/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Provider;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.limewire.core.api.browse.BrowseListener;
import org.limewire.core.settings.SearchSettings;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.AddressFeature;
import org.limewire.friend.api.feature.AuthToken;
import org.limewire.friend.api.feature.AuthTokenFeature;
import org.limewire.friend.api.feature.Feature;
import org.limewire.http.httpclient.SocketWrapperProtocolSocketFactory;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.BlockingConnectObserver;
import org.limewire.net.SocketsManager;
import org.limewire.util.StringUtils;

public class BrowseHostHandler {
    private static final Log LOG = LogFactory.getLog(BrowseHostHandler.class);
    private static final int NOT_STARTED = -1;
    private static final int STARTED = 0;
    private static final int DIRECTLY_CONNECTING = 1;
    private static final int PUSHING = 2;
    private static final int EXCHANGING = 3;
    private static final int FINISHED = 4;
    private static final int CONNECTING = 5;
    static final int DIRECT_CONNECT_TIME = 10000;
    private static final long EXPIRE_TIME = 15000L;
    private GUID _guid = null;
    private volatile long _replyLength = 0L;
    private volatile long _currentLength = 0L;
    private volatile int _state = -1;
    private volatile long _stateStarted = 0L;
    private final SocketsManager socketsManager;
    private final Provider<ForMeReplyHandler> forMeReplyHandler;
    private final MessageFactory messageFactory;
    private final Provider<HttpParams> httpParams;
    private final NetworkManager networkManager;
    private final PushEndpointFactory pushEndpointFactory;

    BrowseHostHandler(GUID sessionGuid, SocketsManager socketsManager, Provider<ForMeReplyHandler> forMeReplyHandler, MessageFactory messageFactory, Provider<HttpParams> httpParams, NetworkManager networkManager, PushEndpointFactory pushEndpointFactory) {
        this._guid = sessionGuid;
        this.socketsManager = socketsManager;
        this.forMeReplyHandler = forMeReplyHandler;
        this.messageFactory = messageFactory;
        this.httpParams = httpParams;
        this.networkManager = networkManager;
        this.pushEndpointFactory = pushEndpointFactory;
    }

    public void browseHost(FriendPresence friendPresence, BrowseListener browseListener) {
        this.setState(0);
        this.setState(5);
        try {
            AddressFeature addressFeature = (AddressFeature)friendPresence.getFeature(AddressFeature.ID);
            if (addressFeature != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("browsing address: " + addressFeature.getFeature());
                }
                Socket socket = this.socketsManager.connect((Address)addressFeature.getFeature(), new BlockingConnectObserver()).getSocket(15000L, TimeUnit.MILLISECONDS);
                this.browseHost(socket, friendPresence);
                browseListener.browseFinished(true);
                return;
            }
        }
        catch (IOException ie) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Error during browse host: " + friendPresence, ie);
            }
        }
        catch (URISyntaxException e) {
            LOG.info("Error during browse host", e);
        }
        catch (HttpException e) {
            LOG.info("Error during browse host", e);
        }
        catch (InterruptedException e) {
            LOG.info("Error during browse host", e);
        }
        catch (TimeoutException e) {
            LOG.info("Error during browse host", e);
        }
        browseListener.browseFinished(false);
        this.failed();
    }

    public double getPercentComplete(long currentTime) {
        switch (this._state) {
            case -1: {
                return 0.0;
            }
            case 0: {
                return 0.0;
            }
            case 1: {
                long elapsed = currentTime - this._stateStarted;
                return (double)elapsed / 10000.0;
            }
            case 2: 
            case 5: {
                long elapsed = currentTime - this._stateStarted;
                return (double)elapsed / 15000.0;
            }
            case 3: {
                if (this._replyLength > 0L) {
                    return (double)this._currentLength / (double)this._replyLength;
                }
                return 0.5;
            }
            case 4: {
                return 1.0;
            }
        }
        throw new IllegalStateException("invalid state");
    }

    private void setState(int state) {
        this._state = state;
        this._stateStarted = System.currentTimeMillis();
    }

    void failed() {
        this.setState(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void browseHost(Socket socket, FriendPresence friendPresence) throws IOException, URISyntaxException, HttpException, InterruptedException {
        try {
            this.setState(3);
            HttpResponse response = this.makeHTTPRequest(socket, friendPresence);
            this.validateResponse(response);
            this.readQueryRepliesFromStream(response, friendPresence);
        }
        finally {
            IOUtils.close(socket);
            this.setState(4);
        }
    }

    private HttpResponse makeHTTPRequest(Socket socket, FriendPresence friendPresence) throws IOException, URISyntaxException, HttpException, InterruptedException {
        SocketWrappingHttpClient client = new SocketWrappingHttpClient(socket);
        if (!friendPresence.getFriend().isAnonymous()) {
            String username = friendPresence.getFriend().getNetwork().getCanonicalizedLocalID();
            Feature feature = friendPresence.getFeature(AuthTokenFeature.ID);
            if (feature != null) {
                AuthTokenFeature authTokenFeature = (AuthTokenFeature)feature;
                String password = StringUtils.toUTF8String(((AuthToken)authTokenFeature.getFeature()).getToken());
                client.setCredentials(new UsernamePasswordCredentials(username, password));
            } else {
                LOG.infof("no auth token for: {0}", (Object)friendPresence);
            }
        }
        HttpGet get = new HttpGet("http://" + NetworkUtils.ip2string(socket.getInetAddress().getAddress()) + ":" + socket.getPort() + this.getPath(friendPresence));
        HttpProtocolParams.setVersion(client.getParams(), HttpVersion.HTTP_1_1);
        get.addHeader(HTTPHeaderName.HOST.create(NetworkUtils.ip2string(socket.getInetAddress().getAddress()) + ":" + socket.getPort()));
        get.addHeader(HTTPHeaderName.USER_AGENT.create(LimeWireUtils.getVendor()));
        get.addHeader(HTTPHeaderName.ACCEPT.create("application/x-gnutella-packets"));
        get.addHeader(HTTPHeaderName.CONNECTION.create("Keep-Alive"));
        if (SearchSettings.DESIRES_NMS1_URNS.getValue()) {
            get.addHeader(HTTPHeaderName.NMS1.create("1"));
        }
        if (!this.networkManager.acceptedIncomingConnection() && this.networkManager.canDoFWT()) {
            get.addHeader(HTTPHeaderName.FW_NODE_INFO.create(this.pushEndpointFactory.createForSelf()));
        }
        return client.execute(get);
    }

    String getPath(FriendPresence friendPresence) {
        if (friendPresence.getFriend().isAnonymous()) {
            return "/";
        }
        try {
            return "/friend/browse/" + URLEncoder.encode(friendPresence.getFriend().getNetwork().getCanonicalizedLocalID(), "UTF-8") + "/";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void validateResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
            throw new IOException("HTTP status code = " + response.getStatusLine().getStatusCode());
        }
        Header contentType = response.getFirstHeader("Content-Type");
        if (contentType != null && StringUtils.indexOfIgnoreCase(contentType.getValue(), "application/x-gnutella-packets", Locale.ENGLISH) < 0) {
            throw new IOException("Unsupported Content-Type: " + contentType.getValue());
        }
        Header contentEncoding = response.getFirstHeader("Content-Encoding");
        if (contentEncoding != null) {
            throw new IOException("Unsupported Content-Encoding: " + contentEncoding.getValue());
        }
        Header contentLength = response.getFirstHeader("Content-Length");
        if (contentLength != null) {
            try {
                this._replyLength = Long.parseLong(contentLength.getValue());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    private void readQueryRepliesFromStream(HttpResponse response, FriendPresence friendPresence) {
        AddressFeature addressFeature = (AddressFeature)friendPresence.getFeature(AddressFeature.ID);
        if (response.getEntity() != null && addressFeature != null) {
            InputStream in;
            Address address = (Address)addressFeature.getFeature();
            try {
                in = response.getEntity().getContent();
            }
            catch (IOException e) {
                LOG.info("Unable to read a single message", e);
                return;
            }
            Message m = null;
            while (true) {
                try {
                    m = null;
                    LOG.debug("reading message");
                    m = this.messageFactory.read(in, Message.Network.TCP);
                }
                catch (BadPacketException bpe) {
                    LOG.debug("BPE while reading", bpe);
                }
                catch (IOException expected) {
                    LOG.debug("IOE while reading", expected);
                }
                if (m == null) {
                    LOG.debug("Unable to read create message");
                    return;
                }
                if (!(m instanceof QueryReply)) continue;
                this._currentLength += (long)m.getTotalLength();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("BHH.browseExchange(): from " + friendPresence + " read QR:" + m);
                }
                QueryReply reply = (QueryReply)m;
                reply.setGUID(this._guid);
                reply.setBrowseHostReply(true);
                this.forMeReplyHandler.get().handleQueryReply(reply, null, address);
            }
        }
    }

    private static SchemeRegistry getSchemeRegistry(Socket socket) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", new SocketWrapperProtocolSocketFactory(socket), 80));
        schemeRegistry.register(new Scheme("tls", new SocketWrapperProtocolSocketFactory(socket), 80));
        schemeRegistry.register(new Scheme("https", new SocketWrapperProtocolSocketFactory(socket), 80));
        return schemeRegistry;
    }

    class SocketWrappingHttpClient
    extends DefaultHttpClient {
        private Credentials credentials;

        SocketWrappingHttpClient(Socket socket) {
            super(new SingleClientConnManager(BrowseHostHandler.getSchemeRegistry(socket)), (HttpParams)BrowseHostHandler.this.httpParams.get());
        }

        void setCredentials(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        protected CredentialsProvider createCredentialsProvider() {
            return new CredentialsProvider(){

                @Override
                public void setCredentials(AuthScope authscope, Credentials credentials) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Credentials getCredentials(AuthScope authscope) {
                    return SocketWrappingHttpClient.this.credentials;
                }

                @Override
                public void clear() {
                    SocketWrappingHttpClient.this.credentials = null;
                }
            };
        }

        @Override
        protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
            return new HttpRequestRetryHandler(){

                @Override
                public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                    return false;
                }
            };
        }
    }

    public static class PushRequestDetails {
        private FriendPresence friendPresence;
        private BrowseHostHandler bhh;
        private long timeStamp;

        public PushRequestDetails(BrowseHostHandler bhh, FriendPresence friendPresence) {
            this.friendPresence = friendPresence;
            this.timeStamp = System.currentTimeMillis();
            this.bhh = bhh;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timeStamp > 15000L;
        }

        public BrowseHostHandler getBrowseHostHandler() {
            return this.bhh;
        }

        public FriendPresence getFriendPresence() {
            return this.friendPresence;
        }
    }
}

