/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.bittorrent.BTDownloadPiecesInfo;
import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.bittorrent.BTUploaderFactory;
import com.limegroup.bittorrent.TorrentUploadManager;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AbstractCoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.serial.BTDownloadMemento;
import com.limegroup.gnutella.downloader.serial.BTMetaInfoMemento;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.LibTorrentBTDownloadMemento;
import com.limegroup.gnutella.downloader.serial.LibTorrentBTDownloadMementoImpl;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.malware.DangerousFileChecker;
import com.limegroup.gnutella.malware.VirusScanException;
import com.limegroup.gnutella.malware.VirusScanner;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentEvent;
import org.limewire.bittorrent.TorrentEventType;
import org.limewire.bittorrent.TorrentFileEntry;
import org.limewire.bittorrent.TorrentInfo;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentParams;
import org.limewire.bittorrent.TorrentPeer;
import org.limewire.bittorrent.TorrentState;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.bittorrent.util.TorrentUtil;
import org.limewire.core.api.download.DownloadPiecesInfo;
import org.limewire.core.api.download.DownloadSourceInfo;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.BittorrentSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.io.Address;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GUID;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPortImpl;
import org.limewire.libtorrent.LibTorrentParams;
import org.limewire.listener.AsynchronousMulticasterImpl;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventMulticaster;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;

public class BTDownloaderImpl
extends AbstractCoreDownloader
implements BTDownloader,
EventListener<TorrentEvent> {
    private static final Log LOG = LogFactory.getLog(BTDownloaderImpl.class);
    @InspectablePrimitive(value="number of torrents started", category=DataCategory.USAGE)
    private static final AtomicInteger torrentsStarted = new AtomicInteger();
    @InspectablePrimitive(value="number of torrents finished", category=DataCategory.USAGE)
    private static final AtomicInteger torrentsFinished = new AtomicInteger();
    private final DownloadManager downloadManager;
    private volatile Torrent torrent;
    private final BTUploaderFactory btUploaderFactory;
    private final AtomicBoolean finishing = new AtomicBoolean(false);
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Library library;
    private final EventMulticaster<DownloadStateEvent> listeners;
    private final AtomicReference<Downloader.DownloadState> lastState = new AtomicReference<Downloader.DownloadState>(Downloader.DownloadState.QUEUED);
    private final FileCollection gnutellaFileCollection;
    private final Provider<TorrentManager> torrentManager;
    private final Provider<TorrentUploadManager> torrentUploadManager;
    private final Provider<DangerousFileChecker> dangerousFileChecker;
    private final Provider<VirusScanner> virusScanner;
    private final Provider<DownloadCallback> downloadCallback;
    private volatile boolean discardUnscannedPreview;
    private volatile URN urn = null;

    @Inject
    BTDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, BTUploaderFactory btUploaderFactory, Library library, @Named(value="fastExecutor") ScheduledExecutorService fastExecutor, @GnutellaFiles FileCollection gnutellaFileCollection, Provider<TorrentManager> torrentManager, Provider<TorrentUploadManager> torrentUploadManager, Provider<DangerousFileChecker> dangerousFileChecker, Provider<VirusScanner> virusScanner, Provider<DownloadCallback> downloadCallback, CategoryManager categoryManager) {
        super(saveLocationManager, categoryManager);
        this.downloadManager = downloadManager;
        this.btUploaderFactory = btUploaderFactory;
        this.library = library;
        this.gnutellaFileCollection = gnutellaFileCollection;
        this.listeners = new AsynchronousMulticasterImpl<DownloadStateEvent>(fastExecutor);
        this.torrentManager = torrentManager;
        this.torrentUploadManager = torrentUploadManager;
        this.dangerousFileChecker = dangerousFileChecker;
        this.virusScanner = virusScanner;
        this.downloadCallback = downloadCallback;
        this.discardUnscannedPreview = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(TorrentEvent event) {
        if (TorrentEventType.COMPLETED == event.getType() && !this.complete.get()) {
            this.finishing.set(true);
            torrentsFinished.incrementAndGet();
            if (this.isInfectedOrDangerous()) {
                return;
            }
            FileUtils.forceDeleteRecursive(this.getSaveFile());
            File completeDir = this.getSaveFile().getParentFile();
            this.torrent.getLock().lock();
            try {
                this.torrent.moveTorrent(completeDir);
                File oldFastResumeFile = this.torrent.getFastResumeFile();
                File oldTorrentFile = this.torrent.getTorrentFile();
                File torrentUploadFolder = BittorrentSettings.TORRENT_UPLOADS_FOLDER.get();
                File newFastResumeFile = new File(torrentUploadFolder, oldFastResumeFile.getName());
                File newTorrentFile = new File(torrentUploadFolder, oldTorrentFile.getName());
                this.torrent.setFastResumeFile(newFastResumeFile);
                this.torrent.setTorrentFile(newTorrentFile);
                FileUtils.copy(oldTorrentFile, newTorrentFile);
                FileUtils.copy(oldFastResumeFile, newFastResumeFile);
                FileUtils.forceDelete(oldTorrentFile);
                FileUtils.forceDelete(oldFastResumeFile);
            }
            finally {
                this.torrent.getLock().unlock();
            }
            this.createUploadMemento();
            this.cleanupPriorityZeroFiles();
            File completeFile = this.getSaveFile();
            this.addFileToCollections(completeFile);
            this.complete.set(true);
            this.deleteIncompleteFiles();
            if (this.lastState.get() != Downloader.DownloadState.SCAN_FAILED && this.lastState.get() != Downloader.DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS) {
                this.lastState.set(Downloader.DownloadState.COMPLETE);
                this.listeners.broadcast(new DownloadStateEvent(this, Downloader.DownloadState.COMPLETE));
            }
            this.downloadManager.remove(this, true);
            this.torrent.removeListener(this);
        } else if (TorrentEventType.STOPPED == event.getType()) {
            this.torrent.removeListener(this);
            if (this.lastState.get() != Downloader.DownloadState.DANGEROUS && this.lastState.get() != Downloader.DownloadState.THREAT_FOUND) {
                this.lastState.set(Downloader.DownloadState.ABORTED);
                this.listeners.broadcast(new DownloadStateEvent(this, Downloader.DownloadState.ABORTED));
            }
            this.downloadManager.remove(this, true);
            this.deleteIncompleteFiles();
        } else if (TorrentEventType.FAST_RESUME_FILE_SAVED != event.getType()) {
            if (TorrentEventType.STARTED == event.getType()) {
                torrentsStarted.incrementAndGet();
            } else {
                Downloader.DownloadState currentState = this.getState();
                if (this.lastState.getAndSet(currentState) != currentState) {
                    this.listeners.broadcast(new DownloadStateEvent(this, currentState));
                }
            }
        }
    }

    private void createUploadMemento() {
        try {
            this.torrentUploadManager.get().writeMemento(this.torrent);
            this.torrent.setAutoManaged(true);
        }
        catch (IOException e) {
            LOG.error("Error saving torrent upload menento for torrent: " + this.torrent.getName(), e);
        }
    }

    private boolean isInfectedOrDangerous() {
        if (this.virusScanner.get().isSupported()) {
            this.lastState.set(Downloader.DownloadState.SCANNING);
            this.listeners.broadcast(new DownloadStateEvent(this, Downloader.DownloadState.SCANNING));
            try {
                if (this.isInfected(this.getIncompleteFile())) {
                    return true;
                }
            }
            catch (VirusScanException e) {
                if (e.getDetail() == VirusScanException.Detail.DOWNLOADING_DEFINITIONS) {
                    this.lastState.set(Downloader.DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS);
                } else {
                    this.lastState.set(Downloader.DownloadState.SCAN_FAILED);
                }
                this.listeners.broadcast(new DownloadStateEvent(this, this.lastState.get()));
            }
        }
        for (File f : this.getIncompleteFiles()) {
            if (!this.isDangerous(f)) continue;
            return true;
        }
        return false;
    }

    private boolean isInfectedOrDangerous(File fragment, Downloader.ScanListener listener) {
        block4: {
            if (this.virusScanner.get().isSupported()) {
                listener.scanStarted();
                try {
                    boolean infected = this.isInfected(fragment);
                    listener.scanStopped();
                    if (infected) {
                        return true;
                    }
                }
                catch (VirusScanException e) {
                    listener.scanStopped();
                    if (!this.promptAboutUnscannedPreview()) break block4;
                    return true;
                }
            }
        }
        return this.isDangerous(fragment);
    }

    private boolean isInfected(File file) throws VirusScanException {
        if (this.virusScanner.get().isSupported() && this.virusScanner.get().isInfected(file)) {
            this.lastState.set(Downloader.DownloadState.THREAT_FOUND);
            this.listeners.broadcast(new DownloadStateEvent(this, Downloader.DownloadState.THREAT_FOUND));
            this.torrent.stop();
            return true;
        }
        return false;
    }

    private boolean isDangerous(File file) {
        if (this.dangerousFileChecker.get().isDangerous(file)) {
            this.lastState.set(Downloader.DownloadState.DANGEROUS);
            this.listeners.broadcast(new DownloadStateEvent(this, Downloader.DownloadState.DANGEROUS));
            this.torrent.stop();
            return true;
        }
        return false;
    }

    private boolean promptAboutUnscannedPreview() {
        this.downloadCallback.get().promptAboutUnscannedPreview(this);
        return this.discardUnscannedPreview;
    }

    @Override
    public void discardUnscannedPreview(boolean delete) {
        this.discardUnscannedPreview = delete;
    }

    private void cleanupPriorityZeroFiles() {
        boolean hasAnyPriorityZero = false;
        List<TorrentFileEntry> fileEntries = this.torrent.getTorrentFileEntries();
        for (TorrentFileEntry fileEntry : fileEntries) {
            if (fileEntry.getPriority() != 0) continue;
            hasAnyPriorityZero = true;
            break;
        }
        if (hasAnyPriorityZero) {
            for (TorrentFileEntry fileEntry : fileEntries) {
                if (fileEntry.getPriority() != 0) continue;
                File torrentDataFile = this.torrent.getTorrentDataFile(fileEntry);
                FileUtils.forceDelete(torrentDataFile);
            }
            FileUtils.deleteEmptyDirectories(this.getSaveFile());
        }
    }

    private void addFileToCollections(File completeFile) {
        if (completeFile.isDirectory()) {
            FileFilter torrentFileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return true;
                }
            };
            this.library.addFolder(completeFile, torrentFileFilter);
            if (!this.torrent.isPrivate() && SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue()) {
                this.gnutellaFileCollection.addFolder(completeFile, torrentFileFilter);
            }
        } else {
            this.library.add(completeFile);
            if (!this.torrent.isPrivate() && SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue()) {
                this.gnutellaFileCollection.add(completeFile);
            }
        }
    }

    @Override
    public void init(TorrentParams params) throws IOException {
        this.torrent = this.torrentManager.get().addTorrent(params);
        if (this.torrent == null) {
            throw new IOException("Error adding torrent to TorrentManager.");
        }
        this.torrent.addListener(this);
        this.setDefaultFileName(this.torrent.getName());
    }

    @Override
    public void stop() {
        if (!this.torrent.isFinished()) {
            this.torrent.stop();
            this.downloadManager.remove(this, true);
        } else {
            this.downloadManager.remove(this, true);
        }
    }

    @Override
    public void pause() {
        this.torrent.pause();
    }

    @Override
    public boolean isPaused() {
        return this.torrent.isPaused();
    }

    @Override
    public boolean isLaunchable() {
        if (this.isCompleted()) {
            return true;
        }
        TorrentInfo torrentInfo = this.torrent.getTorrentInfo();
        return torrentInfo != null && torrentInfo.getTorrentFileEntries().size() <= 1;
    }

    @Override
    public boolean resume() {
        this.torrent.resume();
        return true;
    }

    @Override
    public File getFile() {
        if (this.torrent.isFinished()) {
            return this.getSaveFile();
        }
        return this.getIncompleteFile();
    }

    @Override
    public File getIncompleteFile() {
        return new File(SharingSettings.INCOMPLETE_DIRECTORY.get(), this.torrent.getName());
    }

    @Override
    public File getDownloadFragment(Downloader.ScanListener listener) {
        if (this.isCompleted()) {
            return this.getSaveFile();
        }
        TorrentInfo torrentInfo = this.torrent.getTorrentInfo();
        if (torrentInfo == null || torrentInfo.getTorrentFileEntries().size() > 1) {
            return null;
        }
        File copy = new File(this.getIncompleteFile().getParent(), "Preview-" + this.getIncompleteFile().getName());
        long size = Math.min(this.getIncompleteFile().length(), 0x200000L);
        if (FileUtils.copy(this.getIncompleteFile(), size, copy) <= 0L) {
            return null;
        }
        if (this.isInfectedOrDangerous(copy, listener)) {
            copy.delete();
            return null;
        }
        return copy;
    }

    @Override
    public Downloader.DownloadState getState() {
        switch (this.lastState.get()) {
            case DANGEROUS: {
                return Downloader.DownloadState.DANGEROUS;
            }
            case THREAT_FOUND: {
                return Downloader.DownloadState.THREAT_FOUND;
            }
            case SCAN_FAILED: {
                return Downloader.DownloadState.SCAN_FAILED;
            }
            case SCAN_FAILED_DOWNLOADING_DEFINITIONS: {
                return Downloader.DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS;
            }
            case SCANNING: {
                return Downloader.DownloadState.SCANNING;
            }
        }
        TorrentStatus status = this.torrent.getStatus();
        if (!this.torrent.isStarted() || status == null) {
            return Downloader.DownloadState.QUEUED;
        }
        TorrentState state = status.getState();
        if (this.torrent.isFinished()) {
            return Downloader.DownloadState.COMPLETE;
        }
        if (this.torrent.isCancelled()) {
            return Downloader.DownloadState.ABORTED;
        }
        if (status.isError()) {
            return Downloader.DownloadState.GAVE_UP;
        }
        if (this.finishing.get()) {
            return Downloader.DownloadState.SAVING;
        }
        return this.convertState(state);
    }

    private Downloader.DownloadState convertState(TorrentState state) {
        switch (state) {
            case DOWNLOADING: {
                if (this.isPaused()) {
                    return Downloader.DownloadState.PAUSED;
                }
                return Downloader.DownloadState.DOWNLOADING;
            }
            case QUEUED_FOR_CHECKING: {
                return Downloader.DownloadState.RESUMING;
            }
            case CHECKING_FILES: {
                return Downloader.DownloadState.RESUMING;
            }
            case SEEDING: {
                return Downloader.DownloadState.COMPLETE;
            }
            case FINISHED: {
                return Downloader.DownloadState.COMPLETE;
            }
            case ALLOCATING: {
                return Downloader.DownloadState.CONNECTING;
            }
            case DOWNLOADING_METADATA: {
                return Downloader.DownloadState.INITIALIZING;
            }
        }
        throw new IllegalStateException("Unknown libtorrent state: " + (Object)((Object)state));
    }

    @Override
    public int getRemainingStateTime() {
        return 0;
    }

    @Override
    public long getContentLength() {
        TorrentStatus status = this.torrent.getStatus();
        long contentLength = status != null ? status.getTotalWanted() : -1L;
        return contentLength;
    }

    @Override
    public long getAmountRead() {
        TorrentStatus status = this.torrent.getStatus();
        if (status == null) {
            return -1L;
        }
        return status.getTotalWantedDone();
    }

    @Override
    public long getAmountVerified() {
        TorrentStatus status = this.torrent.getStatus();
        if (status == null) {
            return -1L;
        }
        return status.getTotalWantedDone();
    }

    @Override
    public long getAmountLost() {
        TorrentStatus status = this.torrent.getStatus();
        if (status == null) {
            return -1L;
        }
        return status.getTotalFailedDownload();
    }

    @Override
    public List<RemoteFileDesc> getRemoteFileDescs() {
        return Collections.emptyList();
    }

    @Override
    public int getQueuePosition() {
        return 1;
    }

    @Override
    public int getQueuedHostCount() {
        return 0;
    }

    @Override
    public GUID getQueryGUID() {
        return null;
    }

    @Override
    public boolean isCompleted() {
        return this.complete.get();
    }

    @Override
    public boolean shouldBeRemoved() {
        switch (this.getState()) {
            case DANGEROUS: 
            case THREAT_FOUND: 
            case SCAN_FAILED: 
            case SCAN_FAILED_DOWNLOADING_DEFINITIONS: 
            case ABORTED: 
            case COMPLETE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void measureBandwidth() {
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.torrent.isPaused() ? 0.0f : this.torrent.getDownloadRate() / 1024.0f;
    }

    @Override
    public float getAverageBandwidth() {
        return this.torrent.isPaused() ? 0.0f : this.torrent.getDownloadRate() / 1024.0f;
    }

    @Override
    public boolean isRelocatable() {
        return !this.isCompleted();
    }

    @Override
    protected File getDefaultSaveFile() {
        return new File(SharingSettings.getSaveDirectory(), this.torrent.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URN getSha1Urn() {
        if (this.urn == null) {
            BTDownloaderImpl bTDownloaderImpl = this;
            synchronized (bTDownloaderImpl) {
                if (this.urn == null) {
                    try {
                        this.urn = URN.createSha1UrnFromHex(this.torrent.getSha1());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.urn;
    }

    @Override
    public int getNumHosts() {
        return this.torrent.getNumPeers();
    }

    @Override
    public List<Address> getSourcesAsAddresses() {
        List<TorrentPeer> peers = this.torrent.getTorrentPeers();
        ArrayList<Address> list = new ArrayList<Address>(peers.size());
        for (TorrentPeer peer : peers) {
            String ip = peer.getIPAddress();
            if (ip == null) continue;
            try {
                list.add(new ConnectableImpl(new IpPortImpl(ip), false));
            }
            catch (UnknownHostException e) {}
        }
        return list;
    }

    @Override
    public List<DownloadSourceInfo> getSourcesDetails() {
        List<TorrentPeer> peers = this.torrent.getTorrentPeers();
        ArrayList<DownloadSourceInfo> sourceInfoList = new ArrayList<DownloadSourceInfo>(peers.size());
        for (TorrentPeer peer : peers) {
            sourceInfoList.add(new DownloadSourceInfoAdapter(peer));
        }
        return sourceInfoList;
    }

    @Override
    public DownloadPiecesInfo getPieceInfo() {
        return new BTDownloadPiecesInfo(this.torrent);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void startDownload() {
        this.btUploaderFactory.createBTUploader(this.torrent);
        this.torrent.start();
    }

    @Override
    public void handleInactivity() {
    }

    @Override
    public boolean shouldBeRestarted() {
        return true;
    }

    @Override
    public boolean isAlive() {
        return false;
    }

    @Override
    public boolean isQueuable() {
        return !this.isPaused();
    }

    @Override
    public synchronized void finish() {
        this.deleteIncompleteFiles();
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.BTDOWNLOADER;
    }

    @Override
    protected DownloadMemento createMemento() {
        return new LibTorrentBTDownloadMementoImpl();
    }

    @Override
    protected void fillInMemento(DownloadMemento memento) {
        super.fillInMemento(memento);
        LibTorrentBTDownloadMemento btMemento = (LibTorrentBTDownloadMemento)memento;
        btMemento.setName(this.torrent.getName());
        btMemento.setSha1Urn(this.getSha1Urn());
        btMemento.setIncompleteFile(this.getIncompleteFile());
        btMemento.setTrackerURL(this.torrent.getTrackerURL());
        File fastResumeFile = this.torrent.getFastResumeFile();
        String fastResumePath = fastResumeFile != null ? fastResumeFile.getAbsolutePath() : null;
        btMemento.setFastResumePath(fastResumePath);
        File torrentFile = this.torrent.getTorrentFile();
        String torrentPath = torrentFile != null ? torrentFile.getAbsolutePath() : null;
        btMemento.setTorrentPath(torrentPath);
        btMemento.setPrivate(this.torrent.isPrivate());
    }

    public void initFromCurrentMemento(LibTorrentBTDownloadMemento memento) throws InvalidDataException {
        this.urn = memento.getSha1Urn();
        if (this.urn == null) {
            throw new InvalidDataException("Null SHA1 URN retrieved from LibTorrent torrent momento.");
        }
        if (!this.urn.isSHA1()) {
            throw new InvalidDataException("Non SHA1 URN retrieved from LibTorrent torrent momento.");
        }
        String fastResumePath = memento.getFastResumePath();
        File fastResumeFile = fastResumePath != null ? new File(fastResumePath) : null;
        String torrentPath = memento.getTorrentPath();
        File torrentFile = torrentPath != null ? new File(torrentPath) : null;
        try {
            LibTorrentParams params = new LibTorrentParams(SharingSettings.INCOMPLETE_DIRECTORY.get(), memento.getName(), StringUtils.toHexString(this.urn.getBytes()));
            params.setTrackerURL(memento.getTrackerURL());
            params.setFastResumeFile(fastResumeFile);
            params.setTorrentFile(torrentFile);
            params.setTorrentDataFile(memento.getIncompleteFile());
            params.setPrivate(memento.isPrivate());
            this.init(params);
        }
        catch (IOException e) {
            try {
                LibTorrentParams params = new LibTorrentParams(SharingSettings.INCOMPLETE_DIRECTORY.get(), memento.getName(), StringUtils.toHexString(this.urn.getBytes()));
                params.setTrackerURL(memento.getTrackerURL());
                params.setFastResumeFile(fastResumeFile);
                params.setTorrentDataFile(memento.getIncompleteFile());
                params.setPrivate(memento.isPrivate());
                this.init(params);
            }
            catch (IOException e1) {
                throw new InvalidDataException("Could not initialize the BTDownloader", e1);
            }
        }
    }

    public void initFromOldMemento(BTDownloadMemento memento) throws InvalidDataException {
        BTMetaInfoMemento btmetainfo = memento.getBtMetaInfoMemento();
        URI[] trackers = btmetainfo.getTrackers();
        URI tracker1 = trackers[0];
        String name = btmetainfo.getFileSystem().getName();
        byte[] infoHash = btmetainfo.getInfoHash();
        String sha1 = StringUtils.toHexString(infoHash);
        boolean isPrivate = btmetainfo.isPrivate();
        File saveFile = memento.getSaveFile();
        File saveDir = saveFile == null ? SharingSettings.getSaveDirectory() : saveFile.getParentFile();
        saveDir = saveDir == null ? SharingSettings.getSaveDirectory() : saveDir;
        File oldIncompleteFile = btmetainfo.getFileSystem().getIncompleteFile();
        File newIncompleteFile = new File(SharingSettings.INCOMPLETE_DIRECTORY.get(), name);
        if (newIncompleteFile.exists()) {
            throw new InvalidDataException("Cannot init memento for BTDownloader, incomplete file already exists: " + newIncompleteFile);
        }
        FileUtils.forceRename(oldIncompleteFile, newIncompleteFile);
        File torrentDir = oldIncompleteFile.getParentFile();
        if (torrentDir.getName().length() == 32) {
            FileUtils.forceDeleteRecursive(torrentDir);
        }
        try {
            LibTorrentParams params = new LibTorrentParams(newIncompleteFile.getParentFile(), name, sha1);
            params.setTrackerURL(tracker1.toString());
            params.setTorrentDataFile(newIncompleteFile);
            params.setPrivate(isPrivate);
            this.init(params);
        }
        catch (IOException e) {
            throw new InvalidDataException("Could not initialize the BTDownloader", e);
        }
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento memento) throws InvalidDataException {
        super.initFromMemento(memento);
        if (BTDownloadMemento.class.isInstance(memento)) {
            this.initFromOldMemento((BTDownloadMemento)memento);
        } else if (LibTorrentBTDownloadMemento.class.isInstance(memento)) {
            this.initFromCurrentMemento((LibTorrentBTDownloadMemento)memento);
        }
        if (!this.torrent.isValid()) {
            throw new InvalidDataException("Error registering torrent");
        }
    }

    @Override
    public void addListener(EventListener<DownloadStateEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<DownloadStateEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    @Override
    public void deleteIncompleteFiles() {
        File incompleteFile;
        if (!this.complete.get() && (incompleteFile = this.getIncompleteFile()) != null) {
            FileUtils.forceDeleteRecursive(incompleteFile);
        }
        if (this.torrent.getTorrentFile().getParentFile().equals(SharingSettings.INCOMPLETE_DIRECTORY.get())) {
            FileUtils.forceDelete(this.torrent.getTorrentFile());
        }
        if (this.torrent.getFastResumeFile().getParentFile().equals(SharingSettings.INCOMPLETE_DIRECTORY.get())) {
            FileUtils.forceDelete(this.torrent.getFastResumeFile());
        }
    }

    public List<File> getCompleteFiles() {
        return TorrentUtil.buildTorrentFiles(this.torrent, this.getSaveFile().getParentFile());
    }

    public List<File> getIncompleteFiles() {
        return TorrentUtil.buildTorrentFiles(this.torrent, this.getIncompleteFile().getParentFile());
    }

    @Override
    public boolean conflicts(URN urn, long fileSize, File ... file) {
        if (this.getSha1Urn().equals(urn)) {
            return true;
        }
        for (File f : file) {
            if (!this.conflictsSaveFile(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean conflictsSaveFile(File complete) {
        return complete.equals(this.getSaveFile());
    }

    @Override
    public boolean conflictsWithIncompleteFile(File incomplete) {
        return incomplete.equals(this.getIncompleteFile());
    }

    @Override
    public int getChunkSize() {
        throw new UnsupportedOperationException("BTDownloaderImpl.getChunkSize() not implemented");
    }

    @Override
    public int getAmountPending() {
        throw new UnsupportedOperationException("BTDownloaderImpl.getAmountPending() not implemented");
    }

    @Override
    public File getTorrentFile() {
        return this.torrent.getTorrentFile();
    }

    @Override
    public Torrent getTorrent() {
        return this.torrent;
    }

    private static class DownloadSourceInfoAdapter
    implements DownloadSourceInfo {
        private final TorrentPeer source;

        public DownloadSourceInfoAdapter(TorrentPeer source) {
            this.source = source;
        }

        @Override
        public String getClientName() {
            return this.source.getClientName();
        }

        @Override
        public float getDownloadSpeed() {
            return this.source.getDownloadSpeed();
        }

        @Override
        public String getIPAddress() {
            return this.source.getIPAddress();
        }

        @Override
        public float getUploadSpeed() {
            return this.source.getUploadSpeed();
        }

        @Override
        public boolean isEncyrpted() {
            return this.source.isEncrypted();
        }
    }
}

