/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.internal.ImmutableList;
import com.google.inject.internal.ImmutableMap;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Maps;
import com.google.inject.internal.Preconditions;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.util.Node;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeChecker {
    private final Injector injector;

    public ScopeChecker(Injector injector) {
        this.injector = injector;
    }

    public void check(Class<? extends Annotation> longest, Class<? extends Annotation> nested, Class<? extends Annotation> ... furtherNested) {
        Ranker ranker = new Ranker((Class)longest, (Class)nested, (Class[])furtherNested);
        HashMap<Key<?>, Node> nodes = Maps.newHashMap();
        for (Binding<?> binding : this.injector.getAllBindings().values()) {
            Key<?> key = binding.getKey();
            Node node = this.getNode(nodes, key);
            ranker.rank(binding, node);
            if (binding instanceof ProviderBinding || !(binding instanceof HasDependencies)) continue;
            HasDependencies hasDependencies = (HasDependencies)((Object)binding);
            for (Dependency<?> dependency : hasDependencies.getDependencies()) {
                this.getNode(nodes, dependency.getKey()).addUser(node);
            }
        }
        for (Node node : nodes.values()) {
            node.pushScopeToUsers();
        }
        ArrayList<Message> messages = Lists.newArrayList();
        for (Node node : nodes.values()) {
            if (node.isScopedCorrectly()) continue;
            StringBuilder error = new StringBuilder("Illegal scoped dependency: ").append(node);
            Node dependency = node;
            do {
                dependency = dependency.effectiveScopeDependency();
                error.append("\n  depends on ").append(dependency);
            } while (!dependency.isEffectiveScopeAppliedScope());
            messages.add(new Message(error.toString()));
        }
        if (!messages.isEmpty()) {
            throw new ConfigurationException(messages);
        }
    }

    private Node getNode(Map<Key<?>, Node> nodes, Key<?> key) {
        Node node = nodes.get(key);
        if (node == null) {
            node = new Node(key);
            nodes.put(key, node);
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Ranker
    implements BindingScopingVisitor<Scope> {
        private final ImmutableList<Class<? extends Annotation>> scopeAnnotations;
        private final ImmutableMap<Scope, Integer> scopeToRank;

        private Ranker(Class<? extends Annotation> longest, Class<? extends Annotation> nested, Class<? extends Annotation> ... furtherNested) {
            this.scopeAnnotations = new ImmutableList.Builder<Class<? extends Annotation>>().add(longest).add(nested).addAll(Arrays.asList(furtherNested)).build();
            ImmutableMap.Builder<Scope, Integer> scopeToRankBuilder = ImmutableMap.builder();
            Map<Class<? extends Annotation>, Scope> annotationToScope = ScopeChecker.this.injector.getScopeBindings();
            int i = 0;
            for (Class clazz : this.scopeAnnotations) {
                Scope scope = annotationToScope.get(clazz);
                Preconditions.checkArgument(scope != null, "No scope binding for %s", clazz);
                scopeToRankBuilder.put(scope, i++);
            }
            this.scopeToRank = scopeToRankBuilder.build();
        }

        public void rank(Binding<?> binding, Node node) {
            Scope scope = binding.acceptScopingVisitor(this);
            Integer rank = this.scopeToRank.get(scope);
            if (rank != null) {
                node.setScopeRank(rank, (Class)this.scopeAnnotations.get(rank));
            }
        }

        @Override
        public Scope visitEagerSingleton() {
            return Scopes.SINGLETON;
        }

        @Override
        public Scope visitScope(Scope scope) {
            return scope;
        }

        @Override
        public Scope visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
            throw new AssertionError();
        }

        @Override
        public Scope visitNoScoping() {
            return Scopes.NO_SCOPE;
        }
    }
}

