#!/bin/bash
pkgname=pkgtools

# remove old and get new files
rm -rf pkgtools
wget -m -nH -r -np --cut-dirs=3 -R "=D","=A","index.html","robots*" http://slackware.osuosl.org/slackware-current/source/a/pkgtools/

# set pkgver to the downloaded version
pkgver=`grep VERSION= pkgtools/pkgtools.SlackBuild | sed 's#VERSION=##'`

# create the source archive
tar czf $pkgname-$pkgver.src.tar.gz pkgtools

# change the SLKBUILD
sed -i 's#pkgtools-.*\.src\.tar\.gz#pkgtools-'$pkgver'\.src\.tar\.gz#' SLKBUILD
