/*
 * This code is auto-generated from Wikidata data. Licensed under CC0.
 */


#include "airportdb.h"
#include "airportdb_p.h"
#include "knowledgedb.h"
#include "timezonedb.h"
#include "timezonedb_data_p.h"

#include <limits>

using namespace KItinerary::KnowledgeDb;

namespace KItinerary {
namespace KnowledgeDb {

// airport data sorted by IATA code
// the corresponding index is used to access data the following tables
static constexpr Airport airport_table[] = {
    Airport{IataCode{"AAA"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Anaa Airport
    Airport{IataCode{"AAB"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Arrabury Airport
    Airport{IataCode{"AAC"}, CountryId{"EG"}, Tz::Africa_Cairo}, // El Arish International Airport
    Airport{IataCode{"AAD"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Adado Airport
    Airport{IataCode{"AAE"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Rabah Bitat Airport
    Airport{IataCode{"AAF"}, CountryId{"US"}, Tz::America_New_York}, // Apalachicola Regional Airport
    Airport{IataCode{"AAI"}, CountryId{"BR"}, Tz::America_Araguaina}, // Arraias Airport
    Airport{IataCode{"AAJ"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Cayana Airstrip
    Airport{IataCode{"AAK"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Aranuka Airport
    Airport{IataCode{"AAL"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Aalborg Airport
    Airport{IataCode{"AAM"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Mala Mala Airport
    Airport{IataCode{"AAN"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Al Ain International Airport
    Airport{IataCode{"AAO"}, CountryId{"VE"}, Tz::America_Caracas}, // Anaco Airport
    Airport{IataCode{"AAP"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Samarinda International Airport
    Airport{IataCode{"AAQ"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Anapa Airport
    Airport{IataCode{"AAR"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Aarhus Airport
    Airport{IataCode{"AAS"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Apalapsili Airport
    Airport{IataCode{"AAT"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Altay Airport
    Airport{IataCode{"AAU"}, CountryId{"WS"}, Tz::Pacific_Apia}, // Asau Airport
    Airport{IataCode{"AAV"}, CountryId{"PH"}, Tz::Asia_Manila}, // Allah Valley Airport
    Airport{IataCode{"AAY"}, CountryId{"YE"}, Tz::Asia_Aden}, // Al Ghaydah Airport
    Airport{IataCode{"AAZ"}, CountryId{"GT"}, Tz::America_Guatemala}, // Quetzaltenango Airport
    Airport{IataCode{"ABA"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Abakan International Airport
    Airport{IataCode{"ABB"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Asaba International Airport
    Airport{IataCode{"ABC"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Albacete Airport
    Airport{IataCode{"ABD"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Abadan International Airport
    Airport{IataCode{"ABE"}, CountryId{"US"}, Tz::America_New_York}, // Lehigh Valley International Airport
    Airport{IataCode{"ABF"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Abaiang Atoll Airport
    Airport{IataCode{"ABG"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Abingdon Airport
    Airport{IataCode{"ABH"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Alpha Airport
    Airport{IataCode{"ABI"}, CountryId{"US"}, Tz::America_Chicago}, // Abilene Regional Airport
    Airport{IataCode{"ABJ"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Port Bouet Airport
    Airport{IataCode{"ABK"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Kabri Dar Airport
    Airport{IataCode{"ABL"}, CountryId{"US"}, Tz::America_Anchorage}, // Ambler Airport
    Airport{IataCode{"ABM"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Northern Peninsula Airport
    Airport{IataCode{"ABN"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Albina Airstrip
    Airport{IataCode{"ABO"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Aboisso Airport
    Airport{IataCode{"ABP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Atkamba Airport
    Airport{IataCode{"ABQ"}, CountryId{"US"}, Tz::America_Denver}, // Albuquerque International Sunport
    Airport{IataCode{"ABR"}, CountryId{"US"}, Tz::America_Chicago}, // Aberdeen Regional Airport
    Airport{IataCode{"ABS"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Abu Simbel Airport
    Airport{IataCode{"ABT"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Al-Baha Domestic Airport
    Airport{IataCode{"ABU"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Haliwen Airport
    Airport{IataCode{"ABV"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Nnamdi Azikiwe International Airport
    Airport{IataCode{"ABW"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Abau Airport
    Airport{IataCode{"ABX"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Albury Airport
    Airport{IataCode{"ABY"}, CountryId{"US"}, Tz::America_New_York}, // Southwest Georgia Regional Airport
    Airport{IataCode{"ABZ"}, CountryId{"GB"}, Tz::Europe_London}, // Aberdeen Airport
    Airport{IataCode{"ACA"}, CountryId{"MX"}, Tz::America_Mexico_City}, // General Juan N. Álvarez International Airport
    Airport{IataCode{"ACB"}, CountryId{"US"}, Tz::America_Detroit}, // Antrim County Airport
    Airport{IataCode{"ACC"}, CountryId{"GH"}, Tz::Africa_Accra}, // Kotoka International Airport
    Airport{IataCode{"ACD"}, CountryId{"CO"}, Tz::America_Bogota}, // Alcides Fernández Airport
    Airport{IataCode{"ACE"}, CountryId{"ES"}, Tz::Atlantic_Canary}, // César Manrique Lanzarote Airport
    Airport{IataCode{"ACH"}, CountryId{"CH"}, Tz::Europe_Zurich}, // St. Gallen-Altenrhein Airport
    Airport{IataCode{"ACI"}, CountryId{"GB"}, Tz::Europe_Guernsey}, // Alderney Airport
    Airport{IataCode{"ACK"}, CountryId{"US"}, Tz::America_New_York}, // Nantucket Memorial Airport
    Airport{IataCode{"ACL"}, CountryId{"CO"}, Tz::America_Bogota}, // Aguaclara Airport
    Airport{IataCode{"ACN"}, CountryId{"MX"}, Tz::America_Matamoros}, // Ciudad Acuña International Airport
    Airport{IataCode{"ACP"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Sahand Airport
    Airport{IataCode{"ACR"}, CountryId{"CO"}, Tz::America_Bogota}, // Araracuara Airport
    Airport{IataCode{"ACS"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Achinsk Airport
    Airport{IataCode{"ACT"}, CountryId{"US"}, Tz::America_Chicago}, // Waco Regional Airport
    Airport{IataCode{"ACU"}, CountryId{"PA"}, Tz::America_Panama}, // Achutupo Airport
    Airport{IataCode{"ACV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Arcata-Eureka Airport
    Airport{IataCode{"ACX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xingyi Wanfenglin Airport
    Airport{IataCode{"ACY"}, CountryId{"US"}, Tz::America_New_York}, // Atlantic City International Airport
    Airport{IataCode{"ACZ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Zabol Airport
    Airport{IataCode{"ADA"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Adana Şakirpaşa Airport
    Airport{IataCode{"ADB"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Izmir Adnan Menderes Airport
    Airport{IataCode{"ADC"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Andakombe Airport
    Airport{IataCode{"ADD"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Addis Ababa Bole International Airport
    Airport{IataCode{"ADE"}, CountryId{"YE"}, Tz::Asia_Aden}, // Aden International Airport
    Airport{IataCode{"ADF"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Adıyaman Airport
    Airport{IataCode{"ADG"}, CountryId{"US"}, Tz::America_Detroit}, // Lenawee County Airport
    Airport{IataCode{"ADH"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Aldan Airport
    Airport{IataCode{"ADI"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Arandis Airport
    Airport{IataCode{"ADJ"}, CountryId{"JO"}, Tz::Asia_Amman}, // Amman Civil Airport
    Airport{IataCode{"ADK"}, CountryId{"US"}, Tz::America_Adak}, // Adak Airport
    Airport{IataCode{"ADL"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Adelaide Airport
    Airport{IataCode{"ADM"}, CountryId{"US"}, Tz::America_Chicago}, // Ardmore Municipal Airport
    Airport{IataCode{"ADO"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Andamooka Airport
    Airport{IataCode{"ADP"}, CountryId{"LK"}, Tz::Asia_Colombo}, // SLAF Ampara
    Airport{IataCode{"ADQ"}, CountryId{"US"}, Tz::America_Anchorage}, // Kodiak Airport
    Airport{IataCode{"ADR"}, CountryId{"US"}, Tz::America_New_York}, // Robert F. Swinnie Airport
    Airport{IataCode{"ADS"}, CountryId{"US"}, Tz::America_Chicago}, // Addison Airport
    Airport{IataCode{"ADT"}, CountryId{"US"}, Tz::America_Chicago}, // Ada Municipal Airport
    Airport{IataCode{"ADU"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Ardabil Airport
    Airport{IataCode{"ADV"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Ed Daein Airport
    Airport{IataCode{"ADY"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Alldays Airport
    Airport{IataCode{"ADZ"}, CountryId{"CO"}, Tz::America_Bogota}, // Gustavo Rojas Pinilla International Airport
    Airport{IataCode{"AEA"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Abemama Atoll Airport
    Airport{IataCode{"AEB"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Baise Bama Airport
    Airport{IataCode{"AEG"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Aek Godang Airport
    Airport{IataCode{"AEK"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Aseki Airport
    Airport{IataCode{"AEL"}, CountryId{"US"}, Tz::America_Chicago}, // Albert Lea Municipal Airport
    Airport{IataCode{"AEO"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Aioun el Atrouss Airport
    Airport{IataCode{"AEP"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Aeroparque Jorge Newbery
    Airport{IataCode{"AEQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Ar Horqin Airport
    Airport{IataCode{"AER"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Sochi International Airport
    Airport{IataCode{"AES"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Ålesund Airport, Vigra
    Airport{IataCode{"AET"}, CountryId{"US"}, Tz::America_Anchorage}, // Allakaket Airport
    Airport{IataCode{"AEU"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Abu Musa Airport
    Airport{IataCode{"AEX"}, CountryId{"US"}, Tz::America_Chicago}, // Alexandria International Airport
    Airport{IataCode{"AEY"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Akureyri Airport
    Airport{IataCode{"AFA"}, CountryId{"AR"}, Tz::America_Argentina_Mendoza}, // San Rafael Airport
    Airport{IataCode{"AFD"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Port Alfred Airport
    Airport{IataCode{"AFI"}, CountryId{"CO"}, Tz::America_Bogota}, // Amalfi Airport
    Airport{IataCode{"AFK"}, CountryId{"US"}, Tz::America_Chicago}, // Nebraska City Municipal Airport
    Airport{IataCode{"AFN"}, CountryId{"US"}, Tz::America_New_York}, // Jaffrey Airport – Silver Ranch Airpark
    Airport{IataCode{"AFO"}, CountryId{"US"}, Tz::America_Denver}, // Afton Municipal Airport
    Airport{IataCode{"AFR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Afore Airport
    Airport{IataCode{"AFS"}, CountryId{"UZ"}, Tz::Asia_Samarkand}, // Zarafshan Airport
    Airport{IataCode{"AFT"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Afutara Airport
    Airport{IataCode{"AFW"}, CountryId{"US"}, Tz::America_Chicago}, // Fort Worth Alliance Airport
    Airport{IataCode{"AFY"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Afyon Airport
    Airport{IataCode{"AFZ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Sabzevar Airport
    Airport{IataCode{"AGA"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Agadir–Al Massira Airport
    Airport{IataCode{"AGC"}, CountryId{"US"}, Tz::America_New_York}, // Allegheny County Airport
    Airport{IataCode{"AGD"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Anggi Airport
    Airport{IataCode{"AGF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Agen La Garenne Airport
    Airport{IataCode{"AGI"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Wageningen Airstrip
    Airport{IataCode{"AGJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Aguni Airport
    Airport{IataCode{"AGK"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kagua Airport
    Airport{IataCode{"AGL"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wanigela Airport
    Airport{IataCode{"AGN"}, CountryId{"US"}, Tz::America_Juneau}, // Angoon Seaplane Base
    Airport{IataCode{"AGO"}, CountryId{"US"}, Tz::America_Chicago}, // Magnolia Municipal Airport
    Airport{IataCode{"AGP"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Málaga Airport
    Airport{IataCode{"AGQ"}, CountryId{"GR"}, Tz::Europe_Athens}, // Agrinion Airport
    Airport{IataCode{"AGS"}, CountryId{"US"}, Tz::America_New_York}, // Augusta Regional Airport
    Airport{IataCode{"AGT"}, CountryId{"PY"}, Tz::America_Asuncion}, // Guaraní International Airport
    Airport{IataCode{"AGU"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Lic. Jesús Terán Peredo International Airport
    Airport{IataCode{"AGV"}, CountryId{"VE"}, Tz::America_Caracas}, // Oswaldo Guevara Mujica Airport
    Airport{IataCode{"AGW"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Agnew Airport
    Airport{IataCode{"AGX"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Agatti Aerodrome
    Airport{IataCode{"AGY"}, CountryId{"AU"}, Tz::Australia_Perth}, // Argyle Downs Airport
    Airport{IataCode{"AGZ"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Aggeneys Airport
    Airport{IataCode{"AHB"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Abha Regional Airport
    Airport{IataCode{"AHD"}, CountryId{"US"}, Tz::America_Chicago}, // Ardmore Downtown Executive Airport
    Airport{IataCode{"AHE"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Ahe Airport
    Airport{IataCode{"AHF"}, CountryId{"US"}, Tz::America_Chicago}, // Arapahoe Municipal Airport
    Airport{IataCode{"AHH"}, CountryId{"US"}, Tz::America_Chicago}, // Amery Municipal Airport
    Airport{IataCode{"AHI"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Amahai Airport
    Airport{IataCode{"AHJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Hongyuan Airport
    Airport{IataCode{"AHL"}, CountryId{"GY"}, Tz::America_Guyana}, // Aishalton Airport
    Airport{IataCode{"AHM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Ashland Municipal Airport
    Airport{IataCode{"AHN"}, CountryId{"US"}, Tz::America_New_York}, // Athens Ben Epps Airport
    Airport{IataCode{"AHO"}, CountryId{"IT"}, Tz::Europe_Rome}, // Aeroporto di Alghero-Fertilia
    Airport{IataCode{"AHS"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Ahuas Airport
    Airport{IataCode{"AHU"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Cherif Al Idrissi Airport
    Airport{IataCode{"AHW"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Saih Rawl
    Airport{IataCode{"AIA"}, CountryId{"US"}, Tz::America_Denver}, // Alliance Municipal Airport
    Airport{IataCode{"AIC"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Airok Airport
    Airport{IataCode{"AID"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Anderson Municipal Airport
    Airport{IataCode{"AIE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Aiome Airport
    Airport{IataCode{"AIF"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Assis Airport
    Airport{IataCode{"AIG"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Yalinga Airport
    Airport{IataCode{"AIH"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Aiambak Airport
    Airport{IataCode{"AII"}, CountryId{"DJ"}, Tz::Africa_Djibouti}, // Ali-Sabieh Airport
    Airport{IataCode{"AIK"}, CountryId{"US"}, Tz::America_New_York}, // Aiken Municipal Airport
    Airport{IataCode{"AIM"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Ailuk Airport
    Airport{IataCode{"AIN"}, CountryId{"US"}, Tz::America_Anchorage}, // Wainwright Airport
    Airport{IataCode{"AIO"}, CountryId{"US"}, Tz::America_Chicago}, // Atlantic Municipal Airport
    Airport{IataCode{"AIR"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Aripuanã Airport
    Airport{IataCode{"AIS"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Arorae Island Airport
    Airport{IataCode{"AIT"}, CountryId{"NZ"}, Tz::Pacific_Rarotonga}, // Aitutaki Airport
    Airport{IataCode{"AIU"}, CountryId{"NZ"}, Tz::Pacific_Rarotonga}, // Enua Airport
    Airport{IataCode{"AIV"}, CountryId{"US"}, Tz::America_Chicago}, // George Downer Airport
    Airport{IataCode{"AIZ"}, CountryId{"US"}, Tz::America_Chicago}, // Lee C. Fine Memorial Airport
    Airport{IataCode{"AJA"}, CountryId{"FR"}, Tz::Europe_Paris}, // Ajaccio Napoleon Bonaparte Airport
    Airport{IataCode{"AJF"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Al-Jawf Domestic Airport
    Airport{IataCode{"AJI"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Ağrı Ahmed-i Hani Airport
    Airport{IataCode{"AJJ"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Akjoujt Airport
    Airport{IataCode{"AJK"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Arak Airport
    Airport{IataCode{"AJL"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Lengpui Airport
    Airport{IataCode{"AJN"}, CountryId{"KM"}, Tz::Indian_Comoro}, // Ouani Airport
    Airport{IataCode{"AJR"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Arvidsjaur Airport
    Airport{IataCode{"AJS"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Punta Abreojos Airstrip
    Airport{IataCode{"AJU"}, CountryId{"BR"}, Tz::America_Maceio}, // Santa Maria Airport
    Airport{IataCode{"AJY"}, CountryId{"NE"}, Tz::Africa_Niamey}, // Mano Dayak International Airport
    Airport{IataCode{"AKA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Ankang Wulipu Airport
    Airport{IataCode{"AKB"}, CountryId{"US"}, Tz::America_Adak}, // Atka Airport
    Airport{IataCode{"AKC"}, CountryId{"US"}, Tz::America_New_York}, // Akron Fulton International Airport
    Airport{IataCode{"AKD"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Akola Airport
    Airport{IataCode{"AKE"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Akieni Airport
    Airport{IataCode{"AKF"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Kufra Airport
    Airport{IataCode{"AKG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Anguganak Airport
    Airport{IataCode{"AKI"}, CountryId{"US"}, Tz::America_Anchorage}, // Akiak Airport
    Airport{IataCode{"AKJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Asahikawa Airport
    Airport{IataCode{"AKK"}, CountryId{"US"}, Tz::America_Anchorage}, // Akhiok Airport
    Airport{IataCode{"AKL"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Auckland Airport
    Airport{IataCode{"AKM"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Zakouma Airport
    Airport{IataCode{"AKN"}, CountryId{"US"}, Tz::America_Anchorage}, // King Salmon Airport
    Airport{IataCode{"AKO"}, CountryId{"US"}, Tz::America_Denver}, // Colorado Plains Regional Airport
    Airport{IataCode{"AKP"}, CountryId{"US"}, Tz::America_Anchorage}, // Anaktuvuk Pass Airport
    Airport{IataCode{"AKR"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Akure Airport
    Airport{IataCode{"AKS"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Auki Gwaunaru'u Airport
    Airport{IataCode{"AKU"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Aksu Airport
    Airport{IataCode{"AKV"}, CountryId{"CA"}, Tz::America_Toronto}, // Akulivik Airport
    Airport{IataCode{"AKW"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Aghajari Airport
    Airport{IataCode{"AKX"}, CountryId{"KZ"}, Tz::Asia_Aqtobe}, // Aktobe Airport
    Airport{IataCode{"AKY"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Sittwe Airport
    Airport{IataCode{"ALA"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Almaty International Airport
    Airport{IataCode{"ALB"}, CountryId{"US"}, Tz::America_New_York}, // Albany International Airport
    Airport{IataCode{"ALC"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Alicante Airport
    Airport{IataCode{"ALD"}, CountryId{"PE"}, Tz::America_Lima}, // Alerta Airport
    Airport{IataCode{"ALE"}, CountryId{"US"}, Tz::America_Chicago}, // Alpine-Casparis Municipal Airport
    Airport{IataCode{"ALF"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Alta Airport
    Airport{IataCode{"ALG"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Houari Boumediene Airport
    Airport{IataCode{"ALH"}, CountryId{"AU"}, Tz::Australia_Perth}, // Albany Airport
    Airport{IataCode{"ALI"}, CountryId{"US"}, Tz::America_Chicago}, // Alice International Airport
    Airport{IataCode{"ALJ"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Alexander Bay Airport
    Airport{IataCode{"ALL"}, CountryId{"IT"}, Tz::Europe_Rome}, // Albenga Airport-Riviera Airport
    Airport{IataCode{"ALM"}, CountryId{"US"}, Tz::America_Denver}, // Alamogordo–White Sands Regional Airport
    Airport{IataCode{"ALN"}, CountryId{"US"}, Tz::America_Chicago}, // St. Louis Regional Airport
    Airport{IataCode{"ALO"}, CountryId{"US"}, Tz::America_Chicago}, // Waterloo Regional Airport
    Airport{IataCode{"ALP"}, CountryId{"SY"}, Tz::Asia_Damascus}, // Aleppo International Airport
    Airport{IataCode{"ALQ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Alegrete Airport
    Airport{IataCode{"ALR"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Alexandra Aerodrome
    Airport{IataCode{"ALS"}, CountryId{"US"}, Tz::America_Denver}, // San Luis Valley Regional Airport
    Airport{IataCode{"ALU"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Alula Airport
    Airport{IataCode{"ALW"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Walla Walla Regional Airport
    Airport{IataCode{"ALX"}, CountryId{"US"}, Tz::America_Chicago}, // Thomas C. Russell Field
    Airport{IataCode{"ALY"}, CountryId{"EG"}, Tz::Africa_Cairo}, // El Nouzha Airport
    Airport{IataCode{"ALZ"}, CountryId{"US"}, Tz::America_Anchorage}, // Alitak Seaplane Base
    Airport{IataCode{"AMA"}, CountryId{"US"}, Tz::America_Chicago}, // Rick Husband Amarillo International Airport
    Airport{IataCode{"AMB"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Ambilobe Airport
    Airport{IataCode{"AMC"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Am Timan Airport
    Airport{IataCode{"AMD"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Sardar Vallabhbhai Patel International Airport
    Airport{IataCode{"AMF"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Ama Airport
    Airport{IataCode{"AMH"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Arba Minch Airport
    Airport{IataCode{"AMI"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Selaparang Airport
    Airport{IataCode{"AMK"}, CountryId{"US"}, Tz::America_Denver}, // Animas Air Park
    Airport{IataCode{"AML"}, CountryId{"PA"}, Tz::America_Panama}, // Puerto Armuelles Airport
    Airport{IataCode{"AMM"}, CountryId{"JO"}, Tz::Asia_Amman}, // Queen Alia International Airport
    Airport{IataCode{"AMN"}, CountryId{"US"}, Tz::America_Detroit}, // Gratiot Community Airport
    Airport{IataCode{"AMO"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Mao Airport
    Airport{IataCode{"AMP"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Ampanihy Airport
    Airport{IataCode{"AMQ"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Pattimura Airport
    Airport{IataCode{"AMS"}, CountryId{"NL"}, Tz::Europe_Amsterdam}, // Amsterdam Airport Schiphol
    Airport{IataCode{"AMT"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Amata Airport
    Airport{IataCode{"AMU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Amanab Airport
    Airport{IataCode{"AMV"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Amderma Airport
    Airport{IataCode{"AMW"}, CountryId{"US"}, Tz::America_Chicago}, // Ames Municipal Airport
    Airport{IataCode{"AMZ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Ardmore Airport, New Zealand
    Airport{IataCode{"ANA"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Angama Mara Airport
    Airport{IataCode{"ANB"}, CountryId{"US"}, Tz::America_Chicago}, // Anniston Regional Airport
    Airport{IataCode{"ANC"}, CountryId{"US"}, Tz::America_Anchorage}, // Ted Stevens Anchorage International Airport
    Airport{IataCode{"AND"}, CountryId{"US"}, Tz::America_New_York}, // Anderson Regional Airport
    Airport{IataCode{"ANE"}, CountryId{"FR"}, Tz::Europe_Paris}, // Angers – Loire Airport
    Airport{IataCode{"ANF"}, CountryId{"CL"}, Tz::America_Santiago}, // Andrés Sabella Airport
    Airport{IataCode{"ANG"}, CountryId{"FR"}, Tz::Europe_Paris}, // Angoulême – Brie – Champniers Airport
    Airport{IataCode{"ANI"}, CountryId{"US"}, Tz::America_Anchorage}, // Aniak Airport
    Airport{IataCode{"ANJ"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Zanaga Airport
    Airport{IataCode{"ANL"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Andulo Airport
    Airport{IataCode{"ANM"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Antsirabato Airport
    Airport{IataCode{"ANN"}, CountryId{"US"}, Tz::America_Metlakatla}, // Annette Island Airport
    Airport{IataCode{"ANO"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Angoche Airport
    Airport{IataCode{"ANP"}, CountryId{"US"}, Tz::America_New_York}, // Lee Airport
    Airport{IataCode{"ANQ"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Tri-State Steuben County Airport
    Airport{IataCode{"ANR"}, CountryId{"BE"}, Tz::Europe_Brussels}, // Antwerp International Airport
    Airport{IataCode{"ANS"}, CountryId{"PE"}, Tz::America_Lima}, // Andahuaylas Airport
    Airport{IataCode{"ANV"}, CountryId{"US"}, Tz::America_Anchorage}, // Anvik Airport
    Airport{IataCode{"ANW"}, CountryId{"US"}, Tz::America_Chicago}, // Ainsworth Regional Airport
    Airport{IataCode{"ANX"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Andøya Airport
    Airport{IataCode{"ANY"}, CountryId{"US"}, Tz::America_Chicago}, // Anthony Municipal Airport
    Airport{IataCode{"AOC"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Leipzig-Altenburg Airport
    Airport{IataCode{"AOD"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Abou-Deïa Airport
    Airport{IataCode{"AOE"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Anadolu Airport
    Airport{IataCode{"AOG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Anshan Teng'ao Airport
    Airport{IataCode{"AOH"}, CountryId{"US"}, Tz::America_New_York}, // Lima Allen County Airport
    Airport{IataCode{"AOI"}, CountryId{"IT"}, Tz::Europe_Rome}, // Ancona Falconara Airport
    Airport{IataCode{"AOJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Aomori Airport
    Airport{IataCode{"AOK"}, CountryId{"GR"}, Tz::Europe_Athens}, // Karpathos Island National Airport
    Airport{IataCode{"AOL"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Paso de los Libres Airport
    Airport{IataCode{"AOM"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Adam Airport
    Airport{IataCode{"AOO"}, CountryId{"US"}, Tz::America_New_York}, // Altoona–Blair County Airport
    Airport{IataCode{"AOP"}, CountryId{"PE"}, Tz::America_Lima}, // Alférez FAP Alfredo Vladimir Sara Bauer Airport
    Airport{IataCode{"AOR"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Sultan Abdul Halim Airport
    Airport{IataCode{"AOS"}, CountryId{"US"}, Tz::America_Anchorage}, // Amook Bay Seaplane Base
    Airport{IataCode{"AOT"}, CountryId{"IT"}, Tz::Europe_Rome}, // Aosta Airport
    Airport{IataCode{"AOU"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Attopeu
    Airport{IataCode{"APA"}, CountryId{"US"}, Tz::America_Denver}, // Centennial Airport
    Airport{IataCode{"APB"}, CountryId{"BO"}, Tz::America_La_Paz}, // Apolo Airport
    Airport{IataCode{"APC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Napa County Airport
    Airport{IataCode{"APF"}, CountryId{"US"}, Tz::America_New_York}, // Naples Municipal Airport
    Airport{IataCode{"APK"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Apataki Airport
    Airport{IataCode{"APL"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Nampula Airport
    Airport{IataCode{"APN"}, CountryId{"US"}, Tz::America_Detroit}, // Alpena County Regional Airport
    Airport{IataCode{"APO"}, CountryId{"CO"}, Tz::America_Bogota}, // Antonio Roldán Betancourt Airport
    Airport{IataCode{"APP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Asapa
    Airport{IataCode{"APR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // April River Airport
    Airport{IataCode{"APS"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Anápolis Airport
    Airport{IataCode{"APT"}, CountryId{"US"}, Tz::America_Chicago}, // Marion County Airport
    Airport{IataCode{"APU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Apucarana Airport
    Airport{IataCode{"APV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Apple Valley Airport
    Airport{IataCode{"APW"}, CountryId{"WS"}, Tz::Pacific_Apia}, // Faleolo International Airport
    Airport{IataCode{"APX"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Arapongas Airport
    Airport{IataCode{"APY"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Alto Parnaiba Airport
    Airport{IataCode{"APZ"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Zapala Airport
    Airport{IataCode{"AQA"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Araraquara Airport
    Airport{IataCode{"AQB"}, CountryId{"GT"}, Tz::America_Guatemala}, // Quiché Airport
    Airport{IataCode{"AQG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Anqing Tianzhushan Airport
    Airport{IataCode{"AQI"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Qaisumah Domestic Airport
    Airport{IataCode{"AQJ"}, CountryId{"JO"}, Tz::Asia_Amman}, // King Hussein International Airport
    Airport{IataCode{"AQM"}, CountryId{"BR"}, Tz::America_Porto_Velho}, // Nova Vida Airport
    Airport{IataCode{"AQP"}, CountryId{"PE"}, Tz::America_Lima}, // Rodríguez Ballón International Airport
    Airport{IataCode{"AQY"}, CountryId{"US"}, Tz::America_Anchorage}, // Girdwood Airport
    Airport{IataCode{"ARA"}, CountryId{"US"}, Tz::America_Chicago}, // Acadiana Regional Airport
    Airport{IataCode{"ARB"}, CountryId{"US"}, Tz::America_Detroit}, // Ann Arbor Municipal Airport
    Airport{IataCode{"ARC"}, CountryId{"US"}, Tz::America_Anchorage}, // Arctic Village Airport
    Airport{IataCode{"ARD"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Alor Island Airport
    Airport{IataCode{"ARE"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // Antonio (Nery) Juarbe Pol Airport
    Airport{IataCode{"ARG"}, CountryId{"US"}, Tz::America_Chicago}, // Walnut Ridge Regional Airport
    Airport{IataCode{"ARH"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Talagi Airport
    Airport{IataCode{"ARI"}, CountryId{"CL"}, Tz::America_Santiago}, // Chacalluta International Airport
    Airport{IataCode{"ARJ"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Arso Airport
    Airport{IataCode{"ARK"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Arusha Airport
    Airport{IataCode{"ARL"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Arly Airport
    Airport{IataCode{"ARM"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Armidale Airport
    Airport{IataCode{"ARN"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Stockholm Arlanda Airport
    Airport{IataCode{"ARP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Aragip Airport
    Airport{IataCode{"ARQ"}, CountryId{"CO"}, Tz::America_Bogota}, // Aeropuerto Arsenio Valderrama
    Airport{IataCode{"ARR"}, CountryId{"AR"}, Tz::America_Argentina_Catamarca}, // Casimiro Szlapelis Airport
    Airport{IataCode{"ART"}, CountryId{"US"}, Tz::America_New_York}, // Watertown International Airport
    Airport{IataCode{"ARU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Araçatuba Airport
    Airport{IataCode{"ARV"}, CountryId{"US"}, Tz::America_Chicago}, // Lakeland Airport
    Airport{IataCode{"ARW"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Arad International Airport
    Airport{IataCode{"ARY"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Ararat airport
    Airport{IataCode{"ARZ"}, CountryId{"AO"}, Tz::Africa_Luanda}, // N'zeto Airport
    Airport{IataCode{"ASA"}, CountryId{"ER"}, Tz::Africa_Asmara}, // Assab International Airport
    Airport{IataCode{"ASB"}, CountryId{"TM"}, Tz::Asia_Ashgabat}, // Ashgabat International Airport
    Airport{IataCode{"ASC"}, CountryId{"BO"}, Tz::America_La_Paz}, // Ascencion De Guarayos Airport
    Airport{IataCode{"ASD"}, CountryId{"BS"}, Tz::America_Nassau}, // Andros Town International Airport
    Airport{IataCode{"ASE"}, CountryId{"US"}, Tz::America_Denver}, // Aspen/Pitkin County Airport
    Airport{IataCode{"ASF"}, CountryId{"RU"}, Tz::Europe_Astrakhan}, // Narimanovo Airport
    Airport{IataCode{"ASG"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Ashburton Aerodrome
    Airport{IataCode{"ASH"}, CountryId{"US"}, Tz::America_New_York}, // Nashua Municipal Airport
    Airport{IataCode{"ASJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Amami Airport
    Airport{IataCode{"ASK"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Yamoussoukro Airport
    Airport{IataCode{"ASL"}, CountryId{"US"}, Tz::America_Chicago}, // Harrison County Airport
    Airport{IataCode{"ASM"}, CountryId{"ER"}, Tz::Africa_Asmara}, // Asmara International Airport
    Airport{IataCode{"ASN"}, CountryId{"US"}, Tz::America_Chicago}, // Talladega Municipal Airport
    Airport{IataCode{"ASO"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Asosa Airport
    Airport{IataCode{"ASP"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Alice Springs Airport
    Airport{IataCode{"ASQ"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Austin Airport
    Airport{IataCode{"ASR"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Erkilet International Airport
    Airport{IataCode{"AST"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Astoria Regional Airport
    Airport{IataCode{"ASU"}, CountryId{"PY"}, Tz::America_Asuncion}, // Silvio Pettirossi International Airport
    Airport{IataCode{"ASV"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Amboseli Airport
    Airport{IataCode{"ASW"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Aswan International Airport
    Airport{IataCode{"ASX"}, CountryId{"US"}, Tz::America_Chicago}, // John F. Kennedy Memorial Airport
    Airport{IataCode{"ASY"}, CountryId{"US"}, Tz::America_Chicago}, // Ashley Municipal Airport
    Airport{IataCode{"ASZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Asirim
    Airport{IataCode{"ATA"}, CountryId{"PE"}, Tz::America_Lima}, // Comandante FAP Germán Arias Graziani Airport
    Airport{IataCode{"ATB"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Atbara Airport
    Airport{IataCode{"ATC"}, CountryId{"BS"}, Tz::America_Nassau}, // Arthur's Town Airport
    Airport{IataCode{"ATD"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Uru Harbour Airport
    Airport{IataCode{"ATE"}, CountryId{"US"}, Tz::America_Chicago}, // Antlers Municipal Airport
    Airport{IataCode{"ATF"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Chachoan Airport
    Airport{IataCode{"ATH"}, CountryId{"GR"}, Tz::Europe_Athens}, // Athens International Airport
    Airport{IataCode{"ATI"}, CountryId{"UY"}, Tz::America_Montevideo}, // Artigas Airport
    Airport{IataCode{"ATJ"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Antsirabe Airport
    Airport{IataCode{"ATK"}, CountryId{"US"}, Tz::America_Anchorage}, // Atqasuk Edward Burnell Sr. Memorial Airport
    Airport{IataCode{"ATL"}, CountryId{"US"}, Tz::America_New_York}, // Hartsfield–Jackson Atlanta International Airport
    Airport{IataCode{"ATM"}, CountryId{"BR"}, Tz::America_Santarem}, // Altamira Airport
    Airport{IataCode{"ATN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Namatanai Airport
    Airport{IataCode{"ATO"}, CountryId{"US"}, Tz::America_New_York}, // Ohio University Airport
    Airport{IataCode{"ATP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Aitape Airport
    Airport{IataCode{"ATQ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Sri Guru Ram Dass Jee International Airport
    Airport{IataCode{"ATR"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Atar International Airport
    Airport{IataCode{"ATS"}, CountryId{"US"}, Tz::America_Denver}, // Artesia Municipal Airport
    Airport{IataCode{"ATT"}, CountryId{"US"}, Tz::America_Nome}, // Atmautluak Airport
    Airport{IataCode{"ATV"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Ati Airport
    Airport{IataCode{"ATW"}, CountryId{"US"}, Tz::America_Chicago}, // Appleton International Airport
    Airport{IataCode{"ATX"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Atbasar Airport
    Airport{IataCode{"ATY"}, CountryId{"US"}, Tz::America_Chicago}, // Watertown Regional Airport
    Airport{IataCode{"ATZ"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Assiut Airport
    Airport{IataCode{"AUA"}, CountryId{"NL"}, Tz::America_Aruba}, // Queen Beatrix International Airport
    Airport{IataCode{"AUC"}, CountryId{"CO"}, Tz::America_Bogota}, // Santiago Pérez Quiroz Airport
    Airport{IataCode{"AUE"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Abu Rudeis Airport
    Airport{IataCode{"AUF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Auxerre – Branches Aerodrome
    Airport{IataCode{"AUG"}, CountryId{"US"}, Tz::America_New_York}, // Augusta State Airport
    Airport{IataCode{"AUH"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Abu Dhabi International Airport
    Airport{IataCode{"AUI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Aua Island Airport
    Airport{IataCode{"AUJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Ambunti Airport
    Airport{IataCode{"AUK"}, CountryId{"US"}, Tz::America_Nome}, // Alakanuk Airport
    Airport{IataCode{"AUL"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Aur Airport
    Airport{IataCode{"AUM"}, CountryId{"US"}, Tz::America_Chicago}, // Austin Municipal Airport
    Airport{IataCode{"AUN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Auburn Municipal Airport
    Airport{IataCode{"AUO"}, CountryId{"US"}, Tz::America_Chicago}, // Auburn University Regional Airport
    Airport{IataCode{"AUP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Agaun Airport
    Airport{IataCode{"AUQ"}, CountryId{"FR"}, Tz::Pacific_Marquesas}, // Atuona Airport
    Airport{IataCode{"AUR"}, CountryId{"FR"}, Tz::Europe_Paris}, // Aurillac Airport
    Airport{IataCode{"AUS"}, CountryId{"US"}, Tz::America_Chicago}, // Austin-Bergstrom International Airport
    Airport{IataCode{"AUT"}, CountryId{"TL"}, Tz::Asia_Dili}, // Atauro aerodrome
    Airport{IataCode{"AUU"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Aurukun Airport
    Airport{IataCode{"AUV"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Aumo Airport
    Airport{IataCode{"AUW"}, CountryId{"US"}, Tz::America_Chicago}, // Wausau Downtown Airport
    Airport{IataCode{"AUZ"}, CountryId{"US"}, Tz::America_Chicago}, // Aurora Municipal Airport
    Airport{IataCode{"AVA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Anshun Huangguoshu Airport
    Airport{IataCode{"AVI"}, CountryId{"CU"}, Tz::America_Havana}, // Máximo Gómez Airport
    Airport{IataCode{"AVK"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Arvaikheer Airport
    Airport{IataCode{"AVL"}, CountryId{"US"}, Tz::America_New_York}, // Asheville Regional Airport
    Airport{IataCode{"AVN"}, CountryId{"FR"}, Tz::Europe_Paris}, // Avignon – Caumont Airport
    Airport{IataCode{"AVP"}, CountryId{"US"}, Tz::America_New_York}, // Wilkes-Barre/Scranton International Airport
    Airport{IataCode{"AVU"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Avu Avu Airport
    Airport{IataCode{"AVV"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Avalon Airport
    Airport{IataCode{"AVW"}, CountryId{"US"}, Tz::America_Phoenix}, // Marana Regional Airport
    Airport{IataCode{"AVX"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Catalina Airport
    Airport{IataCode{"AWA"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Awasa Airport
    Airport{IataCode{"AWB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Awaba Airport
    Airport{IataCode{"AWD"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Aniwa Airport
    Airport{IataCode{"AWK"}, CountryId{"US"}, Tz::Pacific_Wake}, // Wake Island Airfield
    Airport{IataCode{"AWM"}, CountryId{"US"}, Tz::America_Chicago}, // West Memphis Municipal Airport
    Airport{IataCode{"AWN"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Alton Downs Airport
    Airport{IataCode{"AWR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Awar Airport
    Airport{IataCode{"AWZ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Ahwaz International Airport
    Airport{IataCode{"AXA"}, CountryId{"GB"}, Tz::America_Anguilla}, // Clayton J. Lloyd International Airport
    Airport{IataCode{"AXB"}, CountryId{"US"}, Tz::America_New_York}, // Maxson Airfield
    Airport{IataCode{"AXC"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Aramac Airport
    Airport{IataCode{"AXD"}, CountryId{"GR"}, Tz::Europe_Athens}, // Alexandroupolis International Airport
    Airport{IataCode{"AXE"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Xanxerê Airport
    Airport{IataCode{"AXF"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Alxa Left Banner Bayanhot Airport
    Airport{IataCode{"AXG"}, CountryId{"US"}, Tz::America_Chicago}, // Algona Municipal Airport
    Airport{IataCode{"AXK"}, CountryId{"YE"}, Tz::Asia_Aden}, // Ataq Airport
    Airport{IataCode{"AXM"}, CountryId{"CO"}, Tz::America_Bogota}, // El Edén International Airport
    Airport{IataCode{"AXN"}, CountryId{"US"}, Tz::America_Chicago}, // Alexandria Municipal Airport
    Airport{IataCode{"AXP"}, CountryId{"BS"}, Tz::America_Nassau}, // Spring Point Airport
    Airport{IataCode{"AXR"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Arutua Airport
    Airport{IataCode{"AXS"}, CountryId{"US"}, Tz::America_Chicago}, // Altus/Quartz Mountain Regional Airport
    Airport{IataCode{"AXT"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Akita Airport
    Airport{IataCode{"AXU"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Axum Airport
    Airport{IataCode{"AXV"}, CountryId{"US"}, Tz::America_New_York}, // Neil Armstrong Airport
    Airport{IataCode{"AYA"}, CountryId{"CO"}, Tz::America_Bogota}, // Ayapel Airport
    Airport{IataCode{"AYG"}, CountryId{"CO"}, Tz::America_Bogota}, // Yaguara Airport
    Airport{IataCode{"AYK"}, CountryId{"KZ"}, Tz::Asia_Qyzylorda}, // Arkalyk Airport
    Airport{IataCode{"AYN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Anyang Yudongbei Airport
    Airport{IataCode{"AYO"}, CountryId{"PY"}, Tz::America_Asuncion}, // Juan de Ayolas Airport
    Airport{IataCode{"AYP"}, CountryId{"PE"}, Tz::America_Lima}, // Coronel FAP Alfredo Mendívil Duarte Airport
    Airport{IataCode{"AYQ"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Ayers Rock Airport
    Airport{IataCode{"AYR"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Ayr Airport
    Airport{IataCode{"AYS"}, CountryId{"US"}, Tz::America_New_York}, // Waycross-Ware County Airport
    Airport{IataCode{"AYT"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Antalya Airport
    Airport{IataCode{"AYU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Aiyura Airport
    Airport{IataCode{"AYW"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Ayawasi Airport
    Airport{IataCode{"AYX"}, CountryId{"PE"}, Tz::America_Lima}, // Tnte. Gral. Gerardo Pérez Pinedo Airport
    Airport{IataCode{"AZA"}, CountryId{"US"}, Tz::America_Phoenix}, // Phoenix–Mesa Gateway Airport
    Airport{IataCode{"AZB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Amazon Bay
    Airport{IataCode{"AZD"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Shahid Sadooghi Airport
    Airport{IataCode{"AZG"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Apatzingan Airport
    Airport{IataCode{"AZI"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Al Bateen Executive Airport
    Airport{IataCode{"AZN"}, CountryId{"UZ"}, Tz::Asia_Tashkent}, // Andizhan Airport
    Airport{IataCode{"AZO"}, CountryId{"US"}, Tz::America_Detroit}, // Kalamazoo/Battle Creek International Airport
    Airport{IataCode{"AZR"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Touat-Cheikh Sidi Mohamed Belkebir Airport
    Airport{IataCode{"AZS"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // Samaná El Catey International Airport
    Airport{IataCode{"AZZ"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Ambriz Airport
    Airport{IataCode{"BAA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bialla Airport
    Airport{IataCode{"BAF"}, CountryId{"US"}, Tz::America_New_York}, // Barnes Municipal Airport
    Airport{IataCode{"BAG"}, CountryId{"PH"}, Tz::Asia_Manila}, // Loakan Airport
    Airport{IataCode{"BAH"}, CountryId{"BH"}, Tz::Asia_Bahrain}, // Bahrain International Airport
    Airport{IataCode{"BAI"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Buenos Aires Airport, Costa Rica
    Airport{IataCode{"BAJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bali
    Airport{IataCode{"BAM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Battle Mountain Airport
    Airport{IataCode{"BAN"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Basongo Airport
    Airport{IataCode{"BAP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Baibara
    Airport{IataCode{"BAQ"}, CountryId{"CO"}, Tz::America_Bogota}, // Ernesto Cortissoz International Airport
    Airport{IataCode{"BAR"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Qionghai Bo'ao Airport
    Airport{IataCode{"BAS"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Balalae Airport
    Airport{IataCode{"BAT"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Barretos Airport
    Airport{IataCode{"BAU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Bauru Airport
    Airport{IataCode{"BAV"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Baotou Erliban Airport
    Airport{IataCode{"BAX"}, CountryId{"RU"}, Tz::Asia_Barnaul}, // Barnaul Airport
    Airport{IataCode{"BAY"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Maramures International Airport
    Airport{IataCode{"BAZ"}, CountryId{"BR"}, Tz::America_Manaus}, // Barcelos Airport
    Airport{IataCode{"BBA"}, CountryId{"CL"}, Tz::America_Santiago}, // Balmaceda Airport
    Airport{IataCode{"BBB"}, CountryId{"US"}, Tz::America_Chicago}, // Benson Municipal Airport
    Airport{IataCode{"BBC"}, CountryId{"US"}, Tz::America_Chicago}, // Bay City Municipal Airport
    Airport{IataCode{"BBD"}, CountryId{"US"}, Tz::America_Chicago}, // Curtis Field
    Airport{IataCode{"BBG"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Butaritari Atoll Airport
    Airport{IataCode{"BBH"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Stralsund Barth Airport
    Airport{IataCode{"BBI"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Biju Patnaik Airport
    Airport{IataCode{"BBK"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Kasane Airport
    Airport{IataCode{"BBL"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Ballera Airport
    Airport{IataCode{"BBM"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Battambang Airport
    Airport{IataCode{"BBN"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Bario Airport
    Airport{IataCode{"BBO"}, CountryId{}, Tz::Africa_Mogadishu}, // Berbera Airport
    Airport{IataCode{"BBQ"}, CountryId{"AG"}, Tz::America_Antigua}, // Codrington Airport
    Airport{IataCode{"BBR"}, CountryId{"FR"}, Tz::America_Guadeloupe}, // Baillif Airport
    Airport{IataCode{"BBS"}, CountryId{"GB"}, Tz::Europe_London}, // Blackbushe Airport
    Airport{IataCode{"BBT"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Berbérati Airport
    Airport{IataCode{"BBU"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Aurel Vlaicu International Airport
    Airport{IataCode{"BBV"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Nero-Mer Airport
    Airport{IataCode{"BBW"}, CountryId{"US"}, Tz::America_Chicago}, // Broken Bow Municipal Airport
    Airport{IataCode{"BBX"}, CountryId{"US"}, Tz::America_New_York}, // Wings Field
    Airport{IataCode{"BBY"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Bambari Airpor
    Airport{IataCode{"BBZ"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Zambezi Airport
    Airport{IataCode{"BCA"}, CountryId{"CU"}, Tz::America_Havana}, // Gustavo Rizo Airport
    Airport{IataCode{"BCB"}, CountryId{"US"}, Tz::America_New_York}, // Virginia Tech Montgomery Executive Airport
    Airport{IataCode{"BCC"}, CountryId{"US"}, Tz::America_Anchorage}, // Bear Creek 3 Airport
    Airport{IataCode{"BCD"}, CountryId{"PH"}, Tz::Asia_Manila}, // Bacolod-Silay International Airport
    Airport{IataCode{"BCE"}, CountryId{"US"}, Tz::America_Denver}, // Bryce Canyon Airport
    Airport{IataCode{"BCF"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Bouca Airport
    Airport{IataCode{"BCH"}, CountryId{"TL"}, Tz::Asia_Dili}, // Baucau Airport
    Airport{IataCode{"BCI"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Barcaldine Airport
    Airport{IataCode{"BCK"}, CountryId{"US"}, Tz::America_Chicago}, // Black River Falls Area Airport
    Airport{IataCode{"BCL"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Barra del Colorado Airport
    Airport{IataCode{"BCM"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Bacău International Airport
    Airport{IataCode{"BCN"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Josep Tarradellas Airport Barcelona-El Prat
    Airport{IataCode{"BCO"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Baco Airport
    Airport{IataCode{"BCQ"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Brak Airport
    Airport{IataCode{"BCR"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Bela Crkva Airport
    Airport{IataCode{"BCS"}, CountryId{"US"}, Tz::America_Chicago}, // Southern Seaplane Airport
    Airport{IataCode{"BCT"}, CountryId{"US"}, Tz::America_New_York}, // Boca Raton Airport
    Airport{IataCode{"BCU"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Bauchi State Airport
    Airport{IataCode{"BCV"}, CountryId{"BZ"}, Tz::America_Belize}, // Hector Silva Airstrip
    Airport{IataCode{"BCW"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Benguera Island Airport
    Airport{IataCode{"BDA"}, CountryId{"GB"}, Tz::Atlantic_Bermuda}, // L.F. Wade International Airport
    Airport{IataCode{"BDB"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Bundaberg Airport
    Airport{IataCode{"BDC"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Barra do Corda Airport
    Airport{IataCode{"BDD"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Badu Island Airport
    Airport{IataCode{"BDE"}, CountryId{"US"}, Tz::America_Chicago}, // Baudette International Airport
    Airport{IataCode{"BDG"}, CountryId{"US"}, Tz::America_Denver}, // Blanding Municipal Airport
    Airport{IataCode{"BDH"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Bandar Lengeh Airport
    Airport{IataCode{"BDJ"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Syamsudin Noor Airport
    Airport{IataCode{"BDK"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Soko Airport
    Airport{IataCode{"BDL"}, CountryId{"US"}, Tz::America_New_York}, // Bradley International Airport
    Airport{IataCode{"BDN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Bend Municipal Airport
    Airport{IataCode{"BDO"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Husein Sastranegara International Airport
    Airport{IataCode{"BDP"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Bhadrapur Airport
    Airport{IataCode{"BDQ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Vadodara Airport
    Airport{IataCode{"BDR"}, CountryId{"US"}, Tz::America_New_York}, // Sikorsky Memorial Airport
    Airport{IataCode{"BDS"}, CountryId{"IT"}, Tz::Europe_Rome}, // Brindisi Airport
    Airport{IataCode{"BDT"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Gbadolite Airport
    Airport{IataCode{"BDU"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Bardufoss Airport
    Airport{IataCode{"BDV"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Moba Airport
    Airport{IataCode{"BDX"}, CountryId{"US"}, Tz::America_Denver}, // Broadus Airport
    Airport{IataCode{"BDY"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Bandon State Airport
    Airport{IataCode{"BDZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Baindoung
    Airport{IataCode{"BEA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bereina Airport
    Airport{IataCode{"BEB"}, CountryId{"GB"}, Tz::Europe_London}, // Benbecula Airport
    Airport{IataCode{"BEC"}, CountryId{"US"}, Tz::America_Chicago}, // Beech Factory Airport
    Airport{IataCode{"BED"}, CountryId{"US"}, Tz::America_New_York}, // Hanscom Field
    Airport{IataCode{"BEF"}, CountryId{"NI"}, Tz::America_Managua}, // Bluefields Airport
    Airport{IataCode{"BEG"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Belgrade Nikola Tesla Airport
    Airport{IataCode{"BEH"}, CountryId{"US"}, Tz::America_Detroit}, // Southwest Michigan Regional Airport
    Airport{IataCode{"BEI"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Beica Airport
    Airport{IataCode{"BEJ"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Kalimarau Airport
    Airport{IataCode{"BEK"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Bareilly Airport
    Airport{IataCode{"BEL"}, CountryId{"BR"}, Tz::America_Belem}, // Val de Cans International Airport
    Airport{IataCode{"BEM"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Beni Mellal Airport
    Airport{IataCode{"BEN"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Benina International Airport
    Airport{IataCode{"BEO"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Belmont Airport
    Airport{IataCode{"BEP"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Bellary Airport
    Airport{IataCode{"BES"}, CountryId{"FR"}, Tz::Europe_Paris}, // Brest Bretagne Airport
    Airport{IataCode{"BET"}, CountryId{"US"}, Tz::America_Anchorage}, // Bethel Airport
    Airport{IataCode{"BEU"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Bedourie Airport
    Airport{IataCode{"BEV"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Be'er Sheva Airport
    Airport{IataCode{"BEW"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Beira Airport
    Airport{IataCode{"BEY"}, CountryId{"LB"}, Tz::Asia_Beirut}, // Beirut–Rafic Hariri International Airport
    Airport{IataCode{"BEZ"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Beru Island Airport
    Airport{IataCode{"BFD"}, CountryId{"US"}, Tz::America_New_York}, // Bradford Regional Airport
    Airport{IataCode{"BFF"}, CountryId{"US"}, Tz::America_Denver}, // Western Nebraska Regional Airport
    Airport{IataCode{"BFG"}, CountryId{"US"}, Tz::America_Denver}, // Bullfrog Basin Airport
    Airport{IataCode{"BFH"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Bacacheri Airport
    Airport{IataCode{"BFI"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Boeing Field
    Airport{IataCode{"BFJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Bijie Feixiong Airport
    Airport{IataCode{"BFK"}, CountryId{"US"}, Tz::America_Chicago}, // Buffalo Municipal Airport
    Airport{IataCode{"BFL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Meadows Field Airport
    Airport{IataCode{"BFM"}, CountryId{"US"}, Tz::America_Chicago}, // Mobile Downtown Airport
    Airport{IataCode{"BFN"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Bloemfontein Airport
    Airport{IataCode{"BFO"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Buffalo Range Airport
    Airport{IataCode{"BFP"}, CountryId{"US"}, Tz::America_New_York}, // Beaver County Airport
    Airport{IataCode{"BFQ"}, CountryId{"PA"}, Tz::America_Panama}, // Bahía Piña Airport
    Airport{IataCode{"BFR"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Virgil I. Grissom Municipal Airport
    Airport{IataCode{"BFS"}, CountryId{"GB"}, Tz::Europe_London}, // Belfast International Airport
    Airport{IataCode{"BFT"}, CountryId{"US"}, Tz::America_New_York}, // Beaufort County Airport
    Airport{IataCode{"BFU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Bengbu Airport
    Airport{IataCode{"BFV"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Buriram Airport
    Airport{IataCode{"BFW"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Sidi Bel Abbes Airport
    Airport{IataCode{"BFX"}, CountryId{"CM"}, Tz::Africa_Douala}, // Bafoussam Airport
    Airport{IataCode{"BGA"}, CountryId{"CO"}, Tz::America_Bogota}, // Palonegro International Airport
    Airport{IataCode{"BGB"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Booue Airport
    Airport{IataCode{"BGC"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Bragança Airport
    Airport{IataCode{"BGD"}, CountryId{"US"}, Tz::America_Chicago}, // Hutchinson County Airport
    Airport{IataCode{"BGE"}, CountryId{"US"}, Tz::America_New_York}, // Decatur County Industrial Air Park
    Airport{IataCode{"BGF"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Bangui M'Poko International Airport
    Airport{IataCode{"BGG"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Bingöl Airport
    Airport{IataCode{"BGH"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Abbaye Airport
    Airport{IataCode{"BGI"}, CountryId{"BB"}, Tz::America_Barbados}, // Grantley Adams International Airport
    Airport{IataCode{"BGK"}, CountryId{"BZ"}, Tz::America_Belize}, // Big Creek Airport
    Airport{IataCode{"BGL"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Baglung Airport
    Airport{IataCode{"BGM"}, CountryId{"US"}, Tz::America_New_York}, // Greater Binghamton Airport
    Airport{IataCode{"BGN"}, CountryId{"RU"}, Tz::Asia_Srednekolymsk}, // Belaya Gora Airport
    Airport{IataCode{"BGO"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Bergen Airport
    Airport{IataCode{"BGQ"}, CountryId{"US"}, Tz::America_Anchorage}, // Big Lake Airport
    Airport{IataCode{"BGR"}, CountryId{"US"}, Tz::America_New_York}, // Bangor International Airport
    Airport{IataCode{"BGT"}, CountryId{"US"}, Tz::America_Phoenix}, // Bagdad Airport
    Airport{IataCode{"BGU"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Bangassou Airport
    Airport{IataCode{"BGW"}, CountryId{"IQ"}, Tz::Asia_Baghdad}, // Baghdad International Airport
    Airport{IataCode{"BGX"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Comandante Gustavo Kraemer Airport
    Airport{IataCode{"BGY"}, CountryId{"IT"}, Tz::Europe_Rome}, // Il Caravaggio International Airport
    Airport{IataCode{"BGZ"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Braga Airport
    Airport{IataCode{"BHA"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Aeropuerto Los Perales
    Airport{IataCode{"BHB"}, CountryId{"US"}, Tz::America_New_York}, // Hancock County-Bar Harbor Airport
    Airport{IataCode{"BHD"}, CountryId{"GB"}, Tz::Europe_London}, // George Best Belfast City Airport
    Airport{IataCode{"BHE"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Woodbourne Airport
    Airport{IataCode{"BHG"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Brus Laguna Airport
    Airport{IataCode{"BHH"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Bisha Domestic Airport
    Airport{IataCode{"BHI"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Comandante Espora Airport
    Airport{IataCode{"BHJ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Bhuj Airport
    Airport{IataCode{"BHK"}, CountryId{"UZ"}, Tz::Asia_Samarkand}, // Bukhara International Airport
    Airport{IataCode{"BHM"}, CountryId{"US"}, Tz::America_Chicago}, // Birmingham-Shuttlesworth International Airport
    Airport{IataCode{"BHN"}, CountryId{"YE"}, Tz::Asia_Aden}, // Beihan Airport
    Airport{IataCode{"BHO"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Raja Bhoj Airport
    Airport{IataCode{"BHP"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Bhojpur Airport
    Airport{IataCode{"BHQ"}, CountryId{"AU"}, Tz::Australia_Broken_Hill}, // Broken Hill Airport
    Airport{IataCode{"BHR"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Bharatpur Airport
    Airport{IataCode{"BHS"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Bathurst Airport
    Airport{IataCode{"BHU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Bhavnagar Airport
    Airport{IataCode{"BHV"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Bahawalpur Airport
    Airport{IataCode{"BHX"}, CountryId{"GB"}, Tz::Europe_London}, // Birmingham Airport
    Airport{IataCode{"BHY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Beihai Fucheng Airport
    Airport{IataCode{"BIA"}, CountryId{"FR"}, Tz::Europe_Paris}, // Bastia – Poretta Airport
    Airport{IataCode{"BIB"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Baidoa Airport
    Airport{IataCode{"BID"}, CountryId{"US"}, Tz::America_New_York}, // Block Island State Airport
    Airport{IataCode{"BII"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Bikini Atoll Airport
    Airport{IataCode{"BIJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Biliau
    Airport{IataCode{"BIK"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Frans Kaisiepo Airport
    Airport{IataCode{"BIL"}, CountryId{"US"}, Tz::America_Denver}, // Billings Logan International Airport
    Airport{IataCode{"BIM"}, CountryId{"BS"}, Tz::America_Nassau}, // South Bimini Airport
    Airport{IataCode{"BIN"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Bamyan Airport
    Airport{IataCode{"BIO"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Bilbao Airport
    Airport{IataCode{"BIQ"}, CountryId{"FR"}, Tz::Europe_Paris}, // Biarritz – Anglet – Bayonne Airport
    Airport{IataCode{"BIR"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Biratnagar Airport
    Airport{IataCode{"BIS"}, CountryId{"US"}, Tz::America_Chicago}, // Bismarck Municipal Airport
    Airport{IataCode{"BIT"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Baitadi Airport
    Airport{IataCode{"BIU"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Bíldudalur Airport
    Airport{IataCode{"BIV"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Bria Airport
    Airport{IataCode{"BIY"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Bisho Airport
    Airport{IataCode{"BJA"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Soummam – Abane Ramdane Airport
    Airport{IataCode{"BJB"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Bojnord Airport
    Airport{IataCode{"BJC"}, CountryId{"US"}, Tz::America_Denver}, // Rocky Mountain Metropolitan Airport
    Airport{IataCode{"BJD"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Bakkafjörður Airport
    Airport{IataCode{"BJF"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Båtsfjord Airport
    Airport{IataCode{"BJG"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Bolaang Airport
    Airport{IataCode{"BJH"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Bajhang Airport
    Airport{IataCode{"BJI"}, CountryId{"US"}, Tz::America_Chicago}, // Bemidji Regional Airport
    Airport{IataCode{"BJJ"}, CountryId{"US"}, Tz::America_New_York}, // Wayne County Airport
    Airport{IataCode{"BJK"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Benjina Airport
    Airport{IataCode{"BJL"}, CountryId{"GM"}, Tz::Africa_Banjul}, // Banjul International Airport
    Airport{IataCode{"BJM"}, CountryId{"BI"}, Tz::Africa_Bujumbura}, // Bujumbura International Airport
    Airport{IataCode{"BJO"}, CountryId{"BO"}, Tz::America_La_Paz}, // Bermejo Airport
    Airport{IataCode{"BJP"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Bragança Paulista Airport
    Airport{IataCode{"BJR"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Bahir Dar Airport
    Airport{IataCode{"BJT"}, CountryId{"LK"}, Tz::Asia_Colombo}, // Bentota River Airport
    Airport{IataCode{"BJU"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Bajura Airport
    Airport{IataCode{"BJV"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Milas-Bodrum Airport
    Airport{IataCode{"BJW"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Bajawa Soa Airport
    Airport{IataCode{"BJX"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Del Bajío International Airport
    Airport{IataCode{"BJZ"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Badajoz Airport
    Airport{IataCode{"BKB"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Nal Airport
    Airport{IataCode{"BKC"}, CountryId{"US"}, Tz::America_Anchorage}, // Buckland Airport
    Airport{IataCode{"BKE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Baker City Municipal Airport
    Airport{IataCode{"BKF"}, CountryId{"US"}, Tz::America_Anchorage}, // Lake Brooks Seaplane Base
    Airport{IataCode{"BKG"}, CountryId{"US"}, Tz::America_Chicago}, // Branson Airport
    Airport{IataCode{"BKI"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Kota Kinabalu International Airport
    Airport{IataCode{"BKJ"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Boké Baralande Airport
    Airport{IataCode{"BKK"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Suvarnabhumi Airport
    Airport{IataCode{"BKL"}, CountryId{"US"}, Tz::America_New_York}, // Cleveland Burke Lakefront Airport
    Airport{IataCode{"BKM"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Ba'kelalan Airport
    Airport{IataCode{"BKN"}, CountryId{"TM"}, Tz::Asia_Ashgabat}, // Balkanabat Airport
    Airport{IataCode{"BKO"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Bamako-Sénou International Airport
    Airport{IataCode{"BKQ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Blackall Airport
    Airport{IataCode{"BKR"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Bokoro Airport
    Airport{IataCode{"BKS"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Fatmawati Soekarno Airport
    Airport{IataCode{"BKW"}, CountryId{"US"}, Tz::America_New_York}, // Raleigh County Memorial Airport
    Airport{IataCode{"BKX"}, CountryId{"US"}, Tz::America_Chicago}, // Brookings Regional Airport
    Airport{IataCode{"BKY"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kavumu Airport
    Airport{IataCode{"BKZ"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Bukoba Airport
    Airport{IataCode{"BLA"}, CountryId{"VE"}, Tz::America_Caracas}, // General José Antonio Anzoátegui International Airport
    Airport{IataCode{"BLB"}, CountryId{"PA"}, Tz::America_Panama}, // Panamá Pacífico International Airport
    Airport{IataCode{"BLC"}, CountryId{"CM"}, Tz::Africa_Douala}, // Bali Airport
    Airport{IataCode{"BLD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Boulder City Municipal Airport
    Airport{IataCode{"BLE"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Dala Airport
    Airport{IataCode{"BLF"}, CountryId{"US"}, Tz::America_New_York}, // Mercer County Airport
    Airport{IataCode{"BLG"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Belaga Airport
    Airport{IataCode{"BLH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Blythe Airport
    Airport{IataCode{"BLJ"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Mostépha Ben Boulaid Airport
    Airport{IataCode{"BLK"}, CountryId{"GB"}, Tz::Europe_London}, // Blackpool Airport
    Airport{IataCode{"BLL"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Billund Airport
    Airport{IataCode{"BLM"}, CountryId{"US"}, Tz::America_New_York}, // Monmouth Executive Airport
    Airport{IataCode{"BLN"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Benalla Airport
    Airport{IataCode{"BLO"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Blönduós Airport
    Airport{IataCode{"BLQ"}, CountryId{"IT"}, Tz::Europe_Rome}, // Bologna Guglielmo Marconi Airport
    Airport{IataCode{"BLR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kempegowda International Airport
    Airport{IataCode{"BLT"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Blackwater Airport
    Airport{IataCode{"BLU"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Blue Canyon–Nyack Airport
    Airport{IataCode{"BLX"}, CountryId{"IT"}, Tz::Europe_Rome}, // Belluno Airport
    Airport{IataCode{"BLY"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Belmullet Aerodrome
    Airport{IataCode{"BLZ"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Chileka International Airport
    Airport{IataCode{"BMA"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Stockholm Bromma Airport
    Airport{IataCode{"BMB"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Bumba Airport
    Airport{IataCode{"BMC"}, CountryId{"US"}, Tz::America_Denver}, // Brigham City Airport
    Airport{IataCode{"BMD"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Belo sur Tsiribihina Airport
    Airport{IataCode{"BME"}, CountryId{"AU"}, Tz::Australia_Perth}, // Broome International Airport
    Airport{IataCode{"BMF"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Bakouma Airport
    Airport{IataCode{"BMG"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Monroe County Airport
    Airport{IataCode{"BMH"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bomai
    Airport{IataCode{"BMI"}, CountryId{"US"}, Tz::America_Chicago}, // Central Illinois Regional Airport
    Airport{IataCode{"BMJ"}, CountryId{"GY"}, Tz::America_Guyana}, // Baramita Airport
    Airport{IataCode{"BML"}, CountryId{"US"}, Tz::America_New_York}, // Berlin Regional Airport
    Airport{IataCode{"BMM"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Bitam Airport
    Airport{IataCode{"BMO"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Bhamo Airport
    Airport{IataCode{"BMP"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Berhampur Airport
    Airport{IataCode{"BMQ"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Bamburi Airport
    Airport{IataCode{"BMT"}, CountryId{"US"}, Tz::America_Chicago}, // Beaumont Municipal Airport
    Airport{IataCode{"BMU"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Bima Airport
    Airport{IataCode{"BMV"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Buon Ma Thuot Airport
    Airport{IataCode{"BMW"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Bordj Mokhtar Airport
    Airport{IataCode{"BMY"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Île Art – Waala Airport
    Airport{IataCode{"BMZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bamu
    Airport{IataCode{"BNA"}, CountryId{"US"}, Tz::America_Chicago}, // Nashville International Airport
    Airport{IataCode{"BNB"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Boende Airport
    Airport{IataCode{"BND"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Bandar Abbas International Airport
    Airport{IataCode{"BNE"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Brisbane Airport
    Airport{IataCode{"BNG"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Banning Municipal Airport
    Airport{IataCode{"BNI"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Benin Airport
    Airport{IataCode{"BNK"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Ballina Byron Gateway Airport
    Airport{IataCode{"BNL"}, CountryId{"US"}, Tz::America_New_York}, // Barnwell Regional Airport
    Airport{IataCode{"BNN"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Brønnøysund Airport, Brønnøy
    Airport{IataCode{"BNO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Burns Municipal Airport
    Airport{IataCode{"BNP"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Bannu Airport
    Airport{IataCode{"BNR"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Banfora Airport
    Airport{IataCode{"BNS"}, CountryId{"VE"}, Tz::America_Caracas}, // Barinas Airport
    Airport{IataCode{"BNU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Blumenau Airport
    Airport{IataCode{"BNW"}, CountryId{"US"}, Tz::America_Chicago}, // Boone Municipal Airport
    Airport{IataCode{"BNX"}, CountryId{"BA"}, Tz::Europe_Sarajevo}, // Banja Luka International Airport
    Airport{IataCode{"BNY"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Bellona/Anua Airport
    Airport{IataCode{"BNZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Banz Airport
    Airport{IataCode{"BOA"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Boma Airport
    Airport{IataCode{"BOB"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Bora Bora Airport
    Airport{IataCode{"BOC"}, CountryId{"PA"}, Tz::America_Panama}, // Bocas del Toro "Isla Colón" International Airport
    Airport{IataCode{"BOD"}, CountryId{"FR"}, Tz::Europe_Paris}, // Bordeaux–Mérignac Airport
    Airport{IataCode{"BOE"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Boundji Airport
    Airport{IataCode{"BOG"}, CountryId{"CO"}, Tz::America_Bogota}, // El Dorado International Airport
    Airport{IataCode{"BOH"}, CountryId{"GB"}, Tz::Europe_London}, // Bournemouth Airport
    Airport{IataCode{"BOI"}, CountryId{"US"}, Tz::America_Boise}, // Boise Airport
    Airport{IataCode{"BOJ"}, CountryId{"BG"}, Tz::Europe_Sofia}, // Burgas Airport
    Airport{IataCode{"BOK"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Brookings Airport
    Airport{IataCode{"BOL"}, CountryId{"GB"}, Tz::Europe_London}, // Ballykelly Airport
    Airport{IataCode{"BOM"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Chhatrapati Shivaji International Airport
    Airport{IataCode{"BON"}, CountryId{"NL"}, Tz::America_Kralendijk}, // Flamingo International Airport
    Airport{IataCode{"BOO"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Bodø Airport
    Airport{IataCode{"BOP"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Bouar Airport
    Airport{IataCode{"BOQ"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Boku Airport
    Airport{IataCode{"BOS"}, CountryId{"US"}, Tz::America_New_York}, // Logan International Airport
    Airport{IataCode{"BOT"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bosset Airport
    Airport{IataCode{"BOV"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Boang
    Airport{IataCode{"BOX"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Borroloola Airport
    Airport{IataCode{"BOY"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Bobo Dioulasso Airport
    Airport{IataCode{"BOZ"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Bozoum Airport
    Airport{IataCode{"BPC"}, CountryId{"CM"}, Tz::Africa_Douala}, // Bamenda Airport
    Airport{IataCode{"BPD"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bapi
    Airport{IataCode{"BPE"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Qinhuangdao Beidaihe Airport
    Airport{IataCode{"BPF"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Batuna Airport
    Airport{IataCode{"BPG"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Barra do Garças Airport
    Airport{IataCode{"BPH"}, CountryId{"PH"}, Tz::Asia_Manila}, // Bislig Airport
    Airport{IataCode{"BPI"}, CountryId{"US"}, Tz::America_Denver}, // Miley Memorial Field
    Airport{IataCode{"BPK"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Biangabip Airport
    Airport{IataCode{"BPL"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Bole Alashankou Airport
    Airport{IataCode{"BPM"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Begumpet Airport
    Airport{IataCode{"BPN"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Sultan Aji Muhammad Sulaiman Airport
    Airport{IataCode{"BPS"}, CountryId{"BR"}, Tz::America_Bahia}, // Porto Seguro Airport
    Airport{IataCode{"BPT"}, CountryId{"US"}, Tz::America_Chicago}, // Jack Brooks Regional Airport
    Airport{IataCode{"BPX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Qamdo Bamda Airport
    Airport{IataCode{"BPY"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Besalampy Airport
    Airport{IataCode{"BQA"}, CountryId{"PH"}, Tz::Asia_Manila}, // Dr. Juan C. Angara Airport
    Airport{IataCode{"BQB"}, CountryId{"AU"}, Tz::Australia_Perth}, // Busselton Margaret River Airport
    Airport{IataCode{"BQE"}, CountryId{"GW"}, Tz::Africa_Bissau}, // Bubaque Airport
    Airport{IataCode{"BQG"}, CountryId{"RU"}, Tz::Asia_Vladivostok}, // Bogorodskoye Airport
    Airport{IataCode{"BQH"}, CountryId{"GB"}, Tz::Europe_London}, // London Biggin Hill Airport
    Airport{IataCode{"BQJ"}, CountryId{"RU"}, Tz::Asia_Vladivostok}, // Batagay Airport
    Airport{IataCode{"BQK"}, CountryId{"US"}, Tz::America_New_York}, // Brunswick Golden Isles Airport
    Airport{IataCode{"BQL"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Boulia Airport
    Airport{IataCode{"BQN"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // Rafael Hernández Airport
    Airport{IataCode{"BQO"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Tehini Airport
    Airport{IataCode{"BQS"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Ignatyevo Airport
    Airport{IataCode{"BQT"}, CountryId{"BY"}, Tz::Europe_Minsk}, // Brest Airport
    Airport{IataCode{"BQU"}, CountryId{"VC"}, Tz::America_St_Vincent}, // J. F. Mitchell Airport
    Airport{IataCode{"BQW"}, CountryId{"AU"}, Tz::Australia_Perth}, // Balgo Hill Airport
    Airport{IataCode{"BRA"}, CountryId{"BR"}, Tz::America_Bahia}, // Barreiras Airport
    Airport{IataCode{"BRB"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Barreirinhas Airport
    Airport{IataCode{"BRC"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // San Carlos de Bariloche Airport
    Airport{IataCode{"BRD"}, CountryId{"US"}, Tz::America_Chicago}, // Brainerd Lakes Regional Airport
    Airport{IataCode{"BRE"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Bremen Airport
    Airport{IataCode{"BRI"}, CountryId{"IT"}, Tz::Europe_Rome}, // Bari Karol Wojtyła Airport
    Airport{IataCode{"BRK"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Bourke Airport
    Airport{IataCode{"BRL"}, CountryId{"US"}, Tz::America_Chicago}, // Southeast Iowa Regional Airport
    Airport{IataCode{"BRM"}, CountryId{"VE"}, Tz::America_Caracas}, // Jacinto Lara International Airport
    Airport{IataCode{"BRN"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Bern Airport
    Airport{IataCode{"BRO"}, CountryId{"US"}, Tz::America_Chicago}, // Brownsville/South Padre Island International Airport
    Airport{IataCode{"BRP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Biaru
    Airport{IataCode{"BRQ"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Brno-Tuřany Airport
    Airport{IataCode{"BRS"}, CountryId{"GB"}, Tz::Europe_London}, // Bristol Airport
    Airport{IataCode{"BRT"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Bathurst Island Airport
    Airport{IataCode{"BRU"}, CountryId{"BE"}, Tz::Europe_Brussels}, // Brussels Airport
    Airport{IataCode{"BRW"}, CountryId{"US"}, Tz::America_Anchorage}, // Wiley Post–Will Rogers Memorial Airport
    Airport{IataCode{"BRX"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // María Montez International Airport
    Airport{IataCode{"BRY"}, CountryId{"US"}, Tz::America_New_York}, // Samuels Field
    Airport{IataCode{"BSA"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Bender Qassim International Airport
    Airport{IataCode{"BSB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Brasília International Airport
    Airport{IataCode{"BSC"}, CountryId{"CO"}, Tz::America_Bogota}, // José Celestino Mutis Airport
    Airport{IataCode{"BSD"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Baoshan Yunduan Airport
    Airport{IataCode{"BSE"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Sematan Airport
    Airport{IataCode{"BSG"}, CountryId{"GQ"}, Tz::Africa_Malabo}, // Bata Airport
    Airport{IataCode{"BSJ"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Bairnsdale Airport
    Airport{IataCode{"BSK"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Biskra Airport
    Airport{IataCode{"BSL"}, CountryId{"FR"}, Tz::Europe_Paris}, // EuroAirport Basel-Mulhouse-Freiburg
    Airport{IataCode{"BSN"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Bossangoa Airport
    Airport{IataCode{"BSO"}, CountryId{"PH"}, Tz::Asia_Manila}, // Basco Airport
    Airport{IataCode{"BSP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bensbach Airport
    Airport{IataCode{"BSQ"}, CountryId{"US"}, Tz::America_Phoenix}, // Bisbee Municipal Airport
    Airport{IataCode{"BSR"}, CountryId{"IQ"}, Tz::Asia_Baghdad}, // Basra International Airport
    Airport{IataCode{"BSS"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Balsas Airport
    Airport{IataCode{"BST"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Bost Airport
    Airport{IataCode{"BSU"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Basankusu Airport
    Airport{IataCode{"BSW"}, CountryId{"US"}, Tz::America_Anchorage}, // Boswell Bay Airport
    Airport{IataCode{"BSX"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Pathein Airport
    Airport{IataCode{"BSY"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Bardera Airport
    Airport{IataCode{"BTA"}, CountryId{"CM"}, Tz::Africa_Douala}, // Bertoua Airport
    Airport{IataCode{"BTB"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Bétou Airport
    Airport{IataCode{"BTF"}, CountryId{"US"}, Tz::America_Denver}, // Skypark Airport
    Airport{IataCode{"BTG"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Batangafo Airport
    Airport{IataCode{"BTH"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Hang Nadim Airport
    Airport{IataCode{"BTI"}, CountryId{"US"}, Tz::America_Anchorage}, // Barter Island LRRS Airport
    Airport{IataCode{"BTJ"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Sultan Iskandar Muda Airport
    Airport{IataCode{"BTK"}, CountryId{"RU"}, Tz::Asia_Irkutsk}, // Bratsk Airport
    Airport{IataCode{"BTL"}, CountryId{"US"}, Tz::America_Detroit}, // W. K. Kellogg Airport
    Airport{IataCode{"BTM"}, CountryId{"US"}, Tz::America_Denver}, // Bert Mooney Airport
    Airport{IataCode{"BTN"}, CountryId{"US"}, Tz::America_New_York}, // Marlboro County Jetport
    Airport{IataCode{"BTO"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Botopassi Airstrip
    Airport{IataCode{"BTP"}, CountryId{"US"}, Tz::America_New_York}, // Butler County Airport
    Airport{IataCode{"BTQ"}, CountryId{"RW"}, Tz::Africa_Kigali}, // Butare Airport
    Airport{IataCode{"BTR"}, CountryId{"US"}, Tz::America_Chicago}, // Baton Rouge Metropolitan Airport
    Airport{IataCode{"BTS"}, CountryId{"SK"}, Tz::Europe_Bratislava}, // M. R. Štefánik Airport
    Airport{IataCode{"BTT"}, CountryId{"US"}, Tz::America_Anchorage}, // Bettles Airport
    Airport{IataCode{"BTU"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Bintulu Airport
    Airport{IataCode{"BTV"}, CountryId{"US"}, Tz::America_New_York}, // Burlington International Airport
    Airport{IataCode{"BTW"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Batu Licin Airport
    Airport{IataCode{"BTY"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Beatty Airport
    Airport{IataCode{"BUA"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Buka Airport
    Airport{IataCode{"BUC"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Burketown Airport
    Airport{IataCode{"BUD"}, CountryId{"HU"}, Tz::Europe_Budapest}, // Budapest Ferenc Liszt International Airport
    Airport{IataCode{"BUF"}, CountryId{"US"}, Tz::America_New_York}, // Buffalo Niagara International Airport
    Airport{IataCode{"BUG"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Benguela Airport
    Airport{IataCode{"BUI"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Bokondini Airport
    Airport{IataCode{"BUJ"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Ain Eddis Airport
    Airport{IataCode{"BUK"}, CountryId{"YE"}, Tz::Asia_Aden}, // Albuq Airport
    Airport{IataCode{"BUL"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bulolo Airport
    Airport{IataCode{"BUN"}, CountryId{"CO"}, Tz::America_Bogota}, // Gerardo Tobar López Airport
    Airport{IataCode{"BUO"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Burao Airport
    Airport{IataCode{"BUP"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Bathinda Airport
    Airport{IataCode{"BUQ"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Joshua Mqabuko Nkomo International Airport
    Airport{IataCode{"BUR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Hollywood Burbank Airport
    Airport{IataCode{"BUS"}, CountryId{"GE"}, Tz::Asia_Tbilisi}, // Batumi International Airport
    Airport{IataCode{"BUT"}, CountryId{"BT"}, Tz::Asia_Thimphu}, // Bathpalathang Airport
    Airport{IataCode{"BUU"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Muara Bungo Airport
    Airport{IataCode{"BUV"}, CountryId{"UY"}, Tz::America_Montevideo}, // Placeres Airport
    Airport{IataCode{"BUW"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Betoambari Airport
    Airport{IataCode{"BUX"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Bunia Airport
    Airport{IataCode{"BUY"}, CountryId{"AU"}, Tz::Australia_Perth}, // Bunbury Airport
    Airport{IataCode{"BUZ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Bushehr Airport
    Airport{IataCode{"BVA"}, CountryId{"FR"}, Tz::Europe_Paris}, // Beauvais-Tillé Airport
    Airport{IataCode{"BVB"}, CountryId{"BR"}, Tz::America_Boa_Vista}, // Boa Vista International Airport
    Airport{IataCode{"BVC"}, CountryId{"CV"}, Tz::Atlantic_Cape_Verde}, // Aristides Pereira International Airport
    Airport{IataCode{"BVE"}, CountryId{"FR"}, Tz::Europe_Paris}, // Brive – Souillac Airport
    Airport{IataCode{"BVF"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Bua / Dama
    Airport{IataCode{"BVG"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Berlevåg Airport
    Airport{IataCode{"BVI"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Birdsville Airport
    Airport{IataCode{"BVJ"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Bovanenkovo Airport
    Airport{IataCode{"BVK"}, CountryId{"BO"}, Tz::America_La_Paz}, // Huacaraje Airport
    Airport{IataCode{"BVL"}, CountryId{"BO"}, Tz::America_La_Paz}, // Baures Airport
    Airport{IataCode{"BVO"}, CountryId{"US"}, Tz::America_Chicago}, // Bartlesville Municipal Airport
    Airport{IataCode{"BVP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bolovip
    Airport{IataCode{"BVU"}, CountryId{"US"}, Tz::America_Anchorage}, // Beluga Airport
    Airport{IataCode{"BVV"}, CountryId{"RU"}, Tz::Asia_Ust_Nera}, // Burevestnik Airport
    Airport{IataCode{"BVW"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Batavia Downs Airport
    Airport{IataCode{"BVX"}, CountryId{"US"}, Tz::America_Chicago}, // Batesville Regional Airport
    Airport{IataCode{"BVY"}, CountryId{"US"}, Tz::America_New_York}, // Beverly Municipal Airport
    Airport{IataCode{"BWA"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Gautam Buddha International Airport
    Airport{IataCode{"BWB"}, CountryId{"AU"}, Tz::Australia_Perth}, // Barrow Island Airport
    Airport{IataCode{"BWC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Brawley Municipal Airport
    Airport{IataCode{"BWD"}, CountryId{"US"}, Tz::America_Chicago}, // Brownwood Regional Airport
    Airport{IataCode{"BWE"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Braunschweig Airport
    Airport{IataCode{"BWF"}, CountryId{"GB"}, Tz::Europe_London}, // Barrow/Walney Island Airport
    Airport{IataCode{"BWG"}, CountryId{"US"}, Tz::America_Chicago}, // Bowling Green-Warren County Regional Airport
    Airport{IataCode{"BWH"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // RMAF Butterworth
    Airport{IataCode{"BWI"}, CountryId{"US"}, Tz::America_New_York}, // Baltimore/Washington International Thurgood Marshall Airport
    Airport{IataCode{"BWJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bawan
    Airport{IataCode{"BWK"}, CountryId{"HR"}, Tz::Europe_Zagreb}, // Bol Airport
    Airport{IataCode{"BWL"}, CountryId{"US"}, Tz::America_Chicago}, // Blackwell–Tonkawa Municipal Airport
    Airport{IataCode{"BWN"}, CountryId{"BN"}, Tz::Asia_Brunei}, // Brunei International Airport
    Airport{IataCode{"BWO"}, CountryId{"RU"}, Tz::Europe_Saratov}, // Balakovo Airport
    Airport{IataCode{"BWP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bewani Airport
    Airport{IataCode{"BWQ"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Brewarrina Airport
    Airport{IataCode{"BWT"}, CountryId{"AU"}, Tz::Australia_Hobart}, // Burnie Airport
    Airport{IataCode{"BWU"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Bankstown Airport
    Airport{IataCode{"BWW"}, CountryId{"CU"}, Tz::America_Havana}, // Las Brujas Airport
    Airport{IataCode{"BWX"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Blimbingsari Airport
    Airport{IataCode{"BXB"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Babo Airport
    Airport{IataCode{"BXD"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Bade Airport
    Airport{IataCode{"BXE"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Bakel Airport
    Airport{IataCode{"BXG"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Bendigo Airport
    Airport{IataCode{"BXH"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Balkhash Airport
    Airport{IataCode{"BXI"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Boundiali Airport
    Airport{IataCode{"BXJ"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Boraldai Airport
    Airport{IataCode{"BXK"}, CountryId{"US"}, Tz::America_Phoenix}, // Buckeye Municipal Airport
    Airport{IataCode{"BXM"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Batom Airport
    Airport{IataCode{"BXN"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Bodrum-Imsik Airport
    Airport{IataCode{"BXO"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Buochs Airport
    Airport{IataCode{"BXP"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Biała Podlaska Airport
    Airport{IataCode{"BXR"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Bam Airport
    Airport{IataCode{"BXS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Borrego Valley Airport
    Airport{IataCode{"BXT"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Bontang Airport
    Airport{IataCode{"BXU"}, CountryId{"PH"}, Tz::Asia_Manila}, // Bancasi Airport
    Airport{IataCode{"BXV"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Breiðdalsvík Airport
    Airport{IataCode{"BXW"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Bawean Airport
    Airport{IataCode{"BXX"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Boorama Airport
    Airport{IataCode{"BXY"}, CountryId{"KZ"}, Tz::Asia_Qyzylorda}, // Krayniy Airport
    Airport{IataCode{"BXZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Bunsil
    Airport{IataCode{"BYB"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Dibba Airport
    Airport{IataCode{"BYC"}, CountryId{"BO"}, Tz::America_La_Paz}, // Yacuiba Airport
    Airport{IataCode{"BYD"}, CountryId{"YE"}, Tz::Asia_Aden}, // Al Bayda' Airport
    Airport{IataCode{"BYF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Albert – Picardie Airport
    Airport{IataCode{"BYH"}, CountryId{"US"}, Tz::America_Chicago}, // Arkansas International Airport
    Airport{IataCode{"BYI"}, CountryId{"US"}, Tz::America_Boise}, // Burley Municipal Airport
    Airport{IataCode{"BYJ"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Beja Airport
    Airport{IataCode{"BYK"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Bouaké Airport
    Airport{IataCode{"BYL"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Belle Yella aerodrome
    Airport{IataCode{"BYM"}, CountryId{"CU"}, Tz::America_Havana}, // Carlos Manuel de Céspedes Airport
    Airport{IataCode{"BYN"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Bayankhongor Airport
    Airport{IataCode{"BYO"}, CountryId{"BR"}, Tz::America_Campo_Grande}, // Bonito Airport
    Airport{IataCode{"BYP"}, CountryId{"AU"}, Tz::Australia_Perth}, // Barimunya Airport
    Airport{IataCode{"BYR"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Læsø Airport
    Airport{IataCode{"BYT"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Bantry Aerodrome
    Airport{IataCode{"BZB"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Bazaruto Island Airport
    Airport{IataCode{"BZC"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Armação dos Búzios Airport
    Airport{IataCode{"BZD"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Balranald Airport
    Airport{IataCode{"BZE"}, CountryId{"BZ"}, Tz::America_Belize}, // Philip S. W. Goldson International Airport
    Airport{IataCode{"BZF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Benton Field
    Airport{IataCode{"BZG"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Bydgoszcz Ignacy Jan Paderewski Airport
    Airport{IataCode{"BZK"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Bryansk International Airport
    Airport{IataCode{"BZL"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Barisal Airport
    Airport{IataCode{"BZN"}, CountryId{"US"}, Tz::America_Denver}, // Bozeman Yellowstone International Airport
    Airport{IataCode{"BZO"}, CountryId{"IT"}, Tz::Europe_Rome}, // Bolzano airport
    Airport{IataCode{"BZR"}, CountryId{"FR"}, Tz::Europe_Paris}, // Béziers Cap d'Agde Airport
    Airport{IataCode{"BZU"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Buta Zega Airport
    Airport{IataCode{"BZV"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Maya-Maya Airport
    Airport{IataCode{"BZX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Bazhong Enyang Airport
    Airport{IataCode{"BZY"}, CountryId{"MD"}, Tz::Europe_Chisinau}, // Bălți International Airport
    Airport{IataCode{"CAA"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // El Aguacate Airport
    Airport{IataCode{"CAB"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Cabinda Airport
    Airport{IataCode{"CAD"}, CountryId{"US"}, Tz::America_Detroit}, // Wexford County Airport
    Airport{IataCode{"CAE"}, CountryId{"US"}, Tz::America_New_York}, // Columbia Metropolitan Airport
    Airport{IataCode{"CAF"}, CountryId{"BR"}, Tz::America_Manaus}, // Carauari Airport
    Airport{IataCode{"CAG"}, CountryId{"IT"}, Tz::Europe_Rome}, // Cagliari Elmas Airport
    Airport{IataCode{"CAH"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Cà Mau Airport
    Airport{IataCode{"CAI"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Cairo International Airport
    Airport{IataCode{"CAJ"}, CountryId{"VE"}, Tz::America_Caracas}, // Canaima Airport
    Airport{IataCode{"CAK"}, CountryId{"US"}, Tz::America_New_York}, // Akron-Canton Airport
    Airport{IataCode{"CAL"}, CountryId{"GB"}, Tz::Europe_London}, // Campbeltown Airport
    Airport{IataCode{"CAN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Guangzhou Baiyun International Airport
    Airport{IataCode{"CAO"}, CountryId{"US"}, Tz::America_Denver}, // Clayton Municipal Airpark
    Airport{IataCode{"CAP"}, CountryId{"HT"}, Tz::America_Port_au_Prince}, // Cap-Haitien International Airport
    Airport{IataCode{"CAQ"}, CountryId{"CO"}, Tz::America_Bogota}, // Juan H. White Airport
    Airport{IataCode{"CAR"}, CountryId{"US"}, Tz::America_New_York}, // Caribou Municipal Airport
    Airport{IataCode{"CAT"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Cascais Municipal Aerodrome
    Airport{IataCode{"CAU"}, CountryId{"BR"}, Tz::America_Recife}, // Caruaru Airport
    Airport{IataCode{"CAV"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Cazombo Airport
    Airport{IataCode{"CAW"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Bartolomeu Lysandro Airport
    Airport{IataCode{"CAX"}, CountryId{"GB"}, Tz::Europe_London}, // Carlisle Lake District Airport
    Airport{IataCode{"CAY"}, CountryId{"FR"}, Tz::America_Cayenne}, // Cayenne – Félix Eboué Airport
    Airport{IataCode{"CAZ"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Cobar Airport
    Airport{IataCode{"CBB"}, CountryId{"BO"}, Tz::America_La_Paz}, // Jorge Wilstermann International Airport
    Airport{IataCode{"CBE"}, CountryId{"US"}, Tz::America_New_York}, // Greater Cumberland Regional Airport
    Airport{IataCode{"CBF"}, CountryId{"US"}, Tz::America_Chicago}, // Council Bluffs Municipal Airport
    Airport{IataCode{"CBG"}, CountryId{"GB"}, Tz::Europe_London}, // Cambridge Airport
    Airport{IataCode{"CBH"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Boudghene Ben Ali Lotfi Airport
    Airport{IataCode{"CBJ"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // Cabo Rojo Airport
    Airport{IataCode{"CBK"}, CountryId{"US"}, Tz::America_Chicago}, // Colby Municipal Airport
    Airport{IataCode{"CBL"}, CountryId{"VE"}, Tz::America_Caracas}, // Tomás de Heres Airport
    Airport{IataCode{"CBN"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Penggung Airport
    Airport{IataCode{"CBO"}, CountryId{"PH"}, Tz::Asia_Manila}, // Awang Airport
    Airport{IataCode{"CBP"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Coimbra Airport
    Airport{IataCode{"CBQ"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Margaret Ekpo International Airport
    Airport{IataCode{"CBR"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Canberra International Airport
    Airport{IataCode{"CBS"}, CountryId{"VE"}, Tz::America_Caracas}, // Oro Negro Airport
    Airport{IataCode{"CBT"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Catumbela Airport
    Airport{IataCode{"CBV"}, CountryId{"GT"}, Tz::America_Guatemala}, // Cobán Airport
    Airport{IataCode{"CBX"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Condobolin Airport
    Airport{IataCode{"CCA"}, CountryId{"BO"}, Tz::America_La_Paz}, // Chimore Airport
    Airport{IataCode{"CCB"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Cable Airport
    Airport{IataCode{"CCC"}, CountryId{"CU"}, Tz::America_Havana}, // Jardines del Rey Airport
    Airport{IataCode{"CCE"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Capital International Airport
    Airport{IataCode{"CCF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Carcassonne Airport
    Airport{IataCode{"CCH"}, CountryId{"CL"}, Tz::America_Santiago}, // Chile Chico Airport
    Airport{IataCode{"CCI"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Concórdia Airport
    Airport{IataCode{"CCJ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Calicut International Airport
    Airport{IataCode{"CCK"}, CountryId{"AU"}, Tz::Indian_Cocos}, // Cocos (Keeling) Islands Airport
    Airport{IataCode{"CCL"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Chinchilla Airport
    Airport{IataCode{"CCM"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Diomício Freitas Airport
    Airport{IataCode{"CCN"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Chaghcharan Airport
    Airport{IataCode{"CCO"}, CountryId{"CO"}, Tz::America_Bogota}, // Carimagua Airport
    Airport{IataCode{"CCP"}, CountryId{"CL"}, Tz::America_Santiago}, // Carriel Sur International Airport
    Airport{IataCode{"CCR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Buchanan Field Airport
    Airport{IataCode{"CCS"}, CountryId{"VE"}, Tz::America_Caracas}, // Simón Bolívar International Airport
    Airport{IataCode{"CCT"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Colonia Catriel Airport
    Airport{IataCode{"CCU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Netaji Subhas Chandra Bose International Airport
    Airport{IataCode{"CCV"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Craig Cove Airport
    Airport{IataCode{"CCW"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Cowell Airport
    Airport{IataCode{"CCY"}, CountryId{"US"}, Tz::America_Chicago}, // Northeast Iowa Regional Airport
    Airport{IataCode{"CCZ"}, CountryId{"BS"}, Tz::America_Nassau}, // Chub Cay International Airport
    Airport{IataCode{"CDB"}, CountryId{"US"}, Tz::America_Nome}, // Cold Bay Airport
    Airport{IataCode{"CDC"}, CountryId{"US"}, Tz::America_Denver}, // Cedar City Regional Airport
    Airport{IataCode{"CDD"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Cauquira Airport
    Airport{IataCode{"CDE"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Chengde Airport
    Airport{IataCode{"CDG"}, CountryId{"FR"}, Tz::Europe_Paris}, // Paris-Charles de Gaulle Airport
    Airport{IataCode{"CDH"}, CountryId{"US"}, Tz::America_Chicago}, // Harrell Field
    Airport{IataCode{"CDI"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Cachoeiro de Itapemirim Airport
    Airport{IataCode{"CDJ"}, CountryId{"BR"}, Tz::America_Belem}, // Conceição do Araguaia Airport
    Airport{IataCode{"CDK"}, CountryId{"US"}, Tz::America_New_York}, // George T. Lewis Airport
    Airport{IataCode{"CDN"}, CountryId{"US"}, Tz::America_New_York}, // Woodward Field (airport)
    Airport{IataCode{"CDP"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kadapa Airport
    Airport{IataCode{"CDR"}, CountryId{"US"}, Tz::America_Denver}, // Chadron Municipal Airport
    Airport{IataCode{"CDS"}, CountryId{"US"}, Tz::America_Chicago}, // Childress Municipal Airport
    Airport{IataCode{"CDT"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Castellón-Costa Azahar Airport
    Airport{IataCode{"CDU"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Camden Airport
    Airport{IataCode{"CDV"}, CountryId{"US"}, Tz::America_Anchorage}, // Merle K. (Mudhole) Smith Airport
    Airport{IataCode{"CDW"}, CountryId{"US"}, Tz::America_New_York}, // Essex County Airport
    Airport{IataCode{"CDY"}, CountryId{"PH"}, Tz::Asia_Manila}, // Cagayan de Sulu Airport
    Airport{IataCode{"CEA"}, CountryId{"US"}, Tz::America_Chicago}, // Cessna Aircraft Field
    Airport{IataCode{"CEB"}, CountryId{"PH"}, Tz::Asia_Manila}, // Mactan–Cebu International Airport
    Airport{IataCode{"CEC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Del Norte County Airport
    Airport{IataCode{"CED"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Ceduna Airport
    Airport{IataCode{"CEE"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Cherepovets Airport
    Airport{IataCode{"CEF"}, CountryId{"US"}, Tz::America_New_York}, // Westover Metropolitan Airport
    Airport{IataCode{"CEG"}, CountryId{"GB"}, Tz::Europe_London}, // Hawarden Airport
    Airport{IataCode{"CEH"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Chelinda Airport
    Airport{IataCode{"CEI"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Mae Fah Luang – Chiang Rai International Airport
    Airport{IataCode{"CEJ"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Chernihiv Shestovitsa Airport
    Airport{IataCode{"CEK"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Chelyabinsk Airport
    Airport{IataCode{"CEL"}, CountryId{"BS"}, Tz::America_Nassau}, // Cape Eleuthera Airport
    Airport{IataCode{"CEM"}, CountryId{"US"}, Tz::America_Anchorage}, // Central Airport
    Airport{IataCode{"CEN"}, CountryId{"MX"}, Tz::America_Hermosillo}, // Ciudad Obregón International Airport
    Airport{IataCode{"CEO"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Waco Kungo Airport
    Airport{IataCode{"CEP"}, CountryId{"BO"}, Tz::America_La_Paz}, // Concepcion Airport
    Airport{IataCode{"CEQ"}, CountryId{"FR"}, Tz::Europe_Paris}, // Cannes – Mandelieu Airport
    Airport{IataCode{"CER"}, CountryId{"FR"}, Tz::Europe_Paris}, // Cherbourg – Maupertus Airport
    Airport{IataCode{"CES"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Cessnock Airport
    Airport{IataCode{"CEU"}, CountryId{"US"}, Tz::America_New_York}, // Oconee County Regional Airport
    Airport{IataCode{"CEV"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Mettel Field
    Airport{IataCode{"CEW"}, CountryId{"US"}, Tz::America_Chicago}, // Bob Sikes Airport
    Airport{IataCode{"CEY"}, CountryId{"US"}, Tz::America_Chicago}, // Murray-Calloway County Airport
    Airport{IataCode{"CEZ"}, CountryId{"US"}, Tz::America_Denver}, // Cortez Municipal Airport
    Airport{IataCode{"CFB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Cabo Frio International Airport
    Airport{IataCode{"CFC"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Caçador Airport
    Airport{IataCode{"CFD"}, CountryId{"US"}, Tz::America_Chicago}, // Coulter Field
    Airport{IataCode{"CFE"}, CountryId{"FR"}, Tz::Europe_Paris}, // Clermont-Ferrand Auvergne Airport
    Airport{IataCode{"CFF"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Cafunfo Airport
    Airport{IataCode{"CFG"}, CountryId{"CU"}, Tz::America_Havana}, // Jaime González Airport
    Airport{IataCode{"CFM"}, CountryId{"CA"}, Tz::America_Edmonton}, // Conklin (Leismer) Airport
    Airport{IataCode{"CFN"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Donegal Airport
    Airport{IataCode{"CFO"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Confresa Airport
    Airport{IataCode{"CFQ"}, CountryId{"CA"}, Tz::America_Creston}, // Creston Aerodrome
    Airport{IataCode{"CFR"}, CountryId{"FR"}, Tz::Europe_Paris}, // Caen – Carpiquet Airport
    Airport{IataCode{"CFS"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Coffs Harbour Airport
    Airport{IataCode{"CFT"}, CountryId{"US"}, Tz::America_Phoenix}, // Greenlee County Airport
    Airport{IataCode{"CFU"}, CountryId{"GR"}, Tz::Europe_Athens}, // Corfu International Airport
    Airport{IataCode{"CFV"}, CountryId{"US"}, Tz::America_Chicago}, // Coffeyville Municipal Airport
    Airport{IataCode{"CGA"}, CountryId{"US"}, Tz::America_Sitka}, // Craig Seaplane Base
    Airport{IataCode{"CGB"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Marechal Rondon International Airport
    Airport{IataCode{"CGC"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Cape Gloucester Airport
    Airport{IataCode{"CGD"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Changde Taohuayuan Airport
    Airport{IataCode{"CGE"}, CountryId{"US"}, Tz::America_New_York}, // Cambridge–Dorchester Airport
    Airport{IataCode{"CGF"}, CountryId{"US"}, Tz::America_New_York}, // Cuyahoga County Airport
    Airport{IataCode{"CGH"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Congonhas-São Paulo Airport
    Airport{IataCode{"CGI"}, CountryId{"US"}, Tz::America_Chicago}, // Cape Girardeau Regional Airport
    Airport{IataCode{"CGJ"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Kasompe Airport
    Airport{IataCode{"CGK"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Soekarno–Hatta International Airport
    Airport{IataCode{"CGM"}, CountryId{"PH"}, Tz::Asia_Manila}, // Camiguin Airport
    Airport{IataCode{"CGN"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Cologne Bonn Airport
    Airport{IataCode{"CGO"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhengzhou Xinzheng International Airport
    Airport{IataCode{"CGP"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Shah Amanat International Airport
    Airport{IataCode{"CGQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Changchun Longjia International Airport
    Airport{IataCode{"CGR"}, CountryId{"BR"}, Tz::America_Campo_Grande}, // Campo Grande International Airport
    Airport{IataCode{"CGS"}, CountryId{"US"}, Tz::America_New_York}, // College Park Airport
    Airport{IataCode{"CGT"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Chinguetti Airport
    Airport{IataCode{"CGY"}, CountryId{"PH"}, Tz::Asia_Manila}, // Laguindingan International Airport
    Airport{IataCode{"CGZ"}, CountryId{"US"}, Tz::America_Phoenix}, // Casa Grande Municipal Airport
    Airport{IataCode{"CHA"}, CountryId{"US"}, Tz::America_New_York}, // Chattanooga Metropolitan Airport
    Airport{IataCode{"CHB"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Chilas Airport
    Airport{IataCode{"CHC"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Christchurch International Airport
    Airport{IataCode{"CHF"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Jinhae Airport
    Airport{IataCode{"CHG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Chaoyang Airport
    Airport{IataCode{"CHH"}, CountryId{"PE"}, Tz::America_Lima}, // Chachapoyas Airport
    Airport{IataCode{"CHJ"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Chipinge Airport
    Airport{IataCode{"CHK"}, CountryId{"US"}, Tz::America_Chicago}, // Chickasaw Municipal Airport
    Airport{IataCode{"CHL"}, CountryId{"US"}, Tz::America_Boise}, // Challis Airport
    Airport{IataCode{"CHM"}, CountryId{"PE"}, Tz::America_Lima}, // Tnte. FAP Jaime Montreuil Morales Airport
    Airport{IataCode{"CHN"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Jeonju Airport
    Airport{IataCode{"CHO"}, CountryId{"US"}, Tz::America_New_York}, // Charlottesville Albemarle Airport
    Airport{IataCode{"CHP"}, CountryId{"US"}, Tz::America_Anchorage}, // Circle Hot Springs Airport
    Airport{IataCode{"CHQ"}, CountryId{"GR"}, Tz::Europe_Athens}, // Chania International Airport
    Airport{IataCode{"CHR"}, CountryId{"FR"}, Tz::Europe_Paris}, // Châteauroux-Centre "Marcel Dassault" Airport
    Airport{IataCode{"CHS"}, CountryId{"US"}, Tz::America_New_York}, // Charleston International Airport
    Airport{IataCode{"CHT"}, CountryId{"NZ"}, Tz::Pacific_Chatham}, // Chatham Islands / Tuuta Airport
    Airport{IataCode{"CHU"}, CountryId{"US"}, Tz::America_Anchorage}, // Chuathbaluk Airport
    Airport{IataCode{"CHV"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Chaves Airport
    Airport{IataCode{"CHX"}, CountryId{"PA"}, Tz::America_Panama}, // Changuinola "Capitán Manuel Niño" International Airport
    Airport{IataCode{"CHY"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Choiseul Bay Airport
    Airport{IataCode{"CHZ"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Chiloquin State Airport
    Airport{IataCode{"CIA"}, CountryId{"IT"}, Tz::Europe_Rome}, // Ciampino–G.B. Pastine International Airport
    Airport{IataCode{"CIC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Chico Municipal Airport
    Airport{IataCode{"CID"}, CountryId{"US"}, Tz::America_Chicago}, // The Eastern Iowa Airport
    Airport{IataCode{"CIF"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Chifeng Yulong Airport
    Airport{IataCode{"CIG"}, CountryId{"US"}, Tz::America_Denver}, // Craig–Moffat Airport
    Airport{IataCode{"CIH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Changzhi Wangcun Airport
    Airport{IataCode{"CII"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Aydın Airport
    Airport{IataCode{"CIJ"}, CountryId{"BO"}, Tz::America_La_Paz}, // Captain Internacional Aníbal Arab Airport
    Airport{IataCode{"CIK"}, CountryId{"US"}, Tz::America_Anchorage}, // Chalkyitsik Airport
    Airport{IataCode{"CIL"}, CountryId{"US"}, Tz::America_Nome}, // Council Airport
    Airport{IataCode{"CIM"}, CountryId{"CO"}, Tz::America_Bogota}, // Cimitarra Airport
    Airport{IataCode{"CIN"}, CountryId{"US"}, Tz::America_Chicago}, // Arthur N. Neu Airport
    Airport{IataCode{"CIO"}, CountryId{"PY"}, Tz::America_Asuncion}, // Concepcion
    Airport{IataCode{"CIP"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Chipata Airport
    Airport{IataCode{"CIQ"}, CountryId{"GT"}, Tz::America_Guatemala}, // Chiquimula Airport
    Airport{IataCode{"CIR"}, CountryId{"US"}, Tz::America_Chicago}, // Cairo Airport
    Airport{IataCode{"CIS"}, CountryId{"KI"}, Tz::Pacific_Enderbury}, // Canton Island Airport
    Airport{IataCode{"CIT"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Shymkent International Airport
    Airport{IataCode{"CIU"}, CountryId{"US"}, Tz::America_Detroit}, // Chippewa County International Airport
    Airport{IataCode{"CIW"}, CountryId{"VC"}, Tz::America_St_Vincent}, // Canouan Airport
    Airport{IataCode{"CIX"}, CountryId{"PE"}, Tz::America_Lima}, // Cap. FAP José A. Quiñones Gonzáles International Airport
    Airport{IataCode{"CIY"}, CountryId{"IT"}, Tz::Europe_Rome}, // Comiso Airport
    Airport{IataCode{"CIZ"}, CountryId{"BR"}, Tz::America_Manaus}, // Coari Airport
    Airport{IataCode{"CJA"}, CountryId{"PE"}, Tz::America_Lima}, // Mayor General FAP Armando Revoredo Iglesias Airport
    Airport{IataCode{"CJB"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Coimbatore Airport
    Airport{IataCode{"CJC"}, CountryId{"CL"}, Tz::America_Santiago}, // El Loa Airport
    Airport{IataCode{"CJF"}, CountryId{"AU"}, Tz::Australia_Perth}, // Coondewanna Airport
    Airport{IataCode{"CJH"}, CountryId{"CA"}, Tz::America_Vancouver}, // Chilko Lake (Tsylos Park Lodge) Aerodrome
    Airport{IataCode{"CJJ"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Cheongju International Airport
    Airport{IataCode{"CJL"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Chitral Airport
    Airport{IataCode{"CJM"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Chumphon Airport
    Airport{IataCode{"CJN"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Nusawiru Airport
    Airport{IataCode{"CJS"}, CountryId{"MX"}, Tz::America_Ojinaga}, // Abraham González Airport
    Airport{IataCode{"CJT"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Comitán Airport
    Airport{IataCode{"CJU"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Jeju International Airport
    Airport{IataCode{"CKB"}, CountryId{"US"}, Tz::America_New_York}, // North Central West Virginia Airport
    Airport{IataCode{"CKC"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Cherkasy International Airport
    Airport{IataCode{"CKD"}, CountryId{"US"}, Tz::America_Anchorage}, // Crooked Creek Airport
    Airport{IataCode{"CKE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Lampson Field
    Airport{IataCode{"CKG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Chongqing Jiangbei International Airport
    Airport{IataCode{"CKH"}, CountryId{"RU"}, Tz::Asia_Srednekolymsk}, // Chokurdakh Airport
    Airport{IataCode{"CKI"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Croker Island Airport
    Airport{IataCode{"CKK"}, CountryId{"US"}, Tz::America_Chicago}, // Sharp County Regional Airport
    Airport{IataCode{"CKM"}, CountryId{"US"}, Tz::America_Chicago}, // Fletcher Field Airport
    Airport{IataCode{"CKN"}, CountryId{"US"}, Tz::America_Chicago}, // Crookston Municipal Airport
    Airport{IataCode{"CKO"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Cornélio Procópio Airport
    Airport{IataCode{"CKS"}, CountryId{"BR"}, Tz::America_Belem}, // Carajás Airport
    Airport{IataCode{"CKT"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Sarakhs Airport
    Airport{IataCode{"CKU"}, CountryId{"US"}, Tz::America_Anchorage}, // Cordova Municipal Airport
    Airport{IataCode{"CKV"}, CountryId{"US"}, Tz::America_Chicago}, // Clarksville-Montgomery County Regional Airport
    Airport{IataCode{"CKW"}, CountryId{"AU"}, Tz::Australia_Perth}, // Graeme Rowley Aerodrome
    Airport{IataCode{"CKX"}, CountryId{"US"}, Tz::America_Anchorage}, // Chicken Airport
    Airport{IataCode{"CKY"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Conakry International Airport
    Airport{IataCode{"CLA"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Comilla Airport
    Airport{IataCode{"CLD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // McClellan–Palomar Airport
    Airport{IataCode{"CLE"}, CountryId{"US"}, Tz::America_New_York}, // Cleveland Hopkins International Airport
    Airport{IataCode{"CLG"}, CountryId{"US"}, Tz::America_Los_Angeles}, // New Coalinga Municipal Airport
    Airport{IataCode{"CLH"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Coolah Airport
    Airport{IataCode{"CLI"}, CountryId{"US"}, Tz::America_Chicago}, // Clintonville Municipal Airport
    Airport{IataCode{"CLJ"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Cluj International Airport
    Airport{IataCode{"CLK"}, CountryId{"US"}, Tz::America_Chicago}, // Clinton Regional Airport
    Airport{IataCode{"CLL"}, CountryId{"US"}, Tz::America_Chicago}, // Easterwood Airport
    Airport{IataCode{"CLM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // William R. Fairchild International Airport
    Airport{IataCode{"CLO"}, CountryId{"CO"}, Tz::America_Bogota}, // Alfonso Bonilla Aragón International Airport
    Airport{IataCode{"CLP"}, CountryId{"US"}, Tz::America_Anchorage}, // Clarks Point Airport
    Airport{IataCode{"CLQ"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Lic. Miguel de la Madrid Airport
    Airport{IataCode{"CLR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Cliff Hatfield Memorial Airport
    Airport{IataCode{"CLS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Chehalis–Centralia Airport
    Airport{IataCode{"CLU"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Columbus Municipal Airport
    Airport{IataCode{"CLV"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Caldas Novas Airport
    Airport{IataCode{"CLW"}, CountryId{"US"}, Tz::America_New_York}, // Clearwater Air Park
    Airport{IataCode{"CLX"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Clorinda Airport
    Airport{IataCode{"CLY"}, CountryId{"FR"}, Tz::Europe_Paris}, // Calvi – Sainte-Catherine Airport
    Airport{IataCode{"CLZ"}, CountryId{"VE"}, Tz::America_Caracas}, // Calabozo Airport
    Airport{IataCode{"CMA"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Cunnamulla Airport
    Airport{IataCode{"CMB"}, CountryId{"LK"}, Tz::Asia_Colombo}, // Bandaranaike International Airport
    Airport{IataCode{"CMD"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Cootamundra Airport
    Airport{IataCode{"CME"}, CountryId{"MX"}, Tz::America_Merida}, // Ciudad del Carmen International Airport
    Airport{IataCode{"CMF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Chambéry Airport
    Airport{IataCode{"CMG"}, CountryId{"BR"}, Tz::America_Campo_Grande}, // Corumbá International Airport
    Airport{IataCode{"CMH"}, CountryId{"US"}, Tz::America_New_York}, // John Glenn Columbus International Airport
    Airport{IataCode{"CMI"}, CountryId{"US"}, Tz::America_Chicago}, // University of Illinois Willard Airport
    Airport{IataCode{"CMJ"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Qimei Airport
    Airport{IataCode{"CMK"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Club Makokola Airport
    Airport{IataCode{"CML"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Camooweal Airport
    Airport{IataCode{"CMM"}, CountryId{"GT"}, Tz::America_Guatemala}, // Carmelita Airport
    Airport{IataCode{"CMN"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Mohammed V International Airport
    Airport{IataCode{"CMO"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Obbia Airport
    Airport{IataCode{"CMP"}, CountryId{"BR"}, Tz::America_Belem}, // Santana do Araguaia Airport
    Airport{IataCode{"CMQ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Clermont Airport
    Airport{IataCode{"CMR"}, CountryId{"FR"}, Tz::Europe_Paris}, // Colmar Airport
    Airport{IataCode{"CMS"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Scusciuban Airport
    Airport{IataCode{"CMU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Chimbu Airport
    Airport{IataCode{"CMV"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Coromandel Aerodrome
    Airport{IataCode{"CMW"}, CountryId{"CU"}, Tz::America_Havana}, // Ignacio Agramonte International Airport
    Airport{IataCode{"CMX"}, CountryId{"US"}, Tz::America_Detroit}, // Houghton County Memorial Airport
    Airport{IataCode{"CMY"}, CountryId{"US"}, Tz::America_Chicago}, // Sparta/Fort McCoy Airport
    Airport{IataCode{"CNA"}, CountryId{"MX"}, Tz::America_Hermosillo}, // Cananea Airport
    Airport{IataCode{"CNB"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Coonamble Airport
    Airport{IataCode{"CNC"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Coconut Island Airport
    Airport{IataCode{"CND"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Mihail Kogălniceanu International Airport
    Airport{IataCode{"CNF"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Tancredo Neves International Airport
    Airport{IataCode{"CNH"}, CountryId{"US"}, Tz::America_New_York}, // Claremont Municipal Airport
    Airport{IataCode{"CNI"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Changhai Airport
    Airport{IataCode{"CNJ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Cloncurry Airport
    Airport{IataCode{"CNK"}, CountryId{"US"}, Tz::America_Chicago}, // Blosser Municipal Airport
    Airport{IataCode{"CNL"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Sindal Airport
    Airport{IataCode{"CNM"}, CountryId{"US"}, Tz::America_Denver}, // Cavern City Air Terminal
    Airport{IataCode{"CNN"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kannur International Airport
    Airport{IataCode{"CNO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Chino Airport
    Airport{IataCode{"CNP"}, CountryId{"GL"}, Tz::America_Danmarkshavn}, // Nerlerit Inaat Airport
    Airport{IataCode{"CNQ"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Doctor Fernando Piragine Niveyro International Airport
    Airport{IataCode{"CNR"}, CountryId{"CL"}, Tz::America_Santiago}, // Chanaral Airport
    Airport{IataCode{"CNS"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Cairns Airport
    Airport{IataCode{"CNU"}, CountryId{"US"}, Tz::America_Chicago}, // Chanute Martin Johnson Airport
    Airport{IataCode{"CNW"}, CountryId{"US"}, Tz::America_Chicago}, // TSTC Waco Airport
    Airport{IataCode{"CNX"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Chiang Mai International Airport
    Airport{IataCode{"CNY"}, CountryId{"US"}, Tz::America_Denver}, // Canyonlands Field
    Airport{IataCode{"CNZ"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Cangamba Airport
    Airport{IataCode{"COA"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Columbia Airport
    Airport{IataCode{"COC"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Comodoro Pierrestegui Airport
    Airport{IataCode{"COD"}, CountryId{"US"}, Tz::America_Denver}, // Yellowstone Regional Airport
    Airport{IataCode{"COE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Coeur d'Alene Airport
    Airport{IataCode{"COG"}, CountryId{"CO"}, Tz::America_Bogota}, // Mandinga Airport
    Airport{IataCode{"COH"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Cooch Behar Airport
    Airport{IataCode{"COI"}, CountryId{"US"}, Tz::America_New_York}, // Merritt Island Airport
    Airport{IataCode{"COJ"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Coonabarabran Airport
    Airport{IataCode{"COK"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Cochin International Airport
    Airport{IataCode{"COM"}, CountryId{"US"}, Tz::America_Chicago}, // Coleman Municipal Airport
    Airport{IataCode{"CON"}, CountryId{"US"}, Tz::America_New_York}, // Concord Municipal Airport
    Airport{IataCode{"COO"}, CountryId{"BJ"}, Tz::Africa_Porto_Novo}, // Cadjehoun Airport
    Airport{IataCode{"COP"}, CountryId{"US"}, Tz::America_New_York}, // Cooperstown-Westville Airport
    Airport{IataCode{"COQ"}, CountryId{"MN"}, Tz::Asia_Choibalsan}, // Choibalsan Airport
    Airport{IataCode{"COR"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Ingeniero Aeronáutico Ambrosio L.V. Taravella International Airport
    Airport{IataCode{"COS"}, CountryId{"US"}, Tz::America_Denver}, // Colorado Springs Airport
    Airport{IataCode{"COT"}, CountryId{"US"}, Tz::America_Chicago}, // Cotulla–La Salle County Airport
    Airport{IataCode{"COU"}, CountryId{"US"}, Tz::America_Chicago}, // Columbia Regional Airport
    Airport{IataCode{"COY"}, CountryId{"AU"}, Tz::Australia_Perth}, // Coolawanyah Station Airport
    Airport{IataCode{"COZ"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // Constanza Airport
    Airport{IataCode{"CPA"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Cape Palmas Airport
    Airport{IataCode{"CPB"}, CountryId{"CO"}, Tz::America_Bogota}, // Capurganá Airport
    Airport{IataCode{"CPC"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Aviador Carlos Campos Airport
    Airport{IataCode{"CPD"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Coober Pedy Airport
    Airport{IataCode{"CPE"}, CountryId{"MX"}, Tz::America_Merida}, // Ing. Alberto Acuña Ongay International Airport
    Airport{IataCode{"CPF"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Ngloram Airport
    Airport{IataCode{"CPG"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Carmen de Patagones
    Airport{IataCode{"CPH"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Copenhagen Airport
    Airport{IataCode{"CPI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Cape Orford
    Airport{IataCode{"CPL"}, CountryId{"CO"}, Tz::America_Bogota}, // Chaparral Airport
    Airport{IataCode{"CPM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Compton/Woodley Airport
    Airport{IataCode{"CPN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Cape Rodney
    Airport{IataCode{"CPO"}, CountryId{"CL"}, Tz::America_Santiago}, // Desierto de Atacama Airport
    Airport{IataCode{"CPQ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Campo dos Amarais Airport
    Airport{IataCode{"CPR"}, CountryId{"US"}, Tz::America_Denver}, // Casper–Natrona County International Airport
    Airport{IataCode{"CPS"}, CountryId{"US"}, Tz::America_Chicago}, // St. Louis Downtown Airport
    Airport{IataCode{"CPT"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Cape Town International Airport
    Airport{IataCode{"CPV"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Campina Grande Airport
    Airport{IataCode{"CPX"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // Benjamín Rivera Noriega Airport
    Airport{IataCode{"CQA"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Canarana Airport
    Airport{IataCode{"CQD"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Shahrekord Airport
    Airport{IataCode{"CQF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Calais–Dunkerque Airport
    Airport{IataCode{"CRA"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Craiova Airport
    Airport{IataCode{"CRB"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Collarenebri Airport
    Airport{IataCode{"CRC"}, CountryId{"CO"}, Tz::America_Bogota}, // Santa Ana Airport
    Airport{IataCode{"CRD"}, CountryId{"AR"}, Tz::America_Argentina_Catamarca}, // General Enrique Mosconi International Airport
    Airport{IataCode{"CRE"}, CountryId{"US"}, Tz::America_New_York}, // Grand Strand Airport
    Airport{IataCode{"CRF"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Carnot Airport
    Airport{IataCode{"CRG"}, CountryId{"US"}, Tz::America_New_York}, // Jacksonville Executive at Craig Airport
    Airport{IataCode{"CRI"}, CountryId{"BS"}, Tz::America_Nassau}, // Colonel Hill Airport
    Airport{IataCode{"CRK"}, CountryId{"PH"}, Tz::Asia_Manila}, // Clark International Airport
    Airport{IataCode{"CRL"}, CountryId{"BE"}, Tz::Europe_Brussels}, // Brussels South Charleroi Airport
    Airport{IataCode{"CRM"}, CountryId{"PH"}, Tz::Asia_Manila}, // Catarman National Airport
    Airport{IataCode{"CRP"}, CountryId{"US"}, Tz::America_Chicago}, // Corpus Christi International Airport
    Airport{IataCode{"CRR"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Ceres Airport
    Airport{IataCode{"CRS"}, CountryId{"US"}, Tz::America_Chicago}, // C. David Campbell Field
    Airport{IataCode{"CRT"}, CountryId{"US"}, Tz::America_Chicago}, // Z. M. Jack Stell Field
    Airport{IataCode{"CRU"}, CountryId{"GD"}, Tz::America_Grenada}, // Lauriston Airport
    Airport{IataCode{"CRV"}, CountryId{"IT"}, Tz::Europe_Rome}, // Crotone Airport
    Airport{IataCode{"CRW"}, CountryId{"US"}, Tz::America_New_York}, // Yeager Airport
    Airport{IataCode{"CRX"}, CountryId{"US"}, Tz::America_Chicago}, // Roscoe Turner Airport
    Airport{IataCode{"CRZ"}, CountryId{"TM"}, Tz::Asia_Ashgabat}, // Turkmenabat Airport
    Airport{IataCode{"CSB"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Caransebeș Airport
    Airport{IataCode{"CSC"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Codela Airport
    Airport{IataCode{"CSG"}, CountryId{"US"}, Tz::America_New_York}, // Columbus Airport
    Airport{IataCode{"CSH"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Solovki Airport
    Airport{IataCode{"CSI"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Casino Airport
    Airport{IataCode{"CSK"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Cap Skirring Airport
    Airport{IataCode{"CSM"}, CountryId{"US"}, Tz::America_Chicago}, // Clinton-Sherman Industrial Airpark
    Airport{IataCode{"CSN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Carson Airport
    Airport{IataCode{"CSO"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Magdeburg-Cochstedt Airport
    Airport{IataCode{"CSQ"}, CountryId{"US"}, Tz::America_Chicago}, // Creston Municipal Airport
    Airport{IataCode{"CSU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Santa Cruz do Sul Airport
    Airport{IataCode{"CSX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Changsha Huanghua International Airport
    Airport{IataCode{"CSY"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Cheboksary Airport
    Airport{IataCode{"CSZ"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Brigadier Hector Eduardo Ruiz Airport
    Airport{IataCode{"CTA"}, CountryId{"IT"}, Tz::Europe_Rome}, // Catania-Fontanarossa Airport
    Airport{IataCode{"CTB"}, CountryId{"US"}, Tz::America_Denver}, // Cut Bank Municipal Airport
    Airport{IataCode{"CTC"}, CountryId{"AR"}, Tz::America_Argentina_Catamarca}, // Coronel Felipe Varela International Airport
    Airport{IataCode{"CTD"}, CountryId{"PA"}, Tz::America_Panama}, // Chitré Alonso Valderrama Airport
    Airport{IataCode{"CTE"}, CountryId{"PA"}, Tz::America_Panama}, // San Blas Airport
    Airport{IataCode{"CTF"}, CountryId{"GT"}, Tz::America_Guatemala}, // Coatepeque Airport
    Airport{IataCode{"CTG"}, CountryId{"CO"}, Tz::America_Bogota}, // Rafael Núñez International Airport
    Airport{IataCode{"CTH"}, CountryId{"US"}, Tz::America_New_York}, // Chester County G. O. Carlson Airport
    Airport{IataCode{"CTI"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Cuito Cuanavale Airport
    Airport{IataCode{"CTK"}, CountryId{"US"}, Tz::America_Chicago}, // Canton Municipal Airport
    Airport{IataCode{"CTL"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Charleville Airport
    Airport{IataCode{"CTM"}, CountryId{"MX"}, Tz::America_Cancun}, // Chetumal International Airport
    Airport{IataCode{"CTN"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Cooktown Airport
    Airport{IataCode{"CTO"}, CountryId{"US"}, Tz::America_New_York}, // Calverton Executive Airpark
    Airport{IataCode{"CTQ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Santa Vitória do Palmar Airport
    Airport{IataCode{"CTS"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // New Chitose Airport
    Airport{IataCode{"CTT"}, CountryId{"FR"}, Tz::Europe_Paris}, // Le Castellet airport
    Airport{IataCode{"CTU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Chengdu Shuangliu International Airport
    Airport{IataCode{"CTX"}, CountryId{"US"}, Tz::America_New_York}, // Cortland County Airport
    Airport{IataCode{"CTY"}, CountryId{"US"}, Tz::America_New_York}, // Cross City Airport
    Airport{IataCode{"CTZ"}, CountryId{"US"}, Tz::America_New_York}, // Clinton-Sampson County Airport
    Airport{IataCode{"CUA"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Ciudad Constitución Airport
    Airport{IataCode{"CUB"}, CountryId{"US"}, Tz::America_New_York}, // Jim Hamilton – L.B. Owens Airport
    Airport{IataCode{"CUC"}, CountryId{"CO"}, Tz::America_Bogota}, // Camilo Daza International Airport
    Airport{IataCode{"CUD"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Caloundra Airport
    Airport{IataCode{"CUE"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Mariscal Lamar International Airport
    Airport{IataCode{"CUF"}, CountryId{"IT"}, Tz::Europe_Rome}, // Cuneo International Airport
    Airport{IataCode{"CUH"}, CountryId{"US"}, Tz::America_Chicago}, // Cushing Municipal Airport
    Airport{IataCode{"CUK"}, CountryId{"BZ"}, Tz::America_Belize}, // Caye Caulker Airport
    Airport{IataCode{"CUL"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Federal de Bachigualato International Airport
    Airport{IataCode{"CUM"}, CountryId{"VE"}, Tz::America_Caracas}, // Antonio José de Sucre Airport
    Airport{IataCode{"CUN"}, CountryId{"MX"}, Tz::America_Cancun}, // Cancún International Airport
    Airport{IataCode{"CUO"}, CountryId{"CO"}, Tz::America_Bogota}, // Caruru Airport
    Airport{IataCode{"CUP"}, CountryId{"VE"}, Tz::America_Caracas}, // General José Francisco Bermúdez Airport
    Airport{IataCode{"CUQ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Coen Airport
    Airport{IataCode{"CUR"}, CountryId{"NL"}, Tz::America_Curacao}, // Hato International Airport
    Airport{IataCode{"CUS"}, CountryId{"US"}, Tz::America_Denver}, // Columbus Municipal Airport
    Airport{IataCode{"CUT"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Cutral Có Airport
    Airport{IataCode{"CUU"}, CountryId{"MX"}, Tz::America_Chihuahua}, // General Roberto Fierro Villalobos International Airport
    Airport{IataCode{"CUV"}, CountryId{"VE"}, Tz::America_Caracas}, // El Cubo Airport
    Airport{IataCode{"CUY"}, CountryId{"AU"}, Tz::Australia_Perth}, // Cue Airport
    Airport{IataCode{"CUZ"}, CountryId{"PE"}, Tz::America_Lima}, // Alejandro Velasco Astete International Airport
    Airport{IataCode{"CVB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Chungribu Airport
    Airport{IataCode{"CVC"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Cleve Airport
    Airport{IataCode{"CVE"}, CountryId{"CO"}, Tz::America_Bogota}, // Coveñas Airport
    Airport{IataCode{"CVF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Courchevel Airport
    Airport{IataCode{"CVG"}, CountryId{"US"}, Tz::America_New_York}, // Cincinnati/Northern Kentucky International Airport
    Airport{IataCode{"CVH"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Caviahue Airport
    Airport{IataCode{"CVJ"}, CountryId{"MX"}, Tz::America_Mexico_City}, // General Mariano Matamoros Airport
    Airport{IataCode{"CVL"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Cape Vogel Airport
    Airport{IataCode{"CVM"}, CountryId{"MX"}, Tz::America_Monterrey}, // General Pedro J. Méndez International Airport
    Airport{IataCode{"CVN"}, CountryId{"US"}, Tz::America_Denver}, // Clovis Municipal Airport
    Airport{IataCode{"CVO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Corvallis Municipal Airport
    Airport{IataCode{"CVQ"}, CountryId{"AU"}, Tz::Australia_Perth}, // Carnarvon Airport
    Airport{IataCode{"CVT"}, CountryId{"GB"}, Tz::Europe_London}, // Coventry Airport
    Airport{IataCode{"CVU"}, CountryId{"PT"}, Tz::Atlantic_Azores}, // Corvo Airport
    Airport{IataCode{"CWA"}, CountryId{"US"}, Tz::America_Chicago}, // Central Wisconsin Airport
    Airport{IataCode{"CWB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Afonso Pena International Airport
    Airport{IataCode{"CWC"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Chernivtsi International Airport
    Airport{IataCode{"CWI"}, CountryId{"US"}, Tz::America_Chicago}, // Clinton Municipal Airport
    Airport{IataCode{"CWJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Cangyuan Washan Airport
    Airport{IataCode{"CWL"}, CountryId{"GB"}, Tz::Europe_London}, // Cardiff Airport
    Airport{IataCode{"CWS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Center Island Airport
    Airport{IataCode{"CWT"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Cowra Airport
    Airport{IataCode{"CWW"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Corowa Airport
    Airport{IataCode{"CWX"}, CountryId{"US"}, Tz::America_Phoenix}, // Cochise County Airport
    Airport{IataCode{"CXA"}, CountryId{"VE"}, Tz::America_Caracas}, // Caicara del Orinoco Airport
    Airport{IataCode{"CXB"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Cox's Bazar Airport
    Airport{IataCode{"CXF"}, CountryId{"US"}, Tz::America_Anchorage}, // Coldfoot Airport
    Airport{IataCode{"CXI"}, CountryId{"KI"}, Tz::Pacific_Kiritimati}, // Cassidy International Airport
    Airport{IataCode{"CXJ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Caxias do Sul Airport
    Airport{IataCode{"CXL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Calexico International Airport
    Airport{IataCode{"CXM"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Camaxilo Airport
    Airport{IataCode{"CXN"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Candala Airport
    Airport{IataCode{"CXO"}, CountryId{"US"}, Tz::America_Chicago}, // Lone Star Executive Airport
    Airport{IataCode{"CXP"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Tunggul Wulung Airport
    Airport{IataCode{"CXQ"}, CountryId{"AU"}, Tz::Australia_Perth}, // Christmas Creek Airport
    Airport{IataCode{"CXR"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Cam Ranh International Airport
    Airport{IataCode{"CXT"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Charters Towers Airport
    Airport{IataCode{"CXY"}, CountryId{"BS"}, Tz::America_Nassau}, // Cat Cay Airport
    Airport{IataCode{"CYA"}, CountryId{"HT"}, Tz::America_Port_au_Prince}, // Antoine-Simon Airport
    Airport{IataCode{"CYB"}, CountryId{"KY"}, Tz::America_Cayman}, // Charles Kirkconnell International Airport
    Airport{IataCode{"CYC"}, CountryId{"BZ"}, Tz::America_Belize}, // Caye Chapel Airport
    Airport{IataCode{"CYF"}, CountryId{"US"}, Tz::America_Nome}, // Chefornak Airport
    Airport{IataCode{"CYG"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Corryong Airport
    Airport{IataCode{"CYI"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Chiayi Airport
    Airport{IataCode{"CYL"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Coyoles Airport
    Airport{IataCode{"CYO"}, CountryId{"CU"}, Tz::America_Havana}, // Vilo Acuña Airport
    Airport{IataCode{"CYP"}, CountryId{"PH"}, Tz::Asia_Manila}, // Calbayog Airport
    Airport{IataCode{"CYR"}, CountryId{"UY"}, Tz::America_Montevideo}, // Colonia Airport
    Airport{IataCode{"CYS"}, CountryId{"US"}, Tz::America_Denver}, // Cheyenne Regional Airport
    Airport{IataCode{"CYU"}, CountryId{"PH"}, Tz::Asia_Manila}, // Cuyo Airport
    Airport{IataCode{"CYW"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Captain Rogelio Castillo National Airport
    Airport{IataCode{"CYX"}, CountryId{"RU"}, Tz::Asia_Srednekolymsk}, // Chersky Airport
    Airport{IataCode{"CYZ"}, CountryId{"PH"}, Tz::Asia_Manila}, // Cauayan Airport
    Airport{IataCode{"CZA"}, CountryId{"MX"}, Tz::America_Merida}, // Chichen Itza International Airport
    Airport{IataCode{"CZC"}, CountryId{"US"}, Tz::America_Anchorage}, // Copper Center Airport
    Airport{IataCode{"CZE"}, CountryId{"VE"}, Tz::America_Caracas}, // José Leonardo Chirino Airport
    Airport{IataCode{"CZF"}, CountryId{"US"}, Tz::America_Nome}, // Cape Romanzof LRRS Airport
    Airport{IataCode{"CZH"}, CountryId{"BZ"}, Tz::America_Belize}, // Corozal Airport
    Airport{IataCode{"CZJ"}, CountryId{"PA"}, Tz::America_Panama}, // Corazon De Jesus Airport
    Airport{IataCode{"CZK"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Cascade Locks State Airport
    Airport{IataCode{"CZL"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Mohamed Boudiaf International Airport
    Airport{IataCode{"CZM"}, CountryId{"MX"}, Tz::America_Cancun}, // Cozumel International Airport
    Airport{IataCode{"CZN"}, CountryId{"US"}, Tz::America_Anchorage}, // Chisana Airport
    Airport{IataCode{"CZS"}, CountryId{"BR"}, Tz::America_Rio_Branco}, // Cruzeiro do Sul International Airport
    Airport{IataCode{"CZU"}, CountryId{"CO"}, Tz::America_Bogota}, // Las Brujas Airport
    Airport{IataCode{"CZW"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Lądowisko Częstochowa-Rudniki
    Airport{IataCode{"CZX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Changzhou Benniu Airport
    Airport{IataCode{"DAB"}, CountryId{"US"}, Tz::America_New_York}, // Daytona Beach International Airport
    Airport{IataCode{"DAC"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Shahjalal International Airport
    Airport{IataCode{"DAD"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Da Nang International Airport
    Airport{IataCode{"DAG"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Barstow-Daggett Airport
    Airport{IataCode{"DAK"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Dakhla Oasis Airport
    Airport{IataCode{"DAL"}, CountryId{"US"}, Tz::America_Chicago}, // Dallas Love Field
    Airport{IataCode{"DAM"}, CountryId{"SY"}, Tz::Asia_Damascus}, // Damascus International Airport
    Airport{IataCode{"DAN"}, CountryId{"US"}, Tz::America_New_York}, // Danville Regional Airport
    Airport{IataCode{"DAP"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Darchula Airport
    Airport{IataCode{"DAR"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Julius Nyerere International Airport
    Airport{IataCode{"DAS"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Great Bear Lake Airport
    Airport{IataCode{"DAT"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Datong Yungang Airport
    Airport{IataCode{"DAU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Daru Airport
    Airport{IataCode{"DAV"}, CountryId{"PA"}, Tz::America_Panama}, // Enrique Malek International Airport
    Airport{IataCode{"DAX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Dazhou Heshi Airport
    Airport{IataCode{"DAY"}, CountryId{"US"}, Tz::America_New_York}, // Dayton International Airport
    Airport{IataCode{"DAZ"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Darwaz Airport
    Airport{IataCode{"DBA"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Dalbandin Airport
    Airport{IataCode{"DBB"}, CountryId{"EG"}, Tz::Africa_Cairo}, // El Alamein International Airport
    Airport{IataCode{"DBC"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Baicheng Chang'an Airport
    Airport{IataCode{"DBD"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Dhanbad Airport
    Airport{IataCode{"DBM"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Debre Marqos Airport
    Airport{IataCode{"DBN"}, CountryId{"US"}, Tz::America_New_York}, // W. H. 'Bud' Barron Airport
    Airport{IataCode{"DBO"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Dubbo City Airport
    Airport{IataCode{"DBP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Debepare
    Airport{IataCode{"DBQ"}, CountryId{"US"}, Tz::America_Chicago}, // Dubuque Regional Airport
    Airport{IataCode{"DBS"}, CountryId{"US"}, Tz::America_Boise}, // Dubois Municipal Airport
    Airport{IataCode{"DBT"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Debre Tabor Airport
    Airport{IataCode{"DBV"}, CountryId{"HR"}, Tz::Europe_Zagreb}, // Dubrovnik Airport
    Airport{IataCode{"DBY"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Dalby Airport
    Airport{IataCode{"DCA"}, CountryId{"US"}, Tz::America_New_York}, // Ronald Reagan Washington National Airport
    Airport{IataCode{"DCF"}, CountryId{"DM"}, Tz::America_Dominica}, // Canefield Airport
    Airport{IataCode{"DCK"}, CountryId{"US"}, Tz::America_Anchorage}, // Dahl Creek Airport
    Airport{IataCode{"DCM"}, CountryId{"FR"}, Tz::Europe_Paris}, // Castres–Mazamet Airport
    Airport{IataCode{"DCT"}, CountryId{"BS"}, Tz::America_Nassau}, // Duncan Town Airport
    Airport{IataCode{"DCU"}, CountryId{"US"}, Tz::America_Chicago}, // Pryor Field Regional Airport
    Airport{IataCode{"DCY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Daocheng Yading Airport
    Airport{IataCode{"DDC"}, CountryId{"US"}, Tz::America_Chicago}, // Dodge City Regional Airport
    Airport{IataCode{"DDD"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Dhaalu Airport
    Airport{IataCode{"DDG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Dandong Langtou Airport
    Airport{IataCode{"DDM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Dodoima
    Airport{IataCode{"DDU"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Dadu Airport
    Airport{IataCode{"DEA"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Dera Ghazi Khan International Airport
    Airport{IataCode{"DEB"}, CountryId{"HU"}, Tz::Europe_Budapest}, // Debrecen International Airport
    Airport{IataCode{"DEC"}, CountryId{"US"}, Tz::America_Chicago}, // Decatur Airport
    Airport{IataCode{"DED"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jolly Grant Airport
    Airport{IataCode{"DEE"}, CountryId{"RU"}, Tz::Asia_Ust_Nera}, // Mendeleevo Airport
    Airport{IataCode{"DEF"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Dezful Airport
    Airport{IataCode{"DEH"}, CountryId{"US"}, Tz::America_Chicago}, // Decorah Municipal Airport
    Airport{IataCode{"DEI"}, CountryId{"SC"}, Tz::Indian_Mahe}, // Denis Island Airport
    Airport{IataCode{"DEL"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Indira Gandhi International Airport
    Airport{IataCode{"DEM"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Dembidolo Airport
    Airport{IataCode{"DEN"}, CountryId{"US"}, Tz::America_Denver}, // Denver International Airport
    Airport{IataCode{"DEP"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Daporijo Airport
    Airport{IataCode{"DEQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Deqing Moganshan Airport
    Airport{IataCode{"DES"}, CountryId{"SC"}, Tz::Indian_Mahe}, // Desroches Airport
    Airport{IataCode{"DET"}, CountryId{"US"}, Tz::America_Detroit}, // Coleman A. Young International Airport
    Airport{IataCode{"DEZ"}, CountryId{"SY"}, Tz::Asia_Damascus}, // Deir ez-Zor Airport
    Airport{IataCode{"DFI"}, CountryId{"US"}, Tz::America_New_York}, // Defiance Memorial Airport
    Airport{IataCode{"DFW"}, CountryId{"US"}, Tz::America_Chicago}, // Dallas/Fort Worth International Airport
    Airport{IataCode{"DGA"}, CountryId{"BZ"}, Tz::America_Belize}, // Dangriga Airport
    Airport{IataCode{"DGE"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Mudgee Airport
    Airport{IataCode{"DGF"}, CountryId{"CA"}, Tz::America_Vancouver}, // Douglas Lake Airport
    Airport{IataCode{"DGL"}, CountryId{"US"}, Tz::America_Phoenix}, // Douglas Municipal Airport
    Airport{IataCode{"DGO"}, CountryId{"MX"}, Tz::America_Monterrey}, // General Guadalupe Victoria International Airport
    Airport{IataCode{"DGP"}, CountryId{"LV"}, Tz::Europe_Riga}, // Daugavpils International Airport
    Airport{IataCode{"DGR"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Dargaville Aerodrome
    Airport{IataCode{"DGT"}, CountryId{"PH"}, Tz::Asia_Manila}, // Sibulan Airport
    Airport{IataCode{"DGU"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Dedougou Airport
    Airport{IataCode{"DGW"}, CountryId{"US"}, Tz::America_Denver}, // Converse County Airport
    Airport{IataCode{"DHI"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Dhangadhi Airport
    Airport{IataCode{"DHL"}, CountryId{"YE"}, Tz::Asia_Aden}, // Dhala
    Airport{IataCode{"DHM"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Gaggal Airport
    Airport{IataCode{"DHN"}, CountryId{"US"}, Tz::America_Chicago}, // Dothan Regional Airport
    Airport{IataCode{"DHR"}, CountryId{"NL"}, Tz::Europe_Amsterdam}, // De Kooy Airfield
    Airport{IataCode{"DHT"}, CountryId{"US"}, Tz::America_Chicago}, // Dalhart Municipal Airport
    Airport{IataCode{"DIB"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Dibrugarh Airport
    Airport{IataCode{"DIE"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Arrachart Airport
    Airport{IataCode{"DIG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Dêqên Shangri-La Airport
    Airport{IataCode{"DIJ"}, CountryId{"FR"}, Tz::Europe_Paris}, // Dijon-Bourgogne Airport
    Airport{IataCode{"DIK"}, CountryId{"US"}, Tz::America_Denver}, // Dickinson Theodore Roosevelt Regional Airport
    Airport{IataCode{"DIL"}, CountryId{"TL"}, Tz::Asia_Dili}, // Presidente Nicolau Lobato International Airport
    Airport{IataCode{"DIM"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Dimbokro Airport
    Airport{IataCode{"DIN"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Dien Bien Phu Airport
    Airport{IataCode{"DIP"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Diapaga Airport
    Airport{IataCode{"DIQ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Divinópolis Airport
    Airport{IataCode{"DIR"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Aba Tenna Dejazmach Yilma International Airport
    Airport{IataCode{"DIS"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Dolisie Airport
    Airport{IataCode{"DIU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Diu Airport
    Airport{IataCode{"DIV"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Divo Airport
    Airport{IataCode{"DIY"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Diyarbakır Airport
    Airport{IataCode{"DJA"}, CountryId{"BJ"}, Tz::Africa_Porto_Novo}, // Djougou Airport
    Airport{IataCode{"DJB"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Sultan Thaha Airport
    Airport{IataCode{"DJE"}, CountryId{"TN"}, Tz::Africa_Tunis}, // Djerba–Zarzis International Airport
    Airport{IataCode{"DJG"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Djanet Inedbirene Airport
    Airport{IataCode{"DJJ"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Sentani Airport
    Airport{IataCode{"DJM"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Djambala Airport
    Airport{IataCode{"DJN"}, CountryId{"US"}, Tz::America_Anchorage}, // Delta Junction Airport
    Airport{IataCode{"DJO"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Daloa Airport
    Airport{IataCode{"DKA"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Katsina Airport
    Airport{IataCode{"DKI"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Dunk Island Airport
    Airport{IataCode{"DKK"}, CountryId{"US"}, Tz::America_New_York}, // Chautauqua County/Dunkirk Airport
    Airport{IataCode{"DKR"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Léopold Sédar Senghor International Airport
    Airport{IataCode{"DKS"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Dikson Airport
    Airport{IataCode{"DLA"}, CountryId{"CM"}, Tz::Africa_Douala}, // Douala International Airport
    Airport{IataCode{"DLC"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Dalian Zhoushuizi International Airport
    Airport{IataCode{"DLD"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Geilo Airport
    Airport{IataCode{"DLE"}, CountryId{"FR"}, Tz::Europe_Paris}, // Dole–Jura Airport
    Airport{IataCode{"DLG"}, CountryId{"US"}, Tz::America_Anchorage}, // Dillingham Airport
    Airport{IataCode{"DLH"}, CountryId{"US"}, Tz::America_Chicago}, // Duluth International Airport
    Airport{IataCode{"DLI"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Lien Khuong Airport
    Airport{IataCode{"DLL"}, CountryId{"US"}, Tz::America_New_York}, // Dillon County Airport
    Airport{IataCode{"DLM"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Dalaman Airport
    Airport{IataCode{"DLN"}, CountryId{"US"}, Tz::America_Denver}, // Dillon Airport
    Airport{IataCode{"DLS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Columbia Gorge Regional Airport
    Airport{IataCode{"DLU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Dali Airport
    Airport{IataCode{"DLY"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Dillon's Bay Airport
    Airport{IataCode{"DLZ"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Dalanzadgad Airport
    Airport{IataCode{"DMB"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Taraz Airport
    Airport{IataCode{"DMD"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Doomadgee Airport
    Airport{IataCode{"DME"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Domodedovo International Airport
    Airport{IataCode{"DMK"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Don Mueang International Airport
    Airport{IataCode{"DMM"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // King Fahd International Airport
    Airport{IataCode{"DMN"}, CountryId{"US"}, Tz::America_Denver}, // Deming Municipal Airport
    Airport{IataCode{"DMO"}, CountryId{"US"}, Tz::America_Chicago}, // Sedalia Regional Airport
    Airport{IataCode{"DMT"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Diamantino Airport
    Airport{IataCode{"DMU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Dimapur Airport
    Airport{IataCode{"DND"}, CountryId{"GB"}, Tz::Europe_London}, // Dundee Airport
    Airport{IataCode{"DNH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Dunhuang Airport
    Airport{IataCode{"DNI"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Wad Medani Airport
    Airport{IataCode{"DNK"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Dnipropetrovsk International Airport
    Airport{IataCode{"DNL"}, CountryId{"US"}, Tz::America_New_York}, // Daniel Field
    Airport{IataCode{"DNN"}, CountryId{"US"}, Tz::America_New_York}, // Dalton Municipal Airport
    Airport{IataCode{"DNP"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Tribhuvannagar Airport
    Airport{IataCode{"DNQ"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Deniliquin Airport
    Airport{IataCode{"DNR"}, CountryId{"FR"}, Tz::Europe_Paris}, // Dinard–Pleurtuit–Saint-Malo Airport
    Airport{IataCode{"DNS"}, CountryId{"US"}, Tz::America_Chicago}, // Denison Municipal Airport
    Airport{IataCode{"DNU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Dinangat
    Airport{IataCode{"DNV"}, CountryId{"US"}, Tz::America_Chicago}, // Vermilion Regional Airport
    Airport{IataCode{"DNX"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Galegu Airport
    Airport{IataCode{"DOB"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Dobo Airport
    Airport{IataCode{"DOD"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Dodoma Airport
    Airport{IataCode{"DOE"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Djoemoe Airstrip
    Airport{IataCode{"DOG"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Dongola Airport
    Airport{IataCode{"DOH"}, CountryId{"QA"}, Tz::Asia_Qatar}, // Hamad International Airport
    Airport{IataCode{"DOI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Doini
    Airport{IataCode{"DOL"}, CountryId{"FR"}, Tz::Europe_Paris}, // Deauville – Saint-Gatien Airport
    Airport{IataCode{"DOM"}, CountryId{"DM"}, Tz::America_Dominica}, // Douglas–Charles Airport
    Airport{IataCode{"DON"}, CountryId{"GT"}, Tz::America_Guatemala}, // Dos Lagunas Airport
    Airport{IataCode{"DOO"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Dorobisoro
    Airport{IataCode{"DOP"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Dolpa Airport
    Airport{IataCode{"DOR"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Dori Airport
    Airport{IataCode{"DOU"}, CountryId{"BR"}, Tz::America_Campo_Grande}, // Dourados Airport
    Airport{IataCode{"DOY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Dongying Shengli Airport
    Airport{IataCode{"DPA"}, CountryId{"US"}, Tz::America_Chicago}, // DuPage Airport
    Airport{IataCode{"DPL"}, CountryId{"PH"}, Tz::Asia_Manila}, // Dipolog Airport
    Airport{IataCode{"DPO"}, CountryId{"AU"}, Tz::Australia_Hobart}, // Devonport Airport
    Airport{IataCode{"DPS"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Ngurah Rai International Airport
    Airport{IataCode{"DPT"}, CountryId{"RU"}, Tz::Asia_Vladivostok}, // Deputatsky Airport
    Airport{IataCode{"DQA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Daqing Sartu Airport
    Airport{IataCode{"DQH"}, CountryId{"US"}, Tz::America_Anchorage}, // Alpine Airstrip
    Airport{IataCode{"DQM"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Duqm Jaaluni Airport
    Airport{IataCode{"DRA"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Desert Rock Airport
    Airport{IataCode{"DRB"}, CountryId{"AU"}, Tz::Australia_Perth}, // Derby Airport
    Airport{IataCode{"DRC"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Dirico Airport
    Airport{IataCode{"DRE"}, CountryId{"US"}, Tz::America_Detroit}, // Drummond Island Airport
    Airport{IataCode{"DRG"}, CountryId{"US"}, Tz::America_Nome}, // Deering Airport
    Airport{IataCode{"DRH"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Dabra Airport
    Airport{IataCode{"DRI"}, CountryId{"US"}, Tz::America_Chicago}, // Beauregard Regional Airport
    Airport{IataCode{"DRJ"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Drietabbetje Airstrip
    Airport{IataCode{"DRK"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Drake Bay Airport
    Airport{IataCode{"DRN"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Dirranbandi Airport
    Airport{IataCode{"DRO"}, CountryId{"US"}, Tz::America_Denver}, // Durango–La Plata County Airport
    Airport{IataCode{"DRS"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Dresden Airport
    Airport{IataCode{"DRT"}, CountryId{"US"}, Tz::America_Chicago}, // Del Rio International Airport
    Airport{IataCode{"DRV"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Dharavandhoo Airport
    Airport{IataCode{"DSA"}, CountryId{"GB"}, Tz::Europe_London}, // Doncaster Sheffield Airport
    Airport{IataCode{"DSC"}, CountryId{"CM"}, Tz::Africa_Douala}, // Dschang Airport
    Airport{IataCode{"DSD"}, CountryId{"FR"}, Tz::America_Guadeloupe}, // La Désirade Airport
    Airport{IataCode{"DSE"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Combolcha Airport
    Airport{IataCode{"DSI"}, CountryId{"US"}, Tz::America_Chicago}, // Destin Executive Airport
    Airport{IataCode{"DSK"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Dera Ismail Khan Airport
    Airport{IataCode{"DSM"}, CountryId{"US"}, Tz::America_Chicago}, // Des Moines International Airport
    Airport{IataCode{"DSN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Ordos Ejin Horo Airport
    Airport{IataCode{"DSO"}, CountryId{"KP"}, Tz::Asia_Pyongyang}, // Sondok Airport
    Airport{IataCode{"DSS"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Blaise Diagne International Airport
    Airport{IataCode{"DSV"}, CountryId{"US"}, Tz::America_New_York}, // Dansville Municipal Airport
    Airport{IataCode{"DSX"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Dongsha Island Airport
    Airport{IataCode{"DTA"}, CountryId{"US"}, Tz::America_Denver}, // Delta Municipal Airport
    Airport{IataCode{"DTB"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Silangit Airport
    Airport{IataCode{"DTD"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Datadawai Airport
    Airport{IataCode{"DTE"}, CountryId{"PH"}, Tz::Asia_Manila}, // Bagasbas Airport
    Airport{IataCode{"DTH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Furnace Creek Airport
    Airport{IataCode{"DTI"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Diamantina Airport
    Airport{IataCode{"DTL"}, CountryId{"US"}, Tz::America_Chicago}, // Detroit Lakes Airport
    Airport{IataCode{"DTM"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Dortmund Airport
    Airport{IataCode{"DTN"}, CountryId{"US"}, Tz::America_Chicago}, // Shreveport Downtown Airport
    Airport{IataCode{"DTU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Wudalianchi Airport
    Airport{IataCode{"DTW"}, CountryId{"US"}, Tz::America_Detroit}, // Detroit Metropolitan Wayne County Airport
    Airport{IataCode{"DUA"}, CountryId{"US"}, Tz::America_Chicago}, // Durant Regional Airport – Eaker Field
    Airport{IataCode{"DUB"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Dublin Airport
    Airport{IataCode{"DUC"}, CountryId{"US"}, Tz::America_Chicago}, // Halliburton Field (airport)
    Airport{IataCode{"DUD"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Dunedin International Airport
    Airport{IataCode{"DUE"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Dundo Airport
    Airport{IataCode{"DUF"}, CountryId{"US"}, Tz::America_New_York}, // Pine Island Airport
    Airport{IataCode{"DUG"}, CountryId{"US"}, Tz::America_Phoenix}, // Bisbee-Douglas International Airport
    Airport{IataCode{"DUJ"}, CountryId{"US"}, Tz::America_New_York}, // DuBois Regional Airport
    Airport{IataCode{"DUM"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Pinang Kampai Airport
    Airport{IataCode{"DUQ"}, CountryId{"CA"}, Tz::America_Vancouver}, // Duncan Airport
    Airport{IataCode{"DUR"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // King Shaka International Airport
    Airport{IataCode{"DUS"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Düsseldorf Airport
    Airport{IataCode{"DUT"}, CountryId{"US"}, Tz::America_Nome}, // Unalaska Airport
    Airport{IataCode{"DVD"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Andavadoaka Airport
    Airport{IataCode{"DVK"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Diavik Airport
    Airport{IataCode{"DVL"}, CountryId{"US"}, Tz::America_Chicago}, // Devils Lake Regional Airport
    Airport{IataCode{"DVN"}, CountryId{"US"}, Tz::America_Chicago}, // Davenport Municipal Airport
    Airport{IataCode{"DVO"}, CountryId{"PH"}, Tz::Asia_Manila}, // Francisco Bangoy International Airport
    Airport{IataCode{"DVT"}, CountryId{"US"}, Tz::America_Phoenix}, // Phoenix Deer Valley Airport
    Airport{IataCode{"DWA"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Dwangwa Airport
    Airport{IataCode{"DWB"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Soalala Airport
    Airport{IataCode{"DWC"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Al Maktoum International Airport
    Airport{IataCode{"DWD"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Dawadmi Domestic Airport
    Airport{IataCode{"DWH"}, CountryId{"US"}, Tz::America_Chicago}, // David Wayne Hooks Memorial Airport
    Airport{IataCode{"DWS"}, CountryId{"US"}, Tz::America_New_York}, // Walt Disney World Airport
    Airport{IataCode{"DXB"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Dubai International Airport
    Airport{IataCode{"DXE"}, CountryId{"US"}, Tz::America_Chicago}, // Bruce Campbell Field
    Airport{IataCode{"DXR"}, CountryId{"US"}, Tz::America_New_York}, // Danbury Municipal Airport
    Airport{IataCode{"DYA"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Dysart Airport
    Airport{IataCode{"DYG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhangjiajie Hehua Airport
    Airport{IataCode{"DYL"}, CountryId{"US"}, Tz::America_New_York}, // Doylestown Airport
    Airport{IataCode{"DYR"}, CountryId{"RU"}, Tz::Asia_Anadyr}, // Ugolny Airport
    Airport{IataCode{"DYU"}, CountryId{"TJ"}, Tz::Asia_Dushanbe}, // Dushanbe International Airport
    Airport{IataCode{"DZA"}, CountryId{"FR"}, Tz::Indian_Mayotte}, // Dzaoudzi Pamandzi International Airport
    Airport{IataCode{"DZN"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Zhezkazgan Airport
    Airport{IataCode{"DZO"}, CountryId{"UY"}, Tz::America_Montevideo}, // Santa Bernardina International Airport
    Airport{IataCode{"DZU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Dazu
    Airport{IataCode{"EAA"}, CountryId{"US"}, Tz::America_Anchorage}, // Eagle Airport
    Airport{IataCode{"EAB"}, CountryId{"YE"}, Tz::Asia_Aden}, // Abbs Airport
    Airport{IataCode{"EAE"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Siwo Airport
    Airport{IataCode{"EAL"}, CountryId{"MH"}, Tz::Pacific_Kwajalein}, // Elenak Airport
    Airport{IataCode{"EAM"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Najran Domestic Airport
    Airport{IataCode{"EAP"}, CountryId{"FR"}, Tz::Europe_Paris}, // EuroAirport Basel-Mulhouse-Freiburg
    Airport{IataCode{"EAR"}, CountryId{"US"}, Tz::America_Chicago}, // Kearney Regional Airport
    Airport{IataCode{"EAS"}, CountryId{"ES"}, Tz::Europe_Madrid}, // San Sebastián Airport
    Airport{IataCode{"EAT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Pangborn Memorial Airport
    Airport{IataCode{"EAU"}, CountryId{"US"}, Tz::America_Chicago}, // Chippewa Valley Regional Airport
    Airport{IataCode{"EBA"}, CountryId{"IT"}, Tz::Europe_Rome}, // Marina di Campo Airport
    Airport{IataCode{"EBB"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Entebbe International Airport
    Airport{IataCode{"EBD"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // El Obeid Airport
    Airport{IataCode{"EBG"}, CountryId{"CO"}, Tz::America_Bogota}, // El Bagre Airport
    Airport{IataCode{"EBH"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // El Bayadh Airport
    Airport{IataCode{"EBJ"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Esbjerg Airport
    Airport{IataCode{"EBL"}, CountryId{"IQ"}, Tz::Asia_Baghdad}, // Erbil International Airport
    Airport{IataCode{"EBN"}, CountryId{"MH"}, Tz::Pacific_Kwajalein}, // Ebadon aerodrome
    Airport{IataCode{"EBO"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Ebon Airport
    Airport{IataCode{"EBS"}, CountryId{"US"}, Tz::America_Chicago}, // Webster City Municipal Airport
    Airport{IataCode{"EBU"}, CountryId{"FR"}, Tz::Europe_Paris}, // Saint-Étienne – Bouthéon Airport
    Airport{IataCode{"EBW"}, CountryId{"CM"}, Tz::Africa_Douala}, // Ebolowa Airport
    Airport{IataCode{"ECG"}, CountryId{"US"}, Tz::America_New_York}, // Elizabeth City Regional Airport
    Airport{IataCode{"ECH"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Echuca Airport
    Airport{IataCode{"ECI"}, CountryId{"NI"}, Tz::America_Managua}, // Costa Esmeralda Airport
    Airport{IataCode{"ECN"}, CountryId{}, Tz::Asia_Famagusta}, // Ercan International Airport
    Airport{IataCode{"ECP"}, CountryId{"US"}, Tz::America_Chicago}, // Northwest Florida Beaches International Airport
    Airport{IataCode{"ECR"}, CountryId{"CO"}, Tz::America_Bogota}, // El Charco
    Airport{IataCode{"EDB"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // El Debba Airport
    Airport{IataCode{"EDE"}, CountryId{"US"}, Tz::America_New_York}, // Northeastern Regional Airport
    Airport{IataCode{"EDI"}, CountryId{"GB"}, Tz::Europe_London}, // Edinburgh Airport
    Airport{IataCode{"EDK"}, CountryId{"US"}, Tz::America_Chicago}, // El Dorado/Captain Jack Thomas Memorial Airport
    Airport{IataCode{"EDL"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Eldoret International Airport
    Airport{IataCode{"EDM"}, CountryId{"FR"}, Tz::Europe_Paris}, // La Roche-sur-Yon - Les Ajoncs Airport
    Airport{IataCode{"EDO"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Balıkesir Koca Seyit Airport
    Airport{IataCode{"EDQ"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Erandique Airport
    Airport{IataCode{"EDR"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Edward River Airport
    Airport{IataCode{"EED"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Needles Airport
    Airport{IataCode{"EEK"}, CountryId{"US"}, Tz::America_Nome}, // Eek Airport
    Airport{IataCode{"EEN"}, CountryId{"US"}, Tz::America_New_York}, // Dillant–Hopkins Airport
    Airport{IataCode{"EFD"}, CountryId{"US"}, Tz::America_Chicago}, // Ellington International Airport
    Airport{IataCode{"EFG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Efogi Airport
    Airport{IataCode{"EFK"}, CountryId{"US"}, Tz::America_New_York}, // Newport State Airport (Vermont)
    Airport{IataCode{"EFL"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kefalonia International Airport
    Airport{IataCode{"EGA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Engati
    Airport{IataCode{"EGC"}, CountryId{"FR"}, Tz::Europe_Paris}, // Bergerac Dordogne Périgord Airport
    Airport{IataCode{"EGE"}, CountryId{"US"}, Tz::America_Denver}, // Eagle County Regional Airport
    Airport{IataCode{"EGH"}, CountryId{"EG"}, Tz::Africa_Cairo}, // El Gora Airport
    Airport{IataCode{"EGI"}, CountryId{"US"}, Tz::America_Chicago}, // Duke Field
    Airport{IataCode{"EGL"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Neghelle Airport
    Airport{IataCode{"EGM"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Seghe Airport
    Airport{IataCode{"EGN"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Geneina Airport
    Airport{IataCode{"EGO"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Belgorod International Airport
    Airport{IataCode{"EGP"}, CountryId{"US"}, Tz::America_Chicago}, // Maverick County Memorial International Airport
    Airport{IataCode{"EGS"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Egilsstaðir Airport
    Airport{IataCode{"EGV"}, CountryId{"US"}, Tz::America_Chicago}, // Eagle River Union Airport
    Airport{IataCode{"EGX"}, CountryId{"US"}, Tz::America_Anchorage}, // Egegik Airport
    Airport{IataCode{"EHL"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // El Bolsón Airport
    Airport{IataCode{"EHM"}, CountryId{"US"}, Tz::America_Nome}, // Cape Newenham LRRS Airport
    Airport{IataCode{"EIA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Papondetta Airport
    Airport{IataCode{"EIE"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Yeniseysk Airport
    Airport{IataCode{"EIN"}, CountryId{"NL"}, Tz::Europe_Amsterdam}, // Eindhoven Airport
    Airport{IataCode{"EIS"}, CountryId{"GB"}, Tz::America_Tortola}, // Terrance B. Lettsome International Airport
    Airport{IataCode{"EIY"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Ein Yahav Airfield
    Airport{IataCode{"EJA"}, CountryId{"CO"}, Tz::America_Bogota}, // Yariguíes Airport
    Airport{IataCode{"EJH"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Al Wajh Domestic Airport
    Airport{IataCode{"EJN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Ejin Banner Taolai Airport
    Airport{IataCode{"EJT"}, CountryId{"US"}, Tz::Pacific_Majuro}, // Enejit Airport
    Airport{IataCode{"EKA"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Murray Field
    Airport{IataCode{"EKB"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Ekibastuz Airport
    Airport{IataCode{"EKI"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Elkhart Municipal Airport
    Airport{IataCode{"EKO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Elko Regional Airport
    Airport{IataCode{"EKS"}, CountryId{"RU"}, Tz::Asia_Sakhalin}, // Shakhtersk
    Airport{IataCode{"EKT"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Eskilstuna Airport
    Airport{IataCode{"EKX"}, CountryId{"US"}, Tz::America_New_York}, // Elizabethtown Regional Airport
    Airport{IataCode{"ELB"}, CountryId{"CO"}, Tz::America_Bogota}, // El Banco Apt. Airport
    Airport{IataCode{"ELC"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Elcho Island Airport
    Airport{IataCode{"ELD"}, CountryId{"US"}, Tz::America_Chicago}, // South Arkansas Regional Airport at Goodwin Field
    Airport{IataCode{"ELE"}, CountryId{"PA"}, Tz::America_Panama}, // El Real Airport
    Airport{IataCode{"ELF"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // El Fasher Airport
    Airport{IataCode{"ELG"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // El Golea Airport
    Airport{IataCode{"ELH"}, CountryId{"BS"}, Tz::America_Nassau}, // North Eleuthera Airport
    Airport{IataCode{"ELI"}, CountryId{"US"}, Tz::America_Nome}, // Elim Airport
    Airport{IataCode{"ELK"}, CountryId{"US"}, Tz::America_Chicago}, // Elk City Regional Business Airport
    Airport{IataCode{"ELM"}, CountryId{"US"}, Tz::America_New_York}, // Elmira Corning Regional Airport
    Airport{IataCode{"ELN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Bowers Airport
    Airport{IataCode{"ELO"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // El Dorado Airport, Argentina
    Airport{IataCode{"ELP"}, CountryId{"US"}, Tz::America_Denver}, // El Paso International Airport
    Airport{IataCode{"ELQ"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Prince Nayef bin Abdulaziz Regional Airport
    Airport{IataCode{"ELS"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // East London Airport
    Airport{IataCode{"ELT"}, CountryId{"EG"}, Tz::Africa_Cairo}, // El Tor Airport
    Airport{IataCode{"ELU"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Guemar Airport
    Airport{IataCode{"ELV"}, CountryId{"US"}, Tz::America_Juneau}, // Elfin Cove Seaplane Base
    Airport{IataCode{"ELX"}, CountryId{"VE"}, Tz::America_Caracas}, // El Tigre Airport
    Airport{IataCode{"ELY"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Ely Airport
    Airport{IataCode{"ELZ"}, CountryId{"US"}, Tz::America_New_York}, // Wellsville Municipal Airport
    Airport{IataCode{"EMA"}, CountryId{"GB"}, Tz::Europe_London}, // East Midlands Airport
    Airport{IataCode{"EMD"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Emerald Airport
    Airport{IataCode{"EMI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Emirau Airport
    Airport{IataCode{"EMK"}, CountryId{"US"}, Tz::America_Nome}, // Emmonak Airport
    Airport{IataCode{"EMM"}, CountryId{"US"}, Tz::America_Denver}, // Kemmerer Municipal Airport
    Airport{IataCode{"EMN"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Néma Airport
    Airport{IataCode{"EMO"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Emo
    Airport{IataCode{"EMP"}, CountryId{"US"}, Tz::America_Chicago}, // Emporia Municipal Airport
    Airport{IataCode{"EMT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // San Gabriel Valley Airport
    Airport{IataCode{"EMX"}, CountryId{"AR"}, Tz::America_Argentina_Catamarca}, // El Maitén Airport
    Airport{IataCode{"ENA"}, CountryId{"US"}, Tz::America_Anchorage}, // Kenai Municipal Airport
    Airport{IataCode{"ENB"}, CountryId{"AU"}, Tz::Australia_Perth}, // Eneabba Airport
    Airport{IataCode{"ENC"}, CountryId{"FR"}, Tz::Europe_Paris}, // Nancy-Essey Airport
    Airport{IataCode{"ENE"}, CountryId{"ID"}, Tz::Asia_Makassar}, // H. Hasan Aroeboesman Airport
    Airport{IataCode{"ENF"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Enontekiö Airport
    Airport{IataCode{"ENH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Enshi Xujiaping Airport
    Airport{IataCode{"ENI"}, CountryId{"PH"}, Tz::Asia_Manila}, // El Nido Airport
    Airport{IataCode{"ENJ"}, CountryId{"GT"}, Tz::America_Guatemala}, // El Naranjo Airport
    Airport{IataCode{"ENK"}, CountryId{"GB"}, Tz::Europe_London}, // Enniskillen/St Angelo Airport
    Airport{IataCode{"ENL"}, CountryId{"US"}, Tz::America_Chicago}, // Centralia Municipal Airport
    Airport{IataCode{"ENN"}, CountryId{"US"}, Tz::America_Anchorage}, // Nenana Municipal Airport
    Airport{IataCode{"ENO"}, CountryId{"PY"}, Tz::America_Asuncion}, // Teniente Amin Ayub Gonzalez Airport
    Airport{IataCode{"ENS"}, CountryId{"NL"}, Tz::Europe_Amsterdam}, // Enschede Airport Twente
    Airport{IataCode{"ENT"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Enewetak Auxiliary Airfield
    Airport{IataCode{"ENU"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Akanu Ibiam International Airport
    Airport{IataCode{"ENV"}, CountryId{"US"}, Tz::America_Denver}, // Wendover Airport
    Airport{IataCode{"ENW"}, CountryId{"US"}, Tz::America_Chicago}, // Kenosha Regional Airport
    Airport{IataCode{"ENY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yan'an Nanniwan Airport
    Airport{IataCode{"EOH"}, CountryId{"CO"}, Tz::America_Bogota}, // Enrique Olaya Herrera Airport
    Airport{IataCode{"EOK"}, CountryId{"US"}, Tz::America_Chicago}, // Keokuk Municipal Airport
    Airport{IataCode{"EOR"}, CountryId{"VE"}, Tz::America_Caracas}, // El Dorado, Venezuela Airport
    Airport{IataCode{"EOS"}, CountryId{"US"}, Tz::America_Chicago}, // Neosho Hugh Robinson Airport
    Airport{IataCode{"EOZ"}, CountryId{"VE"}, Tz::America_Caracas}, // Elorza Airport
    Airport{IataCode{"EPA"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // El Palomar Airport
    Airport{IataCode{"EPH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Ephrata Municipal Airport
    Airport{IataCode{"EPK"}, CountryId{"CY"}, Tz::Asia_Nicosia}, // Q11824372
    Airport{IataCode{"EPL"}, CountryId{"FR"}, Tz::Europe_Paris}, // Épinal – Mirecourt Airport
    Airport{IataCode{"EPR"}, CountryId{"AU"}, Tz::Australia_Perth}, // Esperance Airport
    Airport{IataCode{"EPS"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // Arroyo Barril Airport
    Airport{IataCode{"EPT"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Eliptamin
    Airport{IataCode{"EPU"}, CountryId{"EE"}, Tz::Europe_Tallinn}, // Pärnu Airport
    Airport{IataCode{"EQS"}, CountryId{"AR"}, Tz::America_Argentina_Catamarca}, // Esquel Airport
    Airport{IataCode{"ERA"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Erigavo Airport
    Airport{IataCode{"ERC"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Erzincan Airport
    Airport{IataCode{"ERD"}, CountryId{"UA"}, Tz::Europe_Zaporozhye}, // Berdyansk Airport
    Airport{IataCode{"ERE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Erave Airport
    Airport{IataCode{"ERF"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Erfurt-Weimar Airport
    Airport{IataCode{"ERG"}, CountryId{"RU"}, Tz::Asia_Irkutsk}, // Erbogachen Airport
    Airport{IataCode{"ERH"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Moulay Ali Cherif Airport
    Airport{IataCode{"ERI"}, CountryId{"US"}, Tz::America_New_York}, // Erie International Airport
    Airport{IataCode{"ERL"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Erenhot Saiwusu International Airport
    Airport{IataCode{"ERM"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Erechim Airport
    Airport{IataCode{"ERN"}, CountryId{"BR"}, Tz::America_Eirunepe}, // Eirunepé Airport
    Airport{IataCode{"ERQ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Elrose Airport
    Airport{IataCode{"ERR"}, CountryId{"US"}, Tz::America_New_York}, // Errol Airport
    Airport{IataCode{"ERS"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Eros Airport
    Airport{IataCode{"ERU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Erume
    Airport{IataCode{"ERV"}, CountryId{"US"}, Tz::America_Chicago}, // Kerrville Municipal Airport
    Airport{IataCode{"ERZ"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Erzurum Airport
    Airport{IataCode{"ESA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Esa'ala Airport
    Airport{IataCode{"ESB"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Ankara Esenboğa Airport
    Airport{IataCode{"ESC"}, CountryId{"US"}, Tz::America_Detroit}, // Delta County Airport
    Airport{IataCode{"ESD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Orcas Island Airport
    Airport{IataCode{"ESG"}, CountryId{"PY"}, Tz::America_Asuncion}, // Dr. Luis María Argaña International Airport
    Airport{IataCode{"ESH"}, CountryId{"GB"}, Tz::Europe_London}, // Brighton City Airport
    Airport{IataCode{"ESL"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Elista Airport
    Airport{IataCode{"ESM"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Colonel Carlos Concha Torres Airport
    Airport{IataCode{"ESN"}, CountryId{"US"}, Tz::America_New_York}, // Easton Airport
    Airport{IataCode{"ESO"}, CountryId{"US"}, Tz::America_Denver}, // Ohkay Owingeh Airport
    Airport{IataCode{"ESP"}, CountryId{"US"}, Tz::America_New_York}, // Stroudsburg-Pocono Airport
    Airport{IataCode{"ESR"}, CountryId{"CL"}, Tz::America_Santiago}, // Ricardo García Posada Airport
    Airport{IataCode{"ESS"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Flughafen Essen/Mülheim
    Airport{IataCode{"ESU"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Mogador Airport
    Airport{IataCode{"ESW"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Easton State Airport
    Airport{IataCode{"ETB"}, CountryId{"US"}, Tz::America_Chicago}, // West Bend Municipal Airport
    Airport{IataCode{"ETH"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Eilat Airport
    Airport{IataCode{"ETM"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Ramon Airport
    Airport{IataCode{"ETR"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Santa Rosa Airport
    Airport{IataCode{"ETS"}, CountryId{"US"}, Tz::America_Chicago}, // Enterprise Municipal Airport
    Airport{IataCode{"ETZ"}, CountryId{"FR"}, Tz::Europe_Paris}, // Metz-Nancy-Lorraine Airport
    Airport{IataCode{"EUA"}, CountryId{"TO"}, Tz::Pacific_Tongatapu}, // 'Eua Airport
    Airport{IataCode{"EUC"}, CountryId{"AU"}, Tz::Australia_Eucla}, // Eucla Airport
    Airport{IataCode{"EUE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Eureka Airport
    Airport{IataCode{"EUF"}, CountryId{"US"}, Tz::America_Chicago}, // Weedon Field
    Airport{IataCode{"EUG"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Eugene Airport
    Airport{IataCode{"EUN"}, CountryId{"MA"}, Tz::Africa_El_Aaiun}, // Hassan I Airport
    Airport{IataCode{"EUQ"}, CountryId{"PH"}, Tz::Asia_Manila}, // Evelio Javier Airport
    Airport{IataCode{"EUX"}, CountryId{"NL"}, Tz::America_Kralendijk}, // F.D. Roosevelt Airport
    Airport{IataCode{"EVE"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Harstad/Narvik Airport
    Airport{IataCode{"EVG"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Härjedalen Sveg Airport
    Airport{IataCode{"EVH"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Evans Head Memorial Aerodrome
    Airport{IataCode{"EVN"}, CountryId{"AM"}, Tz::Asia_Yerevan}, // Zvartnots International Airport
    Airport{IataCode{"EVV"}, CountryId{"US"}, Tz::America_Chicago}, // Evansville Regional Airport
    Airport{IataCode{"EWB"}, CountryId{"US"}, Tz::America_New_York}, // New Bedford Regional Airport
    Airport{IataCode{"EWE"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Ewer Airport
    Airport{IataCode{"EWI"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Enarotali Airport
    Airport{IataCode{"EWK"}, CountryId{"US"}, Tz::America_Chicago}, // Newton City/County Airport
    Airport{IataCode{"EWN"}, CountryId{"US"}, Tz::America_New_York}, // Coastal Carolina Regional Airport
    Airport{IataCode{"EWO"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Ewo Airport
    Airport{IataCode{"EWR"}, CountryId{"US"}, Tz::America_New_York}, // Newark Liberty International Airport
    Airport{IataCode{"EXI"}, CountryId{"US"}, Tz::America_Juneau}, // Excursion Inlet Seaplane Base
    Airport{IataCode{"EXM"}, CountryId{"AU"}, Tz::Australia_Perth}, // Exmouth Gulf Airport
    Airport{IataCode{"EXT"}, CountryId{"GB"}, Tz::Europe_London}, // Exeter International Airport
    Airport{IataCode{"EYK"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Beloyarsk Airport
    Airport{IataCode{"EYL"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Yélimané Airport
    Airport{IataCode{"EYP"}, CountryId{"CO"}, Tz::America_Bogota}, // El Alcaraván Airport
    Airport{IataCode{"EYR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Yerington Municipal Airport
    Airport{IataCode{"EYS"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Eliye Springs Airport
    Airport{IataCode{"EYW"}, CountryId{"US"}, Tz::America_New_York}, // Key West International Airport
    Airport{IataCode{"EZE"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Ministro Pistarini International Airport
    Airport{IataCode{"EZS"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Elazığ Airport
    Airport{IataCode{"FAA"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Faranah Airport
    Airport{IataCode{"FAB"}, CountryId{"GB"}, Tz::Europe_London}, // Farnborough Airport
    Airport{IataCode{"FAC"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Faaite Airport
    Airport{IataCode{"FAE"}, CountryId{"FO"}, Tz::Atlantic_Faroe}, // Vágar Airport
    Airport{IataCode{"FAG"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Fagurhólsmýri Airport
    Airport{IataCode{"FAH"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Farah Airport
    Airport{IataCode{"FAI"}, CountryId{"US"}, Tz::America_Anchorage}, // Fairbanks International Airport
    Airport{IataCode{"FAN"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Farsund Airport
    Airport{IataCode{"FAO"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Faro Airport
    Airport{IataCode{"FAQ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Frieda River Airport
    Airport{IataCode{"FAR"}, CountryId{"US"}, Tz::America_Chicago}, // Hector International Airport
    Airport{IataCode{"FAS"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Fáskrúðsfjörður Airport
    Airport{IataCode{"FAT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Fresno Yosemite International Airport
    Airport{IataCode{"FAV"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Fakarava Airport
    Airport{IataCode{"FAY"}, CountryId{"US"}, Tz::America_New_York}, // Fayetteville Regional Airport
    Airport{IataCode{"FAZ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Fasa Airport
    Airport{IataCode{"FBA"}, CountryId{"BR"}, Tz::America_Manaus}, // Fonte Boa Airport
    Airport{IataCode{"FBD"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Fayzabad Airport
    Airport{IataCode{"FBE"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Francisco Beltrão Airport
    Airport{IataCode{"FBM"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Lubumbashi International Airport
    Airport{IataCode{"FBS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Friday Harbor Seaplane Base
    Airport{IataCode{"FCA"}, CountryId{"US"}, Tz::America_Denver}, // Glacier Park International Airport
    Airport{IataCode{"FCB"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Ficksburg Sentraoes Airport
    Airport{IataCode{"FCH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Fresno Chandler Executive Airport
    Airport{IataCode{"FCM"}, CountryId{"US"}, Tz::America_Chicago}, // Flying Cloud Airport
    Airport{IataCode{"FCN"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Sea-Airport Cuxhaven/Nordholz
    Airport{IataCode{"FCO"}, CountryId{"IT"}, Tz::Europe_Rome}, // Leonardo da Vinci–Fiumicino Airport
    Airport{IataCode{"FCY"}, CountryId{"US"}, Tz::America_Chicago}, // Forrest City Municipal Airport
    Airport{IataCode{"FDE"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Førde Airport
    Airport{IataCode{"FDF"}, CountryId{"FR"}, Tz::America_Martinique}, // Martinique Aimé Césaire International Airport
    Airport{IataCode{"FDH"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Friedrichshafen Airport
    Airport{IataCode{"FDK"}, CountryId{"US"}, Tz::America_New_York}, // Frederick Municipal Airport
    Airport{IataCode{"FDO"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // San Fernando Airport
    Airport{IataCode{"FDR"}, CountryId{"US"}, Tz::America_Chicago}, // Frederick Regional Airport
    Airport{IataCode{"FDU"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Bandundu Airport
    Airport{IataCode{"FDY"}, CountryId{"US"}, Tz::America_New_York}, // Findlay Airport
    Airport{IataCode{"FEB"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Sanfebagar Airport
    Airport{IataCode{"FEG"}, CountryId{"UZ"}, Tz::Asia_Tashkent}, // Fergana International Airport
    Airport{IataCode{"FEJ"}, CountryId{"BR"}, Tz::America_Rio_Branco}, // Feijó Airport
    Airport{IataCode{"FEK"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Ferkessédougou Airport
    Airport{IataCode{"FEN"}, CountryId{"BR"}, Tz::America_Noronha}, // Fernando de Noronha Airport
    Airport{IataCode{"FEP"}, CountryId{"US"}, Tz::America_Chicago}, // Albertus Airport
    Airport{IataCode{"FET"}, CountryId{"US"}, Tz::America_Chicago}, // Fremont Municipal Airport
    Airport{IataCode{"FEZ"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Fes-Saïss Airport
    Airport{IataCode{"FFA"}, CountryId{"US"}, Tz::America_New_York}, // First Flight Airport
    Airport{IataCode{"FFL"}, CountryId{"US"}, Tz::America_Chicago}, // Fairfield Municipal Airport
    Airport{IataCode{"FFM"}, CountryId{"US"}, Tz::America_Chicago}, // Fergus Falls Municipal Airport
    Airport{IataCode{"FFT"}, CountryId{"US"}, Tz::America_New_York}, // Capital City Airport
    Airport{IataCode{"FFU"}, CountryId{"CL"}, Tz::America_Santiago}, // Futaleufu Airport
    Airport{IataCode{"FGD"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Fderik Airport
    Airport{IataCode{"FGI"}, CountryId{"WS"}, Tz::Pacific_Apia}, // Fagali'i Airport
    Airport{IataCode{"FGL"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Fox Glacier Heliport
    Airport{IataCode{"FGU"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Fangatau Airport
    Airport{IataCode{"FHZ"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Fakahina Airport
    Airport{IataCode{"FID"}, CountryId{"US"}, Tz::America_New_York}, // Elizabeth Field
    Airport{IataCode{"FIG"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Fria Airport
    Airport{IataCode{"FIH"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // N'djili Airport
    Airport{IataCode{"FIL"}, CountryId{"US"}, Tz::America_Denver}, // Fillmore Municipal Airport
    Airport{IataCode{"FIN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Finschhafen Airport
    Airport{IataCode{"FIZ"}, CountryId{"AU"}, Tz::Australia_Perth}, // Fitzroy Crossing Airport
    Airport{IataCode{"FJR"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Fujairah International Airport
    Airport{IataCode{"FKB"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Baden Airport
    Airport{IataCode{"FKI"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Bangoka International Airport
    Airport{IataCode{"FKJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Fukui Airport
    Airport{IataCode{"FKL"}, CountryId{"US"}, Tz::America_New_York}, // Venango Regional Airport
    Airport{IataCode{"FKN"}, CountryId{"US"}, Tz::America_New_York}, // Franklin Municipal-John Beverly Rose Airport
    Airport{IataCode{"FKQ"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Fakfak Airport
    Airport{IataCode{"FKS"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Fukushima Airport
    Airport{IataCode{"FLA"}, CountryId{"CO"}, Tz::America_Bogota}, // Gustavo Artunduaga Paredes Airport
    Airport{IataCode{"FLB"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Floriano Airport
    Airport{IataCode{"FLD"}, CountryId{"US"}, Tz::America_Chicago}, // Fond du Lac County Airport
    Airport{IataCode{"FLG"}, CountryId{"US"}, Tz::America_Phoenix}, // Flagstaff Pulliam Airport
    Airport{IataCode{"FLL"}, CountryId{"US"}, Tz::America_New_York}, // Fort Lauderdale–Hollywood International Airport
    Airport{IataCode{"FLN"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Florianópolis International Airport
    Airport{IataCode{"FLO"}, CountryId{"US"}, Tz::America_New_York}, // Florence Regional Airport
    Airport{IataCode{"FLP"}, CountryId{"US"}, Tz::America_Chicago}, // Marion County Regional Airport
    Airport{IataCode{"FLR"}, CountryId{"IT"}, Tz::Europe_Rome}, // Florence Airport, Peretola
    Airport{IataCode{"FLS"}, CountryId{"AU"}, Tz::Australia_Hobart}, // Flinders Island Airport
    Airport{IataCode{"FLT"}, CountryId{"HT"}, Tz::America_Port_au_Prince}, // Phaeton Airport
    Airport{IataCode{"FLU"}, CountryId{"US"}, Tz::America_New_York}, // Flushing Airport
    Airport{IataCode{"FLW"}, CountryId{"PT"}, Tz::Atlantic_Azores}, // Flores Airport
    Airport{IataCode{"FLX"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Fallon Municipal Airport
    Airport{IataCode{"FLY"}, CountryId{"US"}, Tz::America_Denver}, // Meadow Lake Airport
    Airport{IataCode{"FMA"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Formosa International Airport
    Airport{IataCode{"FME"}, CountryId{"US"}, Tz::America_New_York}, // Tipton Airport
    Airport{IataCode{"FMI"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kalemie Airport
    Airport{IataCode{"FMM"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Memmingen Airport
    Airport{IataCode{"FMN"}, CountryId{"US"}, Tz::America_Denver}, // Four Corners Regional Airport
    Airport{IataCode{"FMO"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Münster Osnabrück International Airport
    Airport{IataCode{"FMU"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Florence Municipal Airport
    Airport{IataCode{"FMY"}, CountryId{"US"}, Tz::America_New_York}, // Page Field
    Airport{IataCode{"FNA"}, CountryId{"SL"}, Tz::Africa_Freetown}, // Lungi International Airport
    Airport{IataCode{"FNB"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Neubrandenburg Airport
    Airport{IataCode{"FNC"}, CountryId{"PT"}, Tz::Atlantic_Madeira}, // Madeira Airport
    Airport{IataCode{"FND"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Funadhoo Airport
    Airport{IataCode{"FNE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Fane Airport
    Airport{IataCode{"FNG"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Fada N'gourma Airport
    Airport{IataCode{"FNH"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Fincha Airport
    Airport{IataCode{"FNI"}, CountryId{"FR"}, Tz::Europe_Paris}, // Nîmes-Alès-Camargue-Cévennes Airport
    Airport{IataCode{"FNJ"}, CountryId{"KP"}, Tz::Asia_Pyongyang}, // Pyongyang International Airport
    Airport{IataCode{"FNL"}, CountryId{"US"}, Tz::America_Denver}, // Fort Collins–Loveland Municipal Airport
    Airport{IataCode{"FNR"}, CountryId{"US"}, Tz::America_Juneau}, // Funter Bay Seaplane Base
    Airport{IataCode{"FNT"}, CountryId{"US"}, Tz::America_Detroit}, // Bishop International Airport
    Airport{IataCode{"FNU"}, CountryId{"IT"}, Tz::Europe_Rome}, // Oristano-Fenosu Airport
    Airport{IataCode{"FOC"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Fuzhou Changle International Airport
    Airport{IataCode{"FOD"}, CountryId{"US"}, Tz::America_Chicago}, // Fort Dodge Regional Airport
    Airport{IataCode{"FOG"}, CountryId{"IT"}, Tz::Europe_Rome}, // Foggia "Gino Lisa" Airport
    Airport{IataCode{"FOK"}, CountryId{"US"}, Tz::America_New_York}, // Francis S. Gabreski Airport
    Airport{IataCode{"FON"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // El Tanque Airport
    Airport{IataCode{"FOO"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Kornasoren Airport
    Airport{IataCode{"FOR"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Pinto Martins – Fortaleza International Airport
    Airport{IataCode{"FOS"}, CountryId{"AU"}, Tz::Australia_Perth}, // Forrest Airport
    Airport{IataCode{"FOT"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Forster airport
    Airport{IataCode{"FOU"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Fougamou Airport
    Airport{IataCode{"FOY"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Foya Airport
    Airport{IataCode{"FPO"}, CountryId{"BS"}, Tz::America_Nassau}, // Grand Bahama International Airport
    Airport{IataCode{"FPR"}, CountryId{"US"}, Tz::America_New_York}, // Treasure Coast International Airport
    Airport{IataCode{"FPY"}, CountryId{"US"}, Tz::America_New_York}, // Perry-Foley Airport
    Airport{IataCode{"FRA"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Frankfurt Airport
    Airport{IataCode{"FRB"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Forbes Airport
    Airport{IataCode{"FRC"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Franca Airport
    Airport{IataCode{"FRD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Friday Harbor Airport
    Airport{IataCode{"FRE"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Fera Airport
    Airport{IataCode{"FRG"}, CountryId{"US"}, Tz::America_New_York}, // Republic Airport
    Airport{IataCode{"FRH"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // French Lick Municipal Airport
    Airport{IataCode{"FRJ"}, CountryId{"FR"}, Tz::Europe_Paris}, // Frejus Airport
    Airport{IataCode{"FRK"}, CountryId{"SC"}, Tz::Indian_Mahe}, // Frégate Island Airport
    Airport{IataCode{"FRL"}, CountryId{"IT"}, Tz::Europe_Rome}, // Forlì Airport
    Airport{IataCode{"FRM"}, CountryId{"US"}, Tz::America_Chicago}, // Fairmont Municipal Airport
    Airport{IataCode{"FRO"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Florø Airport
    Airport{IataCode{"FRQ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Feramin Airport
    Airport{IataCode{"FRR"}, CountryId{"US"}, Tz::America_New_York}, // Front Royal-Warren County Airport
    Airport{IataCode{"FRS"}, CountryId{"GT"}, Tz::America_Guatemala}, // Mundo Maya International Airport
    Airport{IataCode{"FRT"}, CountryId{"CL"}, Tz::America_Santiago}, // Frutillar Airport
    Airport{IataCode{"FRU"}, CountryId{"KG"}, Tz::Asia_Bishkek}, // Manas International Airport
    Airport{IataCode{"FRW"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Francistown Airport
    Airport{IataCode{"FRY"}, CountryId{"US"}, Tz::America_New_York}, // Eastern Slopes Regional Airport
    Airport{IataCode{"FSC"}, CountryId{"FR"}, Tz::Europe_Paris}, // Figari Sud-Corse Airport
    Airport{IataCode{"FSD"}, CountryId{"US"}, Tz::America_Chicago}, // Sioux Falls Regional Airport
    Airport{IataCode{"FSK"}, CountryId{"US"}, Tz::America_Chicago}, // Fort Scott Municipal Airport
    Airport{IataCode{"FSM"}, CountryId{"US"}, Tz::America_Chicago}, // Fort Smith Regional Airport
    Airport{IataCode{"FSP"}, CountryId{"FR"}, Tz::America_Miquelon}, // Saint-Pierre Airport
    Airport{IataCode{"FST"}, CountryId{"US"}, Tz::America_Chicago}, // Fort Stockton-Pecos County Airport
    Airport{IataCode{"FSU"}, CountryId{"US"}, Tz::America_Denver}, // Fort Sumner Municipal Airport
    Airport{IataCode{"FSZ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Shizuoka Airport
    Airport{IataCode{"FTA"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Futuna Airport
    Airport{IataCode{"FTE"}, CountryId{"AR"}, Tz::America_Argentina_Rio_Gallegos}, // Comandante Armando Tola International Airport
    Airport{IataCode{"FTI"}, CountryId{"US"}, Tz::Pacific_Pago_Pago}, // Fitiuta Airport
    Airport{IataCode{"FTU"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Tôlanaro Airport
    Airport{IataCode{"FTW"}, CountryId{"US"}, Tz::America_Chicago}, // Fort Worth Meacham International Airport
    Airport{IataCode{"FTX"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Owando Airport
    Airport{IataCode{"FTY"}, CountryId{"US"}, Tz::America_New_York}, // Fulton County Airport
    Airport{IataCode{"FUE"}, CountryId{"ES"}, Tz::Atlantic_Canary}, // Fuerteventura Airport
    Airport{IataCode{"FUG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Fuyang Xiguan Airport
    Airport{IataCode{"FUJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Fukue Airport
    Airport{IataCode{"FUK"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Fukuoka Airport
    Airport{IataCode{"FUL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Fullerton Municipal Airport
    Airport{IataCode{"FUM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Fuma
    Airport{IataCode{"FUN"}, CountryId{"TV"}, Tz::Pacific_Funafuti}, // Funafuti International Airport
    Airport{IataCode{"FUO"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Foshan Shadi Airport
    Airport{IataCode{"FUT"}, CountryId{"FR"}, Tz::Pacific_Wallis}, // Pointe Vele Airport
    Airport{IataCode{"FVM"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Fuvahmulah Airport
    Airport{IataCode{"FWA"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Fort Wayne International Airport
    Airport{IataCode{"FXE"}, CountryId{"US"}, Tz::America_New_York}, // Fort Lauderdale Executive Airport
    Airport{IataCode{"FXO"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Cuamba Airport
    Airport{IataCode{"FXY"}, CountryId{"US"}, Tz::America_Chicago}, // Forest City Municipal Airport
    Airport{IataCode{"FYJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Fuyuan Dongji Airport
    Airport{IataCode{"FYM"}, CountryId{"US"}, Tz::America_Chicago}, // Fayetteville Municipal Airport
    Airport{IataCode{"FYN"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Fuyun Koktokay Airport
    Airport{IataCode{"FYT"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Faya-Largeau Airport
    Airport{IataCode{"FYU"}, CountryId{"US"}, Tz::America_Anchorage}, // Fort Yukon Airport
    Airport{IataCode{"FYV"}, CountryId{"US"}, Tz::America_Chicago}, // Drake Field
    Airport{IataCode{"FZD"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Faizabad Airport
    Airport{IataCode{"FZO"}, CountryId{"GB"}, Tz::Europe_London}, // Bristol Filton Airport
    Airport{IataCode{"GAA"}, CountryId{"CO"}, Tz::America_Bogota}, // Guamal Airport
    Airport{IataCode{"GAB"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Gabbs Airport
    Airport{IataCode{"GAC"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Celaque Airport
    Airport{IataCode{"GAD"}, CountryId{"US"}, Tz::America_Chicago}, // Northeast Alabama Regional Airport
    Airport{IataCode{"GAE"}, CountryId{"TN"}, Tz::Africa_Tunis}, // Gabès – Matmata International Airport
    Airport{IataCode{"GAF"}, CountryId{"TN"}, Tz::Africa_Tunis}, // Gafsa – Ksar International Airport
    Airport{IataCode{"GAG"}, CountryId{"US"}, Tz::America_Chicago}, // Gage Airport
    Airport{IataCode{"GAH"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Gayndah Airport
    Airport{IataCode{"GAI"}, CountryId{"US"}, Tz::America_New_York}, // Montgomery County Airpark
    Airport{IataCode{"GAJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Yamagata Airport
    Airport{IataCode{"GAL"}, CountryId{"US"}, Tz::America_Anchorage}, // Edward G. Pitka Sr. Airport
    Airport{IataCode{"GAM"}, CountryId{"US"}, Tz::America_Nome}, // Gambell Airport
    Airport{IataCode{"GAN"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Gan International Airport
    Airport{IataCode{"GAO"}, CountryId{"CU"}, Tz::America_Havana}, // Mariana Grajales Airport
    Airport{IataCode{"GAP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Gusap Airport
    Airport{IataCode{"GAQ"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Gao International Airport
    Airport{IataCode{"GAR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Garaina
    Airport{IataCode{"GAS"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Garissa Airport
    Airport{IataCode{"GAT"}, CountryId{"FR"}, Tz::Europe_Paris}, // Gap – Tallard Airport
    Airport{IataCode{"GAW"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Gangaw airport
    Airport{IataCode{"GAX"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Gamba Airport
    Airport{IataCode{"GAY"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Gaya Airport
    Airport{IataCode{"GAZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Guasopa Airport
    Airport{IataCode{"GBA"}, CountryId{"GB"}, Tz::Europe_London}, // Cotswold Airport
    Airport{IataCode{"GBB"}, CountryId{"AZ"}, Tz::Asia_Baku}, // Qabala Airport
    Airport{IataCode{"GBC"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Gasuke
    Airport{IataCode{"GBD"}, CountryId{"US"}, Tz::America_Chicago}, // Great Bend Municipal Airport
    Airport{IataCode{"GBE"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Sir Seretse Khama International Airport
    Airport{IataCode{"GBF"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Negarbo
    Airport{IataCode{"GBG"}, CountryId{"US"}, Tz::America_Chicago}, // Galesburg Municipal Airport
    Airport{IataCode{"GBH"}, CountryId{"US"}, Tz::America_Anchorage}, // Galbraith Lake Airport
    Airport{IataCode{"GBI"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Gulbarga Airport
    Airport{IataCode{"GBJ"}, CountryId{"FR"}, Tz::America_Guadeloupe}, // Marie-Galante Airport
    Airport{IataCode{"GBK"}, CountryId{"SL"}, Tz::Africa_Freetown}, // Gbangbatoke Airport
    Airport{IataCode{"GBL"}, CountryId{"AU"}, Tz::Australia_Darwin}, // South Goulburn Island Airport
    Airport{IataCode{"GBM"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Garbaharey Airport
    Airport{IataCode{"GBR"}, CountryId{"US"}, Tz::America_New_York}, // Walter J. Koladza Airport
    Airport{IataCode{"GBT"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Gorgan Airport
    Airport{IataCode{"GBU"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Khashm El Girba Airport
    Airport{IataCode{"GBZ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Great Barrier Aerodrome
    Airport{IataCode{"GCC"}, CountryId{"US"}, Tz::America_Denver}, // Gillette–Campbell County Airport
    Airport{IataCode{"GCH"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Gachsaran Airport
    Airport{IataCode{"GCI"}, CountryId{"GB"}, Tz::Europe_Guernsey}, // Guernsey Airport
    Airport{IataCode{"GCJ"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Grand Central Airport
    Airport{IataCode{"GCK"}, CountryId{"US"}, Tz::America_Chicago}, // Garden City Regional Airport
    Airport{IataCode{"GCM"}, CountryId{"GB"}, Tz::America_Cayman}, // Owen Roberts International Airport
    Airport{IataCode{"GCN"}, CountryId{"US"}, Tz::America_Phoenix}, // Grand Canyon National Park Airport
    Airport{IataCode{"GCT"}, CountryId{"US"}, Tz::America_Phoenix}, // Grand Canyon Bar 10 Airport
    Airport{IataCode{"GCW"}, CountryId{"US"}, Tz::America_Phoenix}, // Grand Canyon West Airport
    Airport{IataCode{"GCY"}, CountryId{"US"}, Tz::America_New_York}, // Greeneville-Greene County Municipal Airport
    Airport{IataCode{"GDC"}, CountryId{"US"}, Tz::America_New_York}, // Donaldson Center Airport
    Airport{IataCode{"GDE"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Gode Airport
    Airport{IataCode{"GDG"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Magdagachi Airport
    Airport{IataCode{"GDJ"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Gandajika Airport
    Airport{IataCode{"GDL"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Miguel Hidalgo y Costilla Guadalajara International Airport
    Airport{IataCode{"GDM"}, CountryId{"US"}, Tz::America_New_York}, // Gardner Municipal Airport
    Airport{IataCode{"GDN"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Gdańsk Lech Wałęsa Airport
    Airport{IataCode{"GDO"}, CountryId{"VE"}, Tz::America_Caracas}, // Guasdualito Airport
    Airport{IataCode{"GDP"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Guadalupe Airport
    Airport{IataCode{"GDQ"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Gondar Airport
    Airport{IataCode{"GDT"}, CountryId{"TC"}, Tz::America_Grand_Turk}, // JAGS McCartney International Airport
    Airport{IataCode{"GDV"}, CountryId{"US"}, Tz::America_Denver}, // Dawson Community Airport
    Airport{IataCode{"GDW"}, CountryId{"US"}, Tz::America_Detroit}, // Gladwin Zettel Memorial Airport
    Airport{IataCode{"GDX"}, CountryId{"RU"}, Tz::Asia_Magadan}, // Sokol Airport
    Airport{IataCode{"GDZ"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Gelendzhik Airport
    Airport{IataCode{"GEA"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Nouméa Magenta Airport
    Airport{IataCode{"GED"}, CountryId{"US"}, Tz::America_New_York}, // Delaware Coastal Airport
    Airport{IataCode{"GEE"}, CountryId{"AU"}, Tz::Australia_Hobart}, // George Town Aerodrome
    Airport{IataCode{"GEL"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Santo Ângelo Airport
    Airport{IataCode{"GEO"}, CountryId{"GY"}, Tz::America_Guyana}, // Cheddi Jagan International Airport
    Airport{IataCode{"GER"}, CountryId{"CU"}, Tz::America_Havana}, // Rafael Cabrera Mustelier Airport
    Airport{IataCode{"GES"}, CountryId{"PH"}, Tz::Asia_Manila}, // General Santos International Airport
    Airport{IataCode{"GET"}, CountryId{"AU"}, Tz::Australia_Perth}, // Geraldton Airport
    Airport{IataCode{"GEV"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Gällivare Airport
    Airport{IataCode{"GEX"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Geelong Airport
    Airport{IataCode{"GFD"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Pope Field
    Airport{IataCode{"GFF"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Griffith Airport
    Airport{IataCode{"GFK"}, CountryId{"US"}, Tz::America_Chicago}, // Grand Forks International Airport
    Airport{IataCode{"GFL"}, CountryId{"US"}, Tz::America_New_York}, // Floyd Bennett Memorial Airport
    Airport{IataCode{"GFN"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Clarence Valley Regional Airport
    Airport{IataCode{"GFO"}, CountryId{"GY"}, Tz::America_Guyana}, // Bartica Airport
    Airport{IataCode{"GFY"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Grootfontein Airport
    Airport{IataCode{"GGC"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Lumbala Airport
    Airport{IataCode{"GGE"}, CountryId{"US"}, Tz::America_New_York}, // Georgetown County Airport
    Airport{IataCode{"GGF"}, CountryId{"BR"}, Tz::America_Santarem}, // Almeirim Airport
    Airport{IataCode{"GGG"}, CountryId{"US"}, Tz::America_Chicago}, // East Texas Regional Airport
    Airport{IataCode{"GGH"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Cianorte Airport
    Airport{IataCode{"GGN"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Gagnoa Airport
    Airport{IataCode{"GGO"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Guiglo Airport
    Airport{IataCode{"GGR"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Garowe International Airport
    Airport{IataCode{"GGS"}, CountryId{"AR"}, Tz::America_Argentina_Rio_Gallegos}, // Gobernador Gregores Airport
    Airport{IataCode{"GGT"}, CountryId{"BS"}, Tz::America_Nassau}, // Exuma International Airport
    Airport{IataCode{"GGW"}, CountryId{"US"}, Tz::America_Denver}, // Glasgow Valley County Airport
    Airport{IataCode{"GHA"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Noumérat – Moufdi Zakaria Airport
    Airport{IataCode{"GHB"}, CountryId{"BS"}, Tz::America_Nassau}, // Governor's Harbour Airport
    Airport{IataCode{"GHC"}, CountryId{"BS"}, Tz::America_Nassau}, // Great Harbour Cay Airport
    Airport{IataCode{"GHE"}, CountryId{"PA"}, Tz::America_Panama}, // Garachiné Airport
    Airport{IataCode{"GHM"}, CountryId{"US"}, Tz::America_Chicago}, // Centerville Municipal Airport
    Airport{IataCode{"GHN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Kwanghan Airfield
    Airport{IataCode{"GHS"}, CountryId{"ID"}, Tz::Asia_Makassar}, // West Kutai Melalan Airport
    Airport{IataCode{"GHT"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Ghat Airport
    Airport{IataCode{"GHU"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Gualeguaychú Airport
    Airport{IataCode{"GIB"}, CountryId{"GB"}, Tz::Europe_Gibraltar}, // Gibraltar International Airport
    Airport{IataCode{"GIC"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Boigu Island Airport
    Airport{IataCode{"GID"}, CountryId{"BI"}, Tz::Africa_Bujumbura}, // Gitega Airport
    Airport{IataCode{"GIF"}, CountryId{"US"}, Tz::America_New_York}, // Winter Haven's Gilbert Airport
    Airport{IataCode{"GIG"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Rio de Janeiro/Galeão – Antonio Carlos Jobim International Airport
    Airport{IataCode{"GII"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Siguiri Airport
    Airport{IataCode{"GIL"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Gilgit Airport
    Airport{IataCode{"GIR"}, CountryId{"CO"}, Tz::America_Bogota}, // Santiago Vila Airport
    Airport{IataCode{"GIS"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Gisborne Airport
    Airport{IataCode{"GIT"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Geita Airport
    Airport{IataCode{"GIZ"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Jizan Regional Airport
    Airport{IataCode{"GJA"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Guanaja Airport
    Airport{IataCode{"GJL"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Jijel Ferhat Abbas Airport
    Airport{IataCode{"GJM"}, CountryId{"BR"}, Tz::America_Porto_Velho}, // Guajará-Mirim Airport
    Airport{IataCode{"GJR"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Gjögur Airport
    Airport{IataCode{"GJT"}, CountryId{"US"}, Tz::America_Denver}, // Grand Junction Regional Airport
    Airport{IataCode{"GKA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Goroka Airport
    Airport{IataCode{"GKD"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Gökçeada Airport
    Airport{IataCode{"GKH"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Gorkha Airport
    Airport{IataCode{"GKK"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Kooddoo Airport
    Airport{IataCode{"GKN"}, CountryId{"US"}, Tz::America_Anchorage}, // Gulkana Airport
    Airport{IataCode{"GKT"}, CountryId{"US"}, Tz::America_New_York}, // Gatlinburg-Pigeon Forge Airport
    Airport{IataCode{"GLA"}, CountryId{"GB"}, Tz::Europe_London}, // Glasgow Airport
    Airport{IataCode{"GLB"}, CountryId{"US"}, Tz::America_Phoenix}, // San Carlos Apache Airport
    Airport{IataCode{"GLD"}, CountryId{"US"}, Tz::America_Denver}, // Goodland Municipal Airport
    Airport{IataCode{"GLE"}, CountryId{"US"}, Tz::America_Chicago}, // Gainesville Municipal Airport
    Airport{IataCode{"GLF"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Golfito Airport
    Airport{IataCode{"GLH"}, CountryId{"US"}, Tz::America_Chicago}, // Mid Delta Regional Airport
    Airport{IataCode{"GLI"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Glen Innes Airport
    Airport{IataCode{"GLK"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Abdullahi Yusuf International Airport
    Airport{IataCode{"GLL"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Gol Airport
    Airport{IataCode{"GLN"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Guelmim Airport
    Airport{IataCode{"GLO"}, CountryId{"GB"}, Tz::Europe_London}, // Gloucestershire Airport
    Airport{IataCode{"GLP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Gulgubip
    Airport{IataCode{"GLR"}, CountryId{"US"}, Tz::America_Detroit}, // Gaylord Regional Airport
    Airport{IataCode{"GLS"}, CountryId{"US"}, Tz::America_Chicago}, // Scholes International Airport at Galveston
    Airport{IataCode{"GLT"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Gladstone Airport
    Airport{IataCode{"GLU"}, CountryId{"BT"}, Tz::Asia_Thimphu}, // Gelephu Airport
    Airport{IataCode{"GLV"}, CountryId{"US"}, Tz::America_Nome}, // Golovin Airport
    Airport{IataCode{"GLW"}, CountryId{"US"}, Tz::America_Chicago}, // Glasgow Municipal Airport
    Airport{IataCode{"GLX"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Garmalamo Airport
    Airport{IataCode{"GMA"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Gemena Airport
    Airport{IataCode{"GMB"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Gambela Airport
    Airport{IataCode{"GMD"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Ben Slimane Airport
    Airport{IataCode{"GME"}, CountryId{"BY"}, Tz::Europe_Minsk}, // Gomel Airport
    Airport{IataCode{"GMI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Gasmata Airport
    Airport{IataCode{"GML"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Gostomel Airport
    Airport{IataCode{"GMM"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Gamboma Airport
    Airport{IataCode{"GMN"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Greymouth Airport
    Airport{IataCode{"GMO"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Gombe Lawanti International Airport
    Airport{IataCode{"GMP"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Gimpo International Airport
    Airport{IataCode{"GMQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Golog Airport
    Airport{IataCode{"GMR"}, CountryId{"FR"}, Tz::Pacific_Gambier}, // Totegegie Airport
    Airport{IataCode{"GMU"}, CountryId{"US"}, Tz::America_New_York}, // Greenville Downtown Airport
    Airport{IataCode{"GMZ"}, CountryId{"ES"}, Tz::Atlantic_Canary}, // La Gomera Airport
    Airport{IataCode{"GNA"}, CountryId{"BY"}, Tz::Europe_Minsk}, // Hrodna Airport
    Airport{IataCode{"GNB"}, CountryId{"FR"}, Tz::Europe_Paris}, // Grenoble-Isère Airport
    Airport{IataCode{"GND"}, CountryId{"GD"}, Tz::America_Grenada}, // Maurice Bishop International Airport
    Airport{IataCode{"GNF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Gansner Field
    Airport{IataCode{"GNI"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Lyudao Airport
    Airport{IataCode{"GNM"}, CountryId{"BR"}, Tz::America_Bahia}, // Guanambi Airport
    Airport{IataCode{"GNN"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Ghinnir Airport
    Airport{IataCode{"GNR"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Dr. Arturo Umberto Illia Airport
    Airport{IataCode{"GNS"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Binaka Airport
    Airport{IataCode{"GNT"}, CountryId{"US"}, Tz::America_Denver}, // Grants-Milan Municipal Airport
    Airport{IataCode{"GNU"}, CountryId{"US"}, Tz::America_Anchorage}, // Goodnews Airport
    Airport{IataCode{"GNV"}, CountryId{"US"}, Tz::America_New_York}, // Gainesville Regional Airport
    Airport{IataCode{"GNY"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Şanlıurfa GAP Airport
    Airport{IataCode{"GNZ"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Ghanzi Airport
    Airport{IataCode{"GOA"}, CountryId{"IT"}, Tz::Europe_Rome}, // Genoa Cristoforo Colombo Airport
    Airport{IataCode{"GOB"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Robe Airport
    Airport{IataCode{"GOC"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Gora
    Airport{IataCode{"GOE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Gonalia
    Airport{IataCode{"GOG"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Gobabis Airport
    Airport{IataCode{"GOH"}, CountryId{"GL"}, Tz::America_Godthab}, // Nuuk Airport
    Airport{IataCode{"GOI"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Dabolim Airport
    Airport{IataCode{"GOJ"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Nizhny Novgorod International Airport
    Airport{IataCode{"GOK"}, CountryId{"US"}, Tz::America_Chicago}, // Guthrie–Edmond Regional Airport
    Airport{IataCode{"GOL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Gold Beach Municipal Airport
    Airport{IataCode{"GOM"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Goma International Airport
    Airport{IataCode{"GOO"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Goondiwindi Airport
    Airport{IataCode{"GOP"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Gorakhpur Airport
    Airport{IataCode{"GOQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Golmud Airport
    Airport{IataCode{"GOR"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Gore Airport
    Airport{IataCode{"GOT"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Gothenburg-Landvetter Airport
    Airport{IataCode{"GOU"}, CountryId{"CM"}, Tz::Africa_Douala}, // Garoua International Airport
    Airport{IataCode{"GOV"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Gove Airport
    Airport{IataCode{"GOZ"}, CountryId{"BG"}, Tz::Europe_Sofia}, // Gorna Oryahovitsa Airport
    Airport{IataCode{"GPA"}, CountryId{"GR"}, Tz::Europe_Athens}, // Araxos Airport
    Airport{IataCode{"GPB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Guarapuava Airport
    Airport{IataCode{"GPD"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Mount Gordon Airport
    Airport{IataCode{"GPI"}, CountryId{"CO"}, Tz::America_Bogota}, // Guapi Airport
    Airport{IataCode{"GPL"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Guápiles Airport
    Airport{IataCode{"GPN"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Garden Point Airport
    Airport{IataCode{"GPO"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // General Pico Airport
    Airport{IataCode{"GPS"}, CountryId{"EC"}, Tz::Pacific_Galapagos}, // Seymour Airport
    Airport{IataCode{"GPT"}, CountryId{"US"}, Tz::America_Chicago}, // Gulfport-Biloxi International Airport
    Airport{IataCode{"GPZ"}, CountryId{"US"}, Tz::America_Chicago}, // Grand Rapids – Itasca County Airport
    Airport{IataCode{"GQQ"}, CountryId{"US"}, Tz::America_New_York}, // Galion Municipal Airport
    Airport{IataCode{"GRB"}, CountryId{"US"}, Tz::America_Chicago}, // Green Bay–Austin Straubel International Airport
    Airport{IataCode{"GRC"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Grand Cess aerodrome
    Airport{IataCode{"GRD"}, CountryId{"US"}, Tz::America_New_York}, // Greenwood County Airport
    Airport{IataCode{"GRE"}, CountryId{"US"}, Tz::America_Chicago}, // Greenville Airport
    Airport{IataCode{"GRG"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Gardez Airport
    Airport{IataCode{"GRH"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Garuahi
    Airport{IataCode{"GRI"}, CountryId{"US"}, Tz::America_Chicago}, // Central Nebraska Regional Airport
    Airport{IataCode{"GRJ"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // George Airport
    Airport{IataCode{"GRK"}, CountryId{"US"}, Tz::America_Chicago}, // Killeen–Fort Hood Regional Airport
    Airport{IataCode{"GRL"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Garasa
    Airport{IataCode{"GRM"}, CountryId{"US"}, Tz::America_Chicago}, // Grand Marais/Cook County Airport
    Airport{IataCode{"GRO"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Girona-Costa Brava Airport
    Airport{IataCode{"GRQ"}, CountryId{"NL"}, Tz::Europe_Amsterdam}, // Groningen Airport Eelde
    Airport{IataCode{"GRR"}, CountryId{"US"}, Tz::America_Detroit}, // Gerald R. Ford International Airport
    Airport{IataCode{"GRS"}, CountryId{"IT"}, Tz::Europe_Rome}, // Grosseto Airport
    Airport{IataCode{"GRU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // São Paulo-Guarulhos International Airport
    Airport{IataCode{"GRV"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Grozny Airport
    Airport{IataCode{"GRW"}, CountryId{"PT"}, Tz::Atlantic_Azores}, // Graciosa Airport
    Airport{IataCode{"GRX"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Federico García Lorca Granada Airport
    Airport{IataCode{"GRY"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Grímsey Airport
    Airport{IataCode{"GRZ"}, CountryId{"AT"}, Tz::Europe_Vienna}, // Graz Airport
    Airport{IataCode{"GSA"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Long Pasia Airport
    Airport{IataCode{"GSC"}, CountryId{"AU"}, Tz::Australia_Perth}, // Gascoyne Junction Airport
    Airport{IataCode{"GSE"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Gothenburg City Airport
    Airport{IataCode{"GSH"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Goshen Municipal Airport
    Airport{IataCode{"GSI"}, CountryId{"FR"}, Tz::America_Cayenne}, // Grand-Santi Airport
    Airport{IataCode{"GSJ"}, CountryId{"GT"}, Tz::America_Guatemala}, // San José Airport
    Airport{IataCode{"GSL"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Taltheilei Narrows Airport
    Airport{IataCode{"GSM"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Dayrestan Airport
    Airport{IataCode{"GSN"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Mount Gunson Airport
    Airport{IataCode{"GSO"}, CountryId{"US"}, Tz::America_New_York}, // Piedmont Triad International Airport
    Airport{IataCode{"GSP"}, CountryId{"US"}, Tz::America_New_York}, // Greenville-Spartanburg International Airport
    Airport{IataCode{"GSQ"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Sharq Al-Owainat Airport
    Airport{IataCode{"GSR"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Gardo Airport
    Airport{IataCode{"GST"}, CountryId{"US"}, Tz::America_Juneau}, // Gustavus Airport
    Airport{IataCode{"GSU"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Gedaref Airport
    Airport{IataCode{"GSV"}, CountryId{"RU"}, Tz::Europe_Saratov}, // Gagarin International Airport
    Airport{IataCode{"GTA"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Gatokae Aerodrome
    Airport{IataCode{"GTB"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Genting Airport
    Airport{IataCode{"GTE"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Groote Eylandt Airport
    Airport{IataCode{"GTF"}, CountryId{"US"}, Tz::America_Denver}, // Great Falls International Airport
    Airport{IataCode{"GTG"}, CountryId{"US"}, Tz::America_Chicago}, // Grantsburg Municipal Airport
    Airport{IataCode{"GTN"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Mount Cook Aerodrome
    Airport{IataCode{"GTO"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Jalaluddin Airport
    Airport{IataCode{"GTP"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Grants Pass Airport
    Airport{IataCode{"GTR"}, CountryId{"US"}, Tz::America_Chicago}, // Golden Triangle Regional Airport
    Airport{IataCode{"GTS"}, CountryId{"AU"}, Tz::Australia_Darwin}, // The Granites Airport
    Airport{IataCode{"GTT"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Georgetown Airport
    Airport{IataCode{"GTY"}, CountryId{"US"}, Tz::America_New_York}, // Gettysburg Regional Airport
    Airport{IataCode{"GTZ"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Grumeti River
    Airport{IataCode{"GUA"}, CountryId{"GT"}, Tz::America_Guatemala}, // La Aurora International Airport
    Airport{IataCode{"GUB"}, CountryId{"MX"}, Tz::America_Tijuana}, // Guerrero Negro Airport
    Airport{IataCode{"GUC"}, CountryId{"US"}, Tz::America_Denver}, // Gunnison–Crested Butte Regional Airport
    Airport{IataCode{"GUD"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Goundam Airport
    Airport{IataCode{"GUF"}, CountryId{"US"}, Tz::America_Chicago}, // Jack Edwards Airport
    Airport{IataCode{"GUG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Guari
    Airport{IataCode{"GUH"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Gunnedah Airport
    Airport{IataCode{"GUI"}, CountryId{"VE"}, Tz::America_Caracas}, // Güiria Airport
    Airport{IataCode{"GUL"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Goulburn Airport
    Airport{IataCode{"GUM"}, CountryId{"US"}, Tz::Pacific_Guam}, // Antonio B. Won Pat International Airport
    Airport{IataCode{"GUP"}, CountryId{"US"}, Tz::America_Denver}, // Gallup Municipal Airport
    Airport{IataCode{"GUQ"}, CountryId{"VE"}, Tz::America_Caracas}, // Guanare Airport
    Airport{IataCode{"GUR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Gurney Airport
    Airport{IataCode{"GUS"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Grissom Aeroplex
    Airport{IataCode{"GUU"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Grundarfjörður Airport
    Airport{IataCode{"GUV"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Mougulu Airport
    Airport{IataCode{"GUW"}, CountryId{"KZ"}, Tz::Asia_Atyrau}, // Atyrau Airport
    Airport{IataCode{"GUY"}, CountryId{"US"}, Tz::America_Chicago}, // Guymon Municipal Airport
    Airport{IataCode{"GUZ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Guarapari Airport
    Airport{IataCode{"GVA"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Geneva International Airport
    Airport{IataCode{"GVI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Green River Airport
    Airport{IataCode{"GVL"}, CountryId{"US"}, Tz::America_New_York}, // Lee Gilmer Memorial Airport
    Airport{IataCode{"GVN"}, CountryId{"RU"}, Tz::Asia_Vladivostok}, // Sovetskaya Gavan - May-Gatka
    Airport{IataCode{"GVR"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Governador Valadares Airport
    Airport{IataCode{"GVT"}, CountryId{"US"}, Tz::America_Chicago}, // Majors Airport
    Airport{IataCode{"GVX"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Gävle-Sandviken Airport
    Airport{IataCode{"GWA"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Gwa Airport
    Airport{IataCode{"GWD"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Gwadar International Airport
    Airport{IataCode{"GWL"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Gwalior Airport
    Airport{IataCode{"GWN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Gnarowein
    Airport{IataCode{"GWO"}, CountryId{"US"}, Tz::America_Chicago}, // Greenwood-Leflore Airport
    Airport{IataCode{"GWT"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Sylt Airport
    Airport{IataCode{"GWW"}, CountryId{"US"}, Tz::America_New_York}, // Wayne Executive Jetport
    Airport{IataCode{"GWY"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Galway Airport
    Airport{IataCode{"GXA"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Beringin Airport
    Airport{IataCode{"GXF"}, CountryId{"YE"}, Tz::Asia_Aden}, // Sayun Airport
    Airport{IataCode{"GXG"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Negage Airport
    Airport{IataCode{"GXH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Gannan Xiahe Airport
    Airport{IataCode{"GXQ"}, CountryId{"CL"}, Tz::America_Santiago}, // Teniente Vidal Airport
    Airport{IataCode{"GXX"}, CountryId{"CM"}, Tz::Africa_Douala}, // Yagoua Airport
    Airport{IataCode{"GXY"}, CountryId{"US"}, Tz::America_Denver}, // Greeley–Weld County Airport
    Airport{IataCode{"GYA"}, CountryId{"BO"}, Tz::America_La_Paz}, // Guayaramerín Airport
    Airport{IataCode{"GYD"}, CountryId{"AZ"}, Tz::Asia_Baku}, // Heydar Aliyev International Airport
    Airport{IataCode{"GYE"}, CountryId{"EC"}, Tz::America_Guayaquil}, // José Joaquín de Olmedo International Airport
    Airport{IataCode{"GYG"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Magan Airport
    Airport{IataCode{"GYI"}, CountryId{"RW"}, Tz::Africa_Kigali}, // Gisenyi Airport
    Airport{IataCode{"GYL"}, CountryId{"AU"}, Tz::Australia_Perth}, // Argyle Airport
    Airport{IataCode{"GYM"}, CountryId{"MX"}, Tz::America_Hermosillo}, // General José María Yáñez International Airport
    Airport{IataCode{"GYN"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Santa Genoveva Airport
    Airport{IataCode{"GYP"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Gympie Airport
    Airport{IataCode{"GYR"}, CountryId{"US"}, Tz::America_Phoenix}, // Phoenix Goodyear Airport
    Airport{IataCode{"GYS"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Guangyuan Panlong Airport
    Airport{IataCode{"GYU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Guyuan Liupanshan Airport
    Airport{IataCode{"GZG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Garzê Gesar Airport
    Airport{IataCode{"GZI"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Ghazni Airport
    Airport{IataCode{"GZO"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Nusatupe Airport
    Airport{IataCode{"GZP"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Antalya Gazipasa-Alanya Airport
    Airport{IataCode{"GZT"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Oğuzeli Airport
    Airport{IataCode{"GZW"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Qazvin Airport
    Airport{IataCode{"HAA"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Hasvik Airport
    Airport{IataCode{"HAB"}, CountryId{"US"}, Tz::America_Chicago}, // Marion County – Rankin Fite Airport
    Airport{IataCode{"HAC"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Hachijojima Airport
    Airport{IataCode{"HAD"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Halmstad Airport
    Airport{IataCode{"HAE"}, CountryId{"KP"}, Tz::Asia_Pyongyang}, // Haeju Airport
    Airport{IataCode{"HAF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Half Moon Bay Airport
    Airport{IataCode{"HAH"}, CountryId{"KM"}, Tz::Indian_Comoro}, // Prince Said Ibrahim International Airport
    Airport{IataCode{"HAJ"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Hannover Airport
    Airport{IataCode{"HAK"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Haikou Meilan International Airport
    Airport{IataCode{"HAL"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Halali aerodrome
    Airport{IataCode{"HAM"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Hamburg Airport
    Airport{IataCode{"HAN"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Noi Bai International Airport
    Airport{IataCode{"HAO"}, CountryId{"US"}, Tz::America_New_York}, // Butler County Regional Airport
    Airport{IataCode{"HAQ"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Hanimaadhoo Airport
    Airport{IataCode{"HAR"}, CountryId{"US"}, Tz::America_New_York}, // Capital City Airport
    Airport{IataCode{"HAS"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Ha'il Regional Airport
    Airport{IataCode{"HAU"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Haugesund Airport, Karmøy
    Airport{IataCode{"HAV"}, CountryId{"CU"}, Tz::America_Havana}, // José Martí International Airport
    Airport{IataCode{"HAW"}, CountryId{"GB"}, Tz::Europe_London}, // Haverfordwest Aerodrome
    Airport{IataCode{"HAY"}, CountryId{"CO"}, Tz::America_Bogota}, // Hacaritama Airport
    Airport{IataCode{"HAZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Hatzfeldthaven
    Airport{IataCode{"HBA"}, CountryId{"AU"}, Tz::Australia_Hobart}, // Hobart International Airport
    Airport{IataCode{"HBE"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Borg El Arab Airport
    Airport{IataCode{"HBG"}, CountryId{"US"}, Tz::America_Chicago}, // Hattiesburg Bobby L. Chain Municipal Airport
    Airport{IataCode{"HBK"}, CountryId{"US"}, Tz::America_Phoenix}, // Holbrook Municipal Airport
    Airport{IataCode{"HBQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Qilian Airport
    Airport{IataCode{"HBR"}, CountryId{"US"}, Tz::America_Chicago}, // Hobart Regional Airport
    Airport{IataCode{"HBU"}, CountryId{"MN"}, Tz::Asia_Hovd}, // Bulgan Airport
    Airport{IataCode{"HBX"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Hubli Airport
    Airport{IataCode{"HCA"}, CountryId{"US"}, Tz::America_Chicago}, // Big Spring McMahon-Wrinkle Airport
    Airport{IataCode{"HCC"}, CountryId{"US"}, Tz::America_New_York}, // Columbia County Airport
    Airport{IataCode{"HCJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Hechi Jinchengjiang Airport
    Airport{IataCode{"HCM"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Eyl Airport
    Airport{IataCode{"HCN"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Hengchun Airport
    Airport{IataCode{"HCQ"}, CountryId{"AU"}, Tz::Australia_Perth}, // Halls Creek Airport
    Airport{IataCode{"HCR"}, CountryId{"US"}, Tz::America_Anchorage}, // Holy Cross Airport
    Airport{IataCode{"HCW"}, CountryId{"US"}, Tz::America_New_York}, // Cheraw Municipal Airport
    Airport{IataCode{"HDD"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Hyderabad Airport
    Airport{IataCode{"HDF"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Heringsdorf Airport
    Airport{IataCode{"HDG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Handan Airport
    Airport{IataCode{"HDK"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Kulhudhuffushi Airport
    Airport{IataCode{"HDM"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Hamadan Airport
    Airport{IataCode{"HDN"}, CountryId{"US"}, Tz::America_Denver}, // Yampa Valley Airport
    Airport{IataCode{"HDY"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Hat Yai International Airport
    Airport{IataCode{"HEA"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Herat International Airport
    Airport{IataCode{"HEE"}, CountryId{"US"}, Tz::America_Chicago}, // Thompson-Robbins Airport
    Airport{IataCode{"HEG"}, CountryId{"US"}, Tz::America_New_York}, // Herlong Recreational Airport
    Airport{IataCode{"HEH"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Heho Airport
    Airport{IataCode{"HEK"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Heihe Aihui Airport
    Airport{IataCode{"HEL"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Helsinki Airport
    Airport{IataCode{"HEO"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Haelogo Airport
    Airport{IataCode{"HER"}, CountryId{"GR"}, Tz::Europe_Athens}, // Heraklion International Airport
    Airport{IataCode{"HES"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Hermiston Municipal Airport
    Airport{IataCode{"HET"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Hohhot Baita International Airport
    Airport{IataCode{"HEZ"}, CountryId{"US"}, Tz::America_Chicago}, // Natchez-Adams County Airport
    Airport{IataCode{"HFA"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Haifa International Airport
    Airport{IataCode{"HFD"}, CountryId{"US"}, Tz::America_New_York}, // Hartford-Brainard Airport
    Airport{IataCode{"HFE"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Hefei Xinqiao International Airport
    Airport{IataCode{"HFF"}, CountryId{"US"}, Tz::America_New_York}, // Camp Mackall
    Airport{IataCode{"HFN"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Hornafjörður Airport
    Airport{IataCode{"HFS"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Hagfors Airport
    Airport{IataCode{"HFT"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Hammerfest Airport
    Airport{IataCode{"HGA"}, CountryId{}, Tz::Africa_Mogadishu}, // Hargeisa International Airport
    Airport{IataCode{"HGD"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Hughenden Airport
    Airport{IataCode{"HGE"}, CountryId{"VE"}, Tz::America_Caracas}, // Higuerote Airport
    Airport{IataCode{"HGH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Hangzhou Xiaoshan International Airport
    Airport{IataCode{"HGI"}, CountryId{"SS"}, Tz::Africa_Juba}, // Paloich Airport
    Airport{IataCode{"HGN"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Mae Hong Son Airport
    Airport{IataCode{"HGO"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Korhogo Airport
    Airport{IataCode{"HGR"}, CountryId{"US"}, Tz::America_New_York}, // Hagerstown Regional Airport
    Airport{IataCode{"HGS"}, CountryId{"SL"}, Tz::Africa_Freetown}, // Hastings Airport
    Airport{IataCode{"HGU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Mount Hagen Airport
    Airport{IataCode{"HHH"}, CountryId{"US"}, Tz::America_New_York}, // Hilton Head Airport
    Airport{IataCode{"HHN"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Frankfurt-Hahn Airport
    Airport{IataCode{"HHQ"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Hua Hin Airport
    Airport{IataCode{"HHR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Hawthorne Municipal Airport
    Airport{IataCode{"HHZ"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Hikueru Airport
    Airport{IataCode{"HIA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Huai'an Lianshui Airport
    Airport{IataCode{"HIB"}, CountryId{"US"}, Tz::America_Chicago}, // Range Regional Airport
    Airport{IataCode{"HID"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Horn Island Airport
    Airport{IataCode{"HIE"}, CountryId{"US"}, Tz::America_New_York}, // Mount Washington Regional Airport
    Airport{IataCode{"HII"}, CountryId{"US"}, Tz::America_Phoenix}, // Lake Havasu City Airport
    Airport{IataCode{"HIJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Hiroshima Airport
    Airport{IataCode{"HIL"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Shilavo Airport
    Airport{IataCode{"HIM"}, CountryId{"LK"}, Tz::Asia_Colombo}, // SLAF Hingurakgoda
    Airport{IataCode{"HIN"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Sacheon Airport
    Airport{IataCode{"HIO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Hillsboro Airport
    Airport{IataCode{"HIR"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Honiara International Airport
    Airport{IataCode{"HIT"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Hivaro
    Airport{IataCode{"HIW"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Hiroshima-Nishi Airport
    Airport{IataCode{"HJJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Huaihua Zhijiang Airport
    Airport{IataCode{"HJR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Khajuraho Airport
    Airport{IataCode{"HJT"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Khujirt Airport
    Airport{IataCode{"HKA"}, CountryId{"US"}, Tz::America_Chicago}, // Blytheville Municipal Airport
    Airport{IataCode{"HKB"}, CountryId{"US"}, Tz::America_Anchorage}, // Healy Lake Airport
    Airport{IataCode{"HKD"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Hakodate Airport
    Airport{IataCode{"HKG"}, CountryId{"CN"}, Tz::Asia_Hong_Kong}, // Hong Kong International Airport
    Airport{IataCode{"HKK"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Hokitika Airport
    Airport{IataCode{"HKN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Hoskins Airport
    Airport{IataCode{"HKS"}, CountryId{"US"}, Tz::America_Chicago}, // Hawkins Field
    Airport{IataCode{"HKT"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Phuket International Airport
    Airport{IataCode{"HKY"}, CountryId{"US"}, Tz::America_New_York}, // Hickory Regional Airport
    Airport{IataCode{"HLA"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Lanseria International Airport
    Airport{IataCode{"HLC"}, CountryId{"US"}, Tz::America_Chicago}, // Hill City Municipal Airport
    Airport{IataCode{"HLD"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Hulunbuir Hailar Airport
    Airport{IataCode{"HLE"}, CountryId{"GB"}, Tz::Atlantic_St_Helena}, // Saint Helena Airport
    Airport{IataCode{"HLF"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Hultsfred Airport
    Airport{IataCode{"HLG"}, CountryId{"US"}, Tz::America_New_York}, // Wheeling Ohio County Airport
    Airport{IataCode{"HLH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Ulanhot Airport
    Airport{IataCode{"HLI"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Hollister Municipal Airport
    Airport{IataCode{"HLJ"}, CountryId{"LT"}, Tz::Europe_Vilnius}, // Barysiai Airport
    Airport{IataCode{"HLM"}, CountryId{"US"}, Tz::America_Detroit}, // Park Township Airport
    Airport{IataCode{"HLN"}, CountryId{"US"}, Tz::America_Denver}, // Helena Regional Airport
    Airport{IataCode{"HLP"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Halim Perdanakusuma Airport
    Airport{IataCode{"HLS"}, CountryId{"AU"}, Tz::Australia_Hobart}, // St Helens Airport
    Airport{IataCode{"HLT"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Hamilton Airport
    Airport{IataCode{"HLW"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Hluhluwe Airport
    Airport{IataCode{"HLZ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Hamilton International Airport
    Airport{IataCode{"HMA"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Khanty-Mansiysk Airport
    Airport{IataCode{"HMB"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Sohag International Airport
    Airport{IataCode{"HME"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Oued Irara–Krim Belkacem Airport
    Airport{IataCode{"HMI"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Hami Airport
    Airport{IataCode{"HMJ"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Khmelnytskyi Airport
    Airport{IataCode{"HMO"}, CountryId{"MX"}, Tz::America_Hermosillo}, // General Ignacio Pesqueira García International Airport
    Airport{IataCode{"HMT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Hemet-Ryan Airport
    Airport{IataCode{"HNA"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Hanamaki Airport
    Airport{IataCode{"HNB"}, CountryId{"US"}, Tz::America_Indiana_Vincennes}, // Huntingburg Airport
    Airport{IataCode{"HNC"}, CountryId{"US"}, Tz::America_New_York}, // Billy Mitchell Airport
    Airport{IataCode{"HND"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Tokyo International Airport
    Airport{IataCode{"HNH"}, CountryId{"US"}, Tz::America_Juneau}, // Hoonah Airport
    Airport{IataCode{"HNI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Heiweni
    Airport{IataCode{"HNL"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Daniel K. Inouye International Airport
    Airport{IataCode{"HNM"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Hana Airport
    Airport{IataCode{"HNN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Honinabi Airport
    Airport{IataCode{"HNO"}, CountryId{"ME"}, Tz::Europe_Podgorica}, // Herceg Novi
    Airport{IataCode{"HNS"}, CountryId{"US"}, Tz::America_Juneau}, // Haines Airport
    Airport{IataCode{"HNY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Hengyang Nanyue Airport
    Airport{IataCode{"HOA"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Hola Airport
    Airport{IataCode{"HOB"}, CountryId{"US"}, Tz::America_Denver}, // Lea County Regional Airport
    Airport{IataCode{"HOD"}, CountryId{"YE"}, Tz::Asia_Aden}, // Hodeida International Airport
    Airport{IataCode{"HOE"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Ban Huoeisay Airport
    Airport{IataCode{"HOF"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Al-Ahsa Domestic Airport
    Airport{IataCode{"HOG"}, CountryId{"CU"}, Tz::America_Havana}, // Frank País Airport
    Airport{IataCode{"HOH"}, CountryId{"AT"}, Tz::Europe_Vienna}, // Hohenems-Dornbirn Airport
    Airport{IataCode{"HOI"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Hao Airport
    Airport{IataCode{"HOK"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Hooker Creek Airport
    Airport{IataCode{"HOM"}, CountryId{"US"}, Tz::America_Anchorage}, // Homer Airport
    Airport{IataCode{"HON"}, CountryId{"US"}, Tz::America_Chicago}, // Huron Regional Airport
    Airport{IataCode{"HOO"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Quang Tri Airport
    Airport{IataCode{"HOR"}, CountryId{"PT"}, Tz::Atlantic_Azores}, // Horta Airport
    Airport{IataCode{"HOS"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Chos Malal Airport
    Airport{IataCode{"HOT"}, CountryId{"US"}, Tz::America_Chicago}, // Memorial Field Airport
    Airport{IataCode{"HOU"}, CountryId{"US"}, Tz::America_Chicago}, // William P. Hobby Airport
    Airport{IataCode{"HOV"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Ørsta-Volda Airport
    Airport{IataCode{"HPA"}, CountryId{"TO"}, Tz::Pacific_Tongatapu}, // Lifuka Island Airport
    Airport{IataCode{"HPB"}, CountryId{"US"}, Tz::America_Nome}, // Hooper Bay Airport
    Airport{IataCode{"HPG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shennongjia Airport
    Airport{IataCode{"HPH"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Cat Bi International Airport
    Airport{IataCode{"HPN"}, CountryId{"US"}, Tz::America_New_York}, // Westchester County Airport
    Airport{IataCode{"HPV"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Princeville Airport
    Airport{IataCode{"HPY"}, CountryId{"US"}, Tz::America_Chicago}, // Baytown Airport
    Airport{IataCode{"HQM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Bowerman Airport
    Airport{IataCode{"HRB"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Harbin Taiping International Airport
    Airport{IataCode{"HRE"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Harare International Airport
    Airport{IataCode{"HRG"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Hurghada International Airport
    Airport{IataCode{"HRI"}, CountryId{"LK"}, Tz::Asia_Colombo}, // Mattala Rajapaksa International Airport
    Airport{IataCode{"HRK"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Kharkiv International Airport
    Airport{IataCode{"HRL"}, CountryId{"US"}, Tz::America_Chicago}, // Valley International Airport
    Airport{IataCode{"HRM"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Hassi R'Mel Airport
    Airport{IataCode{"HRO"}, CountryId{"US"}, Tz::America_Chicago}, // Boone County Airport
    Airport{IataCode{"HRS"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Harrismith Airport
    Airport{IataCode{"HRZ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Horizontina Airport
    Airport{IataCode{"HSC"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shaoguan Guitou Airport
    Airport{IataCode{"HSG"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Saga Airport
    Airport{IataCode{"HSH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Henderson Executive Airport
    Airport{IataCode{"HSI"}, CountryId{"US"}, Tz::America_Chicago}, // Hastings Municipal Airport
    Airport{IataCode{"HSJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhengzhou Shangjie Airport
    Airport{IataCode{"HSK"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Huesca-Pirineos Airport
    Airport{IataCode{"HSM"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Horsham Airport
    Airport{IataCode{"HSN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhoushan Putuoshan Airport
    Airport{IataCode{"HSS"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Hisar Airport
    Airport{IataCode{"HSV"}, CountryId{"US"}, Tz::America_Chicago}, // Huntsville International Airport
    Airport{IataCode{"HTA"}, CountryId{"RU"}, Tz::Asia_Chita}, // Kadala Airport
    Airport{IataCode{"HTG"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Khatanga Airport
    Airport{IataCode{"HTH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Hawthorne Industrial Airport
    Airport{IataCode{"HTI"}, CountryId{"AU"}, Tz::Australia_Lindeman}, // Great Barrier Reef Airport
    Airport{IataCode{"HTL"}, CountryId{"US"}, Tz::America_Detroit}, // Roscommon County – Blodgett Memorial Airport
    Airport{IataCode{"HTM"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Khatgal Airport
    Airport{IataCode{"HTN"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Hotan Airport
    Airport{IataCode{"HTO"}, CountryId{"US"}, Tz::America_New_York}, // East Hampton Airport
    Airport{IataCode{"HTR"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Hateruma Airport
    Airport{IataCode{"HTS"}, CountryId{"US"}, Tz::America_New_York}, // Tri-State Airport
    Airport{IataCode{"HTT"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Huatugou Airport
    Airport{IataCode{"HTU"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Hopetoun Airport
    Airport{IataCode{"HTV"}, CountryId{"US"}, Tz::America_Chicago}, // Huntsville Regional Airport
    Airport{IataCode{"HTW"}, CountryId{"US"}, Tz::America_New_York}, // Lawrence County Airpark
    Airport{IataCode{"HTY"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Hatay Airport
    Airport{IataCode{"HTZ"}, CountryId{"CO"}, Tz::America_Bogota}, // Hato Corozal Airport
    Airport{IataCode{"HUB"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Humbert River Airport
    Airport{IataCode{"HUC"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // Humacao Airport
    Airport{IataCode{"HUD"}, CountryId{"US"}, Tz::America_Chicago}, // Humboldt Municipal Airport
    Airport{IataCode{"HUE"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Humera Airport
    Airport{IataCode{"HUG"}, CountryId{"GT"}, Tz::America_Guatemala}, // Huehuetenango Airport
    Airport{IataCode{"HUH"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Huahine – Fare Airport
    Airport{IataCode{"HUI"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Phu Bai International Airport
    Airport{IataCode{"HUJ"}, CountryId{"US"}, Tz::America_Chicago}, // Stan Stamper Municipal Airport
    Airport{IataCode{"HUK"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Hukuntsi Airport
    Airport{IataCode{"HUL"}, CountryId{"US"}, Tz::America_New_York}, // Houlton International Airport
    Airport{IataCode{"HUM"}, CountryId{"US"}, Tz::America_Chicago}, // Houma-Terrebonne Airport
    Airport{IataCode{"HUN"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Hualien Airport
    Airport{IataCode{"HUO"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Huolinhe Airport
    Airport{IataCode{"HUQ"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Hun Airport
    Airport{IataCode{"HUS"}, CountryId{"US"}, Tz::America_Anchorage}, // Hughes Airport
    Airport{IataCode{"HUT"}, CountryId{"US"}, Tz::America_Chicago}, // Hutchinson Municipal Airport
    Airport{IataCode{"HUU"}, CountryId{"PE"}, Tz::America_Lima}, // Alférez FAP David Figueroa Fernandini Airport
    Airport{IataCode{"HUV"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Hudiksvall Airport
    Airport{IataCode{"HUW"}, CountryId{"BR"}, Tz::America_Manaus}, // Humaitá Airport
    Airport{IataCode{"HUX"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Bahías de Huatulco International Airport
    Airport{IataCode{"HUY"}, CountryId{"GB"}, Tz::Europe_London}, // Humberside Airport
    Airport{IataCode{"HUZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Huizhou Airport
    Airport{IataCode{"HVA"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Analalava Airport
    Airport{IataCode{"HVB"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Hervey Bay Airport
    Airport{IataCode{"HVD"}, CountryId{"MN"}, Tz::Asia_Hovd}, // Khovd Airport
    Airport{IataCode{"HVG"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Honningsvåg Airport, Valan
    Airport{IataCode{"HVK"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Hólmavík Airport
    Airport{IataCode{"HVN"}, CountryId{"US"}, Tz::America_New_York}, // Tweed-New Haven Regional Airport
    Airport{IataCode{"HVR"}, CountryId{"US"}, Tz::America_Denver}, // Havre City-County Airport
    Airport{IataCode{"HVS"}, CountryId{"US"}, Tz::America_New_York}, // Hartsville Regional Airport
    Airport{IataCode{"HWA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Hawabango
    Airport{IataCode{"HWN"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Hwange National Park Airport
    Airport{IataCode{"HWO"}, CountryId{"US"}, Tz::America_New_York}, // North Perry Airport
    Airport{IataCode{"HXD"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Delingha Airport
    Airport{IataCode{"HXX"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Hay Airport
    Airport{IataCode{"HYA"}, CountryId{"US"}, Tz::America_New_York}, // Barnstable Municipal Airport
    Airport{IataCode{"HYC"}, CountryId{"GB"}, Tz::Europe_London}, // Wycombe Air Park
    Airport{IataCode{"HYD"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Rajiv Gandhi International Airport
    Airport{IataCode{"HYF"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Hayfields Airport
    Airport{IataCode{"HYG"}, CountryId{"US"}, Tz::America_Sitka}, // Hydaburg Seaplane Base
    Airport{IataCode{"HYL"}, CountryId{"US"}, Tz::America_Sitka}, // Hollis Seaplane Base
    Airport{IataCode{"HYN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Taizhou Luqiao Airport
    Airport{IataCode{"HYR"}, CountryId{"US"}, Tz::America_Chicago}, // Sawyer County Airport
    Airport{IataCode{"HYS"}, CountryId{"US"}, Tz::America_Chicago}, // Hays Regional Airport
    Airport{IataCode{"HZG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Hanzhong Chenggu Airport
    Airport{IataCode{"HZH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Liping Airport
    Airport{IataCode{"HZK"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Húsavík Airport
    Airport{IataCode{"HZL"}, CountryId{"US"}, Tz::America_New_York}, // Hazleton Municipal Airport
    Airport{IataCode{"HZP"}, CountryId{"CA"}, Tz::America_Edmonton}, // Fort MacKay/Horizon Airport
    Airport{IataCode{"IAA"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Igarka Airport
    Airport{IataCode{"IAD"}, CountryId{"US"}, Tz::America_New_York}, // Washington Dulles International Airport
    Airport{IataCode{"IAG"}, CountryId{"US"}, Tz::America_New_York}, // Niagara Falls International Airport
    Airport{IataCode{"IAH"}, CountryId{"US"}, Tz::America_Chicago}, // George Bush Intercontinental Airport
    Airport{IataCode{"IAM"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // In Aménas Airport
    Airport{IataCode{"IAN"}, CountryId{"US"}, Tz::America_Anchorage}, // Bob Baker Memorial Airport
    Airport{IataCode{"IAO"}, CountryId{"PH"}, Tz::Asia_Manila}, // Sayak Airport
    Airport{IataCode{"IAR"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Tunoshna Airport
    Airport{IataCode{"IAS"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Iași International Airport
    Airport{IataCode{"IBA"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Ibadan Airport
    Airport{IataCode{"IBE"}, CountryId{"CO"}, Tz::America_Bogota}, // Perales Airport
    Airport{IataCode{"IBI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Iboki
    Airport{IataCode{"IBL"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Indigo Bay Lodge Airport
    Airport{IataCode{"IBP"}, CountryId{"PE"}, Tz::America_Lima}, // Iberia Airport
    Airport{IataCode{"IBZ"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Ibiza Airport
    Airport{IataCode{"ICA"}, CountryId{"VE"}, Tz::America_Caracas}, // Icabaru Airport
    Airport{IataCode{"ICC"}, CountryId{"VE"}, Tz::America_Caracas}, // Andrés Miguel Salazar Marcano Airport
    Airport{IataCode{"ICI"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Cicia Airport
    Airport{IataCode{"ICK"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Majoor Henry Fernandes Airport
    Airport{IataCode{"ICN"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Incheon International Airport
    Airport{IataCode{"ICR"}, CountryId{"CU"}, Tz::America_Havana}, // Nicaro Airport
    Airport{IataCode{"ICT"}, CountryId{"US"}, Tz::America_Chicago}, // Wichita Dwight D. Eisenhower National Airport
    Airport{IataCode{"ICY"}, CountryId{"US"}, Tz::America_Anchorage}, // Icy Bay Airport
    Airport{IataCode{"IDA"}, CountryId{"US"}, Tz::America_Boise}, // Idaho Falls Regional Airport
    Airport{IataCode{"IDF"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Idiofa Airport
    Airport{IataCode{"IDH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Idaho County Airport
    Airport{IataCode{"IDI"}, CountryId{"US"}, Tz::America_New_York}, // Indiana County-Jimmy Stewart Airport
    Airport{IataCode{"IDP"}, CountryId{"US"}, Tz::America_Chicago}, // Independence Municipal Airport
    Airport{IataCode{"IDR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Devi Ahilyabai Holkar Airport
    Airport{IataCode{"IDY"}, CountryId{"FR"}, Tz::Europe_Paris}, // Île d'Yeu Aerodrome
    Airport{IataCode{"IEG"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Zielona Góra Airport
    Airport{IataCode{"IEJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Iejima Airport
    Airport{IataCode{"IEV"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Kyiv Zhuliany International Airport
    Airport{IataCode{"IFJ"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Ísafjörður Airport
    Airport{IataCode{"IFL"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Innisfail Airport
    Airport{IataCode{"IFN"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Isfahan International Airport
    Airport{IataCode{"IFO"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Ivano-Frankivsk International Airport
    Airport{IataCode{"IFP"}, CountryId{"US"}, Tz::America_Phoenix}, // Laughlin/Bullhead International Airport
    Airport{IataCode{"IGA"}, CountryId{"BS"}, Tz::America_Nassau}, // Inagua Airport
    Airport{IataCode{"IGB"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Ingeniero Jacobacci Airport
    Airport{IataCode{"IGD"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Iğdır Airport
    Airport{IataCode{"IGE"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Tchongorove Airport
    Airport{IataCode{"IGG"}, CountryId{"US"}, Tz::America_Anchorage}, // Igiugig Airport
    Airport{IataCode{"IGH"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Ingham Airport
    Airport{IataCode{"IGM"}, CountryId{"US"}, Tz::America_Phoenix}, // Kingman Airport
    Airport{IataCode{"IGN"}, CountryId{"PH"}, Tz::Asia_Manila}, // Maria Cristina Airport
    Airport{IataCode{"IGO"}, CountryId{"CO"}, Tz::America_Bogota}, // Chigorodó Airport
    Airport{IataCode{"IGR"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Cataratas del Iguazú International Airport
    Airport{IataCode{"IGT"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Magas Airport
    Airport{IataCode{"IGU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Foz do Iguaçu International Airport
    Airport{IataCode{"IHC"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Inhaca Airport
    Airport{IataCode{"IHN"}, CountryId{"YE"}, Tz::Asia_Aden}, // Qishn Airport
    Airport{IataCode{"IHO"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Ihosy Airport
    Airport{IataCode{"IHR"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Iranshahr Airport
    Airport{IataCode{"IHU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Ihu Airport
    Airport{IataCode{"IIA"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Inishmaan Aerodrome
    Airport{IataCode{"IIL"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Ilam Airport
    Airport{IataCode{"IIS"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Nissan Island Airport
    Airport{IataCode{"IJK"}, CountryId{"RU"}, Tz::Europe_Samara}, // Izhevsk Airport
    Airport{IataCode{"IJU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Ijuí Airport
    Airport{IataCode{"IKA"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Tehran Imam Khomeini International Airport
    Airport{IataCode{"IKB"}, CountryId{"US"}, Tz::America_New_York}, // Wilkes County Airport
    Airport{IataCode{"IKI"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Iki Airport
    Airport{IataCode{"IKK"}, CountryId{"US"}, Tz::America_Chicago}, // Greater Kankakee Airport
    Airport{IataCode{"IKL"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Ikela Airport
    Airport{IataCode{"IKS"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Tiksi Airport
    Airport{IataCode{"IKT"}, CountryId{"RU"}, Tz::Asia_Irkutsk}, // Irkutsk International Airport
    Airport{IataCode{"IKU"}, CountryId{"KG"}, Tz::Asia_Bishkek}, // Tamchy Airport
    Airport{IataCode{"ILD"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Lleida-Alguaire Airport
    Airport{IataCode{"ILE"}, CountryId{"US"}, Tz::America_Chicago}, // Skylark Field
    Airport{IataCode{"ILF"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Ilford Airport
    Airport{IataCode{"ILG"}, CountryId{"US"}, Tz::America_New_York}, // New Castle Airport
    Airport{IataCode{"ILI"}, CountryId{"US"}, Tz::America_Anchorage}, // Iliamna Airport
    Airport{IataCode{"ILK"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Atsinanana Airport
    Airport{IataCode{"ILL"}, CountryId{"US"}, Tz::America_Chicago}, // Willmar Municipal Airport
    Airport{IataCode{"ILM"}, CountryId{"US"}, Tz::America_New_York}, // Wilmington International Airport
    Airport{IataCode{"ILN"}, CountryId{"US"}, Tz::America_New_York}, // Wilmington Air Park
    Airport{IataCode{"ILO"}, CountryId{"PH"}, Tz::Asia_Manila}, // Iloilo International Airport
    Airport{IataCode{"ILP"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Île des Pins Airport
    Airport{IataCode{"ILQ"}, CountryId{"PE"}, Tz::America_Lima}, // Ilo Airport
    Airport{IataCode{"ILR"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Ilorin International Airport
    Airport{IataCode{"ILS"}, CountryId{"SV"}, Tz::America_El_Salvador}, // Ilopango International Airport
    Airport{IataCode{"ILU"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Kilaguni Airport
    Airport{IataCode{"ILX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Ileg
    Airport{IataCode{"ILY"}, CountryId{"GB"}, Tz::Europe_London}, // Islay Airport
    Airport{IataCode{"ILZ"}, CountryId{"SK"}, Tz::Europe_Bratislava}, // Žilina Airport
    Airport{IataCode{"IMA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Iamalele
    Airport{IataCode{"IMB"}, CountryId{"GY"}, Tz::America_Guyana}, // Imbaimadai Airport
    Airport{IataCode{"IMI"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Ine Airport
    Airport{IataCode{"IMK"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Simikot Airport
    Airport{IataCode{"IMM"}, CountryId{"US"}, Tz::America_New_York}, // Immokalee Airport
    Airport{IataCode{"IMO"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Zemio Airport
    Airport{IataCode{"IMP"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Imperatriz Airport
    Airport{IataCode{"IMQ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Maku International Airport
    Airport{IataCode{"IMS"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Madison Municipal Airport
    Airport{IataCode{"IMT"}, CountryId{"US"}, Tz::America_Menominee}, // Ford Airport
    Airport{IataCode{"INA"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Inta Airport
    Airport{IataCode{"INB"}, CountryId{"BZ"}, Tz::America_Belize}, // Independence Airport (Belize)
    Airport{IataCode{"INC"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yinchuan Hedong International Airport
    Airport{IataCode{"IND"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Indianapolis International Airport
    Airport{IataCode{"INE"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Chinde Airport
    Airport{IataCode{"INF"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // In Guezzam Airport
    Airport{IataCode{"INH"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Inhambane Airport
    Airport{IataCode{"INI"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Niš Constantine the Great Airport
    Airport{IataCode{"INJ"}, CountryId{"US"}, Tz::America_Chicago}, // Hillsboro Municipal Airport
    Airport{IataCode{"INK"}, CountryId{"US"}, Tz::America_Chicago}, // Winkler County Airport
    Airport{IataCode{"INL"}, CountryId{"US"}, Tz::America_Chicago}, // Falls International Airport
    Airport{IataCode{"INN"}, CountryId{"AT"}, Tz::Europe_Vienna}, // Innsbruck Airport
    Airport{IataCode{"INO"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Inongo Airport
    Airport{IataCode{"INQ"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Inisheer Aerodrome
    Airport{IataCode{"INT"}, CountryId{"US"}, Tz::America_New_York}, // Smith Reynolds Airport
    Airport{IataCode{"INU"}, CountryId{"NR"}, Tz::Pacific_Nauru}, // Nauru International Airport
    Airport{IataCode{"INV"}, CountryId{"GB"}, Tz::Europe_London}, // Inverness Airport
    Airport{IataCode{"INW"}, CountryId{"US"}, Tz::America_Phoenix}, // Winslow-Lindbergh Regional Airport
    Airport{IataCode{"INZ"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // In Salah Airport
    Airport{IataCode{"IOA"}, CountryId{"GR"}, Tz::Europe_Athens}, // Ioannina National Airport
    Airport{IataCode{"IOM"}, CountryId{"IM"}, Tz::Europe_Isle_of_Man}, // Isle of Man Airport
    Airport{IataCode{"ION"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Impfondo Airport
    Airport{IataCode{"IOR"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Inishmore Aerodrome
    Airport{IataCode{"IOS"}, CountryId{"BR"}, Tz::America_Bahia}, // Ilhéus Jorge Amado Airport
    Airport{IataCode{"IOW"}, CountryId{"US"}, Tz::America_Chicago}, // Iowa City Municipal Airport
    Airport{IataCode{"IPA"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Ipota Airport
    Airport{IataCode{"IPC"}, CountryId{"CL"}, Tz::Pacific_Easter}, // Mataveri International Airport
    Airport{IataCode{"IPE"}, CountryId{"PH"}, Tz::Asia_Manila}, // Ipil Airport
    Airport{IataCode{"IPG"}, CountryId{"BR"}, Tz::America_Manaus}, // Ipiranga Airport
    Airport{IataCode{"IPH"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Sultan Azlan Shah Airport
    Airport{IataCode{"IPI"}, CountryId{"CO"}, Tz::America_Bogota}, // San Luis Airport
    Airport{IataCode{"IPL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Imperial County Airport
    Airport{IataCode{"IPN"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Ipatinga Airport
    Airport{IataCode{"IPT"}, CountryId{"US"}, Tz::America_New_York}, // Williamsport Regional Airport
    Airport{IataCode{"IQN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Qingyang Airport
    Airport{IataCode{"IQQ"}, CountryId{"CL"}, Tz::America_Santiago}, // Diego Aracena International Airport
    Airport{IataCode{"IQT"}, CountryId{"PE"}, Tz::America_Lima}, // Crnl. FAP Francisco Secada Vignetta International Airport
    Airport{IataCode{"IRA"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Kirakira Airport
    Airport{IataCode{"IRC"}, CountryId{"US"}, Tz::America_Anchorage}, // Circle City Airport
    Airport{IataCode{"IRD"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Ishurdi Airport
    Airport{IataCode{"IRG"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Lockhart River Airport
    Airport{IataCode{"IRI"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Iringa Airport
    Airport{IataCode{"IRJ"}, CountryId{"AR"}, Tz::America_Argentina_La_Rioja}, // Capitán Vicente Almandos Almonacid Airport
    Airport{IataCode{"IRK"}, CountryId{"US"}, Tz::America_Chicago}, // Kirksville Regional Airport
    Airport{IataCode{"IRN"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Iriona
    Airport{IataCode{"IRO"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Birao Airport
    Airport{IataCode{"IRP"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Matari Airport
    Airport{IataCode{"IRZ"}, CountryId{"BR"}, Tz::America_Manaus}, // Tapuruquara Airport
    Airport{IataCode{"ISA"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Mount Isa Airport
    Airport{IataCode{"ISB"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Islamabad International Airport
    Airport{IataCode{"ISC"}, CountryId{"GB"}, Tz::Europe_London}, // St Mary's Airport
    Airport{IataCode{"ISE"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Isparta Süleyman Demirel Airport
    Airport{IataCode{"ISG"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // New Ishigaki Airport
    Airport{IataCode{"ISI"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Isisford Airport
    Airport{IataCode{"ISJ"}, CountryId{"MX"}, Tz::America_Cancun}, // Isla Mujeres Airport
    Airport{IataCode{"ISK"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Ozar Airport
    Airport{IataCode{"ISL"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Atatürk International Airport
    Airport{IataCode{"ISM"}, CountryId{"US"}, Tz::America_New_York}, // Kissimmee Gateway Airport
    Airport{IataCode{"ISO"}, CountryId{"US"}, Tz::America_New_York}, // Kinston Regional Jetport
    Airport{IataCode{"ISP"}, CountryId{"US"}, Tz::America_New_York}, // Long Island MacArthur Airport
    Airport{IataCode{"ISQ"}, CountryId{"US"}, Tz::America_Detroit}, // Schoolcraft County Airport
    Airport{IataCode{"ISS"}, CountryId{"US"}, Tz::America_New_York}, // Wiscasset Airport
    Airport{IataCode{"IST"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Istanbul Airport
    Airport{IataCode{"ISU"}, CountryId{"IQ"}, Tz::Asia_Baghdad}, // Sulaimaniyah International Airport
    Airport{IataCode{"ISW"}, CountryId{"US"}, Tz::America_Chicago}, // South Wood County Airport
    Airport{IataCode{"ITA"}, CountryId{"BR"}, Tz::America_Manaus}, // Itacoatiara Airport
    Airport{IataCode{"ITB"}, CountryId{"BR"}, Tz::America_Santarem}, // Itaituba Airport
    Airport{IataCode{"ITH"}, CountryId{"US"}, Tz::America_New_York}, // Ithaca Tompkins Regional Airport
    Airport{IataCode{"ITK"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Itokama
    Airport{IataCode{"ITM"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Osaka International Airport
    Airport{IataCode{"ITO"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Hilo International Airport
    Airport{IataCode{"ITQ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Itaqui Airport
    Airport{IataCode{"ITR"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Itumbiara Airport
    Airport{IataCode{"ITU"}, CountryId{"RU"}, Tz::Asia_Ust_Nera}, // Iturup Airport
    Airport{IataCode{"IUE"}, CountryId{"NU"}, Tz::Pacific_Niue}, // Niue International Airport
    Airport{IataCode{"IUS"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Inus Airport
    Airport{IataCode{"IVA"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Ambanja Airport
    Airport{IataCode{"IVC"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Invercargill Airport
    Airport{IataCode{"IVL"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Ivalo Airport
    Airport{IataCode{"IVR"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Inverell Airport
    Airport{IataCode{"IWA"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Ivanovo Yuzhny Airport
    Airport{IataCode{"IWD"}, CountryId{"US"}, Tz::America_Menominee}, // Gogebic-Iron County Airport
    Airport{IataCode{"IWJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Iwami Airport
    Airport{IataCode{"IWS"}, CountryId{"US"}, Tz::America_Chicago}, // West Houston Airport
    Airport{IataCode{"IXA"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Agartala Airport
    Airport{IataCode{"IXB"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Bagdogra Airport
    Airport{IataCode{"IXD"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Allahabad Airport
    Airport{IataCode{"IXE"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Mangalore Airport
    Airport{IataCode{"IXG"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Belgaum Airport
    Airport{IataCode{"IXH"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kailashahar Airport
    Airport{IataCode{"IXI"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Lilabari Airport
    Airport{IataCode{"IXJ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jammu Airport
    Airport{IataCode{"IXK"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Keshod Airport
    Airport{IataCode{"IXL"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kushok Bakula Rimpochee Airport
    Airport{IataCode{"IXM"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Madurai International Airport
    Airport{IataCode{"IXN"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Khowai Airport
    Airport{IataCode{"IXP"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Pathankot Airport
    Airport{IataCode{"IXQ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kamalpur Airport
    Airport{IataCode{"IXR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Birsa Munda Airport
    Airport{IataCode{"IXS"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Silchar Airport
    Airport{IataCode{"IXT"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Pasighat Airport
    Airport{IataCode{"IXU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Aurangabad Airport
    Airport{IataCode{"IXV"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Along Airport
    Airport{IataCode{"IXW"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Sonari Airport
    Airport{IataCode{"IXY"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kandla Airport
    Airport{IataCode{"IXZ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Veer Savarkar International Airport
    Airport{IataCode{"IYK"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Inyokern Airport
    Airport{IataCode{"IZA"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Zona da Mata Regional Airport
    Airport{IataCode{"IZL"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Izmail International Airport
    Airport{IataCode{"IZO"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Izumo Airport
    Airport{IataCode{"JAA"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Jalalabad Airport
    Airport{IataCode{"JAB"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Jabiru Airport
    Airport{IataCode{"JAC"}, CountryId{"US"}, Tz::America_Denver}, // Jackson Hole Airport
    Airport{IataCode{"JAD"}, CountryId{"AU"}, Tz::Australia_Perth}, // Jandakot Airport
    Airport{IataCode{"JAE"}, CountryId{"PE"}, Tz::America_Lima}, // Shumba Airport
    Airport{IataCode{"JAI"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jaipur International  Airport
    Airport{IataCode{"JAK"}, CountryId{"HT"}, Tz::America_Port_au_Prince}, // Jacmel Airport
    Airport{IataCode{"JAL"}, CountryId{"MX"}, Tz::America_Mexico_City}, // El Lencero Airport
    Airport{IataCode{"JAN"}, CountryId{"US"}, Tz::America_Chicago}, // Jackson-Evers International Airport
    Airport{IataCode{"JAP"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Chacarita Airport
    Airport{IataCode{"JAQ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Jacquinot Bay Airport
    Airport{IataCode{"JAR"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Jahrom Airport
    Airport{IataCode{"JAT"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Jabot Airport
    Airport{IataCode{"JAU"}, CountryId{"PE"}, Tz::America_Lima}, // Francisco Carle Airport
    Airport{IataCode{"JAV"}, CountryId{"GL"}, Tz::America_Godthab}, // Ilulissat Airport
    Airport{IataCode{"JAX"}, CountryId{"US"}, Tz::America_New_York}, // Jacksonville International Airport
    Airport{IataCode{"JBB"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Notohadinegoro Airport
    Airport{IataCode{"JBQ"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // La Isabela International Airport
    Airport{IataCode{"JBR"}, CountryId{"US"}, Tz::America_Chicago}, // Jonesboro Municipal Airport
    Airport{IataCode{"JBS"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // São Borja Airport
    Airport{IataCode{"JBT"}, CountryId{"US"}, Tz::America_Anchorage}, // Bethel Seaplane Base
    Airport{IataCode{"JCB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Joaçaba Airport
    Airport{IataCode{"JCI"}, CountryId{"US"}, Tz::America_Chicago}, // New Century AirCenter
    Airport{IataCode{"JCK"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Julia Creek Airport
    Airport{IataCode{"JCU"}, CountryId{"ES"}, Tz::Africa_Ceuta}, // Ceuta Heliport
    Airport{IataCode{"JDA"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Grant County Regional Airport
    Airport{IataCode{"JDF"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Juiz de Fora Airport
    Airport{IataCode{"JDG"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Jungseok Airport
    Airport{IataCode{"JDH"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jodhpur Airport
    Airport{IataCode{"JDN"}, CountryId{"US"}, Tz::America_Denver}, // Jordan Airport
    Airport{IataCode{"JDO"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Juazeiro do Norte Airport
    Airport{IataCode{"JDZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jingdezhen Luojia Airport
    Airport{IataCode{"JED"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // King Abdulaziz International Airport
    Airport{IataCode{"JEE"}, CountryId{"HT"}, Tz::America_Port_au_Prince}, // Jérémie Airport
    Airport{IataCode{"JEF"}, CountryId{"US"}, Tz::America_Chicago}, // Jefferson City Memorial Airport
    Airport{IataCode{"JEG"}, CountryId{"GL"}, Tz::America_Godthab}, // Aasiaat Airport
    Airport{IataCode{"JEJ"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Jeh Airport
    Airport{IataCode{"JEQ"}, CountryId{"BR"}, Tz::America_Bahia}, // Jequié Airport
    Airport{IataCode{"JER"}, CountryId{"JE"}, Tz::Europe_Jersey}, // Jersey Airport
    Airport{IataCode{"JFK"}, CountryId{"US"}, Tz::America_New_York}, // John F. Kennedy International Airport
    Airport{IataCode{"JFN"}, CountryId{"US"}, Tz::America_New_York}, // Northeast Ohio Regional Airport
    Airport{IataCode{"JFR"}, CountryId{"GL"}, Tz::America_Godthab}, // Paamiut Airport
    Airport{IataCode{"JGA"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jamnagar Airport
    Airport{IataCode{"JGB"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jagdalpur Airport
    Airport{IataCode{"JGD"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jiagedaqi Airport
    Airport{IataCode{"JGN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jiayuguan Airport
    Airport{IataCode{"JGS"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jinggangshan Airport
    Airport{IataCode{"JHB"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Senai International Airport
    Airport{IataCode{"JHG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xishuangbanna Gasa International Airport
    Airport{IataCode{"JHL"}, CountryId{"CA"}, Tz::America_Edmonton}, // Fort MacKay/Albian Aerodrome
    Airport{IataCode{"JHM"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Kapalua Airport
    Airport{IataCode{"JHQ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Whitsunday Airport
    Airport{IataCode{"JHS"}, CountryId{"GL"}, Tz::America_Godthab}, // Sisimiut Airport
    Airport{IataCode{"JHW"}, CountryId{"US"}, Tz::America_New_York}, // Chautauqua County-Jamestown Airport
    Airport{IataCode{"JIA"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Juína Airport
    Airport{IataCode{"JIB"}, CountryId{"DJ"}, Tz::Africa_Djibouti}, // Djibouti-Ambouli International Airport
    Airport{IataCode{"JIC"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jinchang Jinchuan Airport
    Airport{IataCode{"JIJ"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Jijiga Airport
    Airport{IataCode{"JIK"}, CountryId{"GR"}, Tz::Europe_Athens}, // Ikaria Island National Airport
    Airport{IataCode{"JIM"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Aba Segud Airport
    Airport{IataCode{"JIN"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Jinja Airport
    Airport{IataCode{"JIO"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Moa Airport
    Airport{IataCode{"JIP"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Jipijapa Airport
    Airport{IataCode{"JIQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Qianjiang Wulingshan Airport
    Airport{IataCode{"JIR"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Jiri Airport
    Airport{IataCode{"JIU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jiujiang Lushan Airport
    Airport{IataCode{"JIW"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Jiwani Airport
    Airport{IataCode{"JJI"}, CountryId{"PE"}, Tz::America_Lima}, // Juanjuí Airport
    Airport{IataCode{"JJM"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Mulika Lodge Airport
    Airport{IataCode{"JJN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Quanzhou Jinjiang Airport
    Airport{IataCode{"JKG"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Jönköping Airport
    Airport{IataCode{"JKH"}, CountryId{"GR"}, Tz::Europe_Athens}, // Chios Island National Airport
    Airport{IataCode{"JKL"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kalymnos Island National Airport
    Airport{IataCode{"JKR"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Janakpur Airport
    Airport{IataCode{"JKV"}, CountryId{"US"}, Tz::America_Chicago}, // Cherokee County Airport
    Airport{IataCode{"JLN"}, CountryId{"US"}, Tz::America_Chicago}, // Joplin Regional Airport
    Airport{IataCode{"JLR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jabalpur Airport
    Airport{IataCode{"JMB"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Jamba Airport
    Airport{IataCode{"JMJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Lancang Airport
    Airport{IataCode{"JMK"}, CountryId{"GR"}, Tz::Europe_Athens}, // Mykonos Island National Airport
    Airport{IataCode{"JMO"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Jomsom Airport
    Airport{IataCode{"JMS"}, CountryId{"US"}, Tz::America_Chicago}, // Jamestown Regional Airport
    Airport{IataCode{"JMU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jiamusi Dongjiao Airport
    Airport{IataCode{"JNA"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Januaria Airport
    Airport{IataCode{"JNB"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // OR Tambo International Airport
    Airport{IataCode{"JNG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jining Qufu Airport
    Airport{IataCode{"JNI"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Junín Airport
    Airport{IataCode{"JNU"}, CountryId{"US"}, Tz::America_Juneau}, // Juneau International Airport
    Airport{IataCode{"JNX"}, CountryId{"GR"}, Tz::Europe_Athens}, // Naxos Island National Airport
    Airport{IataCode{"JNZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jinzhou Bay Airport
    Airport{IataCode{"JOE"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Joensuu Airport
    Airport{IataCode{"JOG"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Adisucipto International Airport
    Airport{IataCode{"JOI"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Joinville-Lauro Carneiro de Loyola Airport
    Airport{IataCode{"JOJ"}, CountryId{"CA"}, Tz::America_Cambridge_Bay}, // Doris Lake Aerodrome
    Airport{IataCode{"JOK"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Yoshkar-Ola Airport
    Airport{IataCode{"JOL"}, CountryId{"PH"}, Tz::Asia_Manila}, // Jolo Airport
    Airport{IataCode{"JOS"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Yakubu Gowon Airport
    Airport{IataCode{"JOT"}, CountryId{"US"}, Tz::America_Chicago}, // Joliet Regional Airport
    Airport{IataCode{"JPA"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Presidente Castro Pinto International Airport
    Airport{IataCode{"JPR"}, CountryId{"BR"}, Tz::America_Porto_Velho}, // Ji-Paraná Airport
    Airport{IataCode{"JQA"}, CountryId{"GL"}, Tz::America_Godthab}, // Qaarsut Airport
    Airport{IataCode{"JQE"}, CountryId{"PA"}, Tz::America_Panama}, // Jaqué Airport
    Airport{IataCode{"JRF"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Kalaeloa Airport
    Airport{IataCode{"JRG"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jharsuguda Airport
    Airport{IataCode{"JRH"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jorhat Airport
    Airport{IataCode{"JRN"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Juruena Airport
    Airport{IataCode{"JRO"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Kilimanjaro International Airport
    Airport{IataCode{"JSA"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jaisalmer Airport
    Airport{IataCode{"JSH"}, CountryId{"GR"}, Tz::Europe_Athens}, // Sitia Public Airport
    Airport{IataCode{"JSI"}, CountryId{"GR"}, Tz::Europe_Athens}, // Skiathos Island National Airport
    Airport{IataCode{"JSJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jiansanjiang Shidi Airport
    Airport{IataCode{"JSM"}, CountryId{"AR"}, Tz::America_Argentina_Catamarca}, // José de San Martín Airport
    Airport{IataCode{"JSR"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Jessore Airport
    Airport{IataCode{"JST"}, CountryId{"US"}, Tz::America_New_York}, // Johnstown–Cambria County Airport
    Airport{IataCode{"JSU"}, CountryId{"GL"}, Tz::America_Godthab}, // Maniitsoq Airport
    Airport{IataCode{"JSY"}, CountryId{"GR"}, Tz::Europe_Athens}, // Syros Island National Airport
    Airport{IataCode{"JTC"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Bauru-Arealva Airport
    Airport{IataCode{"JTI"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Jataí Airport
    Airport{IataCode{"JTR"}, CountryId{"GR"}, Tz::Europe_Athens}, // Santorini (Thira) National Airport
    Airport{IataCode{"JTY"}, CountryId{"GR"}, Tz::Europe_Athens}, // Astypalaia Island National Airport
    Airport{IataCode{"JUA"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Juara Airport
    Airport{IataCode{"JUB"}, CountryId{"SS"}, Tz::Africa_Juba}, // Juba International Airport
    Airport{IataCode{"JUH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Chizhou Jiuhuashan Airport
    Airport{IataCode{"JUJ"}, CountryId{"AR"}, Tz::America_Argentina_Jujuy}, // Gobernador Horacio Guzmán International Airport
    Airport{IataCode{"JUL"}, CountryId{"PE"}, Tz::America_Lima}, // Inca Manco Cápac International Airport
    Airport{IataCode{"JUM"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Jumla Airport
    Airport{IataCode{"JUR"}, CountryId{"AU"}, Tz::Australia_Perth}, // Jurien Bay Airport
    Airport{IataCode{"JUT"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Jutigalpa airport
    Airport{IataCode{"JUV"}, CountryId{"GL"}, Tz::America_Godthab}, // Upernavik Airport
    Airport{IataCode{"JUZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Quzhou Airport
    Airport{IataCode{"JVA"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Ankavandra Airport
    Airport{IataCode{"JVI"}, CountryId{"US"}, Tz::America_New_York}, // Central Jersey Regional Airport
    Airport{IataCode{"JVL"}, CountryId{"US"}, Tz::America_Chicago}, // Southern Wisconsin Regional Airport
    Airport{IataCode{"JWA"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Jwaneng Airport
    Airport{IataCode{"JWN"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Zanjan Airport
    Airport{IataCode{"JXA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jixi Xingkaihu Airport
    Airport{IataCode{"JXN"}, CountryId{"US"}, Tz::America_Detroit}, // Jackson County Airport
    Airport{IataCode{"JYR"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Jiroft Airport
    Airport{IataCode{"JYV"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Jyväskylä Airport
    Airport{IataCode{"JZH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jiuzhai Huanglong Airport
    Airport{IataCode{"KAA"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Kasama Airport
    Airport{IataCode{"KAB"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Kariba Airport
    Airport{IataCode{"KAC"}, CountryId{"SY"}, Tz::Asia_Damascus}, // Qamishli Airport
    Airport{IataCode{"KAD"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Kaduna Airport
    Airport{IataCode{"KAE"}, CountryId{"US"}, Tz::America_Sitka}, // Kake Seaplane Base
    Airport{IataCode{"KAF"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Karato Airport
    Airport{IataCode{"KAI"}, CountryId{"GY"}, Tz::America_Guyana}, // Kaieteur International Airport
    Airport{IataCode{"KAJ"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Kajaani Airport
    Airport{IataCode{"KAL"}, CountryId{"US"}, Tz::America_Anchorage}, // Kaltag Airport
    Airport{IataCode{"KAM"}, CountryId{"YE"}, Tz::Asia_Aden}, // Kamaran Airport
    Airport{IataCode{"KAN"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Mallam Aminu Kano International Airport
    Airport{IataCode{"KAO"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Kuusamo Airport
    Airport{IataCode{"KAP"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kapanga Airport
    Airport{IataCode{"KAR"}, CountryId{"GY"}, Tz::America_Guyana}, // Kamarang Airport
    Airport{IataCode{"KAS"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Karasburg Airport
    Airport{IataCode{"KAT"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Kaitaia Airport
    Airport{IataCode{"KAU"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Kauhava Airfield
    Airport{IataCode{"KAV"}, CountryId{"VE"}, Tz::America_Caracas}, // Kavanayén Airport
    Airport{IataCode{"KAW"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Kawthaung Airport
    Airport{IataCode{"KAX"}, CountryId{"AU"}, Tz::Australia_Perth}, // Kalbarri Airport
    Airport{IataCode{"KAY"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Wakaya Island Airport
    Airport{IataCode{"KAZ"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Kuabang Airport
    Airport{IataCode{"KBA"}, CountryId{"SL"}, Tz::Africa_Freetown}, // Kabala Airport
    Airport{IataCode{"KBC"}, CountryId{"US"}, Tz::America_Anchorage}, // Birch Creek Airport
    Airport{IataCode{"KBG"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Kabalega Falls Airport
    Airport{IataCode{"KBI"}, CountryId{"CM"}, Tz::Africa_Douala}, // Kribi Airport
    Airport{IataCode{"KBL"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Hamid Karzai International Airport
    Airport{IataCode{"KBM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kabwum Airport
    Airport{IataCode{"KBN"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Tunta Airport
    Airport{IataCode{"KBO"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kabalo Airport
    Airport{IataCode{"KBP"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Boryspil International Airport
    Airport{IataCode{"KBQ"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Kasungu Airport
    Airport{IataCode{"KBR"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Sultan Ismail Petra Airport
    Airport{IataCode{"KBS"}, CountryId{"SL"}, Tz::Africa_Freetown}, // Bo Airport
    Airport{IataCode{"KBU"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Gusti Syamsir Alam Airport
    Airport{IataCode{"KBV"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Krabi Airport
    Airport{IataCode{"KBW"}, CountryId{"US"}, Tz::America_Anchorage}, // Chignik Bay Seaplane Base
    Airport{IataCode{"KBX"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Q25470163
    Airport{IataCode{"KBY"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Streaky Bay Airport
    Airport{IataCode{"KBZ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Kaikoura Aerodrome
    Airport{IataCode{"KCA"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Kuqa Qiuci Airport
    Airport{IataCode{"KCB"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Tepoe Airstrip
    Airport{IataCode{"KCF"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Kadanwari Airport
    Airport{IataCode{"KCH"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Kuching International Airport
    Airport{IataCode{"KCK"}, CountryId{"RU"}, Tz::Asia_Irkutsk}, // Kirensk Airport
    Airport{IataCode{"KCL"}, CountryId{"US"}, Tz::America_Anchorage}, // Chignik Lagoon Airport
    Airport{IataCode{"KCM"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Kahramanmaraş Airport
    Airport{IataCode{"KCQ"}, CountryId{"US"}, Tz::America_Anchorage}, // Chignik Lake Airport
    Airport{IataCode{"KCT"}, CountryId{"LK"}, Tz::Asia_Colombo}, // SLAF Koggala
    Airport{IataCode{"KCU"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Masindi Airport
    Airport{IataCode{"KCZ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kōchi Airport
    Airport{IataCode{"KDB"}, CountryId{"AU"}, Tz::Australia_Perth}, // Kambalda Airport
    Airport{IataCode{"KDC"}, CountryId{"BJ"}, Tz::Africa_Porto_Novo}, // Kandi Airport
    Airport{IataCode{"KDD"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Khuzdar Airport
    Airport{IataCode{"KDE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Koroba Airport
    Airport{IataCode{"KDH"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Kandahar International Airport
    Airport{IataCode{"KDI"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Haluoleo Airport
    Airport{IataCode{"KDJ"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Ndjolé Ville Airport
    Airport{IataCode{"KDK"}, CountryId{"US"}, Tz::America_Anchorage}, // Kodiak Municipal Airport
    Airport{IataCode{"KDL"}, CountryId{"EE"}, Tz::Europe_Tallinn}, // Kärdla Airport
    Airport{IataCode{"KDM"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Kaadedhdhoo Airport
    Airport{IataCode{"KDN"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Ndendé Airport
    Airport{IataCode{"KDO"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Kadhdhoo Airport
    Airport{IataCode{"KDP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kandep Airport
    Airport{IataCode{"KDQ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kamberatoro Airport
    Airport{IataCode{"KDR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kandrian Airport
    Airport{IataCode{"KDU"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Skardu Airport
    Airport{IataCode{"KDV"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Vunisea Airport
    Airport{IataCode{"KDX"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Kadugli Airport
    Airport{IataCode{"KDY"}, CountryId{"RU"}, Tz::Asia_Khandyga}, // Teply Klyuch Airport
    Airport{IataCode{"KEB"}, CountryId{"US"}, Tz::America_Anchorage}, // Nanwalek Airport
    Airport{IataCode{"KED"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Kaédi Airport
    Airport{IataCode{"KEE"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Kelle Airport
    Airport{IataCode{"KEF"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Keflavík Airport
    Airport{IataCode{"KEG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Keglsugl Airport
    Airport{IataCode{"KEH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Kenmore Air Harbor
    Airport{IataCode{"KEJ"}, CountryId{"RU"}, Tz::Asia_Novokuznetsk}, // Kemerovo International Airport
    Airport{IataCode{"KEK"}, CountryId{"US"}, Tz::America_Anchorage}, // Ekwok Airport
    Airport{IataCode{"KEM"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Kemi-Tornio Airport
    Airport{IataCode{"KEN"}, CountryId{"SL"}, Tz::Africa_Freetown}, // Kenema Airport
    Airport{IataCode{"KEO"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Odienné Airport
    Airport{IataCode{"KEP"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Nepalgunj Airport
    Airport{IataCode{"KER"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Kerman Airport
    Airport{IataCode{"KES"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Kelsey Airport
    Airport{IataCode{"KET"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Kengtung Airport
    Airport{IataCode{"KEW"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Keewaywin Airport
    Airport{IataCode{"KEX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kanabea Airport
    Airport{IataCode{"KEY"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Kericho Airport
    Airport{IataCode{"KFA"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Kiffa Airport
    Airport{IataCode{"KFE"}, CountryId{"AU"}, Tz::Australia_Perth}, // Fortescue Dave Forrest Airport
    Airport{IataCode{"KFG"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Kalkgurung Airport
    Airport{IataCode{"KFP"}, CountryId{"US"}, Tz::America_Nome}, // False Pass Airport
    Airport{IataCode{"KFS"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Kastamonu Airport
    Airport{IataCode{"KGA"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kananga Airport
    Airport{IataCode{"KGB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Konge
    Airport{IataCode{"KGC"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Kingscote Airport
    Airport{IataCode{"KGD"}, CountryId{"RU"}, Tz::Europe_Kaliningrad}, // Khrabrovo Airport
    Airport{IataCode{"KGE"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Kaghau Airport
    Airport{IataCode{"KGF"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Sary-Arka Airport
    Airport{IataCode{"KGG"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Kédougou Airport
    Airport{IataCode{"KGH"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Yongai Airport
    Airport{IataCode{"KGI"}, CountryId{"AU"}, Tz::Australia_Perth}, // Kalgoorlie-Boulder Airport
    Airport{IataCode{"KGJ"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Karonga Airport
    Airport{IataCode{"KGK"}, CountryId{"US"}, Tz::America_Anchorage}, // Koliganek Airport
    Airport{IataCode{"KGL"}, CountryId{"RW"}, Tz::Africa_Kigali}, // Kigali International Airport
    Airport{IataCode{"KGM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kungim Airstrip
    Airport{IataCode{"KGP"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Kogalym International Airport
    Airport{IataCode{"KGS"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kos Island International Airport
    Airport{IataCode{"KGT"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Kangding Airport
    Airport{IataCode{"KGX"}, CountryId{"US"}, Tz::America_Anchorage}, // Grayling Airport
    Airport{IataCode{"KGY"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Kingaroy Airport
    Airport{IataCode{"KHC"}, CountryId{"RU"}, Tz::Europe_Simferopol}, // Kerch Airport
    Airport{IataCode{"KHD"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Khorramabad Airport
    Airport{IataCode{"KHE"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Kherson International Airport
    Airport{IataCode{"KHG"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Kashgar Airport
    Airport{IataCode{"KHH"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Kaohsiung International Airport
    Airport{IataCode{"KHI"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Jinnah International Airport
    Airport{IataCode{"KHK"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Khark Airport
    Airport{IataCode{"KHM"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Khamti Airport
    Airport{IataCode{"KHN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Nanchang Changbei International Airport
    Airport{IataCode{"KHR"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Kharkhorin Airport
    Airport{IataCode{"KHS"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Khasab Airport
    Airport{IataCode{"KHT"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Khost Airfield
    Airport{IataCode{"KHU"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Kremenchuk Airport
    Airport{IataCode{"KHV"}, CountryId{"RU"}, Tz::Asia_Vladivostok}, // Khabarovsk Novy Airport
    Airport{IataCode{"KHW"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Khwai River Airport
    Airport{IataCode{"KHY"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Khoy Airport
    Airport{IataCode{"KHZ"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Kauehi aerodrome
    Airport{IataCode{"KIC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Mesa Del Rey Airport
    Airport{IataCode{"KID"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Kristianstad Airport
    Airport{IataCode{"KIF"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Kingfisher Lake Airport
    Airport{IataCode{"KIH"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Kish International Airport
    Airport{IataCode{"KIJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Niigata Airport
    Airport{IataCode{"KIM"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Kimberley Airport
    Airport{IataCode{"KIN"}, CountryId{"JM"}, Tz::America_Jamaica}, // Norman Manley International Airport
    Airport{IataCode{"KIO"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Kili Airport
    Airport{IataCode{"KIP"}, CountryId{"US"}, Tz::America_Chicago}, // Kickapoo Downtown Airport
    Airport{IataCode{"KIQ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kira
    Airport{IataCode{"KIR"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Kerry Airport
    Airport{IataCode{"KIS"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Kisumu International Airport
    Airport{IataCode{"KIT"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kithira Island National Airport "Alexandros Aristotelous Onassis"
    Airport{IataCode{"KIV"}, CountryId{"MD"}, Tz::Europe_Chisinau}, // Chișinău International Airport
    Airport{IataCode{"KIW"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Southdowns Airport
    Airport{IataCode{"KIX"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kansai International Airport
    Airport{IataCode{"KIY"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Kilwa Masoko Airport
    Airport{IataCode{"KJA"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Krasnoyarsk International Airport
    Airport{IataCode{"KJH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Kaili Huangping Airport
    Airport{IataCode{"KJI"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Kanas Airport
    Airport{IataCode{"KJK"}, CountryId{"BE"}, Tz::Europe_Brussels}, // Kortrijk-Wevelgem International Airport
    Airport{IataCode{"KJP"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kerama Airport
    Airport{IataCode{"KJT"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Kertajati International Airport
    Airport{IataCode{"KJX"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Blangpidie Airport
    Airport{IataCode{"KKA"}, CountryId{"US"}, Tz::America_Anchorage}, // Koyuk Alfred Adams Airport
    Airport{IataCode{"KKB"}, CountryId{"US"}, Tz::America_Anchorage}, // Kitoi Bay Seaplane Base
    Airport{IataCode{"KKC"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Khon Kaen Airport
    Airport{IataCode{"KKD"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kokoda Airport
    Airport{IataCode{"KKE"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Kerikeri Airport
    Airport{IataCode{"KKH"}, CountryId{"US"}, Tz::America_Nome}, // Kongiganak Airport
    Airport{IataCode{"KKJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kitakyushu Airport
    Airport{IataCode{"KKN"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Kirkenes Airport, Høybuktmoen
    Airport{IataCode{"KKO"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Kaikohe Aerodrome
    Airport{IataCode{"KKR"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Kaukura Airport
    Airport{IataCode{"KKS"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Kashan Airport
    Airport{IataCode{"KKT"}, CountryId{"US"}, Tz::America_Chicago}, // Kentland Municipal Airport
    Airport{IataCode{"KKW"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Kikwit Airport
    Airport{IataCode{"KKX"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kikai Airport
    Airport{IataCode{"KKY"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Kilkenny Airport
    Airport{IataCode{"KKZ"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Koh Kong Airport
    Airport{IataCode{"KLA"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Kampala Airport
    Airport{IataCode{"KLB"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Kalabo Airport
    Airport{IataCode{"KLC"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Kaolack Airport
    Airport{IataCode{"KLD"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Migalovo
    Airport{IataCode{"KLE"}, CountryId{"CM"}, Tz::Africa_Douala}, // Kaélé Airport
    Airport{IataCode{"KLF"}, CountryId{"RU"}, Tz::Europe_Moscow}, // "Kaluga" (Grabtsevo) Airport
    Airport{IataCode{"KLG"}, CountryId{"US"}, Tz::America_Anchorage}, // Kalskag Airport
    Airport{IataCode{"KLH"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kolhapur Airport
    Airport{IataCode{"KLK"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Kalokol Airport
    Airport{IataCode{"KLL"}, CountryId{"US"}, Tz::America_Anchorage}, // Levelock Airport
    Airport{IataCode{"KLM"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Kalaleh Airport
    Airport{IataCode{"KLN"}, CountryId{"US"}, Tz::America_Anchorage}, // Larsen Bay Airport
    Airport{IataCode{"KLO"}, CountryId{"PH"}, Tz::Asia_Manila}, // Kalibo International Airport
    Airport{IataCode{"KLP"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Seruyan Kuala Pembuang Airport
    Airport{IataCode{"KLR"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Kalmar Airport
    Airport{IataCode{"KLS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Southwest Washington Regional Airport
    Airport{IataCode{"KLU"}, CountryId{"AT"}, Tz::Europe_Vienna}, // Klagenfurt Airport
    Airport{IataCode{"KLV"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Karlovy Vary Airport
    Airport{IataCode{"KLW"}, CountryId{"US"}, Tz::America_Sitka}, // Klawock Airport
    Airport{IataCode{"KLX"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kalamata International Airport
    Airport{IataCode{"KLY"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kalima Airport
    Airport{IataCode{"KLZ"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Kleinzee Airport
    Airport{IataCode{"KMA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kerema Airport
    Airport{IataCode{"KMB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Koinambe Airport
    Airport{IataCode{"KMC"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Hafar Al-Batin Domestic Airport
    Airport{IataCode{"KME"}, CountryId{"RW"}, Tz::Africa_Kigali}, // Kamembe Airport
    Airport{IataCode{"KMG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Kunming Changshui International Airport
    Airport{IataCode{"KMH"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Johan Pienaar Airport
    Airport{IataCode{"KMI"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Miyazaki Airport
    Airport{IataCode{"KMJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kumamoto Airport
    Airport{IataCode{"KMK"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Makabana Airport
    Airport{IataCode{"KMN"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kamina Airport
    Airport{IataCode{"KMO"}, CountryId{"US"}, Tz::America_Anchorage}, // Manokotak Airport
    Airport{IataCode{"KMP"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Keetmanshoop Airport
    Airport{IataCode{"KMQ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Komatsu Airport
    Airport{IataCode{"KMS"}, CountryId{"GH"}, Tz::Africa_Accra}, // Kumasi Airport
    Airport{IataCode{"KMT"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Kampot Airport
    Airport{IataCode{"KMU"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Kismayo Airport
    Airport{IataCode{"KMV"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Kalaymyo Airport
    Airport{IataCode{"KMW"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Kostroma Airport
    Airport{IataCode{"KMZ"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Kaoma Airport
    Airport{IataCode{"KNA"}, CountryId{"CL"}, Tz::America_Santiago}, // Viña del Mar Airport
    Airport{IataCode{"KNB"}, CountryId{"US"}, Tz::America_Phoenix}, // Kanab Municipal Airport
    Airport{IataCode{"KND"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kindu Airport
    Airport{IataCode{"KNE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kanainj
    Airport{IataCode{"KNG"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Kaimana Airport
    Airport{IataCode{"KNH"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Kinmen Airport
    Airport{IataCode{"KNI"}, CountryId{"AU"}, Tz::Australia_Perth}, // Katanning Airport
    Airport{IataCode{"KNJ"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Kindamba Airport
    Airport{IataCode{"KNK"}, CountryId{"US"}, Tz::America_Anchorage}, // Kokhanok Airport
    Airport{IataCode{"KNM"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kaniama, Kaniama Airport
    Airport{IataCode{"KNN"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Kankan Airport
    Airport{IataCode{"KNO"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Kualanamu International Airport
    Airport{IataCode{"KNP"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Kapanda Airport
    Airport{IataCode{"KNQ"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Koné Airport
    Airport{IataCode{"KNR"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Jam Airport
    Airport{IataCode{"KNS"}, CountryId{"AU"}, Tz::Australia_Currie}, // King Island Airport
    Airport{IataCode{"KNT"}, CountryId{"US"}, Tz::America_Chicago}, // Kennett Memorial Airport
    Airport{IataCode{"KNU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kanpur Airport
    Airport{IataCode{"KNW"}, CountryId{"US"}, Tz::America_Anchorage}, // New Stuyahok Airport
    Airport{IataCode{"KNX"}, CountryId{"AU"}, Tz::Australia_Perth}, // Kununurra Airport
    Airport{IataCode{"KNZ"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Kéniéba Airport
    Airport{IataCode{"KOA"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Kona International Airport
    Airport{IataCode{"KOE"}, CountryId{"ID"}, Tz::Asia_Makassar}, // El Tari Airport
    Airport{IataCode{"KOG"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Khong
    Airport{IataCode{"KOI"}, CountryId{"GB"}, Tz::Europe_London}, // Kirkwall Airport
    Airport{IataCode{"KOJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kagoshima Airport
    Airport{IataCode{"KOK"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Kokkola-Pietarsaari Airport
    Airport{IataCode{"KOL"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Koumala Airport
    Airport{IataCode{"KOO"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kongolo Airport
    Airport{IataCode{"KOP"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Nakhon Phanom Airport
    Airport{IataCode{"KOR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kokoro
    Airport{IataCode{"KOS"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Sihanouk International Airport
    Airport{IataCode{"KOT"}, CountryId{"US"}, Tz::America_Nome}, // Kotlik Airport
    Airport{IataCode{"KOU"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Koulamoutou Airport
    Airport{IataCode{"KOV"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Kokshetau Airport
    Airport{IataCode{"KOW"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Ganzhou Huangjin Airport
    Airport{IataCode{"KOY"}, CountryId{"US"}, Tz::America_Anchorage}, // Olga Bay Seaplane Base
    Airport{IataCode{"KOZ"}, CountryId{"US"}, Tz::America_Anchorage}, // Ouzinkie Airport
    Airport{IataCode{"KPA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kopiago
    Airport{IataCode{"KPC"}, CountryId{"US"}, Tz::America_Nome}, // Port Clarence Coast Guard Station
    Airport{IataCode{"KPE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Yapsiei
    Airport{IataCode{"KPI"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Kapit Airport
    Airport{IataCode{"KPL"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kapal Airport
    Airport{IataCode{"KPM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kompiam Airport
    Airport{IataCode{"KPN"}, CountryId{"US"}, Tz::America_Nome}, // Kipnuk Airport
    Airport{IataCode{"KPO"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Pohang Airport
    Airport{IataCode{"KPR"}, CountryId{"US"}, Tz::America_Anchorage}, // Port Williams Seaplane Base
    Airport{IataCode{"KPS"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Kempsey Airport
    Airport{IataCode{"KPT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Jackpot Airport
    Airport{IataCode{"KPV"}, CountryId{"US"}, Tz::America_Anchorage}, // Perryville Airport
    Airport{IataCode{"KPX"}, CountryId{"RU"}, Tz::Asia_Anadyr}, // Kupol Airport
    Airport{IataCode{"KPY"}, CountryId{"US"}, Tz::America_Anchorage}, // Port Bailey Seaplane Base
    Airport{IataCode{"KQA"}, CountryId{"US"}, Tz::America_Nome}, // Akutan Airport
    Airport{IataCode{"KQH"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kishangarh Airport
    Airport{IataCode{"KQR"}, CountryId{"AU"}, Tz::Australia_Perth}, // Karara Airport
    Airport{IataCode{"KQT"}, CountryId{"TJ"}, Tz::Asia_Dushanbe}, // Qurghonteppa International Airport
    Airport{IataCode{"KRA"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Kerang Airport
    Airport{IataCode{"KRB"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Karumba Airport
    Airport{IataCode{"KRC"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Depati Parbo Airport
    Airport{IataCode{"KRE"}, CountryId{"BI"}, Tz::Africa_Bujumbura}, // Kirundo Airport
    Airport{IataCode{"KRF"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Kramfors-Sollefteå Airport
    Airport{IataCode{"KRG"}, CountryId{"GY"}, Tz::America_Guyana}, // Karasabai Airport
    Airport{IataCode{"KRH"}, CountryId{"GB"}, Tz::Europe_London}, // Redhill Aerodrome
    Airport{IataCode{"KRI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kikori Airport
    Airport{IataCode{"KRJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Karawari
    Airport{IataCode{"KRK"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // John Paul II International Airport Kraków-Balice
    Airport{IataCode{"KRL"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Korla Airport
    Airport{IataCode{"KRM"}, CountryId{"GY"}, Tz::America_Guyana}, // Karanambo Airport
    Airport{IataCode{"KRN"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Kiruna Airport
    Airport{IataCode{"KRO"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Kurgan Airport
    Airport{IataCode{"KRP"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Karup Airport
    Airport{IataCode{"KRQ"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Kramatorsk Airport
    Airport{IataCode{"KRR"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Krasnodar International Airport
    Airport{IataCode{"KRS"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Kristiansand Airport, Kjevik
    Airport{IataCode{"KRT"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Khartoum International Airport
    Airport{IataCode{"KRU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kerau
    Airport{IataCode{"KRV"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Kimwarer Airport
    Airport{IataCode{"KRW"}, CountryId{"TM"}, Tz::Asia_Ashgabat}, // Turkmenbashi Airport
    Airport{IataCode{"KRX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kar Kar
    Airport{IataCode{"KRY"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Karamay Airport
    Airport{IataCode{"KRZ"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Basango Mboliasa Airport
    Airport{IataCode{"KSA"}, CountryId{"FM"}, Tz::Pacific_Kosrae}, // Kosrae International Airport
    Airport{IataCode{"KSC"}, CountryId{"SK"}, Tz::Europe_Bratislava}, // Košice International Airport
    Airport{IataCode{"KSD"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Karlstad Airport
    Airport{IataCode{"KSE"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Kasese Airport
    Airport{IataCode{"KSF"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Kassel Airport
    Airport{IataCode{"KSG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kisengan
    Airport{IataCode{"KSH"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Kermanshah Airport
    Airport{IataCode{"KSI"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Kissidougou Airport
    Airport{IataCode{"KSJ"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kassos Island Public Airport
    Airport{IataCode{"KSK"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Karlskoga Airport
    Airport{IataCode{"KSL"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Kassala Airport
    Airport{IataCode{"KSM"}, CountryId{"US"}, Tz::America_Nome}, // St. Mary's Airport
    Airport{IataCode{"KSN"}, CountryId{"KZ"}, Tz::Asia_Qyzylorda}, // Kostanay Airport
    Airport{IataCode{"KSO"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kastoria National Airport
    Airport{IataCode{"KSQ"}, CountryId{"UZ"}, Tz::Asia_Samarkand}, // Karshi Airport
    Airport{IataCode{"KSR"}, CountryId{"ID"}, Tz::Asia_Makassar}, // H. Aroeppala Airport
    Airport{IataCode{"KSS"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Sikasso Airport
    Airport{IataCode{"KST"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Rabak Airport
    Airport{IataCode{"KSU"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Kristiansund Airport, Kvernberget
    Airport{IataCode{"KSV"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Springvale Airport
    Airport{IataCode{"KSX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Yasuru
    Airport{IataCode{"KSY"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Kars Airport
    Airport{IataCode{"KSZ"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Kotlas Airport
    Airport{IataCode{"KTA"}, CountryId{"AU"}, Tz::Australia_Perth}, // Karratha Airport
    Airport{IataCode{"KTB"}, CountryId{"US"}, Tz::America_Sitka}, // Thorne Bay Seaplane Base
    Airport{IataCode{"KTC"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Katiola Airport
    Airport{IataCode{"KTD"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kitadaito Airport
    Airport{IataCode{"KTE"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Kerteh Airport
    Airport{IataCode{"KTF"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Takaka Aerodrome
    Airport{IataCode{"KTG"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Ketapang Airport
    Airport{IataCode{"KTI"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Kratié Airport
    Airport{IataCode{"KTK"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Kanua
    Airport{IataCode{"KTL"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Kitale Airport
    Airport{IataCode{"KTM"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Tribhuvan International Airport
    Airport{IataCode{"KTN"}, CountryId{"US"}, Tz::America_Sitka}, // Ketchikan International Airport
    Airport{IataCode{"KTO"}, CountryId{"GY"}, Tz::America_Guyana}, // Kato Airport
    Airport{IataCode{"KTP"}, CountryId{"JM"}, Tz::America_Jamaica}, // Tinson Pen Aerodrome
    Airport{IataCode{"KTS"}, CountryId{"US"}, Tz::America_Nome}, // Brevig Mission Airport
    Airport{IataCode{"KTT"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Kittilä Airport
    Airport{IataCode{"KTU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kota Airport
    Airport{IataCode{"KTV"}, CountryId{"VE"}, Tz::America_Caracas}, // Kamarata Airport
    Airport{IataCode{"KTW"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Katowice International Airport
    Airport{IataCode{"KTX"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Koutiala Airport
    Airport{IataCode{"KUA"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Sultan Haji Ahmad Shah Airport
    Airport{IataCode{"KUC"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Kuria Airport
    Airport{IataCode{"KUD"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Kudat Airport
    Airport{IataCode{"KUE"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Kukudu Airport
    Airport{IataCode{"KUF"}, CountryId{"RU"}, Tz::Europe_Samara}, // Kurumoch International Airport
    Airport{IataCode{"KUH"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kushiro Airport
    Airport{IataCode{"KUK"}, CountryId{"US"}, Tz::America_Nome}, // Kasigluk Airport
    Airport{IataCode{"KUL"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Kuala Lumpur International Airport
    Airport{IataCode{"KUM"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Yakushima Airport
    Airport{IataCode{"KUN"}, CountryId{"LT"}, Tz::Europe_Vilnius}, // Kaunas Airport
    Airport{IataCode{"KUO"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Kuopio Airport
    Airport{IataCode{"KUP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kupiano Airport
    Airport{IataCode{"KUQ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kuri Airport
    Airport{IataCode{"KUS"}, CountryId{"GL"}, Tz::America_Godthab}, // Kulusuk Airport
    Airport{IataCode{"KUT"}, CountryId{"GE"}, Tz::Asia_Tbilisi}, // Kutaisi International Airport
    Airport{IataCode{"KUU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Bhuntar Airport
    Airport{IataCode{"KUV"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Gunsan Airport
    Airport{IataCode{"KUX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kuyol Airport
    Airport{IataCode{"KUY"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kamusi Airport
    Airport{IataCode{"KVA"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kavala International Airport
    Airport{IataCode{"KVB"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Skövde Airport
    Airport{IataCode{"KVC"}, CountryId{"US"}, Tz::America_Nome}, // King Cove Airport
    Airport{IataCode{"KVD"}, CountryId{"AZ"}, Tz::Asia_Baku}, // Ganja International Airport
    Airport{IataCode{"KVE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kitava
    Airport{IataCode{"KVG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kavieng Airport
    Airport{IataCode{"KVK"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Kirovsk-Apatity Airport
    Airport{IataCode{"KVL"}, CountryId{"US"}, Tz::America_Nome}, // Kivalina Airport
    Airport{IataCode{"KVM"}, CountryId{"RU"}, Tz::Asia_Anadyr}, // Markovo Airport
    Airport{IataCode{"KVO"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Morava Airport
    Airport{IataCode{"KVX"}, CountryId{"RU"}, Tz::Europe_Kirov}, // Pobedilovo Airport
    Airport{IataCode{"KWB"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Dewadaru Airport
    Airport{IataCode{"KWE"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Guiyang Longdongbao International Airport
    Airport{IataCode{"KWF"}, CountryId{"US"}, Tz::America_Sitka}, // Waterfall Seaplane Base
    Airport{IataCode{"KWG"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Kryvyi Rih International Airport
    Airport{IataCode{"KWH"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Khwahan Airport
    Airport{IataCode{"KWI"}, CountryId{"KW"}, Tz::Asia_Kuwait}, // Kuwait International Airport
    Airport{IataCode{"KWJ"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Gwangju Airport
    Airport{IataCode{"KWK"}, CountryId{"US"}, Tz::America_Nome}, // Kwigillingok Airport
    Airport{IataCode{"KWL"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Guilin Liangjiang International Airport
    Airport{IataCode{"KWM"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Kowanyama Airport
    Airport{IataCode{"KWN"}, CountryId{"US"}, Tz::America_Anchorage}, // Quinhagak Airport
    Airport{IataCode{"KWO"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kawito Airport
    Airport{IataCode{"KWP"}, CountryId{"US"}, Tz::America_Anchorage}, // West Point Village Seaplane Base
    Airport{IataCode{"KWS"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Kiryat Shmona Airport
    Airport{IataCode{"KWT"}, CountryId{"US"}, Tz::America_Anchorage}, // Kwethluk Airport
    Airport{IataCode{"KWV"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Kurwina Airport
    Airport{IataCode{"KWY"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Kiwayu Airport
    Airport{IataCode{"KWZ"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Kolwezi Airport
    Airport{IataCode{"KXE"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // P.C. Pelser Airport
    Airport{IataCode{"KXK"}, CountryId{"RU"}, Tz::Asia_Vladivostok}, // Komsomolsk-on-Amur Airport
    Airport{IataCode{"KXR"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Karoola Airport
    Airport{IataCode{"KXU"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Katiu airport
    Airport{IataCode{"KYD"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Lanyu Airport
    Airport{IataCode{"KYK"}, CountryId{"US"}, Tz::America_Anchorage}, // Karluk Airport
    Airport{IataCode{"KYP"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Kyaukpyu Airport
    Airport{IataCode{"KYS"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Kayes Airport
    Airport{IataCode{"KYT"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Kyauktu Airport
    Airport{IataCode{"KYU"}, CountryId{"US"}, Tz::America_Anchorage}, // Koyukuk Airport
    Airport{IataCode{"KYX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Yalumet
    Airport{IataCode{"KYZ"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Kyzyl Airport
    Airport{IataCode{"KZB"}, CountryId{"US"}, Tz::America_Anchorage}, // Zachar Bay Seaplane Base
    Airport{IataCode{"KZC"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Kampong Chhnang Airport
    Airport{IataCode{"KZD"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Krakor Airport
    Airport{IataCode{"KZI"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kozani National Airport
    Airport{IataCode{"KZN"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Kazan International Airport
    Airport{IataCode{"KZO"}, CountryId{"KZ"}, Tz::Asia_Qyzylorda}, // Kyzylorda Airport
    Airport{IataCode{"KZR"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Zafer Airport
    Airport{IataCode{"KZS"}, CountryId{"GR"}, Tz::Europe_Athens}, // Kastellorizo Airport
    Airport{IataCode{"LAA"}, CountryId{"US"}, Tz::America_Denver}, // Lamar Municipal Airport (Colorado)
    Airport{IataCode{"LAD"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Quatro de Fevereiro Airport
    Airport{IataCode{"LAE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Lae Nadzab Airport
    Airport{IataCode{"LAF"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Purdue University Airport
    Airport{IataCode{"LAH"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Oesman Sadik Airport
    Airport{IataCode{"LAI"}, CountryId{"FR"}, Tz::Europe_Paris}, // Lannion – Côte de Granit Airport
    Airport{IataCode{"LAJ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Lages Airport
    Airport{IataCode{"LAK"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Aklavik/Freddie Carmichael Airport
    Airport{IataCode{"LAL"}, CountryId{"US"}, Tz::America_New_York}, // Lakeland Linder Regional Airport
    Airport{IataCode{"LAM"}, CountryId{"US"}, Tz::America_Denver}, // Los Alamos County Airport
    Airport{IataCode{"LAN"}, CountryId{"US"}, Tz::America_Detroit}, // Capital Region International Airport
    Airport{IataCode{"LAO"}, CountryId{"PH"}, Tz::Asia_Manila}, // Laoag International Airport
    Airport{IataCode{"LAP"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Manuel Márquez de León International Airport
    Airport{IataCode{"LAQ"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Al Abraq International Airport
    Airport{IataCode{"LAR"}, CountryId{"US"}, Tz::America_Denver}, // Laramie Regional Airport
    Airport{IataCode{"LAS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // McCarran International Airport
    Airport{IataCode{"LAU"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Manda Airport
    Airport{IataCode{"LAW"}, CountryId{"US"}, Tz::America_Chicago}, // Lawton–Fort Sill Regional Airport
    Airport{IataCode{"LAX"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Los Angeles International Airport
    Airport{IataCode{"LAY"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Ladysmith Airport
    Airport{IataCode{"LAZ"}, CountryId{"BR"}, Tz::America_Bahia}, // Bom Jesus da Lapa Airport
    Airport{IataCode{"LBA"}, CountryId{"GB"}, Tz::Europe_London}, // Leeds Bradford International Airport
    Airport{IataCode{"LBB"}, CountryId{"US"}, Tz::America_Chicago}, // Lubbock Preston Smith International Airport
    Airport{IataCode{"LBC"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Lübeck Airport
    Airport{IataCode{"LBD"}, CountryId{"TJ"}, Tz::Asia_Dushanbe}, // Khujand Airport
    Airport{IataCode{"LBE"}, CountryId{"US"}, Tz::America_New_York}, // Arnold Palmer Regional Airport
    Airport{IataCode{"LBF"}, CountryId{"US"}, Tz::America_Chicago}, // North Platte Regional Airport
    Airport{IataCode{"LBG"}, CountryId{"FR"}, Tz::Europe_Paris}, // Paris–Le Bourget Airport
    Airport{IataCode{"LBJ"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Komodo Airport
    Airport{IataCode{"LBK"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Liboi Airport
    Airport{IataCode{"LBL"}, CountryId{"US"}, Tz::America_Chicago}, // Liberal Mid-America Regional Airport
    Airport{IataCode{"LBN"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Lake Baringo Airport
    Airport{IataCode{"LBO"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Lusambo Airport
    Airport{IataCode{"LBP"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Long Banga Airport
    Airport{IataCode{"LBQ"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Lambaréné Airport
    Airport{IataCode{"LBR"}, CountryId{"BR"}, Tz::America_Manaus}, // Lábrea Airport
    Airport{IataCode{"LBS"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Labasa Airport
    Airport{IataCode{"LBT"}, CountryId{"US"}, Tz::America_New_York}, // Lumberton Municipal Airport
    Airport{IataCode{"LBU"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Labuan Airport
    Airport{IataCode{"LBV"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Libreville International Airport
    Airport{IataCode{"LBW"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Juvai Semaring Airport
    Airport{IataCode{"LBX"}, CountryId{"PH"}, Tz::Asia_Manila}, // Lubang Airport
    Airport{IataCode{"LBZ"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Lucapa Airport
    Airport{IataCode{"LCA"}, CountryId{"CY"}, Tz::Asia_Nicosia}, // Larnaca International Airport
    Airport{IataCode{"LCE"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Golosón International Airport
    Airport{IataCode{"LCF"}, CountryId{"GT"}, Tz::America_Guatemala}, // Río Dulce Airport
    Airport{IataCode{"LCG"}, CountryId{"ES"}, Tz::Europe_Madrid}, // A Coruña Airport
    Airport{IataCode{"LCH"}, CountryId{"US"}, Tz::America_Chicago}, // Lake Charles Regional Airport
    Airport{IataCode{"LCI"}, CountryId{"US"}, Tz::America_New_York}, // Laconia Municipal Airport
    Airport{IataCode{"LCJ"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Łódź Władysław Reymont Airport
    Airport{IataCode{"LCK"}, CountryId{"US"}, Tz::America_New_York}, // Rickenbacker International Airport
    Airport{IataCode{"LCL"}, CountryId{"CU"}, Tz::America_Havana}, // La Coloma Airport
    Airport{IataCode{"LCM"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // La Cumbre Airport
    Airport{IataCode{"LCO"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Lague Airport
    Airport{IataCode{"LCP"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Loncopue Airport
    Airport{IataCode{"LCQ"}, CountryId{"US"}, Tz::America_New_York}, // Lake City Gateway Airport
    Airport{IataCode{"LCR"}, CountryId{"CO"}, Tz::America_Bogota}, // La Chorrera Airport
    Airport{IataCode{"LCV"}, CountryId{"IT"}, Tz::Europe_Rome}, // Lucca-Tassignano Airport
    Airport{IataCode{"LCX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Longyan Guanzhishan Airport
    Airport{IataCode{"LCY"}, CountryId{"GB"}, Tz::Europe_London}, // London City Airport
    Airport{IataCode{"LDA"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Malda Airport
    Airport{IataCode{"LDB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Londrina Airport
    Airport{IataCode{"LDE"}, CountryId{"FR"}, Tz::Europe_Paris}, // Tarbes-Lourdes-Pyrénées Airport
    Airport{IataCode{"LDG"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Leshukonskoye Airport
    Airport{IataCode{"LDH"}, CountryId{"AU"}, Tz::Australia_Lord_Howe}, // Lord Howe Island Airport
    Airport{IataCode{"LDI"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Lindi Airport
    Airport{IataCode{"LDJ"}, CountryId{"US"}, Tz::America_New_York}, // Linden Airport
    Airport{IataCode{"LDK"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Lidköping-Hovby Airport
    Airport{IataCode{"LDM"}, CountryId{"US"}, Tz::America_Detroit}, // Mason County Airport
    Airport{IataCode{"LDN"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Lamidanda Airport
    Airport{IataCode{"LDO"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Laduani Airstrip
    Airport{IataCode{"LDS"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yichun Lindu Airport
    Airport{IataCode{"LDU"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Lahad Datu Airport
    Airport{IataCode{"LDX"}, CountryId{"FR"}, Tz::America_Cayenne}, // Saint-Laurent-du-Maroni Airport
    Airport{IataCode{"LDY"}, CountryId{"GB"}, Tz::Europe_London}, // City of Derry Airport
    Airport{IataCode{"LEA"}, CountryId{"AU"}, Tz::Australia_Perth}, // Learmonth Airport
    Airport{IataCode{"LEB"}, CountryId{"US"}, Tz::America_New_York}, // Lebanon Municipal Airport
    Airport{IataCode{"LED"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Pulkovo Airport
    Airport{IataCode{"LEE"}, CountryId{"US"}, Tz::America_New_York}, // Leesburg International Airport
    Airport{IataCode{"LEF"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Lebakeng Airport
    Airport{IataCode{"LEH"}, CountryId{"FR"}, Tz::Europe_Paris}, // Le Havre – Octeville Airport
    Airport{IataCode{"LEI"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Almería Airport
    Airport{IataCode{"LEJ"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Leipzig/Halle Airport
    Airport{IataCode{"LEK"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Tata Airport
    Airport{IataCode{"LEL"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Lake Evella Airport
    Airport{IataCode{"LEN"}, CountryId{"ES"}, Tz::Europe_Madrid}, // León Airport
    Airport{IataCode{"LEP"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Leopoldina Airport
    Airport{IataCode{"LEQ"}, CountryId{"GB"}, Tz::Europe_London}, // Land's End Airport
    Airport{IataCode{"LER"}, CountryId{"AU"}, Tz::Australia_Perth}, // Leinster Airport
    Airport{IataCode{"LES"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Lesobeng Airport
    Airport{IataCode{"LET"}, CountryId{"CO"}, Tz::America_Bogota}, // Alfredo Vásquez Cobo International Airport
    Airport{IataCode{"LEU"}, CountryId{"ES"}, Tz::Europe_Madrid}, // La Seu d'Urgell Airport
    Airport{IataCode{"LEV"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Levuka Airfield
    Airport{IataCode{"LEW"}, CountryId{"US"}, Tz::America_New_York}, // Auburn/Lewiston Municipal Airport
    Airport{IataCode{"LEX"}, CountryId{"US"}, Tz::America_New_York}, // Blue Grass Airport
    Airport{IataCode{"LEY"}, CountryId{"NL"}, Tz::Europe_Amsterdam}, // Lelystad Airport
    Airport{IataCode{"LEZ"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // La Esperanza Airport, Intibucá
    Airport{IataCode{"LFB"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Lumbo Airport
    Airport{IataCode{"LFK"}, CountryId{"US"}, Tz::America_Chicago}, // Angelina County Airport
    Airport{IataCode{"LFM"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Lamerd Airport
    Airport{IataCode{"LFN"}, CountryId{"US"}, Tz::America_New_York}, // Triangle North Executive Airport
    Airport{IataCode{"LFO"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Kelafo East Airport
    Airport{IataCode{"LFQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Linfen Qiaoli Airport
    Airport{IataCode{"LFR"}, CountryId{"VE"}, Tz::America_Caracas}, // La Fría Airport
    Airport{IataCode{"LFT"}, CountryId{"US"}, Tz::America_Chicago}, // Lafayette Regional Airport
    Airport{IataCode{"LFW"}, CountryId{"TG"}, Tz::Africa_Lome}, // Lomé-Tokoin Airport
    Airport{IataCode{"LGA"}, CountryId{"US"}, Tz::America_New_York}, // LaGuardia Airport
    Airport{IataCode{"LGB"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Long Beach Airport
    Airport{IataCode{"LGC"}, CountryId{"US"}, Tz::America_New_York}, // LaGrange-Callaway Airport
    Airport{IataCode{"LGD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // La Grande/Union County Airport
    Airport{IataCode{"LGE"}, CountryId{"AU"}, Tz::Australia_Perth}, // Lake Gregory Airport
    Airport{IataCode{"LGG"}, CountryId{"BE"}, Tz::Europe_Brussels}, // Liege Airport
    Airport{IataCode{"LGH"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Leigh Creek Airport
    Airport{IataCode{"LGI"}, CountryId{"BS"}, Tz::America_Nassau}, // Deadman's Cay Airport
    Airport{IataCode{"LGK"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Langkawi International Airport
    Airport{IataCode{"LGL"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Long Lellang Airport
    Airport{IataCode{"LGN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Linga Linga
    Airport{IataCode{"LGP"}, CountryId{"PH"}, Tz::Asia_Manila}, // Legazpi Airport
    Airport{IataCode{"LGQ"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Lago Agrio Airport
    Airport{IataCode{"LGR"}, CountryId{"CL"}, Tz::America_Santiago}, // Cochrane, Chile Airport
    Airport{IataCode{"LGS"}, CountryId{"AR"}, Tz::America_Argentina_Mendoza}, // Comodoro D. Ricardo Salomón Airport
    Airport{IataCode{"LGT"}, CountryId{"CO"}, Tz::America_Bogota}, // Las Gaviotas Airport
    Airport{IataCode{"LGU"}, CountryId{"US"}, Tz::America_Denver}, // Logan-Cache Airport
    Airport{IataCode{"LGW"}, CountryId{"GB"}, Tz::Europe_London}, // Gatwick Airport
    Airport{IataCode{"LGX"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Lugh Ganane Airport
    Airport{IataCode{"LHC"}, CountryId{"PE"}, Tz::America_Lima}, // Caballococha Airport
    Airport{IataCode{"LHE"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Allama Iqbal International Airport
    Airport{IataCode{"LHG"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Lightning Ridge Airport
    Airport{IataCode{"LHP"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Lehu
    Airport{IataCode{"LHR"}, CountryId{"GB"}, Tz::Europe_London}, // Heathrow Airport
    Airport{IataCode{"LHS"}, CountryId{"AR"}, Tz::America_Argentina_Rio_Gallegos}, // Colonia Las Heras Airport
    Airport{IataCode{"LHV"}, CountryId{"US"}, Tz::America_New_York}, // William T. Piper Memorial Airport
    Airport{IataCode{"LHW"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Lanzhou Zhongchuan International Airport
    Airport{IataCode{"LIE"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Libenge Airport
    Airport{IataCode{"LIF"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Lifou Airport
    Airport{IataCode{"LIG"}, CountryId{"FR"}, Tz::Europe_Paris}, // Limoges – Bellegarde Airport
    Airport{IataCode{"LIH"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Lihue Airport
    Airport{IataCode{"LIK"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Likiep Airport
    Airport{IataCode{"LIL"}, CountryId{"FR"}, Tz::Europe_Paris}, // Lille Airport
    Airport{IataCode{"LIM"}, CountryId{"PE"}, Tz::America_Lima}, // Jorge Chávez International Airport
    Airport{IataCode{"LIN"}, CountryId{"IT"}, Tz::Europe_Rome}, // Linate Airport
    Airport{IataCode{"LIO"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Limón International Airport
    Airport{IataCode{"LIP"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Lins Airport
    Airport{IataCode{"LIQ"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Lisala Airport
    Airport{IataCode{"LIR"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Daniel Oduber Quirós International Airport
    Airport{IataCode{"LIS"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Lisbon Airport
    Airport{IataCode{"LIT"}, CountryId{"US"}, Tz::America_Chicago}, // Bill and Hillary Clinton National Airport
    Airport{IataCode{"LIW"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Loikaw Airport
    Airport{IataCode{"LIX"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Likoma Airport
    Airport{IataCode{"LIZ"}, CountryId{"US"}, Tz::America_New_York}, // Loring International Airport
    Airport{IataCode{"LJA"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Lodja Airport
    Airport{IataCode{"LJG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Lijiang Sanyi Airport
    Airport{IataCode{"LJN"}, CountryId{"US"}, Tz::America_Chicago}, // Texas Gulf Coast Regional Airport
    Airport{IataCode{"LJU"}, CountryId{"SI"}, Tz::Europe_Ljubljana}, // Ljubljana Jože Pučnik Airport
    Airport{IataCode{"LKA"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Gewayantana Airport
    Airport{IataCode{"LKB"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Lakeba Airport
    Airport{IataCode{"LKE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Kenmore Air Harbor Seaplane Base
    Airport{IataCode{"LKG"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Lokichogio Airport
    Airport{IataCode{"LKH"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Long Akah Airport
    Airport{IataCode{"LKK"}, CountryId{"US"}, Tz::America_Anchorage}, // Kulik Lake Airport
    Airport{IataCode{"LKL"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Lakselv Airport, Banak
    Airport{IataCode{"LKN"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Leknes Airport
    Airport{IataCode{"LKO"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Chaudhary Charan Singh Airport
    Airport{IataCode{"LKP"}, CountryId{"US"}, Tz::America_New_York}, // Lake Placid Airport
    Airport{IataCode{"LKU"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Lake Rudolf Airport
    Airport{IataCode{"LKV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Lake County Airport
    Airport{IataCode{"LKW"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Lekhwair Airport
    Airport{IataCode{"LKY"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Lake Manyara Airport
    Airport{IataCode{"LLA"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Luleå-Kallax Airport
    Airport{IataCode{"LLB"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Libo Airport
    Airport{IataCode{"LLC"}, CountryId{"PH"}, Tz::Asia_Manila}, // Cagayan North International Airport
    Airport{IataCode{"LLE"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Malelane Airport
    Airport{IataCode{"LLF"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yongzhou Lingling Airport
    Airport{IataCode{"LLG"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Chillagoe Airport
    Airport{IataCode{"LLH"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // La Lima Airport
    Airport{IataCode{"LLI"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Lalibela Airport
    Airport{IataCode{"LLJ"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Silampari Airport
    Airport{IataCode{"LLK"}, CountryId{"AZ"}, Tz::Asia_Baku}, // Lankaran International Airport
    Airport{IataCode{"LLO"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Palopo Lagaligo Airport
    Airport{IataCode{"LLS"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Alférez Armando Rodríguez Airport
    Airport{IataCode{"LLT"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Lobito Airport
    Airport{IataCode{"LLV"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Lüliang Airport
    Airport{IataCode{"LLW"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Lilongwe International Airport
    Airport{IataCode{"LLX"}, CountryId{"US"}, Tz::America_New_York}, // Caledonia County Airport
    Airport{IataCode{"LLY"}, CountryId{"US"}, Tz::America_New_York}, // South Jersey Regional Airport
    Airport{IataCode{"LMA"}, CountryId{"US"}, Tz::America_Anchorage}, // Minchumina Airport
    Airport{IataCode{"LMB"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Salima Airport
    Airport{IataCode{"LMC"}, CountryId{"CO"}, Tz::America_Bogota}, // La Macarena Airport
    Airport{IataCode{"LME"}, CountryId{"FR"}, Tz::Europe_Paris}, // Airport Le Mans-Arnage
    Airport{IataCode{"LMH"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Limón, Colón, Honduras
    Airport{IataCode{"LMI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Lumi Airport
    Airport{IataCode{"LML"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Lae Airport
    Airport{IataCode{"LMM"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Valle del Fuerte Federal International Airport
    Airport{IataCode{"LMN"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Limbang Airport
    Airport{IataCode{"LMP"}, CountryId{"IT"}, Tz::Europe_Rome}, // Lampedusa Airport
    Airport{IataCode{"LMQ"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Marsa Brega Airport
    Airport{IataCode{"LMR"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Lime Acres Finsch Mine Airport
    Airport{IataCode{"LMS"}, CountryId{"US"}, Tz::America_Chicago}, // Louisville Winston County Airport
    Airport{IataCode{"LMT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Klamath Falls Airport
    Airport{IataCode{"LMY"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Lake Murray Airport
    Airport{IataCode{"LNA"}, CountryId{"US"}, Tz::America_New_York}, // Palm Beach County Park Airport
    Airport{IataCode{"LNB"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Lamen Bay Airport
    Airport{IataCode{"LNC"}, CountryId{"US"}, Tz::America_Chicago}, // Lancaster Airport
    Airport{IataCode{"LND"}, CountryId{"US"}, Tz::America_Denver}, // Hunt Field
    Airport{IataCode{"LNE"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Lonorore Airport
    Airport{IataCode{"LNF"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Munbil
    Airport{IataCode{"LNG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Lese
    Airport{IataCode{"LNJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Lincang Airport
    Airport{IataCode{"LNL"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Longnan Chengzhou Airport
    Airport{IataCode{"LNM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Langimar
    Airport{IataCode{"LNN"}, CountryId{"US"}, Tz::America_New_York}, // Willoughby Lost Nation Municipal Airport
    Airport{IataCode{"LNO"}, CountryId{"AU"}, Tz::Australia_Perth}, // Leonora Airport
    Airport{IataCode{"LNP"}, CountryId{"US"}, Tz::America_New_York}, // Lonesome Pine Airport
    Airport{IataCode{"LNR"}, CountryId{"US"}, Tz::America_Chicago}, // Tri-County Regional Airport
    Airport{IataCode{"LNS"}, CountryId{"US"}, Tz::America_New_York}, // Lancaster Airport
    Airport{IataCode{"LNU"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Robert Atty Bessing Airport
    Airport{IataCode{"LNV"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Lihir Island Airport
    Airport{IataCode{"LNX"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Smolensk South Airport
    Airport{IataCode{"LNY"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Lanai Airport
    Airport{IataCode{"LNZ"}, CountryId{"AT"}, Tz::Europe_Vienna}, // Linz Airport
    Airport{IataCode{"LOB"}, CountryId{"CL"}, Tz::America_Santiago}, // San Rafael Airport (Chile)
    Airport{IataCode{"LOD"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Longana Airport
    Airport{IataCode{"LOE"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Loei Airport
    Airport{IataCode{"LOH"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Camilo Ponce Enríquez Airport - Ciudad de Catamayo
    Airport{IataCode{"LOI"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Lontras Airport
    Airport{IataCode{"LOK"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Lodwar Airport
    Airport{IataCode{"LOL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Derby Field
    Airport{IataCode{"LOM"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Francisco Primo de Verdad National Airport
    Airport{IataCode{"LOO"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // L'Mekrareg Airport
    Airport{IataCode{"LOP"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Lombok International Airport
    Airport{IataCode{"LOQ"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Lobatse Airport
    Airport{IataCode{"LOS"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Murtala Muhammed International Airport
    Airport{IataCode{"LOT"}, CountryId{"US"}, Tz::America_Chicago}, // Lewis University Airport
    Airport{IataCode{"LOU"}, CountryId{"US"}, Tz::America_Kentucky_Louisville}, // Bowman Field
    Airport{IataCode{"LOV"}, CountryId{"MX"}, Tz::America_Monterrey}, // Venustiano Carranza International Airport
    Airport{IataCode{"LOW"}, CountryId{"US"}, Tz::America_New_York}, // Louisa County Airport
    Airport{IataCode{"LOX"}, CountryId{"GT"}, Tz::America_Guatemala}, // Los Tablones
    Airport{IataCode{"LOY"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Loiyangalani Airport
    Airport{IataCode{"LOZ"}, CountryId{"US"}, Tz::America_New_York}, // London-Corbin Airport
    Airport{IataCode{"LPA"}, CountryId{"ES"}, Tz::Atlantic_Canary}, // Gran Canaria Airport
    Airport{IataCode{"LPB"}, CountryId{"BO"}, Tz::America_La_Paz}, // El Alto International Airport
    Airport{IataCode{"LPC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Lompoc Airport
    Airport{IataCode{"LPD"}, CountryId{"CO"}, Tz::America_Bogota}, // La Pedrera Airport
    Airport{IataCode{"LPE"}, CountryId{"CO"}, Tz::America_Bogota}, // La Primavera
    Airport{IataCode{"LPF"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Liupanshui Yuezhao Airport
    Airport{IataCode{"LPG"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // La Plata Airport
    Airport{IataCode{"LPI"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Linköping/Saab Airport
    Airport{IataCode{"LPK"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Lipetsk Airport
    Airport{IataCode{"LPL"}, CountryId{"GB"}, Tz::Europe_London}, // Liverpool John Lennon Airport
    Airport{IataCode{"LPM"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Malekoula Airport
    Airport{IataCode{"LPN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Leron Plains Airport
    Airport{IataCode{"LPO"}, CountryId{"US"}, Tz::America_Chicago}, // La Porte Municipal Airport
    Airport{IataCode{"LPP"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Lappeenranta Airport
    Airport{IataCode{"LPQ"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Luang Prabang International Airport
    Airport{IataCode{"LPT"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Lampang Airport
    Airport{IataCode{"LPU"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Long Apung Airport
    Airport{IataCode{"LPX"}, CountryId{"LV"}, Tz::Europe_Riga}, // Liepāja International Airport
    Airport{IataCode{"LPY"}, CountryId{"FR"}, Tz::Europe_Paris}, // Le Puy – Loudes Airport
    Airport{IataCode{"LQK"}, CountryId{"US"}, Tz::America_New_York}, // Pickens County Airport
    Airport{IataCode{"LQM"}, CountryId{"CO"}, Tz::America_Bogota}, // Caucayá Airport
    Airport{IataCode{"LQN"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Qala i Naw Airport
    Airport{IataCode{"LRB"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Leribe Airport
    Airport{IataCode{"LRD"}, CountryId{"US"}, Tz::America_Chicago}, // Laredo International Airport
    Airport{IataCode{"LRE"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Longreach Airport
    Airport{IataCode{"LRG"}, CountryId{"US"}, Tz::America_New_York}, // Lincoln Regional Airport
    Airport{IataCode{"LRH"}, CountryId{"FR"}, Tz::Europe_Paris}, // La Rochelle – Île de Ré Airport
    Airport{IataCode{"LRI"}, CountryId{"CO"}, Tz::America_Bogota}, // Lorica
    Airport{IataCode{"LRJ"}, CountryId{"US"}, Tz::America_Chicago}, // Le Mars Municipal Airport
    Airport{IataCode{"LRL"}, CountryId{"TG"}, Tz::Africa_Lome}, // Niamtougou International Airport
    Airport{IataCode{"LRM"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // La Romana International Airport
    Airport{IataCode{"LRO"}, CountryId{"US"}, Tz::America_New_York}, // Mount Pleasant Regional Airport
    Airport{IataCode{"LRQ"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Laurie River Airport
    Airport{IataCode{"LRR"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Larestan International Airport
    Airport{IataCode{"LRS"}, CountryId{"GR"}, Tz::Europe_Athens}, // Leros Island National Airport
    Airport{IataCode{"LRT"}, CountryId{"FR"}, Tz::Europe_Paris}, // Lorient South Brittany Airport
    Airport{IataCode{"LRU"}, CountryId{"US"}, Tz::America_Denver}, // Las Cruces International Airport
    Airport{IataCode{"LRV"}, CountryId{"VE"}, Tz::America_Caracas}, // Los Roques Airport
    Airport{IataCode{"LSA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Losuia Airport
    Airport{IataCode{"LSC"}, CountryId{"CL"}, Tz::America_Santiago}, // La Florida Airport
    Airport{IataCode{"LSE"}, CountryId{"US"}, Tz::America_Chicago}, // La Crosse Regional Airport
    Airport{IataCode{"LSH"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Lashio Airport
    Airport{IataCode{"LSI"}, CountryId{"GB"}, Tz::Europe_London}, // Sumburgh Airport
    Airport{IataCode{"LSL"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Los Chiles Airport
    Airport{IataCode{"LSM"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Long Semado Airport
    Airport{IataCode{"LSN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Los Banos Municipal Airport
    Airport{IataCode{"LSP"}, CountryId{"VE"}, Tz::America_Caracas}, // Josefa Camejo International Airport
    Airport{IataCode{"LSQ"}, CountryId{"CL"}, Tz::America_Santiago}, // María Dolores Airport
    Airport{IataCode{"LSS"}, CountryId{"FR"}, Tz::America_Guadeloupe}, // Les Saintes Airport
    Airport{IataCode{"LST"}, CountryId{"AU"}, Tz::Australia_Hobart}, // Launceston Airport
    Airport{IataCode{"LSU"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Long Sukang Airport
    Airport{IataCode{"LSW"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Malikus Saleh Airport
    Airport{IataCode{"LSX"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Lhok Sukon Airport
    Airport{IataCode{"LSY"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Lismore Airport
    Airport{IataCode{"LSZ"}, CountryId{"HR"}, Tz::Europe_Zagreb}, // Lošinj Airport
    Airport{IataCode{"LTA"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Tzaneen Airport
    Airport{IataCode{"LTC"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Laï Airport
    Airport{IataCode{"LTD"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Ghadames Airport
    Airport{IataCode{"LTG"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Langtang Airport
    Airport{IataCode{"LTI"}, CountryId{"MN"}, Tz::Asia_Hovd}, // Altai Airport
    Airport{IataCode{"LTK"}, CountryId{"SY"}, Tz::Asia_Damascus}, // Bassel Al-Assad International Airport
    Airport{IataCode{"LTL"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Lastoursville Airport
    Airport{IataCode{"LTM"}, CountryId{"GY"}, Tz::America_Guyana}, // Lethem Airport
    Airport{IataCode{"LTN"}, CountryId{"GB"}, Tz::Europe_London}, // Luton Airport
    Airport{IataCode{"LTO"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Loreto International Airport
    Airport{IataCode{"LTQ"}, CountryId{"FR"}, Tz::Europe_Paris}, // Le Touquet – Côte d'Opale Airport
    Airport{IataCode{"LTT"}, CountryId{"FR"}, Tz::Europe_Paris}, // La Môle – Saint-Tropez Airport
    Airport{IataCode{"LTU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Latur Airport
    Airport{IataCode{"LTW"}, CountryId{"US"}, Tz::America_New_York}, // St. Mary's County Regional Airport
    Airport{IataCode{"LTX"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Cotopaxi International Airport
    Airport{IataCode{"LUA"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Tenzing-Hillary Airport
    Airport{IataCode{"LUB"}, CountryId{"GY"}, Tz::America_Guyana}, // Lumid Pau Airport
    Airport{IataCode{"LUC"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Laucala Airport
    Airport{IataCode{"LUD"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Lüderitz Airport
    Airport{IataCode{"LUE"}, CountryId{"SK"}, Tz::Europe_Bratislava}, // Boľkovce-Lucenec
    Airport{IataCode{"LUG"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Lugano Airport
    Airport{IataCode{"LUH"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Sahnewal Airport
    Airport{IataCode{"LUI"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // La Unión Airport
    Airport{IataCode{"LUK"}, CountryId{"US"}, Tz::America_New_York}, // Cincinnati Municipal Lunken Airport
    Airport{IataCode{"LUL"}, CountryId{"US"}, Tz::America_Chicago}, // Hesler-Noble Field
    Airport{IataCode{"LUM"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Dehong Mangshi Airport
    Airport{IataCode{"LUN"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Kenneth Kaunda International Airport
    Airport{IataCode{"LUO"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Luena Airport
    Airport{IataCode{"LUP"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Kalaupapa Airport
    Airport{IataCode{"LUQ"}, CountryId{"AR"}, Tz::America_Argentina_San_Luis}, // Brigadier Mayor César Raúl Ojeda Airport
    Airport{IataCode{"LUS"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Lusanga Airport
    Airport{IataCode{"LUU"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Laura Airport
    Airport{IataCode{"LUV"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Karel Sadsuitubun Airport
    Airport{IataCode{"LUW"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Syukuran Aminuddin Amir Airport
    Airport{IataCode{"LUX"}, CountryId{"LU"}, Tz::Europe_Luxembourg}, // Luxembourg Airport
    Airport{IataCode{"LUZ"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Lublin Airport
    Airport{IataCode{"LVA"}, CountryId{"FR"}, Tz::Europe_Paris}, // Laval - Entrammes Airport
    Airport{IataCode{"LVB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Santana do Livramento Airport
    Airport{IataCode{"LVI"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Harry Mwanga Nkumbula International Airport
    Airport{IataCode{"LVK"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Livermore Municipal Airport
    Airport{IataCode{"LVM"}, CountryId{"US"}, Tz::America_Denver}, // Mission Field
    Airport{IataCode{"LVO"}, CountryId{"AU"}, Tz::Australia_Perth}, // Laverton Airport
    Airport{IataCode{"LVP"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Lavan Airport
    Airport{IataCode{"LVR"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Lucas do Rio Verde Airport
    Airport{IataCode{"LVS"}, CountryId{"US"}, Tz::America_Denver}, // Las Vegas Municipal Airport
    Airport{IataCode{"LWB"}, CountryId{"US"}, Tz::America_New_York}, // Greenbrier Valley Airport
    Airport{IataCode{"LWC"}, CountryId{"US"}, Tz::America_Chicago}, // Lawrence Municipal Airport
    Airport{IataCode{"LWE"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Wonopito Airport
    Airport{IataCode{"LWL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Wells Municipal Airport
    Airport{IataCode{"LWM"}, CountryId{"US"}, Tz::America_New_York}, // Lawrence Municipal Airport
    Airport{IataCode{"LWN"}, CountryId{"AM"}, Tz::Asia_Yerevan}, // Shirak International Airport
    Airport{IataCode{"LWO"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Lviv Danylo Halytskyi International Airport
    Airport{IataCode{"LWS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Lewiston – Nez Perce County Airport
    Airport{IataCode{"LWT"}, CountryId{"US"}, Tz::America_Denver}, // Lewistown Municipal Airport
    Airport{IataCode{"LWV"}, CountryId{"US"}, Tz::America_Chicago}, // Lawrenceville-Vincennes International Airport
    Airport{IataCode{"LWY"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Lawas Airport
    Airport{IataCode{"LXA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Lhasa Gonggar Airport
    Airport{IataCode{"LXG"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Louangnamtha Airport
    Airport{IataCode{"LXN"}, CountryId{"US"}, Tz::America_Chicago}, // Jim Kelly Field
    Airport{IataCode{"LXR"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Luxor International Airport
    Airport{IataCode{"LXS"}, CountryId{"GR"}, Tz::Europe_Athens}, // Lemnos International Airport
    Airport{IataCode{"LXU"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Lukulu Airport
    Airport{IataCode{"LXV"}, CountryId{"US"}, Tz::America_Denver}, // Lake County Airport
    Airport{IataCode{"LYA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Luoyang Beijiao Airport
    Airport{IataCode{"LYB"}, CountryId{"GB"}, Tz::America_Cayman}, // Edward Bodden Airfield
    Airport{IataCode{"LYC"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Lycksele Airport
    Airport{IataCode{"LYG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Lianyungang Airport
    Airport{IataCode{"LYH"}, CountryId{"US"}, Tz::America_New_York}, // Lynchburg Regional Airport
    Airport{IataCode{"LYI"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Linyi Qiyang Airport
    Airport{IataCode{"LYN"}, CountryId{"FR"}, Tz::Europe_Paris}, // Lyon-Bron Airport
    Airport{IataCode{"LYP"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Faisalabad International Airport
    Airport{IataCode{"LYR"}, CountryId{"NO"}, Tz::Arctic_Longyearbyen}, // Svalbard Airport
    Airport{IataCode{"LYS"}, CountryId{"FR"}, Tz::Europe_Paris}, // Lyon-Saint Exupéry Airport
    Airport{IataCode{"LYU"}, CountryId{"US"}, Tz::America_Chicago}, // Ely Municipal Airport
    Airport{IataCode{"LYX"}, CountryId{"GB"}, Tz::Europe_London}, // Lydd Airport
    Airport{IataCode{"LZA"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Luiza Airport
    Airport{IataCode{"LZC"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Lázaro Cárdenas Airport
    Airport{IataCode{"LZH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Liuzhou Bailian Airport
    Airport{IataCode{"LZM"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Luzamba Airport
    Airport{IataCode{"LZN"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Matsu Nangan Airport
    Airport{IataCode{"LZO"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Luzhou Yunlong Airport
    Airport{IataCode{"LZR"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Lizard Island Airport
    Airport{IataCode{"LZU"}, CountryId{"US"}, Tz::America_New_York}, // Gwinnett County Airport
    Airport{IataCode{"LZY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Nyingchi Mainling Airport
    Airport{IataCode{"MAA"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Chennai International Airport
    Airport{IataCode{"MAB"}, CountryId{"BR"}, Tz::America_Belem}, // Marabá Airport
    Airport{IataCode{"MAC"}, CountryId{"US"}, Tz::America_New_York}, // Macon Downtown Airport
    Airport{IataCode{"MAD"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Adolfo Suarez Madrid-Barajas Airport
    Airport{IataCode{"MAE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Madera Municipal Airport
    Airport{IataCode{"MAF"}, CountryId{"US"}, Tz::America_Chicago}, // Midland International Airport
    Airport{IataCode{"MAG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Madang Airport
    Airport{IataCode{"MAH"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Menorca Airport
    Airport{IataCode{"MAI"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Mangochi Airport
    Airport{IataCode{"MAJ"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Marshall Islands International Airport
    Airport{IataCode{"MAK"}, CountryId{"SS"}, Tz::Africa_Juba}, // Malakal Airport
    Airport{IataCode{"MAL"}, CountryId{"US"}, Tz::America_New_York}, // Malone-Dufort Airport
    Airport{IataCode{"MAM"}, CountryId{"MX"}, Tz::America_Matamoros}, // General Servando Canales International Airport
    Airport{IataCode{"MAN"}, CountryId{"GB"}, Tz::Europe_London}, // Manchester Airport
    Airport{IataCode{"MAO"}, CountryId{"BR"}, Tz::America_Manaus}, // Manaus International Airport
    Airport{IataCode{"MAP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Mamai
    Airport{IataCode{"MAQ"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Mae Sot Airport
    Airport{IataCode{"MAR"}, CountryId{"VE"}, Tz::America_Caracas}, // La Chinita International Airport
    Airport{IataCode{"MAS"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Momote Airport
    Airport{IataCode{"MAT"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Tshimpi Airport
    Airport{IataCode{"MAU"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Maupiti Airport
    Airport{IataCode{"MAV"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Maloelap Airport
    Airport{IataCode{"MAW"}, CountryId{"US"}, Tz::America_Chicago}, // Malden Regional Airport
    Airport{IataCode{"MAY"}, CountryId{"BS"}, Tz::America_Nassau}, // Clarence A. Bain Airport
    Airport{IataCode{"MAZ"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // Eugenio María de Hostos Airport
    Airport{IataCode{"MBA"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Moi International Airport
    Airport{IataCode{"MBC"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Mbigou Airport
    Airport{IataCode{"MBD"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Mafikeng Airport
    Airport{IataCode{"MBE"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Monbetsu Airport
    Airport{IataCode{"MBG"}, CountryId{"US"}, Tz::America_Chicago}, // Mobridge Municipal Airport
    Airport{IataCode{"MBH"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Maryborough Airport
    Airport{IataCode{"MBI"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Mbeya Airport
    Airport{IataCode{"MBJ"}, CountryId{"JM"}, Tz::America_Jamaica}, // Sangster International Airport
    Airport{IataCode{"MBK"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Matupá Airport
    Airport{IataCode{"MBL"}, CountryId{"US"}, Tz::America_Detroit}, // Manistee County Blacker Airport
    Airport{IataCode{"MBO"}, CountryId{"PH"}, Tz::Asia_Manila}, // Mamburao Airport
    Airport{IataCode{"MBP"}, CountryId{"PE"}, Tz::America_Lima}, // Moyobamba Airport
    Airport{IataCode{"MBQ"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Mbarara Airport
    Airport{IataCode{"MBS"}, CountryId{"US"}, Tz::America_Detroit}, // MBS International Airport
    Airport{IataCode{"MBT"}, CountryId{"PH"}, Tz::Asia_Manila}, // Moises R. Espinosa Airport
    Airport{IataCode{"MBU"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Mbambanakira Airport
    Airport{IataCode{"MBW"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Moorabbin Airport
    Airport{IataCode{"MBX"}, CountryId{"SI"}, Tz::Europe_Ljubljana}, // Maribor Edvard Rusjan Airport
    Airport{IataCode{"MBZ"}, CountryId{"BR"}, Tz::America_Manaus}, // Maués Airport
    Airport{IataCode{"MCA"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Macenta Airport
    Airport{IataCode{"MCB"}, CountryId{"US"}, Tz::America_Chicago}, // McComb-Pike County Airport
    Airport{IataCode{"MCC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // McClellan Airfield
    Airport{IataCode{"MCD"}, CountryId{"US"}, Tz::America_Detroit}, // Mackinac Island Airport
    Airport{IataCode{"MCE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Merced Regional Airport
    Airport{IataCode{"MCG"}, CountryId{"US"}, Tz::America_Anchorage}, // McGrath Airport
    Airport{IataCode{"MCH"}, CountryId{"EC"}, Tz::America_Guayaquil}, // General Manuel Serrano Airport
    Airport{IataCode{"MCI"}, CountryId{"US"}, Tz::America_Chicago}, // Kansas City International Airport
    Airport{IataCode{"MCJ"}, CountryId{"CO"}, Tz::America_Bogota}, // Jorge Isaacs Airport
    Airport{IataCode{"MCK"}, CountryId{"US"}, Tz::America_Chicago}, // McCook Ben Nelson Regional Airport
    Airport{IataCode{"MCL"}, CountryId{"US"}, Tz::America_Anchorage}, // McKinley National Park Airport
    Airport{IataCode{"MCM"}, CountryId{"MC"}, Tz::Europe_Monaco}, // Monaco Heliport
    Airport{IataCode{"MCN"}, CountryId{"US"}, Tz::America_New_York}, // Middle Georgia Regional Airport
    Airport{IataCode{"MCO"}, CountryId{"US"}, Tz::America_New_York}, // Orlando International Airport
    Airport{IataCode{"MCP"}, CountryId{"BR"}, Tz::America_Belem}, // Macapá International Airport
    Airport{IataCode{"MCQ"}, CountryId{"HU"}, Tz::Europe_Budapest}, // Miskolc Airport
    Airport{IataCode{"MCS"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Monte Caseros Airport
    Airport{IataCode{"MCT"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Muscat International Airport
    Airport{IataCode{"MCV"}, CountryId{"AU"}, Tz::Australia_Darwin}, // McArthur River Mine Airport
    Airport{IataCode{"MCW"}, CountryId{"US"}, Tz::America_Chicago}, // Mason City Municipal Airport
    Airport{IataCode{"MCX"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Uytash Airport
    Airport{IataCode{"MCY"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Sunshine Coast Airport
    Airport{IataCode{"MCZ"}, CountryId{"BR"}, Tz::America_Maceio}, // Zumbi dos Palmares International Airport
    Airport{IataCode{"MDB"}, CountryId{"BZ"}, Tz::America_Belize}, // Melinda Airport
    Airport{IataCode{"MDC"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Sam Ratulangi International Airport
    Airport{IataCode{"MDD"}, CountryId{"US"}, Tz::America_Chicago}, // Midland Airpark
    Airport{IataCode{"MDE"}, CountryId{"CO"}, Tz::America_Bogota}, // José María Córdova International Airport
    Airport{IataCode{"MDF"}, CountryId{"US"}, Tz::America_Chicago}, // Taylor County Airport
    Airport{IataCode{"MDG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Mudanjiang Hailang International Airport
    Airport{IataCode{"MDH"}, CountryId{"US"}, Tz::America_Chicago}, // Southern Illinois Airport
    Airport{IataCode{"MDI"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Makurdi Airport
    Airport{IataCode{"MDJ"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Madras Municipal Airport
    Airport{IataCode{"MDK"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Mbandaka Airport
    Airport{IataCode{"MDL"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Mandalay International Airport
    Airport{IataCode{"MDM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Munduku
    Airport{IataCode{"MDO"}, CountryId{"US"}, Tz::America_Anchorage}, // Middleton Island Airport
    Airport{IataCode{"MDQ"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Astor Piazzolla International Airport
    Airport{IataCode{"MDS"}, CountryId{"GB"}, Tz::America_Grand_Turk}, // Middle Caicos Airport
    Airport{IataCode{"MDT"}, CountryId{"US"}, Tz::America_New_York}, // Harrisburg International Airport
    Airport{IataCode{"MDU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Mendi Airport
    Airport{IataCode{"MDV"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Médouneu Airport
    Airport{IataCode{"MDW"}, CountryId{"US"}, Tz::America_Chicago}, // Chicago Midway International Airport
    Airport{IataCode{"MDX"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Mercedes Airport
    Airport{IataCode{"MDY"}, CountryId{"US"}, Tz::Pacific_Midway}, // Henderson Field
    Airport{IataCode{"MDZ"}, CountryId{"AR"}, Tz::America_Argentina_Mendoza}, // Governor Francisco Gabrielli International Airport
    Airport{IataCode{"MEA"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Macaé Airport
    Airport{IataCode{"MEB"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Essendon Airport
    Airport{IataCode{"MEC"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Eloy Alfaro International Airport
    Airport{IataCode{"MED"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Prince Mohammad Bin Abdulaziz International Airport
    Airport{IataCode{"MEE"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Maré Airport
    Airport{IataCode{"MEF"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Melfi Airport
    Airport{IataCode{"MEG"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Malanje Airport
    Airport{IataCode{"MEH"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Mehamn Airport
    Airport{IataCode{"MEI"}, CountryId{"US"}, Tz::America_Chicago}, // Meridian Regional Airport
    Airport{IataCode{"MEJ"}, CountryId{"US"}, Tz::America_New_York}, // Port Meadville Airport
    Airport{IataCode{"MEL"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Melbourne Airport
    Airport{IataCode{"MEM"}, CountryId{"US"}, Tz::America_Chicago}, // Memphis International Airport
    Airport{IataCode{"MEO"}, CountryId{"US"}, Tz::America_New_York}, // Dare County Regional Airport
    Airport{IataCode{"MEP"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Mersing Airport
    Airport{IataCode{"MEQ"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Cut Nyak Dhien Airport
    Airport{IataCode{"MER"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Castle Airport
    Airport{IataCode{"MEU"}, CountryId{"BR"}, Tz::America_Santarem}, // Monte Dourado Airport
    Airport{IataCode{"MEV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Minden-Tahoe Airport
    Airport{IataCode{"MEW"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Mweka Airport
    Airport{IataCode{"MEX"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Mexico City International Airport
    Airport{IataCode{"MEY"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Meghauli Airport
    Airport{IataCode{"MEZ"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Messina Airport
    Airport{IataCode{"MFA"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Mafia Airport
    Airport{IataCode{"MFC"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Mafeteng Airport
    Airport{IataCode{"MFD"}, CountryId{"US"}, Tz::America_New_York}, // Mansfield Lahm Regional Airport
    Airport{IataCode{"MFE"}, CountryId{"US"}, Tz::America_Chicago}, // McAllen-Miller International Airport
    Airport{IataCode{"MFF"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Moanda Airport
    Airport{IataCode{"MFG"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Muzaffarabad Airport
    Airport{IataCode{"MFH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Mesquite Airport
    Airport{IataCode{"MFI"}, CountryId{"US"}, Tz::America_Chicago}, // Marshfield Municipal Airport
    Airport{IataCode{"MFJ"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Moala Airport
    Airport{IataCode{"MFK"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Matsu Beigan Airport
    Airport{IataCode{"MFM"}, CountryId{"CN"}, Tz::Asia_Macau}, // Macau International Airport
    Airport{IataCode{"MFN"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Milford Sound Airport
    Airport{IataCode{"MFO"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Manguna Airport
    Airport{IataCode{"MFQ"}, CountryId{"NE"}, Tz::Africa_Niamey}, // Maradi Airport
    Airport{IataCode{"MFR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Rogue Valley International-Medford Airport
    Airport{IataCode{"MFS"}, CountryId{"CO"}, Tz::America_Bogota}, // Miraflores Airport
    Airport{IataCode{"MFU"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Mfuwe Airport
    Airport{IataCode{"MFV"}, CountryId{"US"}, Tz::America_New_York}, // Accomack County Airport
    Airport{IataCode{"MFY"}, CountryId{"YE"}, Tz::Asia_Aden}, // Mayfa'ah,
    Airport{IataCode{"MFZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Meselia Airport
    Airport{IataCode{"MGA"}, CountryId{"NI"}, Tz::America_Managua}, // Augusto C. Sandino International Airport
    Airport{IataCode{"MGB"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Mount Gambier Airport
    Airport{IataCode{"MGC"}, CountryId{"US"}, Tz::America_Chicago}, // Michigan City Municipal Airport
    Airport{IataCode{"MGD"}, CountryId{"BO"}, Tz::America_La_Paz}, // Magdalena Airport
    Airport{IataCode{"MGF"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Maringá Regional Airport
    Airport{IataCode{"MGG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Margarima Airport
    Airport{IataCode{"MGH"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Margate Airport
    Airport{IataCode{"MGI"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Martín García Island Airport
    Airport{IataCode{"MGJ"}, CountryId{"US"}, Tz::America_New_York}, // Orange County Airport
    Airport{IataCode{"MGM"}, CountryId{"US"}, Tz::America_Chicago}, // Montgomery Regional Airport
    Airport{IataCode{"MGN"}, CountryId{"CO"}, Tz::America_Bogota}, // Baracoa Regional Airport
    Airport{IataCode{"MGQ"}, CountryId{"SO"}, Tz::Africa_Mogadishu}, // Aden Adde International Airport
    Airport{IataCode{"MGR"}, CountryId{"US"}, Tz::America_New_York}, // Moultrie Municipal Airport
    Airport{IataCode{"MGS"}, CountryId{"NZ"}, Tz::Pacific_Rarotonga}, // Mangaia Airport
    Airport{IataCode{"MGT"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Milingimbi Airport
    Airport{IataCode{"MGU"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Manaung Airport
    Airport{IataCode{"MGV"}, CountryId{"AU"}, Tz::Australia_Perth}, // Margaret River Station Airport
    Airport{IataCode{"MGW"}, CountryId{"US"}, Tz::America_New_York}, // Morgantown Municipal Airport
    Airport{IataCode{"MGX"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Moabi Airport
    Airport{IataCode{"MGY"}, CountryId{"US"}, Tz::America_New_York}, // Dayton–Wright Brothers Airport
    Airport{IataCode{"MGZ"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Myeik Airport
    Airport{IataCode{"MHA"}, CountryId{"GY"}, Tz::America_Guyana}, // Mahdia Airport
    Airport{IataCode{"MHC"}, CountryId{"CL"}, Tz::America_Santiago}, // Mocopulli Airport
    Airport{IataCode{"MHD"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Mashhad International Airport
    Airport{IataCode{"MHE"}, CountryId{"US"}, Tz::America_Chicago}, // Mitchell Municipal Airport
    Airport{IataCode{"MHH"}, CountryId{"BS"}, Tz::America_Nassau}, // Leonard M. Thompson International Airport
    Airport{IataCode{"MHI"}, CountryId{"DJ"}, Tz::Africa_Djibouti}, // Moucha Airport
    Airport{IataCode{"MHK"}, CountryId{"US"}, Tz::America_Chicago}, // Manhattan Regional Airport
    Airport{IataCode{"MHL"}, CountryId{"US"}, Tz::America_Chicago}, // Marshall Memorial Municipal Airport
    Airport{IataCode{"MHQ"}, CountryId{"FI"}, Tz::Europe_Mariehamn}, // Mariehamn Airport
    Airport{IataCode{"MHR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Sacramento Mather Airport
    Airport{IataCode{"MHS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Dunsmuir Municipal-Mott Airport
    Airport{IataCode{"MHT"}, CountryId{"US"}, Tz::America_New_York}, // Manchester–Boston Regional Airport
    Airport{IataCode{"MHU"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Mount Hotham Airport
    Airport{IataCode{"MHW"}, CountryId{"BO"}, Tz::America_La_Paz}, // Monteagudo Airport
    Airport{IataCode{"MHX"}, CountryId{"NZ"}, Tz::Pacific_Rarotonga}, // Manihiki Island Airport
    Airport{IataCode{"MHY"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Morehead
    Airport{IataCode{"MIA"}, CountryId{"US"}, Tz::America_New_York}, // Miami International Airport
    Airport{IataCode{"MIC"}, CountryId{"US"}, Tz::America_Chicago}, // Crystal Airport
    Airport{IataCode{"MID"}, CountryId{"MX"}, Tz::America_Merida}, // Manuel Crescencio Rejón International Airport
    Airport{IataCode{"MIE"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Delaware County Airport
    Airport{IataCode{"MIG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Mianyang Nanjiao Airport
    Airport{IataCode{"MII"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Marília Airport
    Airport{IataCode{"MIJ"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Mili Airport
    Airport{IataCode{"MIK"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Mikkeli Airport
    Airport{IataCode{"MIM"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Merimbula Airport
    Airport{IataCode{"MIO"}, CountryId{"US"}, Tz::America_Chicago}, // Miami Municipal Airport
    Airport{IataCode{"MIP"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Mitzpe Ramon Airfield
    Airport{IataCode{"MIQ"}, CountryId{"US"}, Tz::America_Chicago}, // Millard Airport
    Airport{IataCode{"MIR"}, CountryId{"TN"}, Tz::Africa_Tunis}, // Monastir Habib Bourguiba International Airport
    Airport{IataCode{"MIS"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Misima Airport
    Airport{IataCode{"MIT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Shafter Airport
    Airport{IataCode{"MIU"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Maiduguri International Airport
    Airport{IataCode{"MIV"}, CountryId{"US"}, Tz::America_New_York}, // Millville Municipal Airport
    Airport{IataCode{"MJA"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Manja Airport
    Airport{IataCode{"MJB"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Mejit Airport
    Airport{IataCode{"MJC"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Man Airport
    Airport{IataCode{"MJD"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Moenjodaro Airport
    Airport{IataCode{"MJE"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Majkin Airport
    Airport{IataCode{"MJF"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Mosjøen Airport
    Airport{IataCode{"MJI"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Mitiga International Airport
    Airport{IataCode{"MJJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Moki
    Airport{IataCode{"MJK"}, CountryId{"AU"}, Tz::Australia_Perth}, // Shark Bay Airport
    Airport{IataCode{"MJL"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Mouila Airport
    Airport{IataCode{"MJM"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Mbuji Mayi Airport
    Airport{IataCode{"MJN"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Amborovy Airport
    Airport{IataCode{"MJO"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Mount Etjo Airport
    Airport{IataCode{"MJP"}, CountryId{"AU"}, Tz::Australia_Perth}, // Manjimup Airport
    Airport{IataCode{"MJQ"}, CountryId{"US"}, Tz::America_Chicago}, // Jackson Municipal Airport
    Airport{IataCode{"MJR"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Miramar Airport
    Airport{IataCode{"MJT"}, CountryId{"GR"}, Tz::Europe_Athens}, // Mytilene International Airport
    Airport{IataCode{"MJU"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Tampa Padang Airport
    Airport{IataCode{"MJV"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Murcia-San Javier Airport
    Airport{IataCode{"MJX"}, CountryId{"US"}, Tz::America_New_York}, // Robert J. Miller Air Park
    Airport{IataCode{"MJZ"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Mirny Airport
    Airport{IataCode{"MKA"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Marianske Lazne Airport
    Airport{IataCode{"MKB"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Mekambo Airport
    Airport{IataCode{"MKC"}, CountryId{"US"}, Tz::America_Chicago}, // Charles B. Wheeler Downtown Airport
    Airport{IataCode{"MKE"}, CountryId{"US"}, Tz::America_Chicago}, // Milwaukee Mitchell International Airport
    Airport{IataCode{"MKG"}, CountryId{"US"}, Tz::America_Detroit}, // Muskegon County Airport
    Airport{IataCode{"MKH"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Mokhotlong Airport
    Airport{IataCode{"MKI"}, CountryId{"CF"}, Tz::Africa_Bangui}, // M'Boki Airport
    Airport{IataCode{"MKJ"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Makoua Airport
    Airport{IataCode{"MKK"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Molokai Airport
    Airport{IataCode{"MKL"}, CountryId{"US"}, Tz::America_Chicago}, // McKellar-Sipes Regional Airport
    Airport{IataCode{"MKM"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Mukah Airport
    Airport{IataCode{"MKN"}, CountryId{"US"}, Tz::America_Chicago}, // Comanche County-City Airport
    Airport{IataCode{"MKO"}, CountryId{"US"}, Tz::America_Chicago}, // Davis Field
    Airport{IataCode{"MKP"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Makemo Airport
    Airport{IataCode{"MKQ"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Mopah Airport
    Airport{IataCode{"MKR"}, CountryId{"AU"}, Tz::Australia_Perth}, // Meekatharra Airport
    Airport{IataCode{"MKS"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Mekane Selam Airport
    Airport{IataCode{"MKT"}, CountryId{"US"}, Tz::America_Chicago}, // Mankato Regional Airport
    Airport{IataCode{"MKU"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Makokou Airport
    Airport{IataCode{"MKW"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Rendani Airport
    Airport{IataCode{"MKY"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Mackay Airport
    Airport{IataCode{"MKZ"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Melaka International Airport
    Airport{IataCode{"MLA"}, CountryId{"MT"}, Tz::Europe_Malta}, // Malta International Airport
    Airport{IataCode{"MLB"}, CountryId{"US"}, Tz::America_New_York}, // Melbourne International Airport
    Airport{IataCode{"MLC"}, CountryId{"US"}, Tz::America_Chicago}, // McAlester Regional Airport
    Airport{IataCode{"MLE"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Velana International Airport
    Airport{IataCode{"MLG"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Abdul Rachman Saleh Airport
    Airport{IataCode{"MLH"}, CountryId{"FR"}, Tz::Europe_Paris}, // EuroAirport Basel-Mulhouse-Freiburg
    Airport{IataCode{"MLI"}, CountryId{"US"}, Tz::America_Chicago}, // Quad City International Airport
    Airport{IataCode{"MLJ"}, CountryId{"US"}, Tz::America_New_York}, // Baldwin County Airport
    Airport{IataCode{"MLL"}, CountryId{"US"}, Tz::America_Nome}, // Marshall Don Hunter Sr. Airport
    Airport{IataCode{"MLM"}, CountryId{"MX"}, Tz::America_Mexico_City}, // General Francisco J. Mujica International Airport
    Airport{IataCode{"MLN"}, CountryId{"ES"}, Tz::Africa_Ceuta}, // Melilla Airport
    Airport{IataCode{"MLO"}, CountryId{"GR"}, Tz::Europe_Athens}, // Milos Island National Airport
    Airport{IataCode{"MLP"}, CountryId{"PH"}, Tz::Asia_Manila}, // Malabang Airport
    Airport{IataCode{"MLS"}, CountryId{"US"}, Tz::America_Denver}, // Miles City Airport
    Airport{IataCode{"MLT"}, CountryId{"US"}, Tz::America_New_York}, // Millinocket Municipal Airport
    Airport{IataCode{"MLU"}, CountryId{"US"}, Tz::America_Chicago}, // Monroe Regional Airport
    Airport{IataCode{"MLW"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Spriggs Payne Airport
    Airport{IataCode{"MLY"}, CountryId{"US"}, Tz::America_Anchorage}, // Manley Hot Springs Airport
    Airport{IataCode{"MLZ"}, CountryId{"UY"}, Tz::America_Montevideo}, // Cerro Largo International Airport
    Airport{IataCode{"MMB"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Memanbetsu Airport
    Airport{IataCode{"MMC"}, CountryId{"MX"}, Tz::America_Monterrey}, // Ciudad Mante National Airport
    Airport{IataCode{"MMD"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Minami-Daito Airport
    Airport{IataCode{"MME"}, CountryId{"GB"}, Tz::Europe_London}, // Durham Tees Valley Airport
    Airport{IataCode{"MMF"}, CountryId{"CM"}, Tz::Africa_Douala}, // Mamfe Airport
    Airport{IataCode{"MMG"}, CountryId{"AU"}, Tz::Australia_Perth}, // Mount Magnet Airport
    Airport{IataCode{"MMH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Mammoth Yosemite Airport
    Airport{IataCode{"MMI"}, CountryId{"US"}, Tz::America_New_York}, // McMinn County Airport
    Airport{IataCode{"MMJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Matsumoto Airport
    Airport{IataCode{"MMK"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Murmansk Airport
    Airport{IataCode{"MML"}, CountryId{"US"}, Tz::America_Chicago}, // Southwest Minnesota Regional Airport
    Airport{IataCode{"MMM"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Middlemount Airport
    Airport{IataCode{"MMN"}, CountryId{"US"}, Tz::America_New_York}, // Minute Man Air Field
    Airport{IataCode{"MMO"}, CountryId{"CV"}, Tz::Atlantic_Cape_Verde}, // Maio Airport
    Airport{IataCode{"MMQ"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Mbala Airport
    Airport{IataCode{"MMT"}, CountryId{"US"}, Tz::America_New_York}, // McEntire Joint National Guard Base
    Airport{IataCode{"MMU"}, CountryId{"US"}, Tz::America_New_York}, // Morristown Municipal Airport
    Airport{IataCode{"MMV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // McMinnville Municipal Airport
    Airport{IataCode{"MMX"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Malmö Airport
    Airport{IataCode{"MMY"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Miyako Airport
    Airport{IataCode{"MMZ"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Maymana Airport
    Airport{IataCode{"MNA"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Melonguane Airport
    Airport{IataCode{"MNB"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Muanda Airport
    Airport{IataCode{"MNC"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Nacala Airport
    Airport{IataCode{"MNF"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Mana Island Airport
    Airport{IataCode{"MNG"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Maningrida Airport
    Airport{IataCode{"MNH"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Rustaq Airport
    Airport{IataCode{"MNI"}, CountryId{"GB"}, Tz::America_Montserrat}, // John A. Osborne Airport
    Airport{IataCode{"MNJ"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Mananjary Airport
    Airport{IataCode{"MNK"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Maiana Airport
    Airport{IataCode{"MNL"}, CountryId{"PH"}, Tz::Asia_Manila}, // Ninoy Aquino International Airport
    Airport{IataCode{"MNM"}, CountryId{"US"}, Tz::America_Menominee}, // Menominee-Marinette Twin County Airport
    Airport{IataCode{"MNN"}, CountryId{"US"}, Tz::America_New_York}, // Marion Municipal Airport
    Airport{IataCode{"MNQ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Monto Airport
    Airport{IataCode{"MNR"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Mongu Airport
    Airport{IataCode{"MNS"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Mansa Airport
    Airport{IataCode{"MNT"}, CountryId{"US"}, Tz::America_Anchorage}, // Minto Al Wright Airport
    Airport{IataCode{"MNU"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Mawlamyaing Airport
    Airport{IataCode{"MNX"}, CountryId{"BR"}, Tz::America_Manaus}, // Manicoré Airport
    Airport{IataCode{"MNY"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Mono Airport
    Airport{IataCode{"MNZ"}, CountryId{"US"}, Tz::America_New_York}, // Manassas Regional Airport
    Airport{IataCode{"MOA"}, CountryId{"CU"}, Tz::America_Havana}, // Orestes Acosta Airport
    Airport{IataCode{"MOB"}, CountryId{"US"}, Tz::America_Chicago}, // Mobile Regional Airport
    Airport{IataCode{"MOC"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Montes Claros Airport
    Airport{IataCode{"MOD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Modesto City-County Airport
    Airport{IataCode{"MOE"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Momeik Airport
    Airport{IataCode{"MOF"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Frans Seda Airport
    Airport{IataCode{"MOG"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Monghsat Airport
    Airport{IataCode{"MOI"}, CountryId{"NZ"}, Tz::Pacific_Rarotonga}, // Mitiaro Airport
    Airport{IataCode{"MOJ"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Moengo Airstrip
    Airport{IataCode{"MOL"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Molde Airport
    Airport{IataCode{"MOM"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Letfotar Airport
    Airport{IataCode{"MON"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Glentanner Aerodrome
    Airport{IataCode{"MOO"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Moomba Airport
    Airport{IataCode{"MOP"}, CountryId{"US"}, Tz::America_Detroit}, // Mount Pleasant Municipal Airport
    Airport{IataCode{"MOQ"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Morondava Airport
    Airport{IataCode{"MOR"}, CountryId{"US"}, Tz::America_New_York}, // Morristown Regional Airport
    Airport{IataCode{"MOS"}, CountryId{"US"}, Tz::America_Nome}, // Moses Point Airport
    Airport{IataCode{"MOT"}, CountryId{"US"}, Tz::America_Chicago}, // Minot International Airport
    Airport{IataCode{"MOU"}, CountryId{"US"}, Tz::America_Nome}, // Mountain Village Airport
    Airport{IataCode{"MOV"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Moranbah Airport
    Airport{IataCode{"MOZ"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Moorea Airport
    Airport{IataCode{"MPA"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Katima Mulilo Airport
    Airport{IataCode{"MPC"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Mukomuko Airport
    Airport{IataCode{"MPD"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Sindhri Airport
    Airport{IataCode{"MPF"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Mapoda
    Airport{IataCode{"MPG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Makini
    Airport{IataCode{"MPH"}, CountryId{"PH"}, Tz::Asia_Manila}, // Godofredo P. Ramos Airport
    Airport{IataCode{"MPJ"}, CountryId{"US"}, Tz::America_Chicago}, // Petit Jean Park Airport
    Airport{IataCode{"MPK"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Mokpo Airport
    Airport{IataCode{"MPL"}, CountryId{"FR"}, Tz::Europe_Paris}, // Montpellier – Méditerranée Airport
    Airport{IataCode{"MPM"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Maputo International Airport
    Airport{IataCode{"MPO"}, CountryId{"US"}, Tz::America_New_York}, // Pocono Mountains Municipal Airport
    Airport{IataCode{"MPP"}, CountryId{"PA"}, Tz::America_Panama}, // Mulatupo Airport
    Airport{IataCode{"MPQ"}, CountryId{"JO"}, Tz::Asia_Amman}, // Ma'an
    Airport{IataCode{"MPS"}, CountryId{"US"}, Tz::America_Chicago}, // Mount Pleasant Regional Airport
    Airport{IataCode{"MPV"}, CountryId{"US"}, Tz::America_New_York}, // Edward F. Knapp State Airport
    Airport{IataCode{"MPW"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Mariupol International Airport
    Airport{IataCode{"MPX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Miyanmin
    Airport{IataCode{"MPY"}, CountryId{"FR"}, Tz::America_Cayenne}, // Maripasoula Airport
    Airport{IataCode{"MPZ"}, CountryId{"US"}, Tz::America_Chicago}, // Mount Pleasant Municipal Airport
    Airport{IataCode{"MQB"}, CountryId{"US"}, Tz::America_Chicago}, // Macomb Municipal Airport
    Airport{IataCode{"MQC"}, CountryId{"FR"}, Tz::America_Miquelon}, // Miquelon Airport
    Airport{IataCode{"MQD"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Maquinchao Airport
    Airport{IataCode{"MQF"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Magnitogorsk International Airport
    Airport{IataCode{"MQJ"}, CountryId{"RU"}, Tz::Asia_Srednekolymsk}, // Moma Airport
    Airport{IataCode{"MQK"}, CountryId{"BO"}, Tz::America_La_Paz}, // San Matías Airport
    Airport{IataCode{"MQL"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Mildura Airport
    Airport{IataCode{"MQM"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Mardin Airport
    Airport{IataCode{"MQN"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Mo i Rana Airport
    Airport{IataCode{"MQP"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Kruger Mpumalanga International Airport
    Airport{IataCode{"MQQ"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Moundou Airport
    Airport{IataCode{"MQS"}, CountryId{"VC"}, Tz::America_St_Vincent}, // Mustique Airport
    Airport{IataCode{"MQT"}, CountryId{"US"}, Tz::America_Detroit}, // Sawyer International Airport
    Airport{IataCode{"MQU"}, CountryId{"CO"}, Tz::America_Bogota}, // Mariquita Airport
    Airport{IataCode{"MQV"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Mostaganem Airport
    Airport{IataCode{"MQW"}, CountryId{"US"}, Tz::America_New_York}, // Telfair-Wheeler Airport
    Airport{IataCode{"MQX"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Alula Aba Nega Airport
    Airport{IataCode{"MQY"}, CountryId{"US"}, Tz::America_Chicago}, // Smyrna Airport
    Airport{IataCode{"MQZ"}, CountryId{"AU"}, Tz::Australia_Perth}, // Margaret River Airport
    Airport{IataCode{"MRA"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Misrata Airport
    Airport{IataCode{"MRB"}, CountryId{"US"}, Tz::America_New_York}, // Eastern WV Regional Airport
    Airport{IataCode{"MRC"}, CountryId{"US"}, Tz::America_Chicago}, // Maury County Airport
    Airport{IataCode{"MRD"}, CountryId{"VE"}, Tz::America_Caracas}, // Alberto Carnevalli Airport
    Airport{IataCode{"MRE"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Mara Serena Airport
    Airport{IataCode{"MRG"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Mareeba Airfield
    Airport{IataCode{"MRI"}, CountryId{"US"}, Tz::America_Anchorage}, // Merrill Field
    Airport{IataCode{"MRJ"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Marcala Airport
    Airport{IataCode{"MRK"}, CountryId{"US"}, Tz::America_New_York}, // Marco Island Airport
    Airport{IataCode{"MRM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Manare
    Airport{IataCode{"MRN"}, CountryId{"US"}, Tz::America_New_York}, // Foothills Regional Airport
    Airport{IataCode{"MRO"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Hood Aerodrome
    Airport{IataCode{"MRQ"}, CountryId{"PH"}, Tz::Asia_Manila}, // Marinduque Airport
    Airport{IataCode{"MRR"}, CountryId{"EC"}, Tz::America_Guayaquil}, // José María Velasco Ibarra Airport
    Airport{IataCode{"MRS"}, CountryId{"FR"}, Tz::Europe_Paris}, // Marseille Provence Airport
    Airport{IataCode{"MRT"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Moroak Airport
    Airport{IataCode{"MRU"}, CountryId{"MU"}, Tz::Indian_Mauritius}, // Sir Seewoosagur Ramgoolam International Airport
    Airport{IataCode{"MRV"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Mineralnye Vody Airport
    Airport{IataCode{"MRW"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Lolland Falster Airport
    Airport{IataCode{"MRX"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Mahshahr Airport
    Airport{IataCode{"MRY"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Monterey Regional Airport
    Airport{IataCode{"MRZ"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Moree Airport
    Airport{IataCode{"MSA"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Muskrat Dam Airport
    Airport{IataCode{"MSC"}, CountryId{"US"}, Tz::America_Phoenix}, // Falcon Field
    Airport{IataCode{"MSF"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Mount Swan Airport
    Airport{IataCode{"MSG"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Matsaile Airport
    Airport{IataCode{"MSJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Misawa Airport
    Airport{IataCode{"MSL"}, CountryId{"US"}, Tz::America_Chicago}, // Northwest Alabama Regional Airport
    Airport{IataCode{"MSM"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Masi-Manimba Airport
    Airport{IataCode{"MSN"}, CountryId{"US"}, Tz::America_Chicago}, // Dane County Regional Airport
    Airport{IataCode{"MSO"}, CountryId{"US"}, Tz::America_Denver}, // Missoula International Airport
    Airport{IataCode{"MSP"}, CountryId{"US"}, Tz::America_Chicago}, // Minneapolis–Saint Paul International Airport
    Airport{IataCode{"MSQ"}, CountryId{"BY"}, Tz::Europe_Minsk}, // Minsk National Airport
    Airport{IataCode{"MSS"}, CountryId{"US"}, Tz::America_New_York}, // Massena International Airport
    Airport{IataCode{"MST"}, CountryId{"NL"}, Tz::Europe_Amsterdam}, // Maastricht Aachen Airport
    Airport{IataCode{"MSU"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Moshoeshoe I International Airport
    Airport{IataCode{"MSV"}, CountryId{"US"}, Tz::America_New_York}, // Sullivan County International Airport
    Airport{IataCode{"MSW"}, CountryId{"ER"}, Tz::Africa_Asmara}, // Massawa International Airport
    Airport{IataCode{"MSX"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Mossendjo Airport
    Airport{IataCode{"MSY"}, CountryId{"US"}, Tz::America_Chicago}, // Louis Armstrong New Orleans International Airport
    Airport{IataCode{"MSZ"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Welwitschia Mirabilis International Airport
    Airport{IataCode{"MTA"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Matamata Airport
    Airport{IataCode{"MTB"}, CountryId{"CO"}, Tz::America_Bogota}, // El Pindo Airport
    Airport{IataCode{"MTF"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Mizan Teferi Airport
    Airport{IataCode{"MTH"}, CountryId{"US"}, Tz::America_New_York}, // Florida Keys Marathon Airport
    Airport{IataCode{"MTJ"}, CountryId{"US"}, Tz::America_Denver}, // Montrose Regional Airport
    Airport{IataCode{"MTK"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Makin Airfield
    Airport{IataCode{"MTL"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Maitland Airport
    Airport{IataCode{"MTN"}, CountryId{"US"}, Tz::America_New_York}, // Martin State Airport
    Airport{IataCode{"MTO"}, CountryId{"US"}, Tz::America_Chicago}, // Coles County Memorial Airport
    Airport{IataCode{"MTP"}, CountryId{"US"}, Tz::America_New_York}, // Montauk Airport
    Airport{IataCode{"MTQ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Mitchell Airport
    Airport{IataCode{"MTR"}, CountryId{"CO"}, Tz::America_Bogota}, // Los Garzones Airport
    Airport{IataCode{"MTS"}, CountryId{"SZ"}, Tz::Africa_Mbabane}, // Matsapha Airport
    Airport{IataCode{"MTT"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Minatitlán/Coatzacoalcos National Airport
    Airport{IataCode{"MTV"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Mota Lava Airport
    Airport{IataCode{"MTW"}, CountryId{"US"}, Tz::America_Chicago}, // Manitowoc County Airport
    Airport{IataCode{"MTY"}, CountryId{"MX"}, Tz::America_Monterrey}, // Monterrey International Airport
    Airport{IataCode{"MTZ"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Bar Yehuda Airfield
    Airport{IataCode{"MUA"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Munda Airport
    Airport{IataCode{"MUB"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Maun Airport
    Airport{IataCode{"MUC"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Munich Airport
    Airport{IataCode{"MUD"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Mueda Airport
    Airport{IataCode{"MUE"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Waimea-Kohala Airport
    Airport{IataCode{"MUG"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Mulegé Airstrip
    Airport{IataCode{"MUH"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Marsa Matruh International Airport
    Airport{IataCode{"MUJ"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Mui Airport
    Airport{IataCode{"MUK"}, CountryId{"NZ"}, Tz::Pacific_Rarotonga}, // Mauke Airport
    Airport{IataCode{"MUL"}, CountryId{"US"}, Tz::America_New_York}, // Spence Airport
    Airport{IataCode{"MUN"}, CountryId{"VE"}, Tz::America_Caracas}, // José Tadeo Monagas International Airport
    Airport{IataCode{"MUR"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Marudi Airport
    Airport{IataCode{"MUS"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Minami Torishima Airport
    Airport{IataCode{"MUT"}, CountryId{"US"}, Tz::America_Chicago}, // Muscatine Municipal Airport
    Airport{IataCode{"MUW"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Ghriss Airport
    Airport{IataCode{"MUX"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Multan International Airport
    Airport{IataCode{"MUY"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Mouyondzi Airport
    Airport{IataCode{"MUZ"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Musoma Airport
    Airport{IataCode{"MVA"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Mývatn Airport
    Airport{IataCode{"MVB"}, CountryId{"GA"}, Tz::Africa_Libreville}, // M'Vengue El Hadj Omar Bongo Ondimba International Airport
    Airport{IataCode{"MVC"}, CountryId{"US"}, Tz::America_Chicago}, // Monroe County Airport
    Airport{IataCode{"MVD"}, CountryId{"UY"}, Tz::America_Montevideo}, // Carrasco International Airport
    Airport{IataCode{"MVE"}, CountryId{"US"}, Tz::America_Chicago}, // Montevideo–Chippewa County Airport
    Airport{IataCode{"MVI"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Manetai Airport
    Airport{IataCode{"MVJ"}, CountryId{"JM"}, Tz::America_Jamaica}, // Marlboro Airport
    Airport{IataCode{"MVL"}, CountryId{"US"}, Tz::America_New_York}, // Morrisville-Stowe State Airport
    Airport{IataCode{"MVM"}, CountryId{"US"}, Tz::America_Denver}, // Kayenta Airport
    Airport{IataCode{"MVN"}, CountryId{"US"}, Tz::America_Chicago}, // Mount Vernon Airport
    Airport{IataCode{"MVO"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Mongo Airport
    Airport{IataCode{"MVP"}, CountryId{"CO"}, Tz::America_Bogota}, // Fabio Alberto León Bentley Airport
    Airport{IataCode{"MVQ"}, CountryId{"BY"}, Tz::Europe_Minsk}, // Mogilev Airport
    Airport{IataCode{"MVR"}, CountryId{"CM"}, Tz::Africa_Douala}, // Salak Airport
    Airport{IataCode{"MVS"}, CountryId{"BR"}, Tz::America_Bahia}, // Mucuri Airport
    Airport{IataCode{"MVT"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Mataiva Airport
    Airport{IataCode{"MVV"}, CountryId{"FR"}, Tz::Europe_Paris}, // Megève Aerodrome
    Airport{IataCode{"MVW"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Skagit Regional Airport
    Airport{IataCode{"MVX"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Minvoul Airport
    Airport{IataCode{"MVY"}, CountryId{"US"}, Tz::America_New_York}, // Martha's Vineyard Airport
    Airport{IataCode{"MVZ"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Masvingo Airport
    Airport{IataCode{"MWA"}, CountryId{"US"}, Tz::America_Chicago}, // Veterans Airport of Southern Illinois
    Airport{IataCode{"MWB"}, CountryId{"AU"}, Tz::Australia_Perth}, // Morawa Airport
    Airport{IataCode{"MWC"}, CountryId{"US"}, Tz::America_Chicago}, // Lawrence J. Timmerman Airport
    Airport{IataCode{"MWE"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Merowe Airport
    Airport{IataCode{"MWF"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Maewo-Naone Airport
    Airport{IataCode{"MWG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Marawaka
    Airport{IataCode{"MWH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Grant County International Airport
    Airport{IataCode{"MWI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Maramuni Airport
    Airport{IataCode{"MWJ"}, CountryId{"GY"}, Tz::America_Guyana}, // Matthews Ridge
    Airport{IataCode{"MWK"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Matak Airport
    Airport{IataCode{"MWL"}, CountryId{"US"}, Tz::America_Chicago}, // Mineral Wells Airport
    Airport{IataCode{"MWN"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Mwadui Airport
    Airport{IataCode{"MWO"}, CountryId{"US"}, Tz::America_New_York}, // Middletown Regional Airport
    Airport{IataCode{"MWQ"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Magway Airport
    Airport{IataCode{"MWV"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Mondulkiri Airport
    Airport{IataCode{"MWX"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Muan International Airport
    Airport{IataCode{"MWZ"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Mwanza Airport
    Airport{IataCode{"MXA"}, CountryId{"US"}, Tz::America_Chicago}, // Manila Municipal Airport
    Airport{IataCode{"MXB"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Andi Jemma Airport
    Airport{IataCode{"MXC"}, CountryId{"US"}, Tz::America_Denver}, // Monticello Airport
    Airport{IataCode{"MXE"}, CountryId{"US"}, Tz::America_New_York}, // Laurinburg-Maxton Airport
    Airport{IataCode{"MXG"}, CountryId{"US"}, Tz::America_New_York}, // Marlboro Airport
    Airport{IataCode{"MXH"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Moro Airport
    Airport{IataCode{"MXI"}, CountryId{"PH"}, Tz::Asia_Manila}, // Imelda R. Marcos Airport
    Airport{IataCode{"MXJ"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Minna Airport
    Airport{IataCode{"MXL"}, CountryId{"MX"}, Tz::America_Tijuana}, // General Rodolfo Sánchez Taboada International Airport
    Airport{IataCode{"MXM"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Morombe Airport
    Airport{IataCode{"MXN"}, CountryId{"FR"}, Tz::Europe_Paris}, // Morlaix – Ploujean Airport
    Airport{IataCode{"MXO"}, CountryId{"US"}, Tz::America_Chicago}, // Monticello Regional Airport
    Airport{IataCode{"MXP"}, CountryId{"IT"}, Tz::Europe_Rome}, // Milan–Malpensa Airport
    Airport{IataCode{"MXS"}, CountryId{"WS"}, Tz::Pacific_Apia}, // Maota Airport
    Airport{IataCode{"MXT"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Maintirano Airport
    Airport{IataCode{"MXU"}, CountryId{"AU"}, Tz::Australia_Perth}, // Mullewa Airport
    Airport{IataCode{"MXV"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Mörön Airport
    Airport{IataCode{"MXW"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Mandalgovi Airport
    Airport{IataCode{"MXX"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Mora-Siljan Airport
    Airport{IataCode{"MXY"}, CountryId{"US"}, Tz::America_Anchorage}, // McCarthy Airport
    Airport{IataCode{"MXZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Meixian Airport
    Airport{IataCode{"MYA"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Moruya Airport
    Airport{IataCode{"MYB"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Mayumba Airport
    Airport{IataCode{"MYC"}, CountryId{"VE"}, Tz::America_Caracas}, // Mariscal Sucre Airport
    Airport{IataCode{"MYD"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Malindi Airport
    Airport{IataCode{"MYE"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Miyakejima Airport
    Airport{IataCode{"MYF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Montgomery-Gibbs Executive Airport
    Airport{IataCode{"MYG"}, CountryId{"BS"}, Tz::America_Nassau}, // Mayaguana Airport
    Airport{IataCode{"MYH"}, CountryId{"US"}, Tz::America_Phoenix}, // Marble Canyon Airport
    Airport{IataCode{"MYI"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Murray Island Airport
    Airport{IataCode{"MYJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Matsuyama Airport
    Airport{IataCode{"MYK"}, CountryId{"US"}, Tz::America_Anchorage}, // May Creek Airport
    Airport{IataCode{"MYL"}, CountryId{"US"}, Tz::America_Boise}, // McCall Municipal Airport
    Airport{IataCode{"MYM"}, CountryId{"GY"}, Tz::America_Guyana}, // Monkey Mountain Airport
    Airport{IataCode{"MYN"}, CountryId{"YE"}, Tz::Asia_Aden}, // Marib Airport
    Airport{IataCode{"MYP"}, CountryId{"TM"}, Tz::Asia_Ashgabat}, // Mary Airport
    Airport{IataCode{"MYQ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Mysore Airport
    Airport{IataCode{"MYR"}, CountryId{"US"}, Tz::America_New_York}, // Myrtle Beach International Airport
    Airport{IataCode{"MYT"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Myitkyina Airport
    Airport{IataCode{"MYU"}, CountryId{"US"}, Tz::America_Nome}, // Mekoryuk Airport
    Airport{IataCode{"MYV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Yuba County Airport
    Airport{IataCode{"MYW"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Mtwara Airport
    Airport{IataCode{"MYX"}, CountryId{"BS"}, Tz::America_Nassau}, // Big Whale Cay Airport
    Airport{IataCode{"MYY"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Miri Airport
    Airport{IataCode{"MYZ"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Monkey Bay Airport
    Airport{IataCode{"MZA"}, CountryId{"PE"}, Tz::America_Lima}, // Manuel Prado Airport
    Airport{IataCode{"MZB"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Mocímboa da Praia Airport
    Airport{IataCode{"MZC"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Mitzic Airport
    Airport{IataCode{"MZE"}, CountryId{"BZ"}, Tz::America_Belize}, // Manatee Airport
    Airport{IataCode{"MZI"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Mopti Airport
    Airport{IataCode{"MZJ"}, CountryId{"US"}, Tz::America_Phoenix}, // Pinal Airpark
    Airport{IataCode{"MZK"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Marakei Airport
    Airport{IataCode{"MZL"}, CountryId{"CO"}, Tz::America_Bogota}, // La Nubia Airport
    Airport{IataCode{"MZN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Minj Airport
    Airport{IataCode{"MZO"}, CountryId{"CU"}, Tz::America_Havana}, // Sierra Maestra Airport
    Airport{IataCode{"MZP"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Motueka Aerodrome
    Airport{IataCode{"MZR"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Mazar-i-Sharif Airport
    Airport{IataCode{"MZT"}, CountryId{"MX"}, Tz::America_Mazatlan}, // General Rafael Buelna International Airport
    Airport{IataCode{"MZU"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Muzzafarpur Airport
    Airport{IataCode{"MZV"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Mulu Airport
    Airport{IataCode{"MZW"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Mécheria Airport
    Airport{IataCode{"MZZ"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Marion Municipal Airport
    Airport{IataCode{"NAA"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Narrabri Airport
    Airport{IataCode{"NAC"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Naracoorte Airport
    Airport{IataCode{"NAE"}, CountryId{"BJ"}, Tz::Africa_Porto_Novo}, // Natitingou Airport
    Airport{IataCode{"NAG"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Dr. Babasaheb Ambedkar International Airport
    Airport{IataCode{"NAH"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Naha Airport
    Airport{IataCode{"NAI"}, CountryId{"GY"}, Tz::America_Guyana}, // Annai Airport
    Airport{IataCode{"NAJ"}, CountryId{"AZ"}, Tz::Asia_Baku}, // Nakhchivan Airport
    Airport{IataCode{"NAK"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Nakhon Ratchasima Airport
    Airport{IataCode{"NAL"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Nalchik Airport
    Airport{IataCode{"NAM"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Namlea Airport
    Airport{IataCode{"NAN"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Nadi International Airport
    Airport{IataCode{"NAO"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Nanchong Gaoping Airport
    Airport{IataCode{"NAP"}, CountryId{"IT"}, Tz::Europe_Rome}, // Naples International Airport
    Airport{IataCode{"NAQ"}, CountryId{"GL"}, Tz::America_Thule}, // Qaanaaq Airport
    Airport{IataCode{"NAR"}, CountryId{"CO"}, Tz::America_Bogota}, // Puerto Nare Airport
    Airport{IataCode{"NAS"}, CountryId{"BS"}, Tz::America_Nassau}, // Lynden Pindling International Airport
    Airport{IataCode{"NAT"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Greater Natal International Airport
    Airport{IataCode{"NAU"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Napuka Airport
    Airport{IataCode{"NAV"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Nevşehir Kapadokya Airport
    Airport{IataCode{"NAW"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Narathiwat Airport
    Airport{IataCode{"NAY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Beijing Nanyuan Airport
    Airport{IataCode{"NBB"}, CountryId{"CO"}, Tz::America_Bogota}, // Barranco Minas Airport
    Airport{IataCode{"NBC"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Begishevo Airport
    Airport{IataCode{"NBE"}, CountryId{"TN"}, Tz::Africa_Tunis}, // Enfidha – Hammamet International Airport
    Airport{IataCode{"NBL"}, CountryId{"PA"}, Tz::America_Panama}, // Wannukandi Airport
    Airport{IataCode{"NBN"}, CountryId{"GQ"}, Tz::Africa_Malabo}, // Annobon Airport
    Airport{IataCode{"NBO"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Jomo Kenyatta International Airport
    Airport{IataCode{"NBS"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Changbaishan Airport
    Airport{IataCode{"NBW"}, CountryId{"CU"}, Tz::America_New_York}, // Leeward Point Field
    Airport{IataCode{"NBX"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Nabire Airport
    Airport{IataCode{"NCA"}, CountryId{"GB"}, Tz::America_Grand_Turk}, // North Caicos Airport
    Airport{IataCode{"NCE"}, CountryId{"FR"}, Tz::Europe_Paris}, // Nice Côte d'Azur Airport
    Airport{IataCode{"NCG"}, CountryId{"MX"}, Tz::America_Chihuahua}, // Nuevo Casas Grandes Airport
    Airport{IataCode{"NCH"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Nachingwea Airport
    Airport{IataCode{"NCI"}, CountryId{"CO"}, Tz::America_Bogota}, // Necocli Airport
    Airport{IataCode{"NCJ"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Sunchales Airport
    Airport{IataCode{"NCL"}, CountryId{"GB"}, Tz::Europe_London}, // Newcastle International Airport
    Airport{IataCode{"NCN"}, CountryId{"US"}, Tz::America_Anchorage}, // Chenega Bay Airport
    Airport{IataCode{"NCR"}, CountryId{"NI"}, Tz::America_Managua}, // San Carlos Airport
    Airport{IataCode{"NCS"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Newcastle Airport
    Airport{IataCode{"NCT"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Nicoya Airport
    Airport{IataCode{"NCU"}, CountryId{"UZ"}, Tz::Asia_Samarkand}, // Nukus Airport
    Airport{IataCode{"NCY"}, CountryId{"FR"}, Tz::Europe_Paris}, // Annecy – Haute-Savoie – Mont Blanc Airport
    Airport{IataCode{"NDA"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Bandanaira Airport
    Airport{IataCode{"NDB"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Nouadhibou International Airport
    Airport{IataCode{"NDC"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Shri Guru Gobind Singh Ji Airport
    Airport{IataCode{"NDD"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Sumbe Airport
    Airport{IataCode{"NDE"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Mandera Airport
    Airport{IataCode{"NDF"}, CountryId{"AO"}, Tz::Africa_Luanda}, // N'dalatando Airport
    Airport{IataCode{"NDG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Qiqihar Sanjiazi Airport
    Airport{IataCode{"NDJ"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // N'Djamena International Airport
    Airport{IataCode{"NDK"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Namorik Airport
    Airport{IataCode{"NDL"}, CountryId{"CF"}, Tz::Africa_Bangui}, // N'Délé Airport
    Airport{IataCode{"NDM"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Mendi, Ethiopia Airport
    Airport{IataCode{"NDN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Nadunumu
    Airport{IataCode{"NDR"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Nador International Airport
    Airport{IataCode{"NDU"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Rundu Airport
    Airport{IataCode{"NEC"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Necochea Airport
    Airport{IataCode{"NEF"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Neftekamsk Airport
    Airport{IataCode{"NEG"}, CountryId{"JM"}, Tz::America_Jamaica}, // Negril Aerodrome
    Airport{IataCode{"NEK"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Nekemte Airport
    Airport{IataCode{"NER"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Chulman Airport
    Airport{IataCode{"NEU"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Sam Neua
    Airport{IataCode{"NEV"}, CountryId{"KN"}, Tz::America_St_Kitts}, // Vance W. Amory International Airport
    Airport{IataCode{"NFG"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Nefteyugansk Airport
    Airport{IataCode{"NFO"}, CountryId{"TO"}, Tz::Pacific_Tongatapu}, // Niuafoʻou Airport
    Airport{IataCode{"NGA"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Young Airport
    Airport{IataCode{"NGB"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Ningbo Lishe International Airport
    Airport{IataCode{"NGD"}, CountryId{"GB"}, Tz::America_Tortola}, // Auguste George Airport
    Airport{IataCode{"NGE"}, CountryId{"CM"}, Tz::Africa_Douala}, // Ngaoundéré Airport
    Airport{IataCode{"NGI"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Ngau Airport
    Airport{IataCode{"NGK"}, CountryId{"RU"}, Tz::Asia_Sakhalin}, // Nogliki Airport
    Airport{IataCode{"NGN"}, CountryId{"PA"}, Tz::America_Panama}, // Nargana Airport
    Airport{IataCode{"NGO"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Chubu Centrair International Airport
    Airport{IataCode{"NGQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Ngari Gunsa Airport
    Airport{IataCode{"NGR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Ningerum Airport
    Airport{IataCode{"NGS"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Nagasaki Airport
    Airport{IataCode{"NGX"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Manang Airport
    Airport{IataCode{"NHF"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // New Halfa Airport
    Airport{IataCode{"NHV"}, CountryId{"FR"}, Tz::Pacific_Marquesas}, // Nuku Hiva Airport
    Airport{IataCode{"NHZ"}, CountryId{"US"}, Tz::America_New_York}, // Brunswick Executive Airport
    Airport{IataCode{"NIA"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Nimba Airport
    Airport{IataCode{"NIB"}, CountryId{"US"}, Tz::America_Anchorage}, // Nikolai Airport
    Airport{IataCode{"NIF"}, CountryId{"AU"}, Tz::Australia_Perth}, // Nifty Airport
    Airport{IataCode{"NIG"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Nikunau Airport
    Airport{IataCode{"NIM"}, CountryId{"NE"}, Tz::Africa_Niamey}, // Diori Hamani International Airport
    Airport{IataCode{"NIO"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Nioki Airport
    Airport{IataCode{"NIU"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Niau Airport
    Airport{IataCode{"NIX"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Nioro Airport
    Airport{IataCode{"NJC"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Nizhnevartovsk Airport
    Airport{IataCode{"NJF"}, CountryId{"IQ"}, Tz::Asia_Baghdad}, // Al Najaf International Airport
    Airport{IataCode{"NKC"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Nouakchott–Oumtounsy International Airport
    Airport{IataCode{"NKG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Nanjing Lukou International Airport
    Airport{IataCode{"NKL"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // Nkolo Fuma Airport
    Airport{IataCode{"NKM"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Nagoya Airfield
    Airport{IataCode{"NKN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Nankina
    Airport{IataCode{"NKS"}, CountryId{"CM"}, Tz::Africa_Douala}, // Nkongsamba Airport
    Airport{IataCode{"NKT"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Şırnak Airport
    Airport{IataCode{"NKU"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Nkaus Airport
    Airport{IataCode{"NKY"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Yokangassi Airport
    Airport{IataCode{"NLA"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Simon Mwansa Kapwepwe International Airport
    Airport{IataCode{"NLD"}, CountryId{"MX"}, Tz::America_Matamoros}, // Quetzalcóatl International Airport
    Airport{IataCode{"NLE"}, CountryId{"US"}, Tz::America_Detroit}, // Jerry Tyler Memorial Airport
    Airport{IataCode{"NLF"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Darnley Island Airport
    Airport{IataCode{"NLG"}, CountryId{"US"}, Tz::America_Anchorage}, // Nelson Lagoon Airport
    Airport{IataCode{"NLH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Lugu Lake Airport
    Airport{IataCode{"NLI"}, CountryId{"RU"}, Tz::Asia_Vladivostok}, // Nikolayevsk-on-Amur Airport
    Airport{IataCode{"NLK"}, CountryId{"AU"}, Tz::Pacific_Norfolk}, // Norfolk Island Airport
    Airport{IataCode{"NLN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Kneeland Airport
    Airport{IataCode{"NLO"}, CountryId{"CD"}, Tz::Africa_Kinshasa}, // N'Dolo Airport
    Airport{IataCode{"NLP"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Nelspruit Airport
    Airport{IataCode{"NLT"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Nalati Airport
    Airport{IataCode{"NLV"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Mykolaiv Airport
    Airport{IataCode{"NMA"}, CountryId{"UZ"}, Tz::Asia_Tashkent}, // Namangan Airport
    Airport{IataCode{"NMB"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Daman Airport
    Airport{IataCode{"NMC"}, CountryId{"BS"}, Tz::America_Nassau}, // Norman's Cay Airport
    Airport{IataCode{"NME"}, CountryId{"US"}, Tz::America_Nome}, // Nightmute Airport
    Airport{IataCode{"NMF"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Maafaru International Airport
    Airport{IataCode{"NMG"}, CountryId{"PA"}, Tz::America_Panama}, // San Miguel Airport
    Airport{IataCode{"NML"}, CountryId{"CA"}, Tz::America_Edmonton}, // Fort McMurray/Mildred Lake Airport
    Airport{IataCode{"NMS"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Namsang Airport
    Airport{IataCode{"NMT"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Namtu Airport
    Airport{IataCode{"NNB"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Santa Ana Airport
    Airport{IataCode{"NNG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Nanning Wuxu International Airport
    Airport{IataCode{"NNI"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Namutoni Airport
    Airport{IataCode{"NNK"}, CountryId{"US"}, Tz::America_Anchorage}, // Naknek Airport
    Airport{IataCode{"NNL"}, CountryId{"US"}, Tz::America_Anchorage}, // Nondalton Airport
    Airport{IataCode{"NNM"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Naryan-Mar Airport
    Airport{IataCode{"NNN"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Sviatoshyn Airfield
    Airport{IataCode{"NNR"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Connemara Airport
    Airport{IataCode{"NNS"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Naini Saini Airport
    Airport{IataCode{"NNT"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Nan Nakhon Airport
    Airport{IataCode{"NNU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Jorge Schieber Airport
    Airport{IataCode{"NNX"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Nunukan Airport
    Airport{IataCode{"NNY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Nanyang Jiangying Airport
    Airport{IataCode{"NOB"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Nosara Airport
    Airport{IataCode{"NOC"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Ireland West Airport Knock
    Airport{IataCode{"NOG"}, CountryId{"MX"}, Tz::America_Hermosillo}, // Nogales International Airport
    Airport{IataCode{"NOJ"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Noyabrsk Airport
    Airport{IataCode{"NOK"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Nova Xavantina Airport
    Airport{IataCode{"NOM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Nomad River
    Airport{IataCode{"NON"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Nonouti Airport
    Airport{IataCode{"NOP"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Sinop Airport
    Airport{IataCode{"NOR"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Norðfjörður Airport
    Airport{IataCode{"NOS"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Fascene Airport
    Airport{IataCode{"NOT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Marin County Airport
    Airport{IataCode{"NOU"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // La Tontouta International Airport
    Airport{IataCode{"NOV"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Albano Machado Airport
    Airport{IataCode{"NOZ"}, CountryId{"RU"}, Tz::Asia_Novokuznetsk}, // Spichenkovo Airport
    Airport{IataCode{"NPE"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Hawke's Bay Airport
    Airport{IataCode{"NPL"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // New Plymouth Airport
    Airport{IataCode{"NPO"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Nanga Pinoh Airport
    Airport{IataCode{"NPR"}, CountryId{"BR"}, Tz::America_Santarem}, // Novo Progresso Airport
    Airport{IataCode{"NPT"}, CountryId{"US"}, Tz::America_New_York}, // Newport State Airport
    Airport{IataCode{"NPY"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Mpanda Airport
    Airport{IataCode{"NQA"}, CountryId{"US"}, Tz::America_Chicago}, // Millington Regional Jetport
    Airport{IataCode{"NQL"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Niquelândia Airport
    Airport{IataCode{"NQN"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Presidente Perón International Airport
    Airport{IataCode{"NQU"}, CountryId{"CO"}, Tz::America_Bogota}, // Reyes Murillo Airport
    Airport{IataCode{"NQY"}, CountryId{"GB"}, Tz::Europe_London}, // Newquay Cornwall Airport
    Airport{IataCode{"NRA"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Narrandera Airport
    Airport{IataCode{"NRE"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Namrole Airport
    Airport{IataCode{"NRG"}, CountryId{"AU"}, Tz::Australia_Perth}, // Narrogin Airport
    Airport{IataCode{"NRI"}, CountryId{"US"}, Tz::America_Chicago}, // Grand Lake Regional Airport
    Airport{IataCode{"NRK"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Norrköping Airport
    Airport{IataCode{"NRM"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Keibane Airport
    Airport{IataCode{"NRN"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Weeze Airport
    Airport{IataCode{"NRR"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // José Aponte de la Torre Airport
    Airport{IataCode{"NRT"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Narita International Airport
    Airport{IataCode{"NSH"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Noshahr Airport
    Airport{IataCode{"NSI"}, CountryId{"CM"}, Tz::Africa_Douala}, // Yaoundé Nsimalen International Airport
    Airport{IataCode{"NSK"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Alykel Airport
    Airport{IataCode{"NSM"}, CountryId{"AU"}, Tz::Australia_Perth}, // Norseman Airport
    Airport{IataCode{"NSN"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Nelson Airport, New Zealand
    Airport{IataCode{"NSO"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Scone Airport
    Airport{IataCode{"NST"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Nakhon Si Thammarat Airport
    Airport{IataCode{"NSX"}, CountryId{"GB"}, Tz::America_Tortola}, // North Sound Water Aerodrome
    Airport{IataCode{"NTB"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Notodden Airport
    Airport{IataCode{"NTE"}, CountryId{"FR"}, Tz::Europe_Paris}, // Nantes Atlantique Airport
    Airport{IataCode{"NTG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Nantong Xingdong Airport
    Airport{IataCode{"NTN"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Normanton Airport
    Airport{IataCode{"NTQ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Noto Airport
    Airport{IataCode{"NTR"}, CountryId{"MX"}, Tz::America_Monterrey}, // Del Norte International Airport
    Airport{IataCode{"NTT"}, CountryId{"TO"}, Tz::Pacific_Tongatapu}, // Niuatoputapu Airport
    Airport{IataCode{"NTX"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Ranai Airport
    Airport{IataCode{"NTY"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Pilanesberg International Airport
    Airport{IataCode{"NUB"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Numbulwar Airport
    Airport{IataCode{"NUD"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // En Nahud Airport
    Airport{IataCode{"NUE"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Nuremberg Airport
    Airport{IataCode{"NUG"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Nuguria
    Airport{IataCode{"NUI"}, CountryId{"US"}, Tz::America_Anchorage}, // Nuiqsut Airport
    Airport{IataCode{"NUK"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Nukutavake Airport
    Airport{IataCode{"NUL"}, CountryId{"US"}, Tz::America_Anchorage}, // Nulato Airport
    Airport{IataCode{"NUM"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Neom Airport
    Airport{IataCode{"NUP"}, CountryId{"US"}, Tz::America_Nome}, // Nunapitchuk Airport
    Airport{IataCode{"NUS"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Norsup Airport
    Airport{IataCode{"NUT"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Nutuve
    Airport{IataCode{"NUU"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Nakuru Airport
    Airport{IataCode{"NUX"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Novy Urengoy Airport
    Airport{IataCode{"NVA"}, CountryId{"CO"}, Tz::America_Bogota}, // Benito Salas Airport
    Airport{IataCode{"NVG"}, CountryId{"NI"}, Tz::America_Managua}, // Nueva Guinea Airport
    Airport{IataCode{"NVI"}, CountryId{"UZ"}, Tz::Asia_Samarkand}, // Navoi International Airport
    Airport{IataCode{"NVN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Nervino Airport
    Airport{IataCode{"NVR"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Novgorod Airport
    Airport{IataCode{"NVS"}, CountryId{"FR"}, Tz::Europe_Paris}, // Nevers-Fourchambault Airport
    Airport{IataCode{"NVT"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Ministro Victor Konder International Airport
    Airport{IataCode{"NWA"}, CountryId{"KM"}, Tz::Indian_Comoro}, // Mohéli Bandar Es Eslam Airport
    Airport{IataCode{"NWH"}, CountryId{"US"}, Tz::America_New_York}, // Parlin Field
    Airport{IataCode{"NWI"}, CountryId{"GB"}, Tz::Europe_London}, // Norwich International Airport
    Airport{IataCode{"NWT"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Nowata
    Airport{IataCode{"NYA"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Nyagan Airport
    Airport{IataCode{"NYE"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Nyeri Airport
    Airport{IataCode{"NYI"}, CountryId{"GH"}, Tz::Africa_Accra}, // Sunyani Airport
    Airport{IataCode{"NYK"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Nanyuki Airport
    Airport{IataCode{"NYM"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Nadym Airport
    Airport{IataCode{"NYN"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Nyngan Airport
    Airport{IataCode{"NYO"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Stockholm Skavsta Airport
    Airport{IataCode{"NYR"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Nyurba Airport
    Airport{IataCode{"NYT"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Nay Pyi Taw International Airport
    Airport{IataCode{"NYU"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Nyaung U Airport
    Airport{IataCode{"NZA"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Nzagi Airport
    Airport{IataCode{"NZC"}, CountryId{"PE"}, Tz::America_Lima}, // Maria Reiche Neuman Airport
    Airport{IataCode{"NZE"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Nzérékoré Airport
    Airport{IataCode{"NZH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Manzhouli Xijiao Airport
    Airport{IataCode{"NZL"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhalantun Chengjisihan Airport
    Airport{IataCode{"OAG"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Orange Airport
    Airport{IataCode{"OAJ"}, CountryId{"US"}, Tz::America_New_York}, // Albert J. Ellis Airport
    Airport{IataCode{"OAK"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Oakland International Airport
    Airport{IataCode{"OAL"}, CountryId{"BR"}, Tz::America_Porto_Velho}, // Cacoal Airport
    Airport{IataCode{"OAM"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Oamaru Airport
    Airport{IataCode{"OAN"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Olanchito
    Airport{IataCode{"OAR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Marina Municipal Airport
    Airport{IataCode{"OAS"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Sharana Airstrip
    Airport{IataCode{"OAX"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Xoxocotlán International Airport
    Airport{IataCode{"OBC"}, CountryId{"DJ"}, Tz::Africa_Djibouti}, // Obock Airport
    Airport{IataCode{"OBE"}, CountryId{"US"}, Tz::America_New_York}, // Okeechobee County Airport
    Airport{IataCode{"OBF"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Oberpfaffenhofen Airport
    Airport{IataCode{"OBI"}, CountryId{"BR"}, Tz::America_Santarem}, // Tirios Airport
    Airport{IataCode{"OBN"}, CountryId{"GB"}, Tz::Europe_London}, // Oban Airport
    Airport{IataCode{"OBO"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Tokachi-Obihiro Airport
    Airport{IataCode{"OBU"}, CountryId{"US"}, Tz::America_Anchorage}, // Kobuk Airport
    Airport{IataCode{"OBX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Obo Airport
    Airport{IataCode{"OCA"}, CountryId{"US"}, Tz::America_New_York}, // Ocean Reef Club Airport
    Airport{IataCode{"OCC"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Francisco de Orellana Airport
    Airport{IataCode{"OCE"}, CountryId{"US"}, Tz::America_New_York}, // Ocean City Municipal Airport
    Airport{IataCode{"OCF"}, CountryId{"US"}, Tz::America_New_York}, // Ocala International Airport
    Airport{IataCode{"OCJ"}, CountryId{"JM"}, Tz::America_Jamaica}, // Ian Fleming International Airport
    Airport{IataCode{"OCM"}, CountryId{"AU"}, Tz::Australia_Perth}, // Boolgeeda Airport
    Airport{IataCode{"OCN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Oceanside Municipal Airport
    Airport{IataCode{"OCS"}, CountryId{"GQ"}, Tz::Africa_Malabo}, // Corisco International Airport
    Airport{IataCode{"OCV"}, CountryId{"CO"}, Tz::America_Bogota}, // Aguas Claras Airport
    Airport{IataCode{"ODA"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Ouadda Airport
    Airport{IataCode{"ODB"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Córdoba Airport
    Airport{IataCode{"ODC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Oakdale Airport
    Airport{IataCode{"ODE"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Hans Christian Andersen Airport
    Airport{IataCode{"ODJ"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Ouanda Djallé Airport
    Airport{IataCode{"ODM"}, CountryId{"US"}, Tz::America_New_York}, // Garrett County Airport
    Airport{IataCode{"ODN"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Long Seridan Airport
    Airport{IataCode{"ODO"}, CountryId{"RU"}, Tz::Asia_Irkutsk}, // Bodaybo Airport
    Airport{IataCode{"ODS"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Odessa International Airport
    Airport{IataCode{"ODW"}, CountryId{"US"}, Tz::America_Los_Angeles}, // A.J. Eisenberg Airport
    Airport{IataCode{"ODY"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Oudomsay Airport
    Airport{IataCode{"OEC"}, CountryId{"TL"}, Tz::Asia_Dili}, // Oecusse Airport
    Airport{IataCode{"OEL"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Oryol Yuzhny Airport
    Airport{IataCode{"OEM"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Vincent Fayks Airport
    Airport{IataCode{"OEO"}, CountryId{"US"}, Tz::America_Chicago}, // L.O. Simenstad Municipal Airport
    Airport{IataCode{"OER"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Örnsköldsvik Airport
    Airport{IataCode{"OFI"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Ouango Fitini Airport
    Airport{IataCode{"OFJ"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Ólafsfjörður Airport
    Airport{IataCode{"OFK"}, CountryId{"US"}, Tz::America_Chicago}, // Norfolk Regional Airport
    Airport{IataCode{"OFP"}, CountryId{"US"}, Tz::America_New_York}, // Hanover County Municipal Airport
    Airport{IataCode{"OFU"}, CountryId{"US"}, Tz::Pacific_Pago_Pago}, // Ofu Airport
    Airport{IataCode{"OGB"}, CountryId{"US"}, Tz::America_New_York}, // Orangeburg Municipal Airport
    Airport{IataCode{"OGD"}, CountryId{"US"}, Tz::America_Denver}, // Ogden-Hinckley Airport
    Airport{IataCode{"OGE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Ogeranang
    Airport{IataCode{"OGG"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Kahului Airport
    Airport{IataCode{"OGL"}, CountryId{"GY"}, Tz::America_Guyana}, // Eugene F. Correia International Airport - Ogle
    Airport{IataCode{"OGM"}, CountryId{"PA"}, Tz::America_Panama}, // Ustupu-Ogobsucum Airport
    Airport{IataCode{"OGN"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Yonaguni Airport
    Airport{IataCode{"OGR"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Bongor Airport
    Airport{IataCode{"OGS"}, CountryId{"US"}, Tz::America_New_York}, // Ogdensburg International Airport
    Airport{IataCode{"OGU"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Ordu Giresun Airport
    Airport{IataCode{"OGX"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Ain Beida Airport
    Airport{IataCode{"OGZ"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Beslan Airport
    Airport{IataCode{"OHA"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // RNZAF Base Ohakea
    Airport{IataCode{"OHD"}, CountryId{"MK"}, Tz::Europe_Skopje}, // Ohrid "St. Paul the Apostle" Airport
    Airport{IataCode{"OHE"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Mohe Gulian Airport
    Airport{IataCode{"OHH"}, CountryId{"RU"}, Tz::Asia_Sakhalin}, // Okha Airport
    Airport{IataCode{"OHI"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Oshakati
    Airport{IataCode{"OHS"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Sohar Airport
    Airport{IataCode{"OIC"}, CountryId{"US"}, Tz::America_New_York}, // Lt. Warren Eaton Airport
    Airport{IataCode{"OIM"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Oshima Airport
    Airport{IataCode{"OIR"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Okushiri Airport
    Airport{IataCode{"OIT"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Oita Airport
    Airport{IataCode{"OJA"}, CountryId{"US"}, Tz::America_Chicago}, // Thomas P. Stafford Airport
    Airport{IataCode{"OJC"}, CountryId{"US"}, Tz::America_Chicago}, // Johnson County Executive Airport
    Airport{IataCode{"OJU"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Tanjung Api Airport
    Airport{IataCode{"OKA"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Naha Airport
    Airport{IataCode{"OKC"}, CountryId{"US"}, Tz::America_Chicago}, // Will Rogers World Airport
    Airport{IataCode{"OKD"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Okadama Airport
    Airport{IataCode{"OKE"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Okinoerabu Airport
    Airport{IataCode{"OKF"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Okaukuejo Airport
    Airport{IataCode{"OKG"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Okoyo Airport
    Airport{IataCode{"OKI"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Oki Airport
    Airport{IataCode{"OKJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Okayama Airport
    Airport{IataCode{"OKK"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Kokomo Municipal Airport
    Airport{IataCode{"OKL"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Oksibil Airport
    Airport{IataCode{"OKM"}, CountryId{"US"}, Tz::America_Chicago}, // Okmulgee Regional Airport
    Airport{IataCode{"OKN"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Okondja Airport
    Airport{IataCode{"OKP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Oksapmin
    Airport{IataCode{"OKR"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Yorke Island Airport
    Airport{IataCode{"OKT"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Oktyabrsky Airport
    Airport{IataCode{"OKU"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Mokuti Lodge Airport
    Airport{IataCode{"OKV"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Okao Airport
    Airport{IataCode{"OLA"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Ørland Airport
    Airport{IataCode{"OLB"}, CountryId{"IT"}, Tz::Europe_Rome}, // Olbia Costa Smeralda Airport
    Airport{IataCode{"OLD"}, CountryId{"US"}, Tz::America_New_York}, // Old Town Municipal Airport and Seaplane Base
    Airport{IataCode{"OLE"}, CountryId{"US"}, Tz::America_New_York}, // Cattaraugus County-Olean Airport
    Airport{IataCode{"OLF"}, CountryId{"US"}, Tz::America_Denver}, // L. M. Clayton Airport
    Airport{IataCode{"OLH"}, CountryId{"US"}, Tz::America_Anchorage}, // Old Harbor Airport
    Airport{IataCode{"OLI"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Rif Airport
    Airport{IataCode{"OLJ"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Olpoi Airport
    Airport{IataCode{"OLK"}, CountryId{"PY"}, Tz::America_Asuncion}, // Fuerte Olimpo Airport
    Airport{IataCode{"OLL"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Oyo Ollombo Airport
    Airport{IataCode{"OLM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Olympia Regional Airport
    Airport{IataCode{"OLO"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Olomouc Airport
    Airport{IataCode{"OLP"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Olympic Dam Airport
    Airport{IataCode{"OLS"}, CountryId{"US"}, Tz::America_Phoenix}, // Nogales International Airport
    Airport{IataCode{"OLU"}, CountryId{"US"}, Tz::America_Chicago}, // Columbus Municipal Airport
    Airport{IataCode{"OLV"}, CountryId{"US"}, Tz::America_Chicago}, // Olive Branch Airport
    Airport{IataCode{"OLZ"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Olyokminsk Airport
    Airport{IataCode{"OMA"}, CountryId{"US"}, Tz::America_Chicago}, // Eppley Airfield
    Airport{IataCode{"OMB"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Omboue Hospital Airport
    Airport{IataCode{"OMC"}, CountryId{"PH"}, Tz::Asia_Manila}, // Ormoc Airport
    Airport{IataCode{"OMD"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Oranjemund Airport
    Airport{IataCode{"OME"}, CountryId{"US"}, Tz::America_Nome}, // Nome Airport
    Airport{IataCode{"OMG"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Omega Airport
    Airport{IataCode{"OMH"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Urmia Airport
    Airport{IataCode{"OMK"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Omak Airport
    Airport{IataCode{"OMM"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Marmul, OOMX Airport
    Airport{IataCode{"OMO"}, CountryId{"BA"}, Tz::Europe_Sarajevo}, // Mostar International Airport
    Airport{IataCode{"OMR"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Oradea International Airport
    Airport{IataCode{"OMS"}, CountryId{"RU"}, Tz::Asia_Omsk}, // Omsk Tsentralny Airport
    Airport{IataCode{"OMY"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Thbeng Meanchey Airport
    Airport{IataCode{"ONA"}, CountryId{"US"}, Tz::America_Chicago}, // Winona Municipal Airport
    Airport{IataCode{"OND"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Ondangwa Airport
    Airport{IataCode{"ONG"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Mornington Island Airport
    Airport{IataCode{"ONH"}, CountryId{"US"}, Tz::America_New_York}, // Oneonta Municipal Airport
    Airport{IataCode{"ONJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Odate-Noshiro Airport
    Airport{IataCode{"ONK"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Olenyok Airport
    Airport{IataCode{"ONL"}, CountryId{"US"}, Tz::America_Chicago}, // O'Neill Municipal Airport
    Airport{IataCode{"ONO"}, CountryId{"US"}, Tz::America_Boise}, // Ontario Municipal Airport
    Airport{IataCode{"ONP"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Newport Municipal Airport
    Airport{IataCode{"ONQ"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Zonguldak Airport
    Airport{IataCode{"ONS"}, CountryId{"AU"}, Tz::Australia_Perth}, // Onslow Airport
    Airport{IataCode{"ONT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // LA/Ontario International Airport
    Airport{IataCode{"ONU"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Ono-I-Lau Airport
    Airport{IataCode{"ONX"}, CountryId{"PA"}, Tz::America_Panama}, // Enrique Adolfo Jiménez Airport
    Airport{IataCode{"ONZ"}, CountryId{"US"}, Tz::America_Detroit}, // Grosse Ile Municipal Airport
    Airport{IataCode{"OOD"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Oodnadatta Airport
    Airport{IataCode{"OOK"}, CountryId{"US"}, Tz::America_Nome}, // Toksook Bay Airport
    Airport{IataCode{"OOL"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Gold Coast Airport
    Airport{IataCode{"OOM"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Cooma – Snowy Mountains Airport
    Airport{IataCode{"OOT"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Onotoa Airport
    Airport{IataCode{"OOX"}, CountryId{"UA"}, Tz::Europe_Zaporozhye}, // Q56360344
    Airport{IataCode{"OPA"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Kópasker Airport
    Airport{IataCode{"OPB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Open Bay
    Airport{IataCode{"OPF"}, CountryId{"US"}, Tz::America_New_York}, // Opa-locka Airport
    Airport{IataCode{"OPI"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Oenpelli Airport
    Airport{IataCode{"OPL"}, CountryId{"US"}, Tz::America_Chicago}, // St. Landry Parish Airport
    Airport{IataCode{"OPO"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Francisco de Sá Carneiro Airport
    Airport{IataCode{"OPU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Balimo Airport
    Airport{IataCode{"OPW"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Opuwa Airport
    Airport{IataCode{"OQN"}, CountryId{"US"}, Tz::America_New_York}, // Brandywine Airport
    Airport{IataCode{"OQU"}, CountryId{"US"}, Tz::America_New_York}, // Quonset State Airport
    Airport{IataCode{"ORA"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Orán Airport
    Airport{IataCode{"ORB"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Örebro Airport
    Airport{IataCode{"ORC"}, CountryId{"CO"}, Tz::America_Bogota}, // Orocue Airport
    Airport{IataCode{"ORD"}, CountryId{"US"}, Tz::America_Chicago}, // O'Hare International Airport
    Airport{IataCode{"ORE"}, CountryId{"FR"}, Tz::Europe_Paris}, // Orléans – Saint-Denis-de-l'Hôtel Airport
    Airport{IataCode{"ORF"}, CountryId{"US"}, Tz::America_New_York}, // Norfolk International Airport
    Airport{IataCode{"ORG"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Zorg en Hoop Airport
    Airport{IataCode{"ORH"}, CountryId{"US"}, Tz::America_New_York}, // Worcester Regional Airport
    Airport{IataCode{"ORI"}, CountryId{"US"}, Tz::America_Anchorage}, // Port Lions Airport
    Airport{IataCode{"ORJ"}, CountryId{"GY"}, Tz::America_Guyana}, // Orinduik Airport
    Airport{IataCode{"ORK"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Cork Airport
    Airport{IataCode{"ORN"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Oran Es Sénia Airport
    Airport{IataCode{"ORO"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Yoro Airport
    Airport{IataCode{"ORP"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Orapa Airport
    Airport{IataCode{"ORT"}, CountryId{"US"}, Tz::America_Anchorage}, // Northway Airport
    Airport{IataCode{"ORU"}, CountryId{"BO"}, Tz::America_La_Paz}, // Juan Mendoza Airport
    Airport{IataCode{"ORV"}, CountryId{"US"}, Tz::America_Anchorage}, // Robert (Bob) Curtis Memorial Airport
    Airport{IataCode{"ORW"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Ormara Airport
    Airport{IataCode{"ORX"}, CountryId{"BR"}, Tz::America_Santarem}, // Oriximiná Airport
    Airport{IataCode{"ORY"}, CountryId{"FR"}, Tz::Europe_Paris}, // Orly Airport
    Airport{IataCode{"ORZ"}, CountryId{"BZ"}, Tz::America_Belize}, // Orange Walk Airport
    Airport{IataCode{"OSC"}, CountryId{"US"}, Tz::America_Detroit}, // Oscoda-Wurtsmith Airport
    Airport{IataCode{"OSE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Omora
    Airport{IataCode{"OSF"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Ostafyevo International Airport
    Airport{IataCode{"OSH"}, CountryId{"US"}, Tz::America_Chicago}, // Wittman Regional Airport
    Airport{IataCode{"OSI"}, CountryId{"HR"}, Tz::Europe_Zagreb}, // Osijek Airport
    Airport{IataCode{"OSL"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Oslo Airport, Gardermoen
    Airport{IataCode{"OSM"}, CountryId{"IQ"}, Tz::Asia_Baghdad}, // Mosul International Airport
    Airport{IataCode{"OSO"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Osborne Mine Airport
    Airport{IataCode{"OSP"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Słupsk-Redzikowo Airport
    Airport{IataCode{"OSR"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Leoš Janáček Airport Ostrava
    Airport{IataCode{"OSS"}, CountryId{"KG"}, Tz::Asia_Bishkek}, // Osh Airport
    Airport{IataCode{"OST"}, CountryId{"BE"}, Tz::Europe_Brussels}, // Ostend-Bruges International Airport
    Airport{IataCode{"OSU"}, CountryId{"US"}, Tz::America_New_York}, // Ohio State University Airport
    Airport{IataCode{"OSW"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Orsk Airport
    Airport{IataCode{"OSY"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Namsos Airport
    Airport{IataCode{"OSZ"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Koszalin-Zegrze Pomorskie Airport
    Airport{IataCode{"OTC"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Bol Airport
    Airport{IataCode{"OTD"}, CountryId{"PA"}, Tz::America_Panama}, // Contadora Airport
    Airport{IataCode{"OTH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Southwest Oregon Regional Airport
    Airport{IataCode{"OTI"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Pitu Airport
    Airport{IataCode{"OTJ"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Otjiwarongo Airport
    Airport{IataCode{"OTK"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Tillamook Airport
    Airport{IataCode{"OTL"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Boutilimit Airport
    Airport{IataCode{"OTM"}, CountryId{"US"}, Tz::America_Chicago}, // Ottumwa Regional Airport
    Airport{IataCode{"OTN"}, CountryId{"US"}, Tz::America_Indiana_Vincennes}, // Ed-Air Airport
    Airport{IataCode{"OTP"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Henri Coandă International Airport
    Airport{IataCode{"OTR"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Coto 47 Airport
    Airport{IataCode{"OTS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Anacortes Airport
    Airport{IataCode{"OTU"}, CountryId{"CO"}, Tz::America_Bogota}, // Otú Airport
    Airport{IataCode{"OTY"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Oria
    Airport{IataCode{"OTZ"}, CountryId{"US"}, Tz::America_Nome}, // Ralph Wien Memorial Airport
    Airport{IataCode{"OUA"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Ouagadougou Airport
    Airport{IataCode{"OUD"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Angads Airport
    Airport{IataCode{"OUE"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Ouésso Airport
    Airport{IataCode{"OUG"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Ouahigouya Airport
    Airport{IataCode{"OUL"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Oulu Airport
    Airport{IataCode{"OUM"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Oum Hadjer Airport
    Airport{IataCode{"OUN"}, CountryId{"US"}, Tz::America_Chicago}, // University of Oklahoma Westheimer Airport
    Airport{IataCode{"OUS"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Ourinhos Airport
    Airport{IataCode{"OUT"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Bousso Airport
    Airport{IataCode{"OUZ"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Tazadit Airport
    Airport{IataCode{"OVB"}, CountryId{"RU"}, Tz::Asia_Novosibirsk}, // Tolmachevo Airport
    Airport{IataCode{"OVD"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Asturias Airport
    Airport{IataCode{"OVE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Oroville Municipal Airport
    Airport{IataCode{"OVL"}, CountryId{"CL"}, Tz::America_Santiago}, // El Tuqui Airport
    Airport{IataCode{"OVR"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Olavarría Airport
    Airport{IataCode{"OVS"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Sovetsky Airport
    Airport{IataCode{"OWB"}, CountryId{"US"}, Tz::America_Chicago}, // Owensboro-Daviess County Regional Airport
    Airport{IataCode{"OWD"}, CountryId{"US"}, Tz::America_New_York}, // Norwood Memorial Airport
    Airport{IataCode{"OWI"}, CountryId{"US"}, Tz::America_Chicago}, // Ottawa Municipal Airport
    Airport{IataCode{"OWK"}, CountryId{"US"}, Tz::America_New_York}, // Central Maine Airport of Norridgewock
    Airport{IataCode{"OWP"}, CountryId{"US"}, Tz::America_Chicago}, // William R. Pogue Municipal Airport
    Airport{IataCode{"OXB"}, CountryId{"GW"}, Tz::Africa_Bissau}, // Osvaldo Vieira International Airport
    Airport{IataCode{"OXC"}, CountryId{"US"}, Tz::America_New_York}, // Waterbury-Oxford Airport
    Airport{IataCode{"OXD"}, CountryId{"US"}, Tz::America_New_York}, // Miami University Airport
    Airport{IataCode{"OXF"}, CountryId{"GB"}, Tz::Europe_London}, // London Oxford Airport
    Airport{IataCode{"OYA"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Goya Airport
    Airport{IataCode{"OYE"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Oyem Airport
    Airport{IataCode{"OYG"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Moyo Airport
    Airport{IataCode{"OYL"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Moyale Airport
    Airport{IataCode{"OYO"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Tres Arroyos Airport
    Airport{IataCode{"OYP"}, CountryId{"FR"}, Tz::America_Belem}, // Saint-Georges-de-l'Oyapock Airport
    Airport{IataCode{"OZC"}, CountryId{"PH"}, Tz::Asia_Manila}, // Labo Airport
    Airport{IataCode{"OZG"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Zagora Airport
    Airport{IataCode{"OZH"}, CountryId{"UA"}, Tz::Europe_Zaporozhye}, // Zaporizhzhia International Airport
    Airport{IataCode{"OZS"}, CountryId{"US"}, Tz::America_Chicago}, // Camdenton Memorial Airport
    Airport{IataCode{"OZW"}, CountryId{"US"}, Tz::America_Detroit}, // Livingston County Spencer J. Hardy Airport
    Airport{IataCode{"OZZ"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Ouarzazate Airport
    Airport{IataCode{"PAA"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Hpa-An Airport
    Airport{IataCode{"PAB"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Bilaspur Airport
    Airport{IataCode{"PAC"}, CountryId{"PA"}, Tz::America_Panama}, // Albrook "Marcos A. Gelabert" International Airport
    Airport{IataCode{"PAD"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Paderborn Lippstadt Airport
    Airport{IataCode{"PAE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Paine Field
    Airport{IataCode{"PAF"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Pakuba Airport
    Airport{IataCode{"PAG"}, CountryId{"PH"}, Tz::Asia_Manila}, // Pagadian Airport
    Airport{IataCode{"PAH"}, CountryId{"US"}, Tz::America_Chicago}, // Barkley Regional Airport
    Airport{IataCode{"PAJ"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Parachinar Airport
    Airport{IataCode{"PAK"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Port Allen Airport
    Airport{IataCode{"PAN"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Pattani Airport
    Airport{IataCode{"PAO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Palo Alto Airport of Santa Clara County
    Airport{IataCode{"PAP"}, CountryId{"HT"}, Tz::America_Port_au_Prince}, // Toussaint Louverture International Airport
    Airport{IataCode{"PAQ"}, CountryId{"US"}, Tz::America_Anchorage}, // Palmer Municipal Airport
    Airport{IataCode{"PAT"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Lok Nayak Jayaprakash Airport
    Airport{IataCode{"PAU"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Pauk Airport
    Airport{IataCode{"PAV"}, CountryId{"BR"}, Tz::America_Bahia}, // Paulo Afonso Airport
    Airport{IataCode{"PAW"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Pambwa
    Airport{IataCode{"PAX"}, CountryId{"HT"}, Tz::America_Port_au_Prince}, // Port-de-Paix Airport
    Airport{IataCode{"PAY"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Pamol Airport
    Airport{IataCode{"PAZ"}, CountryId{"MX"}, Tz::America_Mexico_City}, // El Tajín National Airport
    Airport{IataCode{"PBC"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Hermanos Serdán International Airport
    Airport{IataCode{"PBD"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Porbandar Airport
    Airport{IataCode{"PBE"}, CountryId{"CO"}, Tz::America_Bogota}, // Puerto Berrio Airport
    Airport{IataCode{"PBF"}, CountryId{"US"}, Tz::America_Chicago}, // Grider Field
    Airport{IataCode{"PBG"}, CountryId{"US"}, Tz::America_New_York}, // Plattsburgh International Airport
    Airport{IataCode{"PBH"}, CountryId{"BT"}, Tz::Asia_Thimphu}, // Paro Airport
    Airport{IataCode{"PBI"}, CountryId{"US"}, Tz::America_New_York}, // Palm Beach International Airport
    Airport{IataCode{"PBJ"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Paama Airport
    Airport{IataCode{"PBL"}, CountryId{"VE"}, Tz::America_Caracas}, // General Bartolomé Salom Airport
    Airport{IataCode{"PBM"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Johan Adolf Pengel International Airport
    Airport{IataCode{"PBN"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Porto Amboim Airport
    Airport{IataCode{"PBO"}, CountryId{"AU"}, Tz::Australia_Perth}, // Paraburdoo Airport
    Airport{IataCode{"PBP"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Punta Islita Airport
    Airport{IataCode{"PBQ"}, CountryId{"BR"}, Tz::America_Porto_Velho}, // Pimenta Bueno Airport
    Airport{IataCode{"PBR"}, CountryId{"GT"}, Tz::America_Guatemala}, // Puerto Barrios Airport
    Airport{IataCode{"PBU"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Putao Airport
    Airport{IataCode{"PCA"}, CountryId{"US"}, Tz::America_Anchorage}, // Portage Creek Airport
    Airport{IataCode{"PCB"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Pondok Cabe Airport
    Airport{IataCode{"PCC"}, CountryId{"CO"}, Tz::America_Bogota}, // Puerto Rico Airport
    Airport{IataCode{"PCD"}, CountryId{"US"}, Tz::America_Chicago}, // Prairie du Chien Municipal Airport
    Airport{IataCode{"PCE"}, CountryId{"CO"}, Tz::America_Bogota}, // Cumaribo Airport
    Airport{IataCode{"PCH"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Palacios Airport
    Airport{IataCode{"PCL"}, CountryId{"PE"}, Tz::America_Lima}, // FAP Captain David Abensur Rengifo International Airport
    Airport{IataCode{"PCN"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Picton Aerodrome
    Airport{IataCode{"PCO"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Punta Colorada Airstrip
    Airport{IataCode{"PCP"}, CountryId{"ST"}, Tz::Africa_Sao_Tome}, // Príncipe Airport
    Airport{IataCode{"PCR"}, CountryId{"CO"}, Tz::America_Bogota}, // Germán Olano Airport
    Airport{IataCode{"PCS"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Picos Airport
    Airport{IataCode{"PCT"}, CountryId{"US"}, Tz::America_New_York}, // Princeton Airport
    Airport{IataCode{"PCW"}, CountryId{"US"}, Tz::America_New_York}, // Erie-Ottawa International Airport
    Airport{IataCode{"PCZ"}, CountryId{"US"}, Tz::America_Chicago}, // Waupaca Municipal Airport
    Airport{IataCode{"PDA"}, CountryId{"CO"}, Tz::America_Bogota}, // César Gaviria Trujillo Airport
    Airport{IataCode{"PDB"}, CountryId{"US"}, Tz::America_Anchorage}, // Pedro Bay Airport
    Airport{IataCode{"PDC"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Mueo Airport
    Airport{IataCode{"PDD"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Ponta do Ouro Airport
    Airport{IataCode{"PDG"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Minangkabau International Airport
    Airport{IataCode{"PDK"}, CountryId{"US"}, Tz::America_New_York}, // DeKalb-Peachtree Airport
    Airport{IataCode{"PDL"}, CountryId{"PT"}, Tz::Atlantic_Azores}, // João Paulo II Airport
    Airport{IataCode{"PDO"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Pendopo Airport
    Airport{IataCode{"PDP"}, CountryId{"UY"}, Tz::America_Montevideo}, // Capitán de Corbeta Carlos A. Curbelo International Airport
    Airport{IataCode{"PDR"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Presidente Dutra
    Airport{IataCode{"PDS"}, CountryId{"MX"}, Tz::America_Matamoros}, // Piedras Negras International Airport
    Airport{IataCode{"PDU"}, CountryId{"UY"}, Tz::America_Montevideo}, // Paysandú Airport
    Airport{IataCode{"PDX"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Portland International Airport
    Airport{IataCode{"PDZ"}, CountryId{"VE"}, Tz::America_Caracas}, // Pedernales Airport
    Airport{IataCode{"PED"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Pardubice Airport
    Airport{IataCode{"PEE"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Bolshoye Savino Airport
    Airport{IataCode{"PEG"}, CountryId{"IT"}, Tz::Europe_Rome}, // Perugia San Francesco d'Assisi – Umbria International Airport
    Airport{IataCode{"PEH"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Comodoro P. Zanni Airport
    Airport{IataCode{"PEI"}, CountryId{"CO"}, Tz::America_Bogota}, // Matecaña International Airport
    Airport{IataCode{"PEK"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Beijing Capital International Airport
    Airport{IataCode{"PEL"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Pelaneng Airport
    Airport{IataCode{"PEM"}, CountryId{"PE"}, Tz::America_Lima}, // Padre Aldamiz International Airport
    Airport{IataCode{"PEN"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Penang International Airport
    Airport{IataCode{"PEO"}, CountryId{"US"}, Tz::America_New_York}, // Penn Yan Airport
    Airport{IataCode{"PEQ"}, CountryId{"US"}, Tz::America_Chicago}, // Pecos Municipal Airport
    Airport{IataCode{"PER"}, CountryId{"AU"}, Tz::Australia_Perth}, // Perth Airport
    Airport{IataCode{"PES"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Petrozavodsk Airport
    Airport{IataCode{"PET"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Pelotas International Airport
    Airport{IataCode{"PEU"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Puerto Lempira Airport
    Airport{IataCode{"PEV"}, CountryId{"HU"}, Tz::Europe_Budapest}, // Pécs-Pogány International Airport
    Airport{IataCode{"PEW"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Bacha Khan International Airport
    Airport{IataCode{"PEX"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Pechora Airport
    Airport{IataCode{"PEZ"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Penza Airport
    Airport{IataCode{"PFB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Lauro Kurtz Airport
    Airport{IataCode{"PFC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Pacific City State Airport
    Airport{IataCode{"PFJ"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Patreksfjörður Airport
    Airport{IataCode{"PFO"}, CountryId{"CY"}, Tz::Asia_Nicosia}, // Paphos International Airport
    Airport{IataCode{"PFQ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Parsabad-Moghan Airport
    Airport{IataCode{"PFR"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Ilebo Airport
    Airport{IataCode{"PGA"}, CountryId{"US"}, Tz::America_Phoenix}, // Page Municipal Airport
    Airport{IataCode{"PGB"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Progar Airport
    Airport{IataCode{"PGC"}, CountryId{"US"}, Tz::America_New_York}, // Grant County Airport
    Airport{IataCode{"PGD"}, CountryId{"US"}, Tz::America_New_York}, // Punta Gorda Airport
    Airport{IataCode{"PGE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Yegepa
    Airport{IataCode{"PGF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Perpignan–Rivesaltes Airport
    Airport{IataCode{"PGH"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Pantnagar Airport
    Airport{IataCode{"PGI"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Chitato Airport
    Airport{IataCode{"PGK"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Depati Amir Airport
    Airport{IataCode{"PGL"}, CountryId{"US"}, Tz::America_Chicago}, // Trent Lott International Airport
    Airport{IataCode{"PGM"}, CountryId{"US"}, Tz::America_Anchorage}, // Port Graham Airport
    Airport{IataCode{"PGN"}, CountryId{"HT"}, Tz::America_Port_au_Prince}, // Pignon Airport
    Airport{IataCode{"PGO"}, CountryId{"US"}, Tz::America_Denver}, // Stevens Field
    Airport{IataCode{"PGQ"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Buli Airport
    Airport{IataCode{"PGR"}, CountryId{"US"}, Tz::America_Chicago}, // Kirk Field
    Airport{IataCode{"PGS"}, CountryId{"US"}, Tz::America_Phoenix}, // Grand Canyon Caverns Airport
    Airport{IataCode{"PGU"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Persian Gulf Airport
    Airport{IataCode{"PGX"}, CountryId{"FR"}, Tz::Europe_Paris}, // Périgueux Bassillac Airport
    Airport{IataCode{"PHB"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Parnaíba-Prefeito Dr. João Silva Filho International Airport
    Airport{IataCode{"PHC"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Port Harcourt International Airport
    Airport{IataCode{"PHD"}, CountryId{"US"}, Tz::America_New_York}, // Harry Clever Field
    Airport{IataCode{"PHE"}, CountryId{"AU"}, Tz::Australia_Perth}, // Port Hedland International Airport
    Airport{IataCode{"PHF"}, CountryId{"US"}, Tz::America_New_York}, // Newport News/Williamsburg International Airport
    Airport{IataCode{"PHI"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Pinheiro Airport
    Airport{IataCode{"PHK"}, CountryId{"US"}, Tz::America_New_York}, // Palm Beach County Glades Airport
    Airport{IataCode{"PHL"}, CountryId{"US"}, Tz::America_New_York}, // Philadelphia International Airport
    Airport{IataCode{"PHN"}, CountryId{"US"}, Tz::America_Detroit}, // St. Clair County International Airport
    Airport{IataCode{"PHO"}, CountryId{"US"}, Tz::America_Nome}, // Point Hope Airport
    Airport{IataCode{"PHQ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // The Monument Airport
    Airport{IataCode{"PHR"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Pacific Harbour Airport
    Airport{IataCode{"PHS"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Phitsanulok Airport
    Airport{IataCode{"PHT"}, CountryId{"US"}, Tz::America_Chicago}, // Henry County Airport
    Airport{IataCode{"PHW"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Hendrik Van Eck Airport
    Airport{IataCode{"PHX"}, CountryId{"US"}, Tz::America_Phoenix}, // Phoenix Sky Harbor International Airport
    Airport{IataCode{"PHY"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Phetchabun Airport
    Airport{IataCode{"PIA"}, CountryId{"US"}, Tz::America_Chicago}, // Peoria International Airport
    Airport{IataCode{"PIB"}, CountryId{"US"}, Tz::America_Chicago}, // Hattiesburg-Laurel Regional Airport
    Airport{IataCode{"PIC"}, CountryId{"GB"}, Tz::America_Grand_Turk}, // Pine Cay Airport
    Airport{IataCode{"PID"}, CountryId{"BS"}, Tz::America_Nassau}, // New Providence Airport
    Airport{IataCode{"PIE"}, CountryId{"US"}, Tz::America_New_York}, // St. Petersburg–Clearwater International Airport
    Airport{IataCode{"PIF"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Pingtung Airport
    Airport{IataCode{"PIG"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Pigue Airport
    Airport{IataCode{"PIH"}, CountryId{"US"}, Tz::America_Boise}, // Pocatello Regional Airport
    Airport{IataCode{"PIK"}, CountryId{"GB"}, Tz::Europe_London}, // Glasgow Prestwick Airport
    Airport{IataCode{"PIL"}, CountryId{"PY"}, Tz::America_Asuncion}, // Carlos Miguel Jiménez Airport
    Airport{IataCode{"PIM"}, CountryId{"US"}, Tz::America_New_York}, // Harris County Airport
    Airport{IataCode{"PIN"}, CountryId{"BR"}, Tz::America_Manaus}, // Parintins Airport
    Airport{IataCode{"PIO"}, CountryId{"PE"}, Tz::America_Lima}, // Capitán FAP Renán Elías Olivera Airport
    Airport{IataCode{"PIP"}, CountryId{"US"}, Tz::America_Anchorage}, // Pilot Point Airport
    Airport{IataCode{"PIR"}, CountryId{"US"}, Tz::America_Chicago}, // Pierre Regional Airport
    Airport{IataCode{"PIS"}, CountryId{"FR"}, Tz::Europe_Paris}, // Poitiers – Biard Airport
    Airport{IataCode{"PIT"}, CountryId{"US"}, Tz::America_New_York}, // Pittsburgh International Airport
    Airport{IataCode{"PIU"}, CountryId{"PE"}, Tz::America_Lima}, // Cap. FAP Guillermo Concha Iberico International Airport
    Airport{IataCode{"PIW"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Pikwitonei Airport
    Airport{IataCode{"PIX"}, CountryId{"PT"}, Tz::Atlantic_Azores}, // Pico Airport
    Airport{IataCode{"PIZ"}, CountryId{"US"}, Tz::America_Nome}, // Point Lay LRRS Airport
    Airport{IataCode{"PJA"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Pajala Airport
    Airport{IataCode{"PJB"}, CountryId{"US"}, Tz::America_Phoenix}, // Payson Airport
    Airport{IataCode{"PJC"}, CountryId{"PY"}, Tz::America_Asuncion}, // Dr. Augusto Roberto Fuster International Airport
    Airport{IataCode{"PJG"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Panjgur Airport
    Airport{IataCode{"PJM"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Puerto Jiménez Airport
    Airport{IataCode{"PKA"}, CountryId{"US"}, Tz::America_Anchorage}, // Napaskiak Airport
    Airport{IataCode{"PKB"}, CountryId{"US"}, Tz::America_New_York}, // Mid-Ohio Valley Regional Airport
    Airport{IataCode{"PKC"}, CountryId{"RU"}, Tz::Asia_Kamchatka}, // Petropavlovsk-Kamchatsky Airport
    Airport{IataCode{"PKE"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Parkes Regional Airport
    Airport{IataCode{"PKF"}, CountryId{"US"}, Tz::America_Chicago}, // Park Falls Municipal Airport
    Airport{IataCode{"PKG"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Pangkor Airport
    Airport{IataCode{"PKH"}, CountryId{"GR"}, Tz::Europe_Athens}, // Porto Cheli Airport
    Airport{IataCode{"PKJ"}, CountryId{"GT"}, Tz::America_Guatemala}, // Playa Grande Airport
    Airport{IataCode{"PKK"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Pakokku Airport
    Airport{IataCode{"PKN"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Iskandar Airport
    Airport{IataCode{"PKO"}, CountryId{"BJ"}, Tz::Africa_Porto_Novo}, // Parakou Airport
    Airport{IataCode{"PKP"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Puka-Puka Airport
    Airport{IataCode{"PKR"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Pokhara Airport
    Airport{IataCode{"PKT"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Port Keats Airfield
    Airport{IataCode{"PKU"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Sultan Syarif Kasim II Airport
    Airport{IataCode{"PKV"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Pskov Airport
    Airport{IataCode{"PKW"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Selebi-Phikwe Airport
    Airport{IataCode{"PKX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Beijing Daxing International Airport
    Airport{IataCode{"PKY"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Tjilik Riwut Airport
    Airport{IataCode{"PKZ"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Pakse International Airport
    Airport{IataCode{"PLD"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Carrillo Airport
    Airport{IataCode{"PLE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Paiela Airport
    Airport{IataCode{"PLF"}, CountryId{"TD"}, Tz::Africa_Ndjamena}, // Pala Airport
    Airport{IataCode{"PLJ"}, CountryId{"BZ"}, Tz::America_Belize}, // Placencia Airport
    Airport{IataCode{"PLK"}, CountryId{"US"}, Tz::America_Chicago}, // M. Graham Clark Field, Taney County Airport
    Airport{IataCode{"PLM"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Sultan Mahmud Badaruddin II International Airport
    Airport{IataCode{"PLN"}, CountryId{"US"}, Tz::America_Detroit}, // Pellston Regional Airport
    Airport{IataCode{"PLO"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Port Lincoln Airport
    Airport{IataCode{"PLP"}, CountryId{"PA"}, Tz::America_Panama}, // Captain Ramon Xatruch Airport
    Airport{IataCode{"PLQ"}, CountryId{"LT"}, Tz::Europe_Vilnius}, // Palanga International Airport
    Airport{IataCode{"PLR"}, CountryId{"US"}, Tz::America_Chicago}, // St. Clair County Airport
    Airport{IataCode{"PLS"}, CountryId{"TC"}, Tz::America_Grand_Turk}, // Providenciales International Airport
    Airport{IataCode{"PLT"}, CountryId{"CO"}, Tz::America_Bogota}, // Plato Airport
    Airport{IataCode{"PLU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Belo Horizonte/Pampulha – Carlos Drummond de Andrade Airport
    Airport{IataCode{"PLV"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Poltava Airport
    Airport{IataCode{"PLW"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Mutiara Airport
    Airport{IataCode{"PLX"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Semey Airport
    Airport{IataCode{"PLY"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Plymouth Municipal Airport (Indiana)
    Airport{IataCode{"PLZ"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Port Elizabeth Airport
    Airport{IataCode{"PMA"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Pemba Airport
    Airport{IataCode{"PMB"}, CountryId{"US"}, Tz::America_Chicago}, // Pembina Municipal Airport
    Airport{IataCode{"PMC"}, CountryId{"CL"}, Tz::America_Santiago}, // El Tepual Airport
    Airport{IataCode{"PMD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // LA/Palmdale Regional Airport
    Airport{IataCode{"PMF"}, CountryId{"IT"}, Tz::Europe_Rome}, // Parma Airport
    Airport{IataCode{"PMG"}, CountryId{"BR"}, Tz::America_Campo_Grande}, // Ponta Porã International Airport
    Airport{IataCode{"PMH"}, CountryId{"US"}, Tz::America_New_York}, // Greater Portsmouth Regional Airport
    Airport{IataCode{"PMI"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Palma de Mallorca Airport
    Airport{IataCode{"PMK"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Palm Island Airport
    Airport{IataCode{"PML"}, CountryId{"US"}, Tz::America_Anchorage}, // Port Moller Airport
    Airport{IataCode{"PMN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Pumani
    Airport{IataCode{"PMO"}, CountryId{"IT"}, Tz::Europe_Rome}, // Falcone–Borsellino Airport
    Airport{IataCode{"PMP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Pimaga Airport
    Airport{IataCode{"PMQ"}, CountryId{"AR"}, Tz::America_Argentina_Rio_Gallegos}, // Perito Moreno Airport
    Airport{IataCode{"PMR"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Palmerston North International Airport
    Airport{IataCode{"PMS"}, CountryId{"SY"}, Tz::Asia_Damascus}, // Palmyra Airport
    Airport{IataCode{"PMV"}, CountryId{"VE"}, Tz::America_Caracas}, // Santiago Mariño Caribbean International Airport
    Airport{IataCode{"PMW"}, CountryId{"BR"}, Tz::America_Araguaina}, // Palmas Airport (Tocantins)
    Airport{IataCode{"PMY"}, CountryId{"AR"}, Tz::America_Argentina_Catamarca}, // El Tehuelche Airport
    Airport{IataCode{"PMZ"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Palmar Sur Airport
    Airport{IataCode{"PNA"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Pamplona Airport
    Airport{IataCode{"PNB"}, CountryId{"BR"}, Tz::America_Araguaina}, // Porto Nacional Airport
    Airport{IataCode{"PNC"}, CountryId{"US"}, Tz::America_Chicago}, // Ponca City Regional Airport
    Airport{IataCode{"PND"}, CountryId{"BZ"}, Tz::America_Belize}, // Punta Gorda Airport
    Airport{IataCode{"PNE"}, CountryId{"US"}, Tz::America_New_York}, // Northeast Philadelphia Airport
    Airport{IataCode{"PNH"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Phnom Penh International Airport
    Airport{IataCode{"PNI"}, CountryId{"FM"}, Tz::Pacific_Pohnpei}, // Pohnpei International Airport
    Airport{IataCode{"PNK"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Supadio Airport
    Airport{IataCode{"PNL"}, CountryId{"IT"}, Tz::Europe_Rome}, // Pantelleria Airport
    Airport{IataCode{"PNM"}, CountryId{"US"}, Tz::America_Chicago}, // Princeton Municipal Airport
    Airport{IataCode{"PNN"}, CountryId{"US"}, Tz::America_New_York}, // Princeton Municipal Airport (Maine)
    Airport{IataCode{"PNP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Girua Airport
    Airport{IataCode{"PNQ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Pune Airport
    Airport{IataCode{"PNR"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Pointe Noire Airport
    Airport{IataCode{"PNS"}, CountryId{"US"}, Tz::America_Chicago}, // Pensacola International Airport
    Airport{IataCode{"PNT"}, CountryId{"CL"}, Tz::America_Punta_Arenas}, // Teniente Julio Gallardo Airport
    Airport{IataCode{"PNU"}, CountryId{"US"}, Tz::America_Denver}, // Panguitch Municipal Airport
    Airport{IataCode{"PNX"}, CountryId{"US"}, Tz::America_Chicago}, // North Texas Regional Airport
    Airport{IataCode{"PNY"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Pondicherry Airport
    Airport{IataCode{"PNZ"}, CountryId{"BR"}, Tz::America_Recife}, // Petrolina Airport
    Airport{IataCode{"POA"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Salgado Filho International Airport
    Airport{IataCode{"POC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Brackett Field
    Airport{IataCode{"POG"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Port-Gentil International Airport
    Airport{IataCode{"POI"}, CountryId{"BO"}, Tz::America_La_Paz}, // Captain Nicolas Rojas Airport
    Airport{IataCode{"POJ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Patos de Minas Airport
    Airport{IataCode{"POL"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Pemba Airport
    Airport{IataCode{"POM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Jacksons International Airport
    Airport{IataCode{"PON"}, CountryId{"GT"}, Tz::America_Guatemala}, // Poptún Airport
    Airport{IataCode{"POP"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // Gregorio Luperón International Airport
    Airport{IataCode{"POR"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Pori Airport
    Airport{IataCode{"POS"}, CountryId{"TT"}, Tz::America_Port_of_Spain}, // Piarco International Airport
    Airport{IataCode{"POT"}, CountryId{"JM"}, Tz::America_Jamaica}, // Ken Jones Aerodrome
    Airport{IataCode{"POU"}, CountryId{"US"}, Tz::America_New_York}, // Hudson Valley Regional Airport
    Airport{IataCode{"POV"}, CountryId{"US"}, Tz::America_New_York}, // Portage County Regional Airport
    Airport{IataCode{"POW"}, CountryId{"SI"}, Tz::Europe_Ljubljana}, // Portorož Airport
    Airport{IataCode{"POX"}, CountryId{"FR"}, Tz::Europe_Paris}, // Pontoise – Cormeilles Aerodrome
    Airport{IataCode{"POZ"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Poznań-Ławica Airport
    Airport{IataCode{"PPB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Presidente Prudente Airport
    Airport{IataCode{"PPC"}, CountryId{"US"}, Tz::America_Anchorage}, // Prospect Creek Airport
    Airport{IataCode{"PPE"}, CountryId{"MX"}, Tz::America_Hermosillo}, // Mar de Cortés International Airport
    Airport{IataCode{"PPF"}, CountryId{"US"}, Tz::America_Chicago}, // Tri-City Airport (Kansas)
    Airport{IataCode{"PPG"}, CountryId{"US"}, Tz::Pacific_Pago_Pago}, // Pago Pago International Airport
    Airport{IataCode{"PPH"}, CountryId{"VE"}, Tz::America_Caracas}, // Parai-tepuí Airport
    Airport{IataCode{"PPI"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Port Pirie Airport
    Airport{IataCode{"PPK"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Petropavl Airport
    Airport{IataCode{"PPL"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Phaplu Airport
    Airport{IataCode{"PPM"}, CountryId{"US"}, Tz::America_New_York}, // Pompano Beach Airpark
    Airport{IataCode{"PPN"}, CountryId{"CO"}, Tz::America_Bogota}, // Guillermo León Valencia Airport
    Airport{IataCode{"PPP"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Whitsunday Coast Airport
    Airport{IataCode{"PPQ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Kapiti Coast Airport
    Airport{IataCode{"PPR"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Tuanku Tambusai Airport
    Airport{IataCode{"PPS"}, CountryId{"PH"}, Tz::Asia_Manila}, // Puerto Princesa International Airport
    Airport{IataCode{"PPT"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Faa'a International Airport
    Airport{IataCode{"PPV"}, CountryId{"US"}, Tz::America_Sitka}, // Port Protection Seaplane Base
    Airport{IataCode{"PPX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Param
    Airport{IataCode{"PPY"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Pouso Alegre Airport
    Airport{IataCode{"PPZ"}, CountryId{"VE"}, Tz::America_Caracas}, // Puerto Páez Airport
    Airport{IataCode{"PQC"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Phu Quoc International Airport
    Airport{IataCode{"PQM"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Palenque International Airport
    Airport{IataCode{"PQQ"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Port Macquarie Airport
    Airport{IataCode{"PQS"}, CountryId{"US"}, Tz::America_Nome}, // Pilot Station Airport
    Airport{IataCode{"PRA"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // General Justo José de Urquiza Airport
    Airport{IataCode{"PRB"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Paso Robles Municipal Airport
    Airport{IataCode{"PRC"}, CountryId{"US"}, Tz::America_Phoenix}, // Ernest A. Love Field
    Airport{IataCode{"PRG"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Prague Václav Havel Airport
    Airport{IataCode{"PRH"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Phrae Airport
    Airport{IataCode{"PRI"}, CountryId{"SC"}, Tz::Indian_Mahe}, // Praslin Island Airport
    Airport{IataCode{"PRM"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Portimão Airport
    Airport{IataCode{"PRN"}, CountryId{"XK"}, Tz::Europe_Belgrade}, // Pristina International Airport Adem Jashari
    Airport{IataCode{"PRO"}, CountryId{"US"}, Tz::America_Chicago}, // Perry Municipal Airport
    Airport{IataCode{"PRQ"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Primer Teniente Jorge Eduardo Casco Airport
    Airport{IataCode{"PRR"}, CountryId{"GY"}, Tz::America_Guyana}, // Paruima Airport
    Airport{IataCode{"PRS"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Marau Sound Airport
    Airport{IataCode{"PRV"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Přerov Airport
    Airport{IataCode{"PRW"}, CountryId{"US"}, Tz::America_Chicago}, // Prentice Airport
    Airport{IataCode{"PRX"}, CountryId{"US"}, Tz::America_Chicago}, // Cox Field
    Airport{IataCode{"PRY"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Wonderboom Airport
    Airport{IataCode{"PRZ"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Prineville Airport
    Airport{IataCode{"PSA"}, CountryId{"IT"}, Tz::Europe_Rome}, // Pisa International Airport
    Airport{IataCode{"PSB"}, CountryId{"US"}, Tz::America_New_York}, // Mid-State Regional Airport
    Airport{IataCode{"PSC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Tri-Cities Airport
    Airport{IataCode{"PSD"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Port Said Airport
    Airport{IataCode{"PSE"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // Mercedita Airport
    Airport{IataCode{"PSF"}, CountryId{"US"}, Tz::America_New_York}, // Pittsfield Municipal Airport
    Airport{IataCode{"PSG"}, CountryId{"US"}, Tz::America_Sitka}, // Petersburg James A. Johnson Airport
    Airport{IataCode{"PSI"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Pasni Airport
    Airport{IataCode{"PSJ"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Kasiguncu Airport
    Airport{IataCode{"PSK"}, CountryId{"US"}, Tz::America_New_York}, // New River Valley Airport
    Airport{IataCode{"PSM"}, CountryId{"US"}, Tz::America_New_York}, // Portsmouth International Airport at Pease
    Airport{IataCode{"PSO"}, CountryId{"CO"}, Tz::America_Bogota}, // Antonio Nariño Airport
    Airport{IataCode{"PSP"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Palm Springs International Airport
    Airport{IataCode{"PSQ"}, CountryId{"US"}, Tz::America_New_York}, // Philadelphia Seaplane Base
    Airport{IataCode{"PSR"}, CountryId{"IT"}, Tz::Europe_Rome}, // Abruzzo Airport
    Airport{IataCode{"PSS"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Libertador General José de San Martín Airport
    Airport{IataCode{"PST"}, CountryId{"CU"}, Tz::America_Havana}, // Preston Airport
    Airport{IataCode{"PSU"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Pangsuma Airport
    Airport{IataCode{"PSX"}, CountryId{"US"}, Tz::America_Chicago}, // Palacios Municipal Airport
    Airport{IataCode{"PSY"}, CountryId{"GB"}, Tz::Atlantic_Stanley}, // Port Stanley Airport
    Airport{IataCode{"PSZ"}, CountryId{"BO"}, Tz::America_La_Paz}, // Puerto Suárez International Airport
    Airport{IataCode{"PTA"}, CountryId{"US"}, Tz::America_Anchorage}, // Port Alsworth Airport
    Airport{IataCode{"PTD"}, CountryId{"US"}, Tz::America_Sitka}, // Port Alexander Seaplane Base
    Airport{IataCode{"PTF"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Malolo Lailai Airport
    Airport{IataCode{"PTG"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Polokwane International Airport
    Airport{IataCode{"PTH"}, CountryId{"US"}, Tz::America_Anchorage}, // Port Heiden Airport
    Airport{IataCode{"PTJ"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Portland Airport, Australia
    Airport{IataCode{"PTK"}, CountryId{"US"}, Tz::America_Detroit}, // Oakland County International Airport
    Airport{IataCode{"PTM"}, CountryId{"VE"}, Tz::America_Caracas}, // Palmarito Airport
    Airport{IataCode{"PTN"}, CountryId{"US"}, Tz::America_Chicago}, // Harry P. Williams Memorial Airport
    Airport{IataCode{"PTO"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Pato Branco Airport
    Airport{IataCode{"PTP"}, CountryId{"FR"}, Tz::America_Guadeloupe}, // Pointe-à-Pitre International Airport
    Airport{IataCode{"PTQ"}, CountryId{"BR"}, Tz::America_Belem}, // Porto de Moz Airport
    Airport{IataCode{"PTS"}, CountryId{"US"}, Tz::America_Chicago}, // Atkinson Municipal Airport
    Airport{IataCode{"PTT"}, CountryId{"US"}, Tz::America_Chicago}, // Pratt Regional Airport
    Airport{IataCode{"PTU"}, CountryId{"US"}, Tz::America_Anchorage}, // Platinum Airport
    Airport{IataCode{"PTV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Porterville Municipal Airport
    Airport{IataCode{"PTW"}, CountryId{"US"}, Tz::America_New_York}, // Heritage Field Airport
    Airport{IataCode{"PTX"}, CountryId{"CO"}, Tz::America_Bogota}, // Contador Airport
    Airport{IataCode{"PTY"}, CountryId{"PA"}, Tz::America_Panama}, // Tocumen International Airport
    Airport{IataCode{"PUB"}, CountryId{"US"}, Tz::America_Denver}, // Pueblo Memorial Airport
    Airport{IataCode{"PUD"}, CountryId{"AR"}, Tz::America_Argentina_Rio_Gallegos}, // Puerto Deseado Airport
    Airport{IataCode{"PUE"}, CountryId{"PA"}, Tz::America_Panama}, // Puerto Obaldia Airport
    Airport{IataCode{"PUF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Pau Pyrénées Airport
    Airport{IataCode{"PUG"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Port Augusta Airport
    Airport{IataCode{"PUJ"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // Punta Cana International Airport
    Airport{IataCode{"PUK"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Pukarua Airport
    Airport{IataCode{"PUM"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Sangia Nibandera Airport
    Airport{IataCode{"PUN"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Punia Airport
    Airport{IataCode{"PUP"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Pô Airport
    Airport{IataCode{"PUQ"}, CountryId{"CL"}, Tz::America_Punta_Arenas}, // Presidente Carlos Ibáñez del Campo International Airport
    Airport{IataCode{"PUR"}, CountryId{"BO"}, Tz::America_La_Paz}, // Puerto Rico Airport
    Airport{IataCode{"PUS"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Gimhae International Airport
    Airport{IataCode{"PUT"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Sri Sathya Sai Airport
    Airport{IataCode{"PUU"}, CountryId{"CO"}, Tz::America_Bogota}, // Tres de Mayo Airport
    Airport{IataCode{"PUW"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Pullman-Moscow Regional Airport
    Airport{IataCode{"PUX"}, CountryId{"CL"}, Tz::America_Santiago}, // El Mirador Airport
    Airport{IataCode{"PUY"}, CountryId{"HR"}, Tz::Europe_Zagreb}, // Pula Airport
    Airport{IataCode{"PUZ"}, CountryId{"NI"}, Tz::America_Managua}, // Puerto Cabezas Airport
    Airport{IataCode{"PVA"}, CountryId{"CO"}, Tz::America_Bogota}, // El Embrujo Airport
    Airport{IataCode{"PVB"}, CountryId{"US"}, Tz::America_Chicago}, // Platteville Municipal Airport
    Airport{IataCode{"PVC"}, CountryId{"US"}, Tz::America_New_York}, // Provincetown Municipal Airport
    Airport{IataCode{"PVD"}, CountryId{"US"}, Tz::America_New_York}, // T. F. Green Airport
    Airport{IataCode{"PVE"}, CountryId{"PA"}, Tz::America_Panama}, // El Porvenir Airport
    Airport{IataCode{"PVF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Placerville Airport
    Airport{IataCode{"PVG"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shanghai Pudong International Airport
    Airport{IataCode{"PVH"}, CountryId{"BR"}, Tz::America_Porto_Velho}, // Governador Jorge Teixeira de Oliveira International Airport
    Airport{IataCode{"PVI"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Paranavaí Airport
    Airport{IataCode{"PVK"}, CountryId{"GR"}, Tz::Europe_Athens}, // Aktion National Airport
    Airport{IataCode{"PVL"}, CountryId{"US"}, Tz::America_New_York}, // Pike County Airport
    Airport{IataCode{"PVO"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Reales Tamarindos Airport
    Airport{IataCode{"PVR"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Licenciado Gustavo Díaz Ordaz International Airport
    Airport{IataCode{"PVS"}, CountryId{"RU"}, Tz::Asia_Anadyr}, // Provideniya Bay Airport
    Airport{IataCode{"PVU"}, CountryId{"US"}, Tz::America_Denver}, // Provo Municipal Airport
    Airport{IataCode{"PVW"}, CountryId{"US"}, Tz::America_Chicago}, // Hale County Airport
    Airport{IataCode{"PWA"}, CountryId{"US"}, Tz::America_Chicago}, // Wiley Post Airport
    Airport{IataCode{"PWD"}, CountryId{"US"}, Tz::America_Denver}, // Sher-Wood Airport
    Airport{IataCode{"PWE"}, CountryId{"RU"}, Tz::Asia_Anadyr}, // Pevek Airport
    Airport{IataCode{"PWK"}, CountryId{"US"}, Tz::America_Chicago}, // Chicago Executive Airport
    Airport{IataCode{"PWL"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Purwokerto Airport
    Airport{IataCode{"PWM"}, CountryId{"US"}, Tz::America_New_York}, // Portland International Jetport
    Airport{IataCode{"PWN"}, CountryId{"BS"}, Tz::America_Nassau}, // Pitts Town Airport
    Airport{IataCode{"PWO"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Pweto Airport
    Airport{IataCode{"PWQ"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Pavlodar Airport
    Airport{IataCode{"PWT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Bremerton National Airport
    Airport{IataCode{"PWY"}, CountryId{"US"}, Tz::America_Denver}, // Ralph Wenz Field
    Airport{IataCode{"PXA"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Atung Bungsu Airport
    Airport{IataCode{"PXE"}, CountryId{"US"}, Tz::America_New_York}, // Perry-Houston County Airport
    Airport{IataCode{"PXH"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Prominent Hill Airport
    Airport{IataCode{"PXL"}, CountryId{"US"}, Tz::America_Phoenix}, // Polacca Airport
    Airport{IataCode{"PXM"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Puerto Escondido International Airport
    Airport{IataCode{"PXO"}, CountryId{"PT"}, Tz::Atlantic_Madeira}, // Porto Santo Airport
    Airport{IataCode{"PXR"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Surin Pakdi Airport
    Airport{IataCode{"PXU"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Pleiku Airport
    Airport{IataCode{"PYA"}, CountryId{"CO"}, Tz::America_Bogota}, // Velasquez Airport
    Airport{IataCode{"PYB"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Jeypore Airport
    Airport{IataCode{"PYC"}, CountryId{"PA"}, Tz::America_Panama}, // Playón Chico Airport
    Airport{IataCode{"PYE"}, CountryId{"NZ"}, Tz::Pacific_Rarotonga}, // Tongareva Airport
    Airport{IataCode{"PYG"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Pakyong Airport
    Airport{IataCode{"PYH"}, CountryId{"VE"}, Tz::America_Caracas}, // Cacique Aramare Airport
    Airport{IataCode{"PYJ"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Polyarny Airport
    Airport{IataCode{"PYK"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Payam International Airport
    Airport{IataCode{"PYM"}, CountryId{"US"}, Tz::America_New_York}, // Plymouth Municipal Airport
    Airport{IataCode{"PYO"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Putumayo Airport
    Airport{IataCode{"PYP"}, CountryId{"US"}, Tz::America_Chicago}, // Piedmont Airport
    Airport{IataCode{"PYS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Paradise Skypark
    Airport{IataCode{"PYX"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Pattaya Airpark
    Airport{IataCode{"PYY"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Pai Airport
    Airport{IataCode{"PZA"}, CountryId{"CO"}, Tz::America_Bogota}, // Paz De Ariporo Airport
    Airport{IataCode{"PZB"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Pietermaritzburg Airport
    Airport{IataCode{"PZH"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Zhob Airport
    Airport{IataCode{"PZI"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Panzhihua Bao'anying Airport
    Airport{IataCode{"PZO"}, CountryId{"VE"}, Tz::America_Caracas}, // Manuel Carlos Piar Guayana Airport
    Airport{IataCode{"PZS"}, CountryId{"CL"}, Tz::America_Santiago}, // Maquehue Airport
    Airport{IataCode{"PZU"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Port Sudan New International Airport
    Airport{IataCode{"PZY"}, CountryId{"SK"}, Tz::Europe_Bratislava}, // Piešťany Airport
    Airport{IataCode{"QAJ"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Ajman International Airport
    Airport{IataCode{"QAQ"}, CountryId{"IT"}, Tz::Europe_Rome}, // L'Aquila Preturo Airport
    Airport{IataCode{"QAS"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Chlef International Airport
    Airport{IataCode{"QBC"}, CountryId{"CA"}, Tz::America_Vancouver}, // Bella Coola Airport
    Airport{IataCode{"QBG"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Pančevo Airport
    Airport{IataCode{"QBS"}, CountryId{"IT"}, Tz::Europe_Rome}, // Verona Boscomantico
    Airport{IataCode{"QCN"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Canela Airport
    Airport{IataCode{"QDC"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Dracena Airport
    Airport{IataCode{"QDF"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Bandeirinhas/Conselheiro Lafaiete Airport
    Airport{IataCode{"QDJ"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Tsletsi Airport
    Airport{IataCode{"QDV"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Jundiaí Airport
    Airport{IataCode{"QEO"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Aleksandrowice Airport
    Airport{IataCode{"QFR"}, CountryId{"IT"}, Tz::Europe_Rome}, // Frosinone Airport
    Airport{IataCode{"QGY"}, CountryId{"HU"}, Tz::Europe_Budapest}, // Győr-Pér International Airport
    Airport{IataCode{"QHR"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Harar Meda Airport
    Airport{IataCode{"QJB"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Jubail Airport
    Airport{IataCode{"QKE"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Milliken Airport
    Airport{IataCode{"QKR"}, CountryId{"FR"}, Tz::America_Cayenne}, // Kourou Airport
    Airport{IataCode{"QKX"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Kautokeino Airport
    Airport{IataCode{"QLA"}, CountryId{"GB"}, Tz::Europe_London}, // Lasham Airfield
    Airport{IataCode{"QLD"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Blida Airport
    Airport{IataCode{"QMF"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Mafra Airport
    Airport{IataCode{"QMH"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Oum el Bouaghi Airport
    Airport{IataCode{"QMJ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Masjed Soleyman Airport
    Airport{IataCode{"QMM"}, CountryId{"IT"}, Tz::Europe_Rome}, // Massa-Cinquale Airport
    Airport{IataCode{"QNC"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Neuchâtel Airport
    Airport{IataCode{"QND"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Novi Sad Airport
    Airport{IataCode{"QNM"}, CountryId{"BE"}, Tz::Europe_Brussels}, // Namur-Suarlee Airport
    Airport{IataCode{"QNV"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Aeroclub, Nova Iguacu Airport
    Airport{IataCode{"QNY"}, CountryId{"US"}, Tz::America_New_York}, // New York Skyports Inc. Seaplane Base
    Airport{IataCode{"QOW"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Sam Mbakwe Airport
    Airport{IataCode{"QPA"}, CountryId{"IT"}, Tz::Europe_Rome}, // Padua Airport
    Airport{IataCode{"QPC"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Plock Airport
    Airport{IataCode{"QPD"}, CountryId{"CU"}, Tz::America_Havana}, // Pinar del Río Airport
    Airport{IataCode{"QPH"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Palapye Airport
    Airport{IataCode{"QRA"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Rand Airport
    Airport{IataCode{"QRC"}, CountryId{"CL"}, Tz::America_Santiago}, // Independencia Airport
    Airport{IataCode{"QRI"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Rize–Artvin Airport
    Airport{IataCode{"QRM"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Narromine Airport
    Airport{IataCode{"QRO"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Querétaro International Airport
    Airport{IataCode{"QRR"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Warren Airport
    Airport{IataCode{"QRT"}, CountryId{"IT"}, Tz::Europe_Rome}, // Rieti Airport
    Airport{IataCode{"QRW"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Warri Airport
    Airport{IataCode{"QSA"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Sabadell Airport
    Airport{IataCode{"QSC"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // São Carlos Airport
    Airport{IataCode{"QSF"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Ain Arnat Airport
    Airport{IataCode{"QSI"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Moshi Airport
    Airport{IataCode{"QSN"}, CountryId{"CU"}, Tz::America_Havana}, // San Nicolás de Bari Airport
    Airport{IataCode{"QSR"}, CountryId{"IT"}, Tz::Europe_Rome}, // Salerno Costa d'Amalfi Airport
    Airport{IataCode{"QSX"}, CountryId{"GY"}, Tz::America_Guyana}, // New Amsterdam Airport
    Airport{IataCode{"QTR"}, CountryId{"CL"}, Tz::America_Santiago}, // Quintero Airport
    Airport{IataCode{"QUB"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Ubari Airport
    Airport{IataCode{"QUG"}, CountryId{"GB"}, Tz::Europe_London}, // Chichester/Goodwood Airport
    Airport{IataCode{"QUO"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Akwa Ibom Airport
    Airport{IataCode{"QUS"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Gusau Airstrip
    Airport{IataCode{"QUT"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Utsunomiya Air Field
    Airport{IataCode{"QVA"}, CountryId{"IT"}, Tz::Europe_Rome}, // Varese-Venegono Airport
    Airport{IataCode{"QVP"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Avaré-Arandu Airport
    Airport{IataCode{"QWG"}, CountryId{"US"}, Tz::America_New_York}, // Wilgrove Air Park
    Airport{IataCode{"QWV"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Valjevo Airport
    Airport{IataCode{"QXB"}, CountryId{"FR"}, Tz::Europe_Paris}, // Aix-en-Provence Aerodrome
    Airport{IataCode{"QYO"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Dajtki Airport
    Airport{IataCode{"QYR"}, CountryId{"FR"}, Tz::Europe_Paris}, // Troyes – Barberey Airport
    Airport{IataCode{"QYY"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Białystok-Krywlany Airport
    Airport{IataCode{"QZD"}, CountryId{"HU"}, Tz::Europe_Budapest}, // Szeged Airport
    Airport{IataCode{"QZN"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Relizane Airport
    Airport{IataCode{"RAA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Rakanda
    Airport{IataCode{"RAB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Rabaul Airport
    Airport{IataCode{"RAC"}, CountryId{"US"}, Tz::America_Chicago}, // John H. Batten Airport
    Airport{IataCode{"RAE"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Arar Domestic Airport
    Airport{IataCode{"RAF"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Rafaela Aerodrome
    Airport{IataCode{"RAH"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Rafha Domestic Airport
    Airport{IataCode{"RAI"}, CountryId{"CV"}, Tz::Atlantic_Cape_Verde}, // Praia International Airport
    Airport{IataCode{"RAJ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Rajkot Airport
    Airport{IataCode{"RAK"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Marrakesh Menara Airport
    Airport{IataCode{"RAL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Riverside Municipal Airport
    Airport{IataCode{"RAM"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Ramingining Airport
    Airport{IataCode{"RAN"}, CountryId{"IT"}, Tz::Europe_Rome}, // Ravenna Airport
    Airport{IataCode{"RAO"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Leite Lopes Airport
    Airport{IataCode{"RAP"}, CountryId{"US"}, Tz::America_Denver}, // Rapid City Regional Airport
    Airport{IataCode{"RAQ"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Sugimanuru Airport
    Airport{IataCode{"RAR"}, CountryId{"CK"}, Tz::Pacific_Rarotonga}, // Rarotonga International Airport
    Airport{IataCode{"RAS"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Rasht Airport
    Airport{IataCode{"RAT"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Raduzhny Airport
    Airport{IataCode{"RAV"}, CountryId{"CO"}, Tz::America_Bogota}, // Cravo Norte Airport
    Airport{IataCode{"RAW"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Arawa Airport
    Airport{IataCode{"RAX"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Oram
    Airport{IataCode{"RAZ"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Rawalakot Airport
    Airport{IataCode{"RBB"}, CountryId{"BR"}, Tz::America_Manaus}, // Borba Airport
    Airport{IataCode{"RBC"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Robinvale Airport
    Airport{IataCode{"RBD"}, CountryId{"US"}, Tz::America_Chicago}, // Dallas Executive Airport
    Airport{IataCode{"RBE"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Ratanakiri Airport
    Airport{IataCode{"RBF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Big Bear City Airport
    Airport{IataCode{"RBG"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Roseburg Regional Airport
    Airport{IataCode{"RBI"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Rabi Airport
    Airport{IataCode{"RBJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Rebun Airport
    Airport{IataCode{"RBK"}, CountryId{"US"}, Tz::America_Los_Angeles}, // French Valley Airport
    Airport{IataCode{"RBL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Red Bluff Municipal Airport
    Airport{IataCode{"RBO"}, CountryId{"BO"}, Tz::America_La_Paz}, // Robore Airport
    Airport{IataCode{"RBP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Rabaraba
    Airport{IataCode{"RBQ"}, CountryId{"BO"}, Tz::America_La_Paz}, // Rurrenabaque Airport
    Airport{IataCode{"RBR"}, CountryId{"BR"}, Tz::America_Rio_Branco}, // Rio Branco International Airport
    Airport{IataCode{"RBS"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Orbost Airport
    Airport{IataCode{"RBT"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Marsabit Airport
    Airport{IataCode{"RBV"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Ramata Airport
    Airport{IataCode{"RBW"}, CountryId{"US"}, Tz::America_New_York}, // Lowcountry Regional Airport
    Airport{IataCode{"RBX"}, CountryId{"SS"}, Tz::Africa_Juba}, // Rumbek Airport
    Airport{IataCode{"RBY"}, CountryId{"US"}, Tz::America_Anchorage}, // Ruby Airport
    Airport{IataCode{"RCB"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Richards Bay Airport
    Airport{IataCode{"RCH"}, CountryId{"CO"}, Tz::America_Bogota}, // Almirante Padilla Airport
    Airport{IataCode{"RCL"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Redcliffe Airport
    Airport{IataCode{"RCM"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Richmond Airport
    Airport{IataCode{"RCP"}, CountryId{"US"}, Tz::America_Chicago}, // Rooks County Regional Airport
    Airport{IataCode{"RCQ"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Reconquista Airport
    Airport{IataCode{"RCR"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Fulton County Airport
    Airport{IataCode{"RCS"}, CountryId{"GB"}, Tz::Europe_London}, // Rochester Airport
    Airport{IataCode{"RCT"}, CountryId{"US"}, Tz::America_Detroit}, // Nartron Field
    Airport{IataCode{"RCU"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Las Higueras Airport
    Airport{IataCode{"RCX"}, CountryId{"US"}, Tz::America_Chicago}, // Rusk County Airport
    Airport{IataCode{"RCY"}, CountryId{"BS"}, Tz::America_Nassau}, // Port Nelson Airport
    Airport{IataCode{"RCZ"}, CountryId{"US"}, Tz::America_New_York}, // Richmond County Airport
    Airport{IataCode{"RDB"}, CountryId{"US"}, Tz::America_Nome}, // Red Dog Airport
    Airport{IataCode{"RDC"}, CountryId{"BR"}, Tz::America_Belem}, // Redenção Airport
    Airport{IataCode{"RDD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Redding Municipal Airport
    Airport{IataCode{"RDG"}, CountryId{"US"}, Tz::America_New_York}, // Reading Regional Airport
    Airport{IataCode{"RDK"}, CountryId{"US"}, Tz::America_Chicago}, // Red Oak Municipal Airport
    Airport{IataCode{"RDM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Roberts Field
    Airport{IataCode{"RDN"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Redang Airport
    Airport{IataCode{"RDO"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Radom-Sadków Airport
    Airport{IataCode{"RDP"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Kazi Nazrul Islam Airport
    Airport{IataCode{"RDS"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Rincón de los Sauces Airport
    Airport{IataCode{"RDT"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Richard Toll Airport
    Airport{IataCode{"RDU"}, CountryId{"US"}, Tz::America_New_York}, // Raleigh–Durham International Airport
    Airport{IataCode{"RDV"}, CountryId{"US"}, Tz::America_Anchorage}, // Red Devil Airport
    Airport{IataCode{"RDZ"}, CountryId{"FR"}, Tz::Europe_Paris}, // Rodez-Aveyron Airport
    Airport{IataCode{"REA"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Reao Airport
    Airport{IataCode{"REC"}, CountryId{"BR"}, Tz::America_Recife}, // Recife/Guararapes–Gilberto Freyre International Airport
    Airport{IataCode{"RED"}, CountryId{"US"}, Tz::America_New_York}, // Mifflin County Airport
    Airport{IataCode{"REG"}, CountryId{"IT"}, Tz::Europe_Rome}, // Reggio Calabria Airport
    Airport{IataCode{"REL"}, CountryId{"AR"}, Tz::America_Argentina_Catamarca}, // Almirante Marcos A. Zar Airport
    Airport{IataCode{"REN"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Orenburg Tsentralny Airport
    Airport{IataCode{"REO"}, CountryId{"US"}, Tz::America_Boise}, // Rome State Airport
    Airport{IataCode{"REP"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Siem Reap International Airport
    Airport{IataCode{"RER"}, CountryId{"GT"}, Tz::America_Guatemala}, // Retalhuleu Airport
    Airport{IataCode{"RES"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Resistencia International Airport
    Airport{IataCode{"RET"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Røst Airport
    Airport{IataCode{"REU"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Reus Airport
    Airport{IataCode{"REX"}, CountryId{"MX"}, Tz::America_Matamoros}, // General Lucio Blanco International Airport
    Airport{IataCode{"REY"}, CountryId{"BO"}, Tz::America_La_Paz}, // Reyes Airport
    Airport{IataCode{"REZ"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Resende Airport
    Airport{IataCode{"RFA"}, CountryId{"CF"}, Tz::Africa_Bangui}, // Rafaï Airport
    Airport{IataCode{"RFD"}, CountryId{"US"}, Tz::America_Chicago}, // Chicago Rockford International Airport
    Airport{IataCode{"RFI"}, CountryId{"US"}, Tz::America_Chicago}, // Rusk County Airport
    Airport{IataCode{"RFN"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Raufarhöfn Airport
    Airport{IataCode{"RFP"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Raiatea Airport
    Airport{IataCode{"RFR"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Rio Frio / Progreso Airport
    Airport{IataCode{"RFS"}, CountryId{"NI"}, Tz::America_Managua}, // Rosita Airport
    Airport{IataCode{"RGA"}, CountryId{"AR"}, Tz::America_Argentina_Ushuaia}, // Rio Grande Airport
    Airport{IataCode{"RGH"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Balurghat Airport
    Airport{IataCode{"RGI"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Rangiroa Airport
    Airport{IataCode{"RGK"}, CountryId{"RU"}, Tz::Asia_Barnaul}, // Gorno-Altaysk Airport
    Airport{IataCode{"RGL"}, CountryId{"AR"}, Tz::America_Argentina_Rio_Gallegos}, // Piloto Civil Norberto Fernández International Airport
    Airport{IataCode{"RGN"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Yangon International Airport
    Airport{IataCode{"RGO"}, CountryId{"KP"}, Tz::Asia_Pyongyang}, // Chongjin Airport
    Airport{IataCode{"RGS"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Burgos Airport
    Airport{IataCode{"RGT"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Japura Airport
    Airport{IataCode{"RHD"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Las Termas Airport
    Airport{IataCode{"RHG"}, CountryId{"RW"}, Tz::Africa_Kigali}, // Ruhengeri Airport
    Airport{IataCode{"RHI"}, CountryId{"US"}, Tz::America_Chicago}, // Rhinelander–Oneida County Airport
    Airport{IataCode{"RHO"}, CountryId{"GR"}, Tz::Europe_Athens}, // Rhodes International Airport
    Airport{IataCode{"RHP"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Ramechhap Airport
    Airport{IataCode{"RHT"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Alxa Right Banner Badanjilin Airport
    Airport{IataCode{"RHV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Reid-Hillview Airport
    Airport{IataCode{"RIB"}, CountryId{"BO"}, Tz::America_La_Paz}, // Riberalta Airport
    Airport{IataCode{"RIC"}, CountryId{"US"}, Tz::America_New_York}, // Richmond International Airport
    Airport{IataCode{"RID"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Richmond Municipal Airport
    Airport{IataCode{"RIE"}, CountryId{"US"}, Tz::America_Chicago}, // Rice Lake Regional Airport
    Airport{IataCode{"RIH"}, CountryId{"PA"}, Tz::America_Panama}, // Río Hato Airport
    Airport{IataCode{"RIJ"}, CountryId{"PE"}, Tz::America_Lima}, // Juan Simons Vela Airport
    Airport{IataCode{"RIL"}, CountryId{"US"}, Tz::America_Denver}, // Garfield County Regional Airport
    Airport{IataCode{"RIN"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Ringi Cove Airport
    Airport{IataCode{"RIR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Flabob Airport
    Airport{IataCode{"RIS"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Rishiri Airport
    Airport{IataCode{"RIU"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Rancho Murieta Airport
    Airport{IataCode{"RIW"}, CountryId{"US"}, Tz::America_Denver}, // Riverton Regional Airport
    Airport{IataCode{"RIX"}, CountryId{"LV"}, Tz::Europe_Riga}, // Riga International Airport
    Airport{IataCode{"RIY"}, CountryId{"YE"}, Tz::Asia_Aden}, // Riyan Airport
    Airport{IataCode{"RIZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Rizhao Shanzihe Airport
    Airport{IataCode{"RJA"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Rajahmundry Airport
    Airport{IataCode{"RJB"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Rajbiraj Airport
    Airport{IataCode{"RJH"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Shah Makhdum Airport
    Airport{IataCode{"RJK"}, CountryId{"HR"}, Tz::Europe_Zagreb}, // Rijeka Airport
    Airport{IataCode{"RJL"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Logroño-Agoncillo Airport
    Airport{IataCode{"RJM"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Marinda Airport
    Airport{IataCode{"RJN"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Rafsanjan Airport
    Airport{IataCode{"RKA"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Aratika Airport
    Airport{IataCode{"RKD"}, CountryId{"US"}, Tz::America_New_York}, // Knox County Regional Airport
    Airport{IataCode{"RKE"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Roskilde Airport
    Airport{IataCode{"RKH"}, CountryId{"US"}, Tz::America_New_York}, // Rock Hill/York County Airport
    Airport{IataCode{"RKI"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Rokot Airport
    Airport{IataCode{"RKP"}, CountryId{"US"}, Tz::America_Chicago}, // Aransas County Airport
    Airport{IataCode{"RKR"}, CountryId{"US"}, Tz::America_Chicago}, // Robert S. Kerr Airport
    Airport{IataCode{"RKS"}, CountryId{"US"}, Tz::America_Denver}, // Southwest Wyoming Regional Airport
    Airport{IataCode{"RKT"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Ras Al Khaimah International Airport
    Airport{IataCode{"RKV"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Reykjavík Airport
    Airport{IataCode{"RKW"}, CountryId{"US"}, Tz::America_Chicago}, // Rockwood Municipal Airport
    Airport{IataCode{"RKZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shigatse Peace Airport
    Airport{IataCode{"RLD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Richland Airport
    Airport{IataCode{"RLG"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Rostock Airport
    Airport{IataCode{"RLK"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Bayannur Tianjitai Airport
    Airport{IataCode{"RLO"}, CountryId{"AR"}, Tz::America_Argentina_San_Luis}, // Sta. Rosa De Conlara Airport
    Airport{IataCode{"RLT"}, CountryId{"NE"}, Tz::Africa_Niamey}, // Arlit Airport
    Airport{IataCode{"RMA"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Roma Airport
    Airport{IataCode{"RMB"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Buraimi Airport
    Airport{IataCode{"RMD"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Ramagundam Airport
    Airport{IataCode{"RME"}, CountryId{"US"}, Tz::America_New_York}, // Griffiss International Airport
    Airport{IataCode{"RMF"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Marsa Alam International Airport
    Airport{IataCode{"RMG"}, CountryId{"US"}, Tz::America_New_York}, // Richard B. Russell Airport
    Airport{IataCode{"RMI"}, CountryId{"IT"}, Tz::Europe_Rome}, // Federico Fellini International Airport
    Airport{IataCode{"RMK"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Renmark Airport
    Airport{IataCode{"RML"}, CountryId{"LK"}, Tz::Asia_Colombo}, // Ratmalana Airport
    Airport{IataCode{"RMN"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Rumginae Airport
    Airport{IataCode{"RMP"}, CountryId{"US"}, Tz::America_Anchorage}, // Rampart Airport
    Airport{IataCode{"RMQ"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Taichung Airport
    Airport{IataCode{"RMT"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Rimatara Airport
    Airport{IataCode{"RMU"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Región de Murcia International Airport
    Airport{IataCode{"RMY"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Mariposa-Yosemite Airport
    Airport{IataCode{"RNA"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Ulawa Airport
    Airport{IataCode{"RNB"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Ronneby Airport
    Airport{IataCode{"RNC"}, CountryId{"US"}, Tz::America_Chicago}, // Warren County Memorial Airport
    Airport{IataCode{"RNH"}, CountryId{"US"}, Tz::America_Chicago}, // New Richmond Regional Airport
    Airport{IataCode{"RNI"}, CountryId{"NI"}, Tz::America_Managua}, // Corn Island Airport
    Airport{IataCode{"RNJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Yoron Airport
    Airport{IataCode{"RNL"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Rennell/Tingoa Airport
    Airport{IataCode{"RNM"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Qarn Alam Airport
    Airport{IataCode{"RNN"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Bornholm Airport
    Airport{IataCode{"RNO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Reno–Tahoe International Airport
    Airport{IataCode{"RNP"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Rongelap Airport
    Airport{IataCode{"RNS"}, CountryId{"FR"}, Tz::Europe_Paris}, // Rennes – Saint-Jacques Airport
    Airport{IataCode{"RNT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Renton Municipal Airport
    Airport{IataCode{"RNU"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Ranau Airport
    Airport{IataCode{"RNV"}, CountryId{"US"}, Tz::America_Chicago}, // Cleveland Municipal Airport
    Airport{IataCode{"RNZ"}, CountryId{"US"}, Tz::America_Chicago}, // Jasper County Airport
    Airport{IataCode{"ROA"}, CountryId{"US"}, Tz::America_New_York}, // Roanoke–Blacksburg Regional Airport
    Airport{IataCode{"ROB"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Roberts International Airport
    Airport{IataCode{"ROC"}, CountryId{"US"}, Tz::America_New_York}, // Greater Rochester International Airport
    Airport{IataCode{"ROD"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Robertson Airfield
    Airport{IataCode{"ROF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Montague Airport
    Airport{IataCode{"ROG"}, CountryId{"US"}, Tz::America_Chicago}, // Rogers Municipal Airport
    Airport{IataCode{"ROI"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Roi Et Airport
    Airport{IataCode{"ROK"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Rockhampton Airport
    Airport{IataCode{"RON"}, CountryId{"CO"}, Tz::America_Bogota}, // Juan José Rondón Airport
    Airport{IataCode{"ROO"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Rondonópolis Airport
    Airport{IataCode{"ROP"}, CountryId{"US"}, Tz::Pacific_Saipan}, // Rota International Airport
    Airport{IataCode{"ROR"}, CountryId{"PW"}, Tz::Pacific_Palau}, // Roman Tmetuchl International Airport
    Airport{IataCode{"ROS"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Rosario – Islas Malvinas International Airport
    Airport{IataCode{"ROT"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Rotorua International Airport
    Airport{IataCode{"ROV"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Platov International Airport
    Airport{IataCode{"ROW"}, CountryId{"US"}, Tz::America_Denver}, // Roswell International Air Center
    Airport{IataCode{"ROY"}, CountryId{"AR"}, Tz::America_Argentina_Catamarca}, // Río Mayo Airport
    Airport{IataCode{"RPA"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Rolpa
    Airport{IataCode{"RPB"}, CountryId{"US"}, Tz::America_Chicago}, // Belleville Municipal Airport
    Airport{IataCode{"RPJ"}, CountryId{"US"}, Tz::America_Chicago}, // Rochelle Municipal Airport
    Airport{IataCode{"RPM"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Ngukurr Airport
    Airport{IataCode{"RPN"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Rosh Pina Airport
    Airport{IataCode{"RPR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Swami Vivekananda Airport
    Airport{IataCode{"RPX"}, CountryId{"US"}, Tz::America_Denver}, // Roundup Airport
    Airport{IataCode{"RQE"}, CountryId{"US"}, Tz::America_Denver}, // Window Rock Airport
    Airport{IataCode{"RQO"}, CountryId{"US"}, Tz::America_Chicago}, // El Reno Regional Airport
    Airport{IataCode{"RRG"}, CountryId{"MU"}, Tz::Indian_Mauritius}, // Sir Gaëtan Duval Airport
    Airport{IataCode{"RRK"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Rourkela Airport
    Airport{IataCode{"RRL"}, CountryId{"US"}, Tz::America_Chicago}, // Merrill Municipal Airport
    Airport{IataCode{"RRR"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Raroia Airport
    Airport{IataCode{"RRS"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Røros Airport
    Airport{IataCode{"RRT"}, CountryId{"US"}, Tz::America_Chicago}, // Warroad International Airport
    Airport{IataCode{"RSA"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Santa Rosa Airport
    Airport{IataCode{"RSD"}, CountryId{"BS"}, Tz::America_Nassau}, // Rock Sound International Airport
    Airport{IataCode{"RSE"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Rose Bay Water Airport
    Airport{IataCode{"RSH"}, CountryId{"US"}, Tz::America_Anchorage}, // Russian Mission Airport
    Airport{IataCode{"RSJ"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Rosario Seaplane Base
    Airport{IataCode{"RSN"}, CountryId{"US"}, Tz::America_Chicago}, // Ruston Regional Airport
    Airport{IataCode{"RST"}, CountryId{"US"}, Tz::America_Chicago}, // Rochester International Airport
    Airport{IataCode{"RSU"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Yeosu Airport
    Airport{IataCode{"RSV"}, CountryId{"US"}, Tz::America_Chicago}, // Crawford County Airport
    Airport{IataCode{"RSW"}, CountryId{"US"}, Tz::America_New_York}, // Southwest Florida International Airport
    Airport{IataCode{"RTA"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Rotuma Airport
    Airport{IataCode{"RTB"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Juan Manuel Gálvez International Airport
    Airport{IataCode{"RTC"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Ratnagiri Airport
    Airport{IataCode{"RTG"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Frans Sales Lega Airport
    Airport{IataCode{"RTI"}, CountryId{"ID"}, Tz::Asia_Makassar}, // David Constantijn Saudale Airport
    Airport{IataCode{"RTL"}, CountryId{"US"}, Tz::America_Chicago}, // Spirit Lake Municipal Airport
    Airport{IataCode{"RTM"}, CountryId{"NL"}, Tz::Europe_Amsterdam}, // Rotterdam The Hague Airport
    Airport{IataCode{"RTN"}, CountryId{"US"}, Tz::America_Denver}, // Raton Municipal Airport
    Airport{IataCode{"RTS"}, CountryId{"AU"}, Tz::Australia_Perth}, // Rottnest Island Airport
    Airport{IataCode{"RUA"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Arua Airport
    Airport{IataCode{"RUD"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Shahroud Airport
    Airport{IataCode{"RUE"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Rughenda Airport
    Airport{IataCode{"RUG"}, CountryId{"US"}, Tz::America_Chicago}, // Rugby Municipal Airport
    Airport{IataCode{"RUH"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // King Khalid International Airport
    Airport{IataCode{"RUI"}, CountryId{"US"}, Tz::America_Denver}, // Sierra Blanca Regional Airport
    Airport{IataCode{"RUK"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Rukumkot Airport
    Airport{IataCode{"RUL"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Maavaarulaa Airport
    Airport{IataCode{"RUM"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Rumjatar Airport
    Airport{IataCode{"RUN"}, CountryId{"FR"}, Tz::Indian_Reunion}, // Roland Garros Airport
    Airport{IataCode{"RUP"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Rupsi Airport
    Airport{IataCode{"RUR"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Rurutu Airport
    Airport{IataCode{"RUS"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Marau Airport
    Airport{IataCode{"RUT"}, CountryId{"US"}, Tz::America_New_York}, // Rutland Southern Vermont Regional Airport
    Airport{IataCode{"RUU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Ruti
    Airport{IataCode{"RUV"}, CountryId{"GT"}, Tz::America_Guatemala}, // Rubelsanto Airport
    Airport{IataCode{"RUY"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Ruinas de Copan Airport
    Airport{IataCode{"RVA"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Farafangana Airport
    Airport{IataCode{"RVD"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Rio Verde Airport
    Airport{IataCode{"RVE"}, CountryId{"CO"}, Tz::America_Bogota}, // Los Colonizadores Airport
    Airport{IataCode{"RVH"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Rzhevka Airport
    Airport{IataCode{"RVK"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Rørvik Airport
    Airport{IataCode{"RVN"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Rovaniemi Airport
    Airport{IataCode{"RVR"}, CountryId{"US"}, Tz::America_Denver}, // Green River Municipal Airport
    Airport{IataCode{"RVS"}, CountryId{"US"}, Tz::America_Chicago}, // Richard Lloyd Jones Jr. Airport
    Airport{IataCode{"RVT"}, CountryId{"AU"}, Tz::Australia_Perth}, // Ravensthorpe Airport
    Airport{IataCode{"RVV"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Raivavae Airport
    Airport{IataCode{"RVY"}, CountryId{"UY"}, Tz::America_Montevideo}, // Rivera International Airport
    Airport{IataCode{"RWI"}, CountryId{"US"}, Tz::America_New_York}, // Rocky Mount-Wilson Regional Airport
    Airport{IataCode{"RWL"}, CountryId{"US"}, Tz::America_Denver}, // Rawlins Municipal Airport
    Airport{IataCode{"RWN"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Rivne International Airport
    Airport{IataCode{"RWV"}, CountryId{"US"}, Tz::America_Chicago}, // Caldwell Municipal Airport
    Airport{IataCode{"RXE"}, CountryId{"US"}, Tz::America_Boise}, // Rexburg-Madison County Airport
    Airport{IataCode{"RXS"}, CountryId{"PH"}, Tz::Asia_Manila}, // Roxas Airport
    Airport{IataCode{"RYB"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Staroselye Airport
    Airport{IataCode{"RYG"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Moss Airport, Rygge
    Airport{IataCode{"RYK"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Shaikh Zayed International Airport
    Airport{IataCode{"RYO"}, CountryId{"AR"}, Tz::America_Argentina_Rio_Gallegos}, // Rio Turbio Airport
    Airport{IataCode{"RYV"}, CountryId{"US"}, Tz::America_Chicago}, // Watertown Municipal Airport
    Airport{IataCode{"RYY"}, CountryId{"US"}, Tz::America_New_York}, // Cobb County Airport
    Airport{IataCode{"RZA"}, CountryId{"AR"}, Tz::America_Argentina_Rio_Gallegos}, // Santa Cruz Airport, Argentina
    Airport{IataCode{"RZE"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Rzeszów-Jasionka Airport
    Airport{IataCode{"RZN"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Turlatovo Airport
    Airport{IataCode{"RZP"}, CountryId{"PH"}, Tz::Asia_Manila}, // Taytay Airport
    Airport{IataCode{"RZR"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Ramsar Airport
    Airport{IataCode{"RZS"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Sawan Airport
    Airport{IataCode{"SAA"}, CountryId{"US"}, Tz::America_Denver}, // Shively Field
    Airport{IataCode{"SAB"}, CountryId{"NL"}, Tz::America_Kralendijk}, // Juancho E. Yrausquin Airport
    Airport{IataCode{"SAC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Sacramento Executive Airport
    Airport{IataCode{"SAD"}, CountryId{"US"}, Tz::America_Phoenix}, // Safford Regional Airport
    Airport{IataCode{"SAF"}, CountryId{"US"}, Tz::America_Denver}, // Santa Fe Municipal Airport
    Airport{IataCode{"SAG"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Shirdi Airport
    Airport{IataCode{"SAH"}, CountryId{"YE"}, Tz::Asia_Aden}, // Sana'a International Airport
    Airport{IataCode{"SAK"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Sauðárkrókur Airport
    Airport{IataCode{"SAL"}, CountryId{"SV"}, Tz::America_El_Salvador}, // Monseñor Óscar Arnulfo Romero International Airport
    Airport{IataCode{"SAM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Salamo Airport
    Airport{IataCode{"SAN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // San Diego International Airport
    Airport{IataCode{"SAP"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Ramón Villeda Morales International Airport
    Airport{IataCode{"SAQ"}, CountryId{"BS"}, Tz::America_Nassau}, // San Andros Airport
    Airport{IataCode{"SAS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Salton Sea Airport
    Airport{IataCode{"SAT"}, CountryId{"US"}, Tz::America_Chicago}, // San Antonio International Airport
    Airport{IataCode{"SAU"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Tardamu Airport
    Airport{IataCode{"SAV"}, CountryId{"US"}, Tz::America_New_York}, // Savannah/Hilton Head International Airport
    Airport{IataCode{"SAW"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Istanbul Sabiha Gökçen International Airport
    Airport{IataCode{"SAZ"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Sasstown Airport
    Airport{IataCode{"SBA"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Santa Barbara Municipal Airport
    Airport{IataCode{"SBB"}, CountryId{"VE"}, Tz::America_Caracas}, // Santa Barbara De Barinas Airport
    Airport{IataCode{"SBC"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Selbang
    Airport{IataCode{"SBD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // San Bernardino International Airport
    Airport{IataCode{"SBF"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Sardeh Band Airport
    Airport{IataCode{"SBG"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Maimun Saleh Airport
    Airport{IataCode{"SBH"}, CountryId{"FR"}, Tz::America_St_Barthelemy}, // Gustaf III Airport
    Airport{IataCode{"SBI"}, CountryId{"GN"}, Tz::Africa_Conakry}, // Sambailo Airport
    Airport{IataCode{"SBK"}, CountryId{"FR"}, Tz::Europe_Paris}, // Saint-Brieuc – Armor Airport
    Airport{IataCode{"SBM"}, CountryId{"US"}, Tz::America_Chicago}, // Sheboygan County Memorial Airport
    Airport{IataCode{"SBN"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // South Bend Regional Airport
    Airport{IataCode{"SBO"}, CountryId{"US"}, Tz::America_Denver}, // Salina-Gunnison Airport
    Airport{IataCode{"SBP"}, CountryId{"US"}, Tz::America_Los_Angeles}, // San Luis Obispo County Regional Airport
    Airport{IataCode{"SBQ"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Sibi Airport
    Airport{IataCode{"SBR"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Saibai Island Airport
    Airport{IataCode{"SBS"}, CountryId{"US"}, Tz::America_Denver}, // Steamboat Springs Airport
    Airport{IataCode{"SBT"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Sabetta International Airport
    Airport{IataCode{"SBU"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Springbok Airport
    Airport{IataCode{"SBV"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Sabah
    Airport{IataCode{"SBW"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Sibu Airport
    Airport{IataCode{"SBX"}, CountryId{"US"}, Tz::America_Denver}, // Shelby Airport
    Airport{IataCode{"SBY"}, CountryId{"US"}, Tz::America_New_York}, // Salisbury–Ocean City–Wicomico Regional Airport
    Airport{IataCode{"SBZ"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Sibiu International Airport
    Airport{IataCode{"SCB"}, CountryId{"US"}, Tz::America_Chicago}, // Scribner State Airport
    Airport{IataCode{"SCC"}, CountryId{"US"}, Tz::America_Anchorage}, // Deadhorse Airport
    Airport{IataCode{"SCD"}, CountryId{"US"}, Tz::America_Chicago}, // Sylacauga Municipal Airport
    Airport{IataCode{"SCE"}, CountryId{"US"}, Tz::America_New_York}, // University Park Airport
    Airport{IataCode{"SCF"}, CountryId{"US"}, Tz::America_Phoenix}, // Scottsdale Airport
    Airport{IataCode{"SCH"}, CountryId{"US"}, Tz::America_New_York}, // Schenectady County Airport
    Airport{IataCode{"SCI"}, CountryId{"VE"}, Tz::America_Caracas}, // Paramillo Airport
    Airport{IataCode{"SCK"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Stockton Metropolitan Airport
    Airport{IataCode{"SCL"}, CountryId{"CL"}, Tz::America_Santiago}, // Arturo Merino Benítez International Airport
    Airport{IataCode{"SCM"}, CountryId{"US"}, Tz::America_Nome}, // Scammon Bay Airport
    Airport{IataCode{"SCN"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Saarbrücken Airport
    Airport{IataCode{"SCO"}, CountryId{"KZ"}, Tz::Asia_Aqtau}, // Aktau Airport
    Airport{IataCode{"SCQ"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Santiago - Rosalia de Castro Airport
    Airport{IataCode{"SCR"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Scandinavian Mountains Airport
    Airport{IataCode{"SCS"}, CountryId{"GB"}, Tz::Europe_London}, // Scatsta Airport
    Airport{IataCode{"SCT"}, CountryId{"YE"}, Tz::Asia_Aden}, // Socotra Airport
    Airport{IataCode{"SCU"}, CountryId{"CU"}, Tz::America_Havana}, // Antonio Maceo Airport
    Airport{IataCode{"SCV"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Suceava Airport
    Airport{IataCode{"SCW"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Syktyvkar Airport
    Airport{IataCode{"SCX"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Salina Cruz Airport
    Airport{IataCode{"SCY"}, CountryId{"EC"}, Tz::Pacific_Galapagos}, // San Cristóbal Airport
    Airport{IataCode{"SCZ"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Santa Cruz/Graciosa Bay/Luova Airport
    Airport{IataCode{"SDC"}, CountryId{"US"}, Tz::America_New_York}, // Williamson–Sodus Airport
    Airport{IataCode{"SDD"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Lubango Airport
    Airport{IataCode{"SDE"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Vicecomodoro Ángel de la Paz Aragonés Airport
    Airport{IataCode{"SDF"}, CountryId{"US"}, Tz::America_Kentucky_Louisville}, // Louisville International Airport
    Airport{IataCode{"SDG"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Sanandaj Airport
    Airport{IataCode{"SDH"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Santa Rosa de Copán Airport
    Airport{IataCode{"SDI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Saidor Airport
    Airport{IataCode{"SDJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Sendai Airport
    Airport{IataCode{"SDK"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Sandakan Airport
    Airport{IataCode{"SDL"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Sundsvall-Timrå Airport
    Airport{IataCode{"SDM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Brown Field Municipal Airport
    Airport{IataCode{"SDN"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Sandane Airport
    Airport{IataCode{"SDO"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Smederevo Airport
    Airport{IataCode{"SDP"}, CountryId{"US"}, Tz::America_Anchorage}, // Sand Point Airport
    Airport{IataCode{"SDQ"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // Las Américas International Airport
    Airport{IataCode{"SDR"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Santander Airport
    Airport{IataCode{"SDS"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Sado Airport
    Airport{IataCode{"SDT"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Saidu Sharif Airport
    Airport{IataCode{"SDU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Santos Dumont Airport
    Airport{IataCode{"SDX"}, CountryId{"US"}, Tz::America_Phoenix}, // Sedona Airport
    Airport{IataCode{"SDY"}, CountryId{"US"}, Tz::America_Denver}, // Sidney-Richland Municipal Airport
    Airport{IataCode{"SEA"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Seattle–Tacoma International Airport
    Airport{IataCode{"SEB"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Sabha Airport
    Airport{IataCode{"SEE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Gillespie Field
    Airport{IataCode{"SEF"}, CountryId{"US"}, Tz::America_New_York}, // Sebring Regional Airport
    Airport{IataCode{"SEG"}, CountryId{"US"}, Tz::America_New_York}, // Penn Valley Airport
    Airport{IataCode{"SEK"}, CountryId{"RU"}, Tz::Asia_Srednekolymsk}, // Srednekolymsk Airport
    Airport{IataCode{"SEM"}, CountryId{"US"}, Tz::America_Chicago}, // Craig Field Airport
    Airport{IataCode{"SEN"}, CountryId{"GB"}, Tz::Europe_London}, // London Southend Airport
    Airport{IataCode{"SEO"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Séguéla Airport
    Airport{IataCode{"SEQ"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Sungai Pakning
    Airport{IataCode{"SER"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Freeman Municipal Airport
    Airport{IataCode{"SEU"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Seronera Airstrip
    Airport{IataCode{"SEV"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Sievierodonetsk Airport
    Airport{IataCode{"SEW"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Siwa Oasis North Airport
    Airport{IataCode{"SEY"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Sélibaby Airport
    Airport{IataCode{"SEZ"}, CountryId{"SC"}, Tz::Indian_Mahe}, // Seychelles International Airport
    Airport{IataCode{"SFA"}, CountryId{"TN"}, Tz::Africa_Tunis}, // Sfax–Thyna International Airport
    Airport{IataCode{"SFB"}, CountryId{"US"}, Tz::America_New_York}, // Orlando Sanford International Airport
    Airport{IataCode{"SFC"}, CountryId{"FR"}, Tz::America_Guadeloupe}, // Saint-François Airport
    Airport{IataCode{"SFD"}, CountryId{"VE"}, Tz::America_Caracas}, // Las Flecheras Airport
    Airport{IataCode{"SFE"}, CountryId{"PH"}, Tz::Asia_Manila}, // San Fernando Airport
    Airport{IataCode{"SFF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Felts Field
    Airport{IataCode{"SFG"}, CountryId{"FR"}, Tz::America_Marigot}, // L'Espérance Airport
    Airport{IataCode{"SFH"}, CountryId{"MX"}, Tz::America_Tijuana}, // San Felipe International Airport
    Airport{IataCode{"SFK"}, CountryId{"HU"}, Tz::Europe_Budapest}, // Siófok-Kiliti Airport
    Airport{IataCode{"SFL"}, CountryId{"CV"}, Tz::Atlantic_Cape_Verde}, // São Filipe Airport
    Airport{IataCode{"SFM"}, CountryId{"US"}, Tz::America_New_York}, // Sanford Regional Airport
    Airport{IataCode{"SFN"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Sauce Viejo Airport
    Airport{IataCode{"SFO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // San Francisco International Airport
    Airport{IataCode{"SFS"}, CountryId{"PH"}, Tz::Asia_Manila}, // Subic Bay International Airport
    Airport{IataCode{"SFT"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Skellefteå Airport
    Airport{IataCode{"SFU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Safia
    Airport{IataCode{"SFZ"}, CountryId{"US"}, Tz::America_New_York}, // North Central State Airport
    Airport{IataCode{"SGA"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Sheghnan Airport
    Airport{IataCode{"SGC"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Surgut International Airport
    Airport{IataCode{"SGD"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Sønderborg Airport
    Airport{IataCode{"SGE"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Siegerland Airport
    Airport{IataCode{"SGF"}, CountryId{"US"}, Tz::America_Chicago}, // Springfield-Branson National Airport
    Airport{IataCode{"SGH"}, CountryId{"US"}, Tz::America_New_York}, // Springfield-Beckley Municipal Airport
    Airport{IataCode{"SGJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Sagarai
    Airport{IataCode{"SGK"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Sangapi Airport
    Airport{IataCode{"SGL"}, CountryId{"PH"}, Tz::Asia_Manila}, // Sangley Point Airport
    Airport{IataCode{"SGM"}, CountryId{"MX"}, Tz::America_Mazatlan}, // San Ignacio Airfield
    Airport{IataCode{"SGN"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Tan Son Nhat International Airport
    Airport{IataCode{"SGO"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // St George Airport
    Airport{IataCode{"SGP"}, CountryId{"AU"}, Tz::Australia_Perth}, // Shay Gap Airport
    Airport{IataCode{"SGR"}, CountryId{"US"}, Tz::America_Chicago}, // Sugar Land Regional Airport
    Airport{IataCode{"SGS"}, CountryId{"PH"}, Tz::Asia_Manila}, // Sanga-Sanga Airport
    Airport{IataCode{"SGT"}, CountryId{"US"}, Tz::America_Chicago}, // Stuttgart Municipal Airport
    Airport{IataCode{"SGU"}, CountryId{"US"}, Tz::America_Denver}, // St. George Regional Airport
    Airport{IataCode{"SGV"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Sierra Grande Airport
    Airport{IataCode{"SGX"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Songea Airport
    Airport{IataCode{"SGY"}, CountryId{"US"}, Tz::America_Juneau}, // Skagway Airport
    Airport{IataCode{"SGZ"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Songkhla Airport
    Airport{IataCode{"SHA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shanghai Hongqiao International Airport
    Airport{IataCode{"SHB"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Nakashibetsu Airport
    Airport{IataCode{"SHC"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Shire Airport
    Airport{IataCode{"SHD"}, CountryId{"US"}, Tz::America_New_York}, // Shenandoah Valley Regional Airport
    Airport{IataCode{"SHE"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shenyang Taoxian International Airport
    Airport{IataCode{"SHF"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Shihezi Huayuan Airport
    Airport{IataCode{"SHG"}, CountryId{"US"}, Tz::America_Anchorage}, // Shungnak Airport
    Airport{IataCode{"SHH"}, CountryId{"US"}, Tz::America_Nome}, // Shishmaref Airport
    Airport{IataCode{"SHI"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Shimojishima Airport
    Airport{IataCode{"SHJ"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Sharjah International Airport
    Airport{IataCode{"SHK"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Sehonghong Airport
    Airport{IataCode{"SHL"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Shillong Airport
    Airport{IataCode{"SHM"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Nanki-Shirahama Airport
    Airport{IataCode{"SHN"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Sanderson Field
    Airport{IataCode{"SHO"}, CountryId{"SZ"}, Tz::Africa_Mbabane}, // Sikhuphe International Airport
    Airport{IataCode{"SHQ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Southport Airport
    Airport{IataCode{"SHR"}, CountryId{"US"}, Tz::America_Denver}, // Sheridan County Airport
    Airport{IataCode{"SHS"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shashi Airport
    Airport{IataCode{"SHT"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Shepparton Airport
    Airport{IataCode{"SHU"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Smith Point Airport
    Airport{IataCode{"SHV"}, CountryId{"US"}, Tz::America_Chicago}, // Shreveport Regional Airport
    Airport{IataCode{"SHW"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Sharurah Domestic Airport
    Airport{IataCode{"SHX"}, CountryId{"US"}, Tz::America_Anchorage}, // Shageluk Airport
    Airport{IataCode{"SHY"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Shinyanga Airport
    Airport{IataCode{"SHZ"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Seshutes Airport
    Airport{IataCode{"SIB"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Sibiti Airport
    Airport{IataCode{"SIC"}, CountryId{"PA"}, Tz::America_Panama}, // San José Airport, Las Perlas
    Airport{IataCode{"SID"}, CountryId{"CV"}, Tz::Atlantic_Cape_Verde}, // Amílcar Cabral International Airport
    Airport{IataCode{"SIF"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Simara Airport
    Airport{IataCode{"SIG"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // Fernando Luis Ribas Dominicci Airport
    Airport{IataCode{"SIH"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Silgadi Doti Airport
    Airport{IataCode{"SIJ"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Siglufjörður Airport
    Airport{IataCode{"SIK"}, CountryId{"US"}, Tz::America_Chicago}, // Sikeston Memorial Municipal Airport
    Airport{IataCode{"SIM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Simbai Airport
    Airport{IataCode{"SIN"}, CountryId{"SG"}, Tz::Asia_Singapore}, // Singapore Changi Airport
    Airport{IataCode{"SIO"}, CountryId{"AU"}, Tz::Australia_Hobart}, // Smithton Airport
    Airport{IataCode{"SIP"}, CountryId{"RU"}, Tz::Europe_Simferopol}, // Simferopol International Airport
    Airport{IataCode{"SIQ"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Dabo Singkep Airport
    Airport{IataCode{"SIR"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Sion Airport
    Airport{IataCode{"SIS"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Sishen Airport
    Airport{IataCode{"SIT"}, CountryId{"US"}, Tz::America_Sitka}, // Sitka Rocky Gutierrez Airport
    Airport{IataCode{"SIU"}, CountryId{"NI"}, Tz::America_Managua}, // Siuna Airport
    Airport{IataCode{"SIV"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Sullivan County Airport
    Airport{IataCode{"SIW"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Sibisa Airport
    Airport{IataCode{"SIX"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Ferdinand Lumban Tobing Airport
    Airport{IataCode{"SIY"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Siskiyou County Airport
    Airport{IataCode{"SIZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Sissano
    Airport{IataCode{"SJB"}, CountryId{"BO"}, Tz::America_La_Paz}, // San Joaquín Airport
    Airport{IataCode{"SJC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // San Jose International Airport
    Airport{IataCode{"SJD"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Los Cabos International Airport
    Airport{IataCode{"SJE"}, CountryId{"CO"}, Tz::America_Bogota}, // Jorge Enrique González Torres Airport
    Airport{IataCode{"SJI"}, CountryId{"PH"}, Tz::Asia_Manila}, // San Jose Airport
    Airport{IataCode{"SJJ"}, CountryId{"BA"}, Tz::Europe_Sarajevo}, // Sarajevo International Airport
    Airport{IataCode{"SJK"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // São José dos Campos Airport
    Airport{IataCode{"SJL"}, CountryId{"BR"}, Tz::America_Manaus}, // São Gabriel da Cachoeira Airport
    Airport{IataCode{"SJM"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // San Juan de la Maguana Airport
    Airport{IataCode{"SJN"}, CountryId{"US"}, Tz::America_Phoenix}, // St. Johns Industrial Air Park
    Airport{IataCode{"SJO"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Juan Santamaría International Airport
    Airport{IataCode{"SJP"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // São José do Rio Preto Airport
    Airport{IataCode{"SJQ"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Sesheke Airport
    Airport{IataCode{"SJS"}, CountryId{"BO"}, Tz::America_La_Paz}, // San José de Chiquitos Airport
    Airport{IataCode{"SJT"}, CountryId{"US"}, Tz::America_Chicago}, // San Angelo Regional Airport
    Airport{IataCode{"SJU"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // Luis Muñoz Marín International Airport
    Airport{IataCode{"SJV"}, CountryId{"BO"}, Tz::America_La_Paz}, // San Javier Airport (Bolivia)
    Airport{IataCode{"SJW"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shijiazhuang Zhengding International Airport
    Airport{IataCode{"SJX"}, CountryId{"BZ"}, Tz::America_Belize}, // Sarteneja Airport
    Airport{IataCode{"SJY"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Seinäjoki Airport
    Airport{IataCode{"SJZ"}, CountryId{"PT"}, Tz::Atlantic_Azores}, // São Jorge Airport
    Airport{IataCode{"SKB"}, CountryId{"KN"}, Tz::America_St_Kitts}, // Robert L. Bradshaw International Airport
    Airport{IataCode{"SKC"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Suki Airport
    Airport{IataCode{"SKD"}, CountryId{"UZ"}, Tz::Asia_Samarkand}, // Samarkand International Airport
    Airport{IataCode{"SKE"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Skien Airport, Geiteryggen
    Airport{IataCode{"SKG"}, CountryId{"GR"}, Tz::Europe_Athens}, // Thessaloniki Airport "Makedonia"
    Airport{IataCode{"SKH"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Surkhet Airport
    Airport{IataCode{"SKI"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Skikda Airport
    Airport{IataCode{"SKK"}, CountryId{"US"}, Tz::America_Anchorage}, // Shaktoolik Airport
    Airport{IataCode{"SKN"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Stokmarknes Airport
    Airport{IataCode{"SKO"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Sadiq Abubakar III International Airport
    Airport{IataCode{"SKP"}, CountryId{"MK"}, Tz::Europe_Skopje}, // Skopje Airport
    Airport{IataCode{"SKQ"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Sekake Airport
    Airport{IataCode{"SKR"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Shakiso Airport
    Airport{IataCode{"SKS"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Vojens Airport
    Airport{IataCode{"SKT"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Sialkot International Airport
    Airport{IataCode{"SKU"}, CountryId{"GR"}, Tz::Europe_Athens}, // Skyros Island National Airport
    Airport{IataCode{"SKV"}, CountryId{"EG"}, Tz::Africa_Cairo}, // St. Catherine International Airport
    Airport{IataCode{"SKW"}, CountryId{"US"}, Tz::America_Anchorage}, // Skwentna Airport
    Airport{IataCode{"SKX"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Saransk Airport
    Airport{IataCode{"SKZ"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Sukkur Airport
    Airport{IataCode{"SLA"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Martín Miguel de Güemes International Airport
    Airport{IataCode{"SLB"}, CountryId{"US"}, Tz::America_Chicago}, // Storm Lake Municipal Airport
    Airport{IataCode{"SLC"}, CountryId{"US"}, Tz::America_Denver}, // Salt Lake City International Airport
    Airport{IataCode{"SLD"}, CountryId{"SK"}, Tz::Europe_Bratislava}, // Sliač Airport
    Airport{IataCode{"SLG"}, CountryId{"US"}, Tz::America_Chicago}, // Smith Field
    Airport{IataCode{"SLH"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Vanua Lava Airport
    Airport{IataCode{"SLI"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Solwezi Airport
    Airport{IataCode{"SLJ"}, CountryId{"AU"}, Tz::Australia_Perth}, // Solomon Airport
    Airport{IataCode{"SLK"}, CountryId{"US"}, Tz::America_New_York}, // Adirondack Regional Airport
    Airport{IataCode{"SLL"}, CountryId{"OM"}, Tz::Asia_Muscat}, // Salalah Airport
    Airport{IataCode{"SLM"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Salamanca Airport
    Airport{IataCode{"SLN"}, CountryId{"US"}, Tz::America_Chicago}, // Salina Regional Airport
    Airport{IataCode{"SLO"}, CountryId{"US"}, Tz::America_Chicago}, // Salem-Leckrone Airport
    Airport{IataCode{"SLP"}, CountryId{"MX"}, Tz::America_Mexico_City}, // San Luis Potosí International Airport
    Airport{IataCode{"SLQ"}, CountryId{"US"}, Tz::America_Anchorage}, // Sleetmute Airport
    Airport{IataCode{"SLR"}, CountryId{"US"}, Tz::America_Chicago}, // Sulphur Springs Municipal Airport
    Airport{IataCode{"SLS"}, CountryId{"BG"}, Tz::Europe_Sofia}, // Silistra Airfield
    Airport{IataCode{"SLT"}, CountryId{"US"}, Tz::America_Denver}, // Harriet Alexander Field
    Airport{IataCode{"SLU"}, CountryId{"LC"}, Tz::America_St_Lucia}, // George F. L. Charles Airport
    Airport{IataCode{"SLV"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Shimla Airport
    Airport{IataCode{"SLW"}, CountryId{"MX"}, Tz::America_Monterrey}, // Plan de Guadalupe International Airport
    Airport{IataCode{"SLX"}, CountryId{"GB"}, Tz::America_Grand_Turk}, // Salt Cay Airport
    Airport{IataCode{"SLY"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Salekhard Airport
    Airport{IataCode{"SLZ"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Marechal Cunha Machado International Airport
    Airport{IataCode{"SMA"}, CountryId{"PT"}, Tz::Atlantic_Azores}, // Santa Maria Airport
    Airport{IataCode{"SMB"}, CountryId{"CL"}, Tz::America_Punta_Arenas}, // Franco Bianco Airport
    Airport{IataCode{"SMC"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Sremska Mitrovica Airport
    Airport{IataCode{"SMD"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Smith Field
    Airport{IataCode{"SME"}, CountryId{"US"}, Tz::America_New_York}, // Lake Cumberland Regional Airport
    Airport{IataCode{"SMF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Sacramento International Airport
    Airport{IataCode{"SMG"}, CountryId{"PE"}, Tz::America_Lima}, // Santa Maria Airport (Peru)
    Airport{IataCode{"SMH"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Sapmanga
    Airport{IataCode{"SMI"}, CountryId{"GR"}, Tz::Europe_Athens}, // Samos International Airport
    Airport{IataCode{"SMJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Sim
    Airport{IataCode{"SMK"}, CountryId{"US"}, Tz::America_Nome}, // St. Michael Airport
    Airport{IataCode{"SML"}, CountryId{"BS"}, Tz::America_Nassau}, // Stella Maris Airport
    Airport{IataCode{"SMM"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Semporna Airport
    Airport{IataCode{"SMN"}, CountryId{"US"}, Tz::America_Boise}, // Lemhi County Airport
    Airport{IataCode{"SMO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Santa Monica Airport
    Airport{IataCode{"SMP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Stockholm Airport
    Airport{IataCode{"SMQ"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Sampit Airport
    Airport{IataCode{"SMR"}, CountryId{"CO"}, Tz::America_Bogota}, // Simón Bolívar International Airport
    Airport{IataCode{"SMS"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Sainte Marie Airport
    Airport{IataCode{"SMV"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Samedan Airport
    Airport{IataCode{"SMW"}, CountryId{"MA"}, Tz::Africa_El_Aaiun}, // Smara Airport
    Airport{IataCode{"SMX"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Santa Maria Public Airport
    Airport{IataCode{"SMZ"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Stoelmans Eiland Airstrip
    Airport{IataCode{"SNA"}, CountryId{"US"}, Tz::America_Los_Angeles}, // John Wayne Airport
    Airport{IataCode{"SNB"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Snake Bay Airport
    Airport{IataCode{"SNC"}, CountryId{"EC"}, Tz::America_Guayaquil}, // General Ulpiano Paez Airport
    Airport{IataCode{"SNE"}, CountryId{"CV"}, Tz::Atlantic_Cape_Verde}, // Preguiça Airport
    Airport{IataCode{"SNF"}, CountryId{"VE"}, Tz::America_Caracas}, // Sub Teniente Nestor Arias Airport
    Airport{IataCode{"SNG"}, CountryId{"BO"}, Tz::America_La_Paz}, // Cap. Av. Juan Cochamanidis San Airport
    Airport{IataCode{"SNH"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Stanthorpe Airport
    Airport{IataCode{"SNI"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Greenville/Sinoe Airport
    Airport{IataCode{"SNK"}, CountryId{"US"}, Tz::America_Chicago}, // Winston Field Airport
    Airport{IataCode{"SNL"}, CountryId{"US"}, Tz::America_Chicago}, // Shawnee Regional Airport
    Airport{IataCode{"SNM"}, CountryId{"BO"}, Tz::America_La_Paz}, // San Ignacio de Moxos Airport
    Airport{IataCode{"SNN"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Shannon Airport
    Airport{IataCode{"SNO"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Sakon Nakhon Airport
    Airport{IataCode{"SNP"}, CountryId{"US"}, Tz::America_Nome}, // St. Paul Island Airport
    Airport{IataCode{"SNR"}, CountryId{"FR"}, Tz::Europe_Paris}, // Saint-Nazaire - Montoir Airport
    Airport{IataCode{"SNS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Salinas Municipal Airport
    Airport{IataCode{"SNU"}, CountryId{"CU"}, Tz::America_Havana}, // Abel Santamaría Airport
    Airport{IataCode{"SNV"}, CountryId{"VE"}, Tz::America_Caracas}, // Santa Elena de Uairén Airport
    Airport{IataCode{"SNW"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Thandwe Airport
    Airport{IataCode{"SNX"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Semnan Airport
    Airport{IataCode{"SNY"}, CountryId{"US"}, Tz::America_Denver}, // Sidney Municipal Airport
    Airport{IataCode{"SOB"}, CountryId{"HU"}, Tz::Europe_Budapest}, // Hévíz–Balaton Airport
    Airport{IataCode{"SOC"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Adisumarmo International Airport
    Airport{IataCode{"SOD"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Sorocaba Airport
    Airport{IataCode{"SOE"}, CountryId{"CG"}, Tz::Africa_Brazzaville}, // Souanké Airport
    Airport{IataCode{"SOF"}, CountryId{"BG"}, Tz::Europe_Sofia}, // Sofia Airport
    Airport{IataCode{"SOG"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Sogndal Airport, Haukåsen
    Airport{IataCode{"SOJ"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Sørkjosen Airport
    Airport{IataCode{"SOK"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Semonkong Airport
    Airport{IataCode{"SOM"}, CountryId{"VE"}, Tz::America_Caracas}, // San Tomé Airport
    Airport{IataCode{"SON"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Santo-Pekoa International Airport
    Airport{IataCode{"SOO"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Söderhamn Airport
    Airport{IataCode{"SOP"}, CountryId{"US"}, Tz::America_New_York}, // Moore County Airport
    Airport{IataCode{"SOQ"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Sorong Airport
    Airport{IataCode{"SOU"}, CountryId{"GB"}, Tz::Europe_London}, // Southampton Airport
    Airport{IataCode{"SOV"}, CountryId{"US"}, Tz::America_Anchorage}, // Seldovia Airport
    Airport{IataCode{"SOW"}, CountryId{"US"}, Tz::America_Phoenix}, // Show Low Regional Airport
    Airport{IataCode{"SOX"}, CountryId{"CO"}, Tz::America_Bogota}, // Alberto Lleras Camargo Airport
    Airport{IataCode{"SPA"}, CountryId{"US"}, Tz::America_New_York}, // Spartanburg Downtown Memorial Airport
    Airport{IataCode{"SPC"}, CountryId{"ES"}, Tz::Atlantic_Canary}, // La Palma Airport
    Airport{IataCode{"SPD"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Saidpur Airport
    Airport{IataCode{"SPE"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Sepulot Airport
    Airport{IataCode{"SPF"}, CountryId{"US"}, Tz::America_Denver}, // Black Hills Airport
    Airport{IataCode{"SPG"}, CountryId{"US"}, Tz::America_New_York}, // Albert Whitted Airport
    Airport{IataCode{"SPH"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Sopu
    Airport{IataCode{"SPI"}, CountryId{"US"}, Tz::America_Chicago}, // Abraham Lincoln Capital Airport
    Airport{IataCode{"SPJ"}, CountryId{"GR"}, Tz::Europe_Athens}, // Sparti Airport
    Airport{IataCode{"SPK"}, CountryId{"US"}, Tz::America_Denver}, // Spanish Fork-Springville Airport
    Airport{IataCode{"SPL"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Smederevska Palanka Airport
    Airport{IataCode{"SPN"}, CountryId{"US"}, Tz::Pacific_Saipan}, // Saipan International Airport
    Airport{IataCode{"SPP"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Menongue Airport
    Airport{IataCode{"SPR"}, CountryId{"BZ"}, Tz::America_Belize}, // John Greif II Airport
    Airport{IataCode{"SPS"}, CountryId{"US"}, Tz::America_Chicago}, // Wichita Falls Municipal Airport
    Airport{IataCode{"SPT"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Sipitang Airport
    Airport{IataCode{"SPU"}, CountryId{"HR"}, Tz::Europe_Zagreb}, // Split Airport
    Airport{IataCode{"SPV"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Sepik Plains
    Airport{IataCode{"SPW"}, CountryId{"US"}, Tz::America_Chicago}, // Spencer Municipal Airport
    Airport{IataCode{"SPX"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Sphinx International Airport
    Airport{IataCode{"SPY"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // San Pédro Airport
    Airport{IataCode{"SPZ"}, CountryId{"US"}, Tz::America_Chicago}, // Springdale Municipal Airport
    Airport{IataCode{"SQA"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Santa Ynez Airport
    Airport{IataCode{"SQC"}, CountryId{"AU"}, Tz::Australia_Perth}, // Southern Cross Airport
    Airport{IataCode{"SQD"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shangrao Sanqingshan Airport
    Airport{IataCode{"SQG"}, CountryId{"ID"}, Tz::Asia_Pontianak}, // Tebelian Airport
    Airport{IataCode{"SQH"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Nà Sản Airport
    Airport{IataCode{"SQJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Sanming Shaxian Airport
    Airport{IataCode{"SQL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // San Carlos Airport
    Airport{IataCode{"SQO"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Storuman Airport
    Airport{IataCode{"SQQ"}, CountryId{"LT"}, Tz::Europe_Vilnius}, // Šiauliai International Airport
    Airport{IataCode{"SQR"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Soroako Airport
    Airport{IataCode{"SQS"}, CountryId{"BZ"}, Tz::America_Belize}, // Matthew Spain Airport
    Airport{IataCode{"SQT"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // China Straits
    Airport{IataCode{"SQV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Sequim Valley Airport
    Airport{IataCode{"SQW"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Skive Airport
    Airport{IataCode{"SQX"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Sao Miguel Do Oeste Airport
    Airport{IataCode{"SQY"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // São Lourenço do Sul Airport
    Airport{IataCode{"SRA"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Santa Rosa Airport
    Airport{IataCode{"SRB"}, CountryId{"BO"}, Tz::America_La_Paz}, // Santa Rosa Airport
    Airport{IataCode{"SRC"}, CountryId{"US"}, Tz::America_Chicago}, // Searcy Municipal Airport
    Airport{IataCode{"SRD"}, CountryId{"BO"}, Tz::America_La_Paz}, // San Ramón Airport
    Airport{IataCode{"SRE"}, CountryId{"BO"}, Tz::America_La_Paz}, // Alcantari Airport
    Airport{IataCode{"SRG"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Achmad Yani International Airport
    Airport{IataCode{"SRJ"}, CountryId{"BO"}, Tz::America_La_Paz}, // Capitán Germán Quiroga Guardia Airport
    Airport{IataCode{"SRL"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Palo Verde Airport
    Airport{IataCode{"SRN"}, CountryId{"AU"}, Tz::Australia_Hobart}, // Strahan Airport
    Airport{IataCode{"SRP"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Stord Airport
    Airport{IataCode{"SRT"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Soroti Airport
    Airport{IataCode{"SRV"}, CountryId{"US"}, Tz::America_Anchorage}, // Stony River Airport
    Airport{IataCode{"SRW"}, CountryId{"US"}, Tz::America_New_York}, // Mid-Carolina Regional Airport
    Airport{IataCode{"SRY"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Dasht-e Naz Airport
    Airport{IataCode{"SRZ"}, CountryId{"BO"}, Tz::America_La_Paz}, // El Trompillo Airport
    Airport{IataCode{"SSA"}, CountryId{"BR"}, Tz::America_Bahia}, // Deputado Luís Eduardo Magalhães International Airport
    Airport{IataCode{"SSB"}, CountryId{"US"}, Tz::America_St_Thomas}, // Christiansted Harbor Seaplane Base
    Airport{IataCode{"SSD"}, CountryId{"CL"}, Tz::America_Santiago}, // Víctor Lafón Airport
    Airport{IataCode{"SSE"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Solapur Airport
    Airport{IataCode{"SSF"}, CountryId{"US"}, Tz::America_Chicago}, // Stinson Municipal Airport
    Airport{IataCode{"SSG"}, CountryId{"GQ"}, Tz::Africa_Malabo}, // Malabo International Airport
    Airport{IataCode{"SSH"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Sharm el-Sheikh International Airport
    Airport{IataCode{"SSI"}, CountryId{"US"}, Tz::America_New_York}, // Malcolm McKinnon Airport
    Airport{IataCode{"SSJ"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Sandnessjøen Airport
    Airport{IataCode{"SSL"}, CountryId{"CO"}, Tz::America_Bogota}, // Santa Rosalía Airport
    Airport{IataCode{"SSM"}, CountryId{"US"}, Tz::America_Detroit}, // Sault Ste. Marie Municipal Airport
    Airport{IataCode{"SSO"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // São Lourenço Airport
    Airport{IataCode{"SSQ"}, CountryId{"CA"}, Tz::America_Toronto}, // La Sarre Airport
    Airport{IataCode{"SSR"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Sara Airport
    Airport{IataCode{"SSS"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Siassi
    Airport{IataCode{"SST"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Santa Teresita Airport
    Airport{IataCode{"SSY"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Mbanza Congo Airport
    Airport{IataCode{"STA"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Stauning Vestjylland Airport
    Airport{IataCode{"STB"}, CountryId{"VE"}, Tz::America_Caracas}, // Miguel Urdaneta Fernández Airport
    Airport{IataCode{"STC"}, CountryId{"US"}, Tz::America_Chicago}, // St. Cloud Regional Airport
    Airport{IataCode{"STD"}, CountryId{"VE"}, Tz::America_Caracas}, // Mayor Buenaventura Vivas Airport
    Airport{IataCode{"STE"}, CountryId{"US"}, Tz::America_Chicago}, // Stevens Point Municipal Airport
    Airport{IataCode{"STF"}, CountryId{"US"}, Tz::America_Chicago}, // George M. Bryan Airport
    Airport{IataCode{"STG"}, CountryId{"US"}, Tz::America_Nome}, // St. George Airport
    Airport{IataCode{"STH"}, CountryId{"CA"}, Tz::America_Edmonton}, // Strathmore (D.J. Murray) Airport
    Airport{IataCode{"STI"}, CountryId{"DO"}, Tz::America_Santo_Domingo}, // Cibao International Airport
    Airport{IataCode{"STJ"}, CountryId{"US"}, Tz::America_Chicago}, // Rosecrans Memorial Airport
    Airport{IataCode{"STM"}, CountryId{"BR"}, Tz::America_Santarem}, // Santarém-Maestro Wilson Fonseca Airport
    Airport{IataCode{"STN"}, CountryId{"GB"}, Tz::Europe_London}, // London Stansted Airport
    Airport{IataCode{"STP"}, CountryId{"US"}, Tz::America_Chicago}, // St. Paul Downtown Airport
    Airport{IataCode{"STQ"}, CountryId{"US"}, Tz::America_New_York}, // St. Marys Municipal Airport
    Airport{IataCode{"STR"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Stuttgart Airport
    Airport{IataCode{"STT"}, CountryId{"US"}, Tz::America_St_Thomas}, // Cyril E. King Airport
    Airport{IataCode{"STV"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Surat Airport
    Airport{IataCode{"STW"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Stavropol Shpakovskoye Airport
    Airport{IataCode{"STX"}, CountryId{"US"}, Tz::America_St_Thomas}, // Henry E. Rohlsen Airport
    Airport{IataCode{"STY"}, CountryId{"UY"}, Tz::America_Montevideo}, // Nueva Hespérides International Airport
    Airport{IataCode{"STZ"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Santa Terezinha Airport
    Airport{IataCode{"SUA"}, CountryId{"US"}, Tz::America_New_York}, // Witham Field
    Airport{IataCode{"SUB"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Juanda International Airport
    Airport{IataCode{"SUD"}, CountryId{"US"}, Tz::America_Chicago}, // Stroud Municipal Airport
    Airport{IataCode{"SUE"}, CountryId{"US"}, Tz::America_Chicago}, // Door County Cherryland Airport
    Airport{IataCode{"SUF"}, CountryId{"IT"}, Tz::Europe_Rome}, // Lamezia Terme International Airport
    Airport{IataCode{"SUG"}, CountryId{"PH"}, Tz::Asia_Manila}, // Surigao Airport
    Airport{IataCode{"SUI"}, CountryId{}, Tz::Asia_Tbilisi}, // Sukhumi Babushara Airport
    Airport{IataCode{"SUJ"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Satu Mare International Airport
    Airport{IataCode{"SUK"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Sakkyryr Airport
    Airport{IataCode{"SUL"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Sui Airport
    Airport{IataCode{"SUM"}, CountryId{"US"}, Tz::America_New_York}, // Sumter Airport
    Airport{IataCode{"SUN"}, CountryId{"US"}, Tz::America_Boise}, // Friedman Memorial Airport
    Airport{IataCode{"SUO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Sunriver Airport
    Airport{IataCode{"SUP"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Trunojoyo Airport
    Airport{IataCode{"SUQ"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Sucua Airport
    Airport{IataCode{"SUR"}, CountryId{"CA"}, Tz::America_Toronto}, // Summer Beaver Airport
    Airport{IataCode{"SUS"}, CountryId{"US"}, Tz::America_Chicago}, // Spirit of St. Louis Airport
    Airport{IataCode{"SUT"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Sumbawanga Airport
    Airport{IataCode{"SUV"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Nausori International Airport
    Airport{IataCode{"SUW"}, CountryId{"US"}, Tz::America_Chicago}, // Richard I. Bong Airport
    Airport{IataCode{"SUX"}, CountryId{"US"}, Tz::America_Chicago}, // Sioux Gateway Airport
    Airport{IataCode{"SUY"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Suntar Airport
    Airport{IataCode{"SUZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Suria aerodrome
    Airport{IataCode{"SVA"}, CountryId{"US"}, Tz::America_Nome}, // Savoonga Airport
    Airport{IataCode{"SVB"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Sambava Airport
    Airport{IataCode{"SVC"}, CountryId{"US"}, Tz::America_Denver}, // Grant County Airport
    Airport{IataCode{"SVD"}, CountryId{"VC"}, Tz::America_St_Vincent}, // Argyle International Airport
    Airport{IataCode{"SVE"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Susanville Municipal Airport
    Airport{IataCode{"SVF"}, CountryId{"BJ"}, Tz::Africa_Porto_Novo}, // Savé Airport
    Airport{IataCode{"SVG"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Stavanger Airport
    Airport{IataCode{"SVI"}, CountryId{"CO"}, Tz::America_Bogota}, // Eduardo Falla Solano Airport
    Airport{IataCode{"SVJ"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Svolvær Airport
    Airport{IataCode{"SVK"}, CountryId{"BZ"}, Tz::America_Belize}, // Silver Creek Airport
    Airport{IataCode{"SVL"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Savonlinna Airport
    Airport{IataCode{"SVM"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // St Pauls
    Airport{IataCode{"SVO"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Sheremetyevo International Airport
    Airport{IataCode{"SVP"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Joaquim Kapango Airport
    Airport{IataCode{"SVQ"}, CountryId{"ES"}, Tz::Europe_Madrid}, // San Pablo Airport
    Airport{IataCode{"SVS"}, CountryId{"US"}, Tz::America_Anchorage}, // Stevens Village Airport
    Airport{IataCode{"SVT"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Savuti Airport
    Airport{IataCode{"SVU"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Savusavu Airport
    Airport{IataCode{"SVW"}, CountryId{"US"}, Tz::America_Anchorage}, // Sparrevohn LRRS Airport
    Airport{IataCode{"SVX"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Koltsovo Airport
    Airport{IataCode{"SVZ"}, CountryId{"VE"}, Tz::America_Caracas}, // Juan Vicente Gómez International Airport
    Airport{IataCode{"SWA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jieyang Chaoshan Airport
    Airport{IataCode{"SWC"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Stawell Airport
    Airport{IataCode{"SWD"}, CountryId{"US"}, Tz::America_Anchorage}, // Seward Airport
    Airport{IataCode{"SWE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Samberigi Airport
    Airport{IataCode{"SWF"}, CountryId{"US"}, Tz::America_New_York}, // New York Stewart International Airport
    Airport{IataCode{"SWH"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Swan Hill Airport
    Airport{IataCode{"SWI"}, CountryId{"US"}, Tz::America_Chicago}, // Sherman Municipal Airport
    Airport{IataCode{"SWJ"}, CountryId{"VU"}, Tz::Pacific_Efate}, // South West Bay Airport
    Airport{IataCode{"SWO"}, CountryId{"US"}, Tz::America_Chicago}, // Stillwater Regional Airport
    Airport{IataCode{"SWP"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Swakopmund Airport
    Airport{IataCode{"SWQ"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Brangbiji Airport
    Airport{IataCode{"SWR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Silur
    Airport{IataCode{"SWS"}, CountryId{"GB"}, Tz::Europe_London}, // Swansea Airport
    Airport{IataCode{"SWT"}, CountryId{"RU"}, Tz::Asia_Tomsk}, // Strezhevoy Airport
    Airport{IataCode{"SWV"}, CountryId{"RU"}, Tz::Asia_Magadan}, // Severo-Evensk Airport
    Airport{IataCode{"SWW"}, CountryId{"US"}, Tz::America_Chicago}, // Avenger Field
    Airport{IataCode{"SWX"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Shakawe Airport
    Airport{IataCode{"SWY"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Sitiawan Airport
    Airport{IataCode{"SXB"}, CountryId{"FR"}, Tz::Europe_Paris}, // Strasbourg Airport
    Airport{IataCode{"SXE"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // West Sale Airport
    Airport{IataCode{"SXF"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Berlin Schönefeld Airport
    Airport{IataCode{"SXG"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Senanga Airport
    Airport{IataCode{"SXI"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Sirri Island Airport
    Airport{IataCode{"SXJ"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Shanshan Airport
    Airport{IataCode{"SXK"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Mathilda Batyaleri Airport
    Airport{IataCode{"SXL"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Sligo Airport
    Airport{IataCode{"SXM"}, CountryId{"NL"}, Tz::America_Lower_Princes}, // Princess Juliana International Airport
    Airport{IataCode{"SXN"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Sua Pan Airport
    Airport{IataCode{"SXO"}, CountryId{"BR"}, Tz::America_Cuiaba}, // São Félix do Araguaia Airport
    Airport{IataCode{"SXP"}, CountryId{"US"}, Tz::America_Nome}, // Sheldon Point Airport
    Airport{IataCode{"SXQ"}, CountryId{"US"}, Tz::America_Anchorage}, // Soldotna Airport
    Airport{IataCode{"SXR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Srinagar Airport
    Airport{IataCode{"SXS"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Sahabat Sahabat 16 Airport
    Airport{IataCode{"SXU"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Soddo Airport
    Airport{IataCode{"SXV"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Salem Airport
    Airport{IataCode{"SXX"}, CountryId{"BR"}, Tz::America_Belem}, // São Félix do Xingu Airport
    Airport{IataCode{"SXY"}, CountryId{"US"}, Tz::America_New_York}, // Sidney Municipal Airport (New York)
    Airport{IataCode{"SXZ"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Siirt Airport
    Airport{IataCode{"SYB"}, CountryId{"US"}, Tz::America_Anchorage}, // Seal Bay Seaplane Base
    Airport{IataCode{"SYD"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Sydney Airport
    Airport{IataCode{"SYE"}, CountryId{"YE"}, Tz::Asia_Aden}, // Saadah Airport
    Airport{IataCode{"SYH"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Syangboche Airport
    Airport{IataCode{"SYI"}, CountryId{"US"}, Tz::America_Chicago}, // Shelbyville Municipal Airport
    Airport{IataCode{"SYJ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Sirjan Airport
    Airport{IataCode{"SYK"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Stykkishólmur Airport
    Airport{IataCode{"SYM"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Pu'er Simao Airport
    Airport{IataCode{"SYN"}, CountryId{"US"}, Tz::America_Chicago}, // Stanton Airfield
    Airport{IataCode{"SYO"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Shonai Airport
    Airport{IataCode{"SYP"}, CountryId{"PA"}, Tz::America_Panama}, // Ruben Cantu Airport
    Airport{IataCode{"SYQ"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Tobías Bolaños International Airport
    Airport{IataCode{"SYR"}, CountryId{"US"}, Tz::America_New_York}, // Syracuse Hancock International Airport
    Airport{IataCode{"SYS"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Saskylakh Airport
    Airport{IataCode{"SYT"}, CountryId{"FR"}, Tz::Europe_Paris}, // Saint-Yan Airport
    Airport{IataCode{"SYU"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Warraber Island Airport
    Airport{IataCode{"SYW"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Sehwan Sharif Airport
    Airport{IataCode{"SYX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Sanya Phoenix International Airport
    Airport{IataCode{"SYY"}, CountryId{"GB"}, Tz::Europe_London}, // Stornoway Airport
    Airport{IataCode{"SYZ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Shiraz International Airport, Iran
    Airport{IataCode{"SZA"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Soyo Airport
    Airport{IataCode{"SZB"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Sultan Abdul Aziz Shah Airport
    Airport{IataCode{"SZE"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Semera Airport
    Airport{IataCode{"SZF"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Samsun-Çarşamba Airport
    Airport{IataCode{"SZG"}, CountryId{"AT"}, Tz::Europe_Vienna}, // Salzburg Airport
    Airport{IataCode{"SZJ"}, CountryId{"CU"}, Tz::America_Havana}, // Siguanea Airport
    Airport{IataCode{"SZK"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Skukuza Airport
    Airport{IataCode{"SZP"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Santa Paula Airport
    Airport{IataCode{"SZR"}, CountryId{"BG"}, Tz::Europe_Sofia}, // Stara Zagora Airport
    Airport{IataCode{"SZW"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Parchim International Airport
    Airport{IataCode{"SZX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shenzhen Bao'an International Airport
    Airport{IataCode{"SZY"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Szczytno-Szymany International Airport
    Airport{IataCode{"SZZ"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // "Solidarity" Szczecin-Goleniów Airport
    Airport{IataCode{"TAB"}, CountryId{"TT"}, Tz::America_Port_of_Spain}, // Arthur Napoleon Raymond Robinson International Airport
    Airport{IataCode{"TAC"}, CountryId{"PH"}, Tz::Asia_Manila}, // Daniel Z. Romualdez Airport
    Airport{IataCode{"TAD"}, CountryId{"US"}, Tz::America_Denver}, // Perry Stokes Airport
    Airport{IataCode{"TAE"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Daegu International Airport
    Airport{IataCode{"TAF"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Oran Tafraoui Airport
    Airport{IataCode{"TAG"}, CountryId{"PH"}, Tz::Asia_Manila}, // Bohol–Panglao International Airport
    Airport{IataCode{"TAH"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Whitegrass Airport
    Airport{IataCode{"TAI"}, CountryId{"YE"}, Tz::Asia_Aden}, // Ta'izz International Airport
    Airport{IataCode{"TAJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tadji Airport
    Airport{IataCode{"TAK"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Takamatsu Airport
    Airport{IataCode{"TAL"}, CountryId{"US"}, Tz::America_Anchorage}, // Ralph M. Calhoun Memorial Airport
    Airport{IataCode{"TAM"}, CountryId{"MX"}, Tz::America_Monterrey}, // General Francisco Javier Mina International Airport
    Airport{IataCode{"TAN"}, CountryId{"US"}, Tz::America_New_York}, // Taunton Municipal Airport
    Airport{IataCode{"TAO"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Qingdao Liuting International Airport
    Airport{IataCode{"TAP"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Tapachula International Airport
    Airport{IataCode{"TAR"}, CountryId{"IT"}, Tz::Europe_Rome}, // Taranto-Grottaglie Airport
    Airport{IataCode{"TAS"}, CountryId{"UZ"}, Tz::Asia_Tashkent}, // Tashkent International Airport
    Airport{IataCode{"TAT"}, CountryId{"SK"}, Tz::Europe_Bratislava}, // Poprad-Tatry Airport
    Airport{IataCode{"TAW"}, CountryId{"UY"}, Tz::America_Montevideo}, // Tacuarembó Airport
    Airport{IataCode{"TAY"}, CountryId{"EE"}, Tz::Europe_Tallinn}, // Tartu Airport
    Airport{IataCode{"TAZ"}, CountryId{"TM"}, Tz::Asia_Ashgabat}, // Daşoguz Airport
    Airport{IataCode{"TBA"}, CountryId{"LK"}, Tz::Asia_Colombo}, // SLAF Iranamadu
    Airport{IataCode{"TBB"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Tuy Hoa Airport
    Airport{IataCode{"TBC"}, CountryId{"US"}, Tz::America_Denver}, // Tuba City Airport
    Airport{IataCode{"TBD"}, CountryId{"CO"}, Tz::America_Bogota}, // Timbiqui
    Airport{IataCode{"TBF"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Tabiteuea Nord Aerodrome
    Airport{IataCode{"TBG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tabubil Airport
    Airport{IataCode{"TBH"}, CountryId{"PH"}, Tz::Asia_Manila}, // Tugdan Airport
    Airport{IataCode{"TBI"}, CountryId{"BS"}, Tz::America_Nassau}, // New Bight Airport
    Airport{IataCode{"TBJ"}, CountryId{"TN"}, Tz::Africa_Tunis}, // Tabarka-Ain Draham International Airport
    Airport{IataCode{"TBN"}, CountryId{"US"}, Tz::America_Chicago}, // Waynesville-St. Robert Regional Airport
    Airport{IataCode{"TBO"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Tabora Airport
    Airport{IataCode{"TBP"}, CountryId{"PE"}, Tz::America_Lima}, // Cap. FAP Pedro Canga Rodríguez Airport
    Airport{IataCode{"TBR"}, CountryId{"US"}, Tz::America_New_York}, // Statesboro-Bulloch County Airport
    Airport{IataCode{"TBS"}, CountryId{"GE"}, Tz::Asia_Tbilisi}, // Tbilisi International Airport
    Airport{IataCode{"TBT"}, CountryId{"BR"}, Tz::America_Eirunepe}, // Tabatinga International Airport
    Airport{IataCode{"TBU"}, CountryId{"TO"}, Tz::Pacific_Tongatapu}, // Fuaʻamotu International Airport
    Airport{IataCode{"TBW"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Tambov Donskoye Airport
    Airport{IataCode{"TBY"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Tshabong Airport
    Airport{IataCode{"TBZ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Tabriz International Airport
    Airport{IataCode{"TCA"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Tennant Creek Airport
    Airport{IataCode{"TCB"}, CountryId{"BS"}, Tz::America_Nassau}, // Treasure Cay Airport
    Airport{IataCode{"TCC"}, CountryId{"US"}, Tz::America_Denver}, // Tucumcari Municipal Airport
    Airport{IataCode{"TCD"}, CountryId{"CO"}, Tz::America_Bogota}, // Tarapacá Airport
    Airport{IataCode{"TCE"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Tulcea Airport
    Airport{IataCode{"TCG"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Tacheng Airport
    Airport{IataCode{"TCH"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Tchibanga Airport
    Airport{IataCode{"TCL"}, CountryId{"US"}, Tz::America_Chicago}, // Tuscaloosa National Airport
    Airport{IataCode{"TCN"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Tehuacán Airport
    Airport{IataCode{"TCO"}, CountryId{"CO"}, Tz::America_Bogota}, // La Florida Airport
    Airport{IataCode{"TCP"}, CountryId{"EG"}, Tz::Africa_Cairo}, // Taba International Airport
    Airport{IataCode{"TCQ"}, CountryId{"PE"}, Tz::America_Lima}, // Crnl. FAP Carlos Ciriani Santa Rosa International Airport
    Airport{IataCode{"TCR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Tuticorin Airport
    Airport{IataCode{"TCS"}, CountryId{"US"}, Tz::America_Denver}, // Truth or Consequences Municipal Airport
    Airport{IataCode{"TCT"}, CountryId{"US"}, Tz::America_Anchorage}, // Takotna Airport
    Airport{IataCode{"TCW"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Tocumwal Airport
    Airport{IataCode{"TCX"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Tabas Airport
    Airport{IataCode{"TCY"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Tracy Municipal Airport
    Airport{IataCode{"TCZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Tengchong Tuofeng Airport
    Airport{IataCode{"TDA"}, CountryId{"CO"}, Tz::America_Bogota}, // Trinidad Airport
    Airport{IataCode{"TDB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tetabedi
    Airport{IataCode{"TDD"}, CountryId{"BO"}, Tz::America_La_Paz}, // Teniente Jorge Henrich Arauz Airport
    Airport{IataCode{"TDF"}, CountryId{"US"}, Tz::America_New_York}, // Person County Airport
    Airport{IataCode{"TDG"}, CountryId{"PH"}, Tz::Asia_Manila}, // Tandag Airport
    Airport{IataCode{"TDJ"}, CountryId{"DJ"}, Tz::Africa_Djibouti}, // Tadjoura Airport
    Airport{IataCode{"TDL"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Tandil Airport
    Airport{IataCode{"TDO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // South Lewis County Airport
    Airport{IataCode{"TDS"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Sasereme Airport
    Airport{IataCode{"TDW"}, CountryId{"US"}, Tz::America_Chicago}, // Tradewind Airport
    Airport{IataCode{"TDX"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Trat Airport
    Airport{IataCode{"TDZ"}, CountryId{"US"}, Tz::America_New_York}, // Toledo Executive Airport
    Airport{IataCode{"TEA"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Tela Airport
    Airport{IataCode{"TEB"}, CountryId{"US"}, Tz::America_New_York}, // Teterboro Airport
    Airport{IataCode{"TEC"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Telêmaco Borba Airport
    Airport{IataCode{"TED"}, CountryId{"DK"}, Tz::Europe_Copenhagen}, // Thisted Airport
    Airport{IataCode{"TEE"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Cheikh Larbi Tébessi Airport
    Airport{IataCode{"TEF"}, CountryId{"AU"}, Tz::Australia_Perth}, // Telfer Airport
    Airport{IataCode{"TEG"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Tenkodogo Airport
    Airport{IataCode{"TEI"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Tezu Airport
    Airport{IataCode{"TEK"}, CountryId{"US"}, Tz::America_Anchorage}, // Tatitlek Airport
    Airport{IataCode{"TEL"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Telupid Airport
    Airport{IataCode{"TEM"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Temora Airport
    Airport{IataCode{"TEN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Tongren Fenghuang Airport
    Airport{IataCode{"TEO"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Terapo
    Airport{IataCode{"TER"}, CountryId{"PT"}, Tz::Atlantic_Azores}, // Lajes Airport
    Airport{IataCode{"TET"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Chingozi Airport
    Airport{IataCode{"TEU"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Manapouri Aerodrome
    Airport{IataCode{"TEV"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Teruel Airport
    Airport{IataCode{"TEX"}, CountryId{"US"}, Tz::America_Denver}, // Telluride Regional Airport
    Airport{IataCode{"TEZ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Tezpur Airport
    Airport{IataCode{"TFB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tifalmin Airport
    Airport{IataCode{"TFF"}, CountryId{"BR"}, Tz::America_Manaus}, // Tefé Airport
    Airport{IataCode{"TFI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tufi Airport
    Airport{IataCode{"TFM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Telefomin Airport
    Airport{IataCode{"TFN"}, CountryId{"ES"}, Tz::Atlantic_Canary}, // Tenerife North Airport
    Airport{IataCode{"TFS"}, CountryId{"ES"}, Tz::Atlantic_Canary}, // Tenerife South Airport
    Airport{IataCode{"TFU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Chengdu Tianfu International Airport
    Airport{IataCode{"TGC"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Tanjung Manis Airport
    Airport{IataCode{"TGD"}, CountryId{"ME"}, Tz::Europe_Podgorica}, // Podgorica Airport
    Airport{IataCode{"TGG"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Sultan Mahmud Airport
    Airport{IataCode{"TGH"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Tongoa Airport
    Airport{IataCode{"TGI"}, CountryId{"PE"}, Tz::America_Lima}, // Tingo María Airport
    Airport{IataCode{"TGJ"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Tiga Airport
    Airport{IataCode{"TGL"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tagula
    Airport{IataCode{"TGM"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Târgu Mureș International Airport
    Airport{IataCode{"TGN"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Latrobe Valley Airport
    Airport{IataCode{"TGO"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Tongliao Airport
    Airport{IataCode{"TGP"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Podkamennaya Tunguska Airport
    Airport{IataCode{"TGR"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Sidi Mahdi Airport
    Airport{IataCode{"TGS"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Chókwè airport
    Airport{IataCode{"TGT"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Tanga Airport
    Airport{IataCode{"TGU"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Toncontín International Airport
    Airport{IataCode{"TGV"}, CountryId{"BG"}, Tz::Europe_Sofia}, // Targovishte Airport
    Airport{IataCode{"TGZ"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Ángel Albino Corzo International Airport
    Airport{IataCode{"THA"}, CountryId{"US"}, Tz::America_Chicago}, // Tullahoma Regional Airport
    Airport{IataCode{"THB"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Thaba Tseka Airport
    Airport{IataCode{"THC"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Tchien Airport
    Airport{IataCode{"THD"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Tho Xuan Airport
    Airport{IataCode{"THE"}, CountryId{"BR"}, Tz::America_Fortaleza}, // Teresina Airport
    Airport{IataCode{"THG"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Thangool Airport
    Airport{IataCode{"THH"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Taharoa Aerodrome
    Airport{IataCode{"THI"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Tichitt Airport
    Airport{IataCode{"THK"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Thakhek
    Airport{IataCode{"THL"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Tachilek Airport
    Airport{IataCode{"THM"}, CountryId{"US"}, Tz::America_Denver}, // Thompson Falls Airport
    Airport{IataCode{"THN"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Trollhättan-Vänersborg Airport
    Airport{IataCode{"THO"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Þórshöfn Airport
    Airport{IataCode{"THQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Tianshui Maijishan Airport
    Airport{IataCode{"THR"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Mehrabad International Airport
    Airport{IataCode{"THS"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Sukhothai Airport
    Airport{IataCode{"THT"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Tamchakett Airport
    Airport{IataCode{"THV"}, CountryId{"US"}, Tz::America_New_York}, // York Airport (Pennsylvania)
    Airport{IataCode{"THX"}, CountryId{"RU"}, Tz::Asia_Krasnoyarsk}, // Turukhansk Airport
    Airport{IataCode{"THZ"}, CountryId{"NE"}, Tz::Africa_Niamey}, // Tahoua Airport
    Airport{IataCode{"TIA"}, CountryId{"AL"}, Tz::Europe_Tirane}, // Tirana International Airport Nënë Tereza
    Airport{IataCode{"TIB"}, CountryId{"CO"}, Tz::America_Bogota}, // Tibu Airport
    Airport{IataCode{"TIC"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Tinak Airport
    Airport{IataCode{"TID"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Tiaret - Abdelhafid Boussouf Bou Chekif Airport
    Airport{IataCode{"TIE"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Tippi Airport
    Airport{IataCode{"TIF"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Ta’if Regional Airport
    Airport{IataCode{"TIG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tingwon
    Airport{IataCode{"TIH"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Tikehau Airport
    Airport{IataCode{"TII"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Tarin Kowt Airport
    Airport{IataCode{"TIJ"}, CountryId{"MX"}, Tz::America_Tijuana}, // Tijuana International Airport
    Airport{IataCode{"TIL"}, CountryId{"CA"}, Tz::America_Edmonton}, // Cheadle Airport
    Airport{IataCode{"TIM"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Timika Airport
    Airport{IataCode{"TIN"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Tindouf Airport
    Airport{IataCode{"TIP"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Tripoli International Airport
    Airport{IataCode{"TIQ"}, CountryId{"US"}, Tz::Pacific_Saipan}, // Tinian International Airport
    Airport{IataCode{"TIR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Tirupati Airport
    Airport{IataCode{"TIU"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Richard Pearse Airport
    Airport{IataCode{"TIV"}, CountryId{"ME"}, Tz::Europe_Podgorica}, // Tivat Airport
    Airport{IataCode{"TIW"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Tacoma Narrows Airport
    Airport{IataCode{"TIX"}, CountryId{"US"}, Tz::America_New_York}, // Space Coast Regional Airport
    Airport{IataCode{"TIY"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Tidjikja Airport
    Airport{IataCode{"TIZ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tari Airport
    Airport{IataCode{"TJA"}, CountryId{"BO"}, Tz::America_La_Paz}, // Capitán Oriel Lea Plaza Airport
    Airport{IataCode{"TJB"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Sei Bati Airport
    Airport{IataCode{"TJG"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Warukin Airport
    Airport{IataCode{"TJH"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Tajima Airport
    Airport{IataCode{"TJI"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Trujillo Airport
    Airport{IataCode{"TJK"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Tokat Airport
    Airport{IataCode{"TJL"}, CountryId{"BR"}, Tz::America_Campo_Grande}, // Três Lagoas Airport
    Airport{IataCode{"TJM"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Roshchino International Airport
    Airport{IataCode{"TJN"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Takume airport
    Airport{IataCode{"TJQ"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Buluh Tumbang Airport
    Airport{IataCode{"TJS"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Tanjung Harapan Airport
    Airport{IataCode{"TJU"}, CountryId{"TJ"}, Tz::Asia_Dushanbe}, // Kulob Airport
    Airport{IataCode{"TKA"}, CountryId{"US"}, Tz::America_Anchorage}, // Talkeetna Airport
    Airport{IataCode{"TKB"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tekadu
    Airport{IataCode{"TKC"}, CountryId{"CM"}, Tz::Africa_Douala}, // Tiko Airport
    Airport{IataCode{"TKD"}, CountryId{"GH"}, Tz::Africa_Accra}, // Takoradi Airport
    Airport{IataCode{"TKF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Truckee Tahoe Airport
    Airport{IataCode{"TKG"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Radin Inten II Airport
    Airport{IataCode{"TKH"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Takhli Airport
    Airport{IataCode{"TKI"}, CountryId{"US"}, Tz::America_Sitka}, // Tokeen Seaplane Base
    Airport{IataCode{"TKJ"}, CountryId{"US"}, Tz::America_Anchorage}, // Tok Junction Airport
    Airport{IataCode{"TKK"}, CountryId{"FM"}, Tz::Pacific_Chuuk}, // Chuuk International Airport
    Airport{IataCode{"TKM"}, CountryId{"GT"}, Tz::America_Guatemala}, // El Peten Airport
    Airport{IataCode{"TKN"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Tokunoshima Airport
    Airport{IataCode{"TKO"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Tlokoeng Airport
    Airport{IataCode{"TKP"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Takapoto Airport
    Airport{IataCode{"TKQ"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Kigoma Airport
    Airport{IataCode{"TKR"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Thakurgaon STOLport
    Airport{IataCode{"TKS"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Tokushima Airport
    Airport{IataCode{"TKT"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Tak Airport
    Airport{IataCode{"TKU"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Turku Airport
    Airport{IataCode{"TKV"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Tatakoto Airport
    Airport{IataCode{"TKW"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tekin Airport
    Airport{IataCode{"TKX"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Takaroa Airport
    Airport{IataCode{"TKZ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Tokoroa Airport
    Airport{IataCode{"TLA"}, CountryId{"US"}, Tz::America_Nome}, // Teller Airport
    Airport{IataCode{"TLB"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Tarbela Dam Airport
    Airport{IataCode{"TLC"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Lic. Adolfo López Mateos International Airport
    Airport{IataCode{"TLD"}, CountryId{"BW"}, Tz::Africa_Gaborone}, // Tuli Lodge Airport
    Airport{IataCode{"TLF"}, CountryId{"US"}, Tz::America_Anchorage}, // Telida Airport
    Airport{IataCode{"TLH"}, CountryId{"US"}, Tz::America_New_York}, // Tallahassee International Airport
    Airport{IataCode{"TLI"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Sultan Bantilan Airport
    Airport{IataCode{"TLJ"}, CountryId{"US"}, Tz::America_Anchorage}, // Tatalina LRRS Airport
    Airport{IataCode{"TLK"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Talakan Airport
    Airport{IataCode{"TLL"}, CountryId{"EE"}, Tz::Europe_Tallinn}, // Tallinn Airport
    Airport{IataCode{"TLM"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Zenata – Messali El Hadj Airport
    Airport{IataCode{"TLN"}, CountryId{"FR"}, Tz::Europe_Paris}, // Toulon-Hyères Airport
    Airport{IataCode{"TLO"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tol Airport
    Airport{IataCode{"TLP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tumolbil
    Airport{IataCode{"TLQ"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Turpan Jiaohe Airport
    Airport{IataCode{"TLR"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Mefford Field Airport
    Airport{IataCode{"TLS"}, CountryId{"FR"}, Tz::Europe_Paris}, // Toulouse–Blagnac Airport
    Airport{IataCode{"TLT"}, CountryId{"US"}, Tz::America_Anchorage}, // Tuluksak Airport
    Airport{IataCode{"TLU"}, CountryId{"CO"}, Tz::America_Bogota}, // Golfo de Morrosquillo Airport
    Airport{IataCode{"TLV"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Ben Gurion Airport
    Airport{IataCode{"TLX"}, CountryId{"CL"}, Tz::America_Santiago}, // Panguilemo Airport
    Airport{IataCode{"TMA"}, CountryId{"US"}, Tz::America_New_York}, // Henry Tift Myers Airport
    Airport{IataCode{"TMB"}, CountryId{"US"}, Tz::America_New_York}, // Miami Executive Airport
    Airport{IataCode{"TMC"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Tambolaka Airport
    Airport{IataCode{"TMD"}, CountryId{"MR"}, Tz::Africa_Nouakchott}, // Timbedra Airport
    Airport{IataCode{"TME"}, CountryId{"CO"}, Tz::America_Bogota}, // Gabriel Vargas Santos Airport
    Airport{IataCode{"TMF"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Thimarafushi Airport
    Airport{IataCode{"TMG"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Tommanggong Airport
    Airport{IataCode{"TMI"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Tumlingtar Airport
    Airport{IataCode{"TMJ"}, CountryId{"UZ"}, Tz::Asia_Samarkand}, // Termez Airport
    Airport{IataCode{"TML"}, CountryId{"GH"}, Tz::Africa_Accra}, // Tamale Airport
    Airport{IataCode{"TMM"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Toamasina Airport
    Airport{IataCode{"TMN"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Tamana Airport
    Airport{IataCode{"TMO"}, CountryId{"VE"}, Tz::America_Caracas}, // Tumeremo Airport
    Airport{IataCode{"TMP"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Tampere-Pirkkala Airport
    Airport{IataCode{"TMQ"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Tambao Airport
    Airport{IataCode{"TMR"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Aguenar–Hadj Bey Akhamok Airport
    Airport{IataCode{"TMS"}, CountryId{"ST"}, Tz::Africa_Sao_Tome}, // São Tomé International Airport
    Airport{IataCode{"TMT"}, CountryId{"BR"}, Tz::America_Santarem}, // Porto Trombetas Airport
    Airport{IataCode{"TMU"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Tambor Airport
    Airport{IataCode{"TMW"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Tamworth Regional Airport
    Airport{IataCode{"TMX"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Timimoun Airport
    Airport{IataCode{"TMZ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Thames Aerodrome
    Airport{IataCode{"TNA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Jinan Yaoqiang International Airport
    Airport{IataCode{"TNC"}, CountryId{"US"}, Tz::America_Nome}, // Tin City LRRS Airport
    Airport{IataCode{"TND"}, CountryId{"CU"}, Tz::America_Havana}, // Alberto Delgado Airport
    Airport{IataCode{"TNE"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // New Tanegashima Airport
    Airport{IataCode{"TNG"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Tangier Ibn Battouta Airport
    Airport{IataCode{"TNH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Tonghua Sanyuanpu Airport
    Airport{IataCode{"TNI"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Satna Airport
    Airport{IataCode{"TNJ"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Raja Haji Fisabilillah International Airport
    Airport{IataCode{"TNK"}, CountryId{"US"}, Tz::America_Nome}, // Tununak Airport
    Airport{IataCode{"TNL"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Ternopil Airport
    Airport{IataCode{"TNN"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Tainan Airport
    Airport{IataCode{"TNO"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Tamarindo Airport
    Airport{IataCode{"TNP"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Twentynine Palms Airport
    Airport{IataCode{"TNQ"}, CountryId{"KI"}, Tz::Pacific_Kiritimati}, // Teraina Airport
    Airport{IataCode{"TNR"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Ivato Airport
    Airport{IataCode{"TNS"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Tungsten (Cantung) Airport
    Airport{IataCode{"TNT"}, CountryId{"US"}, Tz::America_New_York}, // Dade-Collier Training and Transition Airport
    Airport{IataCode{"TNU"}, CountryId{"US"}, Tz::America_Chicago}, // Newton Municipal Airport (Iowa)
    Airport{IataCode{"TNV"}, CountryId{"KI"}, Tz::Pacific_Kiritimati}, // Tabuaeran Island Airport
    Airport{IataCode{"TNW"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Jumandy Airport
    Airport{IataCode{"TNX"}, CountryId{"KH"}, Tz::Asia_Phnom_Penh}, // Stung Treng Airport
    Airport{IataCode{"TOA"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Zamperini Field
    Airport{IataCode{"TOB"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Tobruk Airport
    Airport{IataCode{"TOC"}, CountryId{"US"}, Tz::America_New_York}, // Toccoa Airport
    Airport{IataCode{"TOD"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Tioman Airport
    Airport{IataCode{"TOE"}, CountryId{"TN"}, Tz::Africa_Tunis}, // Tozeur–Nefta International Airport
    Airport{IataCode{"TOF"}, CountryId{"RU"}, Tz::Asia_Tomsk}, // Bogashevo Airport
    Airport{IataCode{"TOG"}, CountryId{"US"}, Tz::America_Anchorage}, // Togiak Airport
    Airport{IataCode{"TOH"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Torres Airport
    Airport{IataCode{"TOI"}, CountryId{"US"}, Tz::America_Chicago}, // Troy Municipal Airport
    Airport{IataCode{"TOK"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Torokina Airport
    Airport{IataCode{"TOL"}, CountryId{"US"}, Tz::America_New_York}, // Toledo Express Airport
    Airport{IataCode{"TOM"}, CountryId{"ML"}, Tz::Africa_Bamako}, // Timbuktu Airport
    Airport{IataCode{"TON"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Tonu
    Airport{IataCode{"TOO"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // San Vito de Java Airport
    Airport{IataCode{"TOP"}, CountryId{"US"}, Tz::America_Chicago}, // Philip Billard Municipal Airport
    Airport{IataCode{"TOQ"}, CountryId{"CL"}, Tz::America_Santiago}, // Barriles Airport
    Airport{IataCode{"TOR"}, CountryId{"US"}, Tz::America_Denver}, // Torrington Municipal Airport
    Airport{IataCode{"TOS"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Tromsø Airport
    Airport{IataCode{"TOT"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Totness Airstrip
    Airport{IataCode{"TOU"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Touho Airport
    Airport{IataCode{"TOV"}, CountryId{"GB"}, Tz::America_Tortola}, // Tortola
    Airport{IataCode{"TOY"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Toyama Airport
    Airport{IataCode{"TOZ"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Mahana Airport
    Airport{IataCode{"TPA"}, CountryId{"US"}, Tz::America_New_York}, // Tampa International Airport
    Airport{IataCode{"TPC"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Tarapoa Airport
    Airport{IataCode{"TPE"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Taoyuan International Airport
    Airport{IataCode{"TPF"}, CountryId{"US"}, Tz::America_New_York}, // Peter O. Knight Airport
    Airport{IataCode{"TPG"}, CountryId{"MY"}, Tz::Asia_Kuala_Lumpur}, // Taiping Airport
    Airport{IataCode{"TPH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Tonopah Airport
    Airport{IataCode{"TPI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tapini Airport
    Airport{IataCode{"TPJ"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Taplejung Airport
    Airport{IataCode{"TPL"}, CountryId{"US"}, Tz::America_Chicago}, // Draughon-Miller Central Texas Regional Airport
    Airport{IataCode{"TPN"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Tiputini Airport
    Airport{IataCode{"TPQ"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Amado Nervo International Airport
    Airport{IataCode{"TPR"}, CountryId{"AU"}, Tz::Australia_Perth}, // Tom Price Airport
    Airport{IataCode{"TPS"}, CountryId{"IT"}, Tz::Europe_Rome}, // Vincenzo Florio Airport Trapani-Birgi
    Airport{IataCode{"TPU"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Tikapur Airport
    Airport{IataCode{"TQH"}, CountryId{"US"}, Tz::America_Chicago}, // Tahlequah Municipal Airport
    Airport{IataCode{"TQN"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Taloqan Airport
    Airport{IataCode{"TQP"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Trepell Airport
    Airport{IataCode{"TRA"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Tarama Airport
    Airport{IataCode{"TRB"}, CountryId{"CO"}, Tz::America_Bogota}, // Gonzalo Mejia Airport
    Airport{IataCode{"TRC"}, CountryId{"MX"}, Tz::America_Monterrey}, // Francisco Sarabia International Airport
    Airport{IataCode{"TRD"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Trondheim Airport
    Airport{IataCode{"TRE"}, CountryId{"GB"}, Tz::Europe_London}, // Tiree Airport
    Airport{IataCode{"TRF"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Sandefjord Airport, Torp
    Airport{IataCode{"TRG"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Tauranga Airport
    Airport{IataCode{"TRH"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Trona Airport
    Airport{IataCode{"TRI"}, CountryId{"US"}, Tz::America_New_York}, // Tri-Cities Regional Airport
    Airport{IataCode{"TRJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tarabits Airport
    Airport{IataCode{"TRK"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Juwata International Airport
    Airport{IataCode{"TRL"}, CountryId{"US"}, Tz::America_Chicago}, // Terrell Municipal Airport
    Airport{IataCode{"TRM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Jacqueline Cochran Regional Airport
    Airport{IataCode{"TRN"}, CountryId{"IT"}, Tz::Europe_Rome}, // Turin Airport
    Airport{IataCode{"TRO"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Taree Airport
    Airport{IataCode{"TRQ"}, CountryId{"BR"}, Tz::America_Rio_Branco}, // Tarauacá Airport
    Airport{IataCode{"TRS"}, CountryId{"IT"}, Tz::Europe_Rome}, // Trieste – Friuli Venezia Giulia Airport
    Airport{IataCode{"TRU"}, CountryId{"PE"}, Tz::America_Lima}, // Cap. FAP Carlos Martínez de Pinillos International Airport
    Airport{IataCode{"TRV"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Trivandrum International Airport
    Airport{IataCode{"TRW"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Bonriki International Airport
    Airport{IataCode{"TRX"}, CountryId{"US"}, Tz::America_Chicago}, // Trenton Municipal Airport
    Airport{IataCode{"TRY"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Tororo Airport
    Airport{IataCode{"TRZ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Tiruchirapalli Airport
    Airport{IataCode{"TSB"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Tsumeb Airport
    Airport{IataCode{"TSC"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Taisha Airport
    Airport{IataCode{"TSE"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Nursultan Nazarbayev International Airport
    Airport{IataCode{"TSF"}, CountryId{"IT"}, Tz::Europe_Rome}, // Treviso Airport
    Airport{IataCode{"TSG"}, CountryId{"US"}, Tz::America_Anchorage}, // Tanacross Airport
    Airport{IataCode{"TSH"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Tshikapa Airport
    Airport{IataCode{"TSI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tsili Tsili
    Airport{IataCode{"TSJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Tsushima Airport
    Airport{IataCode{"TSK"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Taskul
    Airport{IataCode{"TSL"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Tamuín National Airport
    Airport{IataCode{"TSM"}, CountryId{"US"}, Tz::America_Denver}, // Taos Regional Airport
    Airport{IataCode{"TSN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Tianjin Binhai International Airport
    Airport{IataCode{"TSP"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Tehachapi Municipal Airport
    Airport{IataCode{"TSR"}, CountryId{"RO"}, Tz::Europe_Bucharest}, // Traian Vuia International Airport
    Airport{IataCode{"TST"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Trang Airport
    Airport{IataCode{"TSU"}, CountryId{"KI"}, Tz::Pacific_Tarawa}, // Tabiteuea Süd Airport
    Airport{IataCode{"TSV"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Townsville Airport
    Airport{IataCode{"TSW"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tsewi
    Airport{IataCode{"TSY"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Tasikmalaya Airport
    Airport{IataCode{"TTA"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Tan Tan Airport
    Airport{IataCode{"TTB"}, CountryId{"IT"}, Tz::Europe_Rome}, // Tortolì-Arbatax Airport
    Airport{IataCode{"TTC"}, CountryId{"CL"}, Tz::America_Santiago}, // Las Breas Airport
    Airport{IataCode{"TTD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Portland-Troutdale Airport
    Airport{IataCode{"TTE"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Babullah Airport
    Airport{IataCode{"TTG"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Tartagal "General Enrique Mosconi" Airport
    Airport{IataCode{"TTJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Tottori Airport
    Airport{IataCode{"TTM"}, CountryId{"CO"}, Tz::America_Bogota}, // Tablón de Tamará Airport
    Airport{IataCode{"TTN"}, CountryId{"US"}, Tz::America_New_York}, // Trenton-Mercer Airport
    Airport{IataCode{"TTO"}, CountryId{"US"}, Tz::America_Chicago}, // Britton Municipal Airport
    Airport{IataCode{"TTQ"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Tortuguero Airport
    Airport{IataCode{"TTR"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Pongtiku Airport
    Airport{IataCode{"TTS"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Tsaratanana Airport
    Airport{IataCode{"TTT"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Taitung Airport
    Airport{IataCode{"TTU"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Sania Ramel Airport
    Airport{IataCode{"TUA"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Teniente Coronel Luis a Mantilla International Airport
    Airport{IataCode{"TUB"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Tubuai – Mataura Airport
    Airport{IataCode{"TUC"}, CountryId{"AR"}, Tz::America_Argentina_Tucuman}, // Teniente Benjamín Matienzo International Airport
    Airport{IataCode{"TUD"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Tambacounda Airport
    Airport{IataCode{"TUF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Tours Val de Loire Airport
    Airport{IataCode{"TUG"}, CountryId{"PH"}, Tz::Asia_Manila}, // Tuguegarao Airport
    Airport{IataCode{"TUI"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Turaif Domestic Airport
    Airport{IataCode{"TUJ"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Tum Airport
    Airport{IataCode{"TUK"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Turbat International Airport
    Airport{IataCode{"TUL"}, CountryId{"US"}, Tz::America_Chicago}, // Tulsa International Airport
    Airport{IataCode{"TUM"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Tumut Airport
    Airport{IataCode{"TUN"}, CountryId{"TN"}, Tz::Africa_Tunis}, // Tunis–Carthage International Airport
    Airport{IataCode{"TUO"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Taupo Airport
    Airport{IataCode{"TUP"}, CountryId{"US"}, Tz::America_Chicago}, // Tupelo Regional Airport
    Airport{IataCode{"TUQ"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Tougan Airport
    Airport{IataCode{"TUR"}, CountryId{"BR"}, Tz::America_Belem}, // Tucuruí Airport
    Airport{IataCode{"TUU"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Tabuk Regional Airport
    Airport{IataCode{"TUV"}, CountryId{"VE"}, Tz::America_Caracas}, // San Rafael Airport (Venezuela)
    Airport{IataCode{"TUX"}, CountryId{"CA"}, Tz::America_Dawson_Creek}, // Tumbler Ridge Airport
    Airport{IataCode{"TVA"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Morafenobe Airport
    Airport{IataCode{"TVC"}, CountryId{"US"}, Tz::America_Detroit}, // Cherry Capital Airport
    Airport{IataCode{"TVF"}, CountryId{"US"}, Tz::America_Chicago}, // Thief River Falls Regional Airport
    Airport{IataCode{"TVI"}, CountryId{"US"}, Tz::America_New_York}, // Thomasville Regional Airport
    Airport{IataCode{"TVK"}, CountryId{"US"}, Tz::America_Chicago}, // Centerville Municipal Airport
    Airport{IataCode{"TVL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Lake Tahoe Airport
    Airport{IataCode{"TVS"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Tangshan Sannühe Airport
    Airport{IataCode{"TVU"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Matei Airport
    Airport{IataCode{"TVY"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Dawei Airport
    Airport{IataCode{"TWA"}, CountryId{"US"}, Tz::America_Anchorage}, // Twin Hills Airport
    Airport{IataCode{"TWC"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Tumxuk Tangwangcheng Airport
    Airport{IataCode{"TWD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Jefferson County International Airport
    Airport{IataCode{"TWF"}, CountryId{"US"}, Tz::America_Boise}, // Magic Valley Regional Airport
    Airport{IataCode{"TWP"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Torwood Airport
    Airport{IataCode{"TWU"}, CountryId{"MY"}, Tz::Asia_Kuching}, // Tawau Airport
    Airport{IataCode{"TWY"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Tawa
    Airport{IataCode{"TWZ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Pukaki Airport
    Airport{IataCode{"TXE"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Takengon Rembele Airport
    Airport{IataCode{"TXK"}, CountryId{"US"}, Tz::America_Chicago}, // Texarkana Regional Airport
    Airport{IataCode{"TXL"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Berlin Tegel Airport
    Airport{IataCode{"TXN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Huangshan Tunxi International Airport
    Airport{IataCode{"TXU"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Tabou Airport
    Airport{IataCode{"TYB"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Tibooburra Airport
    Airport{IataCode{"TYD"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Tynda Airport
    Airport{IataCode{"TYE"}, CountryId{"US"}, Tz::America_Anchorage}, // Tyonek Airport
    Airport{IataCode{"TYF"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Torsby Airport
    Airport{IataCode{"TYL"}, CountryId{"PE"}, Tz::America_Lima}, // Cap. FAP Víctor Montes Arias Airport
    Airport{IataCode{"TYM"}, CountryId{"BS"}, Tz::America_Nassau}, // Staniel Cay Airport
    Airport{IataCode{"TYN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Taiyuan Wusu International Airport
    Airport{IataCode{"TYQ"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Indianapolis Executive Airport
    Airport{IataCode{"TYR"}, CountryId{"US"}, Tz::America_Chicago}, // Tyler Pounds Regional Airport
    Airport{IataCode{"TYS"}, CountryId{"US"}, Tz::America_New_York}, // McGhee Tyson Airport
    Airport{IataCode{"TYT"}, CountryId{"UY"}, Tz::America_Montevideo}, // Treinta y Tres Airport
    Airport{IataCode{"TYZ"}, CountryId{"US"}, Tz::America_Phoenix}, // Taylor Airport
    Airport{IataCode{"TZA"}, CountryId{"BZ"}, Tz::America_Belize}, // Belize City Municipal Airport
    Airport{IataCode{"TZC"}, CountryId{"US"}, Tz::America_Detroit}, // Tuscola Area Airport
    Airport{IataCode{"TZL"}, CountryId{"BA"}, Tz::Europe_Sarajevo}, // Tuzla International Airport
    Airport{IataCode{"TZM"}, CountryId{"MX"}, Tz::America_Merida}, // Cupul aerodrome
    Airport{IataCode{"TZN"}, CountryId{"BS"}, Tz::America_Nassau}, // South Andros Airport
    Airport{IataCode{"TZR"}, CountryId{"US"}, Tz::America_New_York}, // Bolton Field
    Airport{IataCode{"TZX"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Trabzon Airport
    Airport{IataCode{"UAC"}, CountryId{"MX"}, Tz::America_Hermosillo}, // San Luis Río Colorado Airport
    Airport{IataCode{"UAE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Mount Aue
    Airport{IataCode{"UAH"}, CountryId{"FR"}, Tz::Pacific_Marquesas}, // Ua Huka Airport
    Airport{IataCode{"UAI"}, CountryId{"TL"}, Tz::Asia_Dili}, // Suai Airport
    Airport{IataCode{"UAL"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Luau Villa Teixeira de Sousa  Airport
    Airport{IataCode{"UAO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Aurora State Airport
    Airport{IataCode{"UAP"}, CountryId{"FR"}, Tz::Pacific_Marquesas}, // Ua Pou Airport
    Airport{IataCode{"UAQ"}, CountryId{"AR"}, Tz::America_Argentina_San_Juan}, // Domingo Faustino Sarmiento Airport
    Airport{IataCode{"UAR"}, CountryId{"MA"}, Tz::Africa_Casablanca}, // Bouarfa Airport
    Airport{IataCode{"UAS"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Samburu Airport
    Airport{IataCode{"UAX"}, CountryId{"GT"}, Tz::America_Guatemala}, // Uaxactun Airport
    Airport{IataCode{"UBA"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Uberaba Airport
    Airport{IataCode{"UBB"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Mabuiag Island Airport
    Airport{IataCode{"UBI"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Buin Airport
    Airport{IataCode{"UBJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Yamaguchi Ube Airport
    Airport{IataCode{"UBN"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // New Ulaanbaatar International Airport
    Airport{IataCode{"UBP"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Ubon Ratchathani Airport
    Airport{IataCode{"UBS"}, CountryId{"US"}, Tz::America_Chicago}, // Columbus-Lowndes County Airport
    Airport{IataCode{"UBT"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Ubatuba Airport
    Airport{IataCode{"UCB"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Ulanqab Jining Airport
    Airport{IataCode{"UCC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Yucca Airstrip
    Airport{IataCode{"UCK"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Lutsk Airport
    Airport{IataCode{"UCN"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Buchanan Airport
    Airport{IataCode{"UCP"}, CountryId{"US"}, Tz::America_New_York}, // New Castle Municipal Airport
    Airport{IataCode{"UCT"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Ukhta Airport
    Airport{IataCode{"UCY"}, CountryId{"US"}, Tz::America_Chicago}, // Everett-Stewart Regional Airport
    Airport{IataCode{"UCZ"}, CountryId{"PE"}, Tz::America_Lima}, // Uchiza Airport
    Airport{IataCode{"UDD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Bermuda Dunes Airport
    Airport{IataCode{"UDG"}, CountryId{"US"}, Tz::America_New_York}, // Darlington County Jetport
    Airport{IataCode{"UDI"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Uberlândia Airport
    Airport{IataCode{"UDJ"}, CountryId{"UA"}, Tz::Europe_Uzhgorod}, // Uzhhorod International Airport
    Airport{IataCode{"UDL"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Buol Airport
    Airport{IataCode{"UDN"}, CountryId{"IT"}, Tz::Europe_Rome}, // Udine-Campoformido Airport
    Airport{IataCode{"UDR"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Udaipur Airport
    Airport{IataCode{"UEE"}, CountryId{"AU"}, Tz::Australia_Hobart}, // Queenstown Airport
    Airport{IataCode{"UEL"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Quelimane Airport
    Airport{IataCode{"UEO"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kumejima Airport
    Airport{IataCode{"UES"}, CountryId{"US"}, Tz::America_Chicago}, // Waukesha County Airport
    Airport{IataCode{"UET"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Quetta International Airport
    Airport{IataCode{"UFA"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Ufa International Airport
    Airport{IataCode{"UGA"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Bulgan Airport
    Airport{IataCode{"UGB"}, CountryId{"US"}, Tz::America_Anchorage}, // Ugashik Bay Airport
    Airport{IataCode{"UGC"}, CountryId{"UZ"}, Tz::Asia_Samarkand}, // Urgench International Airport
    Airport{IataCode{"UGN"}, CountryId{"US"}, Tz::America_Chicago}, // Waukegan Regional Airport
    Airport{IataCode{"UGO"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Uíge Airport
    Airport{IataCode{"UGS"}, CountryId{"US"}, Tz::America_Anchorage}, // Ugashik Airport
    Airport{IataCode{"UHE"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Kunovice Airport
    Airport{IataCode{"UIB"}, CountryId{"CO"}, Tz::America_Bogota}, // El Caraño Airport
    Airport{IataCode{"UIH"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Phu Cat Airport
    Airport{IataCode{"UII"}, CountryId{"HN"}, Tz::America_Tegucigalpa}, // Utila Airport
    Airport{IataCode{"UIK"}, CountryId{"RU"}, Tz::Asia_Irkutsk}, // Ust-Ilimsk Airport
    Airport{IataCode{"UIL"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Quillayute Airport
    Airport{IataCode{"UIN"}, CountryId{"US"}, Tz::America_Chicago}, // Quincy Regional Airport
    Airport{IataCode{"UIO"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Mariscal Sucre International Airport
    Airport{IataCode{"UIP"}, CountryId{"FR"}, Tz::Europe_Paris}, // Quimper – Cornouaille Airport
    Airport{IataCode{"UIR"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Quirindi Airport
    Airport{IataCode{"UIT"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Jaluit Airport
    Airport{IataCode{"UJE"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Ujae Airport
    Airport{IataCode{"UJN"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Uljin Airport
    Airport{IataCode{"UJU"}, CountryId{"KP"}, Tz::Asia_Pyongyang}, // Uiju Airfield
    Airport{IataCode{"UKA"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Ukunda Airport
    Airport{IataCode{"UKB"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Kobe Airport
    Airport{IataCode{"UKG"}, CountryId{"RU"}, Tz::Asia_Vladivostok}, // Ust-Kuyga Airport
    Airport{IataCode{"UKI"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Ukiah Municipal Airport
    Airport{IataCode{"UKK"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Oskemen Airport
    Airport{IataCode{"UKL"}, CountryId{"US"}, Tz::America_Chicago}, // Coffey County Airport
    Airport{IataCode{"UKR"}, CountryId{"YE"}, Tz::Asia_Aden}, // Mukeiras Airport
    Airport{IataCode{"UKS"}, CountryId{"RU"}, Tz::Europe_Simferopol}, // Sevastopol International Airport
    Airport{IataCode{"UKT"}, CountryId{"US"}, Tz::America_New_York}, // Quakertown Airport
    Airport{IataCode{"UKU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Nuku Airport
    Airport{IataCode{"UKX"}, CountryId{"RU"}, Tz::Asia_Irkutsk}, // Ust-Kut Airport
    Airport{IataCode{"ULA"}, CountryId{"AR"}, Tz::America_Argentina_Rio_Gallegos}, // Capitán José Daniel Vazquez Airport
    Airport{IataCode{"ULB"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Ulei Airport
    Airport{IataCode{"ULC"}, CountryId{"CL"}, Tz::America_Santiago}, // Los Cerrillos Airport
    Airport{IataCode{"ULD"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Prince M. Buthelezi Airport
    Airport{IataCode{"ULE"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Sule Airport
    Airport{IataCode{"ULG"}, CountryId{"MN"}, Tz::Asia_Hovd}, // Ölgii Airport
    Airport{IataCode{"ULH"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Prince Abdul Majeed bin Abdul Aziz Domestic Airport
    Airport{IataCode{"ULK"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Lensk Airport
    Airport{IataCode{"ULM"}, CountryId{"US"}, Tz::America_Chicago}, // New Ulm Municipal Airport
    Airport{IataCode{"ULN"}, CountryId{"MN"}, Tz::Asia_Ulaanbaatar}, // Chinggis Khaan International Airport
    Airport{IataCode{"ULO"}, CountryId{"MN"}, Tz::Asia_Hovd}, // Ulaangom Airport
    Airport{IataCode{"ULP"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Quilpie Airport
    Airport{IataCode{"ULQ"}, CountryId{"CO"}, Tz::America_Bogota}, // Heriberto Gíl Martínez Airport
    Airport{IataCode{"ULU"}, CountryId{"UG"}, Tz::Africa_Kampala}, // Gulu Airport
    Airport{IataCode{"ULV"}, CountryId{"RU"}, Tz::Europe_Ulyanovsk}, // Ulyanovsk Baratayevka Airport
    Airport{IataCode{"ULY"}, CountryId{"RU"}, Tz::Europe_Ulyanovsk}, // Ulyanovsk Vostochny Airport
    Airport{IataCode{"ULZ"}, CountryId{"MN"}, Tz::Asia_Hovd}, // Donoi Airport
    Airport{IataCode{"UMC"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Umba Airport
    Airport{IataCode{"UME"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Umeå Airport
    Airport{IataCode{"UMM"}, CountryId{"US"}, Tz::America_Anchorage}, // Summit Airport
    Airport{IataCode{"UMP"}, CountryId{"US"}, Tz::America_Indiana_Indianapolis}, // Indianapolis Metropolitan Airport
    Airport{IataCode{"UMS"}, CountryId{"RU"}, Tz::Asia_Khandyga}, // Ust-Maya Airport
    Airport{IataCode{"UMT"}, CountryId{"US"}, Tz::America_Anchorage}, // Umiat Airport
    Airport{IataCode{"UMU"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Umuarama Airport
    Airport{IataCode{"UMY"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Sumy Airport
    Airport{IataCode{"UNA"}, CountryId{"BR"}, Tz::America_Bahia}, // Una-Comandatuba Airport
    Airport{IataCode{"UND"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Kunduz Airport
    Airport{IataCode{"UNE"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Qacha's Nek Airport
    Airport{IataCode{"UNG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Kiunga Airport
    Airport{IataCode{"UNI"}, CountryId{"VC"}, Tz::America_St_Vincent}, // Union Island Airport
    Airport{IataCode{"UNK"}, CountryId{"US"}, Tz::America_Anchorage}, // Unalakleet Airport
    Airport{IataCode{"UNN"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Ranong Airport
    Airport{IataCode{"UNO"}, CountryId{"US"}, Tz::America_Chicago}, // West Plains Regional Airport
    Airport{IataCode{"UNU"}, CountryId{"US"}, Tz::America_Chicago}, // Dodge County Airport
    Airport{IataCode{"UOS"}, CountryId{"US"}, Tz::America_Chicago}, // Franklin County Airport
    Airport{IataCode{"UOX"}, CountryId{"US"}, Tz::America_Chicago}, // University-Oxford Airport
    Airport{IataCode{"UPB"}, CountryId{"CU"}, Tz::America_Havana}, // Playa Baracoa Airport
    Airport{IataCode{"UPG"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Sultan Hasanuddin International Airport
    Airport{IataCode{"UPN"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Lic. y Gen. Ignacio López Rayón International Airport
    Airport{IataCode{"UPP"}, CountryId{"US"}, Tz::Pacific_Honolulu}, // Upolu Airport
    Airport{IataCode{"URA"}, CountryId{"KZ"}, Tz::Asia_Oral}, // Oral Ak Zhol Airport
    Airport{IataCode{"URB"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Urubupunga Airport
    Airport{IataCode{"URC"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Ürümqi Diwopu International Airport
    Airport{IataCode{"URE"}, CountryId{"EE"}, Tz::Europe_Tallinn}, // Kuressaare Airport
    Airport{IataCode{"URG"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Ruben Berta International Airport
    Airport{IataCode{"URJ"}, CountryId{"RU"}, Tz::Asia_Yekaterinburg}, // Uray Airport
    Airport{IataCode{"URO"}, CountryId{"FR"}, Tz::Europe_Paris}, // Rouen Airport
    Airport{IataCode{"URR"}, CountryId{"CO"}, Tz::America_Bogota}, // Urrao Airport
    Airport{IataCode{"URS"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Kursk Vostochny Airport
    Airport{IataCode{"URT"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Surat Thani Airport
    Airport{IataCode{"URU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Uroubi
    Airport{IataCode{"URY"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Gurayat Domestic Airport
    Airport{IataCode{"USA"}, CountryId{"US"}, Tz::America_New_York}, // Concord Regional Airport
    Airport{IataCode{"USH"}, CountryId{"AR"}, Tz::America_Argentina_Ushuaia}, // Ushuaia – Malvinas Argentinas International Airport
    Airport{IataCode{"USI"}, CountryId{"GY"}, Tz::America_Guyana}, // Mabaruma Airport
    Airport{IataCode{"USK"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Usinsk Airport
    Airport{IataCode{"USM"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Samui Airport
    Airport{IataCode{"USN"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Ulsan Airport
    Airport{IataCode{"USQ"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Uşak Airport
    Airport{IataCode{"USR"}, CountryId{"RU"}, Tz::Asia_Ust_Nera}, // Ust-Nera Airport
    Airport{IataCode{"USS"}, CountryId{"CU"}, Tz::America_Havana}, // Sancti Spíritus Airport
    Airport{IataCode{"UST"}, CountryId{"US"}, Tz::America_New_York}, // Northeast Florida Regional Airport
    Airport{IataCode{"USU"}, CountryId{"PH"}, Tz::Asia_Manila}, // Francisco B. Reyes Airport
    Airport{IataCode{"UTA"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Mutare Airport
    Airport{IataCode{"UTB"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Muttaburra Airport
    Airport{IataCode{"UTG"}, CountryId{"LS"}, Tz::Africa_Maseru}, // Quthing Airport
    Airport{IataCode{"UTH"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // Udon Thani International Airport
    Airport{IataCode{"UTI"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Utti Airport
    Airport{IataCode{"UTK"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Utirik Airport
    Airport{IataCode{"UTM"}, CountryId{"US"}, Tz::America_Chicago}, // Tunica Municipal Airport
    Airport{IataCode{"UTN"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Upington Airport
    Airport{IataCode{"UTO"}, CountryId{"US"}, Tz::America_Anchorage}, // Indian Mountain LRRS Airport
    Airport{IataCode{"UTP"}, CountryId{"TH"}, Tz::Asia_Bangkok}, // U-Tapao International Airport
    Airport{IataCode{"UTS"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Ust-Tsylma Airport
    Airport{IataCode{"UTT"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Mthatha Airport
    Airport{IataCode{"UTU"}, CountryId{"PA"}, Tz::America_Panama}, // Ustupo Airport
    Airport{IataCode{"UUA"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Bugulma Airport
    Airport{IataCode{"UUD"}, CountryId{"RU"}, Tz::Asia_Irkutsk}, // Baikal International Airport
    Airport{IataCode{"UUK"}, CountryId{"US"}, Tz::America_Anchorage}, // Ugnu-Kuparuk Airport
    Airport{IataCode{"UUN"}, CountryId{"MN"}, Tz::Asia_Choibalsan}, // Baruun-Urt Airport
    Airport{IataCode{"UUS"}, CountryId{"RU"}, Tz::Asia_Sakhalin}, // Yuzhno-Sakhalinsk Airport
    Airport{IataCode{"UUU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Manumu Airport
    Airport{IataCode{"UVA"}, CountryId{"US"}, Tz::America_Chicago}, // Garner Field
    Airport{IataCode{"UVE"}, CountryId{"FR"}, Tz::Pacific_Noumea}, // Ouvéa Airport
    Airport{IataCode{"UVF"}, CountryId{"LC"}, Tz::America_St_Lucia}, // Hewanorra International Airport
    Airport{IataCode{"UVL"}, CountryId{"EG"}, Tz::Africa_Cairo}, // El Kharga Airport
    Airport{IataCode{"UWA"}, CountryId{"US"}, Tz::America_New_York}, // Ware Airport
    Airport{IataCode{"UXL"}, CountryId{"US"}, Tz::America_Chicago}, // Southland Field
    Airport{IataCode{"UYF"}, CountryId{"US"}, Tz::America_New_York}, // Madison County Airport
    Airport{IataCode{"UYL"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Nyala Airport
    Airport{IataCode{"UYN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yulin Yuyang Airport
    Airport{IataCode{"UYU"}, CountryId{"BO"}, Tz::America_La_Paz}, // Joya Andina Airport
    Airport{IataCode{"UZC"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Ponikve Airport
    Airport{IataCode{"UZM"}, CountryId{"CA"}, Tz::America_Cambridge_Bay}, // Hope Bay Aerodrome
    Airport{IataCode{"UZR"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Urzhar Airport
    Airport{IataCode{"UZU"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Curuzú Cuatiá Airport
    Airport{IataCode{"VAA"}, CountryId{"FI"}, Tz::Europe_Helsinki}, // Vaasa Airport
    Airport{IataCode{"VAF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Valence-Chabeuil Airport
    Airport{IataCode{"VAG"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Varginha Airport
    Airport{IataCode{"VAH"}, CountryId{"BO"}, Tz::America_La_Paz}, // Vallegrande Airport
    Airport{IataCode{"VAI"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Vanimo Airport
    Airport{IataCode{"VAK"}, CountryId{"US"}, Tz::America_Nome}, // Chevak Airport
    Airport{IataCode{"VAL"}, CountryId{"BR"}, Tz::America_Bahia}, // Valenca Airport
    Airport{IataCode{"VAM"}, CountryId{"MV"}, Tz::Indian_Maldives}, // Maamigili Airport
    Airport{IataCode{"VAN"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Van Ferit Melen Airport
    Airport{IataCode{"VAO"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Suavanao Airport
    Airport{IataCode{"VAP"}, CountryId{"CL"}, Tz::America_Santiago}, // Viñamar Airport
    Airport{IataCode{"VAR"}, CountryId{"BG"}, Tz::Europe_Sofia}, // Varna Airport
    Airport{IataCode{"VAS"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Sivas Airport
    Airport{IataCode{"VAT"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Vatomandry Airport
    Airport{IataCode{"VAU"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Vatukoula Airport
    Airport{IataCode{"VAV"}, CountryId{"TO"}, Tz::Pacific_Tongatapu}, // Vava'u International Airport
    Airport{IataCode{"VAW"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Vardø Airport, Svartnes
    Airport{IataCode{"VBC"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Mandalay Chanmyathazi Airport
    Airport{IataCode{"VBP"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Bokpyin Airport
    Airport{IataCode{"VBS"}, CountryId{"IT"}, Tz::Europe_Rome}, // Brescia Airport
    Airport{IataCode{"VBT"}, CountryId{"US"}, Tz::America_Chicago}, // Bentonville Municipal Airport
    Airport{IataCode{"VBV"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Vanuabalavu Airport
    Airport{IataCode{"VBY"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Visby Airport
    Airport{IataCode{"VCA"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Can Tho International Airport
    Airport{IataCode{"VCB"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Nut Tree Airport
    Airport{IataCode{"VCC"}, CountryId{"CM"}, Tz::Africa_Douala}, // Limbe Airport
    Airport{IataCode{"VCD"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Victoria River Downs Airport
    Airport{IataCode{"VCE"}, CountryId{"IT"}, Tz::Europe_Rome}, // Venice Marco Polo Airport
    Airport{IataCode{"VCF"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Valcheta Airport
    Airport{IataCode{"VCH"}, CountryId{"UY"}, Tz::America_Montevideo}, // Vichadero Airport
    Airport{IataCode{"VCL"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Chu Lai Airport
    Airport{IataCode{"VCP"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Viracopos International Airport
    Airport{IataCode{"VCR"}, CountryId{"VE"}, Tz::America_Caracas}, // Carora Airport
    Airport{IataCode{"VCS"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Con Dao Airport
    Airport{IataCode{"VCT"}, CountryId{"US"}, Tz::America_Chicago}, // Victoria Regional Airport
    Airport{IataCode{"VCV"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Southern California Logistics Airport
    Airport{IataCode{"VDA"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Ovda Airport
    Airport{IataCode{"VDB"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Fagernes Airport, Leirin
    Airport{IataCode{"VDC"}, CountryId{"BR"}, Tz::America_Bahia}, // Vitória da Conquista Airport
    Airport{IataCode{"VDE"}, CountryId{"ES"}, Tz::Atlantic_Canary}, // El Hierro Airport
    Airport{IataCode{"VDF"}, CountryId{"US"}, Tz::America_New_York}, // Tampa Executive Airport
    Airport{IataCode{"VDH"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Dong Hoi Airport
    Airport{IataCode{"VDI"}, CountryId{"US"}, Tz::America_New_York}, // Vidalia Regional Airport
    Airport{IataCode{"VDM"}, CountryId{"AR"}, Tz::America_Argentina_Salta}, // Gobernador Edgardo Castello Airport
    Airport{IataCode{"VDO"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Van Don International Airport
    Airport{IataCode{"VDP"}, CountryId{"VE"}, Tz::America_Caracas}, // Valle de la Pascua Airport
    Airport{IataCode{"VDR"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Villa Dolores Airport
    Airport{IataCode{"VDS"}, CountryId{"NO"}, Tz::Europe_Oslo}, // Vadsø Airport
    Airport{IataCode{"VDY"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Vidyanagar Airport
    Airport{IataCode{"VDZ"}, CountryId{"US"}, Tz::America_Anchorage}, // Valdez Airport
    Airport{IataCode{"VEE"}, CountryId{"US"}, Tz::America_Anchorage}, // Venetie Airport
    Airport{IataCode{"VEL"}, CountryId{"US"}, Tz::America_Denver}, // Vernal Regional Airport
    Airport{IataCode{"VER"}, CountryId{"MX"}, Tz::America_Mexico_City}, // General Heriberto Jara International Airport
    Airport{IataCode{"VES"}, CountryId{"US"}, Tz::America_New_York}, // Darke County Airport
    Airport{IataCode{"VEY"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Vestmannaeyjar Airport
    Airport{IataCode{"VFA"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Victoria Falls Airport
    Airport{IataCode{"VGA"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Vijayawada Airport
    Airport{IataCode{"VGC"}, CountryId{"US"}, Tz::America_New_York}, // Hamilton Municipal Airport
    Airport{IataCode{"VGD"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Vologda Airport
    Airport{IataCode{"VGN"}, CountryId{"PH"}, Tz::Asia_Manila}, // Mindoro Airport
    Airport{IataCode{"VGO"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Vigo Airport
    Airport{IataCode{"VGT"}, CountryId{"US"}, Tz::America_Los_Angeles}, // North Las Vegas Airport
    Airport{IataCode{"VGZ"}, CountryId{"CO"}, Tz::America_Bogota}, // Villa Garzón Airport
    Airport{IataCode{"VHC"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Saurimo Airport
    Airport{IataCode{"VHM"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Vilhelmina Airport
    Airport{IataCode{"VHN"}, CountryId{"US"}, Tz::America_Chicago}, // Culberson County Airport
    Airport{IataCode{"VHV"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Verkhnevilyuysk Airport
    Airport{IataCode{"VHY"}, CountryId{"FR"}, Tz::Europe_Paris}, // Vichy – Charmeil Airport
    Airport{IataCode{"VHZ"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Vahitahi Airport
    Airport{IataCode{"VIA"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Videira Airport
    Airport{IataCode{"VIB"}, CountryId{"MX"}, Tz::America_Mazatlan}, // Villa Constitución Airport
    Airport{IataCode{"VID"}, CountryId{"BG"}, Tz::Europe_Sofia}, // Vidin Airfield
    Airport{IataCode{"VIE"}, CountryId{"AT"}, Tz::Europe_Vienna}, // Wien-Schwechat Airport
    Airport{IataCode{"VIG"}, CountryId{"VE"}, Tz::America_Caracas}, // Juan Pablo Pérez Alfonso Airport
    Airport{IataCode{"VIH"}, CountryId{"US"}, Tz::America_Chicago}, // Rolla National Airport
    Airport{IataCode{"VII"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Vinh Airport
    Airport{IataCode{"VIJ"}, CountryId{"GB"}, Tz::America_Tortola}, // Virgin Gorda Airport
    Airport{IataCode{"VIL"}, CountryId{"MA"}, Tz::Africa_El_Aaiun}, // Dakhla Airport
    Airport{IataCode{"VIN"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Havryshivka Vinnytsia International Airport
    Airport{IataCode{"VIQ"}, CountryId{"TL"}, Tz::Asia_Dili}, // Viqueque Airport
    Airport{IataCode{"VIR"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Virginia Airport
    Airport{IataCode{"VIS"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Visalia Municipal Airport
    Airport{IataCode{"VIT"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Vitoria Airport
    Airport{IataCode{"VIV"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Vivigani Airfield
    Airport{IataCode{"VIX"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Eurico de Aguiar Salles Airport
    Airport{IataCode{"VJI"}, CountryId{"US"}, Tz::America_New_York}, // Virginia Highlands Airport
    Airport{IataCode{"VKG"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Rach Gia Airport
    Airport{IataCode{"VKO"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Vnukovo International Airport
    Airport{IataCode{"VKT"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Vorkuta Airport
    Airport{IataCode{"VKX"}, CountryId{"US"}, Tz::America_New_York}, // Potomac Airfield
    Airport{IataCode{"VLC"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Valencia Airport
    Airport{IataCode{"VLD"}, CountryId{"US"}, Tz::America_New_York}, // Valdosta Regional Airport
    Airport{IataCode{"VLE"}, CountryId{"US"}, Tz::America_Phoenix}, // Valle Airport
    Airport{IataCode{"VLG"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Villa Gesell Airport
    Airport{IataCode{"VLI"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Bauerfield International Airport
    Airport{IataCode{"VLL"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Valladolid Airport
    Airport{IataCode{"VLM"}, CountryId{"BO"}, Tz::America_La_Paz}, // Lieutenant Colonel Rafael Pabón Airport
    Airport{IataCode{"VLN"}, CountryId{"VE"}, Tz::America_Caracas}, // Arturo Michelena International Airport
    Airport{IataCode{"VLP"}, CountryId{"BR"}, Tz::America_Cuiaba}, // Vila Rica Airport
    Airport{IataCode{"VLR"}, CountryId{"CL"}, Tz::America_Santiago}, // Vallenar Airport
    Airport{IataCode{"VLS"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Valesdir Airport
    Airport{IataCode{"VLU"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Velikiye Luki Airport
    Airport{IataCode{"VLV"}, CountryId{"VE"}, Tz::America_Caracas}, // Dr. Antonio Nicolás Briceño Airport
    Airport{IataCode{"VLY"}, CountryId{"GB"}, Tz::Europe_London}, // Anglesey Airport
    Airport{IataCode{"VME"}, CountryId{"AR"}, Tz::America_Argentina_San_Luis}, // Villa Reynolds Airport
    Airport{IataCode{"VMI"}, CountryId{"PY"}, Tz::America_Asuncion}, // Dr Juan Plate
    Airport{IataCode{"VMR"}, CountryId{"AR"}, Tz::America_Argentina_Cordoba}, // Presidente Néstor Kirchner Airport
    Airport{IataCode{"VMU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Baimuru Airport
    Airport{IataCode{"VNC"}, CountryId{"US"}, Tz::America_New_York}, // Venice Municipal Airport
    Airport{IataCode{"VND"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Vangaindrano Airport
    Airport{IataCode{"VNE"}, CountryId{"FR"}, Tz::Europe_Paris}, // Meucon Airport
    Airport{IataCode{"VNO"}, CountryId{"LT"}, Tz::Europe_Vilnius}, // Vilnius Airport
    Airport{IataCode{"VNS"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Lal Bahadur Shastri Airport
    Airport{IataCode{"VNT"}, CountryId{"LV"}, Tz::Europe_Riga}, // Ventspils International Airport
    Airport{IataCode{"VNX"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Vilankulo Airport
    Airport{IataCode{"VNY"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Van Nuys Airport
    Airport{IataCode{"VOD"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Vodochody Airport
    Airport{IataCode{"VOG"}, CountryId{"RU"}, Tz::Europe_Volgograd}, // Volgograd International Airport
    Airport{IataCode{"VOI"}, CountryId{"LR"}, Tz::Africa_Monrovia}, // Voinjama Airport
    Airport{IataCode{"VOL"}, CountryId{"GR"}, Tz::Europe_Athens}, // Nea Anchialos National Airport
    Airport{IataCode{"VOT"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Votuporanga Airport
    Airport{IataCode{"VOZ"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Voronezh International Airport
    Airport{IataCode{"VPC"}, CountryId{"US"}, Tz::America_New_York}, // Cartersville Airport
    Airport{IataCode{"VPE"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Ondjiva Pereira Airport
    Airport{IataCode{"VPG"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Vipingo Airport
    Airport{IataCode{"VPN"}, CountryId{"IS"}, Tz::Atlantic_Reykjavik}, // Vopnafjörður Airport
    Airport{IataCode{"VPS"}, CountryId{"US"}, Tz::America_Chicago}, // Destin–Fort Walton Beach Airport
    Airport{IataCode{"VPY"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Chimoio Airport
    Airport{IataCode{"VPZ"}, CountryId{"US"}, Tz::America_Chicago}, // Porter County Regional Airport
    Airport{IataCode{"VQQ"}, CountryId{"US"}, Tz::America_New_York}, // Cecil Airport
    Airport{IataCode{"VQS"}, CountryId{"US"}, Tz::America_Puerto_Rico}, // Antonio Rivera Rodríguez Airport
    Airport{IataCode{"VRA"}, CountryId{"CU"}, Tz::America_Havana}, // Juan Gualberto Gómez Airport
    Airport{IataCode{"VRB"}, CountryId{"US"}, Tz::America_New_York}, // Vero Beach Municipal Airport
    Airport{IataCode{"VRC"}, CountryId{"PH"}, Tz::Asia_Manila}, // Virac Airport
    Airport{IataCode{"VRE"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Vredendal Airport
    Airport{IataCode{"VRI"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Varandey Airport
    Airport{IataCode{"VRL"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Vila Real Airport
    Airport{IataCode{"VRO"}, CountryId{"CU"}, Tz::America_Havana}, // Kawama Airport
    Airport{IataCode{"VRU"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Vryburg Airport
    Airport{IataCode{"VSA"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Carlos Rovirosa Pérez International Airport
    Airport{IataCode{"VSE"}, CountryId{"PT"}, Tz::Europe_Lisbon}, // Viseu Airport
    Airport{IataCode{"VSF"}, CountryId{"US"}, Tz::America_New_York}, // Hartness State Airport
    Airport{IataCode{"VTB"}, CountryId{"BY"}, Tz::Europe_Minsk}, // Vitebsk Vostochny Airport
    Airport{IataCode{"VTE"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Wattay International Airport
    Airport{IataCode{"VTF"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Vatulele Airport
    Airport{IataCode{"VTG"}, CountryId{"VN"}, Tz::Asia_Ho_Chi_Minh}, // Vung Tau Airport
    Airport{IataCode{"VTN"}, CountryId{"US"}, Tz::America_Chicago}, // Miller Field
    Airport{IataCode{"VTR"}, CountryId{"IT"}, Tz::Europe_Rome}, // Rome Viterbo Airport
    Airport{IataCode{"VTU"}, CountryId{"CU"}, Tz::America_Havana}, // Hermanos Ameijeiras Airport
    Airport{IataCode{"VTZ"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Vishakhapatnam International Airport
    Airport{IataCode{"VUJ"}, CountryId{"US"}, Tz::America_New_York}, // Stanly County Airport
    Airport{IataCode{"VUO"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Pearson Field
    Airport{IataCode{"VUP"}, CountryId{"CO"}, Tz::America_Bogota}, // Alfonso López Pumarejo Airport
    Airport{IataCode{"VUS"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Veliky Ustyug Airport
    Airport{IataCode{"VVC"}, CountryId{"CO"}, Tz::America_Bogota}, // La Vanguardia Airport
    Airport{IataCode{"VVI"}, CountryId{"BO"}, Tz::America_La_Paz}, // Viru Viru International Airport
    Airport{IataCode{"VVO"}, CountryId{"RU"}, Tz::Asia_Vladivostok}, // Vladivostok International Airport
    Airport{IataCode{"VVZ"}, CountryId{"DZ"}, Tz::Africa_Algiers}, // Takhamalt Airport
    Airport{IataCode{"VXC"}, CountryId{"MZ"}, Tz::Africa_Maputo}, // Lichinga Airport
    Airport{IataCode{"VXE"}, CountryId{"CV"}, Tz::Atlantic_Cape_Verde}, // Cesária Évora Airport
    Airport{IataCode{"VXO"}, CountryId{"SE"}, Tz::Europe_Stockholm}, // Växjö/Kronoberg Airport
    Airport{IataCode{"VYI"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Vilyuisk Airport
    Airport{IataCode{"VYS"}, CountryId{"US"}, Tz::America_Chicago}, // Illinois Valley Regional Airport
    Airport{IataCode{"WAA"}, CountryId{"US"}, Tz::America_Nome}, // Wales Airport
    Airport{IataCode{"WAC"}, CountryId{"ET"}, Tz::Africa_Addis_Ababa}, // Wacca Airport
    Airport{IataCode{"WAE"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Wadi al-Dawasir Domestic Airport
    Airport{IataCode{"WAG"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Wanganui Airport
    Airport{IataCode{"WAH"}, CountryId{"US"}, Tz::America_Chicago}, // Harry Stern Airport
    Airport{IataCode{"WAI"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Ambalabe Airport
    Airport{IataCode{"WAJ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wawoi Falls
    Airport{IataCode{"WAM"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Ambatondrazaka Airport
    Airport{IataCode{"WAO"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wabo
    Airport{IataCode{"WAP"}, CountryId{"CL"}, Tz::America_Santiago}, // Alto Palena Airport
    Airport{IataCode{"WAQ"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Antsalova Airport
    Airport{IataCode{"WAT"}, CountryId{"IE"}, Tz::Europe_Dublin}, // Waterford Airport
    Airport{IataCode{"WAW"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Warsaw Chopin Airport
    Airport{IataCode{"WAX"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Zuwarah Airport
    Airport{IataCode{"WAY"}, CountryId{"US"}, Tz::America_New_York}, // Greene County Airport
    Airport{IataCode{"WAZ"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Warwick Airport
    Airport{IataCode{"WBB"}, CountryId{"US"}, Tz::America_Nome}, // Stebbins Airport
    Airport{IataCode{"WBC"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wapolu
    Airport{IataCode{"WBM"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wapenamanda Airport
    Airport{IataCode{"WBO"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Antsoa Airport
    Airport{IataCode{"WBQ"}, CountryId{"US"}, Tz::America_Anchorage}, // Beaver Airport
    Airport{IataCode{"WBR"}, CountryId{"US"}, Tz::America_Detroit}, // Roben-Hood Airport
    Airport{IataCode{"WBU"}, CountryId{"US"}, Tz::America_Denver}, // Boulder Municipal Airport
    Airport{IataCode{"WBW"}, CountryId{"US"}, Tz::America_New_York}, // Wilkes-Barre Wyoming Valley Airport
    Airport{IataCode{"WCA"}, CountryId{"CL"}, Tz::America_Santiago}, // Gamboa Airport
    Airport{IataCode{"WCH"}, CountryId{"CL"}, Tz::America_Santiago}, // Nuevo Chaitén Airport
    Airport{IataCode{"WCR"}, CountryId{"US"}, Tz::America_Anchorage}, // Chandalar Lake Airport
    Airport{IataCode{"WDA"}, CountryId{"YE"}, Tz::Asia_Aden}, // Wadi Ain
    Airport{IataCode{"WDG"}, CountryId{"US"}, Tz::America_Chicago}, // Enid Woodring Regional Airport
    Airport{IataCode{"WDH"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Windhoek Hosea Kutako International Airport
    Airport{IataCode{"WDR"}, CountryId{"US"}, Tz::America_New_York}, // Barrow County Airport
    Airport{IataCode{"WDS"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shiyan Wudangshan Airport
    Airport{IataCode{"WEA"}, CountryId{"US"}, Tz::America_Chicago}, // Parker County Airport
    Airport{IataCode{"WEF"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Weifang Airport
    Airport{IataCode{"WEH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Weihai Dashuibo Airport
    Airport{IataCode{"WEI"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Weipa Airport
    Airport{IataCode{"WEL"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Welkom Airport
    Airport{IataCode{"WFI"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Fianarantsoa Airport
    Airport{IataCode{"WFK"}, CountryId{"US"}, Tz::America_New_York}, // Northern Aroostook Regional Airport
    Airport{IataCode{"WGC"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Warangal Airport
    Airport{IataCode{"WGE"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Walgett Airport
    Airport{IataCode{"WGN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Shaoyang Wugang Airport
    Airport{IataCode{"WGO"}, CountryId{"US"}, Tz::America_New_York}, // Winchester Regional Airport
    Airport{IataCode{"WGP"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Mau Hau Airport
    Airport{IataCode{"WGT"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Wangaratta Airport
    Airport{IataCode{"WGU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wagau
    Airport{IataCode{"WHD"}, CountryId{"US"}, Tz::America_Sitka}, // Hyder Seaplane Base
    Airport{IataCode{"WHF"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Wadi Halfa Airport
    Airport{IataCode{"WHK"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Whakatane Airport
    Airport{IataCode{"WHP"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Whiteman Airport
    Airport{IataCode{"WHT"}, CountryId{"US"}, Tz::America_Chicago}, // Wharton Regional Airport
    Airport{IataCode{"WIB"}, CountryId{"US"}, Tz::America_Chicago}, // Wilbarger County Airport
    Airport{IataCode{"WIC"}, CountryId{"GB"}, Tz::Europe_London}, // Wick Airport
    Airport{IataCode{"WIK"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Waiheke Island Aerodrome
    Airport{IataCode{"WIL"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Wilson Airport
    Airport{IataCode{"WIN"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Winton Airport
    Airport{IataCode{"WIO"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Wilcannia Airport
    Airport{IataCode{"WIR"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Wairoa Aerodrome
    Airport{IataCode{"WIU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Witu
    Airport{IataCode{"WJA"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Woja Airport
    Airport{IataCode{"WJF"}, CountryId{"US"}, Tz::America_Los_Angeles}, // General William J. Fox Airfield
    Airport{IataCode{"WJR"}, CountryId{"KE"}, Tz::Africa_Nairobi}, // Wajir Airport
    Airport{IataCode{"WJU"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Wonju Airport
    Airport{IataCode{"WKA"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Wanaka Airport
    Airport{IataCode{"WKB"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Warracknabeal Airport
    Airport{IataCode{"WKI"}, CountryId{"ZW"}, Tz::Africa_Harare}, // Hwange Town Airport
    Airport{IataCode{"WKJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Wakkanai Airport
    Airport{IataCode{"WKK"}, CountryId{"US"}, Tz::America_Anchorage}, // Aleknagik Airport
    Airport{IataCode{"WKN"}, CountryId{"PG"}, Tz::Pacific_Bougainville}, // Wakunai Airport
    Airport{IataCode{"WKR"}, CountryId{"BS"}, Tz::America_Nassau}, // Walkers Cay Airport
    Airport{IataCode{"WLD"}, CountryId{"US"}, Tz::America_Chicago}, // Strother Field
    Airport{IataCode{"WLE"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Miles Airport
    Airport{IataCode{"WLG"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Wellington International Airport
    Airport{IataCode{"WLH"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Walaha Airport
    Airport{IataCode{"WLK"}, CountryId{"US"}, Tz::America_Anchorage}, // Selawik Airport
    Airport{IataCode{"WLP"}, CountryId{"AU"}, Tz::Australia_Perth}, // West Angelas Airport
    Airport{IataCode{"WLS"}, CountryId{"FR"}, Tz::Pacific_Wallis}, // Hihifo Airport
    Airport{IataCode{"WLW"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Willows-Glenn County Airport
    Airport{IataCode{"WMB"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Warrnambool Airport
    Airport{IataCode{"WMC"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Winnemucca Municipal Airport
    Airport{IataCode{"WMD"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Mandabe Airport
    Airport{IataCode{"WME"}, CountryId{"AU"}, Tz::Australia_Perth}, // Mount Keith Airport
    Airport{IataCode{"WMH"}, CountryId{"US"}, Tz::America_Chicago}, // Ozark Regional Airport
    Airport{IataCode{"WMI"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Warsaw-Modlin Mazovia Airport
    Airport{IataCode{"WML"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // West Melton Aerodrome
    Airport{IataCode{"WMN"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Maroantsetra Airport
    Airport{IataCode{"WMO"}, CountryId{"US"}, Tz::America_Nome}, // White Mountain Airport
    Airport{IataCode{"WMP"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Mampikony Airport
    Airport{IataCode{"WMR"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Mananara Nord Airport
    Airport{IataCode{"WMT"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Renhuai Maotai Airport
    Airport{IataCode{"WMX"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Wamena Airport
    Airport{IataCode{"WNA"}, CountryId{"US"}, Tz::America_Anchorage}, // Napakiak Airport
    Airport{IataCode{"WNC"}, CountryId{"US"}, Tz::America_Sitka}, // Naukati Bay Seaplane Base
    Airport{IataCode{"WNH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Wenshan Puzhehei Airport
    Airport{IataCode{"WNI"}, CountryId{"ID"}, Tz::Asia_Makassar}, // Matahora Airport
    Airport{IataCode{"WNN"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Wunnummin Lake Airport
    Airport{IataCode{"WNP"}, CountryId{"PH"}, Tz::Asia_Manila}, // Naga Airport
    Airport{IataCode{"WNR"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Windorah Airport
    Airport{IataCode{"WNS"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Nawabshah Airport
    Airport{IataCode{"WNZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Wenzhou Longwan International Airport
    Airport{IataCode{"WOA"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wonenara Airport
    Airport{IataCode{"WOL"}, CountryId{"AU"}, Tz::Australia_Sydney}, // Shellharbour Airport
    Airport{IataCode{"WON"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Wondoola Airport
    Airport{IataCode{"WOS"}, CountryId{"KP"}, Tz::Asia_Pyongyang}, // Wonsan Airport
    Airport{IataCode{"WOT"}, CountryId{"TW"}, Tz::Asia_Taipei}, // Wang-an Airport
    Airport{IataCode{"WOW"}, CountryId{"US"}, Tz::America_Anchorage}, // Willow Airport
    Airport{IataCode{"WPA"}, CountryId{"CL"}, Tz::America_Santiago}, // Cabo 1° Juan Román Airport
    Airport{IataCode{"WPB"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Port Bergé Airport
    Airport{IataCode{"WPC"}, CountryId{"CA"}, Tz::America_Edmonton}, // Pincher Creek Airport
    Airport{IataCode{"WPL"}, CountryId{"CA"}, Tz::America_Vancouver}, // Powell Lake Water Aerodrome
    Airport{IataCode{"WPR"}, CountryId{"CL"}, Tz::America_Punta_Arenas}, // Capitan Fuentes Martinez Airport
    Airport{IataCode{"WPU"}, CountryId{"CL"}, Tz::America_Punta_Arenas}, // Guardiamarina Zañartu Airport
    Airport{IataCode{"WRE"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Whangarei Airport
    Airport{IataCode{"WRG"}, CountryId{"US"}, Tz::America_Sitka}, // Wrangell Airport
    Airport{IataCode{"WRL"}, CountryId{"US"}, Tz::America_Denver}, // Worland Municipal Airport
    Airport{IataCode{"WRN"}, CountryId{"AU"}, Tz::Australia_Perth}, // Windarling Airport
    Airport{IataCode{"WRO"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Wrocław – Copernicus Airport
    Airport{IataCode{"WRR"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Werur Airport
    Airport{IataCode{"WRT"}, CountryId{"GB"}, Tz::Europe_London}, // Warton Aerodrome
    Airport{IataCode{"WSE"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Santa Cecilia Airport
    Airport{IataCode{"WSF"}, CountryId{"US"}, Tz::America_Nome}, // Cape Sarichef Airport
    Airport{IataCode{"WSG"}, CountryId{"US"}, Tz::America_New_York}, // Washington County Airport
    Airport{IataCode{"WSH"}, CountryId{"US"}, Tz::America_New_York}, // Brookhaven Airport
    Airport{IataCode{"WSJ"}, CountryId{"US"}, Tz::America_Anchorage}, // San Juan (Uganik) Seaplane Base
    Airport{IataCode{"WSK"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Wushan Shennüfeng Airport
    Airport{IataCode{"WSN"}, CountryId{"US"}, Tz::America_Anchorage}, // South Naknek Airport
    Airport{IataCode{"WSO"}, CountryId{"SR"}, Tz::America_Paramaribo}, // Washabo airstrip
    Airport{IataCode{"WSP"}, CountryId{"NI"}, Tz::America_Managua}, // Waspam Airport
    Airport{IataCode{"WST"}, CountryId{"US"}, Tz::America_New_York}, // Westerly State Airport
    Airport{IataCode{"WSU"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wasu
    Airport{IataCode{"WSX"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Westsound/WSX Seaplane Base
    Airport{IataCode{"WSZ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Westport Airport, New Zealand
    Airport{IataCode{"WTA"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Tambohorano Airport
    Airport{IataCode{"WTB"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Toowoomba Wellcamp Airport
    Airport{IataCode{"WTD"}, CountryId{"BS"}, Tz::America_Nassau}, // West End Airport
    Airport{IataCode{"WTE"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Wotje Airport
    Airport{IataCode{"WTK"}, CountryId{"US"}, Tz::America_Nome}, // Noatak Airport
    Airport{IataCode{"WTL"}, CountryId{"US"}, Tz::America_Nome}, // Tuntutuliak Airport
    Airport{IataCode{"WTO"}, CountryId{"MH"}, Tz::Pacific_Majuro}, // Wotho Airport
    Airport{IataCode{"WTP"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Woitape Airport
    Airport{IataCode{"WTR"}, CountryId{"US"}, Tz::America_Phoenix}, // Whiteriver Airport
    Airport{IataCode{"WTT"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wantoat Airport
    Airport{IataCode{"WTZ"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Whitianga Aerodrome
    Airport{IataCode{"WUA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Wuhai Airport
    Airport{IataCode{"WUD"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Wudinna Airport
    Airport{IataCode{"WUG"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wau Airport, Papua New Guinea
    Airport{IataCode{"WUH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Wuhan Tianhe International Airport
    Airport{IataCode{"WUI"}, CountryId{"AU"}, Tz::Australia_Perth}, // Murrin Murrin Airport
    Airport{IataCode{"WUN"}, CountryId{"AU"}, Tz::Australia_Perth}, // Wiluna Airport
    Airport{IataCode{"WUS"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Wuyishan Airport
    Airport{IataCode{"WUT"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xinzhou Wutaishan Airport
    Airport{IataCode{"WUU"}, CountryId{"SS"}, Tz::Africa_Juba}, // Wau Airport
    Airport{IataCode{"WUV"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wuvulu Island Airport
    Airport{IataCode{"WUX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Sunan Shuofang International Airport
    Airport{IataCode{"WUZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Wuzhou Xijiang Airport
    Airport{IataCode{"WVB"}, CountryId{"NA"}, Tz::Africa_Windhoek}, // Walvis Bay Airport
    Airport{IataCode{"WVI"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Watsonville Municipal Airport
    Airport{IataCode{"WVK"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Manakara Airport
    Airport{IataCode{"WVL"}, CountryId{"US"}, Tz::America_New_York}, // Waterville Robert LaFleur Airport
    Airport{IataCode{"WWA"}, CountryId{"US"}, Tz::America_Anchorage}, // Wasilla Airport
    Airport{IataCode{"WWD"}, CountryId{"US"}, Tz::America_New_York}, // Cape May Airport
    Airport{IataCode{"WWK"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Wewak Airport
    Airport{IataCode{"WWP"}, CountryId{"US"}, Tz::America_Sitka}, // North Whale Seaplane Base
    Airport{IataCode{"WWR"}, CountryId{"US"}, Tz::America_Chicago}, // West Woodward Airport
    Airport{IataCode{"WWT"}, CountryId{"US"}, Tz::America_Nome}, // Newtok Airport
    Airport{IataCode{"WWY"}, CountryId{"AU"}, Tz::Australia_Sydney}, // West Wyalong Airport
    Airport{IataCode{"WXN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Wanzhou Wuqiao Airport
    Airport{IataCode{"WYA"}, CountryId{"AU"}, Tz::Australia_Adelaide}, // Whyalla Airport
    Airport{IataCode{"WYE"}, CountryId{"SL"}, Tz::Africa_Freetown}, // Yengema Airport
    Airport{IataCode{"WYK"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Gatot Subrato Airport
    Airport{IataCode{"WYN"}, CountryId{"AU"}, Tz::Australia_Perth}, // Wyndham Airport
    Airport{IataCode{"WYS"}, CountryId{"US"}, Tz::America_Denver}, // Yellowstone Airport
    Airport{IataCode{"WZA"}, CountryId{"GH"}, Tz::Africa_Accra}, // Wa Airport
    Airport{IataCode{"XAI"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xinyang Minggang Airport
    Airport{IataCode{"XAP"}, CountryId{"BR"}, Tz::America_Sao_Paulo}, // Chapecó Airport
    Airport{IataCode{"XAR"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Aribinda Airport
    Airport{IataCode{"XAU"}, CountryId{"FR"}, Tz::America_Cayenne}, // Saül Airport
    Airport{IataCode{"XBE"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Bearskin Lake Airport
    Airport{IataCode{"XBG"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Bogande Airport
    Airport{IataCode{"XBJ"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Birjand International Airport
    Airport{IataCode{"XBO"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Boulsa Airport
    Airport{IataCode{"XBP"}, CountryId{"US"}, Tz::America_Chicago}, // Bridgeport Municipal Airport
    Airport{IataCode{"XBR"}, CountryId{"CA"}, Tz::America_Toronto}, // Brockville-Thousand Islands Regional Tackaberry Airport
    Airport{IataCode{"XCD"}, CountryId{"FR"}, Tz::Europe_Paris}, // Chalon – Champforgeuil Airport
    Airport{IataCode{"XCH"}, CountryId{"AU"}, Tz::Indian_Christmas}, // Christmas Island Airport
    Airport{IataCode{"XCM"}, CountryId{"CA"}, Tz::America_Toronto}, // Chatham-Kent Airport
    Airport{IataCode{"XCR"}, CountryId{"FR"}, Tz::Europe_Paris}, // Châlons Vatry Airport
    Airport{IataCode{"XDE"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Diebougou Airport
    Airport{IataCode{"XDJ"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Djibo Airport
    Airport{IataCode{"XES"}, CountryId{"US"}, Tz::America_Chicago}, // Grand Geneva Resort Airport
    Airport{IataCode{"XFN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xiangyang Liuji Airport
    Airport{IataCode{"XGA"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Gaoua Airport
    Airport{IataCode{"XGG"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Gorom Gorom Airport
    Airport{IataCode{"XGN"}, CountryId{"AO"}, Tz::Africa_Luanda}, // Xangongo Airport
    Airport{IataCode{"XGR"}, CountryId{"CA"}, Tz::America_Toronto}, // Kangiqsualujjuaq (Georges River) Airport
    Airport{IataCode{"XIC"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xichang Qingshan Airport
    Airport{IataCode{"XIE"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Xienglom
    Airport{IataCode{"XIL"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xilinhot Airport
    Airport{IataCode{"XIY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xi'an Xianyang International Airport
    Airport{IataCode{"XJM"}, CountryId{"PK"}, Tz::Asia_Karachi}, // Mangla Airport
    Airport{IataCode{"XKA"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Kantchari Airport
    Airport{IataCode{"XKH"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Xieng Khouang Airport
    Airport{IataCode{"XKS"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Kasabonika Airport
    Airport{IataCode{"XKY"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Kaya Airport
    Airport{IataCode{"XLB"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Lac Brochet Airport
    Airport{IataCode{"XLL"}, CountryId{"US"}, Tz::America_New_York}, // Greensboro North Airport
    Airport{IataCode{"XLS"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Saint-Louis Airport
    Airport{IataCode{"XLU"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Leo Airport
    Airport{IataCode{"XMC"}, CountryId{"AU"}, Tz::Australia_Melbourne}, // Mallacoota Airport
    Airport{IataCode{"XMD"}, CountryId{"US"}, Tz::America_Chicago}, // Madison Municipal Airport
    Airport{IataCode{"XMF"}, CountryId{"FR"}, Tz::Europe_Paris}, // Montbéliard – Courcelles Aerodrome
    Airport{IataCode{"XMG"}, CountryId{"NP"}, Tz::Asia_Kathmandu}, // Mahendranagar Airport
    Airport{IataCode{"XMH"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Manihi Airport
    Airport{IataCode{"XMI"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Masasi Airport
    Airport{IataCode{"XMN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xiamen Gaoqi International Airport
    Airport{IataCode{"XMP"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Macmillian Pass Airport
    Airport{IataCode{"XMS"}, CountryId{"EC"}, Tz::America_Guayaquil}, // Edmundo Carvajal Airport
    Airport{IataCode{"XMY"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Yam Island Airport
    Airport{IataCode{"XNA"}, CountryId{"US"}, Tz::America_Chicago}, // Northwest Arkansas Regional Airport
    Airport{IataCode{"XNN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xining Caojiabao Airport
    Airport{IataCode{"XNO"}, CountryId{"US"}, Tz::America_New_York}, // North Auxiliary Airfield
    Airport{IataCode{"XNT"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xingtai Dalian Airport
    Airport{IataCode{"XNU"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Nouna Airport
    Airport{IataCode{"XPA"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Pama Airport
    Airport{IataCode{"XPK"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Pukatawagan Airport
    Airport{IataCode{"XPP"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Poplar River Airport
    Airport{IataCode{"XPR"}, CountryId{"US"}, Tz::America_Denver}, // Pine Ridge Airport
    Airport{IataCode{"XQP"}, CountryId{"CR"}, Tz::America_Costa_Rica}, // Quepos La Managua Airport
    Airport{IataCode{"XQU"}, CountryId{"CA"}, Tz::America_Vancouver}, // Qualicum Beach Airport
    Airport{IataCode{"XRQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xinbarag Youqi Baogede Airport
    Airport{IataCode{"XRR"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Ross River Airport
    Airport{IataCode{"XRY"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Jerez Airport
    Airport{IataCode{"XSA"}, CountryId{"US"}, Tz::America_New_York}, // Tappahannock-Essex County Airport
    Airport{IataCode{"XSB"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Sir Bani Yas Airport
    Airport{IataCode{"XSC"}, CountryId{"GB"}, Tz::America_Grand_Turk}, // South Caicos Airport
    Airport{IataCode{"XSD"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Tonopah Test Range Airport
    Airport{IataCode{"XSE"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Sebba Airport
    Airport{IataCode{"XSI"}, CountryId{"CA"}, Tz::America_Winnipeg}, // South Indian Lake Airport
    Airport{IataCode{"XSJ"}, CountryId{"FR"}, Tz::Europe_Paris}, // Peronne-St Quentin Airport
    Airport{IataCode{"XSP"}, CountryId{"SG"}, Tz::Asia_Singapore}, // Seletar Airport
    Airport{IataCode{"XTG"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Thargomindah Airport
    Airport{IataCode{"XTL"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Tadoule Lake Airport
    Airport{IataCode{"XTO"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Taroom Airport
    Airport{IataCode{"XUD"}, CountryId{"GB"}, Tz::Europe_London}, // Cranfield Airport
    Airport{IataCode{"XUZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Xuzhou Guanyin Airport
    Airport{IataCode{"XVS"}, CountryId{"FR"}, Tz::Europe_Paris}, // Valenciennes-Denain Airport
    Airport{IataCode{"XWA"}, CountryId{"US"}, Tz::America_Chicago}, // Williston Basin International Airport
    Airport{IataCode{"XYA"}, CountryId{"SB"}, Tz::Pacific_Guadalcanal}, // Yandina Airport
    Airport{IataCode{"XYE"}, CountryId{"MM"}, Tz::Asia_Yangon}, // Ye Airport
    Airport{IataCode{"XYR"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Yellow River
    Airport{IataCode{"XZA"}, CountryId{"BF"}, Tz::Africa_Ouagadougou}, // Zabré Airport
    Airport{IataCode{"YAA"}, CountryId{"CA"}, Tz::America_Vancouver}, // Anahim Lake Airport
    Airport{IataCode{"YAB"}, CountryId{"CA"}, Tz::America_Rankin_Inlet}, // Arctic Bay Airport
    Airport{IataCode{"YAC"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Cat Lake Airport
    Airport{IataCode{"YAG"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Fort Frances Municipal Airport
    Airport{IataCode{"YAH"}, CountryId{"CA"}, Tz::America_Toronto}, // La Grande-4 Airport
    Airport{IataCode{"YAI"}, CountryId{"CL"}, Tz::America_Santiago}, // General Bernardo O'Higgins Airport
    Airport{IataCode{"YAK"}, CountryId{"US"}, Tz::America_Yakutat}, // Yakutat Airport
    Airport{IataCode{"YAL"}, CountryId{"CA"}, Tz::America_Vancouver}, // Alert Bay Airport
    Airport{IataCode{"YAM"}, CountryId{"CA"}, Tz::America_Toronto}, // Sault Ste. Marie Airport
    Airport{IataCode{"YAN"}, CountryId{"CD"}, Tz::Africa_Lubumbashi}, // Yangambi Airport
    Airport{IataCode{"YAO"}, CountryId{"CM"}, Tz::Africa_Douala}, // Yaoundé Airport
    Airport{IataCode{"YAP"}, CountryId{"FM"}, Tz::Pacific_Chuuk}, // Yap International Airport
    Airport{IataCode{"YAR"}, CountryId{"CA"}, Tz::America_Toronto}, // La Grande-3 Airport
    Airport{IataCode{"YAS"}, CountryId{"FJ"}, Tz::Pacific_Fiji}, // Yasawa Island Airport
    Airport{IataCode{"YAT"}, CountryId{"CA"}, Tz::America_Toronto}, // Attawapiskat Airport
    Airport{IataCode{"YAU"}, CountryId{"CA"}, Tz::America_Toronto}, // Kattiniq/Donaldson Airport
    Airport{IataCode{"YAX"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Angling Lake/Wapekeka Airport
    Airport{IataCode{"YAY"}, CountryId{"CA"}, Tz::America_St_Johns}, // St. Anthony Airport
    Airport{IataCode{"YAZ"}, CountryId{"CA"}, Tz::America_Vancouver}, // Tofino/Long Beach Airport
    Airport{IataCode{"YBA"}, CountryId{"CA"}, Tz::America_Edmonton}, // Banff Airport
    Airport{IataCode{"YBB"}, CountryId{"CA"}, Tz::America_Cambridge_Bay}, // Kugaaruk Airport
    Airport{IataCode{"YBC"}, CountryId{"CA"}, Tz::America_Toronto}, // Baie-Comeau Airport
    Airport{IataCode{"YBE"}, CountryId{"CA"}, Tz::America_Regina}, // Uranium City Airport
    Airport{IataCode{"YBF"}, CountryId{"CA"}, Tz::America_Vancouver}, // Bamfield Water Aerodrome
    Airport{IataCode{"YBG"}, CountryId{"CA"}, Tz::America_Toronto}, // Bagotville Airport
    Airport{IataCode{"YBI"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Black Tickle Airport
    Airport{IataCode{"YBJ"}, CountryId{"CA"}, Tz::America_Toronto}, // Baie-Johan-Beetz Seaplane Base
    Airport{IataCode{"YBK"}, CountryId{"CA"}, Tz::America_Rankin_Inlet}, // Baker Lake Airport
    Airport{IataCode{"YBL"}, CountryId{"CA"}, Tz::America_Vancouver}, // Campbell River Airport
    Airport{IataCode{"YBO"}, CountryId{"CA"}, Tz::America_Vancouver}, // Bob Quinn Lake Airport
    Airport{IataCode{"YBP"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yibin Wuliangye Airport
    Airport{IataCode{"YBR"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Brandon Municipal Airport
    Airport{IataCode{"YBS"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Opapimiskan Lake Airport
    Airport{IataCode{"YBT"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Brochet Airport
    Airport{IataCode{"YBV"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Berens River Airport
    Airport{IataCode{"YBW"}, CountryId{"CA"}, Tz::America_Vancouver}, // Bedwell Harbour Water Aerodrome
    Airport{IataCode{"YBX"}, CountryId{"CA"}, Tz::America_Blanc_Sablon}, // Lourdes-de-Blanc-Sablon Airport
    Airport{IataCode{"YBY"}, CountryId{"CA"}, Tz::America_Edmonton}, // Bonnyville Airport
    Airport{IataCode{"YCA"}, CountryId{"CA"}, Tz::America_Vancouver}, // Courtenay Airpark
    Airport{IataCode{"YCC"}, CountryId{"CA"}, Tz::America_Toronto}, // Cornwall Regional Airport
    Airport{IataCode{"YCD"}, CountryId{"CA"}, Tz::America_Vancouver}, // Nanaimo Airport
    Airport{IataCode{"YCF"}, CountryId{"CA"}, Tz::America_Vancouver}, // Cortes Island (Hansen Airfield) Airport
    Airport{IataCode{"YCG"}, CountryId{"CA"}, Tz::America_Vancouver}, // West Kootenay Regional Airport
    Airport{IataCode{"YCH"}, CountryId{"CA"}, Tz::America_Moncton}, // Miramichi Airport
    Airport{IataCode{"YCK"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Colville Lake Airport
    Airport{IataCode{"YCL"}, CountryId{"CA"}, Tz::America_Moncton}, // Charlo Airport
    Airport{IataCode{"YCM"}, CountryId{"CA"}, Tz::America_Toronto}, // St. Catharines/Niagara District Airport
    Airport{IataCode{"YCN"}, CountryId{"CA"}, Tz::America_Toronto}, // Cochrane Airport
    Airport{IataCode{"YCO"}, CountryId{"CA"}, Tz::America_Cambridge_Bay}, // Kugluktuk Airport
    Airport{IataCode{"YCQ"}, CountryId{"CA"}, Tz::America_Dawson_Creek}, // Chetwynd Airport
    Airport{IataCode{"YCR"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Cross Lake Airport
    Airport{IataCode{"YCS"}, CountryId{"CA"}, Tz::America_Rankin_Inlet}, // Chesterfield Inlet Airport
    Airport{IataCode{"YCT"}, CountryId{"CA"}, Tz::America_Edmonton}, // Coronation Airport
    Airport{IataCode{"YCU"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yuncheng Guangong Airport
    Airport{IataCode{"YCW"}, CountryId{"CA"}, Tz::America_Vancouver}, // Chilliwack Airport
    Airport{IataCode{"YCY"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Clyde River Airport
    Airport{IataCode{"YCZ"}, CountryId{"CA"}, Tz::America_Edmonton}, // Fairmont Hot Springs Airport
    Airport{IataCode{"YDA"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Dawson City Airport
    Airport{IataCode{"YDB"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Burwash Airport
    Airport{IataCode{"YDC"}, CountryId{"CA"}, Tz::America_Edmonton}, // Drayton Valley Industrial Airport
    Airport{IataCode{"YDF"}, CountryId{"CA"}, Tz::America_St_Johns}, // Deer Lake Regional Airport
    Airport{IataCode{"YDG"}, CountryId{"CA"}, Tz::America_Halifax}, // Digby/Annapolis Regional Airport
    Airport{IataCode{"YDJ"}, CountryId{"CA"}, Tz::America_Regina}, // Hatchet Lake Airport
    Airport{IataCode{"YDL"}, CountryId{"CA"}, Tz::America_Vancouver}, // Dease Lake Airport
    Airport{IataCode{"YDO"}, CountryId{"CA"}, Tz::America_Toronto}, // Dolbeau-Saint-Félicien Airport
    Airport{IataCode{"YDP"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Nain Airport
    Airport{IataCode{"YDQ"}, CountryId{"CA"}, Tz::America_Dawson_Creek}, // Dawson Creek Airport
    Airport{IataCode{"YDT"}, CountryId{"CA"}, Tz::America_Vancouver}, // Boundary Bay Airport
    Airport{IataCode{"YDU"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Kasba Lake Airport
    Airport{IataCode{"YDV"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Bloodvein River Airport
    Airport{IataCode{"YDW"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Obre Lake/North of Sixty Airport
    Airport{IataCode{"YEA"}, CountryId{"CA"}, Tz::America_Regina}, // Empress Airport
    Airport{IataCode{"YEB"}, CountryId{"CA"}, Tz::America_Toronto}, // Bar River Airport
    Airport{IataCode{"YEE"}, CountryId{"CA"}, Tz::America_Toronto}, // Midland/Huronia Airport
    Airport{IataCode{"YEG"}, CountryId{"CA"}, Tz::America_Edmonton}, // Edmonton International Airport
    Airport{IataCode{"YEH"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Asalouyeh Airport
    Airport{IataCode{"YEK"}, CountryId{"CA"}, Tz::America_Rankin_Inlet}, // Arviat Airport
    Airport{IataCode{"YEL"}, CountryId{"CA"}, Tz::America_Toronto}, // Elliot Lake Municipal Airport
    Airport{IataCode{"YEM"}, CountryId{"CA"}, Tz::America_Toronto}, // Manitowaning/Manitoulin East Municipal Airport
    Airport{IataCode{"YEN"}, CountryId{"CA"}, Tz::America_Regina}, // Estevan Regional Aerodrome
    Airport{IataCode{"YEQ"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Yenkis
    Airport{IataCode{"YER"}, CountryId{"CA"}, Tz::America_Toronto}, // Fort Severn Airport
    Airport{IataCode{"YES"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Yasuj Airport
    Airport{IataCode{"YET"}, CountryId{"CA"}, Tz::America_Edmonton}, // Edson Airport
    Airport{IataCode{"YEU"}, CountryId{"CA"}, Tz::America_Rankin_Inlet}, // Eureka Aerodrome
    Airport{IataCode{"YEV"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Inuvik (Mike Zubko) Airport
    Airport{IataCode{"YEY"}, CountryId{"CA"}, Tz::America_Toronto}, // Amos/Magny Airport
    Airport{IataCode{"YFA"}, CountryId{"CA"}, Tz::America_Toronto}, // Fort Albany Airport
    Airport{IataCode{"YFB"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Iqaluit Airport
    Airport{IataCode{"YFC"}, CountryId{"CA"}, Tz::America_Moncton}, // Fredericton International Airport
    Airport{IataCode{"YFD"}, CountryId{"CA"}, Tz::America_Toronto}, // Bradford Aerodrome
    Airport{IataCode{"YFE"}, CountryId{"CA"}, Tz::America_Toronto}, // Forestville Airport
    Airport{IataCode{"YFG"}, CountryId{"CA"}, Tz::America_Toronto}, // Fontages Airport
    Airport{IataCode{"YFH"}, CountryId{"CA"}, Tz::America_Toronto}, // Fort Hope Airport
    Airport{IataCode{"YFI"}, CountryId{"CA"}, Tz::America_Edmonton}, // Fort MacKay/Firebag Aerodrome
    Airport{IataCode{"YFJ"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Wekweètì Airport
    Airport{IataCode{"YFL"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Fort Reliance Water Aerodrome
    Airport{IataCode{"YFO"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Flin Flon Airport
    Airport{IataCode{"YFR"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Fort Resolution Airport
    Airport{IataCode{"YFS"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Fort Simpson Airport
    Airport{IataCode{"YFX"}, CountryId{"CA"}, Tz::America_St_Johns}, // St. Lewis (Fox Harbour) Airport
    Airport{IataCode{"YGB"}, CountryId{"CA"}, Tz::America_Vancouver}, // Texada/Gillies Bay Airport
    Airport{IataCode{"YGC"}, CountryId{"CA"}, Tz::America_Edmonton}, // Grande Cache Airport
    Airport{IataCode{"YGG"}, CountryId{"CA"}, Tz::America_Vancouver}, // Ganges Water Aerodrome
    Airport{IataCode{"YGH"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Fort Good Hope Airport
    Airport{IataCode{"YGJ"}, CountryId{"JP"}, Tz::Asia_Tokyo}, // Miho-Yonago Airport
    Airport{IataCode{"YGK"}, CountryId{"CA"}, Tz::America_Toronto}, // Kingston/Norman Rogers Airport
    Airport{IataCode{"YGL"}, CountryId{"CA"}, Tz::America_Toronto}, // La Grande Rivière Airport
    Airport{IataCode{"YGM"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Gimli Industrial Park Airport
    Airport{IataCode{"YGO"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Gods Lake Narrows Airport
    Airport{IataCode{"YGP"}, CountryId{"CA"}, Tz::America_Toronto}, // Michel-Pouliot Gaspé Airport
    Airport{IataCode{"YGQ"}, CountryId{"CA"}, Tz::America_Toronto}, // Geraldton (Greenstone Regional) Airport
    Airport{IataCode{"YGR"}, CountryId{"CA"}, Tz::America_Halifax}, // Îles-de-la-Madeleine Airport
    Airport{IataCode{"YGT"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Igloolik Airport
    Airport{IataCode{"YGV"}, CountryId{"CA"}, Tz::America_Toronto}, // Havre Saint-Pierre Airport
    Airport{IataCode{"YGW"}, CountryId{"CA"}, Tz::America_Toronto}, // Kuujjuarapik Airport
    Airport{IataCode{"YGX"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Gillam Airport
    Airport{IataCode{"YGZ"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Grise Fiord Airport
    Airport{IataCode{"YHA"}, CountryId{"CA"}, Tz::America_St_Johns}, // Port Hope Simpson Airport
    Airport{IataCode{"YHB"}, CountryId{"CA"}, Tz::America_Regina}, // Hudson Bay Airport
    Airport{IataCode{"YHD"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Dryden Regional Airport
    Airport{IataCode{"YHE"}, CountryId{"CA"}, Tz::America_Vancouver}, // Hope Aerodrome
    Airport{IataCode{"YHF"}, CountryId{"CA"}, Tz::America_Toronto}, // Hearst (René Fontaine) Municipal Airport
    Airport{IataCode{"YHG"}, CountryId{"CA"}, Tz::America_St_Johns}, // Charlottetown Airport (Labrador)
    Airport{IataCode{"YHH"}, CountryId{"CA"}, Tz::America_Vancouver}, // Campbell River Water Aerodrome
    Airport{IataCode{"YHI"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Ulukhaktok/Holman Airport
    Airport{IataCode{"YHK"}, CountryId{"CA"}, Tz::America_Cambridge_Bay}, // Gjoa Haven Airport
    Airport{IataCode{"YHM"}, CountryId{"CA"}, Tz::America_Toronto}, // John C. Munro Hamilton International Airport
    Airport{IataCode{"YHN"}, CountryId{"CA"}, Tz::America_Toronto}, // Hornepayne Municipal Airport
    Airport{IataCode{"YHO"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Hopedale Airport
    Airport{IataCode{"YHP"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Poplar Hill Airport
    Airport{IataCode{"YHR"}, CountryId{"CA"}, Tz::America_Blanc_Sablon}, // Chevery Airport
    Airport{IataCode{"YHS"}, CountryId{"CA"}, Tz::America_Vancouver}, // Sechelt Aerodrome
    Airport{IataCode{"YHT"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Haines Junction Airport
    Airport{IataCode{"YHU"}, CountryId{"CA"}, Tz::America_Toronto}, // Montréal/Saint-Hubert Airport
    Airport{IataCode{"YHY"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Hay River/Merlyn Carter Airport
    Airport{IataCode{"YHZ"}, CountryId{"CA"}, Tz::America_Halifax}, // Halifax Stanfield International Airport
    Airport{IataCode{"YIA"}, CountryId{"ID"}, Tz::Asia_Jakarta}, // Yogyakarta International Airport
    Airport{IataCode{"YIB"}, CountryId{"CA"}, Tz::America_Atikokan}, // Atikokan Municipal Airport
    Airport{IataCode{"YIC"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yichun Mingyueshan Airport
    Airport{IataCode{"YIE"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Arxan Yi'ershi Airport
    Airport{IataCode{"YIF"}, CountryId{"CA"}, Tz::America_Blanc_Sablon}, // Saint-Augustin Airport
    Airport{IataCode{"YIH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yichang Airport
    Airport{IataCode{"YIK"}, CountryId{"CA"}, Tz::America_Toronto}, // Ivujivik Airport
    Airport{IataCode{"YIN"}, CountryId{"CN"}, Tz::Asia_Urumqi}, // Yining Airport
    Airport{IataCode{"YIO"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Pond Inlet Airport
    Airport{IataCode{"YIP"}, CountryId{"US"}, Tz::America_Detroit}, // Willow Run Airport
    Airport{IataCode{"YIV"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Island Lake Airport
    Airport{IataCode{"YIW"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yiwu Airport
    Airport{IataCode{"YJA"}, CountryId{"CA"}, Tz::America_Edmonton}, // Jasper Airport
    Airport{IataCode{"YJF"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Fort Liard Airport
    Airport{IataCode{"YJM"}, CountryId{"CA"}, Tz::America_Vancouver}, // Fort St. James (Perison) Airport
    Airport{IataCode{"YJN"}, CountryId{"CA"}, Tz::America_Toronto}, // Saint-Jean Airport
    Airport{IataCode{"YJP"}, CountryId{"CA"}, Tz::America_Edmonton}, // Hinton/Jasper-Hinton Airport
    Airport{IataCode{"YJS"}, CountryId{"KP"}, Tz::Asia_Pyongyang}, // Samjiyŏn Airport
    Airport{IataCode{"YJT"}, CountryId{"CA"}, Tz::America_St_Johns}, // Stephenville International Airport
    Airport{IataCode{"YKA"}, CountryId{"CA"}, Tz::America_Vancouver}, // Kamloops Airport
    Airport{IataCode{"YKC"}, CountryId{"CA"}, Tz::America_Regina}, // Collins Bay Airport
    Airport{IataCode{"YKD"}, CountryId{"CA"}, Tz::America_Toronto}, // Kincardine Airport
    Airport{IataCode{"YKE"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Knee Lake Airport
    Airport{IataCode{"YKF"}, CountryId{"CA"}, Tz::America_Toronto}, // Region of Waterloo International Airport
    Airport{IataCode{"YKG"}, CountryId{"CA"}, Tz::America_Toronto}, // Kangirsuk Airport
    Airport{IataCode{"YKH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yingkou Lanqi Airport
    Airport{IataCode{"YKJ"}, CountryId{"CA"}, Tz::America_Regina}, // Key Lake Airport
    Airport{IataCode{"YKK"}, CountryId{"CA"}, Tz::America_Vancouver}, // Kitkatla Water Aerodrome
    Airport{IataCode{"YKL"}, CountryId{"CA"}, Tz::America_Toronto}, // Schefferville Airport
    Airport{IataCode{"YKM"}, CountryId{"US"}, Tz::America_Los_Angeles}, // Yakima Air Terminal
    Airport{IataCode{"YKN"}, CountryId{"US"}, Tz::America_Chicago}, // Chan Gurney Municipal Airport
    Airport{IataCode{"YKO"}, CountryId{"TR"}, Tz::Europe_Istanbul}, // Hakkari Yüksekova Airport
    Airport{IataCode{"YKQ"}, CountryId{"CA"}, Tz::America_Toronto}, // Waskaganish Airport
    Airport{IataCode{"YKS"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Yakutsk Airport
    Airport{IataCode{"YKU"}, CountryId{"CA"}, Tz::America_Toronto}, // Chisasibi Airport
    Airport{IataCode{"YKX"}, CountryId{"CA"}, Tz::America_Toronto}, // Kirkland Lake Airport
    Airport{IataCode{"YKY"}, CountryId{"CA"}, Tz::America_Regina}, // Kindersley Regional Airport
    Airport{IataCode{"YKZ"}, CountryId{"CA"}, Tz::America_Toronto}, // Buttonville Municipal Airport
    Airport{IataCode{"YLB"}, CountryId{"CA"}, Tz::America_Edmonton}, // Lac La Biche Airport
    Airport{IataCode{"YLC"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Kimmirut Airport
    Airport{IataCode{"YLD"}, CountryId{"CA"}, Tz::America_Toronto}, // Chapleau Airport
    Airport{IataCode{"YLE"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Whatì Airport
    Airport{IataCode{"YLG"}, CountryId{"AU"}, Tz::Australia_Perth}, // Yalgoo Airport
    Airport{IataCode{"YLH"}, CountryId{"CA"}, Tz::America_Toronto}, // Lansdowne House Airport
    Airport{IataCode{"YLJ"}, CountryId{"CA"}, Tz::America_Regina}, // Meadow Lake Airport
    Airport{IataCode{"YLK"}, CountryId{"CA"}, Tz::America_Toronto}, // Lake Simcoe Regional Airport
    Airport{IataCode{"YLL"}, CountryId{"CA"}, Tz::America_Edmonton}, // Lloydminster Airport
    Airport{IataCode{"YLN"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yilan Airport
    Airport{IataCode{"YLP"}, CountryId{"CA"}, Tz::America_Toronto}, // Mingan Airport
    Airport{IataCode{"YLQ"}, CountryId{"CA"}, Tz::America_Toronto}, // La Tuque Airport
    Airport{IataCode{"YLR"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Leaf Rapids Airport
    Airport{IataCode{"YLS"}, CountryId{"CA"}, Tz::America_Toronto}, // Lebel-sur-Quévillon Airport
    Airport{IataCode{"YLT"}, CountryId{"CA"}, Tz::America_Pangnirtung}, // Alert Airport
    Airport{IataCode{"YLV"}, CountryId{"AZ"}, Tz::Asia_Baku}, // Yevlakh Airport
    Airport{IataCode{"YLW"}, CountryId{"CA"}, Tz::America_Vancouver}, // Kelowna International Airport
    Airport{IataCode{"YLX"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yulin Fumian Airport
    Airport{IataCode{"YLY"}, CountryId{"CA"}, Tz::America_Vancouver}, // Langley Regional Airport
    Airport{IataCode{"YMA"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Mayo Airport
    Airport{IataCode{"YMB"}, CountryId{"CA"}, Tz::America_Vancouver}, // Merritt Airport
    Airport{IataCode{"YMD"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Mould Bay Airport
    Airport{IataCode{"YME"}, CountryId{"CA"}, Tz::America_Toronto}, // Matane Airport
    Airport{IataCode{"YMG"}, CountryId{"CA"}, Tz::America_Toronto}, // Manitouwadge Airport
    Airport{IataCode{"YMH"}, CountryId{"CA"}, Tz::America_St_Johns}, // Mary's Harbour Airport
    Airport{IataCode{"YML"}, CountryId{"CA"}, Tz::America_Toronto}, // Charlevoix Airport
    Airport{IataCode{"YMM"}, CountryId{"CA"}, Tz::America_Edmonton}, // Fort McMurray International Airport
    Airport{IataCode{"YMN"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Makkovik Airport
    Airport{IataCode{"YMO"}, CountryId{"CA"}, Tz::America_Toronto}, // Moosonee Airport
    Airport{IataCode{"YMP"}, CountryId{"CA"}, Tz::America_Vancouver}, // Port McNeill Airport
    Airport{IataCode{"YMS"}, CountryId{"PE"}, Tz::America_Lima}, // Moisés Benzaquén Rengifo Airport
    Airport{IataCode{"YMT"}, CountryId{"CA"}, Tz::America_Toronto}, // Chibougamau/Chapais Airport
    Airport{IataCode{"YMU"}, CountryId{"CA"}, Tz::America_Vancouver}, // Mansons Landing Water Aerodrome
    Airport{IataCode{"YMV"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Mary River Aerodrome
    Airport{IataCode{"YMW"}, CountryId{"CA"}, Tz::America_Toronto}, // Maniwaki Airport
    Airport{IataCode{"YMX"}, CountryId{"CA"}, Tz::America_Toronto}, // Montréal–Mirabel International Airport
    Airport{IataCode{"YNA"}, CountryId{"CA"}, Tz::America_Toronto}, // Natashquan Airport
    Airport{IataCode{"YNB"}, CountryId{"SA"}, Tz::Asia_Riyadh}, // Yanbu Airport
    Airport{IataCode{"YNC"}, CountryId{"CA"}, Tz::America_Toronto}, // Wemindji Airport
    Airport{IataCode{"YND"}, CountryId{"CA"}, Tz::America_Toronto}, // Gatineau-Ottawa Executive Airport
    Airport{IataCode{"YNE"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Norway House Airport
    Airport{IataCode{"YNG"}, CountryId{"US"}, Tz::America_New_York}, // Youngstown-Warren Regional Airport
    Airport{IataCode{"YNH"}, CountryId{"CA"}, Tz::America_Dawson_Creek}, // Hudson's Hope Airport
    Airport{IataCode{"YNJ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yanji Chaoyangchuan Airport
    Airport{IataCode{"YNL"}, CountryId{"CA"}, Tz::America_Regina}, // Points North Landing Airport
    Airport{IataCode{"YNM"}, CountryId{"CA"}, Tz::America_Toronto}, // Matagami Airport
    Airport{IataCode{"YNO"}, CountryId{"CA"}, Tz::America_Winnipeg}, // North Spirit Lake Airport
    Airport{IataCode{"YNP"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Natuashish Airport
    Airport{IataCode{"YNS"}, CountryId{"CA"}, Tz::America_Toronto}, // Nemiscau Airport
    Airport{IataCode{"YNT"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yantai Penglai International Airport
    Airport{IataCode{"YNX"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Snap Lake Airport
    Airport{IataCode{"YNY"}, CountryId{"KR"}, Tz::Asia_Seoul}, // Yangyang International Airport
    Airport{IataCode{"YNZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yancheng Nanyang Airport
    Airport{IataCode{"YOA"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Ekati Airport
    Airport{IataCode{"YOC"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Old Crow Airport
    Airport{IataCode{"YOE"}, CountryId{"CA"}, Tz::America_Edmonton}, // Donnelly Airport
    Airport{IataCode{"YOG"}, CountryId{"CA"}, Tz::America_Toronto}, // Ogoki Post Airport
    Airport{IataCode{"YOH"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Oxford House Airport
    Airport{IataCode{"YOJ"}, CountryId{"CA"}, Tz::America_Edmonton}, // High Level Airport
    Airport{IataCode{"YOL"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Yola Airport
    Airport{IataCode{"YON"}, CountryId{"BT"}, Tz::Asia_Thimphu}, // Yongphulla Airport
    Airport{IataCode{"YOO"}, CountryId{"CA"}, Tz::America_Toronto}, // Oshawa Airport
    Airport{IataCode{"YOP"}, CountryId{"CA"}, Tz::America_Edmonton}, // Rainbow Lake Airport
    Airport{IataCode{"YOS"}, CountryId{"CA"}, Tz::America_Toronto}, // Owen Sound Billy Bishop Regional Airport
    Airport{IataCode{"YOT"}, CountryId{"IL"}, Tz::Asia_Jerusalem}, // Yotvata Airfield
    Airport{IataCode{"YOW"}, CountryId{"CA"}, Tz::America_Toronto}, // Ottawa Macdonald-Cartier International Airport
    Airport{IataCode{"YPA"}, CountryId{"CA"}, Tz::America_Regina}, // Prince Albert (Glass Field) Airport
    Airport{IataCode{"YPB"}, CountryId{"CA"}, Tz::America_Vancouver}, // Port Alberni (Alberni Valley Regional) Airport
    Airport{IataCode{"YPC"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Paulatuk (Nora Aliqatchialuk Ruben) Airport
    Airport{IataCode{"YPD"}, CountryId{"CA"}, Tz::America_Toronto}, // Parry Sound Area Municipal Airport
    Airport{IataCode{"YPE"}, CountryId{"CA"}, Tz::America_Edmonton}, // Peace River Airport
    Airport{IataCode{"YPF"}, CountryId{"CA"}, Tz::America_Vancouver}, // Esquimalt Airport
    Airport{IataCode{"YPG"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Portage la Prairie Southport Airport
    Airport{IataCode{"YPH"}, CountryId{"CA"}, Tz::America_Toronto}, // Inukjuak Airport
    Airport{IataCode{"YPI"}, CountryId{"CA"}, Tz::America_Vancouver}, // Port Simpson Water Aerodrome
    Airport{IataCode{"YPJ"}, CountryId{"CA"}, Tz::America_Toronto}, // Aupaluk Airport
    Airport{IataCode{"YPK"}, CountryId{"CA"}, Tz::America_Vancouver}, // Pitt Meadows Airport
    Airport{IataCode{"YPL"}, CountryId{"CA"}, Tz::America_Toronto}, // Pickle Lake Airport
    Airport{IataCode{"YPM"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Pikangikum Airport
    Airport{IataCode{"YPN"}, CountryId{"CA"}, Tz::America_Toronto}, // Port-Menier Airport
    Airport{IataCode{"YPO"}, CountryId{"CA"}, Tz::America_Toronto}, // Peawanuck Airport
    Airport{IataCode{"YPQ"}, CountryId{"CA"}, Tz::America_Toronto}, // Peterborough Airport
    Airport{IataCode{"YPR"}, CountryId{"CA"}, Tz::America_Vancouver}, // Prince Rupert Airport
    Airport{IataCode{"YPS"}, CountryId{"CA"}, Tz::America_Halifax}, // Port Hawkesbury Airport
    Airport{IataCode{"YPT"}, CountryId{"CA"}, Tz::America_Vancouver}, // Pender Harbour Water Aerodrome
    Airport{IataCode{"YPW"}, CountryId{"CA"}, Tz::America_Vancouver}, // Powell River Airport
    Airport{IataCode{"YPX"}, CountryId{"CA"}, Tz::America_Toronto}, // Puvirnituq Airport
    Airport{IataCode{"YPY"}, CountryId{"CA"}, Tz::America_Edmonton}, // Fort Chipewyan Airport
    Airport{IataCode{"YPZ"}, CountryId{"CA"}, Tz::America_Vancouver}, // Burns Lake Airport
    Airport{IataCode{"YQA"}, CountryId{"CA"}, Tz::America_Toronto}, // Muskoka Airport
    Airport{IataCode{"YQB"}, CountryId{"CA"}, Tz::America_Toronto}, // Québec City Jean Lesage International Airport
    Airport{IataCode{"YQC"}, CountryId{"CA"}, Tz::America_Toronto}, // Quaqtaq Airport
    Airport{IataCode{"YQD"}, CountryId{"CA"}, Tz::America_Winnipeg}, // The Pas Airport
    Airport{IataCode{"YQF"}, CountryId{"CA"}, Tz::America_Edmonton}, // Red Deer Regional Airport
    Airport{IataCode{"YQG"}, CountryId{"CA"}, Tz::America_Toronto}, // Windsor International Airport
    Airport{IataCode{"YQH"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Watson Lake Airport
    Airport{IataCode{"YQI"}, CountryId{"CA"}, Tz::America_Halifax}, // Yarmouth Airport
    Airport{IataCode{"YQK"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Kenora Airport
    Airport{IataCode{"YQL"}, CountryId{"CA"}, Tz::America_Edmonton}, // Lethbridge Airport
    Airport{IataCode{"YQM"}, CountryId{"CA"}, Tz::America_Moncton}, // Greater Moncton International Airport
    Airport{IataCode{"YQN"}, CountryId{"CA"}, Tz::America_Toronto}, // Nakina Airport
    Airport{IataCode{"YQR"}, CountryId{"CA"}, Tz::America_Regina}, // Regina International Airport
    Airport{IataCode{"YQS"}, CountryId{"CA"}, Tz::America_Toronto}, // St. Thomas Municipal Airport
    Airport{IataCode{"YQT"}, CountryId{"CA"}, Tz::America_Thunder_Bay}, // Thunder Bay International Airport
    Airport{IataCode{"YQU"}, CountryId{"CA"}, Tz::America_Edmonton}, // Grande Prairie Airport
    Airport{IataCode{"YQV"}, CountryId{"CA"}, Tz::America_Regina}, // Yorkton Municipal Airport
    Airport{IataCode{"YQW"}, CountryId{"CA"}, Tz::America_Regina}, // North Battleford (Cameron McIntosh) Airport
    Airport{IataCode{"YQX"}, CountryId{"CA"}, Tz::America_St_Johns}, // Gander International Airport
    Airport{IataCode{"YQY"}, CountryId{"CA"}, Tz::America_Glace_Bay}, // Sydney/J.A. Douglas McCurdy Airport
    Airport{IataCode{"YQZ"}, CountryId{"CA"}, Tz::America_Vancouver}, // Quesnel Airport
    Airport{IataCode{"YRA"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Gamètì/Rae Lakes Airport
    Airport{IataCode{"YRB"}, CountryId{"CA"}, Tz::America_Resolute}, // Resolute Bay Airport
    Airport{IataCode{"YRC"}, CountryId{"CA"}, Tz::America_Toronto}, // Chicoutimi/Saint-Honoré Aerodrome
    Airport{IataCode{"YRD"}, CountryId{"CA"}, Tz::America_Vancouver}, // Dean River Airport
    Airport{IataCode{"YRF"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Cartwright Airport
    Airport{IataCode{"YRG"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Rigolet Airport
    Airport{IataCode{"YRI"}, CountryId{"CA"}, Tz::America_Toronto}, // Rivière-du-Loup Airport
    Airport{IataCode{"YRJ"}, CountryId{"CA"}, Tz::America_Toronto}, // Roberval Airport
    Airport{IataCode{"YRL"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Red Lake Airport
    Airport{IataCode{"YRM"}, CountryId{"CA"}, Tz::America_Edmonton}, // Rocky Mountain House Airport
    Airport{IataCode{"YRN"}, CountryId{"CA"}, Tz::America_Vancouver}, // Rivers Inlet Water Aerodrome
    Airport{IataCode{"YRO"}, CountryId{"CA"}, Tz::America_Toronto}, // Ottawa/Rockcliffe Airport
    Airport{IataCode{"YRP"}, CountryId{"CA"}, Tz::America_Toronto}, // Carp Airport
    Airport{IataCode{"YRQ"}, CountryId{"CA"}, Tz::America_Toronto}, // Trois-Rivières Airport
    Airport{IataCode{"YRS"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Red Sucker Lake Airport
    Airport{IataCode{"YRT"}, CountryId{"CA"}, Tz::America_Rankin_Inlet}, // Rankin Inlet Airport
    Airport{IataCode{"YRV"}, CountryId{"CA"}, Tz::America_Vancouver}, // Revelstoke Airport
    Airport{IataCode{"YSA"}, CountryId{"CA"}, Tz::America_Halifax}, // Sable Island Aerodrome
    Airport{IataCode{"YSB"}, CountryId{"CA"}, Tz::America_Toronto}, // Sudbury Airport
    Airport{IataCode{"YSC"}, CountryId{"CA"}, Tz::America_Toronto}, // Sherbrooke Airport
    Airport{IataCode{"YSE"}, CountryId{"CA"}, Tz::America_Vancouver}, // Squamish Airport
    Airport{IataCode{"YSF"}, CountryId{"CA"}, Tz::America_Regina}, // Stony Rapids Airport
    Airport{IataCode{"YSG"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Lutselk'e Airport
    Airport{IataCode{"YSH"}, CountryId{"CA"}, Tz::America_Toronto}, // Smiths Falls-Montague Airport
    Airport{IataCode{"YSJ"}, CountryId{"CA"}, Tz::America_Moncton}, // Saint John Airport
    Airport{IataCode{"YSK"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Sanikiluaq Airport
    Airport{IataCode{"YSL"}, CountryId{"CA"}, Tz::America_Moncton}, // Saint-Léonard Aerodrome
    Airport{IataCode{"YSM"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Fort Smith Airport
    Airport{IataCode{"YSN"}, CountryId{"CA"}, Tz::America_Vancouver}, // Salmon Arm Airport
    Airport{IataCode{"YSO"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Postville Airport
    Airport{IataCode{"YSP"}, CountryId{"CA"}, Tz::America_Toronto}, // Marathon Aerodrome
    Airport{IataCode{"YSQ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Songyuan Chaganhu Airport
    Airport{IataCode{"YSV"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Saglek Airport
    Airport{IataCode{"YSY"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Sachs Harbour (David Nasogaluak Jr. Saaryuaq) Airport
    Airport{IataCode{"YTA"}, CountryId{"CA"}, Tz::America_Toronto}, // Pembroke Airport
    Airport{IataCode{"YTB"}, CountryId{"CA"}, Tz::America_Vancouver}, // Hartley Bay Water Aerodrome
    Airport{IataCode{"YTD"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Thicket Portage Airport
    Airport{IataCode{"YTE"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Cape Dorset Airport
    Airport{IataCode{"YTF"}, CountryId{"CA"}, Tz::America_Toronto}, // Alma Airport
    Airport{IataCode{"YTG"}, CountryId{"CA"}, Tz::America_Vancouver}, // Sullivan Bay Water Aerodrome
    Airport{IataCode{"YTH"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Thompson Airport
    Airport{IataCode{"YTJ"}, CountryId{"CA"}, Tz::America_Toronto}, // Terrace Bay Airport
    Airport{IataCode{"YTL"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Big Trout Lake Airport
    Airport{IataCode{"YTM"}, CountryId{"CA"}, Tz::America_Toronto}, // Mont Tremblant International Airport
    Airport{IataCode{"YTN"}, CountryId{"CA"}, Tz::America_Halifax}, // Trenton Aerodrome
    Airport{IataCode{"YTP"}, CountryId{"CA"}, Tz::America_Vancouver}, // Tofino Harbour Water Aerodrome
    Airport{IataCode{"YTQ"}, CountryId{"CA"}, Tz::America_Toronto}, // Tasiujaq Airport
    Airport{IataCode{"YTS"}, CountryId{"CA"}, Tz::America_Toronto}, // Timmins/Victor M. Power Airport
    Airport{IataCode{"YTT"}, CountryId{"CA"}, Tz::America_Regina}, // Tisdale Airport
    Airport{IataCode{"YTY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yangzhou Taizhou Airport
    Airport{IataCode{"YTZ"}, CountryId{"CA"}, Tz::America_Toronto}, // Billy Bishop Toronto City Airport
    Airport{IataCode{"YUA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yuanmou Airport
    Airport{IataCode{"YUB"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Tuktoyaktuk/James Gruben Airport
    Airport{IataCode{"YUD"}, CountryId{"CA"}, Tz::America_Toronto}, // Umiujaq Airport
    Airport{IataCode{"YUE"}, CountryId{"AU"}, Tz::Australia_Darwin}, // Yuendumu Airport
    Airport{IataCode{"YUL"}, CountryId{"CA"}, Tz::America_Toronto}, // Montréal–Pierre Elliott Trudeau International Airport
    Airport{IataCode{"YUM"}, CountryId{"US"}, Tz::America_Phoenix}, // Yuma International Airport
    Airport{IataCode{"YUS"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yushu Batang Airport
    Airport{IataCode{"YUT"}, CountryId{"CA"}, Tz::America_Rankin_Inlet}, // Repulse Bay Airport
    Airport{IataCode{"YUX"}, CountryId{"CA"}, Tz::America_Iqaluit}, // Hall Beach Airport
    Airport{IataCode{"YUY"}, CountryId{"CA"}, Tz::America_Toronto}, // Rouyn-Noranda Airport
    Airport{IataCode{"YVA"}, CountryId{"KM"}, Tz::Indian_Comoro}, // Iconi Airport
    Airport{IataCode{"YVB"}, CountryId{"CA"}, Tz::America_Toronto}, // Bonaventure Airport
    Airport{IataCode{"YVC"}, CountryId{"CA"}, Tz::America_Regina}, // La Ronge (Barber Field) Airport
    Airport{IataCode{"YVD"}, CountryId{"PG"}, Tz::Pacific_Port_Moresby}, // Yeva
    Airport{IataCode{"YVE"}, CountryId{"CA"}, Tz::America_Vancouver}, // Vernon Regional Airport
    Airport{IataCode{"YVG"}, CountryId{"CA"}, Tz::America_Edmonton}, // Vermilion Airport
    Airport{IataCode{"YVM"}, CountryId{"CA"}, Tz::America_Pangnirtung}, // Qikiqtarjuaq Airport
    Airport{IataCode{"YVO"}, CountryId{"CA"}, Tz::America_Toronto}, // Val-d'Or Airport
    Airport{IataCode{"YVP"}, CountryId{"CA"}, Tz::America_Toronto}, // Kuujjuaq Airport
    Airport{IataCode{"YVQ"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Norman Wells Airport
    Airport{IataCode{"YVR"}, CountryId{"CA"}, Tz::America_Vancouver}, // Vancouver International Airport
    Airport{IataCode{"YVT"}, CountryId{"CA"}, Tz::America_Regina}, // Buffalo Narrows Airport
    Airport{IataCode{"YVV"}, CountryId{"CA"}, Tz::America_Toronto}, // Wiarton Airport
    Airport{IataCode{"YVZ"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Deer Lake Airport
    Airport{IataCode{"YWA"}, CountryId{"CA"}, Tz::America_Toronto}, // Petawawa Airport
    Airport{IataCode{"YWB"}, CountryId{"CA"}, Tz::America_Toronto}, // Kangiqsujuaq Airport
    Airport{IataCode{"YWG"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Winnipeg James Armstrong Richardson International Airport
    Airport{IataCode{"YWH"}, CountryId{"CA"}, Tz::America_Vancouver}, // Victoria Inner Harbour Airport
    Airport{IataCode{"YWJ"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Déline Airport
    Airport{IataCode{"YWK"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Wabush Airport
    Airport{IataCode{"YWL"}, CountryId{"CA"}, Tz::America_Vancouver}, // Williams Lake Airport
    Airport{IataCode{"YWM"}, CountryId{"CA"}, Tz::America_St_Johns}, // Williams Harbour Airport
    Airport{IataCode{"YWP"}, CountryId{"CA"}, Tz::America_Toronto}, // Webequie Airport
    Airport{IataCode{"YWQ"}, CountryId{"CA"}, Tz::America_Toronto}, // Chutes-des-Passes/Lac Margane Water Aerodrome
    Airport{IataCode{"YWR"}, CountryId{"CA"}, Tz::America_Toronto}, // White River Water Aerodrome
    Airport{IataCode{"YWV"}, CountryId{"CA"}, Tz::America_Edmonton}, // Wainwright Aerodrome
    Airport{IataCode{"YWY"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Wrigley Airport
    Airport{IataCode{"YXC"}, CountryId{"CA"}, Tz::America_Edmonton}, // Canadian Rockies International Airport
    Airport{IataCode{"YXE"}, CountryId{"CA"}, Tz::America_Regina}, // Saskatoon John G. Diefenbaker International Airport
    Airport{IataCode{"YXH"}, CountryId{"CA"}, Tz::America_Edmonton}, // Medicine Hat Airport
    Airport{IataCode{"YXI"}, CountryId{"CA"}, Tz::America_Toronto}, // Killaloe/Bonnechere Airport
    Airport{IataCode{"YXJ"}, CountryId{"CA"}, Tz::America_Dawson_Creek}, // Fort St. John Airport
    Airport{IataCode{"YXK"}, CountryId{"CA"}, Tz::America_Toronto}, // Rimouski Airport
    Airport{IataCode{"YXL"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Sioux Lookout Airport
    Airport{IataCode{"YXN"}, CountryId{"CA"}, Tz::America_Rankin_Inlet}, // Whale Cove Airport
    Airport{IataCode{"YXP"}, CountryId{"CA"}, Tz::America_Pangnirtung}, // Pangnirtung Airport
    Airport{IataCode{"YXQ"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Beaver Creek Airport
    Airport{IataCode{"YXR"}, CountryId{"CA"}, Tz::America_Toronto}, // Earlton (Timiskaming Regional) Airport
    Airport{IataCode{"YXS"}, CountryId{"CA"}, Tz::America_Vancouver}, // Prince George Airport
    Airport{IataCode{"YXT"}, CountryId{"CA"}, Tz::America_Vancouver}, // Northwest Regional Airport
    Airport{IataCode{"YXU"}, CountryId{"CA"}, Tz::America_Toronto}, // London International Airport
    Airport{IataCode{"YXX"}, CountryId{"CA"}, Tz::America_Vancouver}, // Abbotsford International Airport
    Airport{IataCode{"YXY"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Erik Nielsen Whitehorse International Airport
    Airport{IataCode{"YXZ"}, CountryId{"CA"}, Tz::America_Toronto}, // Wawa Airport
    Airport{IataCode{"YYA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Yueyang Sanhe Airport
    Airport{IataCode{"YYB"}, CountryId{"CA"}, Tz::America_Toronto}, // North Bay/Jack Garland Airport
    Airport{IataCode{"YYC"}, CountryId{"CA"}, Tz::America_Edmonton}, // Calgary International Airport
    Airport{IataCode{"YYD"}, CountryId{"CA"}, Tz::America_Vancouver}, // Smithers Airport
    Airport{IataCode{"YYE"}, CountryId{"CA"}, Tz::America_Fort_Nelson}, // Fort Nelson Airport
    Airport{IataCode{"YYF"}, CountryId{"CA"}, Tz::America_Vancouver}, // Penticton Regional Airport
    Airport{IataCode{"YYG"}, CountryId{"CA"}, Tz::America_Halifax}, // Charlottetown Airport
    Airport{IataCode{"YYH"}, CountryId{"CA"}, Tz::America_Cambridge_Bay}, // Taloyoak Airport
    Airport{IataCode{"YYJ"}, CountryId{"CA"}, Tz::America_Vancouver}, // Victoria International Airport
    Airport{IataCode{"YYL"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Lynn Lake Airport
    Airport{IataCode{"YYM"}, CountryId{"CA"}, Tz::America_Edmonton}, // Cowley Airport
    Airport{IataCode{"YYN"}, CountryId{"CA"}, Tz::America_Regina}, // Swift Current Airport
    Airport{IataCode{"YYO"}, CountryId{"CA"}, Tz::America_Regina}, // Wynyard/W. B. Needham Field Aerodrome
    Airport{IataCode{"YYT"}, CountryId{"CA"}, Tz::America_St_Johns}, // St. John's International Airport
    Airport{IataCode{"YYU"}, CountryId{"CA"}, Tz::America_Toronto}, // Kapuskasing Airport
    Airport{IataCode{"YYW"}, CountryId{"CA"}, Tz::America_Toronto}, // Armstrong Airport
    Airport{IataCode{"YYY"}, CountryId{"CA"}, Tz::America_Toronto}, // Mont-Joli Airport
    Airport{IataCode{"YYZ"}, CountryId{"CA"}, Tz::America_Toronto}, // Toronto Pearson International Airport
    Airport{IataCode{"YZA"}, CountryId{"CA"}, Tz::America_Vancouver}, // Cache Creek Airport
    Airport{IataCode{"YZD"}, CountryId{"CA"}, Tz::America_Toronto}, // Downsview Airport
    Airport{IataCode{"YZE"}, CountryId{"CA"}, Tz::America_Toronto}, // Gore Bay-Manitoulin Airport
    Airport{IataCode{"YZF"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Yellowknife Airport
    Airport{IataCode{"YZG"}, CountryId{"CA"}, Tz::America_Toronto}, // Salluit Airport
    Airport{IataCode{"YZH"}, CountryId{"CA"}, Tz::America_Edmonton}, // Slave Lake Airport
    Airport{IataCode{"YZP"}, CountryId{"CA"}, Tz::America_Vancouver}, // Sandspit Airport
    Airport{IataCode{"YZR"}, CountryId{"CA"}, Tz::America_Toronto}, // Sarnia Chris Hadfield Airport
    Airport{IataCode{"YZS"}, CountryId{"CA"}, Tz::America_Atikokan}, // Coral Harbour Airport
    Airport{IataCode{"YZT"}, CountryId{"CA"}, Tz::America_Vancouver}, // Port Hardy Airport
    Airport{IataCode{"YZU"}, CountryId{"CA"}, Tz::America_Edmonton}, // Whitecourt Airport
    Airport{IataCode{"YZV"}, CountryId{"CA"}, Tz::America_Toronto}, // Sept-Îles Airport
    Airport{IataCode{"YZW"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Teslin Airport
    Airport{IataCode{"YZY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhangye Ganzhou Airport
    Airport{IataCode{"YZZ"}, CountryId{"CA"}, Tz::America_Vancouver}, // Trail Airport
    Airport{IataCode{"ZAC"}, CountryId{"CA"}, Tz::America_Winnipeg}, // York Landing Airport
    Airport{IataCode{"ZAD"}, CountryId{"HR"}, Tz::Europe_Zagreb}, // Zadar Airport
    Airport{IataCode{"ZAG"}, CountryId{"HR"}, Tz::Europe_Zagreb}, // Zagreb Airport
    Airport{IataCode{"ZAH"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Zahedan Airport
    Airport{IataCode{"ZAJ"}, CountryId{"AF"}, Tz::Asia_Kabul}, // Zaranj Airport
    Airport{IataCode{"ZAL"}, CountryId{"CL"}, Tz::America_Santiago}, // Pichoy Airport
    Airport{IataCode{"ZAM"}, CountryId{"PH"}, Tz::Asia_Manila}, // Zamboanga International Airport
    Airport{IataCode{"ZAR"}, CountryId{"NG"}, Tz::Africa_Lagos}, // Zaria Airport
    Airport{IataCode{"ZAT"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhaotong Airport
    Airport{IataCode{"ZAZ"}, CountryId{"ES"}, Tz::Europe_Madrid}, // Zaragoza Airport
    Airport{IataCode{"ZBE"}, CountryId{"CZ"}, Tz::Europe_Prague}, // Zábřeh Ostrava Airport
    Airport{IataCode{"ZBF"}, CountryId{"CA"}, Tz::America_Moncton}, // Bathurst Airport
    Airport{IataCode{"ZBG"}, CountryId{"PL"}, Tz::Europe_Warsaw}, // Elbląg Airport
    Airport{IataCode{"ZBK"}, CountryId{"ME"}, Tz::Europe_Podgorica}, // Žabljak Airport
    Airport{IataCode{"ZBL"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Biloela Airport
    Airport{IataCode{"ZBM"}, CountryId{"CA"}, Tz::America_Toronto}, // Roland-Désourdy Airport
    Airport{IataCode{"ZBO"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // Bowen Airport
    Airport{IataCode{"ZBR"}, CountryId{"IR"}, Tz::Asia_Tehran}, // Konarak Airport
    Airport{IataCode{"ZBY"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Sayaboury Airport
    Airport{IataCode{"ZCL"}, CountryId{"MX"}, Tz::America_Mexico_City}, // General Leobardo C. Ruiz International Airport
    Airport{IataCode{"ZCO"}, CountryId{"CL"}, Tz::America_Santiago}, // Aeropuerto La Araucanía
    Airport{IataCode{"ZCQ"}, CountryId{"CL"}, Tz::America_Santiago}, // General Freire Airfield
    Airport{IataCode{"ZDY"}, CountryId{"AE"}, Tz::Asia_Dubai}, // Dalma Airport
    Airport{IataCode{"ZEF"}, CountryId{"US"}, Tz::America_New_York}, // Elkin Municipal Airport
    Airport{IataCode{"ZEL"}, CountryId{"CA"}, Tz::America_Vancouver}, // Bella Bella Airport
    Airport{IataCode{"ZEM"}, CountryId{"CA"}, Tz::America_Toronto}, // Eastmain River Airport
    Airport{IataCode{"ZER"}, CountryId{"IN"}, Tz::Asia_Kolkata}, // Zero Airport
    Airport{IataCode{"ZFA"}, CountryId{"CA"}, Tz::America_Whitehorse}, // Faro Airport
    Airport{IataCode{"ZFD"}, CountryId{"CA"}, Tz::America_Regina}, // Fond-du-Lac Airport
    Airport{IataCode{"ZFM"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Fort McPherson Airport
    Airport{IataCode{"ZFN"}, CountryId{"CA"}, Tz::America_Yellowknife}, // Tulita Airport
    Airport{IataCode{"ZFW"}, CountryId{"CA"}, Tz::America_Edmonton}, // Fairview Airport
    Airport{IataCode{"ZGF"}, CountryId{"CA"}, Tz::America_Vancouver}, // Grand Forks Airport
    Airport{IataCode{"ZGI"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Gods River Airport
    Airport{IataCode{"ZGL"}, CountryId{"AU"}, Tz::Australia_Brisbane}, // South Galway Airport
    Airport{IataCode{"ZGM"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Ngoma Airport
    Airport{IataCode{"ZGR"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Little Grand Rapids Airport
    Airport{IataCode{"ZGS"}, CountryId{"CA"}, Tz::America_Blanc_Sablon}, // La Romaine Airport
    Airport{IataCode{"ZGU"}, CountryId{"VU"}, Tz::Pacific_Efate}, // Gaua Airport
    Airport{IataCode{"ZHA"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhanjiang Airport
    Airport{IataCode{"ZHM"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Shamshernagar Airport
    Airport{IataCode{"ZHP"}, CountryId{"CA"}, Tz::America_Edmonton}, // High Prairie Airport
    Airport{IataCode{"ZHY"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhongwei Shapotou Airport
    Airport{IataCode{"ZIA"}, CountryId{"RU"}, Tz::Europe_Moscow}, // Zhukovsky International Airport
    Airport{IataCode{"ZIC"}, CountryId{"CL"}, Tz::America_Santiago}, // Victoria Airport
    Airport{IataCode{"ZIG"}, CountryId{"SN"}, Tz::Africa_Dakar}, // Ziguinchor Airport
    Airport{IataCode{"ZIH"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Ixtapa-Zihuatanejo International Airport
    Airport{IataCode{"ZIN"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Interlaken Airport
    Airport{IataCode{"ZIS"}, CountryId{"LY"}, Tz::Africa_Tripoli}, // Alzintan Airport
    Airport{IataCode{"ZIX"}, CountryId{"RU"}, Tz::Asia_Yakutsk}, // Zhigansk Airport
    Airport{IataCode{"ZJG"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Jenpeg Airport
    Airport{IataCode{"ZJI"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Locarno Airport
    Airport{IataCode{"ZJN"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Swan River Airport
    Airport{IataCode{"ZKB"}, CountryId{"ZM"}, Tz::Africa_Lusaka}, // Kasaba Bay Airport
    Airport{IataCode{"ZKE"}, CountryId{"CA"}, Tz::America_Toronto}, // Kashechewan Airport
    Airport{IataCode{"ZKG"}, CountryId{"CA"}, Tz::America_Toronto}, // Kegaska Airport
    Airport{IataCode{"ZKM"}, CountryId{"GA"}, Tz::Africa_Libreville}, // Sette-Cama Airport
    Airport{IataCode{"ZKP"}, CountryId{"RU"}, Tz::Asia_Srednekolymsk}, // Zyryanka Airport
    Airport{IataCode{"ZLO"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Playa de Oro International Airport
    Airport{IataCode{"ZLR"}, CountryId{"CL"}, Tz::America_Santiago}, // Linares Airport
    Airport{IataCode{"ZLT"}, CountryId{"CA"}, Tz::America_Blanc_Sablon}, // La Tabatière Airport
    Airport{IataCode{"ZLX"}, CountryId{"SD"}, Tz::Africa_Khartoum}, // Zalingei Airport
    Airport{IataCode{"ZMH"}, CountryId{"CA"}, Tz::America_Vancouver}, // South Cariboo Regional Airport
    Airport{IataCode{"ZMM"}, CountryId{"MX"}, Tz::America_Mexico_City}, // Zamora Airport
    Airport{IataCode{"ZMO"}, CountryId{"IT"}, Tz::Europe_Rome}, // Modena Airport
    Airport{IataCode{"ZMT"}, CountryId{"CA"}, Tz::America_Vancouver}, // Masset Airport
    Airport{IataCode{"ZNA"}, CountryId{"CA"}, Tz::America_Vancouver}, // Nanaimo Harbour Water Airport
    Airport{IataCode{"ZNC"}, CountryId{"US"}, Tz::America_Anchorage}, // Nyac Airport
    Airport{IataCode{"ZND"}, CountryId{"NE"}, Tz::Africa_Niamey}, // Zinder Airport
    Airport{IataCode{"ZNE"}, CountryId{"AU"}, Tz::Australia_Perth}, // Newman Airport
    Airport{IataCode{"ZNJ"}, CountryId{"ZA"}, Tz::Africa_Johannesburg}, // Heilbron Airport
    Airport{IataCode{"ZNL"}, CountryId{"CA"}, Tz::America_Vancouver}, // Nelson Airport
    Airport{IataCode{"ZNZ"}, CountryId{"TZ"}, Tz::Africa_Dar_es_Salaam}, // Abeid Amani Karume International Airport
    Airport{IataCode{"ZOS"}, CountryId{"CL"}, Tz::America_Santiago}, // Cañal Bajo Carlos Hott Siebert Airport
    Airport{IataCode{"ZPB"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Sachigo Lake Airport
    Airport{IataCode{"ZPC"}, CountryId{"CL"}, Tz::America_Santiago}, // Pucón Airport
    Airport{IataCode{"ZPH"}, CountryId{"US"}, Tz::America_New_York}, // Zephyrhills Municipal Airport
    Airport{IataCode{"ZPO"}, CountryId{"CA"}, Tz::America_Regina}, // Pinehouse Lake Airport
    Airport{IataCode{"ZQN"}, CountryId{"NZ"}, Tz::Pacific_Auckland}, // Queenstown Airport
    Airport{IataCode{"ZQS"}, CountryId{"CA"}, Tz::America_Vancouver}, // Queen Charlotte City Water Aerodrome
    Airport{IataCode{"ZQW"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Zweibrücken Airport
    Airport{IataCode{"ZQZ"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhangjiakou Ningyuan Airport
    Airport{IataCode{"ZRE"}, CountryId{"RS"}, Tz::Europe_Belgrade}, // Zrenjanin Airport
    Airport{IataCode{"ZRH"}, CountryId{"CH"}, Tz::Europe_Zurich}, // Zurich Airport
    Airport{IataCode{"ZRI"}, CountryId{"ID"}, Tz::Asia_Jayapura}, // Serui Airport
    Airport{IataCode{"ZRJ"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Round Lake (Weagamow Lake) Airport
    Airport{IataCode{"ZSA"}, CountryId{"BS"}, Tz::America_Nassau}, // San Salvador Airport
    Airport{IataCode{"ZSE"}, CountryId{"FR"}, Tz::Indian_Reunion}, // Pierrefonds Airport
    Airport{IataCode{"ZSI"}, CountryId{"KZ"}, Tz::Asia_Almaty}, // Zaysan Airport
    Airport{IataCode{"ZSJ"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Sandy Lake Airport
    Airport{IataCode{"ZSP"}, CountryId{"CA"}, Tz::America_Edmonton}, // St. Paul Aerodrome
    Airport{IataCode{"ZSS"}, CountryId{"CI"}, Tz::Africa_Abidjan}, // Sassandra Airport
    Airport{IataCode{"ZST"}, CountryId{"CA"}, Tz::America_Vancouver}, // Stewart Aerodrome
    Airport{IataCode{"ZSU"}, CountryId{"DE"}, Tz::Europe_Berlin}, // Dessau Aerodrome
    Airport{IataCode{"ZSW"}, CountryId{"CA"}, Tz::America_Vancouver}, // Prince Rupert/Seal Cove Water Airport
    Airport{IataCode{"ZTA"}, CountryId{"FR"}, Tz::Pacific_Tahiti}, // Tureia Airport
    Airport{IataCode{"ZTB"}, CountryId{"CA"}, Tz::America_Blanc_Sablon}, // Tête-à-la-Baleine Airport
    Airport{IataCode{"ZTH"}, CountryId{"GR"}, Tz::Europe_Athens}, // Zakynthos International Airport
    Airport{IataCode{"ZTM"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Shamattawa Airport
    Airport{IataCode{"ZTR"}, CountryId{"UA"}, Tz::Europe_Kiev}, // Zhytomyr Airport
    Airport{IataCode{"ZTS"}, CountryId{"CA"}, Tz::America_Vancouver}, // Tahsis Water Aerodrome
    Airport{IataCode{"ZTU"}, CountryId{"AZ"}, Tz::Asia_Baku}, // Zaqatala International Airport
    Airport{IataCode{"ZUC"}, CountryId{"CA"}, Tz::America_Winnipeg}, // Ignace Municipal Airport
    Airport{IataCode{"ZUD"}, CountryId{"CL"}, Tz::America_Santiago}, // Pupelde Airport
    Airport{IataCode{"ZUH"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zhuhai Jinwan Airport
    Airport{IataCode{"ZUL"}, CountryId{"AR"}, Tz::America_Argentina_Buenos_Aires}, // Azul Airport
    Airport{IataCode{"ZUM"}, CountryId{"CA"}, Tz::America_Goose_Bay}, // Churchill Falls Airport
    Airport{IataCode{"ZVA"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Miandrivazo Airport
    Airport{IataCode{"ZVG"}, CountryId{"AU"}, Tz::Australia_Perth}, // Springvale Airport
    Airport{IataCode{"ZVK"}, CountryId{"LA"}, Tz::Asia_Vientiane}, // Savannakhet Airport
    Airport{IataCode{"ZWA"}, CountryId{"MG"}, Tz::Indian_Antananarivo}, // Andapa Airport
    Airport{IataCode{"ZWL"}, CountryId{"CA"}, Tz::America_Regina}, // Wollaston Lake Airport
    Airport{IataCode{"ZXB"}, CountryId{"NO"}, Tz::Arctic_Longyearbyen}, // Jan Mayensfield
    Airport{IataCode{"ZXT"}, CountryId{"AZ"}, Tz::Asia_Baku}, // Zabrat Airport
    Airport{IataCode{"ZYI"}, CountryId{"CN"}, Tz::Asia_Shanghai}, // Zunyi Xinzhou Airport
    Airport{IataCode{"ZYL"}, CountryId{"BD"}, Tz::Asia_Dhaka}, // Osmani International Airport
    Airport{IataCode{"ZZO"}, CountryId{"RU"}, Tz::Asia_Sakhalin}, // Zonalnoye Airport
    Airport{IataCode{"ZZU"}, CountryId{"MW"}, Tz::Africa_Blantyre}, // Mzuzu Airport
    Airport{IataCode{"ZZV"}, CountryId{"US"}, Tz::America_New_York}, // Zanesville Municipal Airport
};

// airport coordinates in latitude/longitude pairs
// stored out of line of the airport_table to avoid alignment padding
static constexpr Coordinate coordinate_table[] = {
    Coordinate{-145.512, -17.3489}, // AAA
    Coordinate{141.047, -26.6906}, // AAB
    Coordinate{33.8358, 31.0733}, // AAC
    Coordinate{46.6375, 6.09583}, // AAD
    Coordinate{7.80944, 36.8222}, // AAE
    Coordinate{-85.0275, 29.7275}, // AAF
    Coordinate{-46.8856, -13.0239}, // AAI
    Coordinate{-55.5778, 3.89861}, // AAJ
    Coordinate{173.636, 0.185278}, // AAK
    Coordinate{9.84917, 57.0928}, // AAL
    Coordinate{31.5447, -24.8181}, // AAM
    Coordinate{55.6149, 24.2595}, // AAN
    Coordinate{-64.4708, 9.4303}, // AAO
    Coordinate{117.254, -0.376389}, // AAP
    Coordinate{37.3473, 45.0021}, // AAQ
    Coordinate{10.6192, 56.3042}, // AAR
    Coordinate{139.311, -3.88472}, // AAS
    Coordinate{88.0844, 47.7504}, // AAT
    Coordinate{-172.628, -13.505}, // AAU
    Coordinate{124.753, 6.3678}, // AAV
    Coordinate{52.1742, 16.1934}, // AAY
    Coordinate{-91.5019, 14.8656}, // AAZ
    Coordinate{91.3859, 53.7433}, // ABA
    Coordinate{6.65889, 6.20306}, // ABB
    Coordinate{-1.86333, 38.9483}, // ABC
    Coordinate{48.2283, 30.3711}, // ABD
    Coordinate{-75.4405, 40.6523}, // ABE
    Coordinate{173.04, 1.79639}, // ABF
    Coordinate{143.184, -17.6075}, // ABG
    Coordinate{146.583, -23.6467}, // ABH
    Coordinate{-99.6831, 32.4132}, // ABI
    Coordinate{-3.92578, 5.26142}, // ABJ
    Coordinate{44.2416, 6.73281}, // ABK
    Coordinate{-157.857, 67.1066}, // ABL
    Coordinate{142.459, -10.9508}, // ABM
    Coordinate{-54.0501, 5.51272}, // ABN
    Coordinate{-3.26667, 5.43306}, // ABO
    Coordinate{141.1, -6.0667}, // ABP
    Coordinate{-106.609, 35.0403}, // ABQ
    Coordinate{-98.4228, 45.4483}, // ABR
    Coordinate{31.6117, 22.3758}, // ABS
    Coordinate{41.6343, 20.2961}, // ABT
    Coordinate{124.9, -9.33333}, // ABU
    Coordinate{7.26319, 9.00681}, // ABV
    Coordinate{148.7, -10.1667}, // ABW
    Coordinate{146.958, -36.0678}, // ABX
    Coordinate{-84.1944, 31.5356}, // ABY
    Coordinate{-2.19778, 57.2019}, // ABZ
    Coordinate{-99.754, 16.756}, // ACA
    Coordinate{-85.1983, 44.9886}, // ACB
    Coordinate{-0.167389, 5.60467}, // ACC
    Coordinate{-77.2739, 8.49806}, // ACD
    Coordinate{-13.6053, 28.9456}, // ACE
    Coordinate{9.56083, 47.485}, // ACH
    Coordinate{-2.21444, 49.7067}, // ACI
    Coordinate{-70.059, 41.2529}, // ACK
    Coordinate{-72.9906, 4.74694}, // ACL
    Coordinate{-101.101, 29.3317}, // ACN
    Coordinate{46.1279, 37.348}, // ACP
    Coordinate{-72.3981, -0.601111}, // ACR
    Coordinate{90.5767, 56.2683}, // ACS
    Coordinate{-97.2306, 31.6114}, // ACT
    Coordinate{-78.0167, 9.18333}, // ACU
    Coordinate{-124.108, 40.9778}, // ACV
    Coordinate{104.959, 25.0883}, // ACX
    Coordinate{-74.5772, 39.4575}, // ACY
    Coordinate{61.5439, 31.0983}, // ACZ
    Coordinate{35.2803, 36.9819}, // ADA
    Coordinate{27.155, 38.2892}, // ADB
    Coordinate{145.733, -7.1333}, // ADC
    Coordinate{38.7994, 8.97778}, // ADD
    Coordinate{45.0288, 12.8274}, // ADE
    Coordinate{38.4689, 37.7314}, // ADF
    Coordinate{-84.0772, 41.8678}, // ADG
    Coordinate{125.4, 58.6}, // ADH
    Coordinate{14.98, -22.4622}, // ADI
    Coordinate{35.9914, 31.9725}, // ADJ
    Coordinate{-176.646, 51.8781}, // ADK
    Coordinate{138.531, -34.945}, // ADL
    Coordinate{-97.0206, 34.3042}, // ADM
    Coordinate{137.137, -30.4383}, // ADO
    Coordinate{81.6258, 7.33722}, // ADP
    Coordinate{-152.494, 57.7497}, // ADQ
    Coordinate{-79.5261, 33.4517}, // ADR
    Coordinate{-96.8364, 32.9686}, // ADS
    Coordinate{-96.6714, 34.8044}, // ADT
    Coordinate{48.4242, 38.3256}, // ADU
    Coordinate{26.1192, 11.4036}, // ADV
    Coordinate{29.0555, -22.679}, // ADY
    Coordinate{-81.7111, 12.5836}, // ADZ
    Coordinate{173.829, 0.4908}, // AEA
    Coordinate{106.959, 23.7194}, // AEB
    Coordinate{99.4305, 1.4001}, // AEG
    Coordinate{146.194, -7.3509}, // AEK
    Coordinate{-93.3672, 43.6817}, // AEL
    Coordinate{-9.63778, 16.7111}, // AEO
    Coordinate{-58.4164, -34.5589}, // AEP
    Coordinate{120.16, 43.8704}, // AEQ
    Coordinate{39.9567, 43.45}, // AER
    Coordinate{6.11972, 62.5625}, // AES
    Coordinate{-152.622, 66.5519}, // AET
    Coordinate{55.0317, 25.8756}, // AEU
    Coordinate{-92.5486, 31.3275}, // AEX
    Coordinate{-18.0727, 65.66}, // AEY
    Coordinate{-68.4036, -34.5967}, // AFA
    Coordinate{26.8797, -33.5542}, // AFD
    Coordinate{-75.0667, 6.89444}, // AFI
    Coordinate{-95.8678, 40.6056}, // AFK
    Coordinate{-72.003, 42.8051}, // AFN
    Coordinate{-110.942, 42.7089}, // AFO
    Coordinate{148.395, -9.1318}, // AFR
    Coordinate{64.2328, 41.6136}, // AFS
    Coordinate{160.948, -9.19139}, // AFT
    Coordinate{-97.3189, 32.9878}, // AFW
    Coordinate{30.6011, 38.7264}, // AFY
    Coordinate{57.5952, 36.1681}, // AFZ
    Coordinate{-9.41139, 30.3225}, // AGA
    Coordinate{-79.9302, 40.3544}, // AGC
    Coordinate{133.867, -1.38333}, // AGD
    Coordinate{0.590556, 44.1747}, // AGF
    Coordinate{-56.6333, 5.76667}, // AGI
    Coordinate{127.24, 26.5928}, // AGJ
    Coordinate{143.855, -6.3969}, // AGK
    Coordinate{149.156, -9.3375}, // AGL
    Coordinate{-134.585, 57.5036}, // AGN
    Coordinate{-93.2169, 33.2275}, // AGO
    Coordinate{-4.49917, 36.675}, // AGP
    Coordinate{21.3511, 38.6019}, // AGQ
    Coordinate{-82.0628, 33.1994}, // AGS
    Coordinate{-54.8433, -25.4553}, // AGT
    Coordinate{-102.318, 21.7056}, // AGU
    Coordinate{-69.2375, 9.55333}, // AGV
    Coordinate{142.149, -12.1456}, // AGW
    Coordinate{72.1789, 10.8281}, // AGX
    Coordinate{128.75, -16.35}, // AGY
    Coordinate{18.8136, -29.2817}, // AGZ
    Coordinate{42.6566, 18.2404}, // AHB
    Coordinate{-97.1228, 34.1469}, // AHD
    Coordinate{-146.257, -14.4281}, // AHE
    Coordinate{-99.9064, 40.3394}, // AHF
    Coordinate{-92.3753, 45.2811}, // AHH
    Coordinate{128.917, -3.3333}, // AHI
    Coordinate{102.357, 32.5292}, // AHJ
    Coordinate{-59.3222, 2.47222}, // AHL
    Coordinate{-122.661, 42.1903}, // AHM
    Coordinate{-83.3264, 33.9486}, // AHN
    Coordinate{8.28861, 40.6311}, // AHO
    Coordinate{-84.3522, 15.4722}, // AHS
    Coordinate{-3.83944, 35.1769}, // AHU
    Coordinate{56.7656, 21.3428}, // AHW
    Coordinate{-102.804, 42.0533}, // AIA
    Coordinate{168.817, 7.26667}, // AIC
    Coordinate{-85.6131, 40.1086}, // AID
    Coordinate{144.732, -5.1422}, // AIE
    Coordinate{-50.4531, -22.64}, // AIF
    Coordinate{23.2667, 6.51667}, // AIG
    Coordinate{141.266, -7.3425}, // AIH
    Coordinate{42.7167, 11.1333}, // AII
    Coordinate{-81.685, 33.6494}, // AIK
    Coordinate{169.983, 10.2169}, // AIM
    Coordinate{-160.007, 70.6381}, // AIN
    Coordinate{-95.0469, 41.4072}, // AIO
    Coordinate{-59.4578, -10.2531}, // AIR
    Coordinate{176.802, -2.6163}, // AIS
    Coordinate{-159.764, -18.8308}, // AIT
    Coordinate{-158.12, -19.9678}, // AIU
    Coordinate{-88.1978, 33.1064}, // AIV
    Coordinate{-92.5495, 38.096}, // AIZ
    Coordinate{8.8025, 41.9239}, // AJA
    Coordinate{40.0997, 29.7853}, // AJF
    Coordinate{43.0272, 39.6544}, // AJI
    Coordinate{-14.3833, 19.733}, // AJJ
    Coordinate{49.8473, 34.1381}, // AJK
    Coordinate{92.6204, 23.8384}, // AJL
    Coordinate{44.4296, -12.1317}, // AJN
    Coordinate{19.2819, 65.5903}, // AJR
    Coordinate{-113.56, 26.7272}, // AJS
    Coordinate{-37.0826, -10.9853}, // AJU
    Coordinate{7.99028, 16.9622}, // AJY
    Coordinate{108.931, 32.7081}, // AKA
    Coordinate{-174.206, 52.2206}, // AKB
    Coordinate{-81.4669, 41.0375}, // AKC
    Coordinate{77.0586, 20.6989}, // AKD
    Coordinate{13.9033, -1.13972}, // AKE
    Coordinate{23.3133, 24.1767}, // AKF
    Coordinate{142.218, -3.56075}, // AKG
    Coordinate{-161.231, 60.9028}, // AKI
    Coordinate{142.447, 43.6708}, // AKJ
    Coordinate{-154.182, 56.9386}, // AKK
    Coordinate{174.792, -37.0081}, // AKL
    Coordinate{19.8175, 10.8908}, // AKM
    Coordinate{-156.666, 58.6764}, // AKN
    Coordinate{-103.222, 40.1756}, // AKO
    Coordinate{-151.743, 68.1336}, // AKP
    Coordinate{5.30083, 7.24667}, // AKR
    Coordinate{160.681, -8.69778}, // AKS
    Coordinate{80.2917, 41.2625}, // AKU
    Coordinate{-78.1486, 60.8186}, // AKV
    Coordinate{49.6769, 30.7444}, // AKW
    Coordinate{57.2033, 50.245}, // AKX
    Coordinate{92.8725, 20.1328}, // AKY
    Coordinate{77.0406, 43.3519}, // ALA
    Coordinate{-73.8019, 42.7492}, // ALB
    Coordinate{-0.558056, 38.2822}, // ALC
    Coordinate{-69.3333, -11.6833}, // ALD
    Coordinate{-103.684, 30.3842}, // ALE
    Coordinate{23.3717, 69.9761}, // ALF
    Coordinate{3.21694, 36.6944}, // ALG
    Coordinate{117.809, -34.9433}, // ALH
    Coordinate{-98.0269, 27.7408}, // ALI
    Coordinate{16.5344, -28.5733}, // ALJ
    Coordinate{8.12533, 44.0457}, // ALL
    Coordinate{-105.991, 32.84}, // ALM
    Coordinate{-90.0461, 38.8903}, // ALN
    Coordinate{-92.4003, 42.5569}, // ALO
    Coordinate{37.2242, 36.1806}, // ALP
    Coordinate{-55.8922, -29.8125}, // ALQ
    Coordinate{169.373, -45.2117}, // ALR
    Coordinate{-105.866, 37.435}, // ALS
    Coordinate{50.7483, 11.9586}, // ALU
    Coordinate{-118.289, 46.0947}, // ALW
    Coordinate{-85.9631, 32.9147}, // ALX
    Coordinate{29.9489, 31.1839}, // ALY
    Coordinate{-154.248, 56.8994}, // ALZ
    Coordinate{-101.706, 35.2194}, // AMA
    Coordinate{48.9833, -13.1883}, // AMB
    Coordinate{20.274, 11.034}, // AMC
    Coordinate{72.6347, 23.0772}, // AMD
    Coordinate{141.669, -4.1007}, // AMF
    Coordinate{37.5903, 6.03972}, // AMH
    Coordinate{116.094, -8.56056}, // AMI
    Coordinate{-107.869, 37.2031}, // AMK
    Coordinate{-82.8649, 8.2681}, // AML
    Coordinate{35.9933, 31.7225}, // AMM
    Coordinate{-84.6881, 43.3222}, // AMN
    Coordinate{15.3144, 14.1456}, // AMO
    Coordinate{44.7325, -24.7}, // AMP
    Coordinate{128.089, -3.71026}, // AMQ
    Coordinate{4.76417, 52.3081}, // AMS
    Coordinate{131.207, -26.1083}, // AMT
    Coordinate{141.219, -3.5883}, // AMU
    Coordinate{61.5633, 69.7633}, // AMV
    Coordinate{-93.6217, 41.9919}, // AMW
    Coordinate{174.973, -37.0297}, // AMZ
    Coordinate{34.9543, -1.2717}, // ANA
    Coordinate{-85.8581, 33.5881}, // ANB
    Coordinate{-149.998, 61.1742}, // ANC
    Coordinate{-82.709, 34.4949}, // AND
    Coordinate{-0.312222, 47.5603}, // ANE
    Coordinate{-70.4451, -23.4445}, // ANF
    Coordinate{0.219167, 45.7294}, // ANG
    Coordinate{-159.543, 61.5817}, // ANI
    Coordinate{13.8167, -2.85}, // ANJ
    Coordinate{16.711, -11.4715}, // ANL
    Coordinate{50.32, -14.9994}, // ANM
    Coordinate{-131.572, 55.0425}, // ANN
    Coordinate{39.9333, -16.1833}, // ANO
    Coordinate{-76.5683, 38.9428}, // ANP
    Coordinate{-85.0836, 41.6397}, // ANQ
    Coordinate{4.46028, 51.1894}, // ANR
    Coordinate{-73.3528, -13.7128}, // ANS
    Coordinate{-160.191, 62.6467}, // ANV
    Coordinate{-99.9931, 42.5792}, // ANW
    Coordinate{16.1442, 69.2925}, // ANX
    Coordinate{-98.0797, 37.1586}, // ANY
    Coordinate{12.51, 50.9806}, // AOC
    Coordinate{19.2833, 11.4667}, // AOD
    Coordinate{30.5194, 39.81}, // AOE
    Coordinate{122.856, 41.1047}, // AOG
    Coordinate{-84.0275, 40.7083}, // AOH
    Coordinate{13.3622, 43.6161}, // AOI
    Coordinate{140.689, 40.7333}, // AOJ
    Coordinate{27.1467, 35.4167}, // AOK
    Coordinate{-57.1522, -29.6881}, // AOL
    Coordinate{57.3822, 22.4972}, // AOM
    Coordinate{-78.32, 40.2964}, // AOO
    Coordinate{-76.4666, -2.79611}, // AOP
    Coordinate{100.398, 6.18944}, // AOR
    Coordinate{-153.815, 57.4714}, // AOS
    Coordinate{7.36385, 45.7392}, // AOT
    Coordinate{106.833, 14.7931}, // AOU
    Coordinate{-104.849, 39.57}, // APA
    Coordinate{-68.4167, -14.8181}, // APB
    Coordinate{-122.281, 38.2132}, // APC
    Coordinate{-81.7756, 26.1525}, // APF
    Coordinate{-146.414, -15.5726}, // APK
    Coordinate{39.2818, -15.1056}, // APL
    Coordinate{-83.5603, 45.0781}, // APN
    Coordinate{-76.7134, 7.81117}, // APO
    Coordinate{148.133, -8.9833}, // APP
    Coordinate{142.54, -4.6746}, // APR
    Coordinate{-48.9281, -16.3625}, // APS
    Coordinate{-85.5853, 35.0606}, // APT
    Coordinate{-51.385, -23.6122}, // APU
    Coordinate{-117.187, 34.5753}, // APV
    Coordinate{-172.008, -13.8297}, // APW
    Coordinate{-51.4908, -23.3558}, // APX
    Coordinate{-45.9506, -9.08361}, // APY
    Coordinate{-70.1136, -38.9759}, // APZ
    Coordinate{-48.1403, -21.8044}, // AQA
    Coordinate{-91.1506, 15.0108}, // AQB
    Coordinate{117.05, 30.5822}, // AQG
    Coordinate{46.125, 28.335}, // AQI
    Coordinate{35.0181, 29.6116}, // AQJ
    Coordinate{-62.8256, -10.1781}, // AQM
    Coordinate{-71.5831, -16.3411}, // AQP
    Coordinate{-149.126, 60.9661}, // AQY
    Coordinate{-91.8839, 30.0377}, // ARA
    Coordinate{-83.7456, 42.2231}, // ARB
    Coordinate{-145.579, 68.1147}, // ARC
    Coordinate{124.591, -8.13574}, // ARD
    Coordinate{-66.6756, 18.4511}, // ARE
    Coordinate{-90.925, 36.1247}, // ARG
    Coordinate{40.7167, 64.6}, // ARH
    Coordinate{-70.3386, -18.3486}, // ARI
    Coordinate{128.917, -3.33333}, // ARJ
    Coordinate{36.6219, -3.36667}, // ARK
    Coordinate{1.48333, 11.5833}, // ARL
    Coordinate{151.617, -30.5283}, // ARM
    Coordinate{17.9186, 59.6519}, // ARN
    Coordinate{149.5, -9.9}, // ARP
    Coordinate{-71.3889, 7.01917}, // ARQ
    Coordinate{-70.8129, -45.0136}, // ARR
    Coordinate{-76.0206, 43.9919}, // ART
    Coordinate{-50.4264, -21.1442}, // ARU
    Coordinate{-89.7308, 45.9278}, // ARV
    Coordinate{21.2619, 46.1767}, // ARW
    Coordinate{142.988, -37.31}, // ARY
    Coordinate{12.8626, -7.25903}, // ARZ
    Coordinate{42.645, 13.0717}, // ASA
    Coordinate{58.3608, 37.9869}, // ASB
    Coordinate{-63.1559, -15.9322}, // ASC
    Coordinate{-77.8, 24.6983}, // ASD
    Coordinate{-106.869, 39.2231}, // ASE
    Coordinate{48.0063, 46.2833}, // ASF
    Coordinate{171.797, -43.9033}, // ASG
    Coordinate{-71.5147, 42.7817}, // ASH
    Coordinate{129.712, 28.4308}, // ASJ
    Coordinate{-5.36558, 6.90317}, // ASK
    Coordinate{-94.3078, 32.5206}, // ASL
    Coordinate{38.9017, 15.285}, // ASM
    Coordinate{-86.0511, 33.5694}, // ASN
    Coordinate{34.5861, 10.0183}, // ASO
    Coordinate{133.902, -23.8069}, // ASP
    Coordinate{-117.195, 39.4681}, // ASQ
    Coordinate{35.4953, 38.7703}, // ASR
    Coordinate{-123.879, 46.1581}, // AST
    Coordinate{-57.5192, -25.2397}, // ASU
    Coordinate{37.2508, -2.6358}, // ASV
    Coordinate{32.8197, 23.9642}, // ASW
    Coordinate{-90.9189, 46.5486}, // ASX
    Coordinate{-99.3517, 46.0247}, // ASY
    Coordinate{150.367, -5.8667}, // ASZ
    Coordinate{-77.5983, -9.34722}, // ATA
    Coordinate{34.0569, 17.7097}, // ATB
    Coordinate{-75.6739, 24.6294}, // ATC
    Coordinate{161.011, -8.87333}, // ATD
    Coordinate{-95.6497, 34.1925}, // ATE
    Coordinate{-78.5744, -1.21194}, // ATF
    Coordinate{23.9444, 37.9364}, // ATH
    Coordinate{-56.5078, -30.4008}, // ATI
    Coordinate{47.0667, -19.8358}, // ATJ
    Coordinate{-157.436, 70.4672}, // ATK
    Coordinate{-84.4281, 33.6367}, // ATL
    Coordinate{-52.2522, -3.25083}, // ATM
    Coordinate{152.442, -3.66667}, // ATN
    Coordinate{-82.2292, 39.2119}, // ATO
    Coordinate{142.346, -3.14417}, // ATP
    Coordinate{74.7992, 31.7078}, // ATQ
    Coordinate{-13.0431, 20.5067}, // ATR
    Coordinate{-104.468, 32.8525}, // ATS
    Coordinate{-162.273, 60.8667}, // ATT
    Coordinate{18.3133, 13.2389}, // ATV
    Coordinate{-88.5192, 44.2581}, // ATW
    Coordinate{68.3633, 51.8517}, // ATX
    Coordinate{-97.1547, 44.9139}, // ATY
    Coordinate{31.0119, 27.0464}, // ATZ
    Coordinate{-70.0153, 12.5014}, // AUA
    Coordinate{-70.7369, 7.06889}, // AUC
    Coordinate{33.2, 28.8989}, // AUE
    Coordinate{3.49667, 47.8464}, // AUF
    Coordinate{-69.7972, 44.3206}, // AUG
    Coordinate{54.6511, 24.4331}, // AUH
    Coordinate{143.065, -1.46317}, // AUI
    Coordinate{142.823, -4.2161}, // AUJ
    Coordinate{-164.66, 62.68}, // AUK
    Coordinate{171.173, 8.1455}, // AUL
    Coordinate{-92.9328, 43.6625}, // AUM
    Coordinate{-121.082, 38.9547}, // AUN
    Coordinate{-85.4339, 32.615}, // AUO
    Coordinate{149.386, -9.9308}, // AUP
    Coordinate{-139.013, -9.76861}, // AUQ
    Coordinate{2.41667, 44.8975}, // AUR
    Coordinate{-97.67, 30.1944}, // AUS
    Coordinate{125.602, -8.2817}, // AUT
    Coordinate{141.721, -13.3539}, // AUU
    Coordinate{148.447, -5.7292}, // AUV
    Coordinate{-89.6267, 44.9261}, // AUW
    Coordinate{-88.4756, 41.7719}, // AUZ
    Coordinate{105.873, 26.2606}, // AVA
    Coordinate{-78.7894, 22.0269}, // AVI
    Coordinate{102.799, 46.2525}, // AVK
    Coordinate{-82.5417, 35.4361}, // AVL
    Coordinate{4.90194, 43.9067}, // AVN
    Coordinate{-75.7233, 41.3383}, // AVP
    Coordinate{160.41, -9.86818}, // AVU
    Coordinate{144.469, -38.0394}, // AVV
    Coordinate{-111.218, 32.4096}, // AVW
    Coordinate{-118.416, 33.405}, // AVX
    Coordinate{38.5, 7.067}, // AWA
    Coordinate{142.751, -8.0143}, // AWB
    Coordinate{169.601, -19.2344}, // AWD
    Coordinate{166.637, 19.2825}, // AWK
    Coordinate{-90.2344, 35.135}, // AWM
    Coordinate{139.26, -26.4886}, // AWN
    Coordinate{144.854, -4.1195}, // AWR
    Coordinate{48.762, 31.3374}, // AWZ
    Coordinate{-63.055, 18.2047}, // AXA
    Coordinate{-75.8997, 44.3167}, // AXB
    Coordinate{145.242, -22.9667}, // AXC
    Coordinate{25.9563, 40.8559}, // AXD
    Coordinate{-52.3833, -26.8833}, // AXE
    Coordinate{105.626, 38.8229}, // AXF
    Coordinate{-94.2719, 43.0778}, // AXG
    Coordinate{46.8261, 14.5511}, // AXK
    Coordinate{-75.7664, 4.4525}, // AXM
    Coordinate{-95.3947, 45.8664}, // AXN
    Coordinate{-73.975, 22.4444}, // AXP
    Coordinate{-146.62, -15.2464}, // AXR
    Coordinate{-99.3383, 34.6989}, // AXS
    Coordinate{140.219, 39.6156}, // AXT
    Coordinate{38.7761, 14.1369}, // AXU
    Coordinate{-84.2981, 40.4936}, // AXV
    Coordinate{-75.1464, 8.32}, // AYA
    Coordinate{-73.9333, 1.54417}, // AYG
    Coordinate{66.96, 50.325}, // AYK
    Coordinate{114.344, 36.1339}, // AYN
    Coordinate{-56.8539, -27.3706}, // AYO
    Coordinate{-74.2042, -13.1547}, // AYP
    Coordinate{130.976, -25.1861}, // AYQ
    Coordinate{147.33, -19.585}, // AYR
    Coordinate{-82.3956, 31.2492}, // AYS
    Coordinate{30.7928, 36.9003}, // AYT
    Coordinate{145.904, -6.33778}, // AYU
    Coordinate{132.5, -1.2}, // AYW
    Coordinate{-73.7679, -10.7309}, // AYX
    Coordinate{-111.656, 33.3078}, // AZA
    Coordinate{149.3, -10.3}, // AZB
    Coordinate{54.2764, 31.905}, // AZD
    Coordinate{-102.396, 19.0931}, // AZG
    Coordinate{54.4581, 24.4266}, // AZI
    Coordinate{72.2939, 40.7278}, // AZN
    Coordinate{-85.5519, 42.235}, // AZO
    Coordinate{-0.186361, 27.8378}, // AZR
    Coordinate{-69.7375, 19.27}, // AZS
    Coordinate{13.1156, -7.88333}, // AZZ
    Coordinate{151.008, -5.3306}, // BAA
    Coordinate{-72.7158, 42.1581}, // BAF
    Coordinate{120.616, 16.375}, // BAG
    Coordinate{50.6336, 26.2708}, // BAH
    Coordinate{-83.33, 9.16361}, // BAI
    Coordinate{149.1, -4.883}, // BAJ
    Coordinate{-116.876, 40.5997}, // BAM
    Coordinate{20.4333, -4.3167}, // BAN
    Coordinate{149.633, -10.3333}, // BAP
    Coordinate{-74.7818, 10.8886}, // BAQ
    Coordinate{110.459, 19.1406}, // BAR
    Coordinate{155.888, -6.9925}, // BAS
    Coordinate{-48.5958, -20.5856}, // BAT
    Coordinate{-49.0539, -22.3436}, // BAU
    Coordinate{109.997, 40.5597}, // BAV
    Coordinate{83.5417, 53.3633}, // BAX
    Coordinate{23.4662, 47.6582}, // BAY
    Coordinate{-62.9194, -0.981112}, // BAZ
    Coordinate{-71.687, -45.9164}, // BBA
    Coordinate{-95.6506, 45.3319}, // BBB
    Coordinate{-95.8633, 28.9733}, // BBC
    Coordinate{-99.3239, 31.1792}, // BBD
    Coordinate{172.811, 3.08333}, // BBG
    Coordinate{12.7101, 54.3382}, // BBH
    Coordinate{85.8178, 20.2444}, // BBI
    Coordinate{25.1631, -17.8297}, // BBK
    Coordinate{141.808, -27.4083}, // BBL
    Coordinate{103.224, 13.0956}, // BBM
    Coordinate{115.469, 3.73694}, // BBN
    Coordinate{44.9411, 10.3892}, // BBO
    Coordinate{-61.8269, 17.6358}, // BBQ
    Coordinate{-61.7422, 16.0133}, // BBR
    Coordinate{-0.8475, 51.3239}, // BBS
    Coordinate{15.7861, 4.2214}, // BBT
    Coordinate{26.1036, 44.5036}, // BBU
    Coordinate{-6.924, 4.6333}, // BBV
    Coordinate{-99.6422, 41.4364}, // BBW
    Coordinate{-75.265, 40.1375}, // BBX
    Coordinate{20.6475, 5.84694}, // BBY
    Coordinate{23.1083, -13.5372}, // BBZ
    Coordinate{-74.5061, 20.3653}, // BCA
    Coordinate{-80.4078, 37.2078}, // BCB
    Coordinate{-156.15, 63.5717}, // BCC
    Coordinate{123.015, 10.7764}, // BCD
    Coordinate{-112.145, 37.7064}, // BCE
    Coordinate{18.2667, 6.5167}, // BCF
    Coordinate{126.399, -8.48528}, // BCH
    Coordinate{145.307, -23.5653}, // BCI
    Coordinate{-90.8553, 44.2508}, // BCK
    Coordinate{-83.5833, 10.7667}, // BCL
    Coordinate{26.9103, 46.5219}, // BCM
    Coordinate{2.07833, 41.2969}, // BCN
    Coordinate{36.562, 5.78287}, // BCO
    Coordinate{14.2655, 27.6547}, // BCQ
    Coordinate{21.367, 44.8867}, // BCR
    Coordinate{-90.0222, 29.866}, // BCS
    Coordinate{-80.1078, 26.3786}, // BCT
    Coordinate{9.74444, 10.4833}, // BCU
    Coordinate{-88.7761, 17.2694}, // BCV
    Coordinate{35.4383, -21.8531}, // BCW
    Coordinate{-64.6787, 32.364}, // BDA
    Coordinate{152.319, -24.9039}, // BDB
    Coordinate{-45.2422, -5.5025}, // BDC
    Coordinate{142.175, -10.15}, // BDD
    Coordinate{-94.6122, 48.7283}, // BDE
    Coordinate{-109.483, 37.5833}, // BDG
    Coordinate{54.8248, 26.5314}, // BDH
    Coordinate{114.762, -3.44222}, // BDJ
    Coordinate{-2.76194, 8.01722}, // BDK
    Coordinate{-72.6833, 41.9392}, // BDL
    Coordinate{-121.2, 44.0944}, // BDN
    Coordinate{107.576, -6.90056}, // BDO
    Coordinate{88.0794, 26.5706}, // BDP
    Coordinate{73.2189, 22.33}, // BDQ
    Coordinate{-73.1261, 41.1633}, // BDR
    Coordinate{17.9469, 40.6575}, // BDS
    Coordinate{20.9667, 4.25}, // BDT
    Coordinate{18.5403, 69.0558}, // BDU
    Coordinate{29.7333, -7.1}, // BDV
    Coordinate{-105.457, 45.4706}, // BDX
    Coordinate{-124.408, 43.0865}, // BDY
    Coordinate{146.95, -6.3333}, // BDZ
    Coordinate{146.5, -8.65}, // BEA
    Coordinate{-7.36278, 57.4811}, // BEB
    Coordinate{-97.215, 37.6944}, // BEC
    Coordinate{-71.2889, 42.47}, // BED
    Coordinate{-83.7742, 11.9908}, // BEF
    Coordinate{20.3069, 44.8194}, // BEG
    Coordinate{-86.4261, 42.1286}, // BEH
    Coordinate{34.5192, 9.39194}, // BEI
    Coordinate{117.432, 2.15528}, // BEJ
    Coordinate{79.4469, 28.4225}, // BEK
    Coordinate{-48.4789, -1.38472}, // BEL
    Coordinate{-6.33333, 32.3973}, // BEM
    Coordinate{20.2708, 32.0975}, // BEN
    Coordinate{151.648, -33.0667}, // BEO
    Coordinate{76.8828, 15.1628}, // BEP
    Coordinate{-4.42167, 48.4472}, // BES
    Coordinate{-161.837, 60.7786}, // BET
    Coordinate{139.46, -24.3461}, // BEU
    Coordinate{34.723, 31.287}, // BEV
    Coordinate{34.9075, -19.7964}, // BEW
    Coordinate{35.4883, 33.8211}, // BEY
    Coordinate{176.007, -1.35472}, // BEZ
    Coordinate{-78.64, 41.8031}, // BFD
    Coordinate{-103.596, 41.8739}, // BFF
    Coordinate{-110.713, 37.5458}, // BFG
    Coordinate{-49.2336, -25.4033}, // BFH
    Coordinate{-122.302, 47.53}, // BFI
    Coordinate{105.301, 27.3003}, // BFJ
    Coordinate{-99.6186, 36.8633}, // BFK
    Coordinate{-119.058, 35.4339}, // BFL
    Coordinate{-88.0681, 30.6267}, // BFM
    Coordinate{26.3039, -29.0939}, // BFN
    Coordinate{31.5786, -21.01}, // BFO
    Coordinate{-80.3914, 40.7725}, // BFP
    Coordinate{-78.1811, 7.58465}, // BFQ
    Coordinate{-86.4453, 38.84}, // BFR
    Coordinate{-6.21583, 54.6575}, // BFS
    Coordinate{-80.6344, 32.4122}, // BFT
    Coordinate{117.32, 32.8475}, // BFU
    Coordinate{103.251, 15.2267}, // BFV
    Coordinate{-0.593275, 35.1718}, // BFW
    Coordinate{10.3544, 5.53472}, // BFX
    Coordinate{-73.1847, 7.12639}, // BGA
    Coordinate{11.9431, -0.106944}, // BGB
    Coordinate{-6.70713, 41.8578}, // BGC
    Coordinate{-101.394, 35.7008}, // BGD
    Coordinate{-84.6375, 30.9717}, // BGE
    Coordinate{18.5188, 4.39778}, // BGF
    Coordinate{40.5925, 38.8611}, // BGG
    Coordinate{-14.2, 16.6333}, // BGH
    Coordinate{-59.4925, 13.0747}, // BGI
    Coordinate{-88.4167, 16.5167}, // BGK
    Coordinate{83.6664, 28.2128}, // BGL
    Coordinate{-75.9797, 42.2086}, // BGM
    Coordinate{146.235, 68.5569}, // BGN
    Coordinate{5.21806, 60.2936}, // BGO
    Coordinate{-149.814, 61.5361}, // BGQ
    Coordinate{-68.8281, 44.8072}, // BGR
    Coordinate{-113.17, 34.5958}, // BGT
    Coordinate{22.7833, 4.78333}, // BGU
    Coordinate{44.2344, 33.2625}, // BGW
    Coordinate{-54.1097, -31.3908}, // BGX
    Coordinate{9.69948, 45.6655}, // BGY
    Coordinate{-8.44514, 41.5871}, // BGZ
    Coordinate{-80.4042, -0.6081}, // BHA
    Coordinate{-68.3617, 44.4497}, // BHB
    Coordinate{-5.87123, 54.6155}, // BHD
    Coordinate{173.87, -41.5183}, // BHE
    Coordinate{-84.5436, 15.735}, // BHG
    Coordinate{42.6208, 19.9844}, // BHH
    Coordinate{-62.1575, -38.7275}, // BHI
    Coordinate{69.6703, 23.2878}, // BHJ
    Coordinate{64.4833, 39.775}, // BHK
    Coordinate{-86.7522, 33.5639}, // BHM
    Coordinate{45.72, 14.7819}, // BHN
    Coordinate{77.3375, 23.2875}, // BHO
    Coordinate{87.0508, 27.1475}, // BHP
    Coordinate{141.472, -32.0014}, // BHQ
    Coordinate{84.4294, 27.6781}, // BHR
    Coordinate{149.652, -33.41}, // BHS
    Coordinate{72.1853, 21.7522}, // BHU
    Coordinate{71.7178, 29.3481}, // BHV
    Coordinate{-1.74806, 52.4539}, // BHX
    Coordinate{109.294, 21.5394}, // BHY
    Coordinate{9.48472, 42.55}, // BIA
    Coordinate{43.6178, 3.09267}, // BIB
    Coordinate{-71.5778, 41.1681}, // BID
    Coordinate{165.565, 11.5225}, // BII
    Coordinate{146.35, -5.58333}, // BIJ
    Coordinate{136.107, -1.19}, // BIK
    Coordinate{-108.543, 45.8078}, // BIL
    Coordinate{-79.2647, 25.7}, // BIM
    Coordinate{67.8206, 34.81}, // BIN
    Coordinate{-2.91056, 43.3011}, // BIO
    Coordinate{-1.52333, 43.4683}, // BIQ
    Coordinate{87.2639, 26.4814}, // BIR
    Coordinate{-100.746, 46.7728}, // BIS
    Coordinate{80.5492, 29.4653}, // BIT
    Coordinate{-23.5461, 65.6414}, // BIU
    Coordinate{21.9894, 6.52667}, // BIV
    Coordinate{27.2792, -32.8972}, // BIY
    Coordinate{5.06947, 36.712}, // BJA
    Coordinate{57.3064, 37.4892}, // BJB
    Coordinate{-105.117, 39.9089}, // BJC
    Coordinate{-14.8244, 66.0219}, // BJD
    Coordinate{29.6928, 70.6003}, // BJF
    Coordinate{122.112, -0.960556}, // BJG
    Coordinate{81.1853, 29.5389}, // BJH
    Coordinate{-94.9347, 47.5108}, // BJI
    Coordinate{-81.8883, 40.8747}, // BJJ
    Coordinate{134.275, -6.06292}, // BJK
    Coordinate{-16.6522, 13.338}, // BJL
    Coordinate{29.3185, -3.32402}, // BJM
    Coordinate{-64.3128, -22.7733}, // BJO
    Coordinate{-46.5375, -22.9792}, // BJP
    Coordinate{37.3214, 11.6081}, // BJR
    Coordinate{79.9833, 6.41667}, // BJT
    Coordinate{81.6667, 29.5}, // BJU
    Coordinate{27.6642, 37.2506}, // BJV
    Coordinate{121.063, -8.7125}, // BJW
    Coordinate{-101.481, 20.9933}, // BJX
    Coordinate{-6.82139, 38.8914}, // BJZ
    Coordinate{73.2069, 28.0706}, // BKB
    Coordinate{-161.149, 65.9817}, // BKC
    Coordinate{-117.809, 44.8372}, // BKE
    Coordinate{-155.777, 58.5547}, // BKF
    Coordinate{-93.2006, 36.5319}, // BKG
    Coordinate{116.053, 5.94472}, // BKI
    Coordinate{-14.2811, 10.9658}, // BKJ
    Coordinate{100.747, 13.6811}, // BKK
    Coordinate{-81.6833, 41.5175}, // BKL
    Coordinate{115.618, 3.974}, // BKM
    Coordinate{54.3628, 39.4814}, // BKN
    Coordinate{-7.94306, 12.5378}, // BKO
    Coordinate{145.428, -24.4283}, // BKQ
    Coordinate{17.067, 12.383}, // BKR
    Coordinate{102.337, -3.86188}, // BKS
    Coordinate{-81.1242, 37.7872}, // BKW
    Coordinate{-96.8169, 44.3047}, // BKX
    Coordinate{28.8086, -2.30889}, // BKY
    Coordinate{31.8211, -1.33222}, // BKZ
    Coordinate{-64.6892, 10.1072}, // BLA
    Coordinate{-79.5994, 8.915}, // BLB
    Coordinate{10.0339, 5.89528}, // BLC
    Coordinate{-114.861, 35.9475}, // BLD
    Coordinate{15.515, 60.4219}, // BLE
    Coordinate{-81.2078, 37.2958}, // BLF
    Coordinate{113.761, 2.63611}, // BLG
    Coordinate{-114.713, 33.6147}, // BLH
    Coordinate{6.30925, 35.7518}, // BLJ
    Coordinate{-3.02833, 53.7714}, // BLK
    Coordinate{9.15194, 55.7403}, // BLL
    Coordinate{-74.125, 40.1869}, // BLM
    Coordinate{146.007, -36.5519}, // BLN
    Coordinate{-20.2875, 65.645}, // BLO
    Coordinate{11.2887, 44.5354}, // BLQ
    Coordinate{77.7056, 13.1989}, // BLR
    Coordinate{148.807, -23.6031}, // BLT
    Coordinate{-120.71, 39.275}, // BLU
    Coordinate{12.2481, 46.1667}, // BLX
    Coordinate{-10.0308, 54.2228}, // BLY
    Coordinate{34.9676, -15.6798}, // BLZ
    Coordinate{17.9397, 59.3544}, // BMA
    Coordinate{22.4817, 2.1828}, // BMB
    Coordinate{-112.062, 41.5525}, // BMC
    Coordinate{44.5333, -19.6872}, // BMD
    Coordinate{122.232, -17.9447}, // BME
    Coordinate{22.8006, 5.69417}, // BMF
    Coordinate{-86.6167, 39.1461}, // BMG
    Coordinate{144.633, -6.3667}, // BMH
    Coordinate{-88.9158, 40.4772}, // BMI
    Coordinate{-60.5, 7.37012}, // BMJ
    Coordinate{-71.1758, 44.5753}, // BML
    Coordinate{11.4933, 2.07556}, // BMM
    Coordinate{97.2469, 24.2667}, // BMO
    Coordinate{84.8769, 19.2975}, // BMP
    Coordinate{39.7312, -3.98005}, // BMQ
    Coordinate{-94.215, 30.0703}, // BMT
    Coordinate{118.687, -8.53972}, // BMU
    Coordinate{108.12, 12.6681}, // BMV
    Coordinate{0.927, 21.3778}, // BMW
    Coordinate{163.661, -19.7206}, // BMY
    Coordinate{143.233, -7.83333}, // BMZ
    Coordinate{-86.6819, 36.1267}, // BNA
    Coordinate{20.8667, -0.2833}, // BNB
    Coordinate{56.3778, 27.2181}, // BND
    Coordinate{153.118, -27.3833}, // BNE
    Coordinate{-116.851, 33.9225}, // BNG
    Coordinate{5.59944, 6.31694}, // BNI
    Coordinate{153.562, -28.8333}, // BNK
    Coordinate{-81.3881, 33.2581}, // BNL
    Coordinate{12.2175, 65.4611}, // BNN
    Coordinate{-118.956, 43.5919}, // BNO
    Coordinate{70.5242, 32.9719}, // BNP
    Coordinate{-4.717, 10.683}, // BNR
    Coordinate{-70.2208, 8.61944}, // BNS
    Coordinate{-49.0936, -26.8328}, // BNU
    Coordinate{-93.8475, 42.0494}, // BNW
    Coordinate{17.2975, 44.9414}, // BNX
    Coordinate{159.798, -11.3017}, // BNY
    Coordinate{144.557, -5.7842}, // BNZ
    Coordinate{13.0636, -5.86667}, // BOA
    Coordinate{-151.753, -16.4436}, // BOB
    Coordinate{-82.2508, 9.34083}, // BOC
    Coordinate{-0.715556, 44.8283}, // BOD
    Coordinate{15.3833, -1.0333}, // BOE
    Coordinate{-74.1469, 4.70139}, // BOG
    Coordinate{-1.8425, 50.78}, // BOH
    Coordinate{-116.223, 43.5644}, // BOI
    Coordinate{27.5153, 42.5703}, // BOJ
    Coordinate{-124.29, 42.0744}, // BOK
    Coordinate{-7.0203, 55.0603}, // BOL
    Coordinate{72.8681, 19.0886}, // BOM
    Coordinate{-68.2686, 12.1311}, // BON
    Coordinate{14.3653, 67.2692}, // BOO
    Coordinate{15.6378, 5.9625}, // BOP
    Coordinate{155.2, -6.267}, // BOQ
    Coordinate{-71.0064, 42.3631}, // BOS
    Coordinate{141.092, -7.24083}, // BOT
    Coordinate{153.333, -3.36667}, // BOV
    Coordinate{136.3, -16.0753}, // BOX
    Coordinate{-4.33083, 11.16}, // BOY
    Coordinate{16.3167, 6.3333}, // BOZ
    Coordinate{10.1167, 6.03917}, // BPC
    Coordinate{147, -7.75}, // BPD
    Coordinate{119.058, 39.6625}, // BPE
    Coordinate{158, -8.63}, // BPF
    Coordinate{-52.3894, -15.8608}, // BPG
    Coordinate{126.324, 8.19637}, // BPH
    Coordinate{-110.111, 42.585}, // BPI
    Coordinate{141.744, -5.52639}, // BPK
    Coordinate{82.2997, 44.895}, // BPL
    Coordinate{78.4675, 17.4531}, // BPM
    Coordinate{116.894, -1.26833}, // BPN
    Coordinate{-39.0778, -16.4381}, // BPS
    Coordinate{-94.0206, 29.9508}, // BPT
    Coordinate{97.1086, 30.5536}, // BPX
    Coordinate{44.4833, -16.75}, // BPY
    Coordinate{121.502, 15.7303}, // BQA
    Coordinate{115.4, -33.6872}, // BQB
    Coordinate{-15.8381, 11.2972}, // BQE
    Coordinate{140.449, 52.3806}, // BQG
    Coordinate{0.0325, 51.3308}, // BQH
    Coordinate{134.695, 67.6489}, // BQJ
    Coordinate{-81.4664, 31.2589}, // BQK
    Coordinate{139.9, -22.9133}, // BQL
    Coordinate{-67.1294, 18.4949}, // BQN
    Coordinate{-3.0338, 9.254}, // BQO
    Coordinate{127.413, 50.425}, // BQS
    Coordinate{23.8981, 52.1083}, // BQT
    Coordinate{-61.2644, 12.9869}, // BQU
    Coordinate{127.973, -20.1483}, // BQW
    Coordinate{-45.01, -12.08}, // BRA
    Coordinate{-42.8058, -2.75639}, // BRB
    Coordinate{-71.1578, -41.1511}, // BRC
    Coordinate{-94.1356, 46.4022}, // BRD
    Coordinate{8.78667, 53.0475}, // BRE
    Coordinate{16.7606, 41.1389}, // BRI
    Coordinate{145.952, -30.0392}, // BRK
    Coordinate{-91.1256, 40.7831}, // BRL
    Coordinate{-69.3586, 10.0428}, // BRM
    Coordinate{7.49917, 46.9122}, // BRN
    Coordinate{-97.4258, 25.9069}, // BRO
    Coordinate{146.35, -7.6667}, // BRP
    Coordinate{16.6944, 49.1514}, // BRQ
    Coordinate{-2.71917, 51.3828}, // BRS
    Coordinate{130.62, -11.7692}, // BRT
    Coordinate{4.48444, 50.9014}, // BRU
    Coordinate{-156.766, 71.2856}, // BRW
    Coordinate{-71.1219, 18.2517}, // BRX
    Coordinate{-85.4997, 37.8144}, // BRY
    Coordinate{49.15, 11.2756}, // BSA
    Coordinate{-47.9186, -15.8711}, // BSB
    Coordinate{-77.3944, 6.20278}, // BSC
    Coordinate{99.1683, 25.0533}, // BSD
    Coordinate{109.763, 1.81361}, // BSE
    Coordinate{9.80282, 1.90104}, // BSG
    Coordinate{147.568, -37.8875}, // BSJ
    Coordinate{5.73831, 34.7934}, // BSK
    Coordinate{7.52917, 47.59}, // EAP
    Coordinate{17.4333, 6.5}, // BSN
    Coordinate{121.979, 20.4504}, // BSO
    Coordinate{141.256, -8.8563}, // BSP
    Coordinate{-109.883, 31.3639}, // BSQ
    Coordinate{47.6625, 30.5489}, // BSR
    Coordinate{-46.0533, -7.5253}, // BSS
    Coordinate{64.3647, 31.5588}, // BST
    Coordinate{19.7889, 1.21667}, // BSU
    Coordinate{-146.146, 60.4231}, // BSW
    Coordinate{94.78, 16.8125}, // BSX
    Coordinate{42.3077, 2.33672}, // BSY
    Coordinate{13.7167, 4.54861}, // BTA
    Coordinate{18.5, 3.05}, // BTB
    Coordinate{-111.927, 40.8694}, // BTF
    Coordinate{18.3, 7.3167}, // BTG
    Coordinate{104.119, 1.12083}, // BTH
    Coordinate{-143.582, 70.1339}, // BTI
    Coordinate{95.4203, 5.52333}, // BTJ
    Coordinate{101.698, 56.37}, // BTK
    Coordinate{-85.25, 42.3064}, // BTL
    Coordinate{-112.497, 45.9547}, // BTM
    Coordinate{-79.7344, 34.6217}, // BTN
    Coordinate{-55.447, 4.21751}, // BTO
    Coordinate{-79.9497, 40.7769}, // BTP
    Coordinate{29.74, -2.595}, // BTQ
    Coordinate{-91.15, 30.5328}, // BTR
    Coordinate{17.2128, 48.17}, // BTS
    Coordinate{-151.529, 66.9139}, // BTT
    Coordinate{113.02, 3.12361}, // BTU
    Coordinate{-73.1533, 44.4719}, // BTV
    Coordinate{116, -3.45}, // BTW
    Coordinate{-116.787, 36.8611}, // BTY
    Coordinate{154.673, -5.42222}, // BUA
    Coordinate{139.534, -17.7486}, // BUC
    Coordinate{19.2619, 47.4394}, // BUD
    Coordinate{-78.7322, 42.9406}, // BUF
    Coordinate{13.4036, -12.6089}, // BUG
    Coordinate{138.65, -3.71667}, // BUI
    Coordinate{4.20575, 35.3327}, // BUJ
    Coordinate{43.7667, 15.8333}, // BUK
    Coordinate{146.649, -7.21611}, // BUL
    Coordinate{-76.9897, 3.81972}, // BUN
    Coordinate{45.5667, 9.5}, // BUO
    Coordinate{74.7556, 30.27}, // BUP
    Coordinate{28.6179, -20.0174}, // BUQ
    Coordinate{-118.359, 34.2006}, // BUR
    Coordinate{41.5994, 41.6103}, // BUS
    Coordinate{90.7464, 27.5628}, // BUT
    Coordinate{102.183, -1.5425}, // BUU
    Coordinate{-57.5597, -30.3194}, // BUV
    Coordinate{122.568, -5.48778}, // BUW
    Coordinate{30.2167, 1.56583}, // BUX
    Coordinate{115.677, -33.3781}, // BUY
    Coordinate{50.8303, 28.9448}, // BUZ
    Coordinate{2.11278, 49.4544}, // BVA
    Coordinate{-60.6922, 2.84139}, // BVB
    Coordinate{-22.8886, 16.1372}, // BVC
    Coordinate{1.48556, 45.0397}, // BVE
    Coordinate{178.617, -16.8}, // BVF
    Coordinate{29.0342, 70.8714}, // BVG
    Coordinate{139.348, -25.8975}, // BVI
    Coordinate{68.3366, 70.3198}, // BVJ
    Coordinate{-63.8783, -13.6066}, // BVK
    Coordinate{-63.5833, -13.5833}, // BVL
    Coordinate{-96.0111, 36.7642}, // BVO
    Coordinate{141.7, -5.38333}, // BVP
    Coordinate{-151.045, 61.1731}, // BVU
    Coordinate{147.622, 44.92}, // BVV
    Coordinate{142.675, -12.6592}, // BVW
    Coordinate{-91.6475, 35.7261}, // BVX
    Coordinate{-70.9165, 42.5842}, // BVY
    Coordinate{83.4161, 27.5056}, // BWA
    Coordinate{115.405, -20.8658}, // BWB
    Coordinate{-115.517, 32.9931}, // BWC
    Coordinate{-98.9564, 31.7936}, // BWD
    Coordinate{10.5553, 52.3192}, // BWE
    Coordinate{-3.26722, 54.1286}, // BWF
    Coordinate{-86.4197, 36.9644}, // BWG
    Coordinate{100.391, 5.46611}, // BWH
    Coordinate{-76.6675, 39.1782}, // BWI
    Coordinate{146.9, -6.4}, // BWJ
    Coordinate{16.6797, 43.2858}, // BWK
    Coordinate{-97.3494, 36.745}, // BWL
    Coordinate{114.928, 4.9442}, // BWN
    Coordinate{47.75, 51.85}, // BWO
    Coordinate{141.165, -3.0222}, // BWP
    Coordinate{146.817, -29.9739}, // BWQ
    Coordinate{145.731, -40.9989}, // BWT
    Coordinate{150.988, -33.925}, // BWU
    Coordinate{-79.1472, 22.6211}, // BWW
    Coordinate{114.34, -8.3106}, // BWX
    Coordinate{133.417, -2.55}, // BXB
    Coordinate{139.583, -7.16667}, // BXD
    Coordinate{-12.4833, 14.8472}, // BXE
    Coordinate{144.33, -36.7394}, // BXG
    Coordinate{75.005, 46.8933}, // BXH
    Coordinate{-6.467, 9.533}, // BXI
    Coordinate{76.8825, 43.3517}, // BXJ
    Coordinate{-112.686, 33.4206}, // BXK
    Coordinate{140.882, -4.44294}, // BXM
    Coordinate{27.6556, 37.1361}, // BXN
    Coordinate{8.39694, 46.9744}, // BXO
    Coordinate{23.1325, 52.0006}, // BXP
    Coordinate{58.4497, 29.0828}, // BXR
    Coordinate{-116.321, 33.2589}, // BXS
    Coordinate{117.477, 0.121661}, // BXT
    Coordinate{125.478, 8.95132}, // BXU
    Coordinate{-14.0228, 64.79}, // BXV
    Coordinate{112.679, -5.72361}, // BXW
    Coordinate{43.1508, 9.94556}, // BXX
    Coordinate{63.2144, 45.6183}, // BXY
    Coordinate{147.9, -5.717}, // BXZ
    Coordinate{56.2457, 25.6146}, // BYB
    Coordinate{-63.6517, -21.9608}, // BYC
    Coordinate{45.4403, 14.1056}, // BYD
    Coordinate{2.6925, 49.97}, // BYF
    Coordinate{-89.9439, 35.9644}, // BYH
    Coordinate{-113.772, 42.5425}, // BYI
    Coordinate{-7.9325, 38.0789}, // BYJ
    Coordinate{-5.07361, 7.73889}, // BYK
    Coordinate{-9.59, 7.22}, // BYL
    Coordinate{-76.6214, 20.3964}, // BYM
    Coordinate{100.7, 46.1706}, // BYN
    Coordinate{-56.4561, -21.2472}, // BYO
    Coordinate{119.166, -22.6739}, // BYP
    Coordinate{10.9997, 57.2769}, // BYR
    Coordinate{-9.48444, 51.6689}, // BYT
    Coordinate{35.4728, -21.5428}, // BZB
    Coordinate{-41.9656, -22.771}, // BZC
    Coordinate{143.578, -34.6236}, // BZD
    Coordinate{-88.3083, 17.5392}, // BZE
    Coordinate{-122.408, 40.5742}, // BZF
    Coordinate{17.9778, 53.0967}, // BZG
    Coordinate{34.1764, 53.2142}, // BZK
    Coordinate{90.3012, 22.801}, // BZL
    Coordinate{-111.152, 45.7775}, // BZN
    Coordinate{11.3264, 46.4603}, // BZO
    Coordinate{3.35333, 43.3233}, // BZR
    Coordinate{24.7833, 2.81667}, // BZU
    Coordinate{15.253, -4.2517}, // BZV
    Coordinate{106.633, 30.7}, // BZX
    Coordinate{27.7772, 47.8431}, // BZY
    Coordinate{-85.9, 14.8756}, // CAA
    Coordinate{12.1881, -5.59711}, // CAB
    Coordinate{-85.4189, 44.2753}, // CAD
    Coordinate{-81.1194, 33.9389}, // CAE
    Coordinate{-66.8975, -4.87861}, // CAF
    Coordinate{9.05428, 39.2515}, // CAG
    Coordinate{105.179, 9.17556}, // CAH
    Coordinate{31.4056, 30.1219}, // CAI
    Coordinate{-62.8542, 6.23194}, // CAJ
    Coordinate{-81.4422, 40.9161}, // CAK
    Coordinate{-5.68639, 55.4372}, // CAL
    Coordinate{113.299, 23.3924}, // CAN
    Coordinate{-103.15, 36.4464}, // CAO
    Coordinate{-72.2, 19.7331}, // CAP
    Coordinate{-75.1983, 7.96802}, // CAQ
    Coordinate{-68.0179, 46.8715}, // CAR
    Coordinate{-9.35528, 38.7256}, // CAT
    Coordinate{-36.0108, -8.28444}, // CAU
    Coordinate{22.916, -11.8929}, // CAV
    Coordinate{-41.3078, -21.7011}, // CAW
    Coordinate{-2.8092, 54.9375}, // CAX
    Coordinate{-52.3619, 4.81972}, // CAY
    Coordinate{145.793, -31.5383}, // CAZ
    Coordinate{-66.1775, -17.4208}, // CBB
    Coordinate{-78.7608, 39.6156}, // CBE
    Coordinate{-95.7586, 41.26}, // CBF
    Coordinate{0.175, 52.205}, // CBG
    Coordinate{-2.26119, 31.6547}, // CBH
    Coordinate{-71.6447, 17.9289}, // CBJ
    Coordinate{-101.047, 39.4275}, // CBK
    Coordinate{-63.5361, 8.12222}, // CBL
    Coordinate{108.54, -6.75614}, // CBN
    Coordinate{124.21, 7.16076}, // CBO
    Coordinate{-8.47222, 40.1614}, // CBP
    Coordinate{8.34694, 4.97583}, // CBQ
    Coordinate{149.195, -35.3069}, // CBR
    Coordinate{-71.3225, 10.33}, // CBS
    Coordinate{13.4873, -12.4795}, // CBT
    Coordinate{-90.4067, 15.4689}, // CBV
    Coordinate{147.208, -33.065}, // CBX
    Coordinate{-65.1415, -16.99}, // CCA
    Coordinate{-117.688, 34.1117}, // CCB
    Coordinate{-78.3286, 22.4611}, // CCC
    Coordinate{31.8382, 30.0553}, // CCE
    Coordinate{2.30861, 43.2158}, // CCF
    Coordinate{-71.6907, -46.5827}, // CCH
    Coordinate{-52.0511, -27.1806}, // CCI
    Coordinate{75.9504, 11.1381}, // CCJ
    Coordinate{96.8339, -12.1883}, // CCK
    Coordinate{150.617, -26.775}, // CCL
    Coordinate{-49.4214, -28.7244}, // CCM
    Coordinate{65.2706, 34.5264}, // CCN
    Coordinate{-71.3367, 4.56417}, // CCO
    Coordinate{-73.0631, -36.7725}, // CCP
    Coordinate{-122.057, 37.9897}, // CCR
    Coordinate{-66.9906, 10.6031}, // CCS
    Coordinate{-67.8403, -37.9161}, // CCT
    Coordinate{88.4467, 22.6539}, // CCU
    Coordinate{167.924, -16.265}, // CCV
    Coordinate{136.892, -33.6667}, // CCW
    Coordinate{-92.6108, 43.0725}, // CCY
    Coordinate{-77.8833, 25.4167}, // CCZ
    Coordinate{-162.724, 55.2053}, // CDB
    Coordinate{-113.099, 37.7008}, // CDC
    Coordinate{-83.5917, 15.3167}, // CDD
    Coordinate{118.072, 41.1219}, // CDE
    Coordinate{2.54778, 49.0097}, // CDG
    Coordinate{-92.7633, 33.6228}, // CDH
    Coordinate{-41.1875, -20.8367}, // CDI
    Coordinate{-49.3031, -8.34861}, // CDJ
    Coordinate{-83.0506, 29.1342}, // CDK
    Coordinate{-80.565, 34.2836}, // CDN
    Coordinate{78.7728, 14.51}, // CDP
    Coordinate{-103.095, 42.8375}, // CDR
    Coordinate{-100.288, 34.4339}, // CDS
    Coordinate{0.0697222, 40.2097}, // CDT
    Coordinate{150.687, -34.04}, // CDU
    Coordinate{-145.477, 60.4917}, // CDV
    Coordinate{-74.2814, 40.8753}, // CDW
    Coordinate{118.495, 7.0127}, // CDY
    Coordinate{-97.2506, 37.6486}, // CEA
    Coordinate{123.983, 10.3167}, // CEB
    Coordinate{-124.237, 41.7803}, // CEC
    Coordinate{133.71, -32.1306}, // CED
    Coordinate{38.0283, 59.2767}, // CEE
    Coordinate{-72.5347, 42.1939}, // CEF
    Coordinate{-2.97778, 53.1781}, // CEG
    Coordinate{33.8, -10.55}, // CEH
    Coordinate{99.8828, 19.9522}, // CEI
    Coordinate{31.16, 51.4033}, // CEJ
    Coordinate{61.505, 55.305}, // CEK
    Coordinate{-76.2947, 24.7903}, // CEL
    Coordinate{-144.781, 65.5739}, // CEM
    Coordinate{-109.833, 27.3925}, // CEN
    Coordinate{15.1014, -11.4264}, // CEO
    Coordinate{-62.026, -16.1472}, // CEP
    Coordinate{6.95417, 43.5464}, // CEQ
    Coordinate{-1.47528, 49.6508}, // CER
    Coordinate{151.342, -32.7883}, // CES
    Coordinate{-82.8868, 34.6719}, // CEU
    Coordinate{-85.1311, 39.6983}, // CEV
    Coordinate{-86.5221, 30.7788}, // CEW
    Coordinate{-88.3728, 36.6644}, // CEY
    Coordinate{-108.628, 37.3031}, // CEZ
    Coordinate{-42.0714, -22.9208}, // CFB
    Coordinate{-50.9397, -26.7897}, // CFC
    Coordinate{-96.3314, 30.7156}, // CFD
    Coordinate{3.1625, 45.7858}, // CFE
    Coordinate{17.9897, -8.78361}, // CFF
    Coordinate{-80.3975, 22.15}, // CFG
    Coordinate{-111.279, 55.6961}, // CFM
    Coordinate{-8.34111, 55.0442}, // CFN
    Coordinate{-51.5672, -10.6336}, // CFO
    Coordinate{-116.498, 49.0367}, // CFQ
    Coordinate{-0.45, 49.1733}, // CFR
    Coordinate{153.116, -30.3206}, // CFS
    Coordinate{-109.211, 32.9569}, // CFT
    Coordinate{19.9122, 39.6019}, // CFU
    Coordinate{-95.5719, 37.0942}, // CFV
    Coordinate{-133.148, 55.4789}, // CGA
    Coordinate{-56.1175, -15.65}, // CGB
    Coordinate{148.432, -5.45917}, // CGC
    Coordinate{111.64, 28.9189}, // CGD
    Coordinate{-76.0303, 38.5394}, // CGE
    Coordinate{-81.4864, 41.565}, // CGF
    Coordinate{-46.6564, -23.6261}, // CGH
    Coordinate{-89.5708, 37.2253}, // CGI
    Coordinate{27.85, -12.5728}, // CGJ
    Coordinate{106.654, -6.12736}, // CGK
    Coordinate{124.707, 9.25361}, // CGM
    Coordinate{7.14278, 50.8658}, // CGN
    Coordinate{113.841, 34.5197}, // CGO
    Coordinate{91.8133, 22.2497}, // CGP
    Coordinate{125.201, 43.9057}, // CGQ
    Coordinate{-54.6703, -20.4694}, // CGR
    Coordinate{-76.9223, 38.9806}, // CGS
    Coordinate{-12.3833, 20.4833}, // CGT
    Coordinate{124.457, 8.6125}, // CGY
    Coordinate{-111.767, 32.955}, // CGZ
    Coordinate{-85.2039, 35.0353}, // CHA
    Coordinate{74.085, 35.4269}, // CHB
    Coordinate{172.532, -43.4894}, // CHC
    Coordinate{128.695, 35.1411}, // CHF
    Coordinate{120.435, 41.5381}, // CHG
    Coordinate{-77.8561, -6.20194}, // CHH
    Coordinate{32.6283, -20.2067}, // CHJ
    Coordinate{-97.9678, 35.0972}, // CHK
    Coordinate{-114.218, 44.5236}, // CHL
    Coordinate{-78.5239, -9.14972}, // CHM
    Coordinate{127.119, 35.8783}, // CHN
    Coordinate{-78.4529, 38.1386}, // CHO
    Coordinate{-144.611, 65.4856}, // CHP
    Coordinate{24.1497, 35.5317}, // CHQ
    Coordinate{1.72111, 46.8603}, // CHR
    Coordinate{-80.0406, 32.8986}, // CHS
    Coordinate{-176.457, -43.81}, // CHT
    Coordinate{-159.216, 61.5792}, // CHU
    Coordinate{-7.46315, 41.7223}, // CHV
    Coordinate{-82.5486, 9.45889}, // CHX
    Coordinate{156.396, -6.71194}, // CHY
    Coordinate{-121.876, 42.5831}, // CHZ
    Coordinate{12.5972, 41.7994}, // CIA
    Coordinate{-121.858, 39.7953}, // CIC
    Coordinate{-91.7003, 41.8891}, // CID
    Coordinate{118.908, 42.235}, // CIF
    Coordinate{-107.522, 40.4953}, // CIG
    Coordinate{113.126, 36.2475}, // CIH
    Coordinate{27.8885, 37.815}, // CII
    Coordinate{-68.7828, -11.0403}, // CIJ
    Coordinate{-143.74, 66.645}, // CIK
    Coordinate{-163.703, 64.8978}, // CIL
    Coordinate{-73.9706, 6.36667}, // CIM
    Coordinate{-94.7889, 42.0461}, // CIN
    Coordinate{-57.4272, -23.4417}, // CIO
    Coordinate{32.5869, -13.5569}, // CIP
    Coordinate{-89.5208, 14.8311}, // CIQ
    Coordinate{-89.2194, 37.0639}, // CIR
    Coordinate{-171.713, -2.77}, // CIS
    Coordinate{69.4761, 42.365}, // CIT
    Coordinate{-84.4725, 46.2508}, // CIU
    Coordinate{-61.3444, 12.6992}, // CIW
    Coordinate{-79.8281, -6.78722}, // CIX
    Coordinate{14.6069, 36.9917}, // CIY
    Coordinate{-63.1311, -4.13389}, // CIZ
    Coordinate{-78.4892, -7.13917}, // CJA
    Coordinate{77.0419, 11.0305}, // CJB
    Coordinate{-68.9036, -22.4897}, // CJC
    Coordinate{118.802, -22.9667}, // CJF
    Coordinate{-124.142, 51.6261}, // CJH
    Coordinate{127.499, 36.7164}, // CJJ
    Coordinate{71.7999, 35.8862}, // CJL
    Coordinate{99.3617, 10.7111}, // CJM
    Coordinate{108.49, -7.72039}, // CJN
    Coordinate{-106.429, 31.6361}, // CJS
    Coordinate{-92.0483, 16.175}, // CJT
    Coordinate{126.493, 33.5122}, // CJU
    Coordinate{-80.2281, 39.2967}, // CKB
    Coordinate{31.9953, 49.4156}, // CKC
    Coordinate{-158.135, 61.8678}, // CKD
    Coordinate{-122.901, 38.9906}, // CKE
    Coordinate{106.642, 29.7192}, // CKG
    Coordinate{147.897, 70.625}, // CKH
    Coordinate{132.483, -11.1653}, // CKI
    Coordinate{-91.5628, 36.265}, // CKK
    Coordinate{-90.5122, 34.2997}, // CKM
    Coordinate{-96.6217, 47.8408}, // CKN
    Coordinate{-50.6028, -23.1528}, // CKO
    Coordinate{-50.0042, -6.11778}, // CKS
    Coordinate{61.07, 36.4881}, // CKT
    Coordinate{-145.727, 60.4889}, // CKU
    Coordinate{-87.415, 36.6219}, // CKV
    Coordinate{119.652, -22.3556}, // CKW
    Coordinate{-141.952, 64.0714}, // CKX
    Coordinate{-13.6119, 9.57689}, // CKY
    Coordinate{91.1899, 23.4368}, // CLA
    Coordinate{-117.28, 33.1283}, // CLD
    Coordinate{-81.8497, 41.4117}, // CLE
    Coordinate{-120.294, 36.1631}, // CLG
    Coordinate{149.61, -31.7733}, // CLH
    Coordinate{-88.7308, 44.6133}, // CLI
    Coordinate{23.6861, 46.7851}, // CLJ
    Coordinate{-98.9328, 35.5383}, // CLK
    Coordinate{-96.3639, 30.5886}, // CLL
    Coordinate{-123.5, 48.1203}, // CLM
    Coordinate{-76.3814, 3.54306}, // CLO
    Coordinate{-158.529, 58.8336}, // CLP
    Coordinate{-103.578, 19.2769}, // CLQ
    Coordinate{-115.521, 33.1314}, // CLR
    Coordinate{-122.986, 46.4062}, // CLS
    Coordinate{-85.8964, 39.2619}, // CLU
    Coordinate{-48.61, -17.7247}, // CLV
    Coordinate{-82.7586, 27.9767}, // CLW
    Coordinate{-57.7348, -25.3048}, // CLX
    Coordinate{8.79, 42.525}, // CLY
    Coordinate{-67.4169, 8.92444}, // CLZ
    Coordinate{145.622, -28.03}, // CMA
    Coordinate{79.8836, 7.18111}, // CMB
    Coordinate{148.035, -34.625}, // CMD
    Coordinate{-91.7995, 18.652}, // CME
    Coordinate{5.88, 45.6392}, // CMF
    Coordinate{-57.6714, -19.0119}, // CMG
    Coordinate{-82.8919, 39.9981}, // CMH
    Coordinate{-88.2781, 40.0392}, // CMI
    Coordinate{119.418, 23.2131}, // CMJ
    Coordinate{35.1325, -14.3069}, // CMK
    Coordinate{138.125, -19.9117}, // CML
    Coordinate{-90.0528, 17.45}, // CMM
    Coordinate{-7.58167, 33.3642}, // CMN
    Coordinate{48.5256, 5.35}, // CMO
    Coordinate{-50.3503, -9.33528}, // CMP
    Coordinate{147.62, -22.7733}, // CMQ
    Coordinate{7.35917, 48.1103}, // CMR
    Coordinate{50.2056, 10.3}, // CMS
    Coordinate{144.97, -6.02417}, // CMU
    Coordinate{175.509, -36.7917}, // CMV
    Coordinate{-77.8475, 21.4203}, // CMW
    Coordinate{-88.4892, 47.168}, // CMX
    Coordinate{-90.7378, 43.9583}, // CMY
    Coordinate{-110.267, 31}, // CNA
    Coordinate{148.375, -30.9834}, // CNB
    Coordinate{143.067, -10.05}, // CNC
    Coordinate{28.4883, 44.3622}, // CND
    Coordinate{-43.9719, -19.6244}, // CNF
    Coordinate{-72.3686, 43.3706}, // CNH
    Coordinate{122.667, 39.2664}, // CNI
    Coordinate{140.504, -20.6686}, // CNJ
    Coordinate{-97.6522, 39.5492}, // CNK
    Coordinate{10.2266, 57.5047}, // CNL
    Coordinate{-104.263, 32.3375}, // CNM
    Coordinate{75.548, 11.9199}, // CNN
    Coordinate{-117.637, 33.9747}, // CNO
    Coordinate{-22.6486, 70.7433}, // CNP
    Coordinate{-58.7619, -27.4456}, // CNQ
    Coordinate{-70.6074, -26.3344}, // CNR
    Coordinate{145.755, -16.8858}, // CNS
    Coordinate{-95.485, 37.6689}, // CNU
    Coordinate{-97.0742, 31.6378}, // CNW
    Coordinate{98.9625, 18.7667}, // CNX
    Coordinate{-109.755, 38.755}, // CNY
    Coordinate{19.8604, -13.7094}, // CNZ
    Coordinate{-120.414, 38.0306}, // COA
    Coordinate{-57.9967, -31.2969}, // COC
    Coordinate{-109.024, 44.5203}, // COD
    Coordinate{-116.819, 47.7744}, // COE
    Coordinate{-76.6833, 5.07119}, // COG
    Coordinate{89.4679, 26.3307}, // COH
    Coordinate{-80.6856, 28.3417}, // COI
    Coordinate{149.267, -31.3333}, // COJ
    Coordinate{76.4019, 10.1519}, // COK
    Coordinate{-99.4033, 31.8411}, // COM
    Coordinate{-71.5022, 43.2028}, // CON
    Coordinate{2.385, 6.35583}, // COO
    Coordinate{-74.8911, 42.6292}, // COP
    Coordinate{114.646, 48.1356}, // COQ
    Coordinate{-64.2083, -31.31}, // COR
    Coordinate{-104.701, 38.8058}, // COS
    Coordinate{-99.2183, 28.4567}, // COT
    Coordinate{-92.2197, 38.8181}, // COU
    Coordinate{117.759, -21.7942}, // COY
    Coordinate{-70.7197, 18.9075}, // COZ
    Coordinate{-7.70012, 4.36764}, // CPA
    Coordinate{-77.3502, 8.63028}, // CPB
    Coordinate{-71.1372, -40.0753}, // CPC
    Coordinate{134.721, -29.04}, // CPD
    Coordinate{-90.5008, 19.8158}, // CPE
    Coordinate{111.548, -7.19472}, // CPF
    Coordinate{-62.9803, -40.7781}, // CPG
    Coordinate{12.6561, 55.6181}, // CPH
    Coordinate{152.083, -5.4333}, // CPI
    Coordinate{-75.467, 3.717}, // CPL
    Coordinate{-118.244, 33.89}, // CPM
    Coordinate{148.4, -10.18}, // CPN
    Coordinate{-70.7792, -27.2612}, // CPO
    Coordinate{-47.1081, -22.8592}, // CPQ
    Coordinate{-106.464, 42.9081}, // CPR
    Coordinate{-90.1561, 38.5708}, // CPS
    Coordinate{18.5972, -33.9694}, // CPT
    Coordinate{-35.895, -7.26917}, // CPV
    Coordinate{-65.3044, 18.3133}, // CPX
    Coordinate{-52.2708, -13.5744}, // CQA
    Coordinate{50.8422, 32.2972}, // CQD
    Coordinate{1.95139, 50.9606}, // CQF
    Coordinate{23.8886, 44.3181}, // CRA
    Coordinate{148.582, -29.5219}, // CRB
    Coordinate{-75.9558, 4.75833}, // CRC
    Coordinate{-67.4656, -45.7853}, // CRD
    Coordinate{-78.7239, 33.8117}, // CRE
    Coordinate{15.9, 4.93333}, // CRF
    Coordinate{-81.5144, 30.3364}, // CRG
    Coordinate{-74.1822, 22.7456}, // CRI
    Coordinate{120.56, 15.1858}, // CRK
    Coordinate{4.45382, 50.4592}, // CRL
    Coordinate{124.636, 12.5022}, // CRM
    Coordinate{-97.5011, 27.7703}, // CRP
    Coordinate{-61.927, -29.8717}, // CRR
    Coordinate{-96.4006, 32.0281}, // CRS
    Coordinate{-91.8803, 33.1783}, // CRT
    Coordinate{-61.4722, 12.4769}, // CRU
    Coordinate{17.0803, 38.9972}, // CRV
    Coordinate{-81.5931, 38.3758}, // CRW
    Coordinate{-88.6036, 34.915}, // CRX
    Coordinate{63.6133, 39.0833}, // CRZ
    Coordinate{22.2522, 45.4202}, // CSB
    Coordinate{-83.5931, 10.1606}, // CSC
    Coordinate{-84.9389, 32.5164}, // CSG
    Coordinate{35.7333, 65.03}, // CSH
    Coordinate{153.067, -28.8833}, // CSI
    Coordinate{-16.7461, 12.3889}, // CSK
    Coordinate{-99.2006, 35.3397}, // CSM
    Coordinate{-119.734, 39.1922}, // CSN
    Coordinate{11.418, 51.8559}, // CSO
    Coordinate{-94.3633, 41.0214}, // CSQ
    Coordinate{-52.4122, -29.6836}, // CSU
    Coordinate{113.221, 28.1967}, // CSX
    Coordinate{47.3472, 56.09}, // CSY
    Coordinate{-61.8893, -37.4461}, // CSZ
    Coordinate{15.0639, 37.4667}, // CTA
    Coordinate{-112.376, 48.6083}, // CTB
    Coordinate{-65.7511, -28.5931}, // CTC
    Coordinate{-80.4097, 7.98778}, // CTD
    Coordinate{-79.1, 9.31667}, // CTE
    Coordinate{-91.8825, 14.6942}, // CTF
    Coordinate{-75.5128, 10.442}, // CTG
    Coordinate{-75.8656, 39.9789}, // CTH
    Coordinate{19.1561, -15.1605}, // CTI
    Coordinate{-96.5712, 43.309}, // CTK
    Coordinate{146.262, -26.4133}, // CTL
    Coordinate{-88.3269, 18.5046}, // CTM
    Coordinate{145.184, -15.4447}, // CTN
    Coordinate{-72.7932, 40.9134}, // CTO
    Coordinate{-53.3442, -33.5022}, // CTQ
    Coordinate{141.692, 42.7752}, // CTS
    Coordinate{5.78611, 43.2522}, // CTT
    Coordinate{103.948, 30.58}, // CTU
    Coordinate{-76.2147, 42.5925}, // CTX
    Coordinate{-83.1047, 29.6356}, // CTY
    Coordinate{-78.3656, 34.975}, // CTZ
    Coordinate{-111.615, 25.0539}, // CUA
    Coordinate{-80.9953, 33.9706}, // CUB
    Coordinate{-72.5117, 7.9275}, // CUC
    Coordinate{153.105, -26.8017}, // CUD
    Coordinate{-78.9844, -2.88944}, // CUE
    Coordinate{7.62182, 44.546}, // CUF
    Coordinate{-96.7733, 35.95}, // CUH
    Coordinate{-88.0294, 17.735}, // CUK
    Coordinate{-107.475, 24.7644}, // CUL
    Coordinate{-64.1306, 10.4503}, // CUM
    Coordinate{-86.8769, 21.0367}, // CUN
    Coordinate{-71.2972, 0.925}, // CUO
    Coordinate{-63.2617, 10.66}, // CUP
    Coordinate{143.114, -13.7619}, // CUQ
    Coordinate{-68.9597, 12.1889}, // CUR
    Coordinate{-107.662, 31.8081}, // CUS
    Coordinate{-69.265, -38.9397}, // CUT
    Coordinate{-105.964, 28.7028}, // CUU
    Coordinate{-72.5366, 8.75639}, // CUV
    Coordinate{117.918, -27.4467}, // CUY
    Coordinate{-71.9436, -13.5356}, // CUZ
    Coordinate{144.715, -4.8066}, // CVB
    Coordinate{136.505, -33.71}, // CVC
    Coordinate{-75.7, 9.4}, // CVE
    Coordinate{6.62717, 45.3974}, // CVF
    Coordinate{-84.6678, 39.0489}, // CVG
    Coordinate{-71.0161, -37.8506}, // CVH
    Coordinate{-99.2619, 18.8345}, // CVJ
    Coordinate{150.02, -9.67}, // CVL
    Coordinate{-98.9565, 23.7033}, // CVM
    Coordinate{-103.079, 34.4253}, // CVN
    Coordinate{-123.289, 44.4972}, // CVO
    Coordinate{113.672, -24.8806}, // CVQ
    Coordinate{-1.47972, 52.3725}, // CVT
    Coordinate{-31.1128, 39.6708}, // CVU
    Coordinate{-89.6667, 44.7775}, // CWA
    Coordinate{-49.1761, -25.5317}, // CWB
    Coordinate{25.9811, 48.2589}, // CWC
    Coordinate{-90.3292, 41.8311}, // CWI
    Coordinate{99.3704, 23.2739}, // CWJ
    Coordinate{-3.34333, 51.3967}, // CWL
    Coordinate{-122.832, 48.49}, // CWS
    Coordinate{148.648, -33.845}, // CWT
    Coordinate{146.352, -35.99}, // CWW
    Coordinate{-109.895, 32.2456}, // CWX
    Coordinate{-66.1653, 7.61921}, // CXA
    Coordinate{91.9648, 21.4498}, // CXB
    Coordinate{-150.204, 67.2522}, // CXF
    Coordinate{-157.359, 1.9861}, // CXI
    Coordinate{-51.1897, -29.1956}, // CXJ
    Coordinate{-115.513, 32.6694}, // CXL
    Coordinate{18.9238, -8.37311}, // CXM
    Coordinate{49.9086, 11.4944}, // CXN
    Coordinate{-95.4144, 30.3525}, // CXO
    Coordinate{109.05, -7.63333}, // CXP
    Coordinate{125.917, -18.8833}, // CXQ
    Coordinate{109.219, 11.9981}, // CXR
    Coordinate{146.273, -20.0433}, // CXT
    Coordinate{-79.2761, 25.5553}, // CXY
    Coordinate{-73.7883, 18.2667}, // CYA
    Coordinate{-79.8828, 19.6869}, // CYB
    Coordinate{-88.0411, 17.7008}, // CYC
    Coordinate{-164.286, 60.1492}, // CYF
    Coordinate{147.888, -36.1828}, // CYG
    Coordinate{120.383, 23.4617}, // CYI
    Coordinate{-86.6833, 15.4458}, // CYL
    Coordinate{-81.5456, 21.6161}, // CYO
    Coordinate{124.545, 12.0727}, // CYP
    Coordinate{-57.7706, -34.4564}, // CYR
    Coordinate{-104.812, 41.1556}, // CYS
    Coordinate{121.068, 10.8581}, // CYU
    Coordinate{-100.886, 20.5458}, // CYW
    Coordinate{161.337, 68.7433}, // CYX
    Coordinate{121.718, 16.93}, // CYZ
    Coordinate{-88.4489, 20.6386}, // CZA
    Coordinate{-145.294, 61.9411}, // CZC
    Coordinate{-69.6817, 11.415}, // CZE
    Coordinate{-166.037, 61.7819}, // CZF
    Coordinate{-88.4108, 18.3822}, // CZH
    Coordinate{-78.5829, 9.44648}, // CZJ
    Coordinate{-121.879, 45.6769}, // CZK
    Coordinate{6.61706, 36.2824}, // CZL
    Coordinate{-86.9289, 20.515}, // CZM
    Coordinate{-142.048, 62.0711}, // CZN
    Coordinate{-72.7694, -7.59944}, // CZS
    Coordinate{-75.2856, 9.33278}, // CZU
    Coordinate{19.2022, 50.8847}, // CZW
    Coordinate{119.776, 31.9193}, // CZX
    Coordinate{-81.0606, 29.1847}, // DAB
    Coordinate{90.4026, 23.8466}, // DAC
    Coordinate{108.199, 16.0439}, // DAD
    Coordinate{-116.787, 34.8536}, // DAG
    Coordinate{29.0031, 25.4116}, // DAK
    Coordinate{-96.8517, 32.8472}, // DAL
    Coordinate{36.5156, 33.4115}, // DAM
    Coordinate{-79.3361, 36.5728}, // DAN
    Coordinate{80.5484, 29.6692}, // DAP
    Coordinate{39.2028, -6.87806}, // DAR
    Coordinate{-119.717, 66.7031}, // DAS
    Coordinate{113.482, 40.0603}, // DAT
    Coordinate{143.208, -9.08667}, // DAU
    Coordinate{-82.435, 8.39111}, // DAV
    Coordinate{107.5, 31.3}, // DAX
    Coordinate{-84.2194, 39.9025}, // DAY
    Coordinate{70.8817, 38.4617}, // DAZ
    Coordinate{64.4044, 28.875}, // DBA
    Coordinate{28.4607, 30.9251}, // DBB
    Coordinate{123.019, 45.5053}, // DBC
    Coordinate{86.4253, 23.8339}, // DBD
    Coordinate{37.7333, 10.3167}, // DBM
    Coordinate{-82.9853, 32.5644}, // DBN
    Coordinate{148.575, -32.2167}, // DBO
    Coordinate{141.9, -6.28333}, // DBP
    Coordinate{-90.7094, 42.4019}, // DBQ
    Coordinate{-112.221, 44.1622}, // DBS
    Coordinate{38, 11.9667}, // DBT
    Coordinate{18.2683, 42.5614}, // DBV
    Coordinate{151.267, -27.1553}, // DBY
    Coordinate{-77.042, 38.854}, // DCA
    Coordinate{-61.3922, 15.3367}, // DCF
    Coordinate{-156.905, 66.9433}, // DCK
    Coordinate{2.29056, 43.555}, // DCM
    Coordinate{-75.7333, 22.1817}, // DCT
    Coordinate{-86.9453, 34.6542}, // DCU
    Coordinate{100.053, 29.3231}, // DCY
    Coordinate{-99.9656, 37.7631}, // DDC
    Coordinate{72.8928, 2.66722}, // DDD
    Coordinate{124.287, 40.0257}, // DDG
    Coordinate{147.45, -8.75}, // DDM
    Coordinate{67.6666, 26.7408}, // DDU
    Coordinate{70.4858, 29.9608}, // DEA
    Coordinate{21.6153, 47.4889}, // DEB
    Coordinate{-88.8656, 39.8344}, // DEC
    Coordinate{78.1803, 30.1897}, // DED
    Coordinate{145.85, 44.0333}, // DEE
    Coordinate{48.3833, 32.4333}, // DEF
    Coordinate{-91.7394, 43.2756}, // DEH
    Coordinate{55.6645, -3.80222}, // DEI
    Coordinate{77.0994, 28.5544}, // DEL
    Coordinate{34.85, 8.55}, // DEM
    Coordinate{-104.673, 39.8617}, // DEN
    Coordinate{94.2233, 27.9889}, // DEP
    Coordinate{120.107, 30.5042}, // DEQ
    Coordinate{53.65, -5.7}, // DES
    Coordinate{-83.01, 42.4092}, // DET
    Coordinate{40.1758, 35.2853}, // DEZ
    Coordinate{-84.4289, 41.3375}, // DFI
    Coordinate{-97.0381, 32.8969}, // DFW
    Coordinate{-88.2586, 16.9825}, // DGA
    Coordinate{149.611, -32.5625}, // DGE
    Coordinate{-120.183, 50.1667}, // DGF
    Coordinate{-109.506, 31.3425}, // DGL
    Coordinate{-104.528, 24.1242}, // DGO
    Coordinate{26.665, 55.9447}, // DGP
    Coordinate{173.894, -35.9397}, // DGR
    Coordinate{123.301, 9.33361}, // DGT
    Coordinate{-3.49, 12.459}, // DGU
    Coordinate{-105.386, 42.7972}, // DGW
    Coordinate{80.5819, 28.7533}, // DHI
    Coordinate{44.7333, 13.7333}, // DHL
    Coordinate{76.2633, 32.165}, // DHM
    Coordinate{-85.4494, 31.3211}, // DHN
    Coordinate{4.78278, 52.9225}, // DHR
    Coordinate{-102.547, 36.0225}, // DHT
    Coordinate{95.018, 27.481}, // DIB
    Coordinate{49.2917, -12.3511}, // DIE
    Coordinate{99.6773, 27.7933}, // DIG
    Coordinate{5.0907, 47.2664}, // DIJ
    Coordinate{-102.802, 46.7972}, // DIK
    Coordinate{125.525, -8.54655}, // DIL
    Coordinate{-4.6411, 6.6}, // DIM
    Coordinate{103.008, 21.3972}, // DIN
    Coordinate{1.783, 12.05}, // DIP
    Coordinate{-44.87, -20.1819}, // DIQ
    Coordinate{41.8542, 9.62361}, // DIR
    Coordinate{11.8858, -4.8133}, // DIS
    Coordinate{70.9211, 20.7131}, // DIU
    Coordinate{-5.3544, 5.7931}, // DIV
    Coordinate{40.2008, 37.8939}, // DIY
    Coordinate{1.6376, 9.692}, // DJA
    Coordinate{103.644, -1.63806}, // DJB
    Coordinate{10.7753, 33.875}, // DJE
    Coordinate{9.45211, 24.2929}, // DJG
    Coordinate{140.512, -2.57646}, // DJJ
    Coordinate{14.75, -2.56333}, // DJM
    Coordinate{-145.717, 64.0506}, // DJN
    Coordinate{-6.47319, 6.79281}, // DJO
    Coordinate{7.66028, 13.0078}, // DKA
    Coordinate{146.14, -17.9417}, // DKI
    Coordinate{-79.2719, 42.4933}, // DKK
    Coordinate{-17.4833, 14.7333}, // DKR
    Coordinate{80.3817, 73.5167}, // DKS
    Coordinate{9.71944, 4.00583}, // DLA
    Coordinate{121.538, 38.9656}, // DLC
    Coordinate{8.51245, 60.4167}, // DLD
    Coordinate{5.42444, 47.0422}, // DLE
    Coordinate{-158.506, 59.0447}, // DLG
    Coordinate{-92.1936, 46.8422}, // DLH
    Coordinate{108.374, 11.7506}, // DLI
    Coordinate{-79.3686, 34.4492}, // DLL
    Coordinate{28.7928, 36.7147}, // DLM
    Coordinate{-112.552, 45.2553}, // DLN
    Coordinate{-121.167, 45.6186}, // DLS
    Coordinate{100.318, 25.6511}, // DLU
    Coordinate{169.001, -18.7694}, // DLY
    Coordinate{104.367, 43.6086}, // DLZ
    Coordinate{71.3036, 42.8536}, // DMB
    Coordinate{138.822, -17.9403}, // DMD
    Coordinate{37.9061, 55.4086}, // DME
    Coordinate{100.607, 13.9125}, // DMK
    Coordinate{49.7978, 26.4711}, // DMM
    Coordinate{-107.721, 32.2622}, // DMN
    Coordinate{-93.1758, 38.7075}, // DMO
    Coordinate{-56.4006, -14.3769}, // DMT
    Coordinate{93.7711, 25.8839}, // DMU
    Coordinate{-3.0175, 56.4525}, // DND
    Coordinate{94.8003, 40.1636}, // DNH
    Coordinate{36.3289, 15.3875}, // DNI
    Coordinate{35.1006, 48.3572}, // DNK
    Coordinate{-82.0394, 33.4664}, // DNL
    Coordinate{-84.8703, 34.7231}, // DNN
    Coordinate{82.2942, 28.1108}, // DNP
    Coordinate{144.946, -35.56}, // DNQ
    Coordinate{-2.08, 48.5878}, // DNR
    Coordinate{-95.3806, 41.9867}, // DNS
    Coordinate{146.667, -6.15}, // DNU
    Coordinate{-87.5956, 40.1992}, // DNV
    Coordinate{35.067, 12.533}, // DNX
    Coordinate{134.212, -5.7717}, // DOB
    Coordinate{35.7494, -6.17036}, // DOD
    Coordinate{-55.4816, 4.00571}, // DOE
    Coordinate{30.43, 19.1536}, // DOG
    Coordinate{51.6081, 25.2731}, // DOH
    Coordinate{150.717, -10.7167}, // DOI
    Coordinate{0.154167, 49.3653}, // DOL
    Coordinate{-61.3, 15.5469}, // DOM
    Coordinate{-89.6884, 17.6124}, // DON
    Coordinate{147.8, -9.5}, // DOO
    Coordinate{82.8192, 28.9858}, // DOP
    Coordinate{-0.066667, 14.0333}, // DOR
    Coordinate{-54.9256, -22.2006}, // DOU
    Coordinate{118.784, 37.5103}, // DOY
    Coordinate{-88.2483, 41.9069}, // DPA
    Coordinate{123.334, 8.60139}, // DPL
    Coordinate{146.43, -41.1697}, // DPO
    Coordinate{115.168, -8.74806}, // DPS
    Coordinate{139.902, 69.3925}, // DPT
    Coordinate{125.228, 46.5872}, // DQA
    Coordinate{-150.945, 70.3442}, // DQH
    Coordinate{57.6344, 19.4973}, // DQM
    Coordinate{-116.033, 36.6194}, // DRA
    Coordinate{123.661, -17.37}, // DRB
    Coordinate{20.7663, -17.9815}, // DRC
    Coordinate{-83.7439, 46.0094}, // DRE
    Coordinate{-162.766, 66.0694}, // DRG
    Coordinate{138.317, -2.8}, // DRH
    Coordinate{-93.34, 30.8317}, // DRI
    Coordinate{-54.6667, 4.11667}, // DRJ
    Coordinate{-83.65, 8.73333}, // DRK
    Coordinate{148.217, -28.5917}, // DRN
    Coordinate{-107.754, 37.1514}, // DRO
    Coordinate{13.7681, 51.1344}, // DRS
    Coordinate{-100.927, 29.3742}, // DRT
    Coordinate{73.1306, 5.15667}, // DRV
    Coordinate{-1.00417, 53.4753}, // DSA
    Coordinate{10.0641, 5.44809}, // DSC
    Coordinate{-61.0844, 16.2969}, // DSD
    Coordinate{39.7114, 11.0825}, // DSE
    Coordinate{-86.4714, 30.4}, // DSI
    Coordinate{70.8964, 31.9092}, // DSK
    Coordinate{-93.6631, 41.5339}, // DSM
    Coordinate{109.862, 39.4939}, // DSN
    Coordinate{127.475, 39.6778}, // DSO
    Coordinate{-17.0689, 14.6708}, // DSS
    Coordinate{-77.7131, 42.5708}, // DSV
    Coordinate{116.717, 20.7}, // DSX
    Coordinate{-112.508, 39.3806}, // DTA
    Coordinate{98.9953, 2.25972}, // DTB
    Coordinate{116.48, 0.72}, // DTD
    Coordinate{122.979, 14.1262}, // DTE
    Coordinate{-116.881, 36.4639}, // DTH
    Coordinate{-43.6511, -18.2333}, // DTI
    Coordinate{-95.8847, 46.8253}, // DTL
    Coordinate{7.61222, 51.5183}, // DTM
    Coordinate{-93.745, 32.5403}, // DTN
    Coordinate{126.123, 48.444}, // DTU
    Coordinate{-83.3533, 42.2125}, // DTW
    Coordinate{-96.3944, 33.9422}, // DUA
    Coordinate{-6.27, 53.4214}, // DUB
    Coordinate{-97.96, 34.4708}, // DUC
    Coordinate{170.198, -45.9281}, // DUD
    Coordinate{20.8185, -7.40064}, // DUE
    Coordinate{-75.7886, 36.2533}, // DUF
    Coordinate{-109.604, 31.4689}, // DUG
    Coordinate{-78.8986, 41.1783}, // DUJ
    Coordinate{101.434, 1.60919}, // DUM
    Coordinate{-123.717, 48.7583}, // DUQ
    Coordinate{31.1164, -29.6144}, // DUR
    Coordinate{6.76667, 51.2894}, // DUS
    Coordinate{-166.545, 53.8989}, // DUT
    Coordinate{43.2706, -22.1111}, // DVD
    Coordinate{-110.29, 64.5114}, // DVK
    Coordinate{-98.9083, 48.1144}, // DVL
    Coordinate{-90.5883, 41.6103}, // DVN
    Coordinate{125.646, 7.12552}, // DVO
    Coordinate{-112.082, 33.6883}, // DVT
    Coordinate{34.1311, -12.5183}, // DWA
    Coordinate{45.3667, -16.1}, // DWB
    Coordinate{55.1722, 24.8861}, // DWC
    Coordinate{44.1211, 24.4497}, // DWD
    Coordinate{-95.5528, 30.0619}, // DWH
    Coordinate{-81.5715, 28.4}, // DWS
    Coordinate{55.3644, 25.2528}, // DXB
    Coordinate{-90.1031, 32.4386}, // DXE
    Coordinate{-73.4822, 41.3717}, // DXR
    Coordinate{148.364, -22.6222}, // DYA
    Coordinate{110.443, 29.1031}, // DYG
    Coordinate{-75.1219, 40.3331}, // DYL
    Coordinate{177.742, 64.735}, // DYR
    Coordinate{68.8217, 38.5436}, // DYU
    Coordinate{45.2806, -12.8067}, // DZA
    Coordinate{67.7392, 47.7089}, // DZN
    Coordinate{-56.4992, -33.3586}, // DZO
    Coordinate{105.774, 29.6364}, // DZU
    Coordinate{-141.161, 64.7764}, // EAA
    Coordinate{43.1778, 16.0111}, // EAB
    Coordinate{168.342, -17.0892}, // EAE
    Coordinate{167.333, 9.0833}, // EAL
    Coordinate{44.4192, 17.6114}, // EAM
    Coordinate{7.52917, 47.59}, // EAP
    Coordinate{-99.0067, 40.7269}, // EAR
    Coordinate{-1.79056, 43.3564}, // EAS
    Coordinate{-120.206, 47.3981}, // EAT
    Coordinate{-91.4842, 44.8658}, // EAU
    Coordinate{10.2394, 42.7603}, // EBA
    Coordinate{32.4431, 0.0447222}, // EBB
    Coordinate{30.2325, 13.1531}, // EBD
    Coordinate{-74.8089, 7.59639}, // EBG
    Coordinate{1.09139, 33.7208}, // EBH
    Coordinate{8.55333, 55.5258}, // EBJ
    Coordinate{43.9631, 36.2375}, // EBL
    Coordinate{166.82, 9.33056}, // EBN
    Coordinate{168.753, 4.59889}, // EBO
    Coordinate{-93.8692, 42.4364}, // EBS
    Coordinate{4.29639, 45.5406}, // EBU
    Coordinate{11.1833, 2.85}, // EBW
    Coordinate{-76.1744, 36.2606}, // ECG
    Coordinate{144.762, -36.1572}, // ECH
    Coordinate{-85.9333, 11.4333}, // ECI
    Coordinate{33.4884, 35.1596}, // ECN
    Coordinate{-85.7956, 30.3583}, // ECP
    Coordinate{-78.1, 2.44083}, // ECR
    Coordinate{30.95, 18.025}, // EDB
    Coordinate{-76.5672, 36.0278}, // EDE
    Coordinate{-3.3725, 55.95}, // EDI
    Coordinate{-96.8175, 37.7742}, // EDK
    Coordinate{35.2389, 0.404444}, // EDL
    Coordinate{-1.38167, 46.7019}, // EDM
    Coordinate{27.0138, 39.5546}, // EDO
    Coordinate{-88.4375, 14.13}, // EDQ
    Coordinate{141.609, -14.8967}, // EDR
    Coordinate{-114.623, 34.7664}, // EED
    Coordinate{-162.044, 60.2136}, // EEK
    Coordinate{-72.2708, 42.8983}, // EEN
    Coordinate{-95.1589, 29.6072}, // EFD
    Coordinate{147.66, -9.15567}, // EFG
    Coordinate{-72.2292, 44.8889}, // EFK
    Coordinate{20.5003, 38.12}, // EFL
    Coordinate{146.1, -6.9167}, // EGA
    Coordinate{0.520556, 44.8244}, // EGC
    Coordinate{-106.918, 39.6425}, // EGE
    Coordinate{34.1292, 31.0689}, // EGH
    Coordinate{-86.5254, 30.6492}, // EGI
    Coordinate{39.75, 5.28333}, // EGL
    Coordinate{157.875, -8.578}, // EGM
    Coordinate{22.4672, 13.4817}, // EGN
    Coordinate{36.59, 50.6433}, // EGO
    Coordinate{-100.513, 28.8572}, // EGP
    Coordinate{-14.4014, 65.2833}, // EGS
    Coordinate{-89.2683, 45.9322}, // EGV
    Coordinate{-157.376, 58.1856}, // EGX
    Coordinate{-71.5322, -41.9433}, // EHL
    Coordinate{-162.063, 58.6464}, // EHM
    Coordinate{147.632, -8.1168}, // EIA
    Coordinate{92.1133, 58.4733}, // EIE
    Coordinate{5.37417, 51.4506}, // EIN
    Coordinate{-64.5431, 18.4456}, // EIS
    Coordinate{35.2032, 30.6215}, // EIY
    Coordinate{-73.8067, 7.02444}, // EJA
    Coordinate{36.4764, 26.1986}, // EJH
    Coordinate{101.001, 42.0156}, // EJN
    Coordinate{171.984, 6.04028}, // EJT
    Coordinate{-124.113, 40.8033}, // EKA
    Coordinate{75.2167, 51.5833}, // EKB
    Coordinate{-86.0033, 41.7194}, // EKI
    Coordinate{-115.792, 40.825}, // EKO
    Coordinate{142.078, 49.1907}, // EKS
    Coordinate{16.7083, 59.35}, // EKT
    Coordinate{-85.925, 37.6861}, // EKX
    Coordinate{-73.9756, 9.04279}, // ELB
    Coordinate{135.571, -12.0193}, // ELC
    Coordinate{-92.8133, 33.2211}, // ELD
    Coordinate{-77.7, 8.13333}, // ELE
    Coordinate{25.3244, 13.6147}, // ELF
    Coordinate{2.86422, 30.5774}, // ELG
    Coordinate{-76.6836, 25.475}, // ELH
    Coordinate{-162.271, 64.615}, // ELI
    Coordinate{-99.3943, 35.4308}, // ELK
    Coordinate{-76.8917, 42.16}, // ELM
    Coordinate{-120.531, 47.0331}, // ELN
    Coordinate{-54.5747, -26.3969}, // ELO
    Coordinate{-106.378, 31.8072}, // ELP
    Coordinate{43.7742, 26.3028}, // ELQ
    Coordinate{27.8214, -33.035}, // ELS
    Coordinate{33.6453, 28.2089}, // ELT
    Coordinate{6.78258, 33.5129}, // ELU
    Coordinate{-136.348, 58.1953}, // ELV
    Coordinate{-64.2106, 8.83278}, // ELX
    Coordinate{-114.842, 39.2997}, // ELY
    Coordinate{-77.99, 42.1094}, // ELZ
    Coordinate{-1.32806, 52.8311}, // EMA
    Coordinate{148.179, -23.5675}, // EMD
    Coordinate{149.975, -1.64167}, // EMI
    Coordinate{-164.491, 62.7861}, // EMK
    Coordinate{-110.557, 41.8242}, // EMM
    Coordinate{-7.31639, 16.6219}, // EMN
    Coordinate{147.783, -8.7333}, // EMO
    Coordinate{-96.1911, 38.3322}, // EMP
    Coordinate{-118.035, 34.0861}, // EMT
    Coordinate{-71.1708, -42.0333}, // EMX
    Coordinate{-151.245, 60.5733}, // ENA
    Coordinate{115.246, -29.8325}, // ENB
    Coordinate{6.22611, 48.6922}, // ENC
    Coordinate{121.661, -8.84917}, // ENE
    Coordinate{23.4275, 68.3644}, // ENF
    Coordinate{109.485, 30.3203}, // ENH
    Coordinate{119.416, 11.2025}, // ENI
    Coordinate{-90.8167, 14.0833}, // ENJ
    Coordinate{-7.65194, 54.3986}, // ENK
    Coordinate{-89.092, 38.5148}, // ENL
    Coordinate{-149.084, 64.5472}, // ENN
    Coordinate{-55.835, -27.222}, // ENO
    Coordinate{6.88667, 52.2742}, // ENS
    Coordinate{162.328, 11.34}, // ENT
    Coordinate{7.56194, 6.47417}, // ENU
    Coordinate{-114.031, 40.7186}, // ENV
    Coordinate{-87.9278, 42.5956}, // ENW
    Coordinate{109.465, 36.4764}, // ENY
    Coordinate{-75.5903, 6.21972}, // EOH
    Coordinate{-91.4286, 40.46}, // EOK
    Coordinate{-61.6389, 6.71583}, // EOR
    Coordinate{-94.3917, 36.8108}, // EOS
    Coordinate{-69.4967, 7.05972}, // EOZ
    Coordinate{-58.6125, -34.61}, // EPA
    Coordinate{-119.517, 47.3081}, // EPH
    Coordinate{32.9047, 34.6725}, // EPK
    Coordinate{6.06667, 48.3247}, // EPL
    Coordinate{121.823, -33.6844}, // EPR
    Coordinate{-69.4333, 19.1986}, // EPS
    Coordinate{141.667, -5.03333}, // EPT
    Coordinate{24.4728, 58.4192}, // EPU
    Coordinate{-71.1355, -42.9038}, // EQS
    Coordinate{47.3833, 10.6347}, // ERA
    Coordinate{39.5206, 39.71}, // ERC
    Coordinate{36.7581, 46.8147}, // ERD
    Coordinate{143.901, -6.6071}, // ERE
    Coordinate{10.9581, 50.9797}, // ERF
    Coordinate{108.03, 61.275}, // ERG
    Coordinate{-4.40066, 31.9475}, // ERH
    Coordinate{-80.1808, 42.085}, // ERI
    Coordinate{112.098, 43.4267}, // ERL
    Coordinate{-52.2761, -27.66}, // ERM
    Coordinate{-69.8831, -6.6375}, // ERN
    Coordinate{141.007, -20.9767}, // ERQ
    Coordinate{-71.1645, 44.7922}, // ERR
    Coordinate{17.0806, -22.6122}, // ERS
    Coordinate{147.083, -8.4167}, // ERU
    Coordinate{-99.0856, 29.9767}, // ERV
    Coordinate{41.1692, 39.9553}, // ERZ
    Coordinate{150.956, -9.8774}, // ESA
    Coordinate{32.995, 40.1281}, // ESB
    Coordinate{-87.0936, 45.7228}, // ESC
    Coordinate{-122.911, 48.7081}, // ESD
    Coordinate{-60.6217, -22.045}, // ESG
    Coordinate{-0.297222, 50.8356}, // ESH
    Coordinate{44.3308, 46.3739}, // ESL
    Coordinate{-79.6267, 0.9786}, // ESM
    Coordinate{-76.0689, 38.8042}, // ESN
    Coordinate{-106.045, 36.0261}, // ESO
    Coordinate{-75.1606, 41.0358}, // ESP
    Coordinate{-69.7658, -26.3133}, // ESR
    Coordinate{6.93722, 51.4022}, // ESS
    Coordinate{-9.68167, 31.3975}, // ESU
    Coordinate{-121.186, 47.2542}, // ESW
    Coordinate{-88.1278, 43.4222}, // ETB
    Coordinate{34.9592, 29.5594}, // ETH
    Coordinate{34.9983, 29.7272}, // ETM
    Coordinate{-79.9778, -3.43528}, // ETR
    Coordinate{-85.8997, 31.2997}, // ETS
    Coordinate{6.24667, 48.9783}, // ETZ
    Coordinate{-174.95, -21.3833}, // EUA
    Coordinate{128.877, -31.7067}, // EUC
    Coordinate{-116.005, 39.6042}, // EUE
    Coordinate{-85.1289, 31.9514}, // EUF
    Coordinate{-123.219, 44.1231}, // EUG
    Coordinate{-13.2192, 27.1517}, // EUN
    Coordinate{121.932, 10.7658}, // EUQ
    Coordinate{-62.9794, 17.4964}, // EUX
    Coordinate{16.6781, 68.4913}, // EVE
    Coordinate{14.4228, 62.0478}, // EVG
    Coordinate{153.42, -29.0933}, // EVH
    Coordinate{44.3958, 40.1472}, // EVN
    Coordinate{-87.5308, 38.0383}, // EVV
    Coordinate{-70.9569, 41.6761}, // EWB
    Coordinate{138.067, -5.48333}, // EWE
    Coordinate{136.378, -3.92583}, // EWI
    Coordinate{-97.2744, 38.0583}, // EWK
    Coordinate{-77.0431, 35.0731}, // EWN
    Coordinate{14.8, -0.898056}, // EWO
    Coordinate{-74.1686, 40.6925}, // EWR
    Coordinate{-135.449, 58.4206}, // EXI
    Coordinate{114.1, -22.0333}, // EXM
    Coordinate{-3.41389, 50.7344}, // EXT
    Coordinate{66.6831, 63.6831}, // EYK
    Coordinate{-10.567, 15.133}, // EYL
    Coordinate{-72.3862, 5.31962}, // EYP
    Coordinate{-119.158, 39.0042}, // EYR
    Coordinate{35.9744, 3.23639}, // EYS
    Coordinate{-81.7594, 24.5561}, // EYW
    Coordinate{-58.5358, -34.8222}, // EZE
    Coordinate{39.2914, 38.605}, // EZS
    Coordinate{-10.7698, 10.0355}, // FAA
    Coordinate{-0.7775, 51.2753}, // FAB
    Coordinate{-145.333, -16.6869}, // FAC
    Coordinate{-7.27722, 62.0636}, // FAE
    Coordinate{-16.6417, 63.875}, // FAG
    Coordinate{62.1655, 32.3662}, // FAH
    Coordinate{-147.856, 64.815}, // FAI
    Coordinate{6.625, 58.1003}, // FAN
    Coordinate{-7.96583, 37.0144}, // FAO
    Coordinate{141.96, -4.609}, // FAQ
    Coordinate{-96.8158, 46.9206}, // FAR
    Coordinate{-14.05, 64.9319}, // FAS
    Coordinate{-119.719, 36.7709}, // FAT
    Coordinate{-145.657, -16.0542}, // FAV
    Coordinate{-78.8803, 34.9911}, // FAY
    Coordinate{53.7233, 28.8917}, // FAZ
    Coordinate{-66.0672, -2.53361}, // FBA
    Coordinate{70.5183, 37.1194}, // FBD
    Coordinate{-53.0639, -26.0594}, // FBE
    Coordinate{27.531, -11.5913}, // FBM
    Coordinate{-123.01, 48.5372}, // FBS
    Coordinate{-114.256, 48.3106}, // FCA
    Coordinate{27.9089, -28.8231}, // FCB
    Coordinate{-119.82, 36.7322}, // FCH
    Coordinate{-93.4572, 44.8272}, // FCM
    Coordinate{8.6642, 53.7683}, // FCN
    Coordinate{12.2389, 41.8003}, // FCO
    Coordinate{-90.775, 34.9419}, // FCY
    Coordinate{5.75694, 61.3911}, // FDE
    Coordinate{-60.9964, 14.5922}, // FDF
    Coordinate{9.51139, 47.6714}, // FDH
    Coordinate{-77.3744, 39.4175}, // FDK
    Coordinate{-58.5909, -34.4545}, // FDO
    Coordinate{-98.9839, 34.3522}, // FDR
    Coordinate{17.3817, -3.31139}, // FDU
    Coordinate{-83.6686, 41.0119}, // FDY
    Coordinate{81.2167, 29.2333}, // FEB
    Coordinate{71.745, 40.3589}, // FEG
    Coordinate{-70.3472, -8.14083}, // FEJ
    Coordinate{-5.2, 9.6}, // FEK
    Coordinate{-32.4283, -3.85472}, // FEN
    Coordinate{-89.5819, 42.2461}, // FEP
    Coordinate{-96.5203, 41.4492}, // FET
    Coordinate{-4.97778, 33.9272}, // FEZ
    Coordinate{-75.6714, 36.0183}, // FFA
    Coordinate{-91.9808, 41.0558}, // FFL
    Coordinate{-96.1567, 46.2844}, // FFM
    Coordinate{-84.9061, 38.1819}, // FFT
    Coordinate{-71.8512, -43.1888}, // FFU
    Coordinate{-12.733, 22.667}, // FGD
    Coordinate{-171.742, -13.8492}, // FGI
    Coordinate{170.02, -43.4621}, // FGL
    Coordinate{-140.887, -15.8199}, // FGU
    Coordinate{-140.165, -15.9922}, // FHZ
    Coordinate{-72.0317, 41.2514}, // FID
    Coordinate{-13.5692, 10.3506}, // FIG
    Coordinate{15.4446, -4.38575}, // FIH
    Coordinate{-112.363, 38.9581}, // FIL
    Coordinate{147.854, -6.62229}, // FIN
    Coordinate{125.559, -18.182}, // FIZ
    Coordinate{56.3239, 25.1097}, // FJR
    Coordinate{8.08056, 48.7794}, // FKB
    Coordinate{25.3381, 0.4817}, // FKI
    Coordinate{136.224, 36.1428}, // FKJ
    Coordinate{-79.8603, 41.3778}, // FKL
    Coordinate{-76.9039, 36.6981}, // FKN
    Coordinate{132.267, -2.92}, // FKQ
    Coordinate{140.428, 37.2275}, // FKS
    Coordinate{-75.5644, 1.58917}, // FLA
    Coordinate{-43.0781, -6.84611}, // FLB
    Coordinate{-88.4883, 43.7711}, // FLD
    Coordinate{-111.669, 35.1403}, // FLG
    Coordinate{-80.1528, 26.0725}, // FLL
    Coordinate{-48.5525, -27.6703}, // FLN
    Coordinate{-79.7239, 34.1853}, // FLO
    Coordinate{-92.5903, 36.2908}, // FLP
    Coordinate{11.2029, 43.8088}, // FLR
    Coordinate{147.993, -40.0914}, // FLS
    Coordinate{-71.9003, 19.6775}, // FLT
    Coordinate{-73.8333, 40.7792}, // FLU
    Coordinate{-31.1322, 39.4581}, // FLW
    Coordinate{-118.749, 39.4992}, // FLX
    Coordinate{-104.57, 38.9458}, // FLY
    Coordinate{-58.2281, -26.2128}, // FMA
    Coordinate{-76.7594, 39.0853}, // FME
    Coordinate{29.25, -5.87556}, // FMI
    Coordinate{10.2394, 47.9889}, // FMM
    Coordinate{-108.23, 36.7411}, // FMN
    Coordinate{7.68483, 52.1346}, // FMO
    Coordinate{-124.111, 43.9828}, // FMU
    Coordinate{-81.8633, 26.5867}, // FMY
    Coordinate{-13.1955, 8.61644}, // FNA
    Coordinate{13.306, 53.6022}, // FNB
    Coordinate{-16.7781, 32.6942}, // FNC
    Coordinate{73.2872, 6.16111}, // FND
    Coordinate{147.085, -8.6}, // FNE
    Coordinate{0.35, 12.033}, // FNG
    Coordinate{37.3764, 9.58333}, // FNH
    Coordinate{4.41639, 43.7575}, // FNI
    Coordinate{125.67, 39.2239}, // FNJ
    Coordinate{-105.011, 40.4519}, // FNL
    Coordinate{-134.898, 58.2544}, // FNR
    Coordinate{-83.7436, 42.9656}, // FNT
    Coordinate{8.64083, 39.8936}, // FNU
    Coordinate{119.663, 25.935}, // FOC
    Coordinate{-94.1925, 42.5511}, // FOD
    Coordinate{15.5351, 41.4329}, // FOG
    Coordinate{-72.6317, 40.8436}, // FOK
    Coordinate{-84.5817, 10.4695}, // FON
    Coordinate{134.872, -0.936389}, // FOO
    Coordinate{-38.5322, -3.77583}, // FOR
    Coordinate{128.115, -30.8383}, // FOS
    Coordinate{152.479, -32.2042}, // FOT
    Coordinate{10.6167, -1.28333}, // FOU
    Coordinate{-10.2264, 8.35222}, // FOY
    Coordinate{-78.6956, 26.5586}, // FPO
    Coordinate{-80.3683, 27.495}, // FPR
    Coordinate{-83.5783, 30.0722}, // FPY
    Coordinate{8.57056, 50.0333}, // FRA
    Coordinate{147.935, -33.3636}, // FRB
    Coordinate{-47.3825, -20.5903}, // FRC
    Coordinate{-123.024, 48.5219}, // FRD
    Coordinate{159.577, -8.10746}, // FRE
    Coordinate{-73.4133, 40.7289}, // FRG
    Coordinate{-86.6369, 38.5061}, // FRH
    Coordinate{6.73556, 43.4172}, // FRJ
    Coordinate{55.9463, -4.58389}, // FRK
    Coordinate{12.0696, 44.1954}, // FRL
    Coordinate{-94.4156, 43.6439}, // FRM
    Coordinate{5.02472, 61.5836}, // FRO
    Coordinate{141.699, -5.20836}, // FRQ
    Coordinate{-78.2533, 38.9175}, // FRR
    Coordinate{-89.8663, 16.909}, // FRS
    Coordinate{-73.0646, -41.1308}, // FRT
    Coordinate{74.4775, 43.0613}, // FRU
    Coordinate{27.4744, -21.1594}, // FRW
    Coordinate{-70.9478, 43.9911}, // FRY
    Coordinate{9.09667, 41.5022}, // FSC
    Coordinate{-96.7419, 43.5819}, // FSD
    Coordinate{-94.7694, 37.7983}, // FSK
    Coordinate{-94.3675, 35.3367}, // FSM
    Coordinate{-56.1742, 46.7631}, // FSP
    Coordinate{-102.913, 30.9153}, // FST
    Coordinate{-104.216, 34.4878}, // FSU
    Coordinate{138.189, 34.7961}, // FSZ
    Coordinate{170.232, -19.5164}, // FTA
    Coordinate{-72.0531, -50.28}, // FTE
    Coordinate{-169.424, -14.2161}, // FTI
    Coordinate{46.9558, -25.0381}, // FTU
    Coordinate{-97.3624, 32.8198}, // FTW
    Coordinate{15.95, -0.531389}, // FTX
    Coordinate{-84.5214, 33.7792}, // FTY
    Coordinate{-13.8639, 28.4528}, // FUE
    Coordinate{115.734, 32.8819}, // FUG
    Coordinate{128.833, 32.6664}, // FUJ
    Coordinate{130.452, 33.5844}, // FUK
    Coordinate{-117.98, 33.872}, // FUL
    Coordinate{142.433, -6.38333}, // FUM
    Coordinate{179.196, -8.525}, // FUN
    Coordinate{113.071, 23.0825}, // FUO
    Coordinate{-178.066, -14.3114}, // FUT
    Coordinate{73.4325, -0.309444}, // FVM
    Coordinate{-85.1953, 40.9783}, // FWA
    Coordinate{-80.1708, 26.1972}, // FXE
    Coordinate{36.5283, -14.8175}, // FXO
    Coordinate{-93.6242, 43.2347}, // FXY
    Coordinate{134.366, 48.1995}, // FYJ
    Coordinate{-86.5639, 35.0597}, // FYM
    Coordinate{89.5079, 46.8011}, // FYN
    Coordinate{19.1108, 17.9143}, // FYT
    Coordinate{-145.246, 66.5725}, // FYU
    Coordinate{-94.17, 36.005}, // FYV
    Coordinate{82.155, 26.7511}, // FZD
    Coordinate{-2.59361, 51.5194}, // FZO
    Coordinate{-74.2223, 9.15227}, // GAA
    Coordinate{-117.959, 38.9242}, // GAB
    Coordinate{-88.5958, 14.5736}, // GAC
    Coordinate{-86.0892, 33.9728}, // GAD
    Coordinate{9.92005, 33.7343}, // GAE
    Coordinate{8.81361, 34.4156}, // GAF
    Coordinate{-99.7764, 36.2956}, // GAG
    Coordinate{151.62, -25.6153}, // GAH
    Coordinate{-77.166, 39.1683}, // GAI
    Coordinate{140.371, 38.4119}, // GAJ
    Coordinate{-156.938, 64.7361}, // GAL
    Coordinate{-171.733, 63.7667}, // GAM
    Coordinate{73.1556, -0.693333}, // GAN
    Coordinate{-75.1583, 20.0853}, // GAO
    Coordinate{145.96, -6.0536}, // GAP
    Coordinate{-0.0058, 16.2483}, // GAQ
    Coordinate{147.1, -7.87}, // GAR
    Coordinate{39.6483, -0.463428}, // GAS
    Coordinate{6.03667, 44.4539}, // GAT
    Coordinate{94.1189, 22.1533}, // GAW
    Coordinate{9.9958, -2.7658}, // GAX
    Coordinate{84.9511, 24.7444}, // GAY
    Coordinate{152.95, -9.23333}, // GAZ
    Coordinate{-2.05694, 51.6681}, // GBA
    Coordinate{47.7125, 40.8267}, // GBB
    Coordinate{141.733, -6.1}, // GBC
    Coordinate{-98.8592, 38.3442}, // GBD
    Coordinate{25.9231, -24.5558}, // GBE
    Coordinate{144.667, -6.5833}, // GBF
    Coordinate{-90.4311, 40.9381}, // GBG
    Coordinate{-149.49, 68.4797}, // GBH
    Coordinate{76.9517, 17.3069}, // GBI
    Coordinate{-61.2722, 15.8686}, // GBJ
    Coordinate{-12.3833, 7.76667}, // GBK
    Coordinate{133.382, -11.65}, // GBL
    Coordinate{42.2131, 3.32278}, // GBM
    Coordinate{-73.4032, 42.1842}, // GBR
    Coordinate{54.4053, 36.9067}, // GBT
    Coordinate{35.878, 14.925}, // GBU
    Coordinate{175.472, -36.2414}, // GBZ
    Coordinate{-105.539, 44.3489}, // GCC
    Coordinate{50.8281, 30.3375}, // GCH
    Coordinate{-2.60194, 49.435}, // GCI
    Coordinate{28.14, -25.9871}, // GCJ
    Coordinate{-100.724, 37.9275}, // GCK
    Coordinate{-81.3592, 19.2925}, // GCM
    Coordinate{-112.147, 35.9522}, // GCN
    Coordinate{-113.231, 36.258}, // GCT
    Coordinate{-113.816, 35.9903}, // GCW
    Coordinate{-82.815, 36.1931}, // GCY
    Coordinate{-82.3764, 34.7566}, // GDC
    Coordinate{43.5786, 5.93528}, // GDE
    Coordinate{125.8, 53.4667}, // GDG
    Coordinate{23.95, -6.7333}, // GDJ
    Coordinate{-103.311, 20.5218}, // GDL
    Coordinate{-72.0161, 42.55}, // GDM
    Coordinate{18.4661, 54.3775}, // GDN
    Coordinate{-70.7582, 7.21}, // GDO
    Coordinate{-43.5822, -6.7822}, // GDP
    Coordinate{37.4339, 12.5197}, // GDQ
    Coordinate{-71.1422, 21.4444}, // GDT
    Coordinate{-104.807, 47.1386}, // GDV
    Coordinate{-84.475, 43.9706}, // GDW
    Coordinate{150.721, 59.9111}, // GDX
    Coordinate{38.0094, 44.5725}, // GDZ
    Coordinate{166.473, -22.2583}, // GEA
    Coordinate{-75.3589, 38.6892}, // GED
    Coordinate{146.84, -41.08}, // GEE
    Coordinate{-54.1689, -28.2822}, // GEL
    Coordinate{-58.2539, 6.4983}, // GEO
    Coordinate{-82.7839, 21.8347}, // GER
    Coordinate{125.096, 6.058}, // GES
    Coordinate{114.707, -28.7961}, // GET
    Coordinate{20.8122, 67.1331}, // GEV
    Coordinate{144.333, -38.2253}, // GEX
    Coordinate{-85.7361, 39.7903}, // GFD
    Coordinate{146.067, -34.2517}, // GFF
    Coordinate{-97.1761, 47.9492}, // GFK
    Coordinate{-73.6103, 43.3411}, // GFL
    Coordinate{153.03, -29.76}, // GFN
    Coordinate{-58.6541, 6.36018}, // GFO
    Coordinate{18.1228, -19.6022}, // GFY
    Coordinate{21.4503, -14.1051}, // GGC
    Coordinate{-79.3203, 33.3114}, // GGE
    Coordinate{-52.5783, -1.49195}, // GGF
    Coordinate{-94.7114, 32.3839}, // GGG
    Coordinate{-52.6422, -23.6922}, // GGH
    Coordinate{-5.98694, 6.10333}, // GGN
    Coordinate{-7.4786, 6.525}, // GGO
    Coordinate{48.4833, 8.4}, // GGR
    Coordinate{-70.1622, -48.7833}, // GGS
    Coordinate{-75.878, 23.5626}, // GGT
    Coordinate{-106.615, 48.2125}, // GGW
    Coordinate{3.79467, 32.3843}, // GHA
    Coordinate{-76.3311, 25.2847}, // GHB
    Coordinate{-77.85, 25.7383}, // GHC
    Coordinate{-78.3667, 8.06667}, // GHE
    Coordinate{-87.4453, 35.8375}, // GHM
    Coordinate{104.33, 30.9478}, // GHN
    Coordinate{115.76, 0.203767}, // GHS
    Coordinate{10.1425, 25.1456}, // GHT
    Coordinate{-58.6128, -33.0056}, // GHU
    Coordinate{-5.34972, 36.1511}, // GIB
    Coordinate{142.217, -9.23333}, // GIC
    Coordinate{29.8941, -3.43333}, // GID
    Coordinate{-81.7533, 28.0628}, // GIF
    Coordinate{-43.2506, -22.81}, // GIG
    Coordinate{-9.167, 11.433}, // GII
    Coordinate{74.3336, 35.9186}, // GIL
    Coordinate{-74.7967, 4.27611}, // GIR
    Coordinate{177.978, -38.6633}, // GIS
    Coordinate{32.1717, -2.8714}, // GIT
    Coordinate{42.5858, 16.9011}, // GIZ
    Coordinate{-85.9067, 16.4453}, // GJA
    Coordinate{5.87361, 36.7951}, // GJL
    Coordinate{-65.2817, -10.7883}, // GJM
    Coordinate{-21.3296, 65.9933}, // GJR
    Coordinate{-108.527, 39.1225}, // GJT
    Coordinate{145.392, -6.0817}, // GKA
    Coordinate{25.8822, 40.2011}, // GKD
    Coordinate{84.4662, 28.0387}, // GKH
    Coordinate{73.4331, 0.7308}, // GKK
    Coordinate{-145.454, 62.155}, // GKN
    Coordinate{-83.5286, 35.8578}, // GKT
    Coordinate{-4.43306, 55.8719}, // GLA
    Coordinate{-110.667, 33.3531}, // GLB
    Coordinate{-101.699, 39.3706}, // GLD
    Coordinate{-97.1969, 33.6514}, // GLE
    Coordinate{-83.1833, 8.65}, // GLF
    Coordinate{-90.9856, 33.4828}, // GLH
    Coordinate{151.69, -29.675}, // GLI
    Coordinate{47.4333, 6.76667}, // GLK
    Coordinate{9.05056, 60.7908}, // GLL
    Coordinate{-10.0678, 29.0167}, // GLN
    Coordinate{-2.16722, 51.8942}, // GLO
    Coordinate{141.517, -5.28333}, // GLP
    Coordinate{-84.7033, 45.0131}, // GLR
    Coordinate{-94.8606, 29.2653}, // GLS
    Coordinate{151.223, -23.8697}, // GLT
    Coordinate{90.4653, 26.8686}, // GLU
    Coordinate{-163.011, 64.5506}, // GLV
    Coordinate{-85.9539, 37.0317}, // GLW
    Coordinate{127.787, 1.83831}, // GLX
    Coordinate{19.7667, 3.23528}, // GMA
    Coordinate{34.5631, 8.12861}, // GMB
    Coordinate{-7.22139, 33.6556}, // GMD
    Coordinate{31.0167, 52.5269}, // GME
    Coordinate{150.333, -6.275}, // GMI
    Coordinate{30.1919, 50.6036}, // GML
    Coordinate{15.8667, -1.86667}, // GMM
    Coordinate{171.19, -42.4617}, // GMN
    Coordinate{10.9, 10.2989}, // GMO
    Coordinate{126.798, 37.5569}, // GMP
    Coordinate{100.302, 34.4213}, // GMQ
    Coordinate{-134.883, -23.0833}, // GMR
    Coordinate{-82.35, 34.8481}, // GMU
    Coordinate{-17.2146, 28.0296}, // GMZ
    Coordinate{24.0539, 53.6019}, // GNA
    Coordinate{5.33278, 45.3631}, // GNB
    Coordinate{-61.7861, 12.0042}, // GND
    Coordinate{-120.945, 39.9439}, // GNF
    Coordinate{121.458, 22.6736}, // GNI
    Coordinate{-42.7511, -14.2081}, // GNM
    Coordinate{40.7167, 7.15}, // GNN
    Coordinate{-67.6206, -39.0008}, // GNR
    Coordinate{97.7044, 1.16611}, // GNS
    Coordinate{-107.902, 35.1672}, // GNT
    Coordinate{-161.577, 59.1175}, // GNU
    Coordinate{-82.2717, 29.69}, // GNV
    Coordinate{38.9, 37.45}, // GNY
    Coordinate{21.6578, -21.7}, // GNZ
    Coordinate{8.83756, 44.4135}, // GOA
    Coordinate{40.045, 7.11889}, // GOB
    Coordinate{147.667, -8.4167}, // GOC
    Coordinate{151.867, -5.3833}, // GOE
    Coordinate{18.9747, -22.5072}, // GOG
    Coordinate{-51.6778, 64.1917}, // GOH
    Coordinate{73.8314, 15.3808}, // GOI
    Coordinate{43.7867, 56.23}, // GOJ
    Coordinate{-97.4161, 35.8514}, // GOK
    Coordinate{-124.425, 42.4153}, // GOL
    Coordinate{29.2383, -1.67056}, // GOM
    Coordinate{150.32, -28.5217}, // GOO
    Coordinate{83.45, 26.74}, // GOP
    Coordinate{94.7861, 36.4006}, // GOQ
    Coordinate{35.5525, 8.16167}, // GOR
    Coordinate{12.2911, 57.66}, // GOT
    Coordinate{13.37, 9.33583}, // GOU
    Coordinate{136.818, -12.27}, // GOV
    Coordinate{25.7125, 43.1514}, // GOZ
    Coordinate{21.4167, 38.15}, // GPA
    Coordinate{-51.5244, -25.3881}, // GPB
    Coordinate{139.407, -19.775}, // GPD
    Coordinate{-77.8983, 2.57}, // GPI
    Coordinate{-83.8, 10.2167}, // GPL
    Coordinate{130.425, -11.3992}, // GPN
    Coordinate{-63.7589, -35.6947}, // GPO
    Coordinate{-90.2658, -0.453889}, // GPS
    Coordinate{-89.07, 30.4072}, // GPT
    Coordinate{-93.5097, 47.2111}, // GPZ
    Coordinate{-82.7239, 40.7533}, // GQQ
    Coordinate{-88.1297, 44.4847}, // GRB
    Coordinate{-8.13, 4.34}, // GRC
    Coordinate{-82.1592, 34.2486}, // GRD
    Coordinate{-89.3783, 38.8361}, // GRE
    Coordinate{69.1167, 33.6167}, // GRG
    Coordinate{150.683, -10.3167}, // GRH
    Coordinate{-98.3097, 40.9675}, // GRI
    Coordinate{22.3808, -34.0067}, // GRJ
    Coordinate{-97.8289, 31.0672}, // GRK
    Coordinate{147.2, -7.95}, // GRL
    Coordinate{-90.3831, 47.8383}, // GRM
    Coordinate{2.76056, 41.9008}, // GRO
    Coordinate{6.57806, 53.1206}, // GRQ
    Coordinate{-85.5228, 42.8808}, // GRR
    Coordinate{11.0717, 42.7597}, // GRS
    Coordinate{-46.4818, -23.4356}, // GRU
    Coordinate{45.6997, 43.3883}, // GRV
    Coordinate{-28.0286, 39.0925}, // GRW
    Coordinate{-3.77722, 37.1886}, // GRX
    Coordinate{-18.0186, 66.5467}, // GRY
    Coordinate{15.4392, 46.9931}, // GRZ
    Coordinate{115.719, 4.40944}, // GSA
    Coordinate{115.201, -25.0538}, // GSC
    Coordinate{11.8706, 57.7756}, // GSE
    Coordinate{-85.7942, 41.5264}, // GSH
    Coordinate{-54.3811, 4.28333}, // GSI
    Coordinate{-90.8358, 13.9361}, // GSJ
    Coordinate{-111.541, 62.5972}, // GSL
    Coordinate{55.9024, 26.7546}, // GSM
    Coordinate{137.174, -31.4597}, // GSN
    Coordinate{-79.9372, 36.0978}, // GSO
    Coordinate{-82.2189, 34.8956}, // GSP
    Coordinate{28.7164, 22.5806}, // GSQ
    Coordinate{49.0833, 9.51667}, // GSR
    Coordinate{-135.708, 58.4253}, // GST
    Coordinate{35.3169, 14.13}, // GSU
    Coordinate{46.1711, 51.7128}, // GSV
    Coordinate{158.203, -8.73917}, // GTA
    Coordinate{101.883, 3.55}, // GTB
    Coordinate{136.46, -13.975}, // GTE
    Coordinate{-111.371, 47.4828}, // GTF
    Coordinate{-92.6644, 45.7981}, // GTG
    Coordinate{170.133, -43.7668}, // GTN
    Coordinate{122.85, 0.637222}, // GTO
    Coordinate{-123.388, 42.5101}, // GTP
    Coordinate{-88.5914, 33.4483}, // GTR
    Coordinate{130.35, -20.5483}, // GTS
    Coordinate{143.53, -18.305}, // GTT
    Coordinate{-77.2742, 39.8408}, // GTY
    Coordinate{34.2218, -2.1595}, // GTZ
    Coordinate{-90.5275, 14.5833}, // GUA
    Coordinate{-114.024, 28.0258}, // GUB
    Coordinate{-106.933, 38.5339}, // GUC
    Coordinate{-3.6, 16.35}, // GUD
    Coordinate{-87.6717, 30.2897}, // GUF
    Coordinate{146.9, -8.1}, // GUG
    Coordinate{150.25, -30.9617}, // GUH
    Coordinate{-62.3125, 10.5739}, // GUI
    Coordinate{149.718, -34.81}, // GUL
    Coordinate{144.797, 13.4839}, // GUM
    Coordinate{-108.789, 35.5111}, // GUP
    Coordinate{-69.7544, 9.02778}, // GUQ
    Coordinate{150.334, -10.3114}, // GUR
    Coordinate{-86.1522, 40.6481}, // GUS
    Coordinate{-23.2222, 64.9917}, // GUU
    Coordinate{142.421, -6.28177}, // GUV
    Coordinate{51.8294, 47.1222}, // GUW
    Coordinate{-101.508, 36.685}, // GUY
    Coordinate{-40.4922, -20.6506}, // GUZ
    Coordinate{6.10944, 46.2383}, // GVA
    Coordinate{141.171, -3.90224}, // GVI
    Coordinate{-83.8303, 34.2725}, // GVL
    Coordinate{140.036, 48.9183}, // GVN
    Coordinate{-41.9861, -18.8969}, // GVR
    Coordinate{-96.0653, 33.0678}, // GVT
    Coordinate{16.9511, 60.5933}, // GVX
    Coordinate{94.5833, 17.6}, // GWA
    Coordinate{62.3294, 25.2331}, // GWD
    Coordinate{78.2278, 26.2933}, // GWL
    Coordinate{146.25, -6.5667}, // GWN
    Coordinate{-90.0692, 33.6464}, // GWO
    Coordinate{8.34056, 54.9133}, // GWT
    Coordinate{-77.965, 35.4606}, // GWW
    Coordinate{-8.94159, 53.3002}, // GWY
    Coordinate{114.894, -0.942778}, // GXA
    Coordinate{48.7881, 15.9661}, // GXF
    Coordinate{15.2876, -7.75431}, // GXG
    Coordinate{102.645, 34.8106}, // GXH
    Coordinate{-72.1065, -45.5947}, // GXQ
    Coordinate{15.2437, 10.3531}, // GXX
    Coordinate{-104.633, 40.4375}, // GXY
    Coordinate{-65.3458, -10.8217}, // GYA
    Coordinate{50.0467, 40.4675}, // GYD
    Coordinate{-79.8836, -2.1575}, // GYE
    Coordinate{129.563, 62.1083}, // GYG
    Coordinate{29.2583, -1.68}, // GYI
    Coordinate{128.451, -16.6369}, // GYL
    Coordinate{-110.924, 27.9692}, // GYM
    Coordinate{-49.2267, -16.6325}, // GYN
    Coordinate{152.702, -26.2833}, // GYP
    Coordinate{-112.374, 33.4281}, // GYR
    Coordinate{105.693, 32.39}, // GYS
    Coordinate{106.218, 36.0761}, // GYU
    Coordinate{99.5536, 31.755}, // GZG
    Coordinate{68.4123, 33.5308}, // GZI
    Coordinate{156.864, -8.0986}, // GZO
    Coordinate{32.3033, 36.2989}, // GZP
    Coordinate{37.4789, 36.9478}, // GZT
    Coordinate{50.0333, 36.2333}, // GZW
    Coordinate{22.1397, 70.4867}, // HAA
    Coordinate{-87.9983, 34.1175}, // HAB
    Coordinate{139.786, 33.115}, // HAC
    Coordinate{12.82, 56.6908}, // HAD
    Coordinate{125.779, 38.0054}, // HAE
    Coordinate{-122.501, 37.5133}, // HAF
    Coordinate{43.2714, -11.5367}, // HAH
    Coordinate{9.685, 52.4608}, // HAJ
    Coordinate{110.459, 19.9347}, // HAK
    Coordinate{16.4583, -19.0314}, // HAL
    Coordinate{9.99111, 53.6303}, // HAM
    Coordinate{105.807, 21.2211}, // HAN
    Coordinate{-84.5219, 39.3638}, // HAO
    Coordinate{73.1685, 6.74417}, // HAQ
    Coordinate{-76.8514, 40.2172}, // HAR
    Coordinate{41.6863, 27.4397}, // HAS
    Coordinate{5.2125, 59.3433}, // HAU
    Coordinate{-82.4089, 22.9889}, // HAV
    Coordinate{-4.96111, 51.8331}, // HAW
    Coordinate{-73.5821, 8.24704}, // HAY
    Coordinate{145.167, -4.33333}, // HAZ
    Coordinate{147.51, -42.8361}, // HBA
    Coordinate{29.6964, 30.9178}, // HBE
    Coordinate{-89.2528, 31.265}, // HBG
    Coordinate{-110.138, 34.9408}, // HBK
    Coordinate{100.644, 38.012}, // HBQ
    Coordinate{-99.0514, 34.9914}, // HBR
    Coordinate{91.5819, 46.1017}, // HBU
    Coordinate{75.0847, 15.3617}, // HBX
    Coordinate{-101.522, 32.2125}, // HCA
    Coordinate{-73.7103, 42.2914}, // HCC
    Coordinate{107.7, 24.7839}, // HCJ
    Coordinate{49.8, 7.91667}, // HCM
    Coordinate{120.73, 22.0381}, // HCN
    Coordinate{127.67, -18.2339}, // HCQ
    Coordinate{-159.775, 62.1883}, // HCR
    Coordinate{-79.9569, 34.7128}, // HCW
    Coordinate{68.3667, 25.3183}, // HDD
    Coordinate{14.1522, 53.8786}, // HDF
    Coordinate{114.43, 36.5239}, // HDG
    Coordinate{73.0667, 6.6311}, // HDK
    Coordinate{48.5525, 34.8692}, // HDM
    Coordinate{-107.218, 40.4811}, // HDN
    Coordinate{100.393, 6.93306}, // HDY
    Coordinate{62.2279, 34.2101}, // HEA
    Coordinate{-90.6758, 34.5764}, // HEE
    Coordinate{-81.8058, 30.2778}, // HEG
    Coordinate{96.7919, 20.7469}, // HEH
    Coordinate{127.309, 50.1722}, // HEK
    Coordinate{24.9633, 60.3172}, // HEL
    Coordinate{147.6, -9.1375}, // HEO
    Coordinate{25.1803, 35.3397}, // HER
    Coordinate{-119.259, 45.8283}, // HES
    Coordinate{111.822, 40.8514}, // HET
    Coordinate{-91.2972, 31.6136}, // HEZ
    Coordinate{35.0431, 32.8094}, // HFA
    Coordinate{-72.6494, 41.7367}, // HFD
    Coordinate{116.964, 31.9894}, // HFE
    Coordinate{-79.4975, 35.0364}, // HFF
    Coordinate{-15.2272, 64.2956}, // HFN
    Coordinate{13.5806, 60.025}, // HFS
    Coordinate{23.6686, 70.6797}, // HFT
    Coordinate{44.0888, 9.5182}, // HGA
    Coordinate{144.225, -20.815}, // HGD
    Coordinate{-66.0998, 10.4667}, // HGE
    Coordinate{120.434, 30.2294}, // HGH
    Coordinate{32.5006, 10.5292}, // HGI
    Coordinate{97.9747, 19.3011}, // HGN
    Coordinate{-5.55666, 9.38718}, // HGO
    Coordinate{-77.7264, 39.7086}, // HGR
    Coordinate{-13.1291, 8.3943}, // HGS
    Coordinate{144.296, -5.82679}, // HGU
    Coordinate{-80.6975, 32.2244}, // HHH
    Coordinate{7.26417, 49.9483}, // HHN
    Coordinate{99.9514, 12.6303}, // HHQ
    Coordinate{-118.335, 33.9228}, // HHR
    Coordinate{-142.613, -17.5478}, // HHZ
    Coordinate{119.148, 33.7772}, // HIA
    Coordinate{-92.8389, 47.3867}, // HIB
    Coordinate{142.29, -10.5864}, // HID
    Coordinate{-71.5445, 44.3676}, // HIE
    Coordinate{-114.358, 34.5711}, // HII
    Coordinate{132.919, 34.4361}, // HIJ
    Coordinate{44.7639, 6.07778}, // HIL
    Coordinate{80.9817, 8.053}, // HIM
    Coordinate{128.07, 35.0885}, // HIN
    Coordinate{-122.95, 45.5404}, // HIO
    Coordinate{160.055, -9.428}, // HIR
    Coordinate{143.067, -6.9333}, // HIT
    Coordinate{132.414, 34.3669}, // HIW
    Coordinate{109.7, 27.4414}, // HJJ
    Coordinate{79.9186, 24.8172}, // HJR
    Coordinate{102.778, 46.9253}, // HJT
    Coordinate{-89.8308, 35.9406}, // HKA
    Coordinate{-144.693, 63.9958}, // HKB
    Coordinate{140.822, 41.77}, // HKD
    Coordinate{113.914, 22.3089}, // HKG
    Coordinate{170.985, -42.7136}, // HKK
    Coordinate{150.405, -5.46217}, // HKN
    Coordinate{-90.2225, 32.3347}, // HKS
    Coordinate{98.3169, 8.11333}, // HKT
    Coordinate{-81.3894, 35.7411}, // HKY
    Coordinate{27.9261, -25.9386}, // HLA
    Coordinate{-99.8314, 39.3803}, // HLC
    Coordinate{119.825, 49.205}, // HLD
    Coordinate{-5.64594, -15.9619}, // HLE
    Coordinate{15.8337, 57.5214}, // HLF
    Coordinate{-80.6464, 40.175}, // HLG
    Coordinate{122.008, 46.1953}, // HLH
    Coordinate{-121.41, 36.8933}, // HLI
    Coordinate{23.5581, 56.0706}, // HLJ
    Coordinate{-86.1619, 42.7958}, // HLM
    Coordinate{-111.983, 46.6067}, // HLN
    Coordinate{106.891, -6.26639}, // HLP
    Coordinate{148.282, -41.3367}, // HLS
    Coordinate{142.065, -37.6483}, // HLT
    Coordinate{32.275, -28.0083}, // HLW
    Coordinate{175.332, -37.8667}, // HLZ
    Coordinate{69.0867, 61.0283}, // HMA
    Coordinate{31.7393, 26.3399}, // HMB
    Coordinate{6.14056, 31.6739}, // HME
    Coordinate{93.6694, 42.8425}, // HMI
    Coordinate{26.9333, 49.36}, // HMJ
    Coordinate{-111.048, 29.0958}, // HMO
    Coordinate{-117.022, 33.7339}, // HMT
    Coordinate{141.135, 39.4286}, // HNA
    Coordinate{-86.9536, 38.2489}, // HNB
    Coordinate{-75.6178, 35.2328}, // HNC
    Coordinate{139.781, 35.5533}, // HND
    Coordinate{-135.41, 58.0961}, // HNH
    Coordinate{146.5, -7.4}, // HNI
    Coordinate{-157.923, 21.3186}, // HNL
    Coordinate{-156.014, 20.7956}, // HNM
    Coordinate{142.177, -6.24649}, // HNN
    Coordinate{18.533, 42.4497}, // HNO
    Coordinate{-135.524, 59.2439}, // HNS
    Coordinate{112.618, 26.7239}, // HNY
    Coordinate{40.0039, -1.52}, // HOA
    Coordinate{-103.217, 32.6875}, // HOB
    Coordinate{42.9763, 14.753}, // HOD
    Coordinate{100.426, 20.2578}, // HOE
    Coordinate{49.4852, 25.2853}, // HOF
    Coordinate{-76.315, 20.7856}, // HOG
    Coordinate{9.7, 47.385}, // HOH
    Coordinate{-140.946, -18.0747}, // HOI
    Coordinate{130.643, -18.3367}, // HOK
    Coordinate{-151.487, 59.6425}, // HOM
    Coordinate{-98.2286, 44.3853}, // HON
    Coordinate{106.591, 17.0153}, // HOO
    Coordinate{-28.7164, 38.52}, // HOR
    Coordinate{-70.2231, -37.4447}, // HOS
    Coordinate{-93.0961, 34.4781}, // HOT
    Coordinate{-95.2789, 29.6456}, // HOU
    Coordinate{6.07583, 62.1786}, // HOV
    Coordinate{-174.341, -19.7767}, // HPA
    Coordinate{-166.147, 61.5239}, // HPB
    Coordinate{110.338, 31.6336}, // HPG
    Coordinate{106.725, 20.8192}, // HPH
    Coordinate{-73.7075, 41.0669}, // HPN
    Coordinate{-159.446, 22.2092}, // HPV
    Coordinate{-94.9528, 29.7861}, // HPY
    Coordinate{-123.937, 46.9711}, // HQM
    Coordinate{126.25, 45.6234}, // HRB
    Coordinate{31.0928, -17.9318}, // HRE
    Coordinate{33.7992, 27.1781}, // HRG
    Coordinate{81.1236, 6.28889}, // HRI
    Coordinate{36.29, 49.9247}, // HRK
    Coordinate{-97.655, 26.2272}, // HRL
    Coordinate{3.31039, 32.9315}, // HRM
    Coordinate{-93.1547, 36.2614}, // HRO
    Coordinate{29.1061, -28.2351}, // HRS
    Coordinate{-54.3411, -27.6413}, // HRZ
    Coordinate{113.421, 24.9786}, // HSC
    Coordinate{130.302, 33.1497}, // HSG
    Coordinate{-115.134, 35.9728}, // HSH
    Coordinate{-98.4278, 40.6053}, // HSI
    Coordinate{113.277, 34.8376}, // HSJ
    Coordinate{-0.323333, 42.0808}, // HSK
    Coordinate{142.173, -36.6697}, // HSM
    Coordinate{122.362, 29.9342}, // HSN
    Coordinate{75.7553, 29.1792}, // HSS
    Coordinate{-86.775, 34.6372}, // HSV
    Coordinate{113.305, 52.0267}, // HTA
    Coordinate{102.487, 71.9683}, // HTG
    Coordinate{-118.634, 38.5444}, // HTH
    Coordinate{148.952, -20.3581}, // HTI
    Coordinate{-84.6711, 44.3597}, // HTL
    Coordinate{100.137, 50.4394}, // HTM
    Coordinate{79.865, 37.0386}, // HTN
    Coordinate{-72.2517, 40.9594}, // HTO
    Coordinate{123.804, 24.0583}, // HTR
    Coordinate{-82.5586, 38.3669}, // HTS
    Coordinate{90.8364, 38.2033}, // HTT
    Coordinate{142.36, -35.715}, // HTU
    Coordinate{-95.5872, 30.7469}, // HTV
    Coordinate{-82.4944, 38.4192}, // HTW
    Coordinate{36.2822, 36.3628}, // HTY
    Coordinate{-71.7625, 6.15278}, // HTZ
    Coordinate{130.63, -16.4897}, // HUB
    Coordinate{-65.8008, 18.1381}, // HUC
    Coordinate{-94.2453, 42.7361}, // HUD
    Coordinate{36.8817, 13.8303}, // HUE
    Coordinate{-91.505, 15.3164}, // HUG
    Coordinate{-151.022, -16.6872}, // HUH
    Coordinate{107.703, 16.4017}, // HUI
    Coordinate{-95.5419, 34.0347}, // HUJ
    Coordinate{21.7581, -23.9897}, // HUK
    Coordinate{-67.7919, 46.1231}, // HUL
    Coordinate{-90.6606, 29.5664}, // HUM
    Coordinate{121.618, 24.0231}, // HUN
    Coordinate{119.407, 45.4867}, // HUO
    Coordinate{15.95, 29.11}, // HUQ
    Coordinate{-154.265, 66.0392}, // HUS
    Coordinate{-97.8606, 38.0656}, // HUT
    Coordinate{-76.2048, -9.87881}, // HUU
    Coordinate{17.0806, 61.7683}, // HUV
    Coordinate{-63.0506, -7.53361}, // HUW
    Coordinate{-96.2625, 15.7753}, // HUX
    Coordinate{-0.350833, 53.5744}, // HUY
    Coordinate{114.6, 23.0483}, // HUZ
    Coordinate{47.7625, -14.6333}, // HVA
    Coordinate{152.88, -25.3189}, // HVB
    Coordinate{91.6258, 47.9614}, // HVD
    Coordinate{25.9836, 71.0097}, // HVG
    Coordinate{-21.6964, 65.7047}, // HVK
    Coordinate{-72.8867, 41.2639}, // HVN
    Coordinate{-109.762, 48.5431}, // HVR
    Coordinate{-80.1192, 34.4031}, // HVS
    Coordinate{145.967, -7.4333}, // HWA
    Coordinate{27.0045, -18.6351}, // HWN
    Coordinate{-80.2408, 26.0011}, // HWO
    Coordinate{97.2686, 37.125}, // HXD
    Coordinate{144.83, -34.5317}, // HXX
    Coordinate{-70.2803, 41.6694}, // HYA
    Coordinate{-0.808333, 51.6117}, // HYC
    Coordinate{78.4281, 17.24}, // HYD
    Coordinate{143.058, -3.6988}, // HYF
    Coordinate{-132.828, 55.2064}, // HYG
    Coordinate{-132.624, 55.4906}, // HYL
    Coordinate{121.429, 28.5622}, // HYN
    Coordinate{-91.4442, 46.0253}, // HYR
    Coordinate{-99.2731, 38.8422}, // HYS
    Coordinate{107.202, 33.1367}, // HZG
    Coordinate{109.152, 26.3228}, // HZH
    Coordinate{-17.4258, 65.9522}, // HZK
    Coordinate{-75.995, 40.9867}, // HZL
    Coordinate{-111.701, 57.3817}, // HZP
    Coordinate{86.6217, 67.4367}, // IAA
    Coordinate{-77.4558, 38.9444}, // IAD
    Coordinate{-78.9461, 43.1072}, // IAG
    Coordinate{-95.3414, 29.9844}, // IAH
    Coordinate{9.64278, 28.0514}, // IAM
    Coordinate{-160.437, 66.9758}, // IAN
    Coordinate{126.014, 9.85889}, // IAO
    Coordinate{40.1574, 57.5607}, // IAR
    Coordinate{27.62, 47.1789}, // IAS
    Coordinate{3.97833, 7.36222}, // IBA
    Coordinate{-75.1325, 4.42139}, // IBE
    Coordinate{146.267, -8.4}, // IBI
    Coordinate{35.4522, -21.7072}, // IBL
    Coordinate{-69.4889, -11.4117}, // IBP
    Coordinate{1.37312, 38.8729}, // IBZ
    Coordinate{-61.7407, 4.33337}, // ICA
    Coordinate{-63.9814, 10.7942}, // ICC
    Coordinate{-179.342, -17.7431}, // ICI
    Coordinate{-57.0394, 5.95556}, // ICK
    Coordinate{126.439, 37.4625}, // ICN
    Coordinate{-75.5333, 20.6833}, // ICR
    Coordinate{-97.4331, 37.6499}, // ICT
    Coordinate{-141.662, 59.9689}, // ICY
    Coordinate{-112.071, 43.5136}, // IDA
    Coordinate{19.6, -5}, // IDF
    Coordinate{-116.123, 45.9425}, // IDH
    Coordinate{-79.1056, 40.6322}, // IDI
    Coordinate{-95.7783, 37.1583}, // IDP
    Coordinate{75.8008, 22.7217}, // IDR
    Coordinate{-2.39111, 46.7186}, // IDY
    Coordinate{15.7986, 52.1386}, // IEG
    Coordinate{127.787, 26.7225}, // IEJ
    Coordinate{30.4517, 50.4017}, // IEV
    Coordinate{-23.1353, 66.0581}, // IFJ
    Coordinate{146.012, -17.5586}, // IFL
    Coordinate{51.8611, 32.7508}, // IFN
    Coordinate{24.6861, 48.8842}, // IFO
    Coordinate{-114.559, 35.1575}, // IFP
    Coordinate{-73.6669, 20.975}, // IGA
    Coordinate{-69.5761, -41.3211}, // IGB
    Coordinate{43.8664, 39.9831}, // IGD
    Coordinate{9.31389, -1.93333}, // IGE
    Coordinate{-155.902, 59.3242}, // IGG
    Coordinate{146.152, -18.6606}, // IGH
    Coordinate{-113.938, 35.2594}, // IGM
    Coordinate{124.214, 8.13052}, // IGN
    Coordinate{-76.6865, 7.67719}, // IGO
    Coordinate{-54.4735, -25.7372}, // IGR
    Coordinate{45.013, 43.3193}, // IGT
    Coordinate{-54.485, -25.6003}, // IGU
    Coordinate{32.9292, -25.9978}, // IHC
    Coordinate{51.6833, 15.4167}, // IHN
    Coordinate{46.1651, -22.4061}, // IHO
    Coordinate{60.7199, 27.2289}, // IHR
    Coordinate{145.4, -7.9002}, // IHU
    Coordinate{-9.57, 53.0919}, // IIA
    Coordinate{46.4044, 33.5866}, // IIL
    Coordinate{154.227, -4.5}, // IIS
    Coordinate{53.4567, 56.8333}, // IJK
    Coordinate{-53.8456, -28.3706}, // IJU
    Coordinate{51.1522, 35.4161}, // IKA
    Coordinate{-81.0983, 36.2228}, // IKB
    Coordinate{129.786, 33.7492}, // IKI
    Coordinate{-87.8464, 41.0714}, // IKK
    Coordinate{23.2833, -1.2}, // IKL
    Coordinate{128.903, 71.6975}, // IKS
    Coordinate{104.353, 52.2729}, // IKT
    Coordinate{76.7133, 42.5883}, // IKU
    Coordinate{0.535833, 41.7278}, // ILD
    Coordinate{-97.6864, 31.0858}, // ILE
    Coordinate{-95.6181, 56.0517}, // ILF
    Coordinate{-75.6067, 39.6786}, // ILG
    Coordinate{-154.911, 59.7492}, // ILI
    Coordinate{48.8, -19.5833}, // ILK
    Coordinate{-95.1306, 45.1178}, // ILL
    Coordinate{-77.9025, 34.2706}, // ILM
    Coordinate{-83.7922, 39.4281}, // ILN
    Coordinate{122.493, 10.7147}, // ILO
    Coordinate{167.451, -22.5889}, // ILP
    Coordinate{-71.3606, -17.695}, // ILQ
    Coordinate{4.49444, 8.44056}, // ILR
    Coordinate{-89.1256, 13.6917}, // ILS
    Coordinate{38.0675, -2.91914}, // ILU
    Coordinate{145.833, -5.48333}, // ILX
    Coordinate{-6.24917, 55.6833}, // ILY
    Coordinate{18.6136, 49.2333}, // ILZ
    Coordinate{150.5, -9.5}, // IMA
    Coordinate{-60.2833, 5.71667}, // IMB
    Coordinate{171.483, 7.0167}, // IMI
    Coordinate{81.8189, 29.9711}, // IMK
    Coordinate{-81.4028, 26.4325}, // IMM
    Coordinate{25.1022, 5.0017}, // IMO
    Coordinate{-47.4583, -5.53056}, // IMP
    Coordinate{44.9253, 39.1924}, // IMQ
    Coordinate{-85.4647, 38.76}, // IMS
    Coordinate{-88.1144, 45.8183}, // IMT
    Coordinate{60.1114, 66.0556}, // INA
    Coordinate{-88.4106, 16.5219}, // INB
    Coordinate{106.393, 38.3217}, // INC
    Coordinate{-86.2944, 39.7172}, // IND
    Coordinate{36.4333, -18.5833}, // INE
    Coordinate{5.74889, 19.5689}, // INF
    Coordinate{35.4085, -23.8764}, // INH
    Coordinate{21.8536, 43.3372}, // INI
    Coordinate{-97.0972, 32.0833}, // INJ
    Coordinate{-103.202, 31.7797}, // INK
    Coordinate{-93.4022, 48.5656}, // INL
    Coordinate{11.3439, 47.2603}, // INN
    Coordinate{18.2858, -1.9472}, // INO
    Coordinate{-9.51111, 53.0586}, // INQ
    Coordinate{-80.2219, 36.1336}, // INT
    Coordinate{166.919, -0.547458}, // INU
    Coordinate{-4.0475, 57.5425}, // INV
    Coordinate{-110.723, 35.0219}, // INW
    Coordinate{2.51142, 27.2505}, // INZ
    Coordinate{20.8219, 39.6964}, // IOA
    Coordinate{-4.62389, 54.0833}, // IOM
    Coordinate{18.045, 1.58333}, // ION
    Coordinate{-9.65389, 53.1062}, // IOR
    Coordinate{-39.0333, -14.815}, // IOS
    Coordinate{-91.5465, 41.6392}, // IOW
    Coordinate{169.283, -18.8564}, // IPA
    Coordinate{-109.422, -27.1647}, // IPC
    Coordinate{122.601, 7.7861}, // IPE
    Coordinate{-69.6947, -2.9336}, // IPG
    Coordinate{101.099, 4.5704}, // IPH
    Coordinate{-77.6755, 0.858464}, // IPI
    Coordinate{-115.579, 32.8342}, // IPL
    Coordinate{-42.4881, -19.4706}, // IPN
    Coordinate{-76.9217, 41.2417}, // IPT
    Coordinate{107.603, 35.7997}, // IQN
    Coordinate{-70.1813, -20.5352}, // IQQ
    Coordinate{-73.3086, -3.78472}, // IQT
    Coordinate{161.898, -10.4494}, // IRA
    Coordinate{-144.076, 65.8278}, // IRC
    Coordinate{89.0486, 24.1532}, // IRD
    Coordinate{143.305, -12.7869}, // IRG
    Coordinate{35.7519, -7.66944}, // IRI
    Coordinate{-66.7958, -29.3806}, // IRJ
    Coordinate{-92.545, 40.0933}, // IRK
    Coordinate{-85.1833, 15.95}, // IRN
    Coordinate{22.7169, 10.2364}, // IRO
    Coordinate{27.5881, 2.82667}, // IRP
    Coordinate{-65.0339, -0.416944}, // IRZ
    Coordinate{139.489, -20.6639}, // ISA
    Coordinate{72.8516, 33.5607}, // ISB
    Coordinate{-6.29167, 49.9133}, // ISC
    Coordinate{30.3819, 37.865}, // ISE
    Coordinate{124.245, 24.3964}, // ISG
    Coordinate{144.425, -24.2583}, // ISI
    Coordinate{-86.7403, 21.245}, // ISJ
    Coordinate{73.9131, 20.1192}, // ISK
    Coordinate{28.8142, 40.9761}, // ISL
    Coordinate{-81.4372, 28.2897}, // ISM
    Coordinate{-77.6117, 35.3233}, // ISO
    Coordinate{-73.1003, 40.7953}, // ISP
    Coordinate{-86.174, 45.9701}, // ISQ
    Coordinate{-69.7125, 43.9614}, // ISS
    Coordinate{28.7422, 41.2608}, // IST
    Coordinate{45.3144, 35.5608}, // ISU
    Coordinate{-89.8389, 44.3603}, // ISW
    Coordinate{-58.4817, -3.12639}, // ITA
    Coordinate{-56.0008, -4.24222}, // ITB
    Coordinate{-76.4586, 42.4914}, // ITH
    Coordinate{147.3, -9.5167}, // ITK
    Coordinate{135.438, 34.7855}, // ITM
    Coordinate{-155.048, 19.7253}, // ITO
    Coordinate{-56.5367, -29.1809}, // ITQ
    Coordinate{-49.2142, -18.445}, // ITR
    Coordinate{147.956, 45.2564}, // ITU
    Coordinate{-169.926, -19.08}, // IUE
    Coordinate{155.15, -5.8613}, // IUS
    Coordinate{48.6325, -13.4858}, // IVA
    Coordinate{168.313, -46.415}, // IVC
    Coordinate{27.4139, 68.6108}, // IVL
    Coordinate{151.143, -29.8883}, // IVR
    Coordinate{40.9333, 56.9417}, // IWA
    Coordinate{-90.1314, 46.5275}, // IWD
    Coordinate{131.79, 34.6764}, // IWJ
    Coordinate{-95.6725, 29.8183}, // IWS
    Coordinate{91.2422, 23.89}, // IXA
    Coordinate{88.3286, 26.6811}, // IXB
    Coordinate{81.7339, 25.44}, // IXD
    Coordinate{74.8897, 12.9619}, // IXE
    Coordinate{74.6175, 15.8592}, // IXG
    Coordinate{92.0072, 24.3081}, // IXH
    Coordinate{94.0978, 27.2956}, // IXI
    Coordinate{74.8375, 32.6892}, // IXJ
    Coordinate{70.2703, 21.3169}, // IXK
    Coordinate{77.5464, 34.1358}, // IXL
    Coordinate{78.0894, 9.83361}, // IXM
    Coordinate{91.6039, 24.0617}, // IXN
    Coordinate{75.6344, 32.2336}, // IXP
    Coordinate{91.8142, 24.1317}, // IXQ
    Coordinate{85.3217, 23.3142}, // IXR
    Coordinate{92.9786, 24.9131}, // IXS
    Coordinate{95.3833, 28.1}, // IXT
    Coordinate{75.3981, 19.8628}, // IXU
    Coordinate{94.8019, 28.1753}, // IXV
    Coordinate{86.1681, 22.8136}, // IXW
    Coordinate{70.1003, 23.1128}, // IXY
    Coordinate{92.735, 11.6458}, // IXZ
    Coordinate{-117.829, 35.6586}, // IYK
    Coordinate{-43.1731, -21.5131}, // IZA
    Coordinate{28.8014, 45.3922}, // IZL
    Coordinate{132.89, 35.4136}, // IZO
    Coordinate{70.4985, 34.3997}, // JAA
    Coordinate{132.893, -12.6583}, // JAB
    Coordinate{-110.738, 43.6072}, // JAC
    Coordinate{115.881, -32.0975}, // JAD
    Coordinate{-78.7742, -5.59528}, // JAE
    Coordinate{75.8122, 26.8242}, // JAI
    Coordinate{-72.5186, 18.2411}, // JAK
    Coordinate{-96.7975, 19.475}, // JAL
    Coordinate{-90.0758, 32.3111}, // JAN
    Coordinate{-84.7833, 9.98141}, // JAP
    Coordinate{151.507, -5.6525}, // JAQ
    Coordinate{53.5333, 28.4833}, // JAR
    Coordinate{168.978, 7.75}, // JAT
    Coordinate{-75.4733, -11.7831}, // JAU
    Coordinate{-51.0572, 69.2433}, // JAV
    Coordinate{-81.6878, 30.4942}, // JAX
    Coordinate{113.694, -8.2419}, // JBB
    Coordinate{-69.9814, 18.5756}, // JBQ
    Coordinate{-90.6464, 35.8317}, // JBR
    Coordinate{-56.0328, -28.6531}, // JBS
    Coordinate{-161.743, 60.7819}, // JBT
    Coordinate{-51.5517, -27.1728}, // JCB
    Coordinate{-94.8903, 38.8308}, // JCI
    Coordinate{141.722, -20.6683}, // JCK
    Coordinate{-5.30639, 35.8928}, // JCU
    Coordinate{-118.968, 44.4028}, // JDA
    Coordinate{-43.3856, -21.7931}, // JDF
    Coordinate{126.713, 33.3983}, // JDG
    Coordinate{73.0489, 26.2511}, // JDH
    Coordinate{-106.953, 47.3289}, // JDN
    Coordinate{-39.2717, -7.21833}, // JDO
    Coordinate{117.176, 29.3386}, // JDZ
    Coordinate{39.1556, 21.6811}, // JED
    Coordinate{-74.1705, 18.6633}, // JEE
    Coordinate{-92.1561, 38.5911}, // JEF
    Coordinate{-52.7847, 68.7218}, // JEG
    Coordinate{168.962, 7.565}, // JEJ
    Coordinate{-40.0719, -13.8778}, // JEQ
    Coordinate{-2.19528, 49.2081}, // JER
    Coordinate{-73.7789, 40.6397}, // JFK
    Coordinate{-80.6956, 41.7781}, // JFN
    Coordinate{-49.6708, 62.0147}, // JFR
    Coordinate{70.0125, 22.4656}, // JGA
    Coordinate{82.0369, 19.0744}, // JGB
    Coordinate{124.115, 50.3714}, // JGD
    Coordinate{98.3383, 39.8597}, // JGN
    Coordinate{114.737, 26.8575}, // JGS
    Coordinate{103.669, 1.64111}, // JHB
    Coordinate{100.76, 21.9739}, // JHG
    Coordinate{-111.419, 57.2239}, // JHL
    Coordinate{-156.673, 20.9631}, // JHM
    Coordinate{148.755, -20.2767}, // JHQ
    Coordinate{-53.7294, 66.9514}, // JHS
    Coordinate{-79.2581, 42.1533}, // JHW
    Coordinate{-58.7114, -11.4194}, // JIA
    Coordinate{43.1593, 11.5473}, // JIB
    Coordinate{102.348, 38.5419}, // JIC
    Coordinate{42.9119, 9.3322}, // JIJ
    Coordinate{26.3471, 37.6827}, // JIK
    Coordinate{36.815, 7.66201}, // JIM
    Coordinate{33.1931, 0.4525}, // JIN
    Coordinate{127.909, -8.14056}, // JIO
    Coordinate{-80.6667, -1}, // JIP
    Coordinate{108.829, 29.5175}, // JIQ
    Coordinate{86.2304, 27.6267}, // JIR
    Coordinate{115.801, 29.4769}, // JIU
    Coordinate{61.8056, 25.0678}, // JIW
    Coordinate{-76.7292, -7.16972}, // JJI
    Coordinate{38.1706, 0.230278}, // JJM
    Coordinate{118.589, 24.7989}, // JJN
    Coordinate{14.0717, 57.7583}, // JKG
    Coordinate{26.1406, 38.3431}, // JKH
    Coordinate{26.9406, 36.9633}, // JKL
    Coordinate{85.9222, 26.7086}, // JKR
    Coordinate{-95.2175, 31.8694}, // JKV
    Coordinate{-94.5007, 37.1479}, // JLN
    Coordinate{80.0603, 23.1834}, // JLR
    Coordinate{16.0653, -14.6986}, // JMB
    Coordinate{99.7864, 22.4158}, // JMJ
    Coordinate{25.3481, 37.4351}, // JMK
    Coordinate{83.7225, 28.7822}, // JMO
    Coordinate{-98.6783, 46.9297}, // JMS
    Coordinate{130.465, 46.8433}, // JMU
    Coordinate{-44.3864, -15.4747}, // JNA
    Coordinate{28.2461, -26.1392}, // JNB
    Coordinate{116.347, 35.2928}, // JNG
    Coordinate{-60.9339, -34.5459}, // JNI
    Coordinate{-134.576, 58.355}, // JNU
    Coordinate{25.3682, 37.0811}, // JNX
    Coordinate{121.28, 40.93}, // JNZ
    Coordinate{29.6244, 62.6589}, // JOE
    Coordinate{110.432, -7.78806}, // JOG
    Coordinate{-48.7978, -26.2231}, // JOI
    Coordinate{-106.585, 68.1253}, // JOJ
    Coordinate{47.895, 56.705}, // JOK
    Coordinate{121.01, 6.05307}, // JOL
    Coordinate{8.86889, 9.63972}, // JOS
    Coordinate{-88.1786, 41.5203}, // JOT
    Coordinate{-34.9503, -7.14833}, // JPA
    Coordinate{-61.8467, -10.8706}, // JPR
    Coordinate{-52.6961, 70.7342}, // JQA
    Coordinate{-78.1572, 7.51778}, // JQE
    Coordinate{-158.07, 21.3072}, // JRF
    Coordinate{84.0503, 21.9133}, // JRG
    Coordinate{94.1756, 26.7317}, // JRH
    Coordinate{-58.4894, -10.3058}, // JRN
    Coordinate{37.0744, -3.42944}, // JRO
    Coordinate{70.855, 26.8803}, // JSA
    Coordinate{26.1013, 35.2161}, // JSH
    Coordinate{23.5036, 39.1772}, // JSI
    Coordinate{132.66, 47.11}, // JSJ
    Coordinate{-70.4589, -44.0583}, // JSM
    Coordinate{89.1608, 23.1836}, // JSR
    Coordinate{-78.8347, 40.3156}, // JST
    Coordinate{-52.9394, 65.4125}, // JSU
    Coordinate{24.95, 37.4228}, // JSY
    Coordinate{-49.0683, -22.1578}, // JTC
    Coordinate{-51.7753, -17.83}, // JTI
    Coordinate{25.4793, 36.3992}, // JTR
    Coordinate{26.3758, 36.5799}, // JTY
    Coordinate{-57.5389, -11.2867}, // JUA
    Coordinate{31.6011, 4.87201}, // JUB
    Coordinate{117.687, 30.7403}, // JUH
    Coordinate{-65.0978, -24.3925}, // JUJ
    Coordinate{-70.1581, -15.4669}, // JUL
    Coordinate{82.1933, 29.2744}, // JUM
    Coordinate{115.055, -30.3033}, // JUR
    Coordinate{-86.3, 14.6526}, // JUT
    Coordinate{-56.1306, 72.7903}, // JUV
    Coordinate{118.899, 28.9658}, // JUZ
    Coordinate{45.2739, -18.8058}, // JVA
    Coordinate{-74.5983, 40.5244}, // JVI
    Coordinate{-89.0417, 42.6203}, // JVL
    Coordinate{24.691, -24.6023}, // JWA
    Coordinate{48.3585, 36.5911}, // JWN
    Coordinate{130.997, 45.3061}, // JXA
    Coordinate{-84.4606, 42.2606}, // JXN
    Coordinate{57.6703, 28.7269}, // JYR
    Coordinate{25.6728, 62.4008}, // JYV
    Coordinate{103.685, 32.8542}, // JZH
    Coordinate{31.1333, -10.2172}, // KAA
    Coordinate{28.885, -16.5197}, // KAB
    Coordinate{41.1914, 37.0206}, // KAC
    Coordinate{7.32, 10.6958}, // KAD
    Coordinate{-133.946, 56.9731}, // KAE
    Coordinate{155.4, -6.283}, // KAF
    Coordinate{-59.4914, 5.1725}, // KAI
    Coordinate{27.6875, 64.2842}, // KAJ
    Coordinate{-158.741, 64.3189}, // KAL
    Coordinate{42.6111, 15.3611}, // KAM
    Coordinate{8.52444, 12.0475}, // KAN
    Coordinate{29.2319, 65.9903}, // KAO
    Coordinate{22.65, -8.35}, // KAP
    Coordinate{-60.6167, 5.86417}, // KAR
    Coordinate{18.7333, -28.0333}, // KAS
    Coordinate{173.285, -35.07}, // KAT
    Coordinate{23.0514, 63.1242}, // KAU
    Coordinate{-61.7832, 5.59306}, // KAV
    Coordinate{98.538, 10.0493}, // KAW
    Coordinate{114.26, -27.6917}, // KAX
    Coordinate{179.017, -17.617}, // KAY
    Coordinate{127.896, 1.18528}, // KAZ
    Coordinate{-11.55, 9.583}, // KBA
    Coordinate{-145.824, 66.2739}, // KBC
    Coordinate{31.4978, 2.32639}, // KBG
    Coordinate{9.97722, 2.87278}, // KBI
    Coordinate{69.2123, 34.5659}, // KBL
    Coordinate{147.278, -6.1394}, // KBM
    Coordinate{24.5461, -6.12056}, // KBN
    Coordinate{26.9167, -6.0833}, // KBO
    Coordinate{30.8933, 50.3447}, // KBP
    Coordinate{33.4667, -13.0167}, // KBQ
    Coordinate{102.293, 6.16667}, // KBR
    Coordinate{-11.7624, 7.94389}, // KBS
    Coordinate{116.163, -3.29278}, // KBU
    Coordinate{98.9853, 8.10016}, // KBV
    Coordinate{-158.401, 56.2956}, // KBW
    Coordinate{132.289, -1.3139}, // KBX
    Coordinate{134.293, -32.8358}, // KBY
    Coordinate{173.602, -42.425}, // KBZ
    Coordinate{82.9869, 41.7181}, // KCA
    Coordinate{-55.7167, 3.15}, // KCB
    Coordinate{69.1535, 27.1992}, // KCF
    Coordinate{110.347, 1.48444}, // KCH
    Coordinate{108.061, 57.7728}, // KCK
    Coordinate{-158.534, 56.3111}, // KCL
    Coordinate{36.9533, 37.5386}, // KCM
    Coordinate{-158.775, 56.255}, // KCQ
    Coordinate{80.3206, 5.99389}, // KCT
    Coordinate{31.7367, 1.75}, // KCU
    Coordinate{133.669, 33.5461}, // KCZ
    Coordinate{121.598, -31.19}, // KDB
    Coordinate{2.933, 11.133}, // KDC
    Coordinate{66.6403, 27.7944}, // KDD
    Coordinate{142.745, -5.6956}, // KDE
    Coordinate{65.8503, 31.5072}, // KDH
    Coordinate{122.418, -4.08161}, // KDI
    Coordinate{10.75, -0.188889}, // KDJ
    Coordinate{-152.374, 57.8058}, // KDK
    Coordinate{22.8306, 58.9906}, // KDL
    Coordinate{72.9962, 0.488056}, // KDM
    Coordinate{11.3611, -2.40556}, // KDN
    Coordinate{73.5197, 1.85835}, // KDO
    Coordinate{143.507, -5.84085}, // KDP
    Coordinate{141.052, -3.6005}, // KDQ
    Coordinate{149.542, -6.20833}, // KDR
    Coordinate{75.5361, 35.3356}, // KDU
    Coordinate{178.157, -19.0581}, // KDV
    Coordinate{29.6992, 11.1371}, // KDX
    Coordinate{136.842, 62.7854}, // KDY
    Coordinate{-151.925, 59.3522}, // KEB
    Coordinate{-13.5167, 16.15}, // KED
    Coordinate{14.5333, -0.0833333}, // KEE
    Coordinate{-22.6056, 63.985}, // KEF
    Coordinate{145.097, -5.8325}, // KEG
    Coordinate{-122.259, 47.7547}, // KEH
    Coordinate{86.11, 55.2717}, // KEJ
    Coordinate{-157.472, 59.3547}, // KEK
    Coordinate{24.5847, 65.7792}, // KEM
    Coordinate{-11.1766, 7.8913}, // KEN
    Coordinate{-7.567, 9.5}, // KEO
    Coordinate{81.6669, 28.1036}, // KEP
    Coordinate{56.9511, 30.2744}, // KER
    Coordinate{-96.5061, 56.0367}, // KES
    Coordinate{99.6361, 21.3017}, // KET
    Coordinate{-92.8364, 52.9911}, // KEW
    Coordinate{145.904, -7.5378}, // KEX
    Coordinate{35.2508, -0.413778}, // KEY
    Coordinate{-11.4061, 16.5833}, // KFA
    Coordinate{119.437, -22.2919}, // KFE
    Coordinate{130.808, -17.4319}, // KFG
    Coordinate{-163.41, 54.8475}, // KFP
    Coordinate{33.7908, 41.3047}, // KFS
    Coordinate{22.4667, -5.9}, // KGA
    Coordinate{147.65, -6.1333}, // KGB
    Coordinate{137.521, -35.7139}, // KGC
    Coordinate{20.5925, 54.89}, // KGD
    Coordinate{157.587, -7.33278}, // KGE
    Coordinate{73.3353, 49.6717}, // KGF
    Coordinate{-12.2203, 12.5667}, // KGG
    Coordinate{147.5, -8.58333}, // KGH
    Coordinate{121.462, -30.7894}, // KGI
    Coordinate{33.8928, -9.95494}, // KGJ
    Coordinate{-157.259, 59.7267}, // KGK
    Coordinate{30.1331, -1.96656}, // KGL
    Coordinate{141.03, -5.66998}, // KGM
    Coordinate{74.535, 62.19}, // KGP
    Coordinate{27.0917, 36.7933}, // KGS
    Coordinate{101.735, 30.1575}, // KGT
    Coordinate{-160.065, 62.8944}, // KGX
    Coordinate{151.841, -26.5808}, // KGY
    Coordinate{36.4014, 45.3725}, // KHC
    Coordinate{48.2808, 33.4354}, // KHD
    Coordinate{32.5022, 46.6681}, // KHE
    Coordinate{76.02, 39.5431}, // KHG
    Coordinate{120.35, 22.5769}, // KHH
    Coordinate{67.1608, 24.9067}, // KHI
    Coordinate{50.3233, 29.2593}, // KHK
    Coordinate{95.6744, 25.9875}, // KHM
    Coordinate{115.9, 28.865}, // KHN
    Coordinate{102.826, 47.2467}, // KHR
    Coordinate{56.2333, 26.1708}, // KHS
    Coordinate{69.9517, 33.3336}, // KHT
    Coordinate{33.4753, 49.1308}, // KHU
    Coordinate{135.169, 48.5242}, // KHV
    Coordinate{23.7878, -19.1494}, // KHW
    Coordinate{44.9736, 38.4275}, // KHY
    Coordinate{-146.257, -15.7808}, // KHZ
    Coordinate{-121.121, 36.2286}, // KIC
    Coordinate{14.0833, 55.9119}, // KID
    Coordinate{-89.8553, 53.0125}, // KIF
    Coordinate{53.9797, 26.5262}, // KIH
    Coordinate{139.112, 37.9558}, // KIJ
    Coordinate{24.7636, -28.8017}, // KIM
    Coordinate{-76.7875, 17.9356}, // KIN
    Coordinate{169.128, 5.64617}, // KIO
    Coordinate{-98.4903, 33.8606}, // KIP
    Coordinate{147.1, -7.633}, // KIQ
    Coordinate{-9.52389, 52.1808}, // KIR
    Coordinate{34.7289, -0.086111}, // KIS
    Coordinate{23.017, 36.2743}, // KIT
    Coordinate{28.9308, 46.9278}, // KIV
    Coordinate{28.1497, -12.9006}, // KIW
    Coordinate{135.233, 34.4342}, // KIX
    Coordinate{39.5086, -8.91111}, // KIY
    Coordinate{92.4933, 56.1717}, // KJA
    Coordinate{107.981, 26.9742}, // KJH
    Coordinate{86.9981, 48.2211}, // KJI
    Coordinate{3.20472, 50.8172}, // KJK
    Coordinate{127.293, 26.1683}, // KJP
    Coordinate{108.191, -6.6692}, // KJT
    Coordinate{96.7911, 3.73444}, // KJX
    Coordinate{-161.154, 64.9394}, // KKA
    Coordinate{-152.371, 58.1908}, // KKB
    Coordinate{102.782, 16.4644}, // KKC
    Coordinate{147.733, -8.88306}, // KKD
    Coordinate{173.912, -35.2628}, // KKE
    Coordinate{-162.881, 59.9608}, // KKH
    Coordinate{131.035, 33.8456}, // KKJ
    Coordinate{29.8878, 69.725}, // KKN
    Coordinate{173.817, -35.4528}, // KKO
    Coordinate{-146.886, -15.6677}, // KKR
    Coordinate{51.577, 33.8953}, // KKS
    Coordinate{-87.4283, 40.7586}, // KKT
    Coordinate{18.7833, -5.03583}, // KKW
    Coordinate{129.928, 28.3214}, // KKX
    Coordinate{-7.29611, 52.6508}, // KKY
    Coordinate{102.996, 11.6131}, // KKZ
    Coordinate{32.5925, 0.326111}, // KLA
    Coordinate{22.4806, -14.9983}, // KLB
    Coordinate{-16.0511, 14.1467}, // KLC
    Coordinate{35.76, 56.825}, // KLD
    Coordinate{14.4456, 10.0925}, // KLE
    Coordinate{36.3689, 54.5467}, // KLF
    Coordinate{-160.341, 61.5364}, // KLG
    Coordinate{74.2894, 16.6647}, // KLH
    Coordinate{35.8342, 3.48036}, // KLK
    Coordinate{-156.859, 59.1281}, // KLL
    Coordinate{55.4519, 37.375}, // KLM
    Coordinate{-153.977, 57.535}, // KLN
    Coordinate{122.378, 11.6813}, // KLO
    Coordinate{112.537, -3.37639}, // KLP
    Coordinate{16.2833, 56.6833}, // KLR
    Coordinate{-122.898, 46.1181}, // KLS
    Coordinate{14.3372, 46.6428}, // KLU
    Coordinate{12.915, 50.2031}, // KLV
    Coordinate{-133.076, 55.5792}, // KLW
    Coordinate{22.0256, 37.0684}, // KLX
    Coordinate{26.7333, -2.58333}, // KLY
    Coordinate{17.0933, -29.6884}, // KLZ
    Coordinate{145.771, -7.96365}, // KMA
    Coordinate{144.633, -5.5}, // KMB
    Coordinate{45.5281, 27.9008}, // KMC
    Coordinate{28.9078, -2.46222}, // KME
    Coordinate{102.929, 25.1019}, // KMG
    Coordinate{23.4114, -27.4597}, // KMH
    Coordinate{131.449, 31.8772}, // KMI
    Coordinate{130.855, 32.8372}, // KMJ
    Coordinate{12.6167, -3.48333}, // KMK
    Coordinate{24.9833, -8.7333}, // KMN
    Coordinate{-159.05, 58.9903}, // KMO
    Coordinate{18.1114, -26.5397}, // KMP
    Coordinate{136.408, 36.3939}, // KMQ
    Coordinate{-1.5906, 6.7144}, // KMS
    Coordinate{104.162, 10.6333}, // KMT
    Coordinate{42.4475, -0.389333}, // KMU
    Coordinate{94.0508, 23.1875}, // KMV
    Coordinate{41.02, 57.7967}, // KMW
    Coordinate{24.7833, -14.8}, // KMZ
    Coordinate{-71.4786, -32.9497}, // KNA
    Coordinate{-112.531, 37.0111}, // KNB
    Coordinate{25.9, -2.9333}, // KND
    Coordinate{144.7, -5.2833}, // KNE
    Coordinate{133.695, -3.64452}, // KNG
    Coordinate{118.359, 24.4278}, // KNH
    Coordinate{117.653, -33.7}, // KNI
    Coordinate{14.5167, -3.95}, // KNJ
    Coordinate{-154.803, 59.4331}, // KNK
    Coordinate{24.15, -7.6014}, // KNM
    Coordinate{-9.22733, 10.4485}, // KNN
    Coordinate{98.878, 3.64174}, // KNO
    Coordinate{15.4565, -9.77078}, // KNP
    Coordinate{164.838, -21.0533}, // KNQ
    Coordinate{52.3519, 27.8203}, // KNR
    Coordinate{143.878, -39.8775}, // KNS
    Coordinate{-90.0367, 36.2258}, // KNT
    Coordinate{80.4122, 26.4028}, // KNU
    Coordinate{-157.373, 59.4517}, // KNW
    Coordinate{128.708, -15.7781}, // KNX
    Coordinate{-11.2528, 12.8333}, // KNZ
    Coordinate{-156.046, 19.7389}, // KOA
    Coordinate{123.671, -10.1714}, // KOE
    Coordinate{105.85, 14.1167}, // KOG
    Coordinate{-2.90056, 58.9581}, // KOI
    Coordinate{130.717, 31.8033}, // KOJ
    Coordinate{23.1392, 63.7203}, // KOK
    Coordinate{21.25, 8.5}, // KOL
    Coordinate{26.99, -5.4}, // KOO
    Coordinate{104.642, 17.3839}, // KOP
    Coordinate{146.6, -7.817}, // KOR
    Coordinate{103.637, 10.58}, // KOS
    Coordinate{-163.533, 63.0306}, // KOT
    Coordinate{12.4411, -1.18444}, // KOU
    Coordinate{69.5967, 53.33}, // KOV
    Coordinate{114.777, 25.8517}, // KOW
    Coordinate{-154.23, 57.1614}, // KOY
    Coordinate{-152.501, 57.9229}, // KOZ
    Coordinate{145.417, -5.5833}, // KPA
    Coordinate{-166.859, 65.2536}, // KPC
    Coordinate{141.1, -4.63333}, // KPE
    Coordinate{112.843, 2.00833}, // KPI
    Coordinate{142.822, -8.62855}, // KPL
    Coordinate{143.925, -5.3815}, // KPM
    Coordinate{-164.031, 59.9331}, // KPN
    Coordinate{129.42, 35.9878}, // KPO
    Coordinate{-152.582, 58.49}, // KPR
    Coordinate{152.77, -31.0744}, // KPS
    Coordinate{-114.658, 41.9761}, // KPT
    Coordinate{-159.161, 55.9067}, // KPV
    Coordinate{169.56, 66.9017}, // KPX
    Coordinate{-153.041, 57.93}, // KPY
    Coordinate{-165.604, 54.1447}, // KQA
    Coordinate{74.817, 26.5895}, // KQH
    Coordinate{116.687, -29.2167}, // KQR
    Coordinate{68.8628, 37.8622}, // KQT
    Coordinate{143.939, -35.7517}, // KRA
    Coordinate{140.83, -17.4558}, // KRB
    Coordinate{101.463, -2.09111}, // KRC
    Coordinate{30.0942, -2.54722}, // KRE
    Coordinate{17.7686, 63.0483}, // KRF
    Coordinate{-59.5333, 4.01667}, // KRG
    Coordinate{-0.138611, 51.2136}, // KRH
    Coordinate{144.25, -7.42472}, // KRI
    Coordinate{147.483, -8.75}, // KRJ
    Coordinate{19.7847, 50.0778}, // KRK
    Coordinate{86.1431, 41.6164}, // KRL
    Coordinate{-59.3097, 3.75194}, // KRM
    Coordinate{20.3356, 67.8214}, // KRN
    Coordinate{65.4153, 55.475}, // KRO
    Coordinate{9.12472, 56.2975}, // KRP
    Coordinate{37.6289, 48.7056}, // KRQ
    Coordinate{39.1706, 45.0347}, // KRR
    Coordinate{8.085, 58.2039}, // KRS
    Coordinate{32.5532, 15.5895}, // KRT
    Coordinate{147.1, -8.3}, // KRU
    Coordinate{35.665, 0.32}, // KRV
    Coordinate{53.0072, 40.0633}, // KRW
    Coordinate{145.667, -4.8333}, // KRX
    Coordinate{84.9525, 45.4664}, // KRY
    Coordinate{19, -1.45}, // KRZ
    Coordinate{162.956, 5.3543}, // KSA
    Coordinate{21.2411, 48.6631}, // KSC
    Coordinate{13.3375, 59.4447}, // KSD
    Coordinate{30.1025, 0.19}, // KSE
    Coordinate{9.37763, 51.4084}, // KSF
    Coordinate{146.717, -6.35}, // KSG
    Coordinate{47.1564, 34.3459}, // KSH
    Coordinate{-10.1244, 9.16056}, // KSI
    Coordinate{26.91, 35.4214}, // KSJ
    Coordinate{14.4947, 59.3333}, // KSK
    Coordinate{36.3286, 15.3872}, // KSL
    Coordinate{-163.302, 62.0608}, // KSM
    Coordinate{63.5503, 53.2069}, // KSN
    Coordinate{21.2811, 40.4463}, // KSO
    Coordinate{65.7733, 38.8033}, // KSQ
    Coordinate{120.437, -6.17567}, // KSR
    Coordinate{-5.7989, 11.327}, // KSS
    Coordinate{32.6981, 13.1894}, // KST
    Coordinate{7.82611, 63.1119}, // KSU
    Coordinate{140.703, -23.5431}, // KSV
    Coordinate{146.183, -6.6}, // KSX
    Coordinate{43.0989, 40.5586}, // KSY
    Coordinate{46.6967, 61.2367}, // KSZ
    Coordinate{116.773, -20.7122}, // KTA
    Coordinate{-132.537, 55.6881}, // KTB
    Coordinate{-5.0654, 8.1344}, // KTC
    Coordinate{131.327, 25.9447}, // KTD
    Coordinate{103.427, 4.53722}, // KTE
    Coordinate{172.775, -40.9038}, // KTF
    Coordinate{109.963, -1.81639}, // KTG
    Coordinate{106.055, 12.4852}, // KTI
    Coordinate{154.75, -5.3389}, // KTK
    Coordinate{34.9508, 0.897222}, // KTL
    Coordinate{85.3578, 27.6972}, // KTM
    Coordinate{-131.711, 55.3542}, // KTN
    Coordinate{-59.8322, 4.64917}, // KTO
    Coordinate{-76.825, 17.9858}, // KTP
    Coordinate{-166.466, 65.3314}, // KTS
    Coordinate{24.8481, 67.6986}, // KTT
    Coordinate{75.8456, 25.1601}, // KTU
    Coordinate{-62.416, 5.7167}, // KTV
    Coordinate{19.08, 50.4742}, // KTW
    Coordinate{-5.467, 12.35}, // KTX
    Coordinate{103.209, 3.77518}, // KUA
    Coordinate{173.44, 0.219662}, // KUC
    Coordinate{116.831, 6.92417}, // KUD
    Coordinate{157.595, -8.02403}, // KUE
    Coordinate{50.155, 53.5017}, // KUF
    Coordinate{144.193, 43.0408}, // KUH
    Coordinate{-162.524, 60.8733}, // KUK
    Coordinate{101.71, 2.74556}, // KUL
    Coordinate{130.659, 30.3856}, // KUM
    Coordinate{24.0847, 54.9639}, // KUN
    Coordinate{27.7944, 63.0086}, // KUO
    Coordinate{148.217, -10.0732}, // KUP
    Coordinate{148.2, -10.07}, // KUQ
    Coordinate{-37.1236, 65.5736}, // KUS
    Coordinate{42.4825, 42.1764}, // KUT
    Coordinate{77.1544, 31.8767}, // KUU
    Coordinate{126.616, 35.9039}, // KUV
    Coordinate{141.624, -5.37236}, // KUX
    Coordinate{143.122, -7.4196}, // KUY
    Coordinate{24.6192, 40.9133}, // KVA
    Coordinate{13.9728, 58.4561}, // KVB
    Coordinate{-162.266, 55.1164}, // KVC
    Coordinate{46.3175, 40.7378}, // KVD
    Coordinate{148.7, -10.17}, // KVE
    Coordinate{150.808, -2.57917}, // KVG
    Coordinate{33.5881, 67.4631}, // KVK
    Coordinate{-164.564, 67.7311}, // KVL
    Coordinate{170.414, 64.6653}, // KVM
    Coordinate{20.5853, 43.8186}, // KVO
    Coordinate{49.3483, 58.5033}, // KVX
    Coordinate{110.479, -5.80111}, // KWB
    Coordinate{106.801, 26.5386}, // KWE
    Coordinate{-133.243, 55.2964}, // KWF
    Coordinate{33.2069, 48.0431}, // KWG
    Coordinate{70.2033, 37.8917}, // KWH
    Coordinate{47.98, 29.2268}, // KWI
    Coordinate{126.809, 35.1264}, // KWJ
    Coordinate{-163.169, 59.8764}, // KWK
    Coordinate{110.039, 25.2181}, // KWL
    Coordinate{141.751, -15.4856}, // KWM
    Coordinate{-161.845, 59.755}, // KWN
    Coordinate{142.824, -7.97701}, // KWO
    Coordinate{-153.549, 57.77}, // KWP
    Coordinate{35.5967, 33.2167}, // KWS
    Coordinate{-161.444, 60.7903}, // KWT
    Coordinate{155.3, -6.183}, // KWV
    Coordinate{41.2975, -1.96056}, // KWY
    Coordinate{25.5, -10.7667}, // KWZ
    Coordinate{26.7167, -26.8667}, // KXE
    Coordinate{136.933, 50.4083}, // KXK
    Coordinate{154.599, -5.2771}, // KXR
    Coordinate{-144.403, -16.3398}, // KXU
    Coordinate{121.527, 22.0294}, // KYD
    Coordinate{-154.454, 57.5661}, // KYK
    Coordinate{93.5347, 19.4244}, // KYP
    Coordinate{-11.4044, 14.4811}, // KYS
    Coordinate{94.1333, 21.4}, // KYT
    Coordinate{-157.731, 64.8758}, // KYU
    Coordinate{146.6, -6.1333}, // KYX
    Coordinate{94.4052, 51.6761}, // KYZ
    Coordinate{-153.746, 57.5533}, // KZB
    Coordinate{104.564, 12.255}, // KZC
    Coordinate{104.148, 12.5333}, // KZD
    Coordinate{21.8408, 40.2858}, // KZI
    Coordinate{49.2817, 55.6067}, // KZN
    Coordinate{65.5925, 44.7069}, // KZO
    Coordinate{30.13, 39.1114}, // KZR
    Coordinate{29.5764, 36.1417}, // KZS
    Coordinate{-102.689, 38.0697}, // LAA
    Coordinate{13.2312, -8.8581}, // LAD
    Coordinate{146.726, -6.56972}, // LAE
    Coordinate{-86.9369, 40.4122}, // LAF
    Coordinate{127.501, -0.637222}, // LAH
    Coordinate{-3.47444, 48.7542}, // LAI
    Coordinate{-50.2822, -27.7828}, // LAJ
    Coordinate{-135.006, 68.2233}, // LAK
    Coordinate{-82.0186, 27.9889}, // LAL
    Coordinate{-106.269, 35.8797}, // LAM
    Coordinate{-84.5862, 42.7786}, // LAN
    Coordinate{120.532, 18.1781}, // LAO
    Coordinate{-110.363, 24.0727}, // LAP
    Coordinate{21.9639, 32.7886}, // LAQ
    Coordinate{-105.675, 41.3119}, // LAR
    Coordinate{-115.152, 36.08}, // LAS
    Coordinate{40.9131, -2.25235}, // LAU
    Coordinate{-98.4167, 34.5676}, // LAW
    Coordinate{-118.408, 33.9425}, // LAX
    Coordinate{29.7514, -28.5816}, // LAY
    Coordinate{-43.4078, -13.2617}, // LAZ
    Coordinate{-1.66056, 53.8658}, // LBA
    Coordinate{-101.821, 33.6636}, // LBB
    Coordinate{10.7192, 53.8053}, // LBC
    Coordinate{69.6947, 40.2153}, // LBD
    Coordinate{-79.4067, 40.2747}, // LBE
    Coordinate{-100.684, 41.1261}, // LBF
    Coordinate{2.44139, 48.9694}, // LBG
    Coordinate{119.889, -8.48667}, // LBJ
    Coordinate{40.8817, 0.34833}, // LBK
    Coordinate{-100.96, 37.0442}, // LBL
    Coordinate{36.0129, 0.6027}, // LBN
    Coordinate{23.3783, -4.9667}, // LBO
    Coordinate{115.45, 3.18333}, // LBP
    Coordinate{10.2457, -0.704444}, // LBQ
    Coordinate{-64.7839, -7.25028}, // LBR
    Coordinate{179.34, -16.4668}, // LBS
    Coordinate{-79.0594, 34.6097}, // LBT
    Coordinate{115.25, 5.30056}, // LBU
    Coordinate{9.41222, 0.458611}, // LBV
    Coordinate{115.683, 3.86667}, // LBW
    Coordinate{120.103, 13.8565}, // LBX
    Coordinate{20.7328, -8.44153}, // LBZ
    Coordinate{33.6303, 34.8789}, // LCA
    Coordinate{-86.853, 15.7425}, // LCE
    Coordinate{-88.9611, 15.6681}, // LCF
    Coordinate{-8.37722, 43.3019}, // LCG
    Coordinate{-93.2233, 30.1261}, // LCH
    Coordinate{-71.4189, 43.5728}, // LCI
    Coordinate{19.3981, 51.7219}, // LCJ
    Coordinate{-82.9278, 39.8139}, // LCK
    Coordinate{-83.6422, 22.3361}, // LCL
    Coordinate{-64.5333, -31.0086}, // LCM
    Coordinate{14.5333, -2.45}, // LCO
    Coordinate{-70.6678, -38.0828}, // LCP
    Coordinate{-82.5769, 30.1819}, // LCQ
    Coordinate{-72.8023, -1.45789}, // LCR
    Coordinate{10.5764, 43.8256}, // LCV
    Coordinate{116.746, 25.6742}, // LCX
    Coordinate{0.055278, 51.5053}, // LCY
    Coordinate{88.1235, 25.0104}, // LDA
    Coordinate{-51.1367, -23.3303}, // LDB
    Coordinate{-0.00194444, 43.185}, // LDE
    Coordinate{45.7228, 64.8958}, // LDG
    Coordinate{159.077, -31.5383}, // LDH
    Coordinate{39.7586, -9.85}, // LDI
    Coordinate{-74.2447, 40.6175}, // LDJ
    Coordinate{13.1667, 58.45}, // LDK
    Coordinate{-86.4078, 43.9625}, // LDM
    Coordinate{86.67, 27.2531}, // LDN
    Coordinate{-55.4071, 4.37611}, // LDO
    Coordinate{129.019, 47.7519}, // LDS
    Coordinate{118.324, 5.03222}, // LDU
    Coordinate{-54.0344, 5.48306}, // LDX
    Coordinate{-7.16194, 55.0428}, // LDY
    Coordinate{114.089, -22.2358}, // LEA
    Coordinate{-72.3042, 43.6261}, // LEB
    Coordinate{30.2625, 59.8003}, // LED
    Coordinate{-81.8087, 28.8231}, // LEE
    Coordinate{28.6556, -29.8908}, // LEF
    Coordinate{0.088055, 49.5339}, // LEH
    Coordinate{-2.37, 36.8439}, // LEI
    Coordinate{12.2364, 51.4239}, // LEJ
    Coordinate{-12.29, 11.3382}, // LEK
    Coordinate{135.805, -12.4983}, // LEL
    Coordinate{-5.65556, 42.5889}, // LEN
    Coordinate{-42.7331, -21.4719}, // LEP
    Coordinate{-5.67056, 50.1028}, // LEQ
    Coordinate{120.703, -27.8433}, // LER
    Coordinate{28.3167, -29.7833}, // LES
    Coordinate{-69.9431, -4.19333}, // LET
    Coordinate{1.40917, 42.3386}, // LEU
    Coordinate{178.759, -17.7111}, // LEV
    Coordinate{-70.2836, 44.0486}, // LEW
    Coordinate{-84.6058, 38.0364}, // LEX
    Coordinate{5.5231, 52.4553}, // LEY
    Coordinate{-88.175, 14.2}, // LEZ
    Coordinate{40.6667, -15.0333}, // LFB
    Coordinate{-94.75, 31.2339}, // LFK
    Coordinate{53.1881, 27.3727}, // LFM
    Coordinate{-78.3303, 36.0233}, // LFN
    Coordinate{44.35, 5.657}, // LFO
    Coordinate{111.497, 36.0431}, // LFQ
    Coordinate{-72.2711, 8.23917}, // LFR
    Coordinate{-91.9875, 30.2053}, // LFT
    Coordinate{1.25417, 6.16583}, // LFW
    Coordinate{-73.8726, 40.7772}, // LGA
    Coordinate{-118.152, 33.8178}, // LGB
    Coordinate{-85.0725, 33.0089}, // LGC
    Coordinate{-118.007, 45.2903}, // LGD
    Coordinate{127.619, -20.1089}, // LGE
    Coordinate{5.44417, 50.6378}, // LGG
    Coordinate{138.427, -30.9983}, // LGH
    Coordinate{-75.0942, 23.1789}, // LGI
    Coordinate{99.7286, 6.32972}, // LGK
    Coordinate{115.179, 3.45944}, // LGL
    Coordinate{149.417, -5.6833}, // LGN
    Coordinate{123.723, 13.1569}, // LGP
    Coordinate{-76.8694, 0.0925}, // LGQ
    Coordinate{-72.5877, -47.2437}, // LGR
    Coordinate{-69.5742, -35.4953}, // LGS
    Coordinate{-70.9264, 4.55}, // LGT
    Coordinate{-111.852, 41.7912}, // LGU
    Coordinate{-0.190278, 51.1472}, // LGW
    Coordinate{42.5458, 3.8125}, // LGX
    Coordinate{-70.5083, -3.91686}, // LHC
    Coordinate{74.4025, 31.5214}, // LHE
    Coordinate{147.984, -29.4567}, // LHG
    Coordinate{155.7, -6.417}, // LHP
    Coordinate{-0.461389, 51.4775}, // LHR
    Coordinate{-68.9658, -46.5385}, // LHS
    Coordinate{-77.4222, 41.1358}, // LHV
    Coordinate{103.619, 36.5075}, // LHW
    Coordinate{18.6333, 3.6333}, // LIE
    Coordinate{167.24, -20.7748}, // LIF
    Coordinate{1.18028, 45.8608}, // LIG
    Coordinate{-159.339, 21.9761}, // LIH
    Coordinate{169.309, 9.82333}, // LIK
    Coordinate{3.08694, 50.5633}, // LIL
    Coordinate{-77.1144, -12.0219}, // LIM
    Coordinate{9.27833, 45.4494}, // LIN
    Coordinate{-83.0219, 9.95778}, // LIO
    Coordinate{-49.7311, -21.6628}, // LIP
    Coordinate{21.4833, 2.16667}, // LIQ
    Coordinate{-85.5442, 10.5931}, // LIR
    Coordinate{-9.13417, 38.7742}, // LIS
    Coordinate{-92.22, 34.73}, // LIT
    Coordinate{97.2147, 19.6914}, // LIW
    Coordinate{34.7333, -12.0833}, // LIX
    Coordinate{-67.8858, 46.95}, // LIZ
    Coordinate{23.4444, -3.41866}, // LJA
    Coordinate{100.246, 26.6792}, // LJG
    Coordinate{-95.4622, 29.1086}, // LJN
    Coordinate{14.4561, 46.2244}, // LJU
    Coordinate{123.001, -8.27454}, // LKA
    Coordinate{-178.817, -18.1992}, // LKB
    Coordinate{-122.339, 47.6289}, // LKE
    Coordinate{34.345, 4.2041}, // LKG
    Coordinate{114.783, 3.31306}, // LKH
    Coordinate{-155.121, 58.9819}, // LKK
    Coordinate{24.9739, 70.0667}, // LKL
    Coordinate{13.6167, 68.1542}, // LKN
    Coordinate{80.8833, 26.7619}, // LKO
    Coordinate{-73.9619, 44.2644}, // LKP
    Coordinate{35.8833, 3.41667}, // LKU
    Coordinate{-120.399, 42.1611}, // LKV
    Coordinate{55.3658, 22.8047}, // LKW
    Coordinate{35.8183, -3.37639}, // LKY
    Coordinate{22.1219, 65.5436}, // LLA
    Coordinate{107.962, 25.4525}, // LLB
    Coordinate{121.746, 18.1819}, // LLC
    Coordinate{31.5658, -25.4736}, // LLE
    Coordinate{111.612, 26.3456}, // LLF
    Coordinate{144.529, -17.1428}, // LLG
    Coordinate{-87.8986, 15.4431}, // LLH
    Coordinate{38.9911, 11.9739}, // LLI
    Coordinate{102.917, -3.28}, // LLJ
    Coordinate{48.8064, 38.7586}, // LLK
    Coordinate{120.245, -3.08472}, // LLO
    Coordinate{-60.5491, -24.7214}, // LLS
    Coordinate{13.5333, -12.3667}, // LLT
    Coordinate{111.143, 37.6833}, // LLV
    Coordinate{33.7, -13.9667}, // LLW
    Coordinate{-72.0181, 44.5692}, // LLX
    Coordinate{-74.8458, 39.9428}, // LLY
    Coordinate{-152.302, 63.8861}, // LMA
    Coordinate{34.5831, -13.7569}, // LMB
    Coordinate{-73.7875, 2.17364}, // LMC
    Coordinate{0.201667, 47.9486}, // LME
    Coordinate{-85.55, 15.8667}, // LMH
    Coordinate{142.03, -3.4856}, // LMI
    Coordinate{166.266, 8.9217}, // LML
    Coordinate{-109.081, 25.6861}, // LMM
    Coordinate{115.01, 4.80806}, // LMN
    Coordinate{12.6181, 35.4978}, // LMP
    Coordinate{19.5764, 30.3781}, // LMQ
    Coordinate{23.4391, -28.3601}, // LMR
    Coordinate{-89.0625, 33.1447}, // LMS
    Coordinate{-121.733, 42.1561}, // LMT
    Coordinate{141.493, -7.0094}, // LMY
    Coordinate{-80.085, 26.5931}, // LNA
    Coordinate{168.16, -16.585}, // LNB
    Coordinate{-96.7175, 32.5775}, // LNC
    Coordinate{-108.73, 42.8152}, // LND
    Coordinate{168.172, -15.8647}, // LNE
    Coordinate{141.217, -4.86667}, // LNF
    Coordinate{146.117, -8.1667}, // LNG
    Coordinate{100.025, 23.7383}, // LNJ
    Coordinate{105.797, 33.788}, // LNL
    Coordinate{146.2, -7.217}, // LNM
    Coordinate{-81.3897, 41.6839}, // LNN
    Coordinate{121.315, -28.8781}, // LNO
    Coordinate{-82.53, 36.9875}, // LNP
    Coordinate{-90.1797, 43.2119}, // LNR
    Coordinate{-76.2944, 40.1222}, // LNS
    Coordinate{117.374, 2.83639}, // LNU
    Coordinate{152.628, -3.0424}, // LNV
    Coordinate{32.065, 54.745}, // LNX
    Coordinate{-156.951, 20.7856}, // LNY
    Coordinate{14.1875, 48.2333}, // LNZ
    Coordinate{-70.6481, -32.8144}, // LOB
    Coordinate{167.968, -15.3058}, // LOD
    Coordinate{101.722, 17.4392}, // LOE
    Coordinate{-79.3719, -3.9958}, // LOH
    Coordinate{-49.5433, -27.1603}, // LOI
    Coordinate{35.6086, 3.12222}, // LOK
    Coordinate{-118.565, 40.0664}, // LOL
    Coordinate{-101.944, 21.2592}, // LOM
    Coordinate{2.92833, 33.7644}, // LOO
    Coordinate{116.277, -8.75732}, // LOP
    Coordinate{25.7139, -25.1975}, // LOQ
    Coordinate{3.3211, 6.5772}, // LOS
    Coordinate{-88.0961, 41.6072}, // LOT
    Coordinate{-85.6636, 38.2281}, // LOU
    Coordinate{-101.47, 26.9558}, // LOV
    Coordinate{-77.97, 38.0097}, // LOW
    Coordinate{-90.1667, 14.9667}, // LOX
    Coordinate{36.7167, 2.74706}, // LOY
    Coordinate{-84.0775, 37.0869}, // LOZ
    Coordinate{-15.3867, 27.9319}, // LPA
    Coordinate{-68.1922, -16.5133}, // LPB
    Coordinate{-120.468, 34.6656}, // LPC
    Coordinate{-69.5816, -1.33167}, // LPD
    Coordinate{-70.4212, 5.47917}, // LPE
    Coordinate{104.979, 26.6064}, // LPF
    Coordinate{-57.8931, -34.9692}, // LPG
    Coordinate{15.6728, 58.4083}, // LPI
    Coordinate{39.5383, 52.7033}, // LPK
    Coordinate{-2.84972, 53.3336}, // LPL
    Coordinate{167.817, -16.45}, // LPM
    Coordinate{146.343, -6.3923}, // LPN
    Coordinate{-86.7344, 41.5725}, // LPO
    Coordinate{28.1486, 61.0458}, // LPP
    Coordinate{102.162, 19.8986}, // LPQ
    Coordinate{99.5042, 18.2709}, // LPT
    Coordinate{114.97, 1.70361}, // LPU
    Coordinate{21.0969, 56.5175}, // LPX
    Coordinate{3.76333, 45.0797}, // LPY
    Coordinate{-82.7028, 34.81}, // LQK
    Coordinate{-74.775, -0.182278}, // LQM
    Coordinate{63.1176, 34.9857}, // LQN
    Coordinate{27.5525, -29.4622}, // LRB
    Coordinate{-99.4617, 27.5439}, // LRD
    Coordinate{144.28, -23.4342}, // LRE
    Coordinate{-68.5347, 45.3622}, // LRG
    Coordinate{-1.19528, 46.1792}, // LRH
    Coordinate{-75.7, 9.03333}, // LRI
    Coordinate{-96.1936, 42.7781}, // LRJ
    Coordinate{1.0928, 9.7696}, // LRL
    Coordinate{-68.9117, 18.4511}, // LRM
    Coordinate{-79.7828, 32.8978}, // LRO
    Coordinate{-101.304, 56.2486}, // LRQ
    Coordinate{54.3811, 27.6694}, // LRR
    Coordinate{26.8003, 37.1847}, // LRS
    Coordinate{-3.44, 47.7606}, // LRT
    Coordinate{-106.922, 32.2894}, // LRU
    Coordinate{-66.6717, 11.9458}, // LRV
    Coordinate{151.08, -8.50628}, // LSA
    Coordinate{-71.1994, -29.9161}, // LSC
    Coordinate{-91.2567, 43.8792}, // LSE
    Coordinate{97.7525, 22.9758}, // LSH
    Coordinate{-1.29389, 59.8814}, // LSI
    Coordinate{-84.7, 11.0333}, // LSL
    Coordinate{115.583, 4.21639}, // LSM
    Coordinate{-120.869, 37.0628}, // LSN
    Coordinate{-70.1514, 11.7808}, // LSP
    Coordinate{-72.4256, -37.4019}, // LSQ
    Coordinate{-61.5806, 15.8644}, // LSS
    Coordinate{147.214, -41.5453}, // LST
    Coordinate{115.494, 4.55222}, // LSU
    Coordinate{96.9503, 5.22667}, // LSW
    Coordinate{96.9503, 5.22667}, // LSX
    Coordinate{153.26, -28.8303}, // LSY
    Coordinate{14.3931, 44.5658}, // LSZ
    Coordinate{30.3293, -23.8244}, // LTA
    Coordinate{16.3, 9.4}, // LTC
    Coordinate{9.71533, 30.1517}, // LTD
    Coordinate{85.583, 28.2}, // LTG
    Coordinate{96.2192, 46.3758}, // LTI
    Coordinate{35.9486, 35.4008}, // LTK
    Coordinate{12.7486, -0.826667}, // LTL
    Coordinate{-59.7961, 3.36889}, // LTM
    Coordinate{-0.368333, 51.8747}, // LTN
    Coordinate{-111.348, 25.9892}, // LTO
    Coordinate{1.6275, 50.5147}, // LTQ
    Coordinate{6.4816, 43.2054}, // LTT
    Coordinate{76.4642, 18.4117}, // LTU
    Coordinate{-76.55, 38.3153}, // LTW
    Coordinate{-78.6158, -0.906944}, // LTX
    Coordinate{86.7314, 27.6875}, // LUA
    Coordinate{-59.4408, 2.4}, // LUB
    Coordinate{-179.667, -16.7481}, // LUC
    Coordinate{15.2428, -26.6875}, // LUD
    Coordinate{19.7358, 48.3394}, // LUE
    Coordinate{8.91028, 46.0036}, // LUG
    Coordinate{75.9525, 30.8547}, // LUH
    Coordinate{-86.6925, 15.0333}, // LUI
    Coordinate{-84.4186, 39.1033}, // LUK
    Coordinate{-89.1728, 31.6731}, // LUL
    Coordinate{98.5478, 24.4}, // LUM
    Coordinate{28.4525, -15.3306}, // LUN
    Coordinate{19.8974, -11.7682}, // LUO
    Coordinate{-156.974, 21.2111}, // LUP
    Coordinate{-66.3567, -33.2772}, // LUQ
    Coordinate{18.7167, -4.8}, // LUS
    Coordinate{144.45, -15.55}, // LUU
    Coordinate{132.759, -5.75917}, // LUV
    Coordinate{122.761, -1.03778}, // LUW
    Coordinate{6.20444, 49.6233}, // LUX
    Coordinate{22.6903, 51.2319}, // LUZ
    Coordinate{-0.743, 48.032}, // LVA
    Coordinate{-55.6247, -30.8358}, // LVB
    Coordinate{25.8186, -17.8217}, // LVI
    Coordinate{-121.82, 37.6934}, // LVK
    Coordinate{-110.449, 45.6991}, // LVM
    Coordinate{122.423, -28.6136}, // LVO
    Coordinate{53.3561, 26.8103}, // LVP
    Coordinate{-55.9422, -13.0372}, // LVR
    Coordinate{-105.143, 35.6542}, // LVS
    Coordinate{-80.3994, 37.8583}, // LWB
    Coordinate{-95.2164, 39.0111}, // LWC
    Coordinate{122.237, -8.64056}, // LWE
    Coordinate{-114.922, 41.1172}, // LWL
    Coordinate{-71.1233, 42.7172}, // LWM
    Coordinate{43.8592, 40.7503}, // LWN
    Coordinate{23.9561, 49.8125}, // LWO
    Coordinate{-117.015, 46.3744}, // LWS
    Coordinate{-109.467, 47.0492}, // LWT
    Coordinate{-87.6056, 38.7642}, // LWV
    Coordinate{115.403, 4.84917}, // LWY
    Coordinate{90.9119, 29.2978}, // LXA
    Coordinate{101.402, 20.9606}, // LXG
    Coordinate{-99.7758, 40.7906}, // LXN
    Coordinate{32.7064, 25.6708}, // LXR
    Coordinate{25.2363, 39.9171}, // LXS
    Coordinate{23.2486, -14.3758}, // LXU
    Coordinate{-106.317, 39.2203}, // LXV
    Coordinate{112.388, 34.7413}, // LYA
    Coordinate{-80.1, 19.6667}, // LYB
    Coordinate{18.7161, 64.5481}, // LYC
    Coordinate{118.874, 34.5717}, // LYG
    Coordinate{-79.2011, 37.3253}, // LYH
    Coordinate{118.412, 35.0461}, // LYI
    Coordinate{4.93889, 45.7294}, // LYN
    Coordinate{72.9947, 31.365}, // LYP
    Coordinate{15.4656, 78.2461}, // LYR
    Coordinate{5.08111, 45.7256}, // LYS
    Coordinate{-91.8308, 47.8244}, // LYU
    Coordinate{0.939167, 50.9561}, // LYX
    Coordinate{22.4, -7.1833}, // LZA
    Coordinate{-102.22, 18.0017}, // LZC
    Coordinate{109.391, 24.2075}, // LZH
    Coordinate{18.0493, -9.11596}, // LZM
    Coordinate{119.956, 26.1574}, // LZN
    Coordinate{105.47, 29.03}, // LZO
    Coordinate{145.453, -14.6767}, // LZR
    Coordinate{-83.9625, 33.9781}, // LZU
    Coordinate{94.3353, 29.3033}, // LZY
    Coordinate{80.1636, 12.9822}, // MAA
    Coordinate{-49.1381, -5.36806}, // MAB
    Coordinate{-83.5619, 32.8222}, // MAC
    Coordinate{-3.56083, 40.4722}, // MAD
    Coordinate{-120.113, 36.9886}, // MAE
    Coordinate{-102.202, 31.9425}, // MAF
    Coordinate{145.783, -5.20833}, // MAG
    Coordinate{4.21861, 39.8625}, // MAH
    Coordinate{35.2625, -14.4889}, // MAI
    Coordinate{171.272, 7.06498}, // MAJ
    Coordinate{31.6522, 9.5589}, // MAK
    Coordinate{-74.3289, 44.8536}, // MAL
    Coordinate{-97.5253, 25.7699}, // MAM
    Coordinate{-2.275, 53.3539}, // MAN
    Coordinate{-60.0506, -3.04111}, // MAO
    Coordinate{149.5, -10.3}, // MAP
    Coordinate{98.5436, 16.6997}, // MAQ
    Coordinate{-71.7278, 10.5581}, // MAR
    Coordinate{147.424, -2.06194}, // MAS
    Coordinate{13.4417, -5.79833}, // MAT
    Coordinate{-152.243, -16.4264}, // MAU
    Coordinate{171.231, 8.705}, // MAV
    Coordinate{-89.9925, 36.5983}, // MAW
    Coordinate{-77.6847, 24.2833}, // MAY
    Coordinate{-67.1485, 18.2557}, // MAZ
    Coordinate{39.5942, -4.03472}, // MBA
    Coordinate{11.9125, -1.89306}, // MBC
    Coordinate{25.5444, -25.8333}, // MBD
    Coordinate{143.404, 44.3042}, // MBE
    Coordinate{-100.406, 45.5464}, // MBG
    Coordinate{152.715, -25.5133}, // MBH
    Coordinate{33.4622, -8.91861}, // MBI
    Coordinate{-77.9133, 18.5036}, // MBJ
    Coordinate{-54.9528, -10.1703}, // MBK
    Coordinate{-86.2469, 44.2725}, // MBL
    Coordinate{120.605, 13.2051}, // MBO
    Coordinate{-76.9883, -6.01889}, // MBP
    Coordinate{30.6, -0.555}, // MBQ
    Coordinate{-84.0797, 43.5328}, // MBS
    Coordinate{123.627, 12.3671}, // MBT
    Coordinate{159.839, -9.7475}, // MBU
    Coordinate{145.102, -37.9758}, // MBW
    Coordinate{15.6861, 46.48}, // MBX
    Coordinate{-57.7122, -3.35695}, // MBZ
    Coordinate{-9.467, 8.533}, // MCA
    Coordinate{-90.4719, 31.1783}, // MCB
    Coordinate{-121.401, 38.6678}, // MCC
    Coordinate{-84.6372, 45.865}, // MCD
    Coordinate{-120.514, 37.2847}, // MCE
    Coordinate{-155.606, 62.9528}, // MCG
    Coordinate{-79.9614, -3.26889}, // MCH
    Coordinate{-94.7139, 39.2975}, // MCI
    Coordinate{-72.4933, 11.2325}, // MCJ
    Coordinate{-100.592, 40.2064}, // MCK
    Coordinate{-148.911, 63.7325}, // MCL
    Coordinate{7.42056, 43.7264}, // MCM
    Coordinate{-83.6492, 32.6928}, // MCN
    Coordinate{-81.3089, 28.4294}, // MCO
    Coordinate{-51.0703, -0.0508333}, // MCP
    Coordinate{20.79, 48.1378}, // MCQ
    Coordinate{-57.6394, -30.2703}, // MCS
    Coordinate{58.2817, 23.5928}, // MCT
    Coordinate{136.075, -16.445}, // MCV
    Coordinate{-93.3311, 43.1578}, // MCW
    Coordinate{47.6523, 42.8168}, // MCX
    Coordinate{153.091, -26.6033}, // MCY
    Coordinate{-35.7836, -9.51722}, // MCZ
    Coordinate{-88.3042, 17.0045}, // MDB
    Coordinate{124.926, 1.54917}, // MDC
    Coordinate{-102.101, 32.0367}, // MDD
    Coordinate{-75.4267, 6.16722}, // MDE
    Coordinate{-90.3008, 45.1014}, // MDF
    Coordinate{129.569, 44.5242}, // MDG
    Coordinate{-89.2519, 37.7781}, // MDH
    Coordinate{8.61389, 7.70361}, // MDI
    Coordinate{-121.155, 44.6703}, // MDJ
    Coordinate{18.2886, 0.0225}, // MDK
    Coordinate{95.9781, 21.7022}, // MDL
    Coordinate{143.5, -4.633}, // MDM
    Coordinate{-146.307, 59.4497}, // MDO
    Coordinate{-57.5733, -37.9342}, // MDQ
    Coordinate{-71.8025, 21.8258}, // MDS
    Coordinate{-76.7633, 40.1931}, // MDT
    Coordinate{143.657, -6.14774}, // MDU
    Coordinate{10.7556, 1.00694}, // MDV
    Coordinate{-87.7525, 41.7861}, // MDW
    Coordinate{-58.0881, -29.2222}, // MDX
    Coordinate{-177.381, 28.2014}, // MDY
    Coordinate{-68.7928, -32.8317}, // MDZ
    Coordinate{-41.7639, -22.3428}, // MEA
    Coordinate{144.901, -37.7297}, // MEB
    Coordinate{-80.6786, -0.945833}, // MEC
    Coordinate{39.7058, 24.5503}, // MED
    Coordinate{168.038, -21.4814}, // MEE
    Coordinate{17.95, 11.05}, // MEF
    Coordinate{16.3124, -9.52492}, // MEG
    Coordinate{27.8264, 71.0289}, // MEH
    Coordinate{-88.7425, 32.3372}, // MEI
    Coordinate{-80.2147, 41.6267}, // MEJ
    Coordinate{144.843, -37.6733}, // MEL
    Coordinate{-89.9767, 35.0425}, // MEM
    Coordinate{-75.6956, 35.9185}, // MEO
    Coordinate{103.876, 2.3864}, // MEP
    Coordinate{96.2508, 4.04372}, // MEQ
    Coordinate{-120.568, 37.3806}, // MER
    Coordinate{-52.6022, -0.889722}, // MEU
    Coordinate{-119.752, 39.0008}, // MEV
    Coordinate{21.5417, -4.855}, // MEW
    Coordinate{-99.0719, 19.4361}, // MEX
    Coordinate{84.2289, 27.5772}, // MEY
    Coordinate{29.9866, -22.3561}, // MEZ
    Coordinate{39.6683, -7.9175}, // MFA
    Coordinate{27.2433, -29.8289}, // MFC
    Coordinate{-82.5167, 40.8214}, // MFD
    Coordinate{-98.2386, 26.1758}, // MFE
    Coordinate{13.2694, -1.53778}, // MFF
    Coordinate{73.5086, 34.3392}, // MFG
    Coordinate{-114.055, 36.835}, // MFH
    Coordinate{-90.1894, 44.6369}, // MFI
    Coordinate{179.951, -18.5669}, // MFJ
    Coordinate{120.003, 26.2239}, // MFK
    Coordinate{113.591, 22.1494}, // MFM
    Coordinate{167.923, -44.6733}, // MFN
    Coordinate{151.792, -5.5825}, // MFO
    Coordinate{7.1202, 13.5008}, // MFQ
    Coordinate{-122.874, 42.3742}, // MFR
    Coordinate{-71.9521, 1.33771}, // MFS
    Coordinate{31.9333, -13.2667}, // MFU
    Coordinate{-75.7608, 37.6467}, // MFV
    Coordinate{47.5667, 14.3}, // MFY
    Coordinate{149.117, -6.1368}, // MFZ
    Coordinate{-86.1681, 12.1414}, // MGA
    Coordinate{140.785, -37.7456}, // MGB
    Coordinate{-86.8211, 41.7033}, // MGC
    Coordinate{-64.1366, -13.3084}, // MGD
    Coordinate{-52.0122, -23.4794}, // MGF
    Coordinate{143.359, -5.9788}, // MGG
    Coordinate{30.3431, -30.8594}, // MGH
    Coordinate{-58.2469, -34.1822}, // MGI
    Coordinate{-74.2647, 41.51}, // MGJ
    Coordinate{-86.3939, 32.3006}, // MGM
    Coordinate{-74.8667, 9.11807}, // MGN
    Coordinate{45.3047, 2.01361}, // MGQ
    Coordinate{-83.8033, 31.085}, // MGR
    Coordinate{-157.907, -21.8958}, // MGS
    Coordinate{134.894, -12.0944}, // MGT
    Coordinate{93.6889, 18.8458}, // MGU
    Coordinate{126.874, -18.6243}, // MGV
    Coordinate{-79.9164, 39.6428}, // MGW
    Coordinate{11, -2.43333}, // MGX
    Coordinate{-84.225, 39.5889}, // MGY
    Coordinate{98.6214, 12.4397}, // MGZ
    Coordinate{-59.1511, 5.2667}, // MHA
    Coordinate{-73.7158, -42.3404}, // MHC
    Coordinate{59.645, 36.2342}, // MHD
    Coordinate{-98.0386, 43.7747}, // MHE
    Coordinate{-77.0836, 26.5114}, // MHH
    Coordinate{43.2, 11.7167}, // MHI
    Coordinate{-96.6717, 39.1411}, // MHK
    Coordinate{-93.2028, 39.0956}, // MHL
    Coordinate{19.8964, 60.1219}, // MHQ
    Coordinate{-121.298, 38.5539}, // MHR
    Coordinate{-122.272, 41.2631}, // MHS
    Coordinate{-71.4372, 42.9278}, // MHT
    Coordinate{147.334, -37.0475}, // MHU
    Coordinate{-63.9624, -19.8238}, // MHW
    Coordinate{-161, -10.3806}, // MHX
    Coordinate{141.4, -9}, // MHY
    Coordinate{-80.2906, 25.7933}, // MIA
    Coordinate{-93.3539, 45.0619}, // MIC
    Coordinate{-89.6578, 20.9369}, // MID
    Coordinate{-85.3958, 40.2422}, // MIE
    Coordinate{104.74, 31.43}, // MIG
    Coordinate{-49.9269, -22.1956}, // MII
    Coordinate{171.731, 6.085}, // MIJ
    Coordinate{27.2, 61.6864}, // MIK
    Coordinate{149.901, -36.9086}, // MIM
    Coordinate{-94.8875, 36.9092}, // MIO
    Coordinate{34.8067, 30.6522}, // MIP
    Coordinate{-96.1122, 41.1961}, // MIQ
    Coordinate{10.7547, 35.7581}, // MIR
    Coordinate{152.838, -10.6891}, // MIS
    Coordinate{-119.192, 35.5058}, // MIT
    Coordinate{13.0808, 11.8553}, // MIU
    Coordinate{-75.0722, 39.3678}, // MIV
    Coordinate{44.3158, -21.4264}, // MJA
    Coordinate{170.869, 10.2833}, // MJB
    Coordinate{-7.58722, 7.26667}, // MJC
    Coordinate{68.1431, 27.3353}, // MJD
    Coordinate{168.264, 7.76222}, // MJE
    Coordinate{13.2149, 65.784}, // MJF
    Coordinate{13.2778, 32.8944}, // MJI
    Coordinate{145.25, -5.7}, // MJJ
    Coordinate{113.577, -25.8933}, // MJK
    Coordinate{11.0578, -1.85}, // MJL
    Coordinate{23.5667, -6.12111}, // MJM
    Coordinate{46.3511, -15.6669}, // MJN
    Coordinate{16.4528, -21.0231}, // MJO
    Coordinate{116.14, -34.2653}, // MJP
    Coordinate{-94.9867, 43.65}, // MJQ
    Coordinate{-57.8708, -38.2261}, // MJR
    Coordinate{26.5979, 39.0567}, // MJT
    Coordinate{119.03, -2.58673}, // MJU
    Coordinate{-0.812222, 37.7747}, // MJV
    Coordinate{-74.2925, 39.9275}, // MJX
    Coordinate{114.022, 62.5344}, // MJZ
    Coordinate{12.7166, 49.9228}, // MKA
    Coordinate{13.9686, 0.9766}, // MKB
    Coordinate{-94.5928, 39.1233}, // MKC
    Coordinate{-87.8967, 42.9472}, // MKE
    Coordinate{-86.2356, 43.1678}, // MKG
    Coordinate{29.0722, -29.2817}, // MKH
    Coordinate{25.9294, 5.3331}, // MKI
    Coordinate{15.5821, -0.019055}, // MKJ
    Coordinate{-157.096, 21.1528}, // MKK
    Coordinate{-88.9156, 35.5997}, // MKL
    Coordinate{112.064, 2.89985}, // MKM
    Coordinate{-98.5992, 31.9203}, // MKN
    Coordinate{-95.3617, 35.6578}, // MKO
    Coordinate{-143.658, -16.588}, // MKP
    Coordinate{140.418, -8.52028}, // MKQ
    Coordinate{118.548, -26.6117}, // MKR
    Coordinate{38.7414, 10.7244}, // MKS
    Coordinate{-93.9186, 44.2217}, // MKT
    Coordinate{12.8908, 0.579167}, // MKU
    Coordinate{134.049, -0.891667}, // MKW
    Coordinate{149.18, -21.1717}, // MKY
    Coordinate{102.251, 2.26333}, // MKZ
    Coordinate{14.4775, 35.8575}, // MLA
    Coordinate{-80.6453, 28.1028}, // MLB
    Coordinate{-95.7833, 34.8825}, // MLC
    Coordinate{73.5291, 4.19183}, // MLE
    Coordinate{112.714, -7.92639}, // MLG
    Coordinate{7.52917, 47.59}, // EAP
    Coordinate{-90.5075, 41.4486}, // MLI
    Coordinate{-83.2414, 33.1542}, // MLJ
    Coordinate{-162.026, 61.8642}, // MLL
    Coordinate{-101.025, 19.8497}, // MLM
    Coordinate{-2.95639, 35.2797}, // MLN
    Coordinate{24.4769, 36.6969}, // MLO
    Coordinate{124.056, 7.6167}, // MLP
    Coordinate{-105.886, 46.4281}, // MLS
    Coordinate{-68.6856, 45.6478}, // MLT
    Coordinate{-92.0377, 32.5109}, // MLU
    Coordinate{-10.7586, 6.28917}, // MLW
    Coordinate{-150.644, 64.9975}, // MLY
    Coordinate{-54.2217, -32.3425}, // MLZ
    Coordinate{144.164, 43.8806}, // MMB
    Coordinate{-99.0181, 22.7403}, // MMC
    Coordinate{131.264, 25.8467}, // MMD
    Coordinate{-1.42944, 54.5092}, // MME
    Coordinate{9.30361, 5.70417}, // MMF
    Coordinate{117.842, -28.1161}, // MMG
    Coordinate{-118.839, 37.6242}, // MMH
    Coordinate{-84.5625, 35.3972}, // MMI
    Coordinate{137.923, 36.1667}, // MMJ
    Coordinate{32.7559, 68.7838}, // MMK
    Coordinate{-95.8219, 44.4505}, // MML
    Coordinate{148.705, -22.8033}, // MMM
    Coordinate{-71.5178, 42.4606}, // MMN
    Coordinate{-23.2136, 15.1558}, // MMO
    Coordinate{31.3333, -8.85917}, // MMQ
    Coordinate{-80.8011, 33.9208}, // MMT
    Coordinate{-74.415, 40.7994}, // MMU
    Coordinate{-123.136, 45.1944}, // MMV
    Coordinate{13.3714, 55.53}, // MMX
    Coordinate{125.295, 24.7828}, // MMY
    Coordinate{64.75, 35.933}, // MMZ
    Coordinate{126.673, 4.00694}, // MNA
    Coordinate{12.35, -5.93333}, // MNB
    Coordinate{40.7122, -14.4881}, // MNC
    Coordinate{177.098, -17.6731}, // MNF
    Coordinate{134.234, -12.0561}, // MNG
    Coordinate{57.482, 23.6389}, // MNH
    Coordinate{-62.1933, 16.7914}, // MNI
    Coordinate{48.3556, -21.2068}, // MNJ
    Coordinate{173.031, 1.00359}, // MNK
    Coordinate{121.019, 14.5086}, // MNL
    Coordinate{-87.6391, 45.1263}, // MNM
    Coordinate{-83.0633, 40.6161}, // MNN
    Coordinate{151.1, -24.8867}, // MNQ
    Coordinate{23.1528, -15.2544}, // MNR
    Coordinate{28.857, -11.1386}, // MNS
    Coordinate{-149.369, 65.1481}, // MNT
    Coordinate{97.6607, 16.4447}, // MNU
    Coordinate{-61.2839, -5.81695}, // MNX
    Coordinate{155.565, -7.41611}, // MNY
    Coordinate{-77.5156, 38.7214}, // MNZ
    Coordinate{-74.9222, 20.6539}, // MOA
    Coordinate{-88.2428, 30.6914}, // MOB
    Coordinate{-43.8219, -16.7061}, // MOC
    Coordinate{-120.954, 37.6258}, // MOD
    Coordinate{96.6453, 23.0919}, // MOE
    Coordinate{120.833, -8.6406}, // MOF
    Coordinate{99.2567, 20.5167}, // MOG
    Coordinate{-157.703, -19.8427}, // MOI
    Coordinate{-54.4003, 5.6076}, // MOJ
    Coordinate{7.2625, 62.7447}, // MOL
    Coordinate{-12.5, 17.75}, // MOM
    Coordinate{170.128, -43.9067}, // MON
    Coordinate{140.197, -28.1}, // MOO
    Coordinate{-84.7375, 43.6217}, // MOP
    Coordinate{44.3174, -20.2848}, // MOQ
    Coordinate{-83.3756, 36.1794}, // MOR
    Coordinate{-162.057, 64.6981}, // MOS
    Coordinate{-101.28, 48.2594}, // MOT
    Coordinate{-163.682, 62.0953}, // MOU
    Coordinate{148.077, -22.0578}, // MOV
    Coordinate{-149.762, -17.4894}, // MOZ
    Coordinate{24.1764, -17.6342}, // MPA
    Coordinate{101.088, -2.54328}, // MPC
    Coordinate{69.0333, 25.6836}, // MPD
    Coordinate{147.717, -6.5333}, // MPF
    Coordinate{147.717, -6.5333}, // MPG
    Coordinate{121.955, 11.9247}, // MPH
    Coordinate{-92.9092, 35.1389}, // MPJ
    Coordinate{126.38, 34.7589}, // MPK
    Coordinate{3.95929, 43.5789}, // MPL
    Coordinate{32.5725, -25.9208}, // MPM
    Coordinate{-75.38, 41.1378}, // MPO
    Coordinate{-77.7331, 8.94528}, // MPP
    Coordinate{35.7925, 30.1728}, // MPQ
    Coordinate{-94.9617, 33.0969}, // MPS
    Coordinate{-72.5622, 44.2036}, // MPV
    Coordinate{37.4564, 47.0725}, // MPW
    Coordinate{141.617, -4.9}, // MPX
    Coordinate{-54.0372, 3.6575}, // MPY
    Coordinate{-91.5111, 40.9467}, // MPZ
    Coordinate{-90.6525, 40.52}, // MQB
    Coordinate{-56.3844, 47.0958}, // MQC
    Coordinate{-68.7333, -41.25}, // MQD
    Coordinate{58.7567, 53.3933}, // MQF
    Coordinate{143.263, 66.45}, // MQJ
    Coordinate{-58.4015, -16.3379}, // MQK
    Coordinate{142.086, -34.2292}, // MQL
    Coordinate{40.6317, 37.2233}, // MQM
    Coordinate{14.3017, 66.3639}, // MQN
    Coordinate{31.0993, -25.3916}, // MQP
    Coordinate{16.0714, 8.62417}, // MQQ
    Coordinate{-61.1803, 12.8877}, // MQS
    Coordinate{-87.3953, 46.3536}, // MQT
    Coordinate{-74.8836, 5.2125}, // MQU
    Coordinate{0.148997, 35.9089}, // MQV
    Coordinate{-82.8794, 32.0969}, // MQW
    Coordinate{39.5333, 13.4672}, // MQX
    Coordinate{-86.52, 36.0089}, // MQY
    Coordinate{115.099, -33.9304}, // MQZ
    Coordinate{15.0597, 32.3256}, // MRA
    Coordinate{-77.9847, 39.4019}, // MRB
    Coordinate{-87.1792, 35.5544}, // MRC
    Coordinate{-71.1611, 8.58222}, // MRD
    Coordinate{35.0081, -1.40611}, // MRE
    Coordinate{145.419, -17.0692}, // MRG
    Coordinate{-149.844, 61.2136}, // MRI
    Coordinate{-88.0333, 14.15}, // MRJ
    Coordinate{-81.6725, 25.995}, // MRK
    Coordinate{147.6, -9.2}, // MRM
    Coordinate{-81.6114, 35.8203}, // MRN
    Coordinate{175.633, -40.975}, // MRO
    Coordinate{121.825, 13.36}, // MRQ
    Coordinate{-79.9408, -4.37806}, // MRR
    Coordinate{5.215, 43.4367}, // MRS
    Coordinate{133.7, -14.82}, // MRT
    Coordinate{57.683, -20.43}, // MRU
    Coordinate{43.0833, 44.225}, // MRV
    Coordinate{11.44, 54.6994}, // MRW
    Coordinate{49.1506, 30.5562}, // MRX
    Coordinate{-121.843, 36.5869}, // MRY
    Coordinate{149.845, -29.4989}, // MRZ
    Coordinate{-91.7628, 53.4414}, // MSA
    Coordinate{-111.728, 33.4608}, // MSC
    Coordinate{134.917, -22.6667}, // MSF
    Coordinate{28.8092, -29.8136}, // MSG
    Coordinate{141.372, 40.7053}, // MSJ
    Coordinate{-87.6103, 34.7453}, // MSL
    Coordinate{17.85, -4.7833}, // MSM
    Coordinate{-89.3459, 43.1364}, // MSN
    Coordinate{-114.091, 46.9164}, // MSO
    Coordinate{-93.2217, 44.8819}, // MSP
    Coordinate{28.0325, 53.8825}, // MSQ
    Coordinate{-74.8456, 44.9358}, // MSS
    Coordinate{5.76954, 50.9126}, // MST
    Coordinate{27.5525, -29.4622}, // MSU
    Coordinate{-74.795, 41.7017}, // MSV
    Coordinate{39.368, 15.6711}, // MSW
    Coordinate{12.7, -2.95}, // MSX
    Coordinate{-90.2581, 29.9933}, // MSY
    Coordinate{12.1667, -15.2167}, // MSZ
    Coordinate{175.74, -37.7344}, // MTA
    Coordinate{-75.4413, 7.97333}, // MTB
    Coordinate{35.5333, 6.96667}, // MTF
    Coordinate{-81.0514, 24.7261}, // MTH
    Coordinate{-107.894, 38.5098}, // MTJ
    Coordinate{172.992, 3.37411}, // MTK
    Coordinate{151.488, -32.7033}, // MTL
    Coordinate{-76.4139, 39.3256}, // MTN
    Coordinate{-88.2792, 39.4781}, // MTO
    Coordinate{-71.9206, 41.0767}, // MTP
    Coordinate{147.937, -26.4833}, // MTQ
    Coordinate{-75.8258, 8.82361}, // MTR
    Coordinate{31.3075, -26.5289}, // MTS
    Coordinate{-94.5808, 18.1036}, // MTT
    Coordinate{167.711, -13.6658}, // MTV
    Coordinate{-87.6806, 44.1289}, // MTW
    Coordinate{-100.106, 25.7783}, // MTY
    Coordinate{35.3886, 31.3282}, // MTZ
    Coordinate{157.263, -8.32797}, // MUA
    Coordinate{23.4281, -19.9725}, // MUB
    Coordinate{11.7861, 48.3539}, // MUC
    Coordinate{39.5631, -11.6731}, // MUD
    Coordinate{-155.668, 20.0014}, // MUE
    Coordinate{-111.971, 26.9058}, // MUG
    Coordinate{27.2217, 31.3253}, // MUH
    Coordinate{35.7486, 5.86389}, // MUJ
    Coordinate{-157.345, -20.1367}, // MUK
    Coordinate{-83.7042, 31.1378}, // MUL
    Coordinate{-63.1533, 9.74917}, // MUN
    Coordinate{114.322, 4.1775}, // MUR
    Coordinate{153.979, 24.2897}, // MUS
    Coordinate{-91.1483, 41.3678}, // MUT
    Coordinate{0.147142, 35.2077}, // MUW
    Coordinate{71.4192, 30.2033}, // MUX
    Coordinate{13.9167, -4.0147}, // MUY
    Coordinate{33.8022, -1.50278}, // MUZ
    Coordinate{-16.9181, 65.6558}, // MVA
    Coordinate{13.4347, -1.6561}, // MVB
    Coordinate{-87.3511, 31.4581}, // MVC
    Coordinate{-56.0308, -34.8383}, // MVD
    Coordinate{-95.712, 44.9714}, // MVE
    Coordinate{155.3, -6}, // MVI
    Coordinate{-77.4856, 18.0233}, // MVJ
    Coordinate{-72.6139, 44.5347}, // MVL
    Coordinate{-110.228, 36.7164}, // MVM
    Coordinate{-88.8586, 38.3233}, // MVN
    Coordinate{18.6775, 12.1719}, // MVO
    Coordinate{-70.2339, 1.25361}, // MVP
    Coordinate{30.095, 53.955}, // MVQ
    Coordinate{14.2531, 10.4514}, // MVR
    Coordinate{-39.8642, -18.0494}, // MVS
    Coordinate{-148.717, -14.87}, // MVT
    Coordinate{6.64999, 45.8223}, // MVV
    Coordinate{-122.421, 48.4708}, // MVW
    Coordinate{12.1167, 2.15}, // MVX
    Coordinate{-70.6144, 41.3931}, // MVY
    Coordinate{30.8589, -20.0619}, // MVZ
    Coordinate{-89.0111, 37.755}, // MWA
    Coordinate{116.022, -29.2014}, // MWB
    Coordinate{-88.0344, 43.1103}, // MWC
    Coordinate{31.8187, 18.45}, // MWE
    Coordinate{168.079, -14.9944}, // MWF
    Coordinate{145.9, -6.967}, // MWG
    Coordinate{-119.319, 47.2086}, // MWH
    Coordinate{143.485, -5.1283}, // MWI
    Coordinate{-60.1833, 7.48333}, // MWJ
    Coordinate{106.258, 3.34812}, // MWK
    Coordinate{-98.0603, 32.7817}, // MWL
    Coordinate{33.6167, -3.5}, // MWN
    Coordinate{-84.3964, 39.5317}, // MWO
    Coordinate{94.9729, 20.1579}, // MWQ
    Coordinate{107.187, 12.4606}, // MWV
    Coordinate{126.383, 34.9914}, // MWX
    Coordinate{32.9325, -2.44444}, // MWZ
    Coordinate{-90.1544, 35.8944}, // MXA
    Coordinate{120.331, -2.55972}, // MXB
    Coordinate{-109.341, 37.9325}, // MXC
    Coordinate{-79.3658, 34.7919}, // MXE
    Coordinate{-71.509, 42.3432}, // MXG
    Coordinate{143.238, -6.36333}, // MXH
    Coordinate{126.216, 6.9503}, // MXI
    Coordinate{6.46222, 9.65194}, // MXJ
    Coordinate{-115.241, 32.6306}, // MXL
    Coordinate{43.3667, -21.7539}, // MXM
    Coordinate{-3.81667, 48.6008}, // MXN
    Coordinate{-91.1633, 42.2203}, // MXO
    Coordinate{8.72306, 45.63}, // MXP
    Coordinate{-172.258, -13.7422}, // MXS
    Coordinate{44.0322, -18.0508}, // MXT
    Coordinate{115.518, -28.4739}, // MXU
    Coordinate{100.099, 49.6631}, // MXV
    Coordinate{106.283, 45.7667}, // MXW
    Coordinate{14.5111, 60.9586}, // MXX
    Coordinate{-142.904, 61.4369}, // MXY
    Coordinate{116.133, 24.35}, // MXZ
    Coordinate{150.144, -35.8978}, // MYA
    Coordinate{10.65, -3.46056}, // MYB
    Coordinate{-67.6494, 10.25}, // MYC
    Coordinate{40.1005, -3.22917}, // MYD
    Coordinate{139.56, 34.0736}, // MYE
    Coordinate{-117.139, 32.8158}, // MYF
    Coordinate{-73.0333, 22.3794}, // MYG
    Coordinate{-111.644, 36.8113}, // MYH
    Coordinate{144.054, -9.91667}, // MYI
    Coordinate{132.7, 33.8272}, // MYJ
    Coordinate{-142.687, 61.3356}, // MYK
    Coordinate{-116.102, 44.8886}, // MYL
    Coordinate{-59.6333, 4.6}, // MYM
    Coordinate{45.3269, 15.4692}, // MYN
    Coordinate{61.9014, 37.6067}, // MYP
    Coordinate{76.6583, 12.2292}, // MYQ
    Coordinate{-78.9311, 33.6797}, // MYR
    Coordinate{97.3519, 25.3836}, // MYT
    Coordinate{-166.271, 60.3714}, // MYU
    Coordinate{-121.57, 39.0978}, // MYV
    Coordinate{40.1819, -10.3361}, // MYW
    Coordinate{-77.7884, 25.402}, // MYX
    Coordinate{113.987, 4.32194}, // MYY
    Coordinate{34.9167, -14.1}, // MYZ
    Coordinate{-74.5358, -11.3257}, // MZA
    Coordinate{40.35, -11.3617}, // MZB
    Coordinate{11.5528, 0.777778}, // MZC
    Coordinate{-89.0238, 17.2784}, // MZE
    Coordinate{-4.08417, 14.5086}, // MZI
    Coordinate{-111.325, 32.5097}, // MZJ
    Coordinate{173.267, 2.05028}, // MZK
    Coordinate{-75.4624, 5.02984}, // MZL
    Coordinate{144.688, -5.9015}, // MZN
    Coordinate{-77.0867, 20.2889}, // MZO
    Coordinate{172.994, -41.1233}, // MZP
    Coordinate{67.2091, 36.7069}, // MZR
    Coordinate{-106.266, 23.1614}, // MZT
    Coordinate{85.3136, 26.1192}, // MZU
    Coordinate{114.809, 4.05056}, // MZV
    Coordinate{-0.256226, 33.5318}, // MZW
    Coordinate{-85.6797, 40.49}, // MZZ
    Coordinate{149.827, -30.3192}, // NAA
    Coordinate{140.725, -36.985}, // NAC
    Coordinate{1.36, 10.376}, // NAE
    Coordinate{79.0472, 21.0925}, // NAG
    Coordinate{125.528, 3.68306}, // NAH
    Coordinate{-59.1242, 3.95944}, // NAI
    Coordinate{45.4583, 39.1886}, // NAJ
    Coordinate{102.083, 14.9333}, // NAK
    Coordinate{43.6383, 43.5133}, // NAL
    Coordinate{127.083, -3.25}, // NAM
    Coordinate{177.443, -17.7553}, // NAN
    Coordinate{106.16, 30.7939}, // NAO
    Coordinate{14.2908, 40.8844}, // NAP
    Coordinate{-69.3886, 77.4886}, // NAQ
    Coordinate{-74.5906, 6.21002}, // NAR
    Coordinate{-77.4661, 25.0389}, // NAS
    Coordinate{-35.3664, -5.76889}, // NAT
    Coordinate{-141.267, -14.1767}, // NAU
    Coordinate{34.5264, 38.7764}, // NAV
    Coordinate{101.743, 6.52}, // NAW
    Coordinate{116.388, 39.7825}, // NAY
    Coordinate{-69.8097, 3.48333}, // NBB
    Coordinate{52.095, 55.5633}, // NBC
    Coordinate{10.4386, 36.0758}, // NBE
    Coordinate{-78.1389, 9.25028}, // NBL
    Coordinate{5.62194, -1.41028}, // NBN
    Coordinate{36.9275, -1.31917}, // NBO
    Coordinate{127.549, 42.0881}, // NBS
    Coordinate{-75.2069, 19.9064}, // NBW
    Coordinate{135.496, -3.37028}, // NBX
    Coordinate{-71.9394, 21.9175}, // NCA
    Coordinate{7.215, 43.6653}, // NCE
    Coordinate{-107.883, 30.4}, // NCG
    Coordinate{38.78, -10.3583}, // NCH
    Coordinate{-76.7833, 8.45}, // NCI
    Coordinate{-61.5289, -30.9572}, // NCJ
    Coordinate{-1.69167, 55.0375}, // NCL
    Coordinate{-147.992, 60.0772}, // NCN
    Coordinate{-84.7656, 11.1331}, // NCR
    Coordinate{29.9764, -27.7729}, // NCS
    Coordinate{-85.45, 10.1333}, // NCT
    Coordinate{59.6233, 42.4883}, // NCU
    Coordinate{6.10639, 45.9308}, // NCY
    Coordinate{129.904, -4.52167}, // NDA
    Coordinate{-17.0311, 20.9283}, // NDB
    Coordinate{77.3186, 19.1819}, // NDC
    Coordinate{13.8478, -11.168}, // NDD
    Coordinate{41.8444, 3.93396}, // NDE
    Coordinate{14.9772, -9.28056}, // NDF
    Coordinate{123.918, 47.2397}, // NDG
    Coordinate{15.0247, 12.125}, // NDJ
    Coordinate{168.126, 5.63306}, // NDK
    Coordinate{20.6344, 8.43}, // NDL
    Coordinate{35.1, 9.76667}, // NDM
    Coordinate{147.683, -9.1333}, // NDN
    Coordinate{-3.02821, 34.9888}, // NDR
    Coordinate{19.7194, -17.9564}, // NDU
    Coordinate{-58.8163, -38.4895}, // NEC
    Coordinate{54.3483, 56.11}, // NEF
    Coordinate{-78.3356, 18.34}, // NEG
    Coordinate{36.6, 9.05}, // NEK
    Coordinate{124.912, 56.9133}, // NER
    Coordinate{104.066, 20.4183}, // NEU
    Coordinate{-62.59, 17.2056}, // NEV
    Coordinate{72.65, 61.1083}, // NFG
    Coordinate{-175.631, -15.5711}, // NFO
    Coordinate{148.248, -34.2556}, // NGA
    Coordinate{121.462, 29.8267}, // NGB
    Coordinate{-64.3281, 18.7275}, // NGD
    Coordinate{13.5592, 7.35694}, // NGE
    Coordinate{179.34, -18.1156}, // NGI
    Coordinate{143.142, 51.7839}, // NGK
    Coordinate{-78.5886, 9.4449}, // NGN
    Coordinate{136.805, 34.8583}, // NGO
    Coordinate{80.0443, 32.1142}, // NGQ
    Coordinate{141.127, -5.6733}, // NGR
    Coordinate{129.914, 32.9169}, // NGS
    Coordinate{84, 28.6333}, // NGX
    Coordinate{35.7278, 15.3556}, // NHF
    Coordinate{-140.222, -8.7951}, // NHV
    Coordinate{-69.9389, 43.8922}, // NHZ
    Coordinate{-8.60013, 7.5}, // NIA
    Coordinate{-154.358, 63.0186}, // NIB
    Coordinate{121.595, -21.6737}, // NIF
    Coordinate{176.409, -1.3167}, // NIG
    Coordinate{2.17028, 13.4817}, // NIM
    Coordinate{17.6847, -2.7175}, // NIO
    Coordinate{-146.37, -16.1194}, // NIU
    Coordinate{-9.58333, 15.2333}, // NIX
    Coordinate{76.4833, 60.95}, // NJC
    Coordinate{44.4043, 31.9899}, // NJF
    Coordinate{-15.9697, 18.31}, // NKC
    Coordinate{118.862, 31.7422}, // NKG
    Coordinate{14.8167, -5.45}, // NKL
    Coordinate{136.924, 35.255}, // NKM
    Coordinate{146.45, -5.8333}, // NKN
    Coordinate{9.93333, 4.95}, // NKS
    Coordinate{42.06, 37.3639}, // NKT
    Coordinate{28.1969, -30.0217}, // NKU
    Coordinate{13.2833, -4.21667}, // NKY
    Coordinate{28.66, -13}, // NLA
    Coordinate{-99.5706, 27.4434}, // NLD
    Coordinate{-86.2259, 41.8407}, // NLE
    Coordinate{143.78, -9.57833}, // NLF
    Coordinate{-161.16, 56.0075}, // NLG
    Coordinate{100.757, 27.5438}, // NLH
    Coordinate{140.655, 53.1539}, // NLI
    Coordinate{167.938, -29.0425}, // NLK
    Coordinate{-123.927, 40.7192}, // NLN
    Coordinate{15.3272, -4.32667}, // NLO
    Coordinate{30.9118, -25.5022}, // NLP
    Coordinate{83.3803, 43.4331}, // NLT
    Coordinate{31.9208, 47.0581}, // NLV
    Coordinate{71.5567, 40.9844}, // NMA
    Coordinate{72.8433, 20.4344}, // NMB
    Coordinate{-76.8212, 24.5915}, // NMC
    Coordinate{-164.701, 60.4711}, // NME
    Coordinate{73.4747, 5.8222}, // NMF
    Coordinate{-78.9333, 8.45694}, // NMG
    Coordinate{-111.574, 57.0556}, // NML
    Coordinate{97.7369, 20.8856}, // NMS
    Coordinate{97.383, 23.083}, // NMT
    Coordinate{162.454, -10.85}, // NNB
    Coordinate{108.172, 22.6083}, // NNG
    Coordinate{16.925, -18.8111}, // NNI
    Coordinate{-157.02, 58.7328}, // NNK
    Coordinate{-154.839, 59.9803}, // NNL
    Coordinate{53.125, 67.64}, // NNM
    Coordinate{30.385, 50.4783}, // NNN
    Coordinate{-9.46778, 53.2305}, // NNR
    Coordinate{80.2418, 29.5925}, // NNS
    Coordinate{100.783, 18.8078}, // NNT
    Coordinate{-40.3339, -17.8231}, // NNU
    Coordinate{117.667, 4.13667}, // NNX
    Coordinate{112.615, 32.9808}, // NNY
    Coordinate{-85.6531, 9.96667}, // NOB
    Coordinate{-8.81861, 53.9103}, // NOC
    Coordinate{-110.977, 31.2261}, // NOG
    Coordinate{75.27, 63.1833}, // NOJ
    Coordinate{-52.3492, -14.6973}, // NOK
    Coordinate{142.117, -6.65}, // NOM
    Coordinate{174.428, -0.639667}, // NON
    Coordinate{35.0664, 42.0158}, // NOP
    Coordinate{-13.7464, 65.1319}, // NOR
    Coordinate{48.3092, -13.3181}, // NOS
    Coordinate{-122.556, 38.1436}, // NOT
    Coordinate{166.216, -22.0164}, // NOU
    Coordinate{15.7606, -12.8089}, // NOV
    Coordinate{86.8783, 53.81}, // NOZ
    Coordinate{176.87, -39.4683}, // NPE
    Coordinate{174.179, -39.0086}, // NPL
    Coordinate{111.473, 0.06362}, // NPO
    Coordinate{-55.4008, -7.1258}, // NPR
    Coordinate{-71.2817, 41.5325}, // NPT
    Coordinate{31.0825, -6.35533}, // NPY
    Coordinate{-89.8703, 35.3567}, // NQA
    Coordinate{-48.4919, -14.4364}, // NQL
    Coordinate{-68.1558, -38.9514}, // NQN
    Coordinate{-77.2627, 5.70951}, // NQU
    Coordinate{-4.99528, 50.4408}, // NQY
    Coordinate{146.512, -34.7022}, // NRA
    Coordinate{126.7, -3.85583}, // NRE
    Coordinate{117.08, -32.93}, // NRG
    Coordinate{-94.8619, 36.5775}, // NRI
    Coordinate{16.2317, 58.5861}, // NRK
    Coordinate{-7.26667, 15.2287}, // NRM
    Coordinate{6.14194, 51.6014}, // NRN
    Coordinate{-65.6433, 18.2453}, // NRR
    Coordinate{140.388, 35.7649}, // NRT
    Coordinate{51.4647, 36.6633}, // NSH
    Coordinate{11.5533, 3.7225}, // NSI
    Coordinate{87.3333, 69.31}, // NSK
    Coordinate{121.754, -32.2114}, // NSM
    Coordinate{173.221, -41.2983}, // NSN
    Coordinate{150.832, -32.0372}, // NSO
    Coordinate{99.9447, 8.53944}, // NST
    Coordinate{-64.3931, 18.4947}, // NSX
    Coordinate{9.21222, 59.5656}, // NTB
    Coordinate{-1.60778, 47.1569}, // NTE
    Coordinate{120.976, 32.0708}, // NTG
    Coordinate{141.07, -17.685}, // NTN
    Coordinate{136.962, 37.2933}, // NTQ
    Coordinate{-100.237, 25.8656}, // NTR
    Coordinate{-173.755, -15.9767}, // NTT
    Coordinate{108.388, 3.90871}, // NTX
    Coordinate{27.1716, -25.3355}, // NTY
    Coordinate{135.717, -14.2717}, // NUB
    Coordinate{28.333, 12.6667}, // NUD
    Coordinate{11.0781, 49.4986}, // NUE
    Coordinate{154.8, -3.333}, // NUG
    Coordinate{-151.006, 70.21}, // NUI
    Coordinate{-138.772, -19.285}, // NUK
    Coordinate{-158.074, 64.7294}, // NUL
    Coordinate{35.2961, 27.9286}, // NUM
    Coordinate{-162.439, 60.9058}, // NUP
    Coordinate{167.401, -16.0797}, // NUS
    Coordinate{151.383, -5.6333}, // NUT
    Coordinate{36.1508, -0.302778}, // NUU
    Coordinate{76.5217, 66.07}, // NUX
    Coordinate{-75.2939, 2.95}, // NVA
    Coordinate{-84.4547, 11.6667}, // NVG
    Coordinate{65.175, 40.1178}, // NVI
    Coordinate{-120.353, 39.8186}, // NVN
    Coordinate{31.2417, 58.4933}, // NVR
    Coordinate{3.11083, 47.0026}, // NVS
    Coordinate{-48.6514, -26.88}, // NVT
    Coordinate{43.7619, -12.2981}, // NWA
    Coordinate{-72.1893, 43.3881}, // NWH
    Coordinate{1.28278, 52.6758}, // NWI
    Coordinate{143.167, -8.5}, // NWT
    Coordinate{65.615, 62.11}, // NYA
    Coordinate{36.9667, -0.3714}, // NYE
    Coordinate{-2.32861, 7.36167}, // NYI
    Coordinate{37.0342, -0.069444}, // NYK
    Coordinate{72.7033, 65.48}, // NYM
    Coordinate{147.203, -31.5517}, // NYN
    Coordinate{16.9122, 58.7886}, // NYO
    Coordinate{118.347, 63.2972}, // NYR
    Coordinate{96.1999, 19.6191}, // NYT
    Coordinate{94.9303, 21.1789}, // NYU
    Coordinate{21.3579, -7.71653}, // NZA
    Coordinate{-74.9618, -14.8542}, // NZC
    Coordinate{-8.7026, 7.8132}, // NZE
    Coordinate{117.33, 49.5667}, // NZH
    Coordinate{122.768, 47.8658}, // NZL
    Coordinate{149.133, -33.3817}, // OAG
    Coordinate{-77.6122, 34.8292}, // OAJ
    Coordinate{-122.221, 37.7214}, // OAK
    Coordinate{-61.4508, -11.4956}, // OAL
    Coordinate{171.082, -44.97}, // OAM
    Coordinate{-86.5735, 15.5}, // OAN
    Coordinate{-121.762, 36.6814}, // OAR
    Coordinate{68.8386, 33.126}, // OAS
    Coordinate{-96.7267, 17}, // OAX
    Coordinate{43.2786, 11.9683}, // OBC
    Coordinate{-80.8511, 27.266}, // OBE
    Coordinate{11.2831, 48.0814}, // OBF
    Coordinate{-55.9467, 2.22347}, // OBI
    Coordinate{-5.4, 56.4636}, // OBN
    Coordinate{143.217, 42.7333}, // OBO
    Coordinate{-156.897, 66.9122}, // OBU
    Coordinate{141.324, -7.59053}, // OBX
    Coordinate{-80.2783, 25.3203}, // OCA
    Coordinate{-76.9867, -0.462778}, // OCC
    Coordinate{-75.1239, 38.3106}, // OCE
    Coordinate{-82.2242, 29.1725}, // OCF
    Coordinate{-76.9753, 18.4006}, // OCJ
    Coordinate{117.275, -22.5397}, // OCM
    Coordinate{-117.351, 33.2181}, // OCN
    Coordinate{9.3306, 0.9167}, // OCS
    Coordinate{-73.3583, 8.315}, // OCV
    Coordinate{22.4, 8.01667}, // ODA
    Coordinate{-4.84888, 37.842}, // ODB
    Coordinate{-120.8, 37.7564}, // ODC
    Coordinate{10.3308, 55.4767}, // ODE
    Coordinate{22.7833, 8.9}, // ODJ
    Coordinate{-79.3394, 39.5803}, // ODM
    Coordinate{115.063, 3.97611}, // ODN
    Coordinate{114.243, 57.8664}, // ODO
    Coordinate{30.6781, 46.4269}, // ODS
    Coordinate{-122.674, 48.2517}, // ODW
    Coordinate{101.993, 20.6806}, // ODY
    Coordinate{124.352, -9.19833}, // OEC
    Coordinate{36.0017, 52.935}, // OEL
    Coordinate{-55.4417, 3.34611}, // OEM
    Coordinate{-92.69, 45.3094}, // OEO
    Coordinate{18.99, 63.4078}, // OER
    Coordinate{-4.05, 9.6}, // OFI
    Coordinate{-18.6667, 66.0736}, // OFJ
    Coordinate{-97.435, 41.9856}, // OFK
    Coordinate{-77.4364, 37.7089}, // OFP
    Coordinate{-169.67, -14.1844}, // OFU
    Coordinate{-80.8594, 33.4569}, // OGB
    Coordinate{-112.013, 41.1956}, // OGD
    Coordinate{147.333, -6.4333}, // OGE
    Coordinate{-156.431, 20.8986}, // OGG
    Coordinate{-58.1058, 6.80722}, // OGL
    Coordinate{-77.9819, 9.12727}, // OGM
    Coordinate{122.98, 24.4675}, // OGN
    Coordinate{15.3797, 10.2883}, // OGR
    Coordinate{-75.4656, 44.6819}, // OGS
    Coordinate{38.0667, 40.9647}, // OGU
    Coordinate{5.40667, 31.9314}, // OGX
    Coordinate{44.6067, 43.205}, // OGZ
    Coordinate{175.387, -40.2067}, // OHA
    Coordinate{20.7422, 41.1799}, // OHD
    Coordinate{122.421, 52.9211}, // OHE
    Coordinate{142.88, 53.5178}, // OHH
    Coordinate{15.6959, -17.7972}, // OHI
    Coordinate{56.6953, 24.3328}, // OHS
    Coordinate{-75.5242, 42.5664}, // OIC
    Coordinate{139.36, 34.7819}, // OIM
    Coordinate{139.433, 42.0717}, // OIR
    Coordinate{131.737, 33.4794}, // OIT
    Coordinate{-98.6686, 35.5458}, // OJA
    Coordinate{-94.7375, 38.8475}, // OJC
    Coordinate{121.416, -0.863611}, // OJU
    Coordinate{127.646, 26.1958}, // OKA
    Coordinate{-97.6008, 35.3931}, // OKC
    Coordinate{141.381, 43.1175}, // OKD
    Coordinate{128.706, 27.4317}, // OKE
    Coordinate{15.9117, -19.15}, // OKF
    Coordinate{15.0733, -1.4483}, // OKG
    Coordinate{133.323, 36.1783}, // OKI
    Coordinate{133.855, 34.7569}, // OKJ
    Coordinate{-86.0589, 40.5281}, // OKK
    Coordinate{140.664, -5.10161}, // OKL
    Coordinate{-95.9486, 35.6681}, // OKM
    Coordinate{13.6728, -0.664167}, // OKN
    Coordinate{141.567, -5.46667}, // OKP
    Coordinate{143.404, -9.75333}, // OKR
    Coordinate{53.3883, 54.44}, // OKT
    Coordinate{17.0519, -18.8144}, // OKU
    Coordinate{141.033, -5.55636}, // OKV
    Coordinate{9.60389, 63.6992}, // OLA
    Coordinate{9.51763, 40.8987}, // OLB
    Coordinate{-68.6744, 44.9525}, // OLD
    Coordinate{-78.3714, 42.2411}, // OLE
    Coordinate{-105.575, 48.0944}, // OLF
    Coordinate{-153.269, 57.2183}, // OLH
    Coordinate{-23.8231, 64.9114}, // OLI
    Coordinate{166.558, -14.8817}, // OLJ
    Coordinate{-57.8828, -21.0458}, // OLK
    Coordinate{15.9142, -1.21861}, // OLL
    Coordinate{-122.902, 46.9694}, // OLM
    Coordinate{17.2108, 49.5878}, // OLO
    Coordinate{136.877, -30.485}, // OLP
    Coordinate{-110.848, 31.4178}, // OLS
    Coordinate{-97.3428, 41.4481}, // OLU
    Coordinate{-89.7869, 34.9789}, // OLV
    Coordinate{120.464, 60.3992}, // OLZ
    Coordinate{-95.8937, 41.302}, // OMA
    Coordinate{9.26278, -1.58333}, // OMB
    Coordinate{124.566, 11.0562}, // OMC
    Coordinate{16.4467, -28.5847}, // OMD
    Coordinate{-165.445, 64.5122}, // OME
    Coordinate{22.1889, -18.0303}, // OMG
    Coordinate{45.0676, 37.6668}, // OMH
    Coordinate{-119.518, 48.4642}, // OMK
    Coordinate{55.1822, 18.1361}, // OMM
    Coordinate{17.8458, 43.2828}, // OMO
    Coordinate{21.9024, 47.0253}, // OMR
    Coordinate{73.3083, 54.9667}, // OMS
    Coordinate{104.972, 13.7606}, // OMY
    Coordinate{-91.7083, 44.0772}, // ONA
    Coordinate{15.95, -17.8781}, // OND
    Coordinate{139.178, -16.6625}, // ONG
    Coordinate{-75.0644, 42.5247}, // ONH
    Coordinate{140.372, 40.1919}, // ONJ
    Coordinate{112.479, 68.5156}, // ONK
    Coordinate{-98.6872, 42.4694}, // ONL
    Coordinate{-117.013, 44.0194}, // ONO
    Coordinate{-124.058, 44.5803}, // ONP
    Coordinate{32.0886, 41.5064}, // ONQ
    Coordinate{115.113, -21.6684}, // ONS
    Coordinate{-117.601, 34.0561}, // ONT
    Coordinate{-178.741, -20.6598}, // ONU
    Coordinate{-79.8675, 9.35667}, // ONX
    Coordinate{-83.1614, 42.0992}, // ONZ
    Coordinate{135.445, -27.56}, // OOD
    Coordinate{-165.087, 60.5414}, // OOK
    Coordinate{153.513, -28.1663}, // OOL
    Coordinate{148.973, -36.3006}, // OOM
    Coordinate{175.526, -1.79639}, // OOT
    Coordinate{35.3047, 46.88}, // OOX
    Coordinate{-16.4667, 66.3108}, // OPA
    Coordinate{151.667, -4.9333}, // OPB
    Coordinate{-80.2783, 25.9069}, // OPF
    Coordinate{133.005, -12.3253}, // OPI
    Coordinate{-92.0994, 30.5269}, // OPL
    Coordinate{-8.67806, 41.2356}, // OPO
    Coordinate{142.94, -8.05117}, // OPU
    Coordinate{13.83, -18.07}, // OPW
    Coordinate{-75.5819, 39.99}, // OQN
    Coordinate{-71.4122, 41.5972}, // OQU
    Coordinate{-64.3292, -23.1528}, // ORA
    Coordinate{15.0381, 59.2236}, // ORB
    Coordinate{-71.3564, 4.78972}, // ORC
    Coordinate{-87.9047, 41.9786}, // ORD
    Coordinate{2.16417, 47.8975}, // ORE
    Coordinate{-76.2011, 36.8947}, // ORF
    Coordinate{-55.1901, 5.8115}, // ORG
    Coordinate{-71.8758, 42.2672}, // ORH
    Coordinate{-152.846, 57.8853}, // ORI
    Coordinate{-60.035, 4.72528}, // ORJ
    Coordinate{-8.49111, 51.8414}, // ORK
    Coordinate{-0.611389, 35.6272}, // ORN
    Coordinate{-87.1356, 15.1167}, // ORO
    Coordinate{25.3178, -21.2672}, // ORP
    Coordinate{-141.928, 62.9611}, // ORT
    Coordinate{-67.0761, -17.9625}, // ORU
    Coordinate{-161.022, 66.8175}, // ORV
    Coordinate{64.5861, 25.2747}, // ORW
    Coordinate{-55.8672, -1.76695}, // ORX
    Coordinate{2.37944, 48.7233}, // ORY
    Coordinate{-88.5667, 18.0667}, // ORZ
    Coordinate{-83.3942, 44.4517}, // OSC
    Coordinate{147.1, -7.833}, // OSE
    Coordinate{37.5072, 55.5117}, // OSF
    Coordinate{-88.5569, 43.9844}, // OSH
    Coordinate{18.8103, 45.4628}, // OSI
    Coordinate{11.0839, 60.1939}, // OSL
    Coordinate{43.1475, 36.3058}, // OSM
    Coordinate{140.557, -22.0817}, // OSO
    Coordinate{17.1075, 54.4789}, // OSP
    Coordinate{18.1108, 49.6961}, // OSR
    Coordinate{72.7931, 40.6089}, // OSS
    Coordinate{2.86667, 51.2}, // OST
    Coordinate{-83.0731, 40.0797}, // OSU
    Coordinate{58.5967, 51.0717}, // OSW
    Coordinate{11.6, 64.4667}, // OSY
    Coordinate{16.2642, 54.0422}, // OSZ
    Coordinate{14.7393, 13.4433}, // OTC
    Coordinate{-79.0333, 8.61667}, // OTD
    Coordinate{-124.263, 43.4172}, // OTH
    Coordinate{128.315, 2.04583}, // OTI
    Coordinate{16.65, -20.4306}, // OTJ
    Coordinate{-123.814, 45.4182}, // OTK
    Coordinate{-14.7167, 17.533}, // OTL
    Coordinate{-92.4481, 41.1067}, // OTM
    Coordinate{-87.4997, 38.8514}, // OTN
    Coordinate{26.085, 44.5711}, // OTP
    Coordinate{-82.9667, 8.6}, // OTR
    Coordinate{-122.662, 48.4989}, // OTS
    Coordinate{-74.7183, 7.01056}, // OTU
    Coordinate{155.7, -6.583}, // OTY
    Coordinate{-162.599, 66.8847}, // OTZ
    Coordinate{-1.51222, 12.3531}, // OUA
    Coordinate{-1.92389, 34.7872}, // OUD
    Coordinate{16.0378, 1.6158}, // OUE
    Coordinate{-2.417, 13.567}, // OUG
    Coordinate{25.3556, 64.9292}, // OUL
    Coordinate{19.2333, 13.2667}, // OUM
    Coordinate{-97.4722, 35.2456}, // OUN
    Coordinate{-49.9119, -22.9736}, // OUS
    Coordinate{16.717, 10.483}, // OUT
    Coordinate{-12.4686, 22.7567}, // OUZ
    Coordinate{82.6506, 55.0125}, // OVB
    Coordinate{-6.03472, 43.5636}, // OVD
    Coordinate{-121.622, 39.4878}, // OVE
    Coordinate{-71.1761, -30.5594}, // OVL
    Coordinate{-60.2278, -36.8889}, // OVR
    Coordinate{63.605, 61.325}, // OVS
    Coordinate{-87.1669, 37.7389}, // OWB
    Coordinate{-71.1731, 42.1906}, // OWD
    Coordinate{-95.2519, 38.5392}, // OWI
    Coordinate{-69.8665, 44.7155}, // OWK
    Coordinate{-96.1519, 36.1753}, // OWP
    Coordinate{-15.6536, 11.895}, // OXB
    Coordinate{-73.1353, 41.4786}, // OXC
    Coordinate{-84.7844, 39.5022}, // OXD
    Coordinate{-1.32, 51.8369}, // OXF
    Coordinate{-59.2187, -29.1059}, // OYA
    Coordinate{11.5814, 1.54311}, // OYE
    Coordinate{31.7644, 3.64889}, // OYG
    Coordinate{39.102, 3.465}, // OYL
    Coordinate{-60.3275, -38.3856}, // OYO
    Coordinate{-51.8056, 3.89333}, // OYP
    Coordinate{123.841, 8.17852}, // OZC
    Coordinate{-5.85722, 30.2667}, // OZG
    Coordinate{35.3158, 47.8669}, // OZH
    Coordinate{-92.6911, 37.9739}, // OZS
    Coordinate{-83.9822, 42.6294}, // OZW
    Coordinate{-6.90944, 30.9392}, // OZZ
    Coordinate{97.6744, 16.8931}, // PAA
    Coordinate{82.1111, 21.9883}, // PAB
    Coordinate{-79.5556, 8.97333}, // PAC
    Coordinate{8.61722, 51.6153}, // PAD
    Coordinate{-122.281, 47.9061}, // PAE
    Coordinate{31.5544, 2.20222}, // PAF
    Coordinate{123.458, 7.82722}, // PAG
    Coordinate{-88.7731, 37.0603}, // PAH
    Coordinate{70.0714, 33.9028}, // PAJ
    Coordinate{-159.603, 21.8969}, // PAK
    Coordinate{101.154, 6.7855}, // PAN
    Coordinate{-122.115, 37.4611}, // PAO
    Coordinate{-72.2925, 18.58}, // PAP
    Coordinate{-149.092, 61.595}, // PAQ
    Coordinate{85.0919, 25.5936}, // PAT
    Coordinate{94.4864, 21.4489}, // PAU
    Coordinate{-38.2542, -9.40222}, // PAV
    Coordinate{151.1, -10.58}, // PAW
    Coordinate{-72.85, 19.9333}, // PAX
    Coordinate{117.4, 5.9993}, // PAY
    Coordinate{-97.4608, 20.6021}, // PAZ
    Coordinate{-98.3714, 19.1581}, // PBC
    Coordinate{69.6572, 21.6486}, // PBD
    Coordinate{-74.4106, 6.45972}, // PBE
    Coordinate{-91.9356, 34.1744}, // PBF
    Coordinate{-73.4681, 44.6508}, // PBG
    Coordinate{89.4206, 27.4088}, // PBH
    Coordinate{-80.0956, 26.6832}, // PBI
    Coordinate{168.236, -16.4319}, // PBJ
    Coordinate{-68.0733, 10.4781}, // PBL
    Coordinate{-55.1878, 5.45283}, // PBM
    Coordinate{13.7657, -10.722}, // PBN
    Coordinate{117.746, -23.1714}, // PBO
    Coordinate{-85.3667, 9.85}, // PBP
    Coordinate{-61.1811, -11.6417}, // PBQ
    Coordinate{-88.585, 15.7308}, // PBR
    Coordinate{97.4264, 27.3197}, // PBU
    Coordinate{-157.711, 58.9064}, // PCA
    Coordinate{106.765, -6.3368}, // PCB
    Coordinate{-75.1576, 1.875}, // PCC
    Coordinate{-91.1236, 43.0192}, // PCD
    Coordinate{-69.7815, 4.44637}, // PCE
    Coordinate{-84.9403, 15.9542}, // PCH
    Coordinate{-74.5743, -8.3779}, // PCL
    Coordinate{173.958, -41.3447}, // PCN
    Coordinate{-109.536, 23.575}, // PCO
    Coordinate{7.4117, 1.6631}, // PCP
    Coordinate{-67.4931, 6.18444}, // PCR
    Coordinate{-41.5194, -7.06528}, // PCS
    Coordinate{-74.6589, 40.3992}, // PCT
    Coordinate{-82.8694, 41.5164}, // PCW
    Coordinate{-89.0197, 44.3333}, // PCZ
    Coordinate{-67.9061, 3.85361}, // PDA
    Coordinate{-154.13, 59.7972}, // PDB
    Coordinate{164.999, -21.3164}, // PDC
    Coordinate{32.8383, -26.8267}, // PDD
    Coordinate{100.281, -0.786667}, // PDG
    Coordinate{-84.3019, 33.8756}, // PDK
    Coordinate{-25.6978, 37.7419}, // PDL
    Coordinate{103.88, -3.28607}, // PDO
    Coordinate{-55.0942, -34.855}, // PDP
    Coordinate{-44.5, -5.2833}, // PDR
    Coordinate{-100.534, 28.6274}, // PDS
    Coordinate{-58.0622, -32.3633}, // PDU
    Coordinate{-122.598, 45.5886}, // PDX
    Coordinate{-62.2333, 9.97778}, // PDZ
    Coordinate{15.7386, 50.0133}, // PED
    Coordinate{56.0267, 57.9167}, // PEE
    Coordinate{12.5131, 43.0958}, // PEG
    Coordinate{-61.8575, -35.8447}, // PEH
    Coordinate{-75.7394, 4.8125}, // PEI
    Coordinate{116.584, 40.0733}, // PEK
    Coordinate{28.4972, -29.1167}, // PEL
    Coordinate{-69.2286, -12.6136}, // PEM
    Coordinate{100.277, 5.29694}, // PEN
    Coordinate{-77.0528, 42.6372}, // PEO
    Coordinate{-103.511, 31.3825}, // PEQ
    Coordinate{115.967, -31.9403}, // PER
    Coordinate{34.1567, 61.885}, // PES
    Coordinate{-52.3311, -31.7161}, // PET
    Coordinate{-86.7811, 15.2622}, // PEU
    Coordinate{18.241, 45.9909}, // PEV
    Coordinate{71.5147, 33.9939}, // PEW
    Coordinate{57.13, 65.1217}, // PEX
    Coordinate{45.0167, 53.1167}, // PEZ
    Coordinate{-52.3286, -28.2453}, // PFB
    Coordinate{-123.962, 45.1997}, // PFC
    Coordinate{-23.965, 65.5558}, // PFJ
    Coordinate{32.485, 34.7183}, // PFO
    Coordinate{47.8547, 39.6036}, // PFQ
    Coordinate{20.6, -4.33}, // PFR
    Coordinate{-111.448, 36.9261}, // PGA
    Coordinate{20.1808, 44.723}, // PGB
    Coordinate{-79.1458, 38.995}, // PGC
    Coordinate{-81.9908, 26.9189}, // PGD
    Coordinate{146.15, -7.1333}, // PGE
    Coordinate{2.87056, 42.7406}, // PGF
    Coordinate{79.4742, 29.0322}, // PGH
    Coordinate{20.8035, -7.35889}, // PGI
    Coordinate{106.139, -2.16194}, // PGK
    Coordinate{-88.5292, 30.4628}, // PGL
    Coordinate{-151.832, 59.3483}, // PGM
    Coordinate{-72.1186, 19.3214}, // PGN
    Coordinate{-107.055, 37.2881}, // PGO
    Coordinate{128.275, 0.894141}, // PGQ
    Coordinate{-90.5092, 36.0639}, // PGR
    Coordinate{-113.247, 35.5269}, // PGS
    Coordinate{52.7375, 27.3794}, // PGU
    Coordinate{0.815217, 45.1975}, // PGX
    Coordinate{-41.7303, -2.89389}, // PHB
    Coordinate{6.94944, 5.01528}, // PHC
    Coordinate{-81.42, 40.4703}, // PHD
    Coordinate{118.626, -20.3778}, // PHE
    Coordinate{-76.4931, 37.1319}, // PHF
    Coordinate{-45.0672, -2.4836}, // PHI
    Coordinate{-80.6933, 26.785}, // PHK
    Coordinate{-75.2411, 39.8719}, // PHL
    Coordinate{-82.5289, 42.9108}, // PHN
    Coordinate{-166.799, 68.3489}, // PHO
    Coordinate{139.923, -21.8117}, // PHQ
    Coordinate{178.05, -18.2563}, // PHR
    Coordinate{100.279, 16.7731}, // PHS
    Coordinate{-88.3828, 36.3383}, // PHT
    Coordinate{31.155, -23.9372}, // PHW
    Coordinate{-112.012, 33.4342}, // PHX
    Coordinate{101.195, 16.6758}, // PHY
    Coordinate{-89.6933, 40.6642}, // PIA
    Coordinate{-89.3369, 31.4672}, // PIB
    Coordinate{-72.1011, 21.8779}, // PIC
    Coordinate{-77.2933, 25.0792}, // PID
    Coordinate{-82.6909, 27.907}, // PIE
    Coordinate{120.478, 22.6953}, // PIF
    Coordinate{-62.3833, -37.6061}, // PIG
    Coordinate{-112.596, 42.9098}, // PIH
    Coordinate{-4.59444, 55.5094}, // PIK
    Coordinate{-58.318, -26.8815}, // PIL
    Coordinate{-84.8825, 32.8406}, // PIM
    Coordinate{-56.7711, -2.66944}, // PIN
    Coordinate{-76.2203, -13.745}, // PIO
    Coordinate{-157.572, 57.5803}, // PIP
    Coordinate{-100.286, 44.3828}, // PIR
    Coordinate{0.306667, 46.5875}, // PIS
    Coordinate{-80.2567, 40.496}, // PIT
    Coordinate{-80.6167, -5.2}, // PIU
    Coordinate{-97.1636, 55.5894}, // PIW
    Coordinate{-28.4414, 38.5544}, // PIX
    Coordinate{-163.011, 69.7322}, // PIZ
    Coordinate{23.0689, 67.2458}, // PJA
    Coordinate{-111.339, 34.2569}, // PJB
    Coordinate{-55.8297, -22.6414}, // PJC
    Coordinate{64.1325, 26.9547}, // PJG
    Coordinate{-83.3, 8.53333}, // PJM
    Coordinate{-161.778, 60.7028}, // PKA
    Coordinate{-81.4394, 39.345}, // PKB
    Coordinate{158.454, 53.1677}, // PKC
    Coordinate{148.239, -33.1314}, // PKE
    Coordinate{-90.4244, 45.955}, // PKF
    Coordinate{100.553, 4.24472}, // PKG
    Coordinate{23.149, 37.2988}, // PKH
    Coordinate{-90.7417, 15.9975}, // PKJ
    Coordinate{95.1023, 21.3445}, // PKK
    Coordinate{111.673, -2.705}, // PKN
    Coordinate{2.60917, 9.35722}, // PKO
    Coordinate{-138.811, -14.8093}, // PKP
    Coordinate{83.9819, 28.2008}, // PKR
    Coordinate{129.528, -14.2483}, // PKT
    Coordinate{101.444, 0.460833}, // PKU
    Coordinate{28.3983, 57.785}, // PKV
    Coordinate{27.8205, -22.0572}, // PKW
    Coordinate{116.411, 39.5119}, // PKX
    Coordinate{113.942, -2.225}, // PKY
    Coordinate{105.782, 15.1339}, // PKZ
    Coordinate{-85.4833, 9.86667}, // PLD
    Coordinate{142.976, -5.3721}, // PLE
    Coordinate{14.925, 9.37806}, // PLF
    Coordinate{-88.3617, 16.5369}, // PLJ
    Coordinate{-93.2289, 36.6258}, // PLK
    Coordinate{104.7, -2.90028}, // PLM
    Coordinate{-84.7967, 45.5708}, // PLN
    Coordinate{135.88, -34.6053}, // PLO
    Coordinate{-78.1417, 8.40667}, // PLP
    Coordinate{21.0939, 55.9733}, // PLQ
    Coordinate{-86.2492, 33.5589}, // PLR
    Coordinate{-72.2658, 21.7736}, // PLS
    Coordinate{-74.7861, 9.79852}, // PLT
    Coordinate{-43.9506, -19.8519}, // PLU
    Coordinate{34.3986, 49.5739}, // PLV
    Coordinate{119.91, -0.918611}, // PLW
    Coordinate{80.2344, 50.3514}, // PLX
    Coordinate{-86.3003, 41.365}, // PLY
    Coordinate{25.6103, -33.99}, // PLZ
    Coordinate{39.8114, -5.25722}, // PMA
    Coordinate{-97.2408, 48.9425}, // PMB
    Coordinate{-73.0939, -41.4386}, // PMC
    Coordinate{-118.084, 34.6294}, // PMD
    Coordinate{10.2953, 44.8222}, // PMF
    Coordinate{-55.7025, -22.5497}, // PMG
    Coordinate{-82.8472, 38.8406}, // PMH
    Coordinate{2.73881, 39.5517}, // PMI
    Coordinate{146.581, -18.7553}, // PMK
    Coordinate{-160.561, 56.006}, // PML
    Coordinate{149.467, -9.8167}, // PMN
    Coordinate{13.0994, 38.1819}, // PMO
    Coordinate{143.545, -6.3643}, // PMP
    Coordinate{-70.9788, -46.5384}, // PMQ
    Coordinate{175.617, -40.3206}, // PMR
    Coordinate{38.3, 34.55}, // PMS
    Coordinate{-63.9675, 10.9131}, // PMV
    Coordinate{-48.3578, -10.29}, // PMW
    Coordinate{-65.1028, -42.7592}, // PMY
    Coordinate{-83.4686, 8.95111}, // PMZ
    Coordinate{-1.647, 42.77}, // PNA
    Coordinate{-48.4003, -10.7169}, // PNB
    Coordinate{-97.0997, 36.7319}, // PNC
    Coordinate{-88.8081, 16.1022}, // PND
    Coordinate{-75.0106, 40.0819}, // PNE
    Coordinate{104.844, 11.5464}, // PNH
    Coordinate{158.209, 6.985}, // PNI
    Coordinate{109.404, -0.150556}, // PNK
    Coordinate{11.9686, 36.8164}, // PNL
    Coordinate{-93.6083, 45.56}, // PNM
    Coordinate{-67.5644, 45.2006}, // PNN
    Coordinate{148.309, -8.80444}, // PNP
    Coordinate{73.9197, 18.5822}, // PNQ
    Coordinate{11.8858, -4.81333}, // PNR
    Coordinate{-87.1866, 30.4734}, // PNS
    Coordinate{-72.5284, -51.6717}, // PNT
    Coordinate{-112.392, 37.8453}, // PNU
    Coordinate{-96.6736, 33.7142}, // PNX
    Coordinate{79.8128, 11.9658}, // PNY
    Coordinate{-40.5636, -9.3675}, // PNZ
    Coordinate{-51.1711, -29.9939}, // POA
    Coordinate{-117.782, 34.0916}, // POC
    Coordinate{8.75444, -0.711667}, // POG
    Coordinate{-65.7236, -19.5431}, // POI
    Coordinate{-46.4914, -18.6722}, // POJ
    Coordinate{40.5225, -12.9868}, // POL
    Coordinate{147.22, -9.4433}, // POM
    Coordinate{-89.4269, 16.3247}, // PON
    Coordinate{-70.57, 19.7578}, // POP
    Coordinate{21.7978, 61.4614}, // POR
    Coordinate{-61.3372, 10.5953}, // POS
    Coordinate{-76.5361, 18.1967}, // POT
    Coordinate{-73.8842, 41.6267}, // POU
    Coordinate{-81.2517, 41.2103}, // POV
    Coordinate{13.615, 45.4734}, // POW
    Coordinate{2.04072, 49.0966}, // POX
    Coordinate{16.8264, 52.4211}, // POZ
    Coordinate{-51.4189, -22.1783}, // PPB
    Coordinate{-150.644, 66.8142}, // PPC
    Coordinate{-113.306, 31.352}, // PPE
    Coordinate{-95.5061, 37.3308}, // PPF
    Coordinate{-170.711, -14.3317}, // PPG
    Coordinate{-61.5194, 4.57028}, // PPH
    Coordinate{137.995, -33.2389}, // PPI
    Coordinate{69.185, 54.7744}, // PPK
    Coordinate{86.5844, 27.5181}, // PPL
    Coordinate{-80.1111, 26.2472}, // PPM
    Coordinate{-76.6092, 2.45417}, // PPN
    Coordinate{148.552, -20.495}, // PPP
    Coordinate{174.989, -40.9047}, // PPQ
    Coordinate{100.37, 0.845478}, // PPR
    Coordinate{118.759, 9.74222}, // PPS
    Coordinate{-149.611, -17.5567}, // PPT
    Coordinate{-133.61, 56.3289}, // PPV
    Coordinate{149.6, -9.983}, // PPX
    Coordinate{-45.9194, -22.2889}, // PPY
    Coordinate{-67.4497, 6.21944}, // PPZ
    Coordinate{103.991, 10.1717}, // PQC
    Coordinate{-92.0156, 17.533}, // PQM
    Coordinate{152.863, -31.4358}, // PQQ
    Coordinate{-162.899, 61.9344}, // PQS
    Coordinate{-60.4803, -31.7947}, // PRA
    Coordinate{-120.627, 35.6728}, // PRB
    Coordinate{-112.42, 34.6544}, // PRC
    Coordinate{14.26, 50.1008}, // PRG
    Coordinate{100.165, 18.1317}, // PRH
    Coordinate{55.6916, -4.31924}, // PRI
    Coordinate{-8.57972, 37.1475}, // PRM
    Coordinate{21.0358, 42.5728}, // PRN
    Coordinate{-94.1597, 41.8281}, // PRO
    Coordinate{-60.4933, -26.7556}, // PRQ
    Coordinate{-61.0556, 5.81545}, // PRR
    Coordinate{161.425, -9.64167}, // PRS
    Coordinate{17.4047, 49.4258}, // PRV
    Coordinate{-90.2758, 45.5386}, // PRW
    Coordinate{-95.4508, 33.6367}, // PRX
    Coordinate{28.2167, -25.6536}, // PRY
    Coordinate{-120.904, 44.2869}, // PRZ
    Coordinate{10.3925, 43.6839}, // PSA
    Coordinate{-78.0872, 40.8833}, // PSB
    Coordinate{-119.119, 46.2646}, // PSC
    Coordinate{32.24, 31.2794}, // PSD
    Coordinate{-66.5631, 18.0083}, // PSE
    Coordinate{-73.2929, 42.4268}, // PSF
    Coordinate{-132.946, 56.8014}, // PSG
    Coordinate{63.3453, 25.2906}, // PSI
    Coordinate{120.658, -1.41667}, // PSJ
    Coordinate{-80.6786, 37.1372}, // PSK
    Coordinate{-70.8233, 43.0781}, // PSM
    Coordinate{-77.2914, 1.39611}, // PSO
    Coordinate{-116.507, 33.8297}, // PSP
    Coordinate{-75.2997, 39.8589}, // PSQ
    Coordinate{14.1872, 42.4372}, // PSR
    Coordinate{-55.9705, -27.3857}, // PSS
    Coordinate{-75.6572, 20.7342}, // PST
    Coordinate{112.937, 0.835556}, // PSU
    Coordinate{-96.2508, 28.7275}, // PSX
    Coordinate{-57.7776, -51.6857}, // PSY
    Coordinate{-57.8206, -18.9753}, // PSZ
    Coordinate{-154.319, 60.2044}, // PTA
    Coordinate{-134.648, 56.2469}, // PTD
    Coordinate{177.216, -17.7831}, // PTF
    Coordinate{29.4586, -23.8453}, // PTG
    Coordinate{-158.633, 56.9592}, // PTH
    Coordinate{141.471, -38.3181}, // PTJ
    Coordinate{-83.4194, 42.6656}, // PTK
    Coordinate{-70.1832, 7.56671}, // PTM
    Coordinate{-91.3389, 29.7094}, // PTN
    Coordinate{-52.6942, -26.2178}, // PTO
    Coordinate{-61.5258, 16.2642}, // PTP
    Coordinate{-52.245, -1.73917}, // PTQ
    Coordinate{-94.7311, 37.4494}, // PTS
    Coordinate{-98.7469, 37.7025}, // PTT
    Coordinate{-161.819, 59.0114}, // PTU
    Coordinate{-119.063, 36.0297}, // PTV
    Coordinate{-75.5567, 40.2394}, // PTW
    Coordinate{-76.0875, 1.85694}, // PTX
    Coordinate{-79.3836, 9.07139}, // PTY
    Coordinate{-104.496, 38.2892}, // PUB
    Coordinate{-65.9164, -47.7356}, // PUD
    Coordinate{-77.4167, 8.66667}, // PUE
    Coordinate{-0.418611, 43.38}, // PUF
    Coordinate{137.717, -32.5069}, // PUG
    Coordinate{-68.3519, 18.5667}, // PUJ
    Coordinate{-137.017, -18.2956}, // PUK
    Coordinate{121.524, -4.34359}, // PUM
    Coordinate{26.3333, -1.36667}, // PUN
    Coordinate{-1.14847, 11.1791}, // PUP
    Coordinate{-70.8544, -53.0025}, // PUQ
    Coordinate{-67.5483, -11.1075}, // PUR
    Coordinate{128.938, 35.1806}, // PUS
    Coordinate{77.7911, 14.1492}, // PUT
    Coordinate{-76.5008, 0.505278}, // PUU
    Coordinate{-117.109, 46.7439}, // PUW
    Coordinate{-72.9468, -41.3493}, // PUX
    Coordinate{13.9222, 44.8936}, // PUY
    Coordinate{-83.3877, 14.0462}, // PUZ
    Coordinate{-81.3583, 13.3569}, // PVA
    Coordinate{-90.4444, 42.6894}, // PVB
    Coordinate{-70.2214, 42.0719}, // PVC
    Coordinate{-71.4283, 41.7239}, // PVD
    Coordinate{-78.9533, 9.56528}, // PVE
    Coordinate{-120.753, 38.7242}, // PVF
    Coordinate{121.805, 31.1433}, // PVG
    Coordinate{-63.9028, -8.71361}, // PVH
    Coordinate{-52.4886, -23.0917}, // PVI
    Coordinate{20.772, 38.93}, // PVK
    Coordinate{-82.5664, 37.5617}, // PVL
    Coordinate{-80.4719, -1.04139}, // PVO
    Coordinate{-105.254, 20.68}, // PVR
    Coordinate{-173.243, 64.3783}, // PVS
    Coordinate{-111.723, 40.2192}, // PVU
    Coordinate{-101.716, 34.1689}, // PVW
    Coordinate{-97.6469, 35.5342}, // PWA
    Coordinate{-104.523, 48.7889}, // PWD
    Coordinate{170.597, 69.7833}, // PWE
    Coordinate{-87.9017, 42.1142}, // PWK
    Coordinate{109.417, -7.46167}, // PWL
    Coordinate{-70.3092, 43.6461}, // PWM
    Coordinate{-74.3464, 22.8297}, // PWN
    Coordinate{28.8896, -8.4685}, // PWO
    Coordinate{77.0739, 52.195}, // PWQ
    Coordinate{-122.765, 47.4903}, // PWT
    Coordinate{-109.807, 42.7956}, // PWY
    Coordinate{103.379, -4.0225}, // PXA
    Coordinate{-83.7672, 32.5106}, // PXE
    Coordinate{135.522, -29.7167}, // PXH
    Coordinate{-110.423, 35.7917}, // PXL
    Coordinate{-97.0889, 15.8767}, // PXM
    Coordinate{-16.3497, 33.0708}, // PXO
    Coordinate{103.498, 14.8683}, // PXR
    Coordinate{108.017, 14.0044}, // PXU
    Coordinate{-74.457, 5.93861}, // PYA
    Coordinate{82.552, 18.88}, // PYB
    Coordinate{-78.2347, 9.30972}, // PYC
    Coordinate{-158.033, -9.01444}, // PYE
    Coordinate{88.5878, 27.2281}, // PYG
    Coordinate{-67.6061, 5.62}, // PYH
    Coordinate{112.05, 66.4167}, // PYJ
    Coordinate{50.8228, 35.7761}, // PYK
    Coordinate{-70.7289, 41.9089}, // PYM
    Coordinate{-75.9, 0.08333}, // PYO
    Coordinate{-85.61, 34.09}, // PYP
    Coordinate{-121.616, 39.7106}, // PYS
    Coordinate{100.95, 12.8325}, // PYX
    Coordinate{98.4359, 19.3704}, // PYY
    Coordinate{-71.8917, 5.875}, // PZA
    Coordinate{30.3983, -29.6506}, // PZB
    Coordinate{69.4636, 31.3583}, // PZH
    Coordinate{101.799, 26.5423}, // PZI
    Coordinate{-62.7603, 8.28861}, // PZO
    Coordinate{-72.6372, -38.7669}, // PZS
    Coordinate{37.2341, 19.4336}, // PZU
    Coordinate{17.8286, 48.625}, // PZY
    Coordinate{55.9925, 25.3103}, // QAJ
    Coordinate{13.3103, 42.3806}, // QAQ
    Coordinate{1.33564, 36.2148}, // QAS
    Coordinate{-126.596, 52.3875}, // QBC
    Coordinate{20.6353, 44.9022}, // QBG
    Coordinate{10.9281, 45.4719}, // QBS
    Coordinate{-50.8322, -29.3706}, // QCN
    Coordinate{-51.6069, -21.4611}, // QDC
    Coordinate{-43.7981, -20.7386}, // QDF
    Coordinate{3.349, 34.6671}, // QDJ
    Coordinate{-46.9436, -23.1817}, // QDV
    Coordinate{19.0019, 49.805}, // QEO
    Coordinate{13.2939, 41.6481}, // QFR
    Coordinate{17.8136, 47.6244}, // QGY
    Coordinate{39.0059, 8.7163}, // QHR
    Coordinate{49.405, 27.0385}, // QJB
    Coordinate{28.3792, -14.4506}, // QKE
    Coordinate{-52.694, 5.17361}, // QKR
    Coordinate{23.0342, 69.0403}, // QKX
    Coordinate{-1.03361, 51.1872}, // QLA
    Coordinate{2.81447, 36.5039}, // QLD
    Coordinate{-49.8322, -26.1589}, // QMF
    Coordinate{7.25719, 35.8775}, // QMH
    Coordinate{49.2686, 32.0022}, // QMJ
    Coordinate{10.1431, 43.9856}, // QMM
    Coordinate{6.8647, 46.9575}, // QNC
    Coordinate{19.8339, 45.3857}, // QND
    Coordinate{4.7689, 50.4881}, // QNM
    Coordinate{-43.4647, -22.7467}, // QNV
    Coordinate{-73.9728, 40.7339}, // QNY
    Coordinate{7.20583, 5.42694}, // QOW
    Coordinate{11.8481, 45.3958}, // QPA
    Coordinate{19.7213, 52.5622}, // QPC
    Coordinate{-83.6784, 22.4214}, // QPD
    Coordinate{27.1333, -22.5636}, // QPH
    Coordinate{28.1511, -26.2425}, // QRA
    Coordinate{-70.7708, -34.1678}, // QRC
    Coordinate{40.8303, 41.1736}, // QRI
    Coordinate{148.225, -32.2144}, // QRM
    Coordinate{-100.188, 20.6222}, // QRO
    Coordinate{147.803, -31.7333}, // QRR
    Coordinate{12.8508, 42.4259}, // QRT
    Coordinate{5.81944, 5.59722}, // QRW
    Coordinate{2.10503, 41.5209}, // QSA
    Coordinate{-47.9033, -21.8764}, // QSC
    Coordinate{5.28861, 36.1767}, // QSF
    Coordinate{37.3256, -3.36333}, // QSI
    Coordinate{-81.9208, 22.7564}, // QSN
    Coordinate{14.9125, 40.62}, // QSR
    Coordinate{-58.5892, 6.4225}, // QSX
    Coordinate{-71.5217, -32.7941}, // QTR
    Coordinate{12.8231, 26.5672}, // QUB
    Coordinate{-0.759167, 50.8594}, // QUG
    Coordinate{8.09889, 4.87583}, // QUO
    Coordinate{6.69611, 12.1717}, // QUS
    Coordinate{139.871, 36.5145}, // QUT
    Coordinate{8.8869, 45.7406}, // QVA
    Coordinate{-48.9842, -23.0931}, // QVP
    Coordinate{-80.67, 35.2139}, // QWG
    Coordinate{20.0219, 44.2978}, // QWV
    Coordinate{5.36, 43.505}, // QXB
    Coordinate{20.415, 53.7731}, // QYO
    Coordinate{4.01667, 48.3217}, // QYR
    Coordinate{23.1714, 53.1031}, // QYY
    Coordinate{20.0892, 46.2486}, // QZD
    Coordinate{0.626956, 35.7517}, // QZN
    Coordinate{152.43, -4.21098}, // RAA
    Coordinate{152.379, -4.34028}, // RAB
    Coordinate{-87.8192, 42.7594}, // RAC
    Coordinate{41.1382, 30.9066}, // RAE
    Coordinate{-61.5042, -31.2844}, // RAF
    Coordinate{43.4906, 29.6264}, // RAH
    Coordinate{-23.4847, 14.9411}, // RAI
    Coordinate{70.7794, 22.3092}, // RAJ
    Coordinate{-8.04083, 31.6086}, // RAK
    Coordinate{-117.445, 33.9519}, // RAL
    Coordinate{134.898, -12.3567}, // RAM
    Coordinate{12.225, 44.3642}, // RAN
    Coordinate{-47.7767, -21.1364}, // RAO
    Coordinate{-103.057, 44.0453}, // RAP
    Coordinate{122.6, -4.8}, // RAQ
    Coordinate{-159.806, -21.2028}, // RAR
    Coordinate{49.6058, 37.3233}, // RAS
    Coordinate{77.33, 62.1583}, // RAT
    Coordinate{-70.2131, 6.31667}, // RAV
    Coordinate{155.57, -6.222}, // RAW
    Coordinate{148, -9.667}, // RAX
    Coordinate{73.7983, 33.8497}, // RAZ
    Coordinate{-59.5978, -4.40861}, // RBB
    Coordinate{142.776, -34.6424}, // RBC
    Coordinate{-96.8683, 32.6808}, // RBD
    Coordinate{106.984, 13.7294}, // RBE
    Coordinate{-116.856, 34.2639}, // RBF
    Coordinate{-123.356, 43.2389}, // RBG
    Coordinate{179.975, -16.5335}, // RBI
    Coordinate{141.039, 45.455}, // RBJ
    Coordinate{-117.129, 33.5742}, // RBK
    Coordinate{-122.252, 40.1508}, // RBL
    Coordinate{-59.7658, -18.3276}, // RBO
    Coordinate{149.833, -9.9833}, // RBP
    Coordinate{-67.4981, -14.4275}, // RBQ
    Coordinate{-67.8981, -9.86889}, // RBR
    Coordinate{148.61, -37.79}, // RBS
    Coordinate{37.9842, 2.345}, // RBT
    Coordinate{157.643, -8.16806}, // RBV
    Coordinate{-80.6406, 32.9211}, // RBW
    Coordinate{29.67, 6.83}, // RBX
    Coordinate{-155.47, 64.7272}, // RBY
    Coordinate{32.0919, -28.7408}, // RCB
    Coordinate{-72.9258, 11.5261}, // RCH
    Coordinate{167.835, -15.472}, // RCL
    Coordinate{143.115, -20.7019}, // RCM
    Coordinate{-99.3047, 39.3467}, // RCP
    Coordinate{-59.68, -29.2103}, // RCQ
    Coordinate{-86.1817, 41.0656}, // RCR
    Coordinate{0.5028, 51.3519}, // RCS
    Coordinate{-85.5167, 43.9}, // RCT
    Coordinate{-64.2693, -33.0936}, // RCU
    Coordinate{-91.0006, 45.4969}, // RCX
    Coordinate{-74.8361, 23.6844}, // RCY
    Coordinate{-79.7597, 34.8914}, // RCZ
    Coordinate{-162.899, 68.0322}, // RDB
    Coordinate{-49.9806, -8.03111}, // RDC
    Coordinate{-122.293, 40.5089}, // RDD
    Coordinate{-75.9653, 40.3786}, // RDG
    Coordinate{-95.2589, 41.0108}, // RDK
    Coordinate{-121.15, 44.2542}, // RDM
    Coordinate{103.007, 5.76528}, // RDN
    Coordinate{21.2136, 51.3892}, // RDO
    Coordinate{87.2414, 23.6253}, // RDP
    Coordinate{-68.9044, -37.3906}, // RDS
    Coordinate{-15.6572, 16.4375}, // RDT
    Coordinate{-78.7875, 35.8778}, // RDU
    Coordinate{-157.35, 61.7881}, // RDV
    Coordinate{2.48278, 44.4078}, // RDZ
    Coordinate{-136.443, -18.4659}, // REA
    Coordinate{-34.9228, -8.12639}, // REC
    Coordinate{-77.6269, 40.6775}, // RED
    Coordinate{15.6536, 38.0719}, // REG
    Coordinate{-65.2838, -43.2106}, // REL
    Coordinate{55.4567, 51.7958}, // REN
    Coordinate{-117.886, 42.5778}, // REO
    Coordinate{103.813, 13.4106}, // REP
    Coordinate{-91.6972, 14.5211}, // RER
    Coordinate{-59.0561, -27.45}, // RES
    Coordinate{12.1033, 67.5278}, // RET
    Coordinate{1.16722, 41.1475}, // REU
    Coordinate{-98.2286, 26.0089}, // REX
    Coordinate{-67.3917, -14.3233}, // REY
    Coordinate{-44.4817, -22.4786}, // REZ
    Coordinate{23.9281, 4.9896}, // RFA
    Coordinate{-89.0972, 42.1953}, // RFD
    Coordinate{-94.8517, 32.1417}, // RFI
    Coordinate{-15.9183, 66.4064}, // RFN
    Coordinate{-151.466, -16.723}, // RFP
    Coordinate{-83.8876, 10.3274}, // RFR
    Coordinate{-84.4086, 13.8897}, // RFS
    Coordinate{-67.7495, -53.7776}, // RGA
    Coordinate{88.7956, 25.2617}, // RGH
    Coordinate{-147.659, -14.9564}, // RGI
    Coordinate{85.8333, 51.9667}, // RGK
    Coordinate{-69.3128, -51.6089}, // RGL
    Coordinate{96.1331, 16.9072}, // RGN
    Coordinate{129.649, 41.4297}, // RGO
    Coordinate{-3.61361, 42.3575}, // RGS
    Coordinate{102.335, -0.352222}, // RGT
    Coordinate{-64.9483, -27.5106}, // RHD
    Coordinate{29.6333, -1.5}, // RHG
    Coordinate{-89.4664, 45.6308}, // RHI
    Coordinate{28.0861, 36.4053}, // RHO
    Coordinate{86.0614, 27.3939}, // RHP
    Coordinate{101.644, 39.2133}, // RHT
    Coordinate{-121.82, 37.3328}, // RHV
    Coordinate{-66.1167, -11.0167}, // RIB
    Coordinate{-77.3194, 37.505}, // RIC
    Coordinate{-84.8428, 39.7561}, // RID
    Coordinate{-91.7733, 45.42}, // RIE
    Coordinate{-80.1297, 8.38}, // RIH
    Coordinate{-77.16, -6.06806}, // RIJ
    Coordinate{-107.727, 39.5264}, // RIL
    Coordinate{157.143, -8.12639}, // RIN
    Coordinate{-117.41, 33.9889}, // RIR
    Coordinate{141.188, 45.2419}, // RIS
    Coordinate{-121.103, 38.4867}, // RIU
    Coordinate{-108.46, 43.0642}, // RIW
    Coordinate{23.9708, 56.9208}, // RIX
    Coordinate{49.375, 14.6625}, // RIY
    Coordinate{119.317, 35.3997}, // RIZ
    Coordinate{81.8183, 17.1103}, // RJA
    Coordinate{86.75, 26.517}, // RJB
    Coordinate{88.6164, 24.4369}, // RJH
    Coordinate{14.5036, 45.2169}, // RJK
    Coordinate{-2.32028, 42.4603}, // RJL
    Coordinate{130.776, -0.4255}, // RJM
    Coordinate{56.0486, 30.2975}, // RJN
    Coordinate{-145.467, -15.4856}, // RKA
    Coordinate{-69.0992, 44.06}, // RKD
    Coordinate{12.1314, 55.5856}, // RKE
    Coordinate{-81.0572, 34.9839}, // RKH
    Coordinate{99.7044, -2.1001}, // RKI
    Coordinate{-97.0436, 28.0861}, // RKP
    Coordinate{-94.6211, 35.0217}, // RKR
    Coordinate{-109.065, 41.5942}, // RKS
    Coordinate{55.9389, 25.6136}, // RKT
    Coordinate{-21.9406, 64.13}, // RKV
    Coordinate{-84.6897, 35.9222}, // RKW
    Coordinate{89.3069, 29.3517}, // RKZ
    Coordinate{-119.304, 46.3056}, // RLD
    Coordinate{12.2783, 53.9183}, // RLG
    Coordinate{107.739, 40.9264}, // RLK
    Coordinate{-65.1858, -32.3847}, // RLO
    Coordinate{7.36, 18.7889}, // RLT
    Coordinate{148.775, -26.545}, // RMA
    Coordinate{55.7589, 24.2556}, // RMB
    Coordinate{81.8183, 17.1103}, // RMD
    Coordinate{-75.4069, 43.2339}, // RME
    Coordinate{34.5836, 25.5569}, // RMF
    Coordinate{-85.1586, 34.3508}, // RMG
    Coordinate{12.6094, 44.0194}, // RMI
    Coordinate{140.673, -34.1967}, // RMK
    Coordinate{79.8862, 6.82199}, // RML
    Coordinate{141.264, -5.89646}, // RMN
    Coordinate{-150.141, 65.5078}, // RMP
    Coordinate{120.621, 24.1863}, // RMQ
    Coordinate{-152.805, -22.6387}, // RMT
    Coordinate{-1.12411, 37.8036}, // RMU
    Coordinate{-120.039, 37.5108}, // RMY
    Coordinate{161.979, -9.85472}, // RNA
    Coordinate{15.265, 56.2667}, // RNB
    Coordinate{-85.8439, 35.6986}, // RNC
    Coordinate{-92.5391, 45.1478}, // RNH
    Coordinate{-83.0606, 12.1714}, // RNI
    Coordinate{128.402, 27.0439}, // RNJ
    Coordinate{160.071, -11.5583}, // RNL
    Coordinate{57.0506, 21.3748}, // RNM
    Coordinate{14.7594, 55.0633}, // RNN
    Coordinate{-119.768, 39.4992}, // RNO
    Coordinate{166.887, 11.1572}, // RNP
    Coordinate{-1.72611, 48.0683}, // RNS
    Coordinate{-122.216, 47.4931}, // RNT
    Coordinate{116.679, 5.9565}, // RNU
    Coordinate{-90.7578, 33.7611}, // RNV
    Coordinate{-87.1825, 40.9478}, // RNZ
    Coordinate{-79.9756, 37.3256}, // ROA
    Coordinate{-10.3622, 6.23389}, // ROB
    Coordinate{-77.6725, 43.1189}, // ROC
    Coordinate{19.8999, -33.8124}, // ROD
    Coordinate{-122.546, 41.7303}, // ROF
    Coordinate{-94.1069, 36.3725}, // ROG
    Coordinate{103.65, 16.0667}, // ROI
    Coordinate{150.475, -23.3817}, // ROK
    Coordinate{-73.1057, 5.76441}, // RON
    Coordinate{-54.7242, -16.5853}, // ROO
    Coordinate{145.242, 14.1744}, // ROP
    Coordinate{134.544, 7.36722}, // ROR
    Coordinate{-60.7844, -32.9036}, // ROS
    Coordinate{176.317, -38.1092}, // ROT
    Coordinate{39.924, 47.4716}, // ROV
    Coordinate{-104.531, 33.3016}, // ROW
    Coordinate{-70.2594, -45.7056}, // ROY
    Coordinate{82.65, 28.7}, // RPA
    Coordinate{-97.6597, 39.8178}, // RPB
    Coordinate{-89.0783, 41.8931}, // RPJ
    Coordinate{134.747, -14.7228}, // RPM
    Coordinate{35.5719, 32.981}, // RPN
    Coordinate{81.7389, 21.1803}, // RPR
    Coordinate{-108.543, 46.475}, // RPX
    Coordinate{-109.067, 35.6519}, // RQE
    Coordinate{-98.0058, 35.4728}, // RQO
    Coordinate{63.3608, -19.7575}, // RRG
    Coordinate{84.816, 22.2565}, // RRK
    Coordinate{-89.7128, 45.1989}, // RRL
    Coordinate{-142.477, -16.045}, // RRR
    Coordinate{11.3423, 62.5784}, // RRS
    Coordinate{-95.3483, 48.9414}, // RRT
    Coordinate{-64.2758, -36.5883}, // RSA
    Coordinate{-76.1778, 24.8917}, // RSD
    Coordinate{151.255, -33.8706}, // RSE
    Coordinate{-161.319, 61.775}, // RSH
    Coordinate{-122.868, 48.6456}, // RSJ
    Coordinate{-92.5883, 32.5147}, // RSN
    Coordinate{-92.5, 43.9083}, // RST
    Coordinate{127.617, 34.8423}, // RSU
    Coordinate{-87.6497, 39.0161}, // RSV
    Coordinate{-81.7553, 26.5361}, // RSW
    Coordinate{177.071, -12.4825}, // RTA
    Coordinate{-86.5222, 16.3172}, // RTB
    Coordinate{73.3278, 17.0136}, // RTC
    Coordinate{120.478, -8.5962}, // RTG
    Coordinate{123.075, -10.767}, // RTI
    Coordinate{-95.1392, 43.3708}, // RTL
    Coordinate{4.43333, 51.95}, // RTM
    Coordinate{-104.502, 36.7417}, // RTN
    Coordinate{115.54, -32.0067}, // RTS
    Coordinate{30.9122, 3.04722}, // RUA
    Coordinate{55.1042, 36.4253}, // RUD
    Coordinate{29.3131, 0.11615}, // RUE
    Coordinate{-100.024, 48.3903}, // RUG
    Coordinate{46.6989, 24.9578}, // RUH
    Coordinate{-105.535, 33.4628}, // RUI
    Coordinate{82.1942, 28.6272}, // RUK
    Coordinate{73.5114, 0.336667}, // RUL
    Coordinate{86.5506, 27.3036}, // RUM
    Coordinate{55.5164, -20.89}, // RUN
    Coordinate{89.9067, 26.1411}, // RUP
    Coordinate{-151.368, -22.4335}, // RUR
    Coordinate{160.825, -9.8617}, // RUS
    Coordinate{-72.9497, 43.53}, // RUT
    Coordinate{144.25, -5.3}, // RUU
    Coordinate{-90.4453, 15.9919}, // RUV
    Coordinate{-89.1736, 14.8256}, // RUY
    Coordinate{47.8203, -22.8067}, // RVA
    Coordinate{-50.9561, -17.8347}, // RVD
    Coordinate{-71.9, 6.91667}, // RVE
    Coordinate{30.5883, 59.98}, // RVH
    Coordinate{11.1461, 64.8383}, // RVK
    Coordinate{25.8308, 66.5617}, // RVN
    Coordinate{-110.228, 38.9614}, // RVR
    Coordinate{-95.9846, 36.0396}, // RVS
    Coordinate{120.208, -33.7972}, // RVT
    Coordinate{-147.7, -23.8861}, // RVV
    Coordinate{-55.4761, -30.9744}, // RVY
    Coordinate{-77.8919, 35.8564}, // RWI
    Coordinate{-107.2, 41.8056}, // RWL
    Coordinate{26.1417, 50.6072}, // RWN
    Coordinate{-96.7042, 30.5156}, // RWV
    Coordinate{-111.805, 43.8339}, // RXE
    Coordinate{122.749, 11.5978}, // RXS
    Coordinate{38.925, 58.1017}, // RYB
    Coordinate{10.7856, 59.3789}, // RYG
    Coordinate{70.2797, 28.3839}, // RYK
    Coordinate{-72.2203, -51.605}, // RYO
    Coordinate{-88.7233, 43.1697}, // RYV
    Coordinate{-84.5986, 34.0131}, // RYY
    Coordinate{-68.5803, -50.0178}, // RZA
    Coordinate{22.0189, 50.11}, // RZE
    Coordinate{39.855, 54.555}, // RZN
    Coordinate{119.508, 10.8189}, // RZP
    Coordinate{50.6796, 36.905}, // RZR
    Coordinate{68.8739, 26.9594}, // RZS
    Coordinate{-106.824, 41.4447}, // SAA
    Coordinate{-63.2206, 17.6456}, // SAB
    Coordinate{-121.493, 38.5125}, // SAC
    Coordinate{-109.635, 32.8533}, // SAD
    Coordinate{-106.089, 35.6172}, // SAF
    Coordinate{74.3789, 19.6886}, // SAG
    Coordinate{44.2197, 15.4764}, // SAH
    Coordinate{-19.5728, 65.7317}, // SAK
    Coordinate{-89.0557, 13.4409}, // SAL
    Coordinate{150.789, -9.67133}, // SAM
    Coordinate{-117.19, 32.7336}, // SAN
    Coordinate{-87.9236, 15.4528}, // SAP
    Coordinate{-78.05, 25.05}, // SAQ
    Coordinate{-115.952, 33.2411}, // SAS
    Coordinate{-98.472, 29.527}, // SAT
    Coordinate{121.898, -10.4278}, // SAU
    Coordinate{-81.2022, 32.1275}, // SAV
    Coordinate{29.3092, 40.8983}, // SAW
    Coordinate{-8.43333, 4.66667}, // SAZ
    Coordinate{-119.84, 34.4261}, // SBA
    Coordinate{-71.1665, 7.80278}, // SBB
    Coordinate{141.75, -5.31667}, // SBC
    Coordinate{-117.235, 34.0953}, // SBD
    Coordinate{68.6365, 33.321}, // SBF
    Coordinate{95.3416, 5.8745}, // SBG
    Coordinate{-62.8439, 17.9044}, // SBH
    Coordinate{-13.3585, 12.5727}, // SBI
    Coordinate{-2.85667, 48.5375}, // SBK
    Coordinate{-87.8517, 43.7697}, // SBM
    Coordinate{-86.3172, 41.7012}, // SBN
    Coordinate{-111.838, 39.0292}, // SBO
    Coordinate{-120.642, 35.2369}, // SBP
    Coordinate{67.8431, 29.5744}, // SBQ
    Coordinate{142.625, -9.3783}, // SBR
    Coordinate{-106.866, 40.5161}, // SBS
    Coordinate{72.0522, 71.2192}, // SBT
    Coordinate{17.9389, -29.6894}, // SBU
    Coordinate{155.05, -5.58333}, // SBV
    Coordinate{111.985, 2.26139}, // SBW
    Coordinate{-111.871, 48.5406}, // SBX
    Coordinate{-75.5094, 38.34}, // SBY
    Coordinate{24.095, 45.789}, // SBZ
    Coordinate{-96.63, 41.6103}, // SCB
    Coordinate{-148.465, 70.1947}, // SCC
    Coordinate{-86.3056, 33.1719}, // SCD
    Coordinate{-77.8486, 40.8492}, // SCE
    Coordinate{-111.911, 33.6228}, // SCF
    Coordinate{-73.9289, 42.8525}, // SCH
    Coordinate{-72.2015, 7.80504}, // SCI
    Coordinate{-121.238, 37.8942}, // SCK
    Coordinate{-70.7856, -33.3928}, // SCL
    Coordinate{-165.571, 61.8453}, // SCM
    Coordinate{7.10944, 49.2144}, // SCN
    Coordinate{51.0919, 43.86}, // SCO
    Coordinate{-8.41514, 42.8963}, // SCQ
    Coordinate{12.84, 61.159}, // SCR
    Coordinate{-1.29611, 60.4328}, // SCS
    Coordinate{53.9056, 12.6306}, // SCT
    Coordinate{-75.8356, 19.97}, // SCU
    Coordinate{26.354, 47.6875}, // SCV
    Coordinate{50.8383, 61.6417}, // SCW
    Coordinate{-95.2014, 16.2125}, // SCX
    Coordinate{-89.6175, -0.910278}, // SCY
    Coordinate{165.798, -10.7197}, // SCZ
    Coordinate{-77.1194, 43.2347}, // SDC
    Coordinate{13.5767, -14.9333}, // SDD
    Coordinate{-64.31, -27.7656}, // SDE
    Coordinate{-85.7364, 38.1742}, // SDF
    Coordinate{47.0092, 35.2459}, // SDG
    Coordinate{-88.7833, 14.7772}, // SDH
    Coordinate{146.465, -5.6286}, // SDI
    Coordinate{140.917, 38.1397}, // SDJ
    Coordinate{118.059, 5.90083}, // SDK
    Coordinate{17.4428, 62.5281}, // SDL
    Coordinate{-116.98, 32.5722}, // SDM
    Coordinate{6.10583, 61.83}, // SDN
    Coordinate{20.9629, 44.6447}, // SDO
    Coordinate{-160.521, 55.3136}, // SDP
    Coordinate{-69.6689, 18.4297}, // SDQ
    Coordinate{-3.82, 43.4269}, // SDR
    Coordinate{138.414, 38.0611}, // SDS
    Coordinate{72.3528, 34.8133}, // SDT
    Coordinate{-43.1628, -22.9103}, // SDU
    Coordinate{-111.79, 34.85}, // SDX
    Coordinate{-104.192, 47.7069}, // SDY
    Coordinate{-122.309, 47.4489}, // SEA
    Coordinate{14.4725, 26.987}, // SEB
    Coordinate{-116.973, 32.8261}, // SEE
    Coordinate{-81.3425, 27.4564}, // SEF
    Coordinate{-76.8642, 40.8211}, // SEG
    Coordinate{153.735, 67.4797}, // SEK
    Coordinate{-86.9878, 32.3439}, // SEM
    Coordinate{0.693333, 51.5703}, // SEN
    Coordinate{-6.64422, 7.96}, // SEO
    Coordinate{102.14, 1.37127}, // SEQ
    Coordinate{-85.9083, 38.9247}, // SER
    Coordinate{34.8214, -2.45806}, // SEU
    Coordinate{38.5417, 48.8967}, // SEV
    Coordinate{25.5053, 29.3469}, // SEW
    Coordinate{-12.2072, 15.1794}, // SEY
    Coordinate{55.5219, -4.67434}, // SEZ
    Coordinate{10.6886, 34.7178}, // SFA
    Coordinate{-81.2375, 28.7778}, // SFB
    Coordinate{-61.265, 16.255}, // SFC
    Coordinate{-67.4439, 7.88306}, // SFD
    Coordinate{120.303, 16.5956}, // SFE
    Coordinate{-117.323, 47.6831}, // SFF
    Coordinate{-63.0472, 18.0999}, // SFG
    Coordinate{-114.816, 30.9303}, // SFH
    Coordinate{18.0936, 46.8603}, // SFK
    Coordinate{-24.48, 14.885}, // SFL
    Coordinate{-70.7081, 43.3939}, // SFM
    Coordinate{-60.8114, -31.7108}, // SFN
    Coordinate{-122.375, 37.6189}, // SFO
    Coordinate{120.271, 14.7945}, // SFS
    Coordinate{21.0769, 64.6247}, // SFT
    Coordinate{148.6, -9.583}, // SFU
    Coordinate{-71.4914, 41.9208}, // SFZ
    Coordinate{71.5, 37.5667}, // SGA
    Coordinate{73.4022, 61.3439}, // SGC
    Coordinate{9.79173, 54.9644}, // SGD
    Coordinate{8.08306, 50.7078}, // SGE
    Coordinate{-93.3886, 37.2456}, // SGF
    Coordinate{-83.8403, 39.8403}, // SGH
    Coordinate{149.833, -10.3833}, // SGJ
    Coordinate{144.323, -5.125}, // SGK
    Coordinate{120.894, 14.4913}, // SGL
    Coordinate{-112.939, 27.2969}, // SGM
    Coordinate{106.652, 10.8189}, // SGN
    Coordinate{148.595, -28.05}, // SGO
    Coordinate{120.14, -20.425}, // SGP
    Coordinate{-95.6567, 29.6222}, // SGR
    Coordinate{119.743, 5.04694}, // SGS
    Coordinate{-91.575, 34.5995}, // SGT
    Coordinate{-113.51, 37.0364}, // SGU
    Coordinate{-65.3503, -41.5917}, // SGV
    Coordinate{35.5811, -10.6808}, // SGX
    Coordinate{-136.323, 59.4553}, // SGY
    Coordinate{100.608, 7.18656}, // SGZ
    Coordinate{121.336, 31.1981}, // SHA
    Coordinate{144.96, 43.5775}, // SHB
    Coordinate{38.2708, 14.0794}, // SHC
    Coordinate{-78.8964, 38.2639}, // SHD
    Coordinate{123.484, 41.64}, // SHE
    Coordinate{85.8911, 44.2417}, // SHF
    Coordinate{-157.163, 66.8881}, // SHG
    Coordinate{-166.089, 66.2494}, // SHH
    Coordinate{125.145, 24.8267}, // SHI
    Coordinate{55.5172, 25.3286}, // SHJ
    Coordinate{28.7689, -29.7308}, // SHK
    Coordinate{91.9786, 25.7036}, // SHL
    Coordinate{135.364, 33.6622}, // SHM
    Coordinate{-123.147, 47.2336}, // SHN
    Coordinate{31.7169, -26.3586}, // SHO
    Coordinate{153.372, -27.9217}, // SHQ
    Coordinate{-106.98, 44.7692}, // SHR
    Coordinate{112.279, 30.3222}, // SHS
    Coordinate{145.393, -36.4289}, // SHT
    Coordinate{132.158, -11.1328}, // SHU
    Coordinate{-93.8256, 32.4467}, // SHV
    Coordinate{47.1211, 17.4669}, // SHW
    Coordinate{-159.569, 62.6922}, // SHX
    Coordinate{33.5, -3.61}, // SHY
    Coordinate{28.5536, -29.2667}, // SHZ
    Coordinate{13.35, -3.7464}, // SIB
    Coordinate{-79.078, 8.26246}, // SIC
    Coordinate{-22.95, 16.7376}, // SID
    Coordinate{84.98, 27.1594}, // SIF
    Coordinate{-66.0988, 18.4567}, // SIG
    Coordinate{80.936, 29.2631}, // SIH
    Coordinate{-18.9167, 66.1333}, // SIJ
    Coordinate{-89.5617, 36.8989}, // SIK
    Coordinate{144.545, -5.2784}, // SIM
    Coordinate{103.989, 1.35917}, // SIN
    Coordinate{145.083, -40.835}, // SIO
    Coordinate{33.9753, 45.0522}, // SIP
    Coordinate{104.579, -0.4788}, // SIQ
    Coordinate{7.32676, 46.2196}, // SIR
    Coordinate{23, -27.65}, // SIS
    Coordinate{-135.362, 57.0472}, // SIT
    Coordinate{-84.7769, 13.7167}, // SIU
    Coordinate{-87.4483, 39.1142}, // SIV
    Coordinate{98.9322, 2.667}, // SIW
    Coordinate{98.8905, 1.55446}, // SIX
    Coordinate{-122.468, 41.7814}, // SIY
    Coordinate{142.05, -3}, // SIZ
    Coordinate{-64.8167, -13.0667}, // SJB
    Coordinate{-121.929, 37.3628}, // SJC
    Coordinate{-109.721, 23.1517}, // SJD
    Coordinate{-72.6393, 2.57972}, // SJE
    Coordinate{121.047, 12.3614}, // SJI
    Coordinate{18.3314, 43.8247}, // SJJ
    Coordinate{-45.8711, -23.2289}, // SJK
    Coordinate{-66.9858, -0.14806}, // SJL
    Coordinate{-71.2333, 18.8333}, // SJM
    Coordinate{-109.379, 34.5186}, // SJN
    Coordinate{-84.2089, 9.99389}, // SJO
    Coordinate{-49.4047, -20.8161}, // SJP
    Coordinate{24.3056, -17.4767}, // SJQ
    Coordinate{-60.8, -17.8324}, // SJS
    Coordinate{-100.496, 31.355}, // SJT
    Coordinate{-66.0019, 18.4392}, // SJU
    Coordinate{-62.4704, -16.2667}, // SJV
    Coordinate{114.697, 38.2808}, // SJW
    Coordinate{-88.1308, 18.3556}, // SJX
    Coordinate{22.8319, 62.6936}, // SJY
    Coordinate{-28.1703, 38.6633}, // SJZ
    Coordinate{-62.7186, 17.3111}, // SKB
    Coordinate{141.8, -8.08333}, // SKC
    Coordinate{66.9839, 39.7006}, // SKD
    Coordinate{9.56694, 59.185}, // SKE
    Coordinate{22.9709, 40.5197}, // SKG
    Coordinate{81.6358, 28.5858}, // SKH
    Coordinate{6.95108, 36.8627}, // SKI
    Coordinate{-161.224, 64.3711}, // SKK
    Coordinate{15.0261, 68.5808}, // SKN
    Coordinate{5.20694, 12.9161}, // SKO
    Coordinate{21.6269, 41.9611}, // SKP
    Coordinate{28.3703, -30.0389}, // SKQ
    Coordinate{38.975, 5.69167}, // SKR
    Coordinate{9.29078, 55.2219}, // SKS
    Coordinate{74.3639, 32.5356}, // SKT
    Coordinate{24.4872, 38.9675}, // SKU
    Coordinate{34.0625, 28.6853}, // SKV
    Coordinate{-151.191, 61.9653}, // SKW
    Coordinate{45.215, 54.125}, // SKX
    Coordinate{68.7917, 27.7219}, // SKZ
    Coordinate{-65.4869, -24.8597}, // SLA
    Coordinate{-95.2407, 42.5972}, // SLB
    Coordinate{-111.978, 40.7883}, // SLC
    Coordinate{19.1342, 48.6381}, // SLD
    Coordinate{-94.49, 36.1919}, // SLG
    Coordinate{167.537, -13.8517}, // SLH
    Coordinate{26.3667, -12.1742}, // SLI
    Coordinate{117.762, -22.2553}, // SLJ
    Coordinate{-74.2061, 44.3853}, // SLK
    Coordinate{54.0922, 17.0389}, // SLL
    Coordinate{-5.50194, 40.9519}, // SLM
    Coordinate{-97.6522, 38.7906}, // SLN
    Coordinate{-88.9642, 38.6428}, // SLO
    Coordinate{-100.931, 22.2544}, // SLP
    Coordinate{-157.166, 61.7006}, // SLQ
    Coordinate{-95.6211, 33.1597}, // SLR
    Coordinate{27.1789, 44.055}, // SLS
    Coordinate{-106.049, 38.5383}, // SLT
    Coordinate{-60.9931, 14.02}, // SLU
    Coordinate{77.0679, 31.0826}, // SLV
    Coordinate{-100.929, 25.5494}, // SLW
    Coordinate{-71.2, 21.3333}, // SLX
    Coordinate{66.5866, 66.5901}, // SLY
    Coordinate{-44.2361, -2.58694}, // SLZ
    Coordinate{-25.1706, 36.9714}, // SMA
    Coordinate{-69.3336, -52.7367}, // SMB
    Coordinate{19.6599, 45.0365}, // SMC
    Coordinate{-85.1528, 41.1433}, // SMD
    Coordinate{-84.6156, 37.0536}, // SME
    Coordinate{-121.591, 38.6956}, // SMF
    Coordinate{-76.7681, -12.4}, // SMG
    Coordinate{146.75, -6.0833}, // SMH
    Coordinate{26.9117, 37.69}, // SMI
    Coordinate{146.8, -7.667}, // SMJ
    Coordinate{-162.11, 63.49}, // SMK
    Coordinate{-75.2793, 23.5901}, // SML
    Coordinate{118.596, 4.44972}, // SMM
    Coordinate{-113.881, 45.1239}, // SMN
    Coordinate{-118.451, 34.0158}, // SMO
    Coordinate{151.55, -4.35}, // SMP
    Coordinate{112.975, -2.49917}, // SMQ
    Coordinate{-74.2306, 11.1194}, // SMR
    Coordinate{49.8158, -17.0939}, // SMS
    Coordinate{9.88389, 46.5339}, // SMV
    Coordinate{-11.6847, 26.7317}, // SMW
    Coordinate{-120.457, 34.8989}, // SMX
    Coordinate{-54.4167, 4.35}, // SMZ
    Coordinate{-117.868, 33.6756}, // SNA
    Coordinate{130.654, -11.4228}, // SNB
    Coordinate{-80.9889, -2.205}, // SNC
    Coordinate{-24.2839, 16.5881}, // SNE
    Coordinate{-68.7332, 10.2834}, // SNF
    Coordinate{-60.9778, -16.3847}, // SNG
    Coordinate{151.991, -28.6203}, // SNH
    Coordinate{-9.0668, 5.03432}, // SNI
    Coordinate{-100.948, 32.6996}, // SNK
    Coordinate{-96.9428, 35.3572}, // SNL
    Coordinate{-65.6434, -14.9667}, // SNM
    Coordinate{-8.92472, 52.7019}, // SNN
    Coordinate{104.112, 17.1951}, // SNO
    Coordinate{-170.221, 57.1672}, // SNP
    Coordinate{-2.16111, 47.3106}, // SNR
    Coordinate{-121.606, 36.6628}, // SNS
    Coordinate{-79.9436, 22.4922}, // SNU
    Coordinate{-61.1447, 4.55472}, // SNV
    Coordinate{94.3, 18.4167}, // SNW
    Coordinate{53.4953, 35.5947}, // SNX
    Coordinate{-102.985, 41.0997}, // SNY
    Coordinate{17.1592, 46.6864}, // SOB
    Coordinate{110.757, -7.51611}, // SOC
    Coordinate{-47.4864, -23.4831}, // SOD
    Coordinate{14.1333, 2}, // SOE
    Coordinate{23.4083, 42.695}, // SOF
    Coordinate{7.13778, 61.1561}, // SOG
    Coordinate{20.9597, 69.7867}, // SOJ
    Coordinate{28.06, -29.8383}, // SOK
    Coordinate{-64.1511, 8.94528}, // SOM
    Coordinate{167.22, -15.505}, // SON
    Coordinate{17.0983, 61.2614}, // SOO
    Coordinate{-79.3911, 35.2372}, // SOP
    Coordinate{131.289, -0.894167}, // SOQ
    Coordinate{-1.35667, 50.9503}, // SOU
    Coordinate{-151.704, 59.4425}, // SOV
    Coordinate{-110.006, 34.2656}, // SOW
    Coordinate{-72.9703, 5.67639}, // SOX
    Coordinate{-81.9565, 34.9157}, // SPA
    Coordinate{-17.7556, 28.6264}, // SPC
    Coordinate{88.9086, 25.7592}, // SPD
    Coordinate{116.467, 4.733}, // SPE
    Coordinate{-103.783, 44.4803}, // SPF
    Coordinate{-82.6269, 27.765}, // SPG
    Coordinate{147.767, -9}, // SPH
    Coordinate{-89.6736, 39.8444}, // SPI
    Coordinate{22.5167, 36.9667}, // SPJ
    Coordinate{-111.668, 40.1419}, // SPK
    Coordinate{20.9596, 44.3499}, // SPL
    Coordinate{145.729, 15.1189}, // SPN
    Coordinate{17.7196, -14.6576}, // SPP
    Coordinate{-87.9711, 17.9139}, // SPR
    Coordinate{-98.4919, 33.9889}, // SPS
    Coordinate{115.55, 5.0833}, // SPT
    Coordinate{16.2981, 43.5389}, // SPU
    Coordinate{143.683, -3.9}, // SPV
    Coordinate{-95.2028, 43.1656}, // SPW
    Coordinate{30.8944, 30.1097}, // SPX
    Coordinate{-6.66082, 4.74672}, // SPY
    Coordinate{-94.1192, 36.1764}, // SPZ
    Coordinate{-120.076, 34.6069}, // SQA
    Coordinate{119.358, -31.2417}, // SQC
    Coordinate{117.961, 28.3799}, // SQD
    Coordinate{111.457, -0.041944}, // SQG
    Coordinate{104.035, 21.2147}, // SQH
    Coordinate{117.845, 26.4281}, // SQJ
    Coordinate{-122.249, 37.5119}, // SQL
    Coordinate{17.6967, 64.9556}, // SQO
    Coordinate{23.3947, 55.8939}, // SQQ
    Coordinate{121.283, -2.5377}, // SQR
    Coordinate{-89.0098, 17.1859}, // SQS
    Coordinate{150.683, -10.55}, // SQT
    Coordinate{-123.187, 48.0981}, // SQV
    Coordinate{9.17278, 56.55}, // SQW
    Coordinate{-53.5033, -26.7811}, // SQX
    Coordinate{-52.0328, -31.3833}, // SQY
    Coordinate{-54.5222, -27.9089}, // SRA
    Coordinate{-66.7872, -14.0729}, // SRB
    Coordinate{-91.7375, 35.2106}, // SRC
    Coordinate{-64.7, -13.2833}, // SRD
    Coordinate{-65.1491, -19.2383}, // SRE
    Coordinate{110.374, -6.97139}, // SRG
    Coordinate{-66.75, -14.8667}, // SRJ
    Coordinate{-112.099, 27.0931}, // SRL
    Coordinate{145.291, -42.1556}, // SRN
    Coordinate{5.33972, 59.7928}, // SRP
    Coordinate{33.6187, 1.72231}, // SRT
    Coordinate{-156.589, 61.7897}, // SRV
    Coordinate{-80.5203, 35.6458}, // SRW
    Coordinate{53.1936, 36.6358}, // SRY
    Coordinate{-63.1714, -17.8114}, // SRZ
    Coordinate{-38.3225, -12.9086}, // SSA
    Coordinate{-64.705, 17.7472}, // SSB
    Coordinate{-70.705, -32.7458}, // SSD
    Coordinate{75.9347, 17.6278}, // SSE
    Coordinate{-98.4711, 29.3369}, // SSF
    Coordinate{8.70861, 3.755}, // SSG
    Coordinate{34.3947, 27.9772}, // SSH
    Coordinate{-81.3914, 31.1519}, // SSI
    Coordinate{12.4689, 65.9567}, // SSJ
    Coordinate{-70.8718, 5.13056}, // SSL
    Coordinate{-84.3683, 46.4792}, // SSM
    Coordinate{-45.0453, -22.0917}, // SSO
    Coordinate{-79.1792, 48.9167}, // SSQ
    Coordinate{168.152, -15.4715}, // SSR
    Coordinate{147.95, -5.9}, // SSS
    Coordinate{-56.7214, -36.5422}, // SST
    Coordinate{14.2471, -6.26986}, // SSY
    Coordinate{8.35389, 55.99}, // STA
    Coordinate{-71.9428, 8.97417}, // STB
    Coordinate{-94.06, 45.5467}, // STC
    Coordinate{-72.035, 7.565}, // STD
    Coordinate{-89.5303, 44.545}, // STE
    Coordinate{-88.8486, 33.4331}, // STF
    Coordinate{-169.664, 56.5772}, // STG
    Coordinate{-113.56, 51.1342}, // STH
    Coordinate{-70.6047, 19.4061}, // STI
    Coordinate{-94.9097, 39.7719}, // STJ
    Coordinate{-54.7858, -2.42472}, // STM
    Coordinate{0.235, 51.885}, // STN
    Coordinate{-93.06, 44.9344}, // STP
    Coordinate{-78.5025, 41.4125}, // STQ
    Coordinate{9.22194, 48.69}, // STR
    Coordinate{-64.9733, 18.3372}, // STT
    Coordinate{72.7453, 21.1177}, // STV
    Coordinate{42.1133, 45.11}, // STW
    Coordinate{-64.8017, 17.7044}, // STX
    Coordinate{-57.9853, -31.4386}, // STY
    Coordinate{-50.5186, -10.4647}, // STZ
    Coordinate{-80.2211, 27.1817}, // SUA
    Coordinate{112.785, -7.38}, // SUB
    Coordinate{-96.6556, 35.7894}, // SUD
    Coordinate{-87.4217, 44.8436}, // SUE
    Coordinate{16.2422, 38.9053}, // SUF
    Coordinate{125.479, 9.75757}, // SUG
    Coordinate{41.1281, 42.8581}, // SUI
    Coordinate{22.8856, 47.7033}, // SUJ
    Coordinate{130.391, 67.7919}, // SUK
    Coordinate{69.1769, 28.6453}, // SUL
    Coordinate{-80.3614, 33.995}, // SUM
    Coordinate{-114.296, 43.5039}, // SUN
    Coordinate{-121.453, 43.8764}, // SUO
    Coordinate{113.89, -7.02425}, // SUP
    Coordinate{-78.1694, -2.483}, // SUQ
    Coordinate{-88.5419, 52.7086}, // SUR
    Coordinate{-90.6519, 38.6622}, // SUS
    Coordinate{31.6103, -7.94889}, // SUT
    Coordinate{178.559, -18.0433}, // SUV
    Coordinate{-92.0947, 46.6897}, // SUW
    Coordinate{-96.3844, 42.4025}, // SUX
    Coordinate{117.635, 62.185}, // SUY
    Coordinate{143.917, -7.1667}, // SUZ
    Coordinate{-170.492, 63.6864}, // SVA
    Coordinate{50.1747, -14.2786}, // SVB
    Coordinate{-108.156, 32.6367}, // SVC
    Coordinate{-61.1503, 13.1564}, // SVD
    Coordinate{-120.573, 40.3756}, // SVE
    Coordinate{2.46458, 8.01817}, // SVF
    Coordinate{5.63778, 58.8767}, // SVG
    Coordinate{-74.7667, 2.10028}, // SVI
    Coordinate{14.6692, 68.2433}, // SVJ
    Coordinate{-88.3692, 16.7284}, // SVK
    Coordinate{28.945, 61.9428}, // SVL
    Coordinate{142.333, -10.1867}, // SVM
    Coordinate{37.4146, 55.9726}, // SVO
    Coordinate{16.9474, -12.4049}, // SVP
    Coordinate{-5.89889, 37.4181}, // SVQ
    Coordinate{-149.054, 66.0169}, // SVS
    Coordinate{24.0767, -18.5206}, // SVT
    Coordinate{179.341, -16.8028}, // SVU
    Coordinate{-155.575, 61.0972}, // SVW
    Coordinate{60.8036, 56.7414}, // SVX
    Coordinate{-72.4397, 7.8408}, // SVZ
    Coordinate{116.415, 23.553}, // SWA
    Coordinate{142.74, -37.0717}, // SWC
    Coordinate{-149.419, 60.1269}, // SWD
    Coordinate{143.935, -6.7222}, // SWE
    Coordinate{-74.1047, 41.5042}, // SWF
    Coordinate{143.549, -35.3758}, // SWH
    Coordinate{-96.5861, 33.6242}, // SWI
    Coordinate{167.438, -16.495}, // SWJ
    Coordinate{-97.0856, 36.1578}, // SWO
    Coordinate{14.5667, -22.6583}, // SWP
    Coordinate{117.414, -8.48861}, // SWQ
    Coordinate{147.95, -5.88333}, // SWR
    Coordinate{-4.06778, 51.6053}, // SWS
    Coordinate{77.66, 60.71}, // SWT
    Coordinate{159.23, 61.9217}, // SWV
    Coordinate{-100.466, 32.4672}, // SWW
    Coordinate{21.8167, -18.3742}, // SWX
    Coordinate{100.699, 4.21639}, // SWY
    Coordinate{7.63444, 48.5419}, // SXB
    Coordinate{146.965, -38.0917}, // SXE
    Coordinate{13.5206, 52.3786}, // SXF
    Coordinate{23.2667, -16.1125}, // SXG
    Coordinate{54.5394, 25.9083}, // SXI
    Coordinate{90.2475, 42.9117}, // SXJ
    Coordinate{131.305, -7.98835}, // SXK
    Coordinate{-8.5992, 54.2802}, // SXL
    Coordinate{-63.1094, 18.0408}, // SXM
    Coordinate{26.1156, -20.5534}, // SXN
    Coordinate{-50.6883, -11.6319}, // SXO
    Coordinate{-164.848, 62.5206}, // SXP
    Coordinate{-151.038, 60.475}, // SXQ
    Coordinate{74.7742, 33.9871}, // SXR
    Coordinate{119.094, 5.0878}, // SXS
    Coordinate{37.7667, 6.83333}, // SXU
    Coordinate{78.0644, 11.7819}, // SXV
    Coordinate{-51.99, -6.64028}, // SXX
    Coordinate{-75.4161, 42.3025}, // SXY
    Coordinate{41.8392, 37.9781}, // SXZ
    Coordinate{-152.202, 58.3717}, // SYB
    Coordinate{151.177, -33.9461}, // SYD
    Coordinate{43.7288, 16.9667}, // SYE
    Coordinate{86.7103, 27.8092}, // SYH
    Coordinate{-86.4425, 35.5594}, // SYI
    Coordinate{55.6717, 29.5508}, // SYJ
    Coordinate{-22.7942, 65.0581}, // SYK
    Coordinate{100.959, 22.7933}, // SYM
    Coordinate{-93.0164, 44.4756}, // SYN
    Coordinate{139.787, 38.8122}, // SYO
    Coordinate{-80.9453, 8.08556}, // SYP
    Coordinate{-84.1394, 9.95722}, // SYQ
    Coordinate{-76.1064, 43.1111}, // SYR
    Coordinate{114.082, 71.9289}, // SYS
    Coordinate{4.02111, 46.4064}, // SYT
    Coordinate{142.823, -10.2083}, // SYU
    Coordinate{67.7172, 26.4731}, // SYW
    Coordinate{109.412, 18.3029}, // SYX
    Coordinate{-6.33111, 58.2156}, // SYY
    Coordinate{52.59, 29.5392}, // SYZ
    Coordinate{12.3718, -6.14106}, // SZA
    Coordinate{101.549, 3.13056}, // SZB
    Coordinate{40.9917, 11.7875}, // SZE
    Coordinate{36.5486, 41.2656}, // SZF
    Coordinate{13.0033, 47.7944}, // SZG
    Coordinate{-82.955, 21.6425}, // SZJ
    Coordinate{31.5886, -24.9609}, // SZK
    Coordinate{-119.062, 34.3469}, // SZP
    Coordinate{25.6553, 42.3767}, // SZR
    Coordinate{11.7834, 53.427}, // SZW
    Coordinate{113.811, 22.6394}, // SZX
    Coordinate{20.9378, 53.4819}, // SZY
    Coordinate{14.9022, 53.5847}, // SZZ
    Coordinate{-60.8322, 11.1497}, // TAB
    Coordinate{125.028, 11.2275}, // TAC
    Coordinate{-104.341, 37.2594}, // TAD
    Coordinate{128.659, 35.8942}, // TAE
    Coordinate{-0.533894, 35.5411}, // TAF
    Coordinate{123.775, 9.5667}, // TAG
    Coordinate{169.224, -19.455}, // TAH
    Coordinate{44.1392, 13.6858}, // TAI
    Coordinate{142.428, -3.199}, // TAJ
    Coordinate{134.016, 34.2142}, // TAK
    Coordinate{-152.109, 65.1744}, // TAL
    Coordinate{-97.8658, 22.2898}, // TAM
    Coordinate{-71.0164, 41.8742}, // TAN
    Coordinate{120.374, 36.2661}, // TAO
    Coordinate{-92.37, 14.7943}, // TAP
    Coordinate{17.4048, 40.5162}, // TAR
    Coordinate{69.2812, 41.2579}, // TAS
    Coordinate{20.2411, 49.0736}, // TAT
    Coordinate{-55.9258, -31.7503}, // TAW
    Coordinate{26.6869, 58.3075}, // TAY
    Coordinate{59.8331, 41.7647}, // TAZ
    Coordinate{80.4876, 9.30544}, // TBA
    Coordinate{109.334, 13.0494}, // TBB
    Coordinate{-111.383, 36.0928}, // TBC
    Coordinate{-77.6681, 2.77778}, // TBD
    Coordinate{174.776, -1.2238}, // TBF
    Coordinate{141.226, -5.27861}, // TBG
    Coordinate{122.078, 12.3099}, // TBH
    Coordinate{-75.4522, 24.3153}, // TBI
    Coordinate{8.87694, 36.98}, // TBJ
    Coordinate{-92.1408, 37.7417}, // TBN
    Coordinate{32.8306, -5.07611}, // TBO
    Coordinate{-80.3811, -3.5525}, // TBP
    Coordinate{-81.7372, 32.4828}, // TBR
    Coordinate{44.9547, 41.6692}, // TBS
    Coordinate{-69.9378, -4.25056}, // TBT
    Coordinate{-175.149, -21.2411}, // TBU
    Coordinate{41.4828, 52.8058}, // TBW
    Coordinate{22.4014, -26.0667}, // TBY
    Coordinate{46.235, 38.1339}, // TBZ
    Coordinate{134.183, -19.6344}, // TCA
    Coordinate{-77.3996, 26.7453}, // TCB
    Coordinate{-103.603, 35.1828}, // TCC
    Coordinate{-69.7497, -2.89574}, // TCD
    Coordinate{28.7144, 45.0628}, // TCE
    Coordinate{83.3408, 46.6725}, // TCG
    Coordinate{11.017, -2.85}, // TCH
    Coordinate{-87.6114, 33.2206}, // TCL
    Coordinate{-97.4197, 18.4969}, // TCN
    Coordinate{-78.7492, 1.81456}, // TCO
    Coordinate{34.7781, 29.5878}, // TCP
    Coordinate{-70.2758, -18.0533}, // TCQ
    Coordinate{78.0258, 8.72417}, // TCR
    Coordinate{-107.272, 33.2369}, // TCS
    Coordinate{-156.028, 62.9936}, // TCT
    Coordinate{145.603, -35.8108}, // TCW
    Coordinate{56.8925, 33.6675}, // TCX
    Coordinate{-121.442, 37.6889}, // TCY
    Coordinate{98.4851, 24.9401}, // TCZ
    Coordinate{-71.6584, 5.43049}, // TDA
    Coordinate{148.083, -9.2}, // TDB
    Coordinate{-64.9181, -14.8186}, // TDD
    Coordinate{-78.9847, 36.2847}, // TDF
    Coordinate{126.17, 9.06683}, // TDG
    Coordinate{42.9167, 11.7833}, // TDJ
    Coordinate{-59.2286, -37.2344}, // TDL
    Coordinate{-122.806, 46.4772}, // TDO
    Coordinate{142.869, -7.62278}, // TDS
    Coordinate{-101.826, 35.17}, // TDW
    Coordinate{102.319, 12.2746}, // TDX
    Coordinate{-83.4822, 41.5647}, // TDZ
    Coordinate{-87.4758, 15.7758}, // TEA
    Coordinate{-74.063, 40.849}, // TEB
    Coordinate{-50.6522, -24.3164}, // TEC
    Coordinate{8.70522, 57.0688}, // TED
    Coordinate{8.1225, 35.432}, // TEE
    Coordinate{122.229, -21.715}, // TEF
    Coordinate{-0.367, 11.8}, // TEG
    Coordinate{96.1346, 27.9417}, // TEI
    Coordinate{-146.691, 60.8725}, // TEK
    Coordinate{117.126, 5.62861}, // TEL
    Coordinate{147.512, -34.4217}, // TEM
    Coordinate{109.309, 27.8833}, // TEN
    Coordinate{146.067, -8.08333}, // TEO
    Coordinate{-27.0908, 38.7619}, // TER
    Coordinate{33.6403, -16.1081}, // TET
    Coordinate{167.65, -45.5331}, // TEU
    Coordinate{-1.2175, 40.4119}, // TEV
    Coordinate{-107.909, 37.9539}, // TEX
    Coordinate{92.7872, 26.7122}, // TEZ
    Coordinate{141.418, -5.11745}, // TFB
    Coordinate{-64.7253, -3.38028}, // TFF
    Coordinate{149.32, -9.076}, // TFI
    Coordinate{141.642, -5.126}, // TFM
    Coordinate{-16.3459, 28.488}, // TFN
    Coordinate{-16.5725, 28.0444}, // TFS
    Coordinate{104.445, 30.319}, // TFU
    Coordinate{111.202, 2.17778}, // TGC
    Coordinate{19.2519, 42.3594}, // TGD
    Coordinate{103.103, 5.3825}, // TGG
    Coordinate{168.551, -16.8911}, // TGH
    Coordinate{-76.005, -9.29}, // TGI
    Coordinate{167.804, -21.0958}, // TGJ
    Coordinate{153.5, -11.5}, // TGL
    Coordinate{24.4125, 46.4677}, // TGM
    Coordinate{146.47, -38.2072}, // TGN
    Coordinate{122.2, 43.5569}, // TGO
    Coordinate{89.9733, 61.59}, // TGP
    Coordinate{6.08953, 33.0736}, // TGR
    Coordinate{32.9653, -24.5206}, // TGS
    Coordinate{39.0717, -5.09209}, // TGT
    Coordinate{-87.2169, 14.0617}, // TGU
    Coordinate{26.7001, 43.3068}, // TGV
    Coordinate{-93.3529, 16.5636}, // TGZ
    Coordinate{-86.2467, 35.38}, // THA
    Coordinate{28.6158, -29.5228}, // THB
    Coordinate{-8.13667, 6.06639}, // THC
    Coordinate{105.468, 19.9017}, // THD
    Coordinate{-42.8244, -5.06056}, // THE
    Coordinate{150.579, -24.4939}, // THG
    Coordinate{174.708, -38.1811}, // THH
    Coordinate{-9.517, 18.45}, // THI
    Coordinate{104.8, 17.4}, // THK
    Coordinate{99.9348, 20.4829}, // THL
    Coordinate{-115.281, 47.5736}, // THM
    Coordinate{12.3364, 58.3242}, // THN
    Coordinate{-15.3356, 66.2183}, // THO
    Coordinate{105.861, 34.5583}, // THQ
    Coordinate{51.3136, 35.6892}, // THR
    Coordinate{99.8181, 17.2378}, // THS
    Coordinate{-10.817, 17.233}, // THT
    Coordinate{-76.8731, 39.9169}, // THV
    Coordinate{87.93, 65.8}, // THX
    Coordinate{5.26917, 14.8775}, // THZ
    Coordinate{19.7206, 41.4147}, // TIA
    Coordinate{-72.7333, 8.63139}, // TIB
    Coordinate{171.917, 7.1333}, // TIC
    Coordinate{1.46297, 35.341}, // TID
    Coordinate{35.415, 7.2025}, // TIE
    Coordinate{40.5444, 21.4833}, // TIF
    Coordinate{149.8, -2.6}, // TIG
    Coordinate{-148.234, -15.1197}, // TIH
    Coordinate{65.8642, 32.6053}, // TII
    Coordinate{-116.97, 32.5408}, // TIJ
    Coordinate{-113.624, 51.0575}, // TIL
    Coordinate{136.887, -4.5291}, // TIM
    Coordinate{-8.16667, 27.7}, // TIN
    Coordinate{13.1567, 32.6694}, // TIP
    Coordinate{145.619, 14.9992}, // TIQ
    Coordinate{79.5418, 13.6331}, // TIR
    Coordinate{171.225, -44.3029}, // TIU
    Coordinate{18.7233, 42.4047}, // TIV
    Coordinate{-122.578, 47.2681}, // TIW
    Coordinate{-80.7992, 28.5148}, // TIX
    Coordinate{-11.4333, 18.5667}, // TIY
    Coordinate{142.947, -5.845}, // TIZ
    Coordinate{-64.7013, -21.5557}, // TJA
    Coordinate{103.393, 1.05222}, // TJB
    Coordinate{115.437, -2.21636}, // TJG
    Coordinate{134.787, 35.5128}, // TJH
    Coordinate{-85.9383, 15.9269}, // TJI
    Coordinate{36.3736, 40.3117}, // TJK
    Coordinate{-51.6839, -20.7544}, // TJL
    Coordinate{65.3167, 57.1683}, // TJM
    Coordinate{-142.268, -15.8556}, // TJN
    Coordinate{107.755, -2.74556}, // TJQ
    Coordinate{117.374, 2.83639}, // TJS
    Coordinate{69.805, 37.9883}, // TJU
    Coordinate{-150.095, 62.32}, // TKA
    Coordinate{146.6, -7.667}, // TKB
    Coordinate{9.36028, 4.08917}, // TKC
    Coordinate{-1.77472, 4.89583}, // TKD
    Coordinate{-120.139, 39.32}, // TKF
    Coordinate{105.179, -5.2425}, // TKG
    Coordinate{100.3, 15.2783}, // TKH
    Coordinate{-133.327, 55.9372}, // TKI
    Coordinate{-142.954, 63.3294}, // TKJ
    Coordinate{151.843, 7.4619}, // TKK
    Coordinate{-89.6103, 17.2262}, // TKM
    Coordinate{128.881, 27.8364}, // TKN
    Coordinate{28.8847, -29.2394}, // TKO
    Coordinate{-145.249, -14.71}, // TKP
    Coordinate{29.6703, -4.885}, // TKQ
    Coordinate{88.4036, 26.0164}, // TKR
    Coordinate{134.606, 34.1328}, // TKS
    Coordinate{99.2533, 16.896}, // TKT
    Coordinate{22.2617, 60.5147}, // TKU
    Coordinate{-138.445, -17.3553}, // TKV
    Coordinate{142.15, -5.25}, // TKW
    Coordinate{-145.027, -14.4577}, // TKX
    Coordinate{175.892, -38.2367}, // TKZ
    Coordinate{-166.339, 65.2403}, // TLA
    Coordinate{72.6114, 33.9861}, // TLB
    Coordinate{-99.566, 19.3369}, // TLC
    Coordinate{29.1167, -22.1833}, // TLD
    Coordinate{-153.278, 63.3807}, // TLF
    Coordinate{-84.3503, 30.3967}, // TLH
    Coordinate{120.794, 1.12343}, // TLI
    Coordinate{-155.976, 62.8944}, // TLJ
    Coordinate{111.044, 59.8764}, // TLK
    Coordinate{24.7992, 59.4164}, // TLL
    Coordinate{-1.45753, 35.0134}, // TLM
    Coordinate{6.14611, 43.0972}, // TLN
    Coordinate{152.01, -4.98083}, // TLO
    Coordinate{141.017, -4.78333}, // TLP
    Coordinate{89.0972, 43.0303}, // TLQ
    Coordinate{-119.327, 36.1567}, // TLR
    Coordinate{1.36778, 43.635}, // TLS
    Coordinate{-160.969, 61.0969}, // TLT
    Coordinate{-75.5864, 9.51167}, // TLU
    Coordinate{34.8828, 32.0094}, // TLV
    Coordinate{-71.6017, -35.3783}, // TLX
    Coordinate{-83.4886, 31.4289}, // TMA
    Coordinate{-80.4328, 25.6478}, // TMB
    Coordinate{119.244, -9.40972}, // TMC
    Coordinate{-8.167, 16.233}, // TMD
    Coordinate{-71.7597, 6.45111}, // TME
    Coordinate{73.2097, 2.20972}, // TMF
    Coordinate{118.646, 5.39972}, // TMG
    Coordinate{87.1933, 27.315}, // TMI
    Coordinate{67.31, 37.2867}, // TMJ
    Coordinate{-0.8631, 9.5569}, // TML
    Coordinate{49.3925, -18.1158}, // TMM
    Coordinate{175.97, -2.48624}, // TMN
    Coordinate{-61.5285, 7.24945}, // TMO
    Coordinate{23.5878, 61.4153}, // TMP
    Coordinate{0.0411111, 14.7908}, // TMQ
    Coordinate{5.45083, 22.8111}, // TMR
    Coordinate{6.7122, 0.3781}, // TMS
    Coordinate{-56.3992, -1.48444}, // TMT
    Coordinate{-85.0167, 9.73333}, // TMU
    Coordinate{150.849, -31.0839}, // TMW
    Coordinate{0.276111, 29.2367}, // TMX
    Coordinate{175.549, -37.16}, // TMZ
    Coordinate{117.216, 36.8572}, // TNA
    Coordinate{-167.922, 65.5631}, // TNC
    Coordinate{-79.9972, 21.7883}, // TND
    Coordinate{130.992, 30.605}, // TNE
    Coordinate{-5.91689, 35.7269}, // TNG
    Coordinate{125.704, 42.2539}, // TNH
    Coordinate{80.8544, 24.5625}, // TNI
    Coordinate{104.532, 0.9225}, // TNJ
    Coordinate{-165.272, 60.5756}, // TNK
    Coordinate{25.7, 49.525}, // TNL
    Coordinate{120.204, 22.9503}, // TNN
    Coordinate{-85.8132, 10.3156}, // TNO
    Coordinate{-115.946, 34.1317}, // TNP
    Coordinate{-160.378, 4.6637}, // TNQ
    Coordinate{47.4761, -18.7969}, // TNR
    Coordinate{-128.203, 61.9569}, // TNS
    Coordinate{-80.8969, 25.8617}, // TNT
    Coordinate{-93.0217, 41.6744}, // TNU
    Coordinate{-159.354, 3.84472}, // TNV
    Coordinate{-77.822, -1.0628}, // TNW
    Coordinate{106.014, 13.5317}, // TNX
    Coordinate{-118.34, 33.8033}, // TOA
    Coordinate{23.8375, 32.0961}, // TOB
    Coordinate{-83.2964, 34.5928}, // TOC
    Coordinate{104.16, 2.81889}, // TOD
    Coordinate{8.11056, 33.9397}, // TOE
    Coordinate{85.2117, 56.3833}, // TOF
    Coordinate{-160.397, 59.0536}, // TOG
    Coordinate{166.638, -13.3275}, // TOH
    Coordinate{-86.0122, 31.8606}, // TOI
    Coordinate{155.062, -6.2011}, // TOK
    Coordinate{-83.8078, 41.5868}, // TOL
    Coordinate{-3.0075, 16.7306}, // TOM
    Coordinate{155.6, -6.35}, // TON
    Coordinate{-82.9589, 8.8167}, // TOO
    Coordinate{-95.6225, 39.0686}, // TOP
    Coordinate{-70.0658, -22.1425}, // TOQ
    Coordinate{-104.153, 42.0644}, // TOR
    Coordinate{18.9178, 69.6814}, // TOS
    Coordinate{-56.3275, 5.86583}, // TOT
    Coordinate{165.259, -20.7903}, // TOU
    Coordinate{-64.6097, 18.4614}, // TOV
    Coordinate{137.188, 36.6483}, // TOY
    Coordinate{-7.67361, 8.28972}, // TOZ
    Coordinate{-82.5333, 27.9756}, // TPA
    Coordinate{-76.3375, -0.122778}, // TPC
    Coordinate{121.224, 25.0764}, // TPE
    Coordinate{-82.4492, 27.9149}, // TPF
    Coordinate{100.715, 4.86639}, // TPG
    Coordinate{-117.087, 38.0603}, // TPH
    Coordinate{146.989, -8.367}, // TPI
    Coordinate{87.6972, 27.3515}, // TPJ
    Coordinate{-97.4078, 31.1519}, // TPL
    Coordinate{-75.5264, -0.78333}, // TPN
    Coordinate{-104.843, 21.4195}, // TPQ
    Coordinate{117.869, -22.7461}, // TPR
    Coordinate{12.4933, 37.9119}, // TPS
    Coordinate{81.15, 28.5169}, // TPU
    Coordinate{-95.0044, 35.9303}, // TQH
    Coordinate{69.5324, 36.7707}, // TQN
    Coordinate{140.888, -21.835}, // TQP
    Coordinate{124.675, 24.6539}, // TRA
    Coordinate{-76.7483, 8.06667}, // TRB
    Coordinate{-103.411, 25.5681}, // TRC
    Coordinate{10.9242, 63.4575}, // TRD
    Coordinate{-6.88, 56.5}, // TRE
    Coordinate{10.2586, 59.1867}, // TRF
    Coordinate{176.196, -37.6719}, // TRG
    Coordinate{-117.327, 35.8125}, // TRH
    Coordinate{-82.4075, 36.4753}, // TRI
    Coordinate{141.043, -5.61428}, // TRJ
    Coordinate{117.566, 3.32667}, // TRK
    Coordinate{-96.2674, 32.7092}, // TRL
    Coordinate{-116.16, 33.6267}, // TRM
    Coordinate{7.64959, 45.2018}, // TRN
    Coordinate{152.514, -31.8886}, // TRO
    Coordinate{-70.7828, -8.1575}, // TRQ
    Coordinate{13.4856, 45.8212}, // TRS
    Coordinate{-79.1086, -8.08139}, // TRU
    Coordinate{76.92, 8.48222}, // TRV
    Coordinate{173.147, 1.3817}, // TRW
    Coordinate{-93.5906, 40.0836}, // TRX
    Coordinate{34.1667, 0.68}, // TRY
    Coordinate{78.7147, 10.7658}, // TRZ
    Coordinate{17.7256, -19.2619}, // TSB
    Coordinate{-77.5031, -2.38167}, // TSC
    Coordinate{71.4669, 51.0222}, // TSE
    Coordinate{12.1978, 45.6508}, // TSF
    Coordinate{-143.336, 63.3744}, // TSG
    Coordinate{20.7947, -6.43833}, // TSH
    Coordinate{146.35, -6.85}, // TSI
    Coordinate{129.331, 34.285}, // TSJ
    Coordinate{150.417, -2.5833}, // TSK
    Coordinate{-98.8067, 22.0378}, // TSL
    Coordinate{-105.673, 36.4581}, // TSM
    Coordinate{117.346, 39.1244}, // TSN
    Coordinate{-118.439, 35.135}, // TSP
    Coordinate{21.3381, 45.81}, // TSR
    Coordinate{99.6166, 7.50874}, // TST
    Coordinate{175.065, -1.47439}, // TSU
    Coordinate{146.765, -19.2533}, // TSV
    Coordinate{146.033, -6.9671}, // TSW
    Coordinate{108.246, -7.3466}, // TSY
    Coordinate{-11.1614, 28.4439}, // TTA
    Coordinate{9.68321, 39.9167}, // TTB
    Coordinate{-70.3767, -25.5639}, // TTC
    Coordinate{-122.401, 45.5494}, // TTD
    Coordinate{127.381, 0.831411}, // TTE
    Coordinate{-63.8183, -22.6283}, // TTG
    Coordinate{134.163, 35.53}, // TTJ
    Coordinate{-72.1006, 5.72639}, // TTM
    Coordinate{-74.8133, 40.2767}, // TTN
    Coordinate{-97.7428, 45.815}, // TTO
    Coordinate{-83.5167, 10.5667}, // TTQ
    Coordinate{119.821, -3.04256}, // TTR
    Coordinate{47.6167, -16.75}, // TTS
    Coordinate{121.093, 22.7547}, // TTT
    Coordinate{-5.31997, 35.5944}, // TTU
    Coordinate{-77.7081, 0.8094}, // TUA
    Coordinate{-149.529, -23.371}, // TUB
    Coordinate{-65.1047, -26.8408}, // TUC
    Coordinate{-13.658, 13.7327}, // TUD
    Coordinate{0.723056, 47.4319}, // TUF
    Coordinate{121.731, 17.6383}, // TUG
    Coordinate{38.7311, 31.6928}, // TUI
    Coordinate{35.5194, 6.25972}, // TUJ
    Coordinate{63.0303, 25.9864}, // TUK
    Coordinate{-95.8881, 36.1983}, // TUL
    Coordinate{148.241, -35.2628}, // TUM
    Coordinate{10.2272, 36.8511}, // TUN
    Coordinate{176.084, -38.7397}, // TUO
    Coordinate{-88.77, 34.2681}, // TUP
    Coordinate{-3.07709, 13.0592}, // TUQ
    Coordinate{-49.7197, -3.79361}, // TUR
    Coordinate{36.6189, 28.3656}, // TUU
    Coordinate{-62.0942, 9.08889}, // TUV
    Coordinate{-120.931, 55.0272}, // TUX
    Coordinate{44.9167, -17.8503}, // TVA
    Coordinate{-85.5822, 44.7417}, // TVC
    Coordinate{-96.185, 48.0656}, // TVF
    Coordinate{-83.8811, 30.9017}, // TVI
    Coordinate{-92.9011, 40.6844}, // TVK
    Coordinate{-119.995, 38.8939}, // TVL
    Coordinate{117.993, 39.7253}, // TVS
    Coordinate{-179.877, -16.6906}, // TVU
    Coordinate{98.2036, 14.1}, // TVY
    Coordinate{-160.275, 59.0744}, // TWA
    Coordinate{78.99, 39.8806}, // TWC
    Coordinate{-122.811, 48.0539}, // TWD
    Coordinate{-114.488, 42.4818}, // TWF
    Coordinate{143.75, -17.3633}, // TWP
    Coordinate{118.122, 4.31333}, // TWU
    Coordinate{146.117, -7.45}, // TWY
    Coordinate{170.118, -44.2369}, // TWZ
    Coordinate{96.8494, 4.72083}, // TXE
    Coordinate{-93.9911, 33.4536}, // TXK
    Coordinate{13.2878, 52.5597}, // TXL
    Coordinate{118.253, 29.73}, // TXN
    Coordinate{-7.36273, 4.43781}, // TXU
    Coordinate{142.058, -29.4517}, // TYB
    Coordinate{124.778, 55.2833}, // TYD
    Coordinate{-151.138, 61.0767}, // TYE
    Coordinate{12.9936, 60.1547}, // TYF
    Coordinate{-81.2539, -4.57639}, // TYL
    Coordinate{-76.4403, 24.1625}, // TYM
    Coordinate{112.628, 37.7469}, // TYN
    Coordinate{-86.2514, 40.0306}, // TYQ
    Coordinate{-95.4028, 32.3539}, // TYR
    Coordinate{-83.9939, 35.8111}, // TYS
    Coordinate{-54.3472, -33.195}, // TYT
    Coordinate{-110.115, 34.4528}, // TYZ
    Coordinate{-88.1917, 17.5164}, // TZA
    Coordinate{-83.4453, 43.4586}, // TZC
    Coordinate{18.7247, 44.4586}, // TZL
    Coordinate{-88.1722, 21.1553}, // TZM
    Coordinate{-77.5898, 24.1587}, // TZN
    Coordinate{-83.1369, 39.9011}, // TZR
    Coordinate{39.7853, 40.9951}, // TZX
    Coordinate{-114.798, 32.4453}, // UAC
    Coordinate{144.65, -6.2333}, // UAE
    Coordinate{-139.555, -8.93611}, // UAH
    Coordinate{125.287, -9.30397}, // UAI
    Coordinate{22.2311, -10.7158}, // UAL
    Coordinate{-122.77, 45.2472}, // UAO
    Coordinate{-140.078, -9.3522}, // UAP
    Coordinate{-68.4211, -31.5714}, // UAQ
    Coordinate{-1.97833, 32.5144}, // UAR
    Coordinate{37.5342, 0.53056}, // UAS
    Coordinate{-89.6347, 17.3931}, // UAX
    Coordinate{-47.9661, -19.7647}, // UBA
    Coordinate{142.197, -9.95167}, // UBB
    Coordinate{155.685, -6.73333}, // UBI
    Coordinate{131.279, 33.93}, // UBJ
    Coordinate{106.819, 47.6434}, // UBN
    Coordinate{104.87, 15.2513}, // UBP
    Coordinate{-88.3803, 33.4653}, // UBS
    Coordinate{-45.0761, -23.4414}, // UBT
    Coordinate{113.108, 41.1239}, // UCB
    Coordinate{-116.038, 36.9458}, // UCC
    Coordinate{25.4833, 50.6833}, // UCK
    Coordinate{-10.0575, 5.90389}, // UCN
    Coordinate{-80.4133, 41.0253}, // UCP
    Coordinate{53.8033, 63.5667}, // UCT
    Coordinate{-88.9858, 36.3797}, // UCY
    Coordinate{-76.35, -8.467}, // UCZ
    Coordinate{-116.275, 33.7483}, // UDD
    Coordinate{-79.8903, 34.449}, // UDG
    Coordinate{-48.2253, -18.8836}, // UDI
    Coordinate{22.2633, 48.6342}, // UDJ
    Coordinate{121.415, 1.10472}, // UDL
    Coordinate{13.0384, 45.977}, // UDN
    Coordinate{73.8961, 24.6178}, // UDR
    Coordinate{145.53, -42.0756}, // UEE
    Coordinate{36.8667, -17.8764}, // UEL
    Coordinate{126.714, 26.3636}, // UEO
    Coordinate{-88.2369, 43.0411}, // UES
    Coordinate{66.9387, 30.2521}, // UET
    Coordinate{55.8742, 54.5575}, // UFA
    Coordinate{103.484, 48.8542}, // UGA
    Coordinate{-157.74, 57.4253}, // UGB
    Coordinate{60.6417, 41.5842}, // UGC
    Coordinate{-87.8678, 42.4222}, // UGN
    Coordinate{15.0277, -7.60278}, // UGO
    Coordinate{-157.396, 57.5233}, // UGS
    Coordinate{17.4397, 49.0294}, // UHE
    Coordinate{-76.6411, 5.69083}, // UIB
    Coordinate{109.042, 13.955}, // UIH
    Coordinate{-86.8803, 16.0917}, // UII
    Coordinate{102.557, 58.1333}, // UIK
    Coordinate{-124.563, 47.9367}, // UIL
    Coordinate{-91.1947, 39.9428}, // UIN
    Coordinate{-78.3656, -0.135556}, // UIO
    Coordinate{-4.16778, 47.975}, // UIP
    Coordinate{150.514, -31.4986}, // UIR
    Coordinate{169.637, 5.90917}, // UIT
    Coordinate{165.762, 8.92806}, // UJE
    Coordinate{129.465, 36.77}, // UJN
    Coordinate{124.499, 40.1517}, // UJU
    Coordinate{39.5714, -4.29694}, // UKA
    Coordinate{135.224, 34.6328}, // UKB
    Coordinate{135.647, 70.0111}, // UKG
    Coordinate{-123.201, 39.1258}, // UKI
    Coordinate{82.4942, 50.0361}, // UKK
    Coordinate{-95.725, 38.3025}, // UKL
    Coordinate{45.65, 13.9333}, // UKR
    Coordinate{33.5833, 44.6833}, // UKS
    Coordinate{-75.3803, 40.4364}, // UKT
    Coordinate{142.483, -3.667}, // UKU
    Coordinate{105.73, 56.8567}, // UKX
    Coordinate{-67.8028, -49.3094}, // ULA
    Coordinate{168.283, -16.333}, // ULB
    Coordinate{-70.7, -33.4936}, // ULC
    Coordinate{31.4161, -28.3206}, // ULD
    Coordinate{151.297, -4.9747}, // ULE
    Coordinate{89.9197, 48.9917}, // ULG
    Coordinate{38.1169, 26.4833}, // ULH
    Coordinate{114.826, 60.7206}, // ULK
    Coordinate{-94.5022, 44.3194}, // ULM
    Coordinate{106.766, 47.8431}, // ULN
    Coordinate{92.0797, 49.9733}, // ULO
    Coordinate{144.257, -26.6086}, // ULP
    Coordinate{-76.2261, 4.09449}, // ULQ
    Coordinate{32.275, 2.8}, // ULU
    Coordinate{48.2267, 54.2683}, // ULV
    Coordinate{48.8028, 54.4011}, // ULY
    Coordinate{96.5242, 47.7128}, // ULZ
    Coordinate{145.966, -7.017}, // UMC
    Coordinate{20.28, 63.7931}, // UME
    Coordinate{-149.127, 63.3314}, // UMM
    Coordinate{-86.045, 39.9353}, // UMP
    Coordinate{134.449, 60.3639}, // UMS
    Coordinate{-152.135, 69.3711}, // UMT
    Coordinate{-53.3139, -23.7992}, // UMU
    Coordinate{34.7625, 50.8583}, // UMY
    Coordinate{-38.9972, -15.3533}, // UNA
    Coordinate{68.9106, 36.6651}, // UND
    Coordinate{28.6711, -30.1111}, // UNE
    Coordinate{141.282, -6.12567}, // UNG
    Coordinate{-61.4425, 12.5986}, // UNI
    Coordinate{-160.799, 63.8883}, // UNK
    Coordinate{98.5853, 9.7775}, // UNN
    Coordinate{-91.9028, 36.8783}, // UNO
    Coordinate{-88.7039, 43.4264}, // UNU
    Coordinate{-85.8981, 35.2053}, // UOS
    Coordinate{-89.5367, 34.3844}, // UOX
    Coordinate{-82.5794, 23.0328}, // UPB
    Coordinate{119.554, -5.06167}, // UPG
    Coordinate{-102.039, 19.3967}, // UPN
    Coordinate{-155.86, 20.2653}, // UPP
    Coordinate{51.5431, 51.1508}, // URA
    Coordinate{-51.5665, -20.777}, // URB
    Coordinate{87.4742, 43.9072}, // URC
    Coordinate{22.5094, 58.2297}, // URE
    Coordinate{-57.0383, -29.7833}, // URG
    Coordinate{64.8333, 60.1167}, // URJ
    Coordinate{1.18389, 49.3908}, // URO
    Coordinate{-76.1406, 6.32771}, // URR
    Coordinate{36.2967, 51.7517}, // URS
    Coordinate{99.1392, 9.13611}, // URT
    Coordinate{148.567, -9.5}, // URU
    Coordinate{37.2794, 31.4119}, // URY
    Coordinate{-80.7092, 35.3878}, // USA
    Coordinate{-68.3123, -54.8396}, // USH
    Coordinate{-59.7833, 8.2}, // USI
    Coordinate{57.3667, 66}, // USK
    Coordinate{100.062, 9.54778}, // USM
    Coordinate{129.352, 35.5933}, // USN
    Coordinate{29.4699, 38.6796}, // USQ
    Coordinate{143.111, 64.5494}, // USR
    Coordinate{-79.4428, 21.97}, // USS
    Coordinate{-81.3397, 29.9592}, // UST
    Coordinate{120.1, 12.1214}, // USU
    Coordinate{32.625, -18.9975}, // UTA
    Coordinate{144.529, -22.5831}, // UTB
    Coordinate{27.6933, -30.4075}, // UTG
    Coordinate{102.788, 17.3864}, // UTH
    Coordinate{26.9381, 60.8964}, // UTI
    Coordinate{169.853, 11.2225}, // UTK
    Coordinate{-90.3478, 34.685}, // UTM
    Coordinate{21.2597, -28.4011}, // UTN
    Coordinate{-153.704, 65.9928}, // UTO
    Coordinate{101.005, 12.6796}, // UTP
    Coordinate{52.1989, 65.4333}, // UTS
    Coordinate{28.6736, -31.5464}, // UTT
    Coordinate{-77.9347, 9.1379}, // UTU
    Coordinate{52.8017, 54.64}, // UUA
    Coordinate{107.438, 51.8075}, // UUD
    Coordinate{-149.598, 70.3308}, // UUK
    Coordinate{113.285, 46.6603}, // UUN
    Coordinate{142.724, 46.8869}, // UUS
    Coordinate{147.6, -8.083}, // UUU
    Coordinate{-99.7436, 29.2114}, // UVA
    Coordinate{166.573, -20.6417}, // UVE
    Coordinate{-60.9525, 13.7333}, // UVF
    Coordinate{30.59, 25.4716}, // UVL
    Coordinate{-72.2148, 42.282}, // UWA
    Coordinate{-93.3761, 30.1314}, // UXL
    Coordinate{-83.4619, 39.9328}, // UYF
    Coordinate{24.9, 12.0535}, // UYL
    Coordinate{109.73, 38.2742}, // UYN
    Coordinate{-66.8422, -20.45}, // UYU
    Coordinate{19.6974, 43.8988}, // UZC
    Coordinate{-106.614, 68.1639}, // UZM
    Coordinate{81.659, 47.0895}, // UZR
    Coordinate{-57.9828, -29.7725}, // UZU
    Coordinate{21.7642, 63.0453}, // VAA
    Coordinate{4.96861, 44.9156}, // VAF
    Coordinate{-45.4733, -21.5889}, // VAG
    Coordinate{-64.0996, -18.4793}, // VAH
    Coordinate{141.302, -2.69717}, // VAI
    Coordinate{-165.601, 61.5408}, // VAK
    Coordinate{-38.9925, -13.2964}, // VAL
    Coordinate{72.8358, 3.47056}, // VAM
    Coordinate{43.3308, 38.4683}, // VAN
    Coordinate{158.731, -7.58583}, // VAO
    Coordinate{-71.3542, -33.3568}, // VAP
    Coordinate{27.8253, 43.2319}, // VAR
    Coordinate{36.9025, 39.7667}, // VAS
    Coordinate{48.95, -19.3833}, // VAT
    Coordinate{177.842, -17.5}, // VAU
    Coordinate{-173.97, -18.5856}, // VAV
    Coordinate{31.045, 70.3553}, // VAW
    Coordinate{96.0896, 21.9405}, // VBC
    Coordinate{98.7355, 11.1511}, // VBP
    Coordinate{10.3314, 45.4286}, // VBS
    Coordinate{-94.2194, 36.3458}, // VBT
    Coordinate{-178.983, -17.2667}, // VBV
    Coordinate{18.3461, 57.6628}, // VBY
    Coordinate{105.712, 10.0853}, // VCA
    Coordinate{-121.962, 38.3778}, // VCB
    Coordinate{9.2, 4.01667}, // VCC
    Coordinate{131.003, -16.4033}, // VCD
    Coordinate{12.3519, 45.5053}, // VCE
    Coordinate{-66.1772, -40.6997}, // VCF
    Coordinate{-54.6169, -31.7669}, // VCH
    Coordinate{108.706, 15.4061}, // VCL
    Coordinate{-47.1344, -23.0069}, // VCP
    Coordinate{-70.0654, 10.1756}, // VCR
    Coordinate{106.629, 8.7325}, // VCS
    Coordinate{-96.9186, 28.8525}, // VCT
    Coordinate{-117.383, 34.5975}, // VCV
    Coordinate{34.9358, 29.9403}, // VDA
    Coordinate{9.28806, 61.0156}, // VDB
    Coordinate{-40.8631, -14.8636}, // VDC
    Coordinate{-17.8869, 27.8147}, // VDE
    Coordinate{-82.3453, 28.0139}, // VDF
    Coordinate{106.591, 17.515}, // VDH
    Coordinate{-82.3711, 32.1928}, // VDI
    Coordinate{-62.9978, -40.8703}, // VDM
    Coordinate{107.409, 21.0981}, // VDO
    Coordinate{-65.9933, 9.22194}, // VDP
    Coordinate{-65.1475, -31.9533}, // VDR
    Coordinate{29.8447, 70.0653}, // VDS
    Coordinate{76.6341, 15.175}, // VDY
    Coordinate{-146.248, 61.1339}, // VDZ
    Coordinate{-146.366, 67.0086}, // VEE
    Coordinate{-109.51, 40.4408}, // VEL
    Coordinate{-96.1874, 19.1458}, // VER
    Coordinate{-84.5319, 40.2044}, // VES
    Coordinate{-20.2792, 63.425}, // VEY
    Coordinate{25.839, -18.0959}, // VFA
    Coordinate{80.7967, 16.5275}, // VGA
    Coordinate{-75.5611, 42.8433}, // VGC
    Coordinate{39.9467, 59.2817}, // VGD
    Coordinate{120.356, 17.5547}, // VGN
    Coordinate{-8.6275, 42.2292}, // VGO
    Coordinate{-115.194, 36.2106}, // VGT
    Coordinate{-76.6064, 0.978503}, // VGZ
    Coordinate{20.4316, -9.68894}, // VHC
    Coordinate{16.8333, 64.5789}, // VHM
    Coordinate{-104.784, 31.0578}, // VHN
    Coordinate{120.276, 63.4592}, // VHV
    Coordinate{3.40333, 46.1692}, // VHY
    Coordinate{-138.853, -18.78}, // VHZ
    Coordinate{-51.1575, -27}, // VIA
    Coordinate{-111.688, 25.0553}, // VIB
    Coordinate{22.8158, 44.0222}, // VID
    Coordinate{16.5697, 48.1103}, // VIE
    Coordinate{-71.6728, 8.62417}, // VIG
    Coordinate{-91.7694, 38.1275}, // VIH
    Coordinate{105.671, 18.7367}, // VII
    Coordinate{-64.4281, 18.4456}, // VIJ
    Coordinate{-15.9319, 23.7181}, // VIL
    Coordinate{28.6139, 49.2397}, // VIN
    Coordinate{126.373, -8.8839}, // VIQ
    Coordinate{31.0583, -29.7708}, // VIR
    Coordinate{-119.393, 36.3186}, // VIS
    Coordinate{-2.72444, 42.8828}, // VIT
    Coordinate{150.318, -9.3064}, // VIV
    Coordinate{-40.2864, -20.2581}, // VIX
    Coordinate{-82.0333, 36.6871}, // VJI
    Coordinate{105.134, 9.95972}, // VKG
    Coordinate{37.2675, 55.5961}, // VKO
    Coordinate{63.99, 67.4883}, // VKT
    Coordinate{-76.9558, 38.7486}, // VKX
    Coordinate{-0.481667, 39.4894}, // VLC
    Coordinate{-83.2761, 30.7814}, // VLD
    Coordinate{-112.142, 35.6495}, // VLE
    Coordinate{-57.0239, -37.2344}, // VLG
    Coordinate{168.32, -17.6992}, // VLI
    Coordinate{-4.85194, 41.7061}, // VLL
    Coordinate{-63.4056, -21.255}, // VLM
    Coordinate{-67.9283, 10.1497}, // VLN
    Coordinate{-51.1422, -9.97945}, // VLP
    Coordinate{-70.7575, -28.5965}, // VLR
    Coordinate{168.177, -16.7961}, // VLS
    Coordinate{30.61, 56.3817}, // VLU
    Coordinate{-70.5842, 9.34083}, // VLV
    Coordinate{-4.53528, 53.2481}, // VLY
    Coordinate{-65.3781, -33.7318}, // VME
    Coordinate{-57.94, -22.16}, // VMI
    Coordinate{-63.2265, -32.3201}, // VMR
    Coordinate{144.823, -7.4948}, // VMU
    Coordinate{-82.4403, 27.0717}, // VNC
    Coordinate{47.5789, -23.3517}, // VND
    Coordinate{-2.72333, 47.7192}, // VNE
    Coordinate{25.2878, 54.6369}, // VNO
    Coordinate{82.8594, 25.4522}, // VNS
    Coordinate{21.5442, 57.3578}, // VNT
    Coordinate{35.3133, -22.0184}, // VNX
    Coordinate{-118.49, 34.2097}, // VNY
    Coordinate{14.3956, 50.2167}, // VOD
    Coordinate{44.3467, 48.7817}, // VOG
    Coordinate{-9.767, 8.4}, // VOI
    Coordinate{22.7942, 39.2194}, // VOL
    Coordinate{-50.0025, -20.4572}, // VOT
    Coordinate{39.23, 51.815}, // VOZ
    Coordinate{-84.85, 34.1231}, // VPC
    Coordinate{15.6838, -17.0435}, // VPE
    Coordinate{39.7972, -3.8103}, // VPG
    Coordinate{-14.8506, 65.7206}, // VPN
    Coordinate{-86.5494, 30.4833}, // VPS
    Coordinate{33.4286, -19.1486}, // VPY
    Coordinate{-87.0072, 41.4539}, // VPZ
    Coordinate{-81.8767, 30.2186}, // VQQ
    Coordinate{-65.4936, 18.1347}, // VQS
    Coordinate{-81.4353, 23.0344}, // VRA
    Coordinate{-80.4179, 27.6556}, // VRB
    Coordinate{124.206, 13.5758}, // VRC
    Coordinate{18.5396, -31.6431}, // VRE
    Coordinate{58.1986, 68.8478}, // VRI
    Coordinate{-7.71972, 41.2775}, // VRL
    Coordinate{-81.3036, 23.1228}, // VRO
    Coordinate{24.7283, -26.9808}, // VRU
    Coordinate{-92.8172, 17.995}, // VSA
    Coordinate{-7.88917, 40.7278}, // VSE
    Coordinate{-72.5172, 43.3436}, // VSF
    Coordinate{30.3517, 55.1264}, // VTB
    Coordinate{102.563, 17.9883}, // VTE
    Coordinate{177.638, -18.5115}, // VTF
    Coordinate{107.093, 10.3703}, // VTG
    Coordinate{-100.549, 42.8567}, // VTN
    Coordinate{12.0622, 42.4302}, // VTR
    Coordinate{-76.9358, 20.9878}, // VTU
    Coordinate{83.2244, 17.7211}, // VTZ
    Coordinate{-80.1508, 35.4167}, // VUJ
    Coordinate{-122.656, 45.6206}, // VUO
    Coordinate{-73.2494, 10.435}, // VUP
    Coordinate{46.26, 60.7883}, // VUS
    Coordinate{-73.6144, 4.16833}, // VVC
    Coordinate{-63.1353, -17.6447}, // VVI
    Coordinate{132.151, 43.3992}, // VVO
    Coordinate{8.62247, 26.7236}, // VVZ
    Coordinate{35.2644, -13.2742}, // VXC
    Coordinate{-25.0569, 16.8331}, // VXE
    Coordinate{14.7278, 56.9289}, // VXO
    Coordinate{121.693, 63.7567}, // VYI
    Coordinate{-89.1531, 41.3519}, // VYS
    Coordinate{-168.095, 65.6225}, // WAA
    Coordinate{37.167, 7.167}, // WAC
    Coordinate{45.1994, 20.5042}, // WAE
    Coordinate{175.025, -39.9622}, // WAG
    Coordinate{-96.6072, 46.2442}, // WAH
    Coordinate{46.953, -15.7741}, // WAI
    Coordinate{142.65, -6.95}, // WAJ
    Coordinate{48.4333, -17.8}, // WAM
    Coordinate{145, -7.6667}, // WAO
    Coordinate{-71.8069, -43.6153}, // WAP
    Coordinate{44.6147, -18.7014}, // WAQ
    Coordinate{-7.08696, 52.1872}, // WAT
    Coordinate{20.9672, 52.1658}, // WAW
    Coordinate{12.0167, 32.9528}, // WAX
    Coordinate{-80.1306, 39.9011}, // WAY
    Coordinate{151.943, -28.1494}, // WAZ
    Coordinate{-162.278, 63.5158}, // WBB
    Coordinate{150.4, -9.317}, // WBC
    Coordinate{143.895, -5.6433}, // WBM
    Coordinate{45.1333, -21.6076}, // WBO
    Coordinate{-147.407, 66.3622}, // WBQ
    Coordinate{-85.5042, 43.7225}, // WBR
    Coordinate{-105.226, 40.0394}, // WBU
    Coordinate{-75.8522, 41.2972}, // WBW
    Coordinate{-73.7667, -42.4833}, // WCA
    Coordinate{-72.8347, -42.7819}, // WCH
    Coordinate{-148.483, 67.5044}, // WCR
    Coordinate{45.55, 14.8667}, // WDA
    Coordinate{-97.7889, 36.3783}, // WDG
    Coordinate{17.4708, -22.48}, // WDH
    Coordinate{-83.6681, 33.9822}, // WDR
    Coordinate{110.908, 32.5917}, // WDS
    Coordinate{-97.6824, 32.7463}, // WEA
    Coordinate{119.118, 36.6467}, // WEF
    Coordinate{122.229, 37.1869}, // WEH
    Coordinate{141.925, -12.6786}, // WEI
    Coordinate{26.6667, -28}, // WEL
    Coordinate{47.1, -21.45}, // WFI
    Coordinate{-68.3128, 47.2856}, // WFK
    Coordinate{79.6, 17.9167}, // WGC
    Coordinate{148.125, -30.0333}, // WGE
    Coordinate{110.642, 26.802}, // WGN
    Coordinate{-78.1444, 39.1439}, // WGO
    Coordinate{120.301, -9.66861}, // WGP
    Coordinate{146.307, -36.4158}, // WGT
    Coordinate{146.8, -6.8}, // WGU
    Coordinate{-130.007, 55.9033}, // WHD
    Coordinate{31.5164, 21.8003}, // WHF
    Coordinate{176.914, -37.9206}, // WHK
    Coordinate{-118.413, 34.2593}, // WHP
    Coordinate{-96.1542, 29.2542}, // WHT
    Coordinate{-99.2839, 34.2256}, // WIB
    Coordinate{-3.09306, 58.4589}, // WIC
    Coordinate{175.085, -36.8089}, // WIK
    Coordinate{36.8148, -1.32172}, // WIL
    Coordinate{143.085, -22.3633}, // WIN
    Coordinate{143.375, -31.5267}, // WIO
    Coordinate{177.404, -39.0122}, // WIR
    Coordinate{149.183, -5.5667}, // WIU
    Coordinate{168.55, 7.4508}, // WJA
    Coordinate{-118.219, 34.7411}, // WJF
    Coordinate{40.09, 1.73}, // WJR
    Coordinate{127.96, 37.4381}, // WJU
    Coordinate{169.246, -44.7225}, // WKA
    Coordinate{142.419, -36.3211}, // WKB
    Coordinate{26.5142, -18.3632}, // WKI
    Coordinate{141.802, 45.4044}, // WKJ
    Coordinate{-158.618, 59.2825}, // WKK
    Coordinate{155.221, -5.86139}, // WKN
    Coordinate{-78.4022, 27.2604}, // WKR
    Coordinate{-97.0375, 37.1686}, // WLD
    Coordinate{150.165, -26.8092}, // WLE
    Coordinate{174.812, -41.329}, // WLG
    Coordinate{167.691, -15.412}, // WLH
    Coordinate{-159.986, 66.6}, // WLK
    Coordinate{118.707, -23.1367}, // WLP
    Coordinate{-176.199, -13.2383}, // WLS
    Coordinate{-122.217, 39.5158}, // WLW
    Coordinate{142.447, -38.2953}, // WMB
    Coordinate{-117.806, 40.8967}, // WMC
    Coordinate{44.94, -21.0464}, // WMD
    Coordinate{120.555, -27.2864}, // WME
    Coordinate{-92.4706, 36.3689}, // WMH
    Coordinate{20.6517, 52.4511}, // WMI
    Coordinate{172.395, -43.4767}, // WML
    Coordinate{49.6833, -15.4383}, // WMN
    Coordinate{-163.413, 64.6892}, // WMO
    Coordinate{47.6167, -16.05}, // WMP
    Coordinate{49.7667, -16.1667}, // WMR
    Coordinate{106.438, 27.967}, // WMT
    Coordinate{138.952, -4.09833}, // WMX
    Coordinate{-161.979, 60.6903}, // WNA
    Coordinate{-133.228, 55.8496}, // WNC
    Coordinate{104.243, 23.3758}, // WNH
    Coordinate{123.583, -5.31667}, // WNI
    Coordinate{-89.2892, 52.8939}, // WNN
    Coordinate{123.27, 13.5847}, // WNP
    Coordinate{142.667, -25.4133}, // WNR
    Coordinate{68.39, 26.2194}, // WNS
    Coordinate{120.852, 27.9119}, // WNZ
    Coordinate{145.884, -6.8}, // WOA
    Coordinate{150.789, -34.5611}, // WOL
    Coordinate{140.894, -18.5727}, // WON
    Coordinate{127.484, 39.1626}, // WOS
    Coordinate{119.502, 23.3674}, // WOT
    Coordinate{-150.052, 61.7542}, // WOW
    Coordinate{-72.6703, -45.3992}, // WPA
    Coordinate{47.6167, -15.5833}, // WPB
    Coordinate{-113.997, 49.5206}, // WPC
    Coordinate{-124.533, 49.8833}, // WPL
    Coordinate{-70.3327, -53.2537}, // WPR
    Coordinate{-67.6263, -54.9311}, // WPU
    Coordinate{174.365, -35.7683}, // WRE
    Coordinate{-132.37, 56.4844}, // WRG
    Coordinate{-107.951, 43.9628}, // WRL
    Coordinate{119.39, -30.0317}, // WRN
    Coordinate{16.8858, 51.1028}, // WRO
    Coordinate{132.191, -0.419444}, // WRR
    Coordinate{-2.8839, 53.745}, // WRT
    Coordinate{-76.9917, 0.0708333}, // WSE
    Coordinate{-164.914, 54.5824}, // WSF
    Coordinate{-80.2903, 40.1364}, // WSG
    Coordinate{-72.8669, 40.8219}, // WSH
    Coordinate{-153.321, 57.7303}, // WSJ
    Coordinate{109.706, 31.064}, // WSK
    Coordinate{-157.003, 58.7022}, // WSN
    Coordinate{-57.1853, 5.21528}, // WSO
    Coordinate{-83.9758, 14.736}, // WSP
    Coordinate{-71.8033, 41.3497}, // WST
    Coordinate{147.3, -6}, // WSU
    Coordinate{-122.953, 48.6178}, // WSX
    Coordinate{171.581, -41.7381}, // WSZ
    Coordinate{43.9667, -17.4833}, // WTA
    Coordinate{151.795, -27.5586}, // WTB
    Coordinate{-78.975, 26.6833}, // WTD
    Coordinate{170.239, 9.45833}, // WTE
    Coordinate{-162.98, 67.5611}, // WTK
    Coordinate{-162.667, 60.3353}, // WTL
    Coordinate{166.003, 10.1733}, // WTO
    Coordinate{147.253, -8.5625}, // WTP
    Coordinate{-109.986, 33.8106}, // WTR
    Coordinate{146.468, -6.1325}, // WTT
    Coordinate{175.679, -36.8358}, // WTZ
    Coordinate{106.803, 39.7919}, // WUA
    Coordinate{135.447, -33.0432}, // WUD
    Coordinate{146.719, -7.34531}, // WUG
    Coordinate{114.208, 30.7836}, // WUH
    Coordinate{121.89, -28.7053}, // WUI
    Coordinate{120.22, -26.63}, // WUN
    Coordinate{118, 27.7008}, // WUS
    Coordinate{112.968, 38.5992}, // WUT
    Coordinate{27.975, 7.7258}, // WUU
    Coordinate{142.835, -1.7336}, // WUV
    Coordinate{120.429, 31.4944}, // WUX
    Coordinate{111.099, 23.4014}, // WUZ
    Coordinate{14.6453, -22.98}, // WVB
    Coordinate{-121.79, 36.9358}, // WVI
    Coordinate{48.0167, -22.1206}, // WVK
    Coordinate{-69.6756, 44.5333}, // WVL
    Coordinate{-149.539, 61.5719}, // WWA
    Coordinate{-74.9083, 39.0086}, // WWD
    Coordinate{143.669, -3.58383}, // WWK
    Coordinate{-133.122, 56.1164}, // WWP
    Coordinate{-99.5228, 36.4381}, // WWR
    Coordinate{-164.641, 60.9392}, // WWT
    Coordinate{147.192, -33.9367}, // WWY
    Coordinate{108.431, 30.7978}, // WXN
    Coordinate{137.514, -33.0589}, // WYA
    Coordinate{-11.0472, 8.6105}, // WYE
    Coordinate{104.402, -4.39206}, // WYK
    Coordinate{128.153, -15.5114}, // WYN
    Coordinate{-111.118, 44.6883}, // WYS
    Coordinate{-2.5075, 10.0825}, // WZA
    Coordinate{114.078, 32.5414}, // XAI
    Coordinate{-52.6619, -27.1339}, // XAP
    Coordinate{-0.895556, 14.2153}, // XAR
    Coordinate{-53.2042, 3.61361}, // XAU
    Coordinate{-91.0272, 53.9656}, // XBE
    Coordinate{-0.167, 12.983}, // XBG
    Coordinate{59.2661, 32.8897}, // XBJ
    Coordinate{-0.567, 12.65}, // XBO
    Coordinate{-97.8283, 33.1753}, // XBP
    Coordinate{-75.7503, 44.6394}, // XBR
    Coordinate{4.8175, 46.8261}, // XCD
    Coordinate{105.69, -10.4506}, // XCH
    Coordinate{-82.0825, 42.3058}, // XCM
    Coordinate{4.19167, 48.7778}, // XCR
    Coordinate{-3.25, 10.9482}, // XDE
    Coordinate{-1.62472, 14.125}, // XDJ
    Coordinate{-88.3944, 42.6131}, // XES
    Coordinate{112.291, 32.15}, // XFN
    Coordinate{-3.25083, 10.2992}, // XGA
    Coordinate{-0.218889, 14.4542}, // XGG
    Coordinate{14.9649, -16.7553}, // XGN
    Coordinate{-65.9928, 58.7114}, // XGR
    Coordinate{102.184, 27.9892}, // XIC
    Coordinate{100.833, 19.65}, // XIE
    Coordinate{115.964, 43.9167}, // XIL
    Coordinate{108.751, 34.4469}, // XIY
    Coordinate{73.6383, 33.05}, // XJM
    Coordinate{1.5, 12.467}, // XKA
    Coordinate{103.158, 19.4401}, // XKH
    Coordinate{-88.6431, 53.5247}, // XKS
    Coordinate{-1.1, 13.067}, // XKY
    Coordinate{-101.469, 58.6142}, // XLB
    Coordinate{-79.9133, 36.2536}, // XLL
    Coordinate{-16.4611, 16.0498}, // XLS
    Coordinate{-2.1, 11.1}, // XLU
    Coordinate{149.721, -37.5989}, // XMC
    Coordinate{-97.0856, 44.0164}, // XMD
    Coordinate{6.79139, 47.4867}, // XMF
    Coordinate{80.1481, 28.9633}, // XMG
    Coordinate{-146.071, -14.4375}, // XMH
    Coordinate{38.7667, -10.7383}, // XMI
    Coordinate{118.126, 24.5222}, // XMN
    Coordinate{-130.202, 63.1765}, // XMP
    Coordinate{-78.1208, -2.29917}, // XMS
    Coordinate{142.772, -9.9}, // XMY
    Coordinate{-94.3078, 36.2817}, // XNA
    Coordinate{102.043, 36.5275}, // XNN
    Coordinate{-81.0831, 33.6169}, // XNO
    Coordinate{114.429, 36.8828}, // XNT
    Coordinate{-3.867, 12.75}, // XNU
    Coordinate{0.7, 11.25}, // XPA
    Coordinate{-101.266, 55.7492}, // XPK
    Coordinate{-97.2736, 52.9964}, // XPP
    Coordinate{-102.511, 43.0225}, // XPR
    Coordinate{-84.1333, 9.44306}, // XQP
    Coordinate{-124.394, 49.3372}, // XQU
    Coordinate{116.938, 48.5762}, // XRQ
    Coordinate{-132.422, 61.9706}, // XRR
    Coordinate{-6.06, 36.7447}, // XRY
    Coordinate{-76.8942, 37.8597}, // XSA
    Coordinate{52.5833, 24.2833}, // XSB
    Coordinate{-71.5286, 21.5158}, // XSC
    Coordinate{-116.779, 37.7947}, // XSD
    Coordinate{0.503333, 13.4567}, // XSE
    Coordinate{-98.9072, 56.7928}, // XSI
    Coordinate{3.02861, 49.8689}, // XSJ
    Coordinate{103.868, 1.41694}, // XSP
    Coordinate{143.811, -27.9864}, // XTG
    Coordinate{-98.5122, 58.7061}, // XTL
    Coordinate{149.899, -25.8019}, // XTO
    Coordinate{-0.6167, 52.0722}, // XUD
    Coordinate{117.555, 34.0591}, // XUZ
    Coordinate{3.46126, 50.3247}, // XVS
    Coordinate{-103.751, 48.2597}, // XWA
    Coordinate{159.219, -9.09278}, // XYA
    Coordinate{97.8667, 15.3}, // XYE
    Coordinate{141.783, -3.88333}, // XYR
    Coordinate{-0.616667, 11.1667}, // XZA
    Coordinate{-125.304, 52.4514}, // YAA
    Coordinate{-85.0472, 73.0064}, // YAB
    Coordinate{-91.8244, 51.7272}, // YAC
    Coordinate{-93.4406, 48.6544}, // YAG
    Coordinate{-73.6753, 53.7547}, // YAH
    Coordinate{-72.0388, -36.5868}, // YAI
    Coordinate{-139.66, 59.5033}, // YAK
    Coordinate{-126.916, 50.5822}, // YAL
    Coordinate{-84.5094, 46.485}, // YAM
    Coordinate{24.45, 0.8}, // YAN
    Coordinate{11.5216, 3.83206}, // YAO
    Coordinate{138.083, 9.4989}, // YAP
    Coordinate{-76.1964, 53.5719}, // YAR
    Coordinate{177.545, -16.7589}, // YAS
    Coordinate{-82.4319, 52.9275}, // YAT
    Coordinate{-73.3214, 61.6622}, // YAU
    Coordinate{-89.5794, 53.8492}, // YAX
    Coordinate{-56.0831, 51.3919}, // YAY
    Coordinate{-125.772, 49.0822}, // YAZ
    Coordinate{-115.54, 51.2083}, // YBA
    Coordinate{-89.8053, 68.5358}, // YBB
    Coordinate{-68.2044, 49.1325}, // YBC
    Coordinate{-108.481, 59.5614}, // YBE
    Coordinate{-125.137, 48.8342}, // YBF
    Coordinate{-70.9964, 48.3306}, // YBG
    Coordinate{-55.7875, 53.47}, // YBI
    Coordinate{-62.8103, 50.2836}, // YBJ
    Coordinate{-96.0778, 64.2989}, // YBK
    Coordinate{-125.273, 49.9519}, // YBL
    Coordinate{-130.249, 56.9667}, // YBO
    Coordinate{104.525, 28.858}, // YBP
    Coordinate{-99.9522, 49.91}, // YBR
    Coordinate{-90.3769, 52.6086}, // YBS
    Coordinate{-101.679, 57.8894}, // YBT
    Coordinate{-97.0181, 52.3589}, // YBV
    Coordinate{-123.228, 48.7467}, // YBW
    Coordinate{-57.1861, 51.4419}, // YBX
    Coordinate{-110.741, 54.3047}, // YBY
    Coordinate{-124.982, 49.6794}, // YCA
    Coordinate{-74.5678, 45.0928}, // YCC
    Coordinate{-123.87, 49.0544}, // YCD
    Coordinate{-124.984, 50.0236}, // YCF
    Coordinate{-117.632, 49.2961}, // YCG
    Coordinate{-65.4569, 47.0058}, // YCH
    Coordinate{-126.129, 67.0211}, // YCK
    Coordinate{-66.3303, 47.9908}, // YCL
    Coordinate{-79.1711, 43.1917}, // YCM
    Coordinate{-81.0153, 49.1067}, // YCN
    Coordinate{-115.144, 67.8167}, // YCO
    Coordinate{-121.627, 55.6872}, // YCQ
    Coordinate{-97.7603, 54.6108}, // YCR
    Coordinate{-90.7311, 63.3472}, // YCS
    Coordinate{-111.445, 52.075}, // YCT
    Coordinate{111.04, 35.1167}, // YCU
    Coordinate{-121.939, 49.1528}, // YCW
    Coordinate{-68.5169, 70.4858}, // YCY
    Coordinate{-115.873, 50.3303}, // YCZ
    Coordinate{-139.13, 64.0422}, // YDA
    Coordinate{-139.04, 61.3706}, // YDB
    Coordinate{-114.96, 53.2658}, // YDC
    Coordinate{-57.3944, 49.2092}, // YDF
    Coordinate{-65.7858, 44.5458}, // YDG
    Coordinate{-103.538, 58.6625}, // YDJ
    Coordinate{-130.031, 58.4222}, // YDL
    Coordinate{-72.375, 48.7783}, // YDO
    Coordinate{-61.6822, 56.5506}, // YDP
    Coordinate{-120.183, 55.7422}, // YDQ
    Coordinate{-123.007, 49.0742}, // YDT
    Coordinate{-102.502, 60.2919}, // YDU
    Coordinate{-96.6922, 51.7844}, // YDV
    Coordinate{-103.132, 60.3156}, // YDW
    Coordinate{-110, 50.9333}, // YEA
    Coordinate{-84.0942, 46.4189}, // YEB
    Coordinate{-79.9294, 44.6847}, // YEE
    Coordinate{-113.579, 53.31}, // YEG
    Coordinate{52.6153, 27.4814}, // YEH
    Coordinate{-94.0717, 61.0939}, // YEK
    Coordinate{-82.5611, 46.3517}, // YEL
    Coordinate{-81.8575, 45.8425}, // YEM
    Coordinate{-102.966, 49.2103}, // YEN
    Coordinate{143.917, -5.1}, // YEQ
    Coordinate{-87.6761, 56.0189}, // YER
    Coordinate{51.545, 30.7006}, // YES
    Coordinate{-116.465, 53.5789}, // YET
    Coordinate{-85.8119, 79.9944}, // YEU
    Coordinate{-133.483, 68.3039}, // YEV
    Coordinate{-78.2492, 48.565}, // YEY
    Coordinate{-81.6958, 52.2036}, // YFA
    Coordinate{-68.5561, 63.7567}, // YFB
    Coordinate{-66.5372, 45.8689}, // YFC
    Coordinate{-79.6289, 44.1361}, // YFD
    Coordinate{-69.0972, 48.7461}, // YFE
    Coordinate{-71.1733, 54.5539}, // YFG
    Coordinate{-87.9078, 51.5619}, // YFH
    Coordinate{-110.977, 57.2758}, // YFI
    Coordinate{-114.079, 64.1917}, // YFJ
    Coordinate{-109.167, 62.7}, // YFL
    Coordinate{-101.682, 54.6781}, // YFO
    Coordinate{-113.69, 61.1808}, // YFR
    Coordinate{-121.237, 61.7603}, // YFS
    Coordinate{-55.6739, 52.3728}, // YFX
    Coordinate{-124.518, 49.6942}, // YGB
    Coordinate{-118.874, 53.9169}, // YGC
    Coordinate{-123.5, 48.85}, // YGG
    Coordinate{-128.648, 66.2406}, // YGH
    Coordinate{133.239, 35.4933}, // YGJ
    Coordinate{-76.5969, 44.2253}, // YGK
    Coordinate{-77.7042, 53.6253}, // YGL
    Coordinate{-97.0433, 50.6281}, // YGM
    Coordinate{-94.4914, 54.5589}, // YGO
    Coordinate{-64.4797, 48.7753}, // YGP
    Coordinate{-86.9386, 49.7786}, // YGQ
    Coordinate{-61.7781, 47.425}, // YGR
    Coordinate{-81.8164, 69.3647}, // YGT
    Coordinate{-63.6111, 50.2819}, // YGV
    Coordinate{-77.7653, 55.2819}, // YGW
    Coordinate{-94.7108, 56.3578}, // YGX
    Coordinate{-82.9094, 76.4261}, // YGZ
    Coordinate{-56.2853, 52.5281}, // YHA
    Coordinate{-102.311, 52.8183}, // YHB
    Coordinate{-92.7442, 49.8317}, // YHD
    Coordinate{-121.498, 49.3683}, // YHE
    Coordinate{-83.6869, 49.7139}, // YHF
    Coordinate{-56.1125, 52.7658}, // YHG
    Coordinate{-125.25, 50.05}, // YHH
    Coordinate{-117.806, 70.7628}, // YHI
    Coordinate{-95.8503, 68.6356}, // YHK
    Coordinate{-79.935, 43.1736}, // YHM
    Coordinate{-84.7589, 49.1931}, // YHN
    Coordinate{-60.2281, 55.4489}, // YHO
    Coordinate{-94.2556, 52.1133}, // YHP
    Coordinate{-59.6367, 50.4689}, // YHR
    Coordinate{-123.719, 49.4606}, // YHS
    Coordinate{-137.545, 60.7894}, // YHT
    Coordinate{-73.4169, 45.5181}, // YHU
    Coordinate{-115.783, 60.8397}, // YHY
    Coordinate{-63.5103, 44.8797}, // YHZ
    Coordinate{110.054, -7.90746}, // YIA
    Coordinate{-91.6386, 48.7739}, // YIB
    Coordinate{114.308, 27.8033}, // YIC
    Coordinate{119.912, 47.3106}, // YIE
    Coordinate{-58.6575, 51.2097}, // YIF
    Coordinate{111.48, 30.5565}, // YIH
    Coordinate{-77.9253, 62.4172}, // YIK
    Coordinate{81.3303, 43.9558}, // YIN
    Coordinate{-77.9689, 72.6894}, // YIO
    Coordinate{-83.5304, 42.2379}, // YIP
    Coordinate{-94.6536, 53.8572}, // YIV
    Coordinate{120.032, 29.3447}, // YIW
    Coordinate{-118.059, 52.9967}, // YJA
    Coordinate{-123.47, 60.2356}, // YJF
    Coordinate{-124.263, 54.3972}, // YJM
    Coordinate{-73.2817, 45.2944}, // YJN
    Coordinate{-117.753, 53.3192}, // YJP
    Coordinate{128.41, 41.9072}, // YJS
    Coordinate{-58.55, 48.5414}, // YJT
    Coordinate{-120.449, 50.7025}, // YKA
    Coordinate{-103.677, 58.2361}, // YKC
    Coordinate{-81.6056, 44.2014}, // YKD
    Coordinate{-94.7981, 54.9153}, // YKE
    Coordinate{-80.3786, 43.4608}, // YKF
    Coordinate{-69.9992, 60.0272}, // YKG
    Coordinate{122.357, 40.5408}, // YKH
    Coordinate{-105.618, 57.2564}, // YKJ
    Coordinate{-130.433, 53.8}, // YKK
    Coordinate{-66.8053, 54.8053}, // YKL
    Coordinate{-120.544, 46.5681}, // YKM
    Coordinate{-97.3858, 42.9167}, // YKN
    Coordinate{44.2377, 37.5501}, // YKO
    Coordinate{-78.7583, 51.4733}, // YKQ
    Coordinate{129.772, 62.0933}, // YKS
    Coordinate{-78.9169, 53.8058}, // YKU
    Coordinate{-79.9814, 48.2103}, // YKX
    Coordinate{-109.181, 51.5153}, // YKY
    Coordinate{-79.3686, 43.8608}, // YKZ
    Coordinate{-112.032, 54.7703}, // YLB
    Coordinate{-69.8772, 62.8481}, // YLC
    Coordinate{-83.3469, 47.8203}, // YLD
    Coordinate{-117.246, 63.1317}, // YLE
    Coordinate{116.684, -28.3553}, // YLG
    Coordinate{-87.9342, 52.1956}, // YLH
    Coordinate{-108.523, 54.1253}, // YLJ
    Coordinate{-79.5556, 44.4861}, // YLK
    Coordinate{-110.073, 53.3092}, // YLL
    Coordinate{129.6, 46.32}, // YLN
    Coordinate{-64.145, 50.29}, // YLP
    Coordinate{-72.7889, 47.4097}, // YLQ
    Coordinate{-99.9853, 56.5133}, // YLR
    Coordinate{-77.0172, 49.0303}, // YLS
    Coordinate{-62.2806, 82.5178}, // YLT
    Coordinate{47.1417, 40.6317}, // YLV
    Coordinate{-119.378, 49.9572}, // YLW
    Coordinate{110.059, 22.5857}, // YLX
    Coordinate{-122.631, 49.1008}, // YLY
    Coordinate{-135.868, 63.6164}, // YMA
    Coordinate{-120.747, 50.1228}, // YMB
    Coordinate{-119.319, 76.2392}, // YMD
    Coordinate{-67.4522, 48.8564}, // YME
    Coordinate{-85.8611, 49.0833}, // YMG
    Coordinate{-55.8478, 52.3028}, // YMH
    Coordinate{-70.2239, 47.5975}, // YML
    Coordinate{-111.223, 56.6533}, // YMM
    Coordinate{-59.1878, 55.0772}, // YMN
    Coordinate{-80.6083, 51.2919}, // YMO
    Coordinate{-127.029, 50.5756}, // YMP
    Coordinate{-76.1181, -5.89361}, // YMS
    Coordinate{-74.5281, 49.7719}, // YMT
    Coordinate{-124.983, 50.0667}, // YMU
    Coordinate{-79.3569, 71.3242}, // YMV
    Coordinate{-75.9906, 46.2728}, // YMW
    Coordinate{-74.0386, 45.6797}, // YMX
    Coordinate{-61.7889, 50.19}, // YNA
    Coordinate{38.0636, 24.1442}, // YNB
    Coordinate{-78.8311, 53.0106}, // YNC
    Coordinate{-75.5636, 45.5217}, // YND
    Coordinate{-97.8442, 53.9583}, // YNE
    Coordinate{-80.6792, 41.2608}, // YNG
    Coordinate{-121.976, 56.0356}, // YNH
    Coordinate{129.451, 42.8828}, // YNJ
    Coordinate{-104.082, 58.2767}, // YNL
    Coordinate{-77.8028, 49.7617}, // YNM
    Coordinate{-92.9711, 52.4733}, // YNO
    Coordinate{-61.1844, 55.9139}, // YNP
    Coordinate{