Vakzination manages your health certificates like vaccination, test, and recovery certificates.

## Supported Formats

The following certificate formats are supported:

* Indian vaccination certificates (based on https://en.wikipedia.org/wiki/Verifiable_credentials)
* EU "Digitial Green Certificate" (DCG) vaccination, test and recovery certificates (see https://github.com/eu-digital-green-certificates)

For other certificate formats please open a feature request and consider sending a data sample in private.

## Importing certificates

There are multiple ways to add certificates. You can:

- Open a file containing a certificate. This can be either a plain text file containing the data or a PDF that contains the relevant QR code.
- Pass such a file when launching Vakzination.
- Paste a certificate from the clipboard.
- Scan a QR code using [Qrca](https://invent.kde.org/plasma-mobile/qrca/) and have it opened in Vakzination.

## Get it

- Linux: [Nightly Flatpak](https://community.kde.org/Guidelines_and_HOWTOs/Flatpak) builds are availble.
- Android: An [F-Droid repository](https://community.kde.org/Android/FDroid) with nightly builds is availble.
- Windows: Nightly [Windows installers](https://binary-factory.kde.org/view/Windows%2064-bit/job/Vakzination_Nightly_win64/) are available.

## Contribute

Please see the instructions on how to [build from source](https://community.kde.org/Get_Involved/development).

For questions and discussion you can contact us in the [Plasma Mobile Matrix channel](matrix:r/plasma-mobile:kde.org).
