/***************************************************************************
                          kfvproject.h  -  description
                             -------------------
    begin                : Thu Aug 30 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFVPROJECT_H
#define KFVPROJECT_H

#include <qwidget.h>
#include <qframe.h>
class QPushButton;

class QLineEdit;
class QLayout;
class QTabWidget;
class KFMProject;
class KFMTask;
class KFVTaskList;
class KFVLogBook;


/**View of a logbook
  *@author Jeffrey Yu
  */

class KFVProject : public QFrame  {
   Q_OBJECT
public: 
	KFVProject(QWidget *parent=0, const char *name=0);
	~KFVProject();
	
	KFMProject* project() const;
	void project(KFMProject* project);

public slots: // Public slots	
  /** Slot to change the project name */
  void changeName();

private:
	
	QLineEdit* leName_;
	QPushButton* pbChange_;
	QTabWidget* twContent_;
	
	KFVTaskList* vTaskList_;
	KFVLogBook* vLogBook_;
	
	KFMProject* project_;
	
	void createWidgets();
	void createNameWidgets(QLayout* l);
	void createContentWidgets(QLayout* l);

private slots: // Private slots
  /** Slot to receive taskCompleted signal from KFVTaskList */
  void onTaskCompleted(KFMTask* task);

};

#endif
