/***************************************************************************
                          kplchecklistitem.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Aug 22 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include "kplchecklistitem.h"

KplCheckListItem::KplCheckListItem(QListView* parent) :
  QListViewItem(parent), on(false)
{
  init();
}

KplCheckListItem::KplCheckListItem(KplCheckListItem* parent) :
  QListViewItem(parent), on(false)
{
  init();
}

KplCheckListItem::KplCheckListItem(QListView* parent, KplCheckListItem* after) :
  QListViewItem(parent, after), on(false)
{
  init();
}

KplCheckListItem::KplCheckListItem(KplCheckListItem* parent,
                                   KplCheckListItem* after) :
  QListViewItem(parent, after), on(false)
{
  init();
}

KplCheckListItem::~KplCheckListItem()
{
}

void KplCheckListItem::setOn(bool b)
{
  bool old = on;
  on = b;
  if (on != old) {
    if (on)
      setPixmap(0, BarIcon("checked"));
    else
      setPixmap(0, BarIcon("unchecked"));
    emit stateChanged(this, on);
  }
}

bool KplCheckListItem::isOn() const
{
  return on;
}

void KplCheckListItem::activate()
{
  QPoint pos;
  if (!activatedPos(pos))
	  setOn(!on);
}

void KplCheckListItem::init()
{
  setPixmap(0, BarIcon("unchecked"));
}
