/***************************************************************************
                          resource.h  -  description
                             -------------------
    begin                : Sun Jun 20 14:17:54 MEST 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef RESSOURCE_H
#define RESSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands

///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES


///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_MUD_NEW_WINDOW          10010
#define ID_MUD_CONNECTION_WIZARD   10020
#define ID_MUD_CONNECT             10030
#define ID_MUD_CLOSE               10070


#define ID_MUD_CLOSE_WINDOW        10090
#define ID_MUD_QUIT                10100

#define ID_MUD_QUICKCONNECTBASE    10110
#define ID_MUD_QUICKCONNECT0       10110
#define ID_MUD_QUICKCONNECT1       10111
#define ID_MUD_QUICKCONNECT2       10112
#define ID_MUD_QUICKCONNECT3       10113
#define ID_MUD_QUICKCONNECT4       10114


///////////////////////////////////////////////////////////////////
// View-menu entries
#define ID_VIEW_TOOLBAR             12010
#define ID_VIEW_CUSTOM_TOOLBAR      12015
#define ID_VIEW_STATUSBAR           12020
#define ID_VIEW_OPTIONS             12030
#define ID_VIEW_ALTINPUT            12040
#define ID_VIEW_MULTILINEINPUT      12045
#define ID_VIEW_MAPPER              12050

///////////////////////////////////////////////////////////////////
// Option-menu entries
#define ID_OPTION_FONT             13010
#define ID_OPTION_COLORS           13020
#define ID_OPTION_PREFERENCES      13030
#define ID_OPTION_MUD              13040
#define ID_OPTION_KEYS             13050

///////////////////////////////////////////////////////////////////
// Profile-menu entries
#define ID_PROFILE_ALIASES         14010
#define ID_PROFILE_TRIGGERS        14020
#define ID_PROFILE_LOGGING         14030
#define ID_PROFILE_TOOLBAR	   14040
#define ID_PROFILE_SAVE            14100

///////////////////////////////////////////////////////////////////
// Plugin-menu entries
#define ID_PLUGIN_MANAGER          15010


///////////////////////////////////////////////////////////////////
// Help-menu entries
#define ID_HELP                     19010
#define ID_HELP_BOSS                19020

///////////////////////////////////////////////////////////////////
// special toolbar icon values
#define ID_TOOLBAR_LOGGING_TOGGLE   20010


///////////////////////////////////////////////////////////////////
// General application values
#define ID_STATUS_MSG               1001
#define ID_STATUS_ICON              1002
#define ID_STATUS_TIME              1003


//////////////////////////////////////////////////////////////////
// MAPPER WINDOW STUFF

//////////////////////////////////////////////////////////////////
// Mapper file menu entries
#define ID_MAPPER_FILE_EXPORT         30010
#define ID_MAPPER_FILE_EXPORT_KCMFILE 30011
#define ID_MAPPER_FILE_IMPORT         30020
#define ID_MAPPER_FILE_CLOSE          30030
#define ID_MAPPER_FILE_NEW            30040
#define ID_MAPPER_FILE_INFO           30050

//////////////////////////////////////////////////////////////////
// Mapper edit menu entries
#define ID_MAPPER_EDIT_CUT          31010
#define ID_MAPPER_EDIT_COPY         31020
#define ID_MAPPER_EDIT_PASTE        31030
#define ID_MAPPER_EDIT_DELETE       31040
#define ID_MAPPER_EDIT_SELECTALL    31050
#define ID_MAPPER_EDIT_DESELECTALL  31060
#define ID_MAPPER_EDIT_INVERTSEL    31070
#define ID_MAPPER_EDIT_UNDO_AUTO    31080

/////////////////////////////////////////////////////////////////
// Mapper options menu entries
#define ID_MAPPER_OPTIONS_PREFS     32000
#define ID_MAPPER_OPTIONS_FOLLOW    32010
#define ID_MAPPER_OPTIONS_CREATE    32020

/////////////////////////////////////////////////////////////////
// Mapper view menu entries
#define ID_MAPPER_VIEW_STATUSBAR    33000
#define ID_MAPPER_VIEW_TOOLS        33010
#define ID_MAPPER_VIEW_MODES        33020
#define ID_MAPPER_VIEW_MAIN         33030
#define ID_MAPPER_VIEW_LOWER	    33040
#define ID_MAPPER_VIEW_HIGHER	    33050
#define ID_MAPPER_VIEW_OVERVIEW	    33060
#define ID_MAPPER_VIEW_ALWAYS_ON_TOP 33070
#define ID_MAPPER_VIEW_SPEEDWALK    33080

///////////////////////////////////////////////////////////////////
// Mapper room context menu entries
#define ID_MAPPER_ROOM_MOVE_LOC     34000
#define ID_MAPPER_ROOM_MOVE_PLAYER  34010
#define ID_MAPPER_ROOM_DEL          34020
#define ID_MAPPER_ROOM_SET_LOGIN    34030
#define ID_MAPPER_ROOM_PROP	    34040
#define ID_MAPPER_ROOM_ADD_SPEED    34050

///////////////////////////////////////////////////////////////////
// Mapper path context menu entries
#define ID_MAPPER_PATH_DEL          35000
#define ID_MAPPER_PATH_ONEWAY       35010
#define ID_MAPPER_PATH_TWOWAY       35020
#define ID_MAPPER_PATH_ADDBEND      35030
#define ID_MAPPER_PATH_DELBEND      35040
#define ID_MAPPER_PATH_EDITBEND     35050
#define ID_MAPPER_PATH_PROP         35060

///////////////////////////////////////////////////////////////////
// Mapper text context menu entries
#define ID_MAPPER_TEXT_DEL          35100
#define ID_MAPPER_TEXT_PROP         35110

///////////////////////////////////////////////////////////////////
// Mapper zone context menu entries
#define ID_MAPPER_ZONE_DEL          35200
#define ID_MAPPER_ZONE_OPEN         35210
#define ID_MAPPER_ZONE_PROP         35220

//////////////////////////////////////////////////////////////////
// Mapper toolbars
#define ID_MAPPER_TOOLBAR_MAIN      0
#define ID_MAPPER_TOOLBAR_TOOLS     1
#define ID_MAPPER_TOOLBAR_MODES     2

//////////////////////////////////////////////////////////////////
// Mapper tools toolbar entries
#define ID_MAPPER_TOOL_SELECT       36000
#define ID_MAPPER_TOOL_CREATE_ROOM  36010
#define ID_MAPPER_TOOL_CREATE_PATH  36020
#define ID_MAPPER_TOOL_CREATE_TEXT  36030
#define ID_MAPPER_TOOL_DELETE       36050

#define ID_MAPPER_TOGGLE_GRID       36100
#define ID_MAPPER_TOOL_VIEW_CURENT  36110

/////////////////////////////////////////////////////////////////
// Level stuff
#define ID_MAPPER_LEVEL_NUM         37000
#define ID_MAPPER_LEVEL_UP	    37010
#define ID_MAPPER_LEVEL_DOWN        37020
#define ID_MAPPER_LEVEL_DEL	    37030
#define ID_MAPPER_TOOL_NEW_TOP      37040
#define ID_MAPPER_TOOL_NEW_BOTTOM   37050

/////////////////////////////////////////////////////////////////
// Zone stuff
#define ID_MAPPER_TOOL_ZONE_UP      38000
#define ID_MAPPER_TOOL_ZONE_PROP    38010

///////////////////////////////////////////////////////////////////
// General application values
#define ID_MAPPER_STATUS_MSG        39000
#define ID_MAPPER_STATUS_LEVEL      39010
#define ID_MAPPER_STATUS_ZONE       39020

///////////////////////////////////////////////////////////////////
// MACROS FOR THE CONNECT OF YOUR SIGNALS TO CORRESPONDENT SLOTS
// IN YOUR MAIN IMPLEMENTATION OF MENUBAR AND TOOLBAR


///////////////////////////////////////////////////////////////////
// MENU CONNECTS
#define CONNECT_CMD(submenu)           connect(submenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));connect(submenu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)))


///////////////////////////////////////////////////////////////////
// TOOLBAR CONNECT
#define CONNECT_TOOLBAR(ToolBar)        connect(ToolBar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));connect(ToolBar, SIGNAL(highlighted(int,bool)), SLOT(statusCallback(int)))

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function)   case id:cmd_class_function ;break;

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them to change statusBar entry
#define ON_STATUS_MSG(id, message)     case id:  slotStatusHelpMsg(message);break;

#endif // RESOURCE_H
