/***************************************************************************
                          bibtexfactory.h  -  description                              
                             -------------------                                         
    begin                : Fri Jul 28 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BIBTEXFACTORY_H
#define BIBTEXFACTORY_H

#include <qstring.h>

/**
  *@author Jan Mueller
  */

class BibTexFactory {
private:
	BibTexFactory& operator=(const BibTexFactory&);
	BibTexFactory(const BibTexFactory&);

public:
	BibTexFactory();
	~BibTexFactory();
	QString &article(QString entry,
									 QString author,
									 QString title,
									 QString journal,
									 QString year,
									 QString volume,
									 QString number,
									 QString pages,
									 QString month,
									 QString note,
									 QString key="",
									 QString crossref="");

	QString &book(QString entry,
								QString author,
								QString editor,
								QString title,
								QString publisher,
								QString year,
								QString volume,
								QString number,
								QString series,
								QString address,
								QString edition,
								QString month,
								QString note);

	QString &booklet(QString entry,
									 QString title,
									 QString author,
									 QString howpublished,
									 QString address,
									 QString month,
									 QString year,
									 QString note);

	QString &inbook(QString entry,
									QString author,
									QString editor,
									QString title,
									QString chapter,
									QString pages,
									QString publisher,
									QString year,
									QString volume,
									QString number,
									QString series,
									QString type,
									QString address,
									QString edition,
									QString month,
									QString note,
									QString key="",
									QString crossref="");

	QString &incollection(QString entry,
									 			QString author,
												QString title,
												QString booktitle,
												QString publisher,
												QString year,
												QString editor,
												QString volume,
												QString number,
												QString series,
												QString type,
												QString chapter,
												QString pages,
												QString address,
												QString edition,
												QString month,
												QString note,
												QString key="",
												QString crossref="");

	QString &inproceedings(QString entry,
									 			 QString author,
												 QString title,
												 QString booktitle,
												 QString year,
												 QString editor,
												 QString volume,
												 QString number,
												 QString series,
												 QString pages,
												 QString address,
												 QString month,
  											 QString organization,
												 QString publisher,
												 QString note,
												 QString key="",
												 QString crossref="");

	QString &manual(QString entry,
									QString title,
									QString author,
									QString organization,
									QString address,
									QString edition,
									QString month,
									QString year,
									QString note);

	QString &masterthesis(QString entry,
									 			QString author,
											  QString title,
												QString school,
												QString year,
												QString type,
												QString address,
												QString month,
												QString note);

	QString &misc(QString entry,
								QString author,
							  QString title,
								QString howpublished,
								QString month,
								QString year,
								QString note);

	QString &phdthesis(QString entry,
									 	 QString author,
									   QString title,
										 QString school,
										 QString year,
										 QString type,
										 QString address,
										 QString month,
										 QString note);

	QString &proceedings(QString entry,
									 		 QString title,
											 QString year,
											 QString editor,
											 QString volume,
											 QString number,
											 QString series,
											 QString address,
											 QString month,
											 QString organization,
											 QString publisher,
											 QString note);

	QString &techreport(QString entry,
									 		QString author,
										  QString title,
											QString institution,
											QString year,
											QString address,
											QString type,
											QString number,
											QString month,
											QString note);

	QString &unpublished(QString entry,
									 		 QString author,
										   QString title,
											 QString note,
											 QString month,
											 QString year);
	QString &getEntry() { return bt; }

protected:
	QString bt;

	void addAddress(QString &a) { bt+=",\naddress=\""+a+"\""; }
	void addAuthor(QString &a) { bt+=",\nauthor=\""+a+"\""; }
	void addBooktitle(QString &b) { bt+=",\nbooktitle=\""+b+"\""; }
	void addChapter(QString &c) { bt+=",\nchapter=\""+c+"\""; }
	void addEdition(QString &e)  { bt+=",\nedition=\""+e+"\""; }
	void addEditor(QString &e) { bt+=",\neditior=\""+e+"\""; }
	void addHowpublished(QString &h) { bt+=",\nhowpublished=\""+h+"\""; }
	void addInstitution(QString &i)  { bt+=",\ninstitution=\""+i+"\""; }
	void addJournal(QString &j) { bt+=",\njournal=\""+j+"\""; }
	void addMonth(QString &m) { bt+=",\nmonth=\""+m+"\""; }
	void addNote(QString &n) { bt+=",\nnote=\""+n+"\""; }
	void addNumber(QString &n)  { bt+=",\nnumber="+n; }
	void addOrganization(QString &o)  { bt+=",\norganization=\""+o+"\""; }
	void addPages(QString &p)  { bt+=",\npages=\""+p+"\""; }
	void addPublisher(QString &p)  { bt+=",\npublisher=\""+p+"\""; }
	void addSchool(QString &s)  { bt+=",\nschool=\""+s+"\""; }
	void addSeries(QString &s)  { bt+=",\nseries=\""+s+"\""; }
	void addTitle(QString &t)  { bt+=",\ntitle=\""+t+"\""; }
	void addType(QString &t)  { bt+=",\ntype=\""+t+"\""; }
	void addVolume(QString &v)  { bt+=",\nvolume="+v; }
	void addYear(QString &y)  { bt+=",\nyear="+y; }
	void addKey(QString &k)  { bt+=",\nkey=\""+k+"\""; }
	void addCrossRef(QString &c)  { bt+=",\ncrossref=\""+c+"\""; }
};

#endif













