/*
 * kheise.h
 *
 * Copyright (c) 1998 Michael Kropfberger <mkropfbe@edu.uni-klu.ac.at>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef _KHEISE_H
#define _KHEISE_H

#include <qapp.h>
#include <qpushbt.h>
#include <qscrbar.h>
#include <qlcdnum.h>
#include <qfont.h>

#include <ktopwidget.h>
#include <kstdaccel.h>
#include <kiconloader.h>

#include "heisedlg.h"

class MyMainWidget : public KTopLevelWidget {
   Q_OBJECT

  public:
    MyMainWidget(QWidget *parent=0,const char *name=0);
    ~MyMainWidget();

 signals:
   void startSearch();
   void stopSearch();
   void searchDone();
 
  private slots:
    void fileMenuNewSlot();
    void fileMenuUpdateDBSlot();
    void fileMenuQuitSlot();
  
  // these slots invoke the underlying HeiseDlg-Slots
    void startSearchSlot();
    void stopSearchSlot();
    void searchDoneSlot();

  private:
    int winID;
    KMenuBar     *menuBar;
    QPopupMenu   *fileMenu, *searchMenu;
    KToolBar     *toolBar;
    int          updateMenuEntryID;
    int          startButtonID, stopButtonID,
                 startMenuEntryID, stopMenuEntryID;
    KStatusBar   *statusBar;
    bool         searchInterrupted;
    
    HeiseDlg *heiseDlg;


  protected:
    static QList<MyMainWidget> windowList;
    void closeEvent ( QCloseEvent *ev);
  
};

#endif /* ifdef _KHEISE_H */
