// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.



#ifndef KROT_EXCEPTION_H
#define KROT_EXCEPTION_H


#include <string>



/**
 * @short KRot exception base class
 *
 * This is the base class of all exception types in KRot.
 *
 * This class has no functionality yet. Still every exception has to be derived
 * from this class, so we can easily add functionality common to all exceptions
 * later on.
 *
 * @author Jochen Kpper
 * @version 1999/02/07
 */
struct KRotException
{
};



/**
 * @short Exception IOError
 *
 * This exception or one of its derived classes are thrown whenever a
 * I/O operation failed. You should try to derive more specific childs.
 *
 * @author Jochen Kpper
 * @version 1999/02/10
 */
struct IOError : KRotException
{
};




/**
 * @short Exception UnknownFileType
 *
 * Thrown when a file operation on an unknown type is requested.
 *
 * @author Jochen Kpper
 * @version 1999/02/11
 */
struct UnknownFileType : KRotException
{
};



/**
 * @short Exception FileNotFound
 *
 * This exception is thrown whenever an file-I/O operation failed because the
 * specified file could not be opened due to the lack of itself ( on read )
 * or some dir ( read or write ).
 *
 * @author Jochen Kpper
 * @version 1999/02/10
 */
struct FileNotFound : IOError
{
public:
    
    FileNotFound( const string& file ) : IOError() { _name = file; };

    string filename() { return _name; };

private:
    string _name;
};



#endif



//* Local Variables:
//* c-file-style: "Stroustrup"
//* mode: C++
//* End:
