#include <qfiledlg.h>
#include <qmsgbox.h>
#include <qpopmenu.h>

#include "worksheet.h"
#include "export.h"

#include "export.moc"


/*
 *   Export Filter base class initialization module:
 *
 *
 *   Because of trouble defining these variables inside the headerfile
 *   they will be defined here. In the headerfile export.h they are
 *   only declared extern
 *
 *
 *   Written for the KOrigin project by
 *
 *   (C) 1997 by Martin Hfner  
 *
 */


// ***************************************************************************


void runExportFilters::exportTable (int i)
{
  exportFilterList().at(i)->exportToFile();
}


void runExportFilters::exportOptions (int i)
{
  exportFilterList().at(i)->getOptionsSlot();
}


static runExportFilters run;


// ***************************************************************************


ExportFilterList& exportFilterList ()
{
  static ExportFilterList theList;
  return theList;
}


QPopupMenu* exportFilter::getExportOptionsPopup ()
{
  QPopupMenu* exportOptions = new QPopupMenu();

  exportFilter* iter;

  for (iter=exportFilterList().first(); iter!=0; 
	   iter=exportFilterList().next())
    exportOptions->insertItem(iter->getDescription().data());

  QObject::connect (exportOptions, SIGNAL (activated (int)), &run, 
		    SLOT (exportOptions (int)));

  return exportOptions;
}


QPopupMenu* exportFilter::getExportFilterPopup ()
{
  QPopupMenu* export = new QPopupMenu();

  exportFilter* iter;

  for (iter=exportFilterList().first(); iter!=0; 
	   iter=exportFilterList().next())
    export->insertItem(iter->getDescription().data());

  QObject::connect (export, SIGNAL (activated (int)), &run, 
		    SLOT (exportTable (int)));

  return export;
}


void exportFilter::exportToFile ()
{
  if (activeWS == 0)
    {
      QMessageBox::warning (0,"Error: Can\'t Export","Before you can export "\
			    "anything, you must have opened\na worksheet, of"\
			    " course. (Say, you are a scientist???)");
      return;
    }

  QString filename;
  QFileDialog* filedlg;
  filedlg = new QFileDialog(0, getFileFilter(), 0, "", TRUE);

  QString capt = QString ("Export ");
  capt += getDescription();
  filedlg->setCaption(capt);
  filedlg->setDir((const char*)getLatestDirectory());
  
  int result = filedlg->exec ();
  filename = filedlg->selectedFile();
  
  if (result == 1)
    {
      writeTable ( (const char*)filename, activeWS->getTable() );
      setLatestDirectory (filedlg->dirPath ());
    }
  
  delete filedlg;
}
