//
// Copyright (C) 1999, Mark W J Redding <grawlfang@tesco.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

//

#ifndef _KONSTELLATION_INCLUDE
#define _KONSTELLATION_INCLUDE

#include <qwidget.h>
#include <qlist.h>
#include <qpixmap.h>
#include <qscrollview.h>
#include <qslider.h>
#include <qlabel.h>

#include <kapp.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <kstatusbar.h>

#include "mapView.h"
#include "StarDetails.h"

class
Konstellation : public KTopLevelWidget
{
private:
	Q_OBJECT

	double m_scale,m_mag;
	long m_bscat,m_bslast;
	long m_undo_bscat,m_undo_bslast;

	StarDetails* sd;

	KStatusBar* m_StatusBar;

	QScrollView* sView;
	QLabel* lZoom;
	QLabel* lMag;
	QSlider* sZoom;
	QSlider* sMag;

	KMenuBar* m_Menu;
	QPopupMenu* m_FileMenu;
	QPopupMenu* m_ViewMenu;
	QPopupMenu* m_HelpMenu;

	int m_gm_undo,m_gm_exit;
	int m_vm_fmap;
	int m_hm_about;

	mapView *currView;

public:
	Konstellation(QWidget*, const char*);
	~Konstellation();
	void locate(double,double);
	void centre(int,int);
	void countStars(int);
	void showPosition(mapView*);
	void showStar(long,int,int);

private:
	void setupMenu();
	void setupStatusBar();
	void cleanView();

protected:
	void resizeEvent(QResizeEvent*);
	void closeEvent(QCloseEvent*);
	void paintEvent(QPaintEvent*);

signals:
	void quit();

public slots:
	void exitKonst();
	void helpAbout();
	void setZoom(int);
	void setMagnitude(int);
	void fullMap();
	void showDetail();
	void hideDetails();
	void connectUp();
	void undoConnect();
};

#endif

