# -*- Mode: makefile  -*-
#
# SUMMARY:      
# USAGE:        make <make-target>
#
# AUTHOR:       Prud'homme Christophe
# ORG:          
# E-MAIL:       prudhomm@ann.jussieu.fr
#
# ORIG-DATE:     June-94
# LAST-MOD:      7-Dec-95 at 10:50:02 by Prud'homme Christophe	
#
# DESCRIPTION:  
# DESCRIP-END.	
#
# Makefile for freefem 
#
# change this makefile accordingly to your system
# then do  make -f makefile.x 
#
# suffix .cpp used for the c++ sources because of the PC version.  If you
# have problems then rename all files .C and remove line below
.SUFFIXES:	 .cpp

# Things that may need to be changed: 
# the compiler name (here g++)
# the location of the X11 librairy
# if you have problem with the link then notice that our #include are with <..>
# instead of "..".  You may revert to ".." but it's in all .cpp files.

export CXX 	= g++
export CXXFLAGS	= -O2 -g 
export CXXINC	= -I./ -I/usr/X11/include
export CXXLIBS	= -L/usr/X11/lib -lX11 -lm 
 

#          NO NEED TO CHANGE THE MAKEFILE AFTER THIS
##################################################

# sources
OBJS =  gibbs.o triangul.o lexical.o ugraph.o disk.o xrgraph.o syntaxic.o fem.o opclass.o fem1.o fem1c.o

freefem      :$(OBJS) 
	$(CXX)  -o $@ $(OBJS) $(CXXLIBS)

.cpp.o:
	$(CXX) $(CXXFLAGS) $(CXXINC) -c $< 

### dependencies
opclass.o: opclass.h
xrgraph.o: rgraph.h disk.h lexical.h syntaxic.h
compil.o: disk.h triangul.h opclass.h rgraph.h syntaxic.h lexical.h
disk.o: disk.h triangul.h opclass.h rgraph.h
fem1.o: opclass.h triangul.h
fem.o: triangul.h opclass.h syntaxic.h lexical.h disk.h rgraph.h fem.h fem1.h
gibbs.o: triangul.h opclass.h rgraph.h
lexical.o: rgraph.h triangul.h opclass.h lexical.h
syntaxic.o: syntaxic.h triangul.h opclass.h lexical.h ugraph.h rgraph.h disk.h fem.h
triangul.o: triangul.h opclass.h rgraph.h gibbs.h
ugraph.o: triangul.h opclass.h ugraph.h rgraph.h
