/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _verticeT1_h
#define _verticeT1_h

#include <header.hxx>
#include <r2.hxx>
#include <t_t0.hxx>
#include <metric.hxx>

class Triangulo_T1;
struct Vertice_T1_dlink;
struct Arista_CAD_dlink;
class Vertice_T1 {
  friend ostream& operator<<(ostream&, Vertice_T1&);
public:
  R2             c;    // Coordenadas.
  int          ref;    // Referencia.
  Triangulo_T1*  t;    // Triangulo que lo contiene en el
                       // mallado T1;
  Boolean   front;     // TRUE si esta en la frontera.
  Boolean   inters;    // TRUE si un vertice se encuentra en una
                       // interseccion de superficies.
                       // Otros punteros para la busqueda.
  Boolean   fluid;     // True si vertice proximo a la pared.
  Triangulo_T0* t0;    // Triangulo que lo contiene en el
                       // mallado T0 o mallado definicion
                       // de la metrica.
  Metrica       mtr;   // Metrica calculada en ese nodo..
  Vertice_T1_dlink* lk;// Link que lo contiene en la lista
                       // doble
  Arista_CAD_dlink*  a;// Arista CAD dlink.
  Vertice_T1 (): c(),ref(0),mtr(){
    t=NIL;t0=NIL; lk=NIL;inters=FALSE;front=FALSE;fluid=FALSE; a=NIL;}
  Vertice_T1 (Scalar xx, Scalar yy, Scalar zz=0, int reff=0):
    c(xx,yy),ref(reff),mtr() {
      t=NIL; t0=NIL; lk=NIL;
      inters=FALSE; front=FALSE;fluid=FALSE; a=NIL;
  }
  Vertice_T1 (const R2& cc, int reff): c(cc),ref(reff),mtr() {
    t=NIL; t0=NIL; lk=NIL; inters=FALSE;front=FALSE;fluid=FALSE; a=NIL;}
  Vertice_T1 (const R2& cc, int reff,Triangulo_T1* tt):
    c(cc),ref(reff),mtr() {
      t=tt;t0=NIL;lk=NIL; inters=FALSE;front=FALSE;fluid=FALSE; a=NIL;}
  Vertice_T1 (const R2& cc, int reff,Triangulo_T1* tt,Triangulo_T0* tt0):
    c(cc),ref(reff),mtr() {
      t=tt; t0=tt0; lk=NIL; inters=FALSE;front=FALSE;fluid=FALSE; a=NIL;}
  Vertice_T1 (const Vertice_T1& ss): c(ss.c),ref(ss.ref) {
    t=ss.t; t0=ss.t0; lk=ss.lk; front=ss.front;
    inters=ss.inters; mtr=ss.mtr;fluid=ss.fluid; a=ss.a;
  }

  void write(ostream&);

  void set (const R2& cc, int reff) {
    c=cc;
    ref=reff;
    t=NIL; t0=NIL; lk=NIL; inters=FALSE;front=FALSE;}
  void set (Scalar xx, Scalar yy, Scalar zz, int reff) {
    c.set(xx,yy);
    ref=reff;
    t=NIL; t0=NIL; lk=NIL;
    inters=FALSE;front=FALSE;
  }
  void set (const Vertice_T1& ss){
    c=ss.c;
    ref=ss.ref;
    t=ss.t; t0=ss.t0; lk=ss.lk;
    inters=ss.inters; front=ss.front;a=ss.a;
  }
  void set (const R2& cc,int reff,Triangulo_T1* tt) {
    c=cc; ref=reff;
    t=tt; t0=NIL; lk=NIL;
    inters=FALSE; front=FALSE;
  }
  void set (const R2& cc,int reff,Triangulo_T1* tt,
	    Triangulo_T0* tt0) {
    c=cc;
    ref=reff;
    t=tt; t0=tt0; lk=NIL;
    inters=FALSE;front=FALSE;
  }
  void set (const R2& cc,int reff,Boolean frontera,Triangulo_T1* tt,
	    Triangulo_T0* tt0) {
    c=cc;
    ref=reff;
    t=tt; t0=tt0;  lk=NIL;
    inters=FALSE;front=frontera;
  }
  void set_lk(Vertice_T1_dlink* llk) {
    lk=llk;
  }   
  int operator==(const Vertice_T1& ss) {
    int v=0;
    if (c==ss.c) v=1;
    return v;
  }
  Vertice_T1& operator=(const Vertice_T1& ss) {
    c=ss.c;
    ref=ss.ref;
    t=ss.t;
    t0=ss.t0;
    lk=ss.lk;
    inters=ss.inters;
    front=ss.front;
    mtr=ss.mtr;
    fluid=ss.fluid;
    a=ss.a;
    return *this;
  }
};


#endif
