/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _carete_h
#define _carete_h

 struct int_link {
     int  pos;
     int_link* suc;

     int_link () {pos=0; suc=NIL;}
     int_link (const int& pp, int_link* nn) {pos=pp; suc=nn;}

     void set(const int& pp , int_link* nn) {pos=pp; suc=nn;}
     int_link* sig () {return suc;}
  };
 

  class int_list {

     int_link* last;
     int_link* begin;
     
     
  public:
     int_list () {last=NIL;begin=NIL;}
     int_list (int_link* a) {last=begin=a;}
     void insert(int_link* a) {  //pega al principio de la lista.
             if (begin) {
               a->suc=begin;
               begin=a; 
             }
             else {
               last=a;
               begin=a;
             }
          }
     void append(int_link* a) {  //pega al final de la lista.
             if (last) {
               last->suc=a;
               last=a;
             }
             else {
               last=a;
               begin=a;
             }
          }
     int_link* principio() {return begin;}         
     int_link* fin() {return last;}
     int num_elem() {
           int num=0;
           int_link* aux=begin;
              while (aux) {
                 num++;
                 aux=aux->suc;
              }
           return num;
         }

     void clear() {
               int_link* aux;
               while(begin) {
                 aux=begin->suc;
                 delete begin;
                 begin=aux;
               } 
            last=begin=NIL;
          }
     
     void operator delete (void* p)
      { 
        if (p) {
          ((int_list*)p)->clear();
          delete p; p=NIL;
        }
      }              

 };

#endif
