/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr)
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */



#include <header.hxx>
#include <params.hxx>
#include <triangl.hxx>

extern Scalar*  lecsol(char*,int,int&);

Scalar* read_param(Triangulation* t_cad, Triangulation* t_ini,parameter& param) {
  struct Mesh_characteristic* ch_mesh;
  Scalar* solution=NIL;
  char timmtr0[72];
  char timcad[72];
  char nombre_sol[72];
  char timesh[72];
  char sol_interp[72];
  char timtr[72];
  char c;
  int err,ii;

  cout<<"==================================================="<<endl;
  cout<<"                  FILENAME DATA:"<<endl;
  cout<<"==================================================="<<endl;
  cout<< "CAD Mesh file (format .am_fmt -- without .am_fmt extension): ";
  do { cin.get(timcad,62,'\n');
  }while (cin.get(c) && c!='\n');
  cout<<endl;
  cout <<"Mesh file (fomat .am_fmt -- without .am_fmt extension): ";
  do { cin.get(timmtr0,62,'\n');
  }while (cin.get(c) && c!='\n');
  cout<<endl;
  cout <<"Solution over mesh(1=yes/0=no):";
  do { cin>>ii;
  } while (ii!=0 && ii!=1);
  cin.get(c);
  param.sol=Boolean(ii);
  cout<<endl;
  if (param.sol==1) {
    cout<<"Solution file ( format .bb -- without .bb extension): ";
    do { cin.get(nombre_sol,62,'\n');
    } while (cin.get(c) && c!='\n');
    cout<<endl;
    strcpy(param.timtr,"metric.mtr");
  }
  else {
    cout<<" Metric filename:";
    do { cin.get(timtr,62,'\n');
    }while (cin.get(c) && c!='\n');
    cout<<endl;
    strcpy(param.timtr,timtr);
  }  
  cout <<"Adapted mesh file (format .am_fmt -- without .am_fmt extension): ";
  do { cin.get(timesh,62,'\n');
  }while (cin.get(c) && c!='\n');
  cout<<endl;
  strcpy(param.timesh,timesh);
  if (param.sol==1) {
    cout<<"Interpolated solution file (format .bb -- without .bb extension): ";
    do { cin.get(sol_interp,62,'\n');
    } while (cin.get(c) && c!='\n');
    cout<<endl;
    strcpy(param.sol_interp,sol_interp);
    cout<<"    1=P1  -- 2=Local P1 (L2 norm)  -- 3=Global P1 (L2 norm) -- 4=Local P1 (L1 norm)"<<endl;
    cout<<"Interpolation operator:";
    do { cin>>param.tinterp;
    }while (param.tinterp < 1 || param.tinterp>4);
    cin.get(c);
    cout<<endl;
  }
  /*      read:     
   *     CAD mesh (t_cad) 
   *     Mesh to be adapted (t_ini)
   *     Solution (if sol=1);
   */
  strcat(timcad,".am_fmt");     
  err=t_cad->build(timcad);
  if (err) { cerr<<"Error in Triangulation::build"; exit(1);};

  strcat(timmtr0,".am_fmt");     
  err=t_ini->build(timmtr0);
  if (err) { cerr<<"Error in Triangulation::build"; exit(1);};
  if (param.sol==1) { 
    strcat(nombre_sol,".bb");
    solution=lecsol(nombre_sol,int(t_ini->np),param.nsol);
  }  
  ch_mesh=t_ini->characteristic();
  param.scale=ch_mesh->scale;
  if (param.scale>5e+3) param.scale=5e+3;
  if (param.sol==1) {
    cout<<" ===================================================="<<endl;
    cout<<"            METRIC COMPUTATION PARAMETERS: "<<endl;
    cout<<" ===================================================="<<endl;
    cout<<endl<<endl;
    cout<<"       Mesh characteristics"<<endl;
    cout<<"       --------------------"<<endl;
    cout<<"N. vertices:"<<t_ini->np<<"    N. triangles:"<<t_ini->nt<<endl<<endl;
    
    cout<<"    Mesh box"<<endl \
        <<"    --------"<<endl;
    cout<<ch_mesh->df[0]<<endl<<ch_mesh->df[1]<<endl<<endl;
    
    cout<<"Smallest edge length:"<<ch_mesh->ed_min<<endl;
    cout<<"Largest edge length :"<<ch_mesh->ed_max<<endl;
    cout<<"Scale factor        :"<<ch_mesh->scale<<endl<<endl<<endl;

    do {
      cout<<"Number approximated of triangles to be generated (0 == no imposition):"; 
      cin>>param.nbt_max;
    } while (param.nbt_max<0); 
    cout<<endl;
    do {
      cout<<"Error Tolerance:"; 
      cin>>param.err0;
    } while (param.err0<=0);
    cout<<endl;
    do {
      cout<<"Minimal edge length:"; 
      cin>>param.lmin;
    } while (param.lmin<=0);
    cout<<endl;
    do {
      cout<<"Maxmial edge length:"; 
      cin>>param.lmax;
    } while (param.lmax<=0);
    cout<<endl;
    do {
      cout<<"Anisotropic mesh (0=no;1=yes):"; 
      cin>>ii;
    } while (ii!=0 && ii!=1);
    cout<<endl;
    param.aniso=Boolean(ii);
    do {
      cout<<"Wall prescribed h in the normal direction (0=no imposition):"; 
      cin>>param.hwall;
    } while (param.hwall<0.0 || param.hwall>param.lmax);
    cout<<endl;
    do {
      cout<<"Wall node's reference:"; 
      cin>> param.refwall;
    } while (param.refwall<=0);
  }  
  cout<<" ===================================================="<<endl;
  cout<<"               MESH ADAPTATION PARAMETERS: "<<endl;
  cout<<" ===================================================="<<endl;
  
  cout <<"Corner indentification angle (No corners=0): ";
  do {
    cin>>param.angulo;
  } while (param.angulo<0 || param.angulo>180);
  cout<<endl;
  if (param.angulo==0) {
    param.angulo=360;
  }
  cout<<"Number of adaptation iterations (0= by default, negative=hard impostion): ";
  do {
    cin>>param.nit;
  } while (param.nit<-999 || param.nit>999);
  cout<<endl;
  do {
    cout<<"copy of security at each iteration (1=yes/0=no): ";
    cin>>ii;
  }
  while(ii!=0 && ii!=1); 
  param.segur=Boolean(ii);
  do {
    cout<<"Initial regularization (1=yes;0=no): ";
    cin>>ii;
  }while(ii!=0 && ii!=1);
  param.reg_ini=Boolean(ii); 
  do {
    cout<<"Final regularization (Attention: Expensive!!! 1=yes;0=no): ";
    cin>>ii;
  }
  while(ii!=0 && ii!=1);
  param.reg_fin=Boolean(ii);
  do {
    cout<<"Metrix relaxation (Attetion: Expensive!!! 1=yes;0=no): ";
    cin>>ii;
  }
  while(ii!=0 && ii!=1);
  param.rel_mtr=Boolean(ii);
  if (param.sol==1) {
    do {
      cout<<"Hard imposition of wall metrics in NS EQ.(1=yes/0=no): ";
      cin>>ii;
    }
    while(ii!=0 && ii!=1);
    param.fluid_NS=Boolean(ii);
  }
  else
    param.fluid_NS=0;
  return solution;
}
