/***************************************************************************
                          btextabbild.cpp  -  description
                             -------------------
    begin                : Sun Jan 23 2000
    copyright            : (C) 2000 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qfile.h>
#include <math.h>

#include "btextabbild.h"
#include "bhebbuch.h"
#include "bhebidx.h"
#include "bitana.h"
#include "blexikon.h"

#include "iostream.h"

#define STRSEPL "\t "
#define STRSEP  "\t"

BTextAbbild::BTextAbbild()
{
 _cod=new BHebBuch();
 _idx=new BHebIdx();
 _stop=false;
}

BTextAbbild::~BTextAbbild()
{
}

bool BTextAbbild::abbild(QString buch, QString wo, int bpos,
                         int inter, bool le)
{
 extern BitanaApp *bitana;

 QString wort(wo);
 QFile a1;
 QDir d=QDir::root();
 if(d.cd(bitana->getTmpDir())) a1.setName(d.filePath("abb1.lst"));
 else
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("Cannot find the working directory\n")+bitana->getTmpDir());
  return false;
 }
 a1.remove();

 _cod->modifiWort(wort);
 QString wort2=_cod->textUmkehr(wort);
 _anzbu=wort.length();
 if(_anzbu<3)
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("You have not given (or to short) input word."));
   return false;
 }
 if(_cod->lngBuch(buch)-(_anzbu*inter)<(uint)bpos)
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("You have given wrong startposition."));
  return false;
 }
 if(inter>1000)
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("You have given wrong linelengh.\nThe maximal lenght is 1000."));
   return false;
 }

// Open the files to write
 if (!a1.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Error"),
                          i18n("Cannot create the file\n abb1.lst"));
 }

// Create text area
 int beg;
 int end;

 _inter=inter;
 if(inter<8 && _anzbu<10) _zlbrt=ZLBRT;
 else _zlbrt=inter;
 int suwrtpos=beg=bpos;
 end=bpos+((_anzbu-1)*inter);
 while((uint)end>_cod->lngBuch(buch)) end=_cod->lngBuch(buch);
 _endsuwrt=end;

 int anzl=1+((end-beg)/_zlbrt);
 beg=beg-(((ANZZL-anzl)/2)*_zlbrt);
 if(_zlbrt>ZLBRT) beg=beg-(_zlbrt-(ZLBRT/2));
 else beg=beg-(_zlbrt/2);
 while(beg<0) beg+=inter;

 if((beg+(ANZZL*_zlbrt))>end) end=beg+(ANZZL*_zlbrt);
 if((uint)end>_cod->lngBuch(buch)) end=(int)_cod->lngBuch(buch);
 _begpos=beg;
 _endpos=end;

// Headline for list
 QString tabstr("");;
 QString zeile("");;
 QString tmp("");
 QTextStream tab(&a1);

 tab<<"# Matrix"<<endl;
 if(_zlbrt>ZLBRT) tmp.setNum(ZLBRT);
 else tmp.setNum(_zlbrt);
 tab<<"# "<<tmp<<SEP;
 tmp.setNum((end-beg)/_zlbrt);
 tab<<tmp<<endl;
 tmp=buch.upper();
 tabstr=i18n("# Textshowing");
 tab<<tabstr<<tmp;
 tabstr=i18n(" with line length ");
 tmp.setNum(_zlbrt);
 tab<<tabstr<<tmp;
 if(_zlbrt>ZLBRT)
 {
  tabstr=i18n(" and presentation by ");
  tab<<tabstr<<ZLBRT;
 }
 tab<<endl;
 tabstr=i18n("# From position ");
 tmp.setNum(beg);
 tab<<tabstr<<tmp<<" (";
 _idx->posKap(buch, beg);
 tmp=_idx->versdat.kapvers;
 tab<<tmp.left(6)<<")";
 tabstr=i18n(" to position ");
 tmp.setNum(end);
 tab<<tabstr<<tmp<<" (";
 _idx->posKap(buch, end);
 tmp=_idx->versdat.kapvers;
 tmp+=")";
 tab<<tmp.left(6)<<")"<<endl;

// Read the text and write the list
 int lfd=beg;
 int z=_zlbrt;
 int p=0;
 int c,e;
 uint b=0;
 bool ok;
 int a=_anzbu;

 while(lfd<end)
 {
  if(lfd+z>end) z=end-lfd;
  ok=_cod->lesTextRevers(buch, lfd, z);
  if(!ok) return false;
  if(z<_zlbrt) _cod->text=_cod->text.rightJustify(_zlbrt,' ');
  e=0;
  while(bpos<lfd+z)
  {
   p=(lfd+z)-bpos-1;
   c=(int)_cod->text[p];
   if(c==-22) c++;
   if(c==-19) c++;
   if(c==-17) c++;
   if(c==-13) c++;
   if(c==-11) c++;
   if(c!=(int)wort[b] && c!=(int)wort2[b])
   {
    QMessageBox::warning(0,i18n("Error"),
                           i18n("Searchword not on position"));
    return false;
   }
   b++;
   _cod->text=_cod->text.insert(p,"\t3");
   e+=2;
   a--;
   if(a>0) bpos=bpos+inter;
   else bpos=999999;
  }
  lfd=lfd+_zlbrt;
  if(_zlbrt>ZLBRT) _cod->text=_cod->text.left(ZLBRT+e);
  tab<<_cod->text<<endl;
 }
 a1.close();
 if(!le) return true;

// Begin search in lexica
 delete _idx;

// Preparative for search words in dictionary
 _lex=new BLexikon();
 sor=new GEF[502];

// Create datafield
 anzl=(_endpos-_begpos)/_zlbrt;
 if(_zlbrt<ZLBRT) z=_zlbrt;
 else z=ZLBRT;
 _daten=new char[anzl*z];


 div_t erg=div((suwrtpos-_begpos),inter);
 _begsuwrt=(erg.quot*z)+erg.rem;
 _endsuwrt=_begsuwrt+((_anzbu-1)*z);
 _begfldpos=0;
 _endfldpos=0;
 _anzzl=0;

// Write datafield
 lfd=_begpos;
 while(lfd<_endpos)
 {
  if(lfd+z>end+1) z=end-lfd+1;
  ok=_cod->lesText(buch, lfd, z+1);
  for(c=0;c<z;c++)
  {
   _daten[_endfldpos]=_cod->text.at(c);
   _endfldpos++;
  }
  _anzzl++;
  lfd+=_zlbrt;
 }
 _endfldpos--;

 delete _cod;

// Delete the old version output file abb2
 QFile a2;
 d=QDir::root();
 if(d.cd(bitana->getTmpDir())) a2.setName(d.filePath("abb2.lst"));
 else
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("Cannot find the working directory\n")+bitana->getTmpDir());
  return false;
 }
 a2.remove();

 if(_zlbrt>ZLBRT) _zlbrt=ZLBRT;         // New definition linelength

 ok=startSuche();

 delete _daten;
 if(!ok) return false;

// Open the output file abb2
 if (!a2.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a2.name());
 }
 QTextStream as(&a2);

// Make headline for list
 as<<"# Tabelle"<<endl;
 as<<i18n("# \t6\tDistance\t72\tPosition\t56\tELS\t40\tD\t25\tText hebrew\t160\t  Text english \t295")<<endl;
 as<<i18n("# Neighbour words to ")<<wort;
 as<<i18n(" with ELS ");
 tmp.setNum(inter);
 as<<tmp;
 as<<i18n(" from position ");
 tmp.setNum(suwrtpos);
 as<<tmp<<endl;
 as<<"# "<<_anzgef<<i18n(" words find, ")<<i18n("maximal listwords = 500")<<endl;

 int anbu;
 int m,n;


 for(int i=0;i<_anzwrt;i++)
 {
  anbu=0;
  while(sor[i].heb[anbu]!=0) anbu++;
  wort="";
  zeile="";
  if(sor[i].abst<1.0) sor[i].abst=0;
  for(n=0;n<anbu;n++) wort.insert(n,sor[i].heb[n]);    // Reconstruct searchword
  zeile=_lex->findWort(wort,0);
  if(zeile.at(0)!=49 && zeile.at(0)!=50 && zeile.at(0)!=51) // Create list line
  {
   tmp.setNum(sor[i].abst);
   as<<tmp<<STRSEP;
   tmp.setNum(sor[i].pos);
   as<<tmp<<STRSEP;
   tmp.setNum(sor[i].seq);
   as<<tmp<<STRSEP<<sor[i].la<<sor[i].ri<<STRSEP;
   tmp=_lex->txtUmkehr(wort);
   as<<tmp<<STRSEP;
   m=0;
   for(n=0;n<(int)zeile.length();n++) if(zeile.at(n)==10) m++; // Number of words
   while(zeile.at(0)!=10) zeile=zeile.right(zeile.length()-1);
   zeile=zeile.right(zeile.length()-1);
   anbu=0;
   while(zeile.at(anbu)!=10) anbu++;
   wort="";
   for(n=0;n<anbu;n++) wort.insert(n,zeile.at(n));    // Reconstruct findword
   as<<wort<<endl;
   m-=2;
   while(m>0)
   {
    for(n=0;n<6;n++) as<<STRSEPL;
    while(zeile.at(0)!=10) zeile=zeile.right(zeile.length()-1);
    zeile=zeile.right(zeile.length()-1);
    anbu=0;
    while(zeile.at(anbu)!=10) anbu++;
    wort="";
    for(n=0;n<anbu;n++) wort.insert(n,zeile.at(n));    // Reconstruct findword
    as<<wort<<endl;
    m--;
   }
  }
 }

 delete _lex;

 a2.close();
 return true;
}

bool BTextAbbild::startSuche()
{
 int maxint;
 int zlpro;

 extern BitanaApp *bitana;
  _stop = false;
  connect(bitana, SIGNAL(signalStop()), this, SLOT(slotStop()));

 zlpro=_anzzl+_zlbrt+(2*(_zlbrt-4+_anzzl-4));
 bitana->progressStart(zlpro, i18n("Searching words ..."));
 zlpro=0;

 _anzwrt=0;
 _anzgef=0;

// Begin search words in line's
 maxint=_zlbrt/4;
 _lfdzl=0;
 _fak=1;
 _faki=1;
 gef.la='W';
 while(_lfdzl<_anzzl)
 {
  zlpro++;
  bitana->progressStep(zlpro);
  _lfdint=1;
  while(_lfdint<=maxint)
  {
   for(int i=0;i<MAXBRT;i++) _text[i]=0;
   _lfdch=0;
   _anzchar=0;
   while(_lfdch<_zlbrt)       // Create character line
   {
    _text[_anzchar]=_daten[_lfdzl*_zlbrt+_lfdch];
    _anzchar++;
    _lfdch+=_lfdint;
   }
   _beglfdzl=(_lfdzl*_zlbrt);
   bool ok=_check();
   if(!ok || _stop)
   {
    bitana->progressEnd();
    return false;
   }
   _lfdint++;
  }
  _lfdzl++;
 }

// Begin search words in colum's
 maxint=_anzzl/4;
 _lfdzl=0;
 _lfdch=0;
 if(_inter>ZLBRT) _faki=_inter;
 else _faki=ZLBRT;
 _fak=_zlbrt;
 gef.la='S';
 while(_lfdch<_zlbrt)
 {
  _lfdint=1;
  zlpro++;
  bitana->progressStep(zlpro);
  while(_lfdint<=maxint)
  {
   for(int i=0;i<MAXBRT;i++) _text[i]=0;
   _lfdzl=0;
   _anzchar=0;
   while(_lfdzl<_anzzl)       // Create character line
   {
    _text[_anzchar]=_daten[_lfdzl*_zlbrt+_lfdch];
    _anzchar++;
    _lfdzl+=_lfdint;
   }
   if(_stop)
   {
    bitana->progressEnd();
    return false;
   }
   _beglfdzl=_lfdch;
   _check();
   _lfdint++;
  }
  _lfdch++;
 }

// Begin search words in diagonal from left to right
char zw[MAXBRT];
int  pos;
int  lng;
div_t erg;

 _lfdzl=0;
 _lfdch=3;
 if(_inter>ZLBRT) _faki=_inter-1;
 else _faki=ZLBRT-1;
 _fak=_zlbrt-1;
 gef.la='R';
 while(_lfdch<_zlbrt && _lfdzl<_anzzl-3)
 {
  zlpro++;
  bitana->progressStep(zlpro);

  pos=_lfdch+(_lfdzl*_zlbrt);
  for(int i=0;i<MAXBRT;i++) zw[i]=0;
  lng=0;
  do
  {
   zw[lng]=_daten[pos];
   lng++;
   erg=div(pos,_zlbrt);
   pos+=_fak;
   if(erg.rem==0 || pos>_endfldpos) break;
  } while(pos<_endfldpos);

  maxint=lng/4;
  _lfdint=1;
  while(_lfdint<=maxint)
  {
   for(int i=0;i<MAXBRT;i++) _text[i]=0;
   _anzchar=0;
   pos=0;
   while(pos<lng)                    // Create character line
   {
    _text[_anzchar]=zw[pos];
    _anzchar++;
    pos+=_lfdint;
   }
   if(_stop)
   {
    bitana->progressEnd();
    return false;
   }
   _beglfdzl=_lfdch+(_lfdzl*_zlbrt);
   _check();
   _lfdint++;
  }
  if(_lfdch<_zlbrt-1) _lfdch++;
  else _lfdzl++;
 }

// Begin search words in diagonal from right to left
 _lfdzl=0;
 _lfdch=0;
 if(_inter>ZLBRT) _faki=_inter+1;
 else _faki=ZLBRT+1;
 _fak=_zlbrt+1;
 gef.la='L';
 while(_lfdch<_zlbrt-3 && _lfdzl<_anzzl-3)
 {
  zlpro++;
  bitana->progressStep(zlpro);

  pos=_lfdch+(_lfdzl*_zlbrt);
  for(int i=0;i<MAXBRT;i++) zw[i]=0;
  lng=0;
  do
  {
   zw[lng]=_daten[pos];
   lng++;
   erg=div(pos,_zlbrt);
   pos+=_fak;
   if(erg.rem==_zlbrt-1 || pos>_endfldpos) break;
  } while(pos<_endfldpos);

  maxint=lng/4;
  _lfdint=1;
  while(_lfdint<=maxint)
  {
   for(int i=0;i<MAXBRT;i++) _text[i]=0;
   _anzchar=0;
   pos=0;
   while(pos<lng)                    // Create character line
   {
    _text[_anzchar]=zw[pos];
    _anzchar++;
    pos+=_lfdint;
   }
   if(_stop)
   {
    bitana->progressEnd();
    return false;
   }
   if(_lfdzl) _beglfdzl=_lfdzl*_zlbrt;
   else _beglfdzl=_lfdch;
   _check();
   _lfdint++;
  }
  if(_lfdch<_zlbrt-4) _lfdch++;
  else _lfdzl++;
 }

 bitana->progressEnd();
 return true;
}

bool BTextAbbild::_check()
{
 bool ok;
 int m,n;
 int x;
 int lz;

 QString wort("");
 QString zeile("");
 QString tmp("");

 m=0;
 if(_lfdint>1) _lfdbu=3;
 else _lfdbu=4;
 while(m<(_anzchar-_lfdbu))
 {
  if(_lfdint>1) _lfdbu=3;
  else _lfdbu=4;
  _beglfdwrt=_beglfdzl+(m*_lfdint*_fak);
  wort="";
  for(n=0;n<_lfdbu;n++) wort.insert(n,_text[m+n]);    // Create word
  ok=true;
  while(ok)
  {
   zeile=_lex->findWort(wort,0);
   x=zeile.at(0);
   if(x==52) return false;
   if(x!=49 && x!=50 && x!=51)
   {
    gef.abst=_abstand();
    gef.pos=_absPosition();
    gef.seq=_lfdint*_faki;
    gef.ri='V';
    for(lz=0;lz<LNGHWRT;lz++) gef.heb[lz]=0;
    lz=0;
    while(zeile.at(lz)!=10)
    {
     gef.heb[lz]=zeile.at(lz);
     lz++;
    }
    _einsort();
   }
   if(x==49) wort.insert(n,_text[m+n]);
   else ok=false;
   _lfdbu++;
   if((m+n)<_anzchar) n++;
   else ok=false;
  }

// Check the revers word
  if(_lfdint>1) _lfdbu=3;
  else _lfdbu=4;
  tmp="";
  ok=false;
  for(n=0;n<_lfdbu;n++) tmp.insert(n,_text[m+n]);    // Create word
  wort=_lex->txtUmkehr(tmp);
  if(strcmp(wort,tmp)!=0) ok=true;
  while(ok)
  {
   zeile=_lex->findWort(wort,0);
   x=zeile.at(0);
   if(x!=49 && x!=50 && x!=51)
   {
    gef.abst=_abstand();
    gef.pos=_absPosition();
    gef.seq=_lfdint*_faki;
    gef.ri='R';
    for(lz=0;lz<LNGHWRT;lz++) gef.heb[lz]=0;
    lz=0;
    while(zeile.at(lz)!=10)
    {
     gef.heb[lz]=zeile.at(lz);
     lz++;
    }
    _einsort();
   }
   if(x==49) wort.insert(n,_text[m+n]);
   else ok=false;
   _lfdbu++;
   if((m+n)<_anzchar) n++;
   else ok=false;
  }
  m++;
 }
 return true;
}

void BTextAbbild::_einsort()
{
 int i=0;
 int l=0;

 while(l<500)
 {
  if(gef.abst<sor[l].abst || sor[l].abst==0.0)
  {
   if(_anzwrt) for(i=_anzwrt;i>=l;i--) sor[i+1]=sor[i];
   sor[l]=gef;
   _anzwrt++;
   _anzgef++;
   if(_anzwrt>500) _anzwrt=500;
   break;
  }
  l++;
 }
}

float BTextAbbild::_abstand()
{
 float abst,di;

 _endlfdwrt=_beglfdwrt+(_lfdint*_fak*(_lfdbu-1));
 abst=99999.0;
 di=_diff(_begsuwrt,_beglfdwrt,_zlbrt);
 if(abst>di) abst=di;
 di=_diff(_begsuwrt,_endlfdwrt,_zlbrt);
 if(abst>di) abst=di;
 di=_diff(_endsuwrt,_beglfdwrt,_zlbrt);
 if(abst>di) abst=di;
 di=_diff(_endsuwrt,_endlfdwrt,_zlbrt);
 if(abst>di) abst=di;
 if(abst==0) abst=0.1;
 return abst;
}

float BTextAbbild::_diff(int p1, int p2, int s)
{
 float wur;
 div_t dp1,dp2;

 dp1=div(p1,_zlbrt);
 dp2=div(p2,_zlbrt);
 dp1.quot=abs(dp1.quot-dp2.quot);
 dp1.rem=abs(dp1.rem-dp2.rem);

 if(dp1.rem!=0 && dp1.quot!=0) wur=hypot((double)dp1.rem,(double)dp1.quot);
 if(dp1.rem==0) wur=(float)dp1.quot;
 if(dp1.quot==0) wur=(float)dp1.rem;
 return wur;
}

int BTextAbbild::_absPosition()
{
 div_t erg;
 int  pos;

 erg=div(_beglfdwrt,_zlbrt);
 if(_inter<8 && _anzbu<10) pos=erg.quot*BLDBRT;
 else pos=erg.quot*_inter;
 pos+=erg.rem;
 return pos+_begpos;
}

void BTextAbbild::slotStop()
{
  _stop = true;
}
