/***************************************************************************
                          bibtext.h  -  description
                             -------------------
    begin                : Thu Dec 30 1999
    copyright            : (C) 1999 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BIBTEXT_H
#define BIBTEXT_H

// include files for QT
#include <qvalidator.h>
#include <qstring.h>

// include files for KDE
#include <kcombo.h>
#include <ktoolbar.h>
#include <klined.h>

	/** Bibtext selection in a statusbar (bookbar). The transform from position to chapter, vers
			ans return are includes by buttons.
  		*@author Hans-Jrgen Schumann
	*/

class BibText : public KToolBar {
   Q_OBJECT

public:
	BibText(QWidget *parent=0);
	void initBar(KToolBar *bookbar);

	QString lesBuchName();
	QString lesBuchDir();
	int lesVonPos();
	int	lesBisPos();	
	int lesVonKap();
  int lesBisKap();
	int lesVonVers();
	int lesBisVers();

	QString lesKapVersVon();
	QString lesKapVersBis();

	void setBuchDir(QString);
	void setBuchName(QString);
	void setKapVersVon(QString);
	void setKapVersBis(QString);
	void setPosVon(int);
	void setPosBis(int);

 	~BibText();


private:
	QIntValidator *pvalid;
	KCombo *buch;
	KLined *kvon, *kbis, *pvon, *pbis;

	QString namebuch;
	QString buchdir;
	int vonpos;
	int	bispos;	
	int vonkap;
  int biskap;
	int vonvers;
	int bisvers;

	void writeKapVers();

private slots:
  /** Open a book directory */
  void slotOpenBookDir(int id);
	void slotTextChanged(const char *txt);
  /** Book changed; a new book was selected and the start and endposition
			is located
			@param buch the item of book is selected
	*/
	void slotBookChanged(int buch);
	/** transform position to chapter, vers
	*/
	void slotPos2Kap();
	void slotKap2Pos();

public slots:
	/** If return pressed, all widgeds and variables of the bookbar are updated
	*/
  void slotReturnPressed();
};

#endif













