/**************************************************************************
 * $Id: SamplinMain.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SamplinMain_included
#define SamplinMain_included

#include "script_all.h"
#include "devices.h"

#include <qsocknot.h>
#include <qtimer.h>
#include <qlist.h>
#include <qstring.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qsplitter.h>

#include <kapp.h>
#include <ktmainwindow.h>
#include <kwview.h>
#include <kwdoc.h>

#include <TEWidget.h>
#include <TEmulation.h>


// StatusBar field IDs
#define ID_LINE_COLUMN 1
#define ID_INS_OVR 2
#define ID_MODIFIED 3
#define ID_GENERAL 4
#define ID_SCRIPT 5

#define BUTTON_START 10
#define BUTTON_STOP 11
#define BUTTON_STEP 12
#define BUTTON_RESET 13
#define BUTTON_GOTO 14
#define BUTTON_KILL 15


class SamplinMain : public KTMainWindow
{
    Q_OBJECT

 public:

    SamplinMain
    (KWriteDoc * = 0);

   virtual ~SamplinMain();

//   void externEdit(const char *);

 protected:
   QSplitter *splitter;
   TEWidget *tewidget;
   STerm *temul;
   bool warn_modified;
   QTimer *timer;
   QSocketNotifier *notifier1,*notifier2,*notifier3;
   QString filename;
   
   // internal variables - running compiler
   
   int child_running;
   int child_fd_in;
   int child_fd_out;
   int child_fd_stdout;
   int child_fd_stderr;
   int child_log;
   int child_status;
   int child_errorlevel;
   int child_lineno;
   pid_t child_pid,devs_pid;
   int nbytes;
   int script_status;
   
   void forkScript(void);
   
 protected slots:
   virtual void timerHandler();
   virtual void notifier1Handler();
   virtual void notifier2Handler();
   virtual void notifier3Handler();
   virtual void scriptState(int state);   

   virtual void scriptConfig();
   virtual void devConfig();

   void helpAbout();
   void helpContents();
   
   void receiveChar(const char *,int);
   
 public slots:
   void killScript();
   void runScript();
   void stopScript();
   void resetScript();
   void gotoScript();
   void stepScript();
   int  startScript();
   
   
   // here begin kwrite methods & data
   
 public:
   
   void init(); //initialize caption, status and show
   
   virtual bool queryClose();
   virtual bool queryExit();
   
   void loadURL(const char *url, int flags = 0);
   
 protected:
   virtual void focusInEvent(QFocusEvent *);
   void setupEditWidget(KWriteDoc *);
   void setupMenuBar();
   void setupToolBar();
   void setupStatusBar();
   
   KWrite *kWrite;
   int menuUndo, menuRedo;
   int menuVertical, menuShowTB, menuShowSB;
   //    int statusID, toolID, verticalID, indentID;
   //    QPopupMenu *file, *edit, *options, *help;
   QPopupMenu *edit, *options, *recentPopup, *hlPopup, *popup, *m_conf;
   QStrList recentFiles;
   
   bool hideToolBar;
   bool hideStatusBar;
   
   QTimer *statusbarTimer;
   
 public slots:
   void openRecent(int);
   void newWindow();
   void newView();
   void closeWindow();
   void quitEditor();
   
   void toggleStatusBar();
   void toggleToolBar();
   
   void helpSelected();
   
   void newCurPos();
   void newStatus();
   void statusMsg(const char *);
   void timeout();
   void newCaption();
   void newUndo();
   
   void dropAction(KDNDDropZone *);
   
   void showHighlight();
   
       //config file functions
 public:
   //common config
   void readConfig(KConfig *);
   void writeConfig(KConfig *);
   //config file
   void readConfig();
 public slots:
   void writeConfig();
   //session management
 public:
   void restore(KConfig *,int);
 protected:
   virtual void readProperties(KConfig *);
   virtual void saveProperties(KConfig *);
   virtual void saveData(KConfig *);

   void message(const char *);
};
#endif // SamplinMain_included
