#ifndef QWT_SLDBASE_H
#define QWT_SLDBASE_H

#include <qwt_drange.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qdatetm.h>

class QwtSliderBase : public QWidget, public QwtDblRange
{

	Q_OBJECT 

 public:

	enum { ScrNone, ScrMouse, ScrTimer, ScrDirect };
	
 protected:

	int d_scrollMode;
	double d_mouseOffset;
	int d_direction;
	int d_tracking;
	
 private:
	
	int d_tmrID;
	int d_updTime;
	int d_timerTick;
	QTime d_time;
	double d_speed;
	double d_mass;

	void buttonReleased();

 public:
	
	QwtSliderBase( QWidget *parent = 0, const char *name = 0 );
	~QwtSliderBase();

	void setUpdateTime(int t);
//	void incValue(double nSteps);
	void stopMoving();
	void setTracking(bool enable);
	
  protected:
	
	virtual void setMass(double val);
	void setPosition(const QPoint &p);
	virtual void valueChange();
	virtual double mass() const;

	void timerEvent(QTimerEvent *e);
	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	   
 public slots:

	void moveTo(double val);
	void adjustTo(double val);
	
 signals:

	void valueChanged(double value);
	void sliderPressed();
	void sliderReleased();
	void sliderMoved(double value);

 protected:

	virtual double getValue(const QPoint & p) = 0;
	virtual void getScrollMode( const QPoint &p,
				   int &scrollMode, int &direction) = 0;

};


inline double QwtSliderBase::mass() const
{
	return d_mass;
}

#endif


















