#include "qwt_scale.h"
#include <qwt_math.h>


QwtScale::QwtScale( QwtScaleDraw::Orientation ori, QWidget *parent, const char *name)
: QWidget(parent,name)
{
    d_scaleOffset[0] = 0;
    d_scaleOffset[1] = 0;
    d_borderDist = 4;
    d_titleOffset = 0;
    d_titleDist = 8;
    d_autoRedraw = TRUE;
    if ((ori > 0) && (ori > QwtScaleDraw::Right))
       ori = QwtScaleDraw::Bottom;
    d_scale.setGeometry(0,0,10,ori);
    setMinimumSize(30,30);
//   d_font=font();
//   d_titleFont=font();
}


QwtScale::~QwtScale()
{
}


//------------------------------------------------------------
//
//.S	QwtScale::setTitle
//
//
//.s	Parameters
//.p	const char *title
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::setTitle(const char *title)
//
//------------------------------------------------------------
void QwtScale::setTitle(const char *title)
{
    d_title = QString(title);
    repaint();
}


//------------------------------------------------------------
//
//.S	QwtScale::setScaleOffset
//
//
//.s	Parameters
//.p	int start, int end
//
//.s	Return Type
//		setBorderDist
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::setBorderDist(int horz, int vert)
//
//------------------------------------------------------------
void QwtScale::setScaleOffset(int start, int end)
{
//   if(start!=d_scaleOffset[0] || end!=d_scaleOffset[1]){
      d_scaleOffset[0] = start;
      d_scaleOffset[1] = end;
      resizeScale();
      repaint();
//   }
}



//------------------------------------------------------------
//
//.S	QwtScale::setBorderDist
//      Specify the border distance of the scale's base line.
//
//.s	Parameters
//.p	int bd	-- distance
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::setBorderDist(int bd)
//
//------------------------------------------------------------
void QwtScale::setBorderDist(int bd)
{
    d_borderDist = qwtMax(0,bd);
    repaint();
}

//------------------------------------------------------------
//
//.S	QwtScale::setTitleFont
//
//
//.s	Parameters
//.p	const QFont &f
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::setTitleFont(const QFont &f)
//
//------------------------------------------------------------
void QwtScale::setTitleFont(const QFont &f)
{
    d_titleFont = f;
    repaint();
}


void QwtScale::setFont(const QFont &f)
{
    d_font = f;
    d_scale.setFont(f);
}


//------------------------------------------------------------
//
//.S	QwtScale::setTitleColor
//
//
//.s	Parameters
//.p	const QColor &c
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::setTitleColor(const QColor &c)
//
//------------------------------------------------------------
void QwtScale::setTitleColor(const QColor &c)
{
    d_titleColor = c;
    repaint();
}


//------------------------------------------------------------
//
//.S	QwtScale::paintEvent
//
//
//.s	Parameters
//.p	QPaintEvent *e
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::paintEvent(QPaintEvent *e)
//
//------------------------------------------------------------
void QwtScale::paintEvent(QPaintEvent *e)
{
   QPainter p;
   QRect r = this->rect();

   p.begin(this);
   
   draw(&p,&r);
   
   p.end();
    
}

void QwtScale::setLabelFormat(char f, int prec)
  {
     d_scale.setLabelFormat(f,prec);
  }


void QwtScale::draw(QPainter *p, QRect *r)
{
   int th, ta, ttop;
   
    ta = p->fontMetrics().ascent();
    th = p->fontMetrics().height();
    ttop = ta + d_titleOffset;

    // draw scale
   resizeScale(p,r);
   d_scale.draw(p);
   
   // draw title

   p->setFont(d_titleFont);
   switch(d_scale.orientation())
     {
      case QwtScaleDraw::Left:
	p->rotate(-90.0);
	ttop = qwtMin(ttop + (r->width() - ttop) / 4, r->width());
	p->drawText(-r->bottom(), r->right() - ttop,
	   r->height(), 2*th,AlignHCenter|AlignTop, d_title);
	break;
      case QwtScaleDraw::Right:
	
	p->rotate(90.0);
	ttop = qwtMin(ttop + (r->width() - ttop) / 4, r->width());
	p->drawText(r->top(), -r->left() - ttop,
		    r->height(), 2*th, AlignHCenter|AlignTop, d_title);
	break;
      case QwtScaleDraw::Top:
	p->drawText(r->x(), r->bottom() - ttop,
		    r->width(), 2*th,
		    AlignHCenter|AlignTop ,d_title);
	break;
      case QwtScaleDraw::Bottom:
	p->drawText(r->x(), r->top() + d_titleOffset,
		    r->width(), 2*th,
		    AlignHCenter|AlignTop,d_title);
	break;
     }

   
}


//------------------------------------------------------------
//
//.S	QwtScale::resizeEvent
//
//
//.s	Parameters
//.p	QResizeEvent *e
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::resizeEvent(QResizeEvent *e)
//
//------------------------------------------------------------
void QwtScale::resizeEvent(QResizeEvent *e)
{
//   printf("resize: old_w=%i, new_w=%i\n",e->oldSize().width(),e->size().width());
     
//     if(e->size()!=e->oldSize())
     resizeScale();
}

//------------------------------------------------------------
//
//.S	QwtScale::resizeScale
//
//
//.s	Parameters
//.p	QPainter *p, int ori
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::resizeScale(QPainter *p, int ori)
//
//------------------------------------------------------------
void QwtScale::resizeScale()
{
    
    QRect r = this->rect();
    QPainter p;

    p.begin(this);
    
    switch(d_scale.orientation())
    {
    case QwtScaleDraw::Bottom:
	d_scale.setGeometry(r.x() + d_scaleOffset[0],
			    r.y() + d_borderDist,
			    r.width() - d_scaleOffset[1] - d_scaleOffset[0],
			    QwtScaleDraw::Bottom);

	d_titleOffset = d_titleDist + d_borderDist + d_scale.maxHeight(&p);
	break;
	
    case QwtScaleDraw::Top:
	d_scale.setGeometry(r.x() + d_scaleOffset[0],
			    r.bottom() - d_borderDist,
			    r.width() - d_scaleOffset[1] - d_scaleOffset[0],
			    QwtScaleDraw::Top);
	d_titleOffset =  d_titleDist + d_borderDist + d_scale.maxHeight(&p);
	break;
	
    case QwtScaleDraw::Left:
	d_scale.setGeometry(r.right() - d_borderDist,
			    r.y() + d_scaleOffset[0],
			    r.height() - d_scaleOffset[0] - d_scaleOffset[1],
			    QwtScaleDraw::Left);
	d_titleOffset = d_borderDist + d_titleDist + d_scale.maxWidth(&p,FALSE);
	break;
	
    case QwtScaleDraw::Right:
	d_scale.setGeometry(r.x() + d_borderDist,
			    r.y() + d_scaleOffset[0],
			    r.height() - d_scaleOffset[0] - d_scaleOffset[1],
			    QwtScaleDraw::Right);
	d_titleOffset = d_borderDist + d_titleDist + d_scale.maxWidth(&p,FALSE);
	break;
	
    }
    p.end();
    
}

void QwtScale::resizeScale(QPainter *p, QRect *r)
{
    
    switch(d_scale.orientation())
    {
    case QwtScaleDraw::Bottom:
	d_scale.setGeometry(r->x() + d_scaleOffset[0],
			    r->y() + d_borderDist,
			    r->width() - d_scaleOffset[1] - d_scaleOffset[0],
			    QwtScaleDraw::Bottom);

	d_titleOffset = d_titleDist + d_borderDist + d_scale.maxHeight(p);
	break;
	
    case QwtScaleDraw::Top:
	d_scale.setGeometry(r->x() + d_scaleOffset[0],
			    r->bottom() - d_borderDist,
			    r->width() - d_scaleOffset[1] - d_scaleOffset[0],
			    QwtScaleDraw::Top);
	d_titleOffset =  d_titleDist + d_borderDist + d_scale.maxHeight(p);
	break;
	
    case QwtScaleDraw::Left:
	d_scale.setGeometry(r->right() - d_borderDist,
			    r->y() + d_scaleOffset[0],
			    r->height() - d_scaleOffset[0] - d_scaleOffset[1],
			    QwtScaleDraw::Left);
	d_titleOffset = d_borderDist + d_titleDist + d_scale.maxWidth(p,FALSE);
	break;
	
    case QwtScaleDraw::Right:
	d_scale.setGeometry(r->x() + d_borderDist,
			    r->y() + d_scaleOffset[0],
			    r->height() - d_scaleOffset[0] - d_scaleOffset[1],
			    QwtScaleDraw::Right);
	d_titleOffset = d_borderDist + d_titleDist + d_scale.maxWidth(p,FALSE);
	break;
	
    }
    
}

//------------------------------------------------------------
//
//.S	QwtScale::scaleChange
//
//
//.s	Parameters
//.p	
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::scaleChange()
//
//------------------------------------------------------------
void QwtScale::scaleChange()
{
    repaint();
}



//------------------------------------------------------------
//
//.S	QwtScale::adjustWidth
//
//
//.s	Parameters
//.p	bool tf
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::adjustWidth(bool tf)
//
//------------------------------------------------------------
void QwtScale::adjustWidth(bool tf)
{
    d_adjWidth = tf;
    resizeScale();
    repaint();
}



//------------------------------------------------------------
//
//.S	QwtScale::sizeHint
//
//
//.s	Parameters
//.p	
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//.s	Note
//	This function uses a QPainter internally.  
//
//.s	Syntax
//.f	QSize QwtScale::sizeHint() const
//
//------------------------------------------------------------
QSize QwtScale::sizeHint() const
{
    int th,ta, tw;
    
    QPainter p;
    p.begin(this);

   p.setFont(d_titleFont);
    QFontMetrics fm = p.fontMetrics();
   
	th = fm.height();
    ta = fm.ascent();
    tw = fm.width(d_title);
    
    QSize rv;
    switch(d_scale.orientation())
    {
    case QwtScaleDraw::Left:
    case QwtScaleDraw::Right:
// TRUE !!!!
       
       rv.setWidth(d_scale.maxWidth(&p,FALSE) + d_borderDist + th);
	rv.setHeight(d_scale.scaleDiv().majCnt() * 2 * d_scale.maxHeight(&p));
	break;
    case QwtScaleDraw::Top:
    case QwtScaleDraw::Bottom:
	rv.setHeight(d_scale.maxHeight(&p) + d_borderDist + th + d_titleDist);
	rv.setWidth(d_scale.scaleDiv().majCnt()  * d_scale.maxWidth(&p,TRUE));
	break;
    }
    p.end();
    
    return rv;
    
}

//------------------------------------------------------------
//
//.S	QwtScale::minScaleOffset
//
//
//.s	Parameters
//.p	
//
//.s	Return Type
//		int
//
//.s	Return Value
//
//.s	Description
//
//.s	Note
//	This function uses a QPainter internally.  
//
//.s	Syntax
//.f	int QwtScale::minScaleOffset()
//
//------------------------------------------------------------
int QwtScale::minScaleOffset() const
{
    int rv = 0;
    
    QPainter p;
    p.begin(this);
    QFontMetrics fm = p.fontMetrics();
    

    switch(d_scale.orientation())
    {
    case QwtScaleDraw::Left:
    case QwtScaleDraw::Right:
	rv = (fm.ascent() + fm.descent() + 1) / 2;
	break;
    case QwtScaleDraw::Top:
    case QwtScaleDraw::Bottom:
	rv = (d_scale.maxLabelWidth(&p,TRUE) + 1) / 2;
	break;
    }
    p.end();
    
    return rv;
    
}

//------------------------------------------------------------
//
//.S	QwtScale::fontChange
//
//
//.s	Parameters
//.p	const QFont &oldfont
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::fontChange(const QFont &oldfont)
//
//------------------------------------------------------------
void QwtScale::fontChange(const QFont &oldfont)
{
    resizeScale();
    repaint();
}

//------------------------------------------------------------
//
//.S	QwtScale::setScale
//
//
//.s	Parameters
//.p	QwtScale::setScale
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtScale::setScale(QwtScaleDiv::setScale)
//
//------------------------------------------------------------
void QwtScale::setScale(const QwtScaleDiv &sd)
{
    if (d_scale.scaleDiv() != sd)
    {
    	d_scale.setScale(sd);
    	resize(this->size());
    	repaint();
    }
}
