#include <qwt_math.h>
//------------------------------------------------------------
//.H QwtMath | 3 | 27/04/96 | Qwt Widget Library | Qwt Programmer's Manual
//.S NAME
//	QwtMath - a set of mathematical routines
//
//.S SYNOPSIS
//	#include <qwtMath.h>
//
//------------------------------------------------------------


//------------------------------------------------------------
//
//.S	qwtGetMin
//	Find the smallest value in an array
//
//.s	Parameters
//.p	double *array, int size
//
//.s	Return Type
//		double
//
//.s	Syntax
//.f	double qwtGetMin(double *array, int size)
//
//------------------------------------------------------------
double qwtGetMin(double *array, int size)
{
    double rv;
    int i;
	
    if (size > 0)
    {
	rv = array[0];
	for (i=1; i< size; i++)
	   rv = qwtMin(rv, array[i]);
	return rv;
    }
    else
       return 0.0;
	
}


//------------------------------------------------------------
//
//.S	qwtGetMax
//	Find the largest value in an array
//
//.s	Parameters
//.p	double *array, int size
//
//.s	Return Type
//		double
//
//.s	Syntax
//.f	double qwtGetMax(double *array, int size)
//
//------------------------------------------------------------
double qwtGetMax(double *array, int size)
{
	double rv;
	int i;
	
	if (size > 0)
	{
		rv = array[0];
		for (i=1; i< size; i++)
		   rv = qwtMax(rv, array[i]);
		return rv;
	}
	else
	   return 0.0;
	
}


//------------------------------------------------------------
//
//.S	qwtCeil125
//	Find the smallest value out of {1,2,5}*10^n with an integer number n
//	which is greater than or equal to x
//
//.s	Parameters
//.p	double x
//
//.s	Return Type
//		double
//
//.s	Syntax
//.f	double qwtCeil125(double x)
//
//------------------------------------------------------------
double qwtCeil125( double x)
{
	double lx, rv;
	double p10, fr;
	double sign = ( x > 0) ? 1.0 : -1.0;

	lx = log10(fabs(x));
	p10 = floor(lx);
	fr = pow(10.0,lx - p10);
	if (fr <=1.0)
	   fr = 1.0;
	else if (fr <= 2.0)
	   fr = 2.0;
	else if (fr <= 5.0)
	   fr = 5.0;
	else
	   fr = 10.0;
	rv = fr * pow(10.0,p10);
	return sign * rv;
} 


//------------------------------------------------------------
//
//.S	qwtCeil125
//	Find the largest value out of {1,2,5}*10^n with an integer number n
//	which is smaller than or equal to x
//
//.s	Parameters
//.p	double x
//
//.s	Return Type
//		double
//
//.s	Syntax
//.f	double qwtFloor125(double x)
//
//------------------------------------------------------------
double qwtFloor125( double x)
{
	double lx, rv;
	double p10, fr;
	double sign = ( x > 0) ? 1.0 : -1.0;
	lx = log10(fabs(x));
	p10 = floor(lx);
	fr = pow(10.0,lx - p10);
	if (fr >= 10.0)
	   fr = 10.0;
	else if (fr >= 5.0)
	   fr = 5.0;
	else if (fr >= 2.0)
	   fr = 2.0;
	else
	   fr = 1.0;
	rv = fr * pow(10.0,p10);
	return sign * rv;
} 


//------------------------------------------------------------
//
//.S	qwtChkMono
//	  Checks if an array is a strictly monotonic sequence
//
//.s	Parameters
//.p	double *array	-- pointer to a double array
//	int size	-- size of the array
//
//.s	Return Type
//		int
//
//.s	Return Value
//.t      0 -- sequence is not strictly monotonic
//      1 -- sequence is strictly monotonically increasing
//      -1 --  sequence is strictly monotonically decreasing
//
//.s	Syntax
//.f	int qwtChkMono(double *array, int size)
//
//------------------------------------------------------------
int qwtChkMono(double *array, int size)
{
	int rv, i;
	
	if (size < 2) return 0;
	
	rv = qwtSign(array[1] - array[0]);
	for (i=1;i<size-1;i++)
	{
		if ( qwtSign(array[i+1] - array[i]) != rv )
		{
			rv = 0;
			break;
		}
	}
	return rv;
	
}

//------------------------------------------------------------
//
//.S	qwtTwistArray
//	Turn an array upside down
//
//.s	Parameters
//.p	double *array, int size
//
//.s	Return Type
//		void
//
//.s	Syntax
//.f	void qwtTwistArray(double *array, int size)
//
//------------------------------------------------------------
void qwtTwistArray(double *array, int size)
{
    int itmp;
    int i, s2;
    double dtmp;

    s2 = size / 2;
	
    for (i=0; i < s2; i++)
    {
	itmp = size - 1 - i;
	dtmp = array[i];
	array[i] = array[itmp];
	array[itmp] = dtmp;
    }

}


//------------------------------------------------------------
//
//.S	qwtLinSpace
//	Create an array of equally spaced values
//
//.s Parameters
//.p	double *array	--	where to put the values
//	int size	-- size of the array
//	double xmin	-- value associated with index 0
//	double xmax	-- value associated with index (size-1)
//
//.s Return Type
//	void
//.s Syntax
//.f void qwtLinSpace(double *array, int size, double xmin, double xmax)	
//------------------------------------------------------------
void qwtLinSpace(double *array, int size, double xmin, double xmax)
{
  int i, imax;
  imax = size -1;
  double step;
  
  if (size > 0)
    {
      array[0] = xmin;
      array[imax] = xmax;
      step = (xmax - xmin) / double(imax);

      for (i=1;i<imax;i++)
	array[i] = xmin + double(i) * step;
    }
    
}


//------------------------------------------------------------
//
//.S	qwtLogSpace
//	Create an array of logarithmically equally spaced values
//
//.s Parameters
//.p	double *array	--	where to put the values
//	int size	-- size of the array
//	double xmin	-- value associated with index 0
//	double xmax	-- value associated with index (size-1)
//------------------------------------------------------------
void qwtLogSpace(double *array, int size, double xmin, double xmax)
{
  int i, imax;
  imax = size -1;
  double step;
  double lxmin,lxmax;
  double lstep;

  if ((xmin <= 0.0) || (xmax <= 0.0) || (size <= 0))
    return;

  array[0] = xmin;
  array[imax] = xmax;
  lxmin = log(xmin);
  lxmax = log(xmax);

  lstep = (lxmax - lxmin) / double(imax);

  for (i=1; i<imax;i++)
    array[i] = exp(lxmin + double(i) * lstep);
  
}
















