/**************************************************************************
 * $Id: SeriesFit.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SeriesFit_included
#define SeriesFit_included

#include "dlg/SeriesFitData.h"
#include "SamplinCurve.h"

class SeriesFit : public SeriesFitData
{
    Q_OBJECT

public:

    SeriesFit
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~SeriesFit();

   void setData(SamplinCurve *crv);
   int loadBack(bool force=false);
   int loadOld(void);

 protected:
   virtual void fit();
   
 protected:
   SamplinCurve *curve;
   QString d_function;
   double d_from, d_to, d_eps;
   bool d_range,d_auto;
   bool fitting;
   
 protected slots:
   void updateEnabled();

   void start();
   void stop();
   
 signals:
   void update();  
};
#endif // SeriesFit_included
