/**************************************************************************
 * $Id: Graph_axis.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef Graph_axis_included
#define Graph_axis_included

#include <dlg/Graph_axisData.h>
#include <SamplinPlotData.h>

class Graph_axis : public Graph_axisData
{
    Q_OBJECT

 protected:
   void loadBack(void);
   
   SamplinScaleBox *scale;
   QFont d_font,d_tfont,d_nfont,d_ntfont;
   QColor d_tcolor;
   QPen d_pen;
   QString d_title;
   double d_min,d_max,d_step,d_ref;
   int d_prec,d_format,d_mincnt,d_opt;
   bool d_enable,d_auto;
   
 public:

   Graph_axis
     (
      QWidget* parent = NULL,
      const char* name = NULL
      );
   
   virtual ~Graph_axis();
   
   void setData(SamplinScaleBox *);
   
 protected slots:
   virtual void apply();
   virtual void ok();
   virtual void cancel();
   virtual void selectFont();
   virtual void selectTitleFont();
   virtual void updateEnabled();
   
 signals:
   void update();
   

};
#endif // Graph_axis_included
