/**************************************************************************
 * $Id: script.h 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef __INCL_SCRIPT
#define __INCL_SCRIPT

#include <stdio.h>
#include <stdlib.h>
#include <float.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <values.h>
#include <unistd.h>
#include <signal.h>
#include <ctype.h>

#include <pthread.h>

#define DONE {current=current->next;break;}
#define ERROR(level,args) {if(level<=infolevel)error args;}

#include <qintdict.h>
#include <qlist.h>
#include <qobject.h>
#include <qtimer.h>
#include <kledlamp.h>
#include <qlcdnum.h>
#include <qprogressdialog.h>
#include <qsocknot.h>

#include <samplin.h>
#include <devices.h>
#include <ScriptInput.h>
#include <GraphWindow.h>
#include "script.flex.h"
#include "script.bison.h"
#include "script_all.h"
#include "cnflib.h"


void signal_handler(int);  /* handle various signals */

/* ------------- flex ------------------------ */
//void yyerror(char *); /* yyerror message */


class SamplinScript : public QObject, public SamplinParser
{
   Q_OBJECT

 public:
   
   
   SamplinScript(QWidget *parent=0);
   virtual ~SamplinScript();

   int yylex();
   void yyunput(int);
   void yyerror(char *);
   int setDevicesFile(const char *);
   void setInfoLevel(int level){infolevel=level;}
   void setQuitFlag(bool qflag){quitflag=qflag;}

   dlgitem *findDlg(const char *name);
   GraphPanel *findGraph(const char *name);
   GraphWindow *findGraphWindow(const char *name);
   GraphWindow *findGraphWindow(uint id);
   uint newGraphId(void);
   GraphWindow *openGraph(const char *name);
   bool closeGraph(const char *name);
   bool closeGraph(uint id);
   bool closeAllGraphs(void);
   
   void widgetAction(void);
   void timeHandler(void);
   
   SamplinDevice *getDevice(char *);
   void closeDevices(void);
   
   SamplinScanner *scanner;
   QList<SamplinDevice> *devices;
   QIntDict<GraphWindow> graphs;
   QList<dlgitem> dialogs;
   QProgressDialog *pd;
   
   QString devices_file, script_file, script_name;
   bool quitflag,childflag;

   /* ---------------------- enum types ------------------------------- */
   
   enum stck_or_sym { /* contents of a stack element or type of a symbol */
      STRING,NUMBER,LBL,GTO,JUMP,FREE,FUNC,ARRAY,RETADD,IRETADD,PTR,NIL
   };
   
   enum cmd_type { /* type of command */

      // Commands executed in program thread
      
      LABEL,GOTO,QGOTO,GOSUB,QGOSUB,IGOSUB,RETURN,          /* flow control */
      END,DECIDE,SKIPPER,NOP,
      
      DIM,FUNCTION,DOARRAY,                          /* everything with "()" or "[]"*/

      BINOP,RELOP,STRRELOP,
      /*DBLADD,DBLMIN,DBLMUL,DBLDIV,DBLPOW,NEGATE,*/     /* double operations */
      /*DBLAND,DBLXOR,DBLOR,*/
      NEGATE,
      PUSHDBLSYM,PUSHDBLSYMPTR,POPDBLSYM,PUSHDBL,POPDBL,PUSHDBLP,
      
      UNARYASSIGN,  // unary assignments
      
      SETINFOLEVEL,

      /*AND,OR,NOT,LT,GT,LE,GE,EQ,NE,*/
       
      PUSHSTRSYM,POPSTRSYM,PUSHSTR,CONCAT,           /* string operations */
      
      PRINT,PROMPT,RESTORE,QRESTORE,          /* i/o operations */
      READDATA,DATA,MYOPEN,MYCLOSE,MYSWITCH,
      WAIT,BELL,
      
      DEVWR, DEVWRB, DEVRD, DEVRDB, DEVOPEN, DEVCLOSE, DEVCTL, DEVSEEK, DEVFLUSH,

      TIMER,

      // Commands executed in main (widget) thread

      MYREAD,MYREADDLG,
      
      MESSAGE, ADDPLOT, UPDATEPLOT, DELPLOT, 
      
      ADDGRAPH, DELGRAPH, LOADGRAPH, SAVEGRAPH, TITLEGRAPH, PLOTFNC, GRAPHFNC,

      ADDDLG, DELDLG, HIDEDLG, SHOWDLG, PROGRESSDLG, ADDWIDGET,
      
      SLEEP, MULTI, CURSOR
   };
   
//   enum states {    /* current state of program */
//      HATCHED,INITIALIZED,COMPILING,COMPILED,RUNNING,STOPPED,FINISHED
//   };
   
   /* ------------- function prototypes for ... ---------------- */
   /* ------------- main program and auxiliary functions ---------------- */

   int programState(void);
   int errorLevel(void){return errorlevel;}
   int currentLine(void);
   int doStep(void);
   int doWidgetStep();
   int compile(void);
   int setFile(const char *);
//   void go(int line);
   void execute(int whence);
//   void reset(void);
//   void step(void);
   void freeAlloc(void);
   //     {msgwin=ptr;if(ptr!=NULL)ptr->clear();printf("ddd\n");}
   
   struct symbol *get_sym(const char *,int,int); /* find and/or add a symbol */
   struct command *add_command(int); /* get room for new command */
   void initialize(void); /* give correct values to pointers etc ... */
   void resetptr(void); /* reset pointers to their initial values */

   char *my_strdup(const char *); /* my own version of strdup */
   void *my_malloc(unsigned); /* my own version of malloc */
   
   void error(int,const char *,...); /* reports an error and possibly exits */
   
   /* ------------- double handling ---------------- */
   void create_negate(void); /* creates command negate */
   void negate(void);  /* negates top of stack */
   void create_pushdblsym(char *, int); /* create command 'pushdblsym' */
   void create_pushdblsymptr(char *); /* create command 'pushdblsymptr' */
   void create_pushdblsym2(char *); /* create command 'pushdblsym' */
   void pushdblsym(struct command *); /* push double symbol onto stack */
   void pushdblsymptr(struct command *); /* push double symbol ptr onto stack */
   void pushint(int);
   void create_popdblsym(char *, int); /* create command 'popdblsym' */
   void create_popdblsym2(char *, int); /* create command 'popdblsym' */
   void popdblsym(struct command *); /* pop double from stack */
   void create_pushdbl(double); /* create command 'pushdbl' */
   void pushdbl(struct command *); /* push double onto stack */
   void create_pushdblp(double *); /* create command 'pushdbl' */
   void pushdblp(struct command *); /* push double onto stack */   
   void create_popdbl(double *); /* create command 'pushdbl' */
   void popdbl(struct command *); /* push double onto stack */
   void create_binop(int); /* create binary expression calculation */
   void binop(struct command *); /* compute with two numbers from stack */

   void create_unaryassign(int, int); /* create unary expression calculation */
   void unaryassign(struct command *); /* compute with one number from stack */

   void create_relop(int); /* create command dblrelop */ 
   void relop(struct command *);  /* compare topmost double-values */
   
   /* ------------- string handling ---------------- */
   void create_pushstrsym(char *); /* push string symbol onto stack */
   void pushstrsym(struct command *);   /* push string symbol onto stack */
   void create_popstrsym(char *); /* create command 'popstrsym' */
   void popstrsym(struct command *); /* pop string from stack */
   void create_concat(void); /* creates command concat */
   void concat(void); /* concetenates two strings from stack */
   void create_pushstr(char *); /* creates command pushstr */
   void pushstr(struct command *); /* push string onto stack */
   void pushname(char *); /* push a name on stack */
   void create_strrelop(int); /* create command strrelop */ 
   void strrelop(struct command *);  /* compare topmost string-values */
   
   /* ------------- i/o ---------------- */
   void create_print(char); /* create command 'print' */
   void print(struct command *); /* print on screen */
   char *replace(char *); /* replace \n,\a, etc. */
   void create_myread(char); /* create command 'read' */
   void myread(struct command *); /* read from file or stdin */
   void create_myreaddlg(char); /* create command 'read' */
   void myreaddlg(struct command *); /* read from file or stdin */
   void create_prompt(char *); /* create command 'prompt' */
   void prompt(struct command *); /* set input prompt */
   void create_myopen(double,char *); /* create command 'myopen' */
   void myopen(struct command *); /* open specified file for given name */
   void create_myclose(double); /* create command 'myclose' */
   void myclose(struct command *); /* close the specified stream */
   void create_myswitch(double); /* create command 'myswitch' */
   void myswitch(struct command *); /* switch to specified stream */
   int badstream(int); /* test for valid stream id */
   
   /* ------------- flow--control ---------------- */
   void create_goto(char *); /* creates command goto */
   void create_gosub(char *); /* creates command gosub */
   void create_label(char *); /* creates command label */
   void pushgoto(void); /* generate label and push goto on stack */
   void popgoto(void); /* pops a goto and generates the matching command */
   void jump(struct command *); /* jump to specific Label */
   void create_return(void); /* creates command return */
   void myreturn(void); /* return from gosub */
   void create_skipper(void); /* creating command skipper */
   void skipper(void); /* used for on_goto/gosub, skip commands */
   void create_nop(void); /* does nothing */
   void create_myend(void); /* create command 'end' */
   void myend(void); /* is called at the end of program execution */
   void create_decide(void); /* creates command decide */
   void decide(void); /*  skips next command, if 0 on stack */
   
   /* ------------- miscellanous basic commands ---------------- */
   void create_function(int,char *); /* create command 'function' */
   void function(struct command *); /* performs a function */
   void create_doarray(char *,int); /* creates array-commands */ 
   void doarray(struct command *);  /* call an array */
   void create_dim(char *,char); /* create command 'dim' */
   void dim(struct command *); /* get room for array */
   void create_restore(char *); /* create command 'restore' */
   void restore(struct command *); /* reset data pointer to given label */
   void create_dbldata(double);  /* create command dbldata */
   void create_strdata(char *);  /* create command strdata */
   void create_readdata(char); /* create command readdata */
   void readdata(struct command *); /* read data items */
   void create_mywait(); /* create Command 'wait' */
   void mywait(); /* wait given number of seconds */
   void create_bell(); /* create Command 'bell' */
   void bell(); /* ring ascii bell */
   void setinfolevel(void); /* set infolevel to content of variable */
  
   /* ------------- basic functions ---------------- */

   char *fromto(char *,int,int); /* portion of string (for mid$,left$,right$) */
   char *inkey(void); /* gets char from keyboard, blocks and doesnt print */

   /* ------------- other stack operations ---------------- */
   void pushcopy(void); /* push copy of the last stack element */
   void pushcounter(void); /* push number '0' on stack */
   void inccounter(void); /* increment topmost stack element */
   void pushletter(char *); /* push letter on stack (for argument test) */
   void pushdummy(void); 
   void pushlabel(void); /* generate goto and push label on stack */
   void poplabel(void); /* pops a label and generates the matching command */
   void swap(void); /*swap topmost elements on stack */
   struct stackentry *push(void); /* push element on stack and enlarge it*/
   struct stackentry *pop(void); /* pops element to memory */
   struct array * plotArrayOk(const char *astr);
   
   void create_message(char);
   void message(struct command *);

   void create_devopen(char *);
   void devopen(struct command *);

   void create_devclose(char *);
   void devclose(struct command *);
   
   void create_devwr(char *,int);
   void devwr(struct command *);

   void create_devwrb(char *, char *);
   void devwrb(struct command *);
   
   void create_devrd(char *,int);
   void devrd(struct command *);
   
   void create_devrdb(char *, char *);
   void devrdb(struct command *);

   void create_devctl(char *);
   void devctl(struct command *);
   
   void create_devseek(char *,int);
   void devseek(struct command *);
   
   void create_devflush(char *);
   void devflush(struct command *);
   
   void create_plotfnc(int, char *, char *);
   void plotfnc(struct command *);
   
   void create_graphfnc(int, int, char *, char *);
   void graphfnc(struct command *);
   
   void create_addgraph();
   void addgraph(struct command *);

   void create_delgraph();
   void delgraph(struct command *);

   void create_loadgraph(int);
   void loadgraph(struct command *);
   
   void create_savegraph(int);
   void savegraph(struct command *);   

   void create_exportgraph(int);
   void exportgraph(struct command *);      

   void create_printgraph();
   void printgraph(struct command *);   
   
   void create_adddlg(char *);
   void adddlg(struct command *);

   void create_progressdlg(int, int);
   void progressdlg(struct command *);
   
   void create_deldlg(char *);
   void deldlg(struct command *);

   void create_hidedlg(char *);
   void hidedlg(struct command *);
   
   void create_showdlg(char *);
   void showdlg(struct command *);
   
   void create_addwidget(char *, int, char *, char *);
   void addwidget(struct command *);
   
   void create_mysleep(); /* create Command 'wait' */
   void mysleep(); /* wait given number of seconds */   

   void create_multi(int);
   void multi(struct command *);
   
   void create_timer(int);
   void mytimer(struct command *);   

   void create_cursor(int);
   void cursor(struct command *);   
   /* ------------- global variables ---------------- */
   
   struct symbol *symroot; /* first element in symbol list */
   struct symbol *symhead; /* last element ind symbol list */
   struct stackentry *stackroot; /* lowest element in double stack */
   struct stackentry *stackhead; /* topmost element in double stack */
   struct command *current; /* currently executed command */
   struct command *cmdroot; /* first command */
   struct command *cmdhead; /* last command */
   struct command *datapointer; /* current location for read-command */
   int infolevel; /* controls issuing of error messages */
   int diagnostic_count; /* number of diagnostic messages */
   int note_count; /* number of notes */
   int warning_count; /* number of warning messages */
   int error_count; /* number of error messages */
   char *string; /* for trash-strings */
   int labelcount; /* count self-generated labels */
   int commandcount; /* total number of commands */
   volatile int program_state;  /* state of program */
   char inputprompt[100]; /* input prompt */
// !!!   struct command *lastcommand; /* most recently created command */
   FILE *streams[10]; /* file streams */
   FILE *currentstream; /* current stream for output ... */
   
   /* printer-related */
   FILE *printerfile; /* file to print on */
   char *prfilename; /* filename to print on */
   int print_to_file; /* print to file ? */

 public slots:
//   void stop();
   void widgetSlot(widgetitem *w);
   void closeGraphSlot(uint id);
   void progressSlot();
   void threadEntryPoint();

 protected slots:
   void inputHandler();
   void threadHandler();
   void pauseSlot();
  
 private:
   void setProgramState(int state);
   
 private:
   pthread_mutex_t thread_mutex;
   int thread_pipe[2];
   QSocketNotifier *inputnotifier, *threadnotifier;
   bool multiflag;
   bool timerflag;
   bool textonly;
   bool pauseflag;
   int  last_print;
   bool unputflag;
   int unputtoken;
   
   widgetitem *waitMulti;
   volatile int goto_line,last_line;
   bool step_flag;
   
 signals:
   void refreshParent();
   void finishedScript();
   void changedState(int);
   void openGraphSignal(uint id, GraphWindow *gwin);
   void closeGraphSignal(uint id);   
//   void closeGraph(char *);
};

#endif
