/**************************************************************************
 * $Id: SamplinPlot.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3 beta $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef Samplin_Plot_included
#define Samplin_Plot_included

#include <qframe.h>
#include <qpixmap.h>
#include <qlist.h>
#include <qwt_autoscl.h>
#include <qwt_scldraw.h>
#include <unistd.h>

#include "SamplinPlotData.h"

#define OBJ_NONE -1
#define OBJ_GRAPH 0
#define OBJ_XBOTTOM 1
#define OBJ_XTOP 3
#define OBJ_YLEFT 2
#define OBJ_YRIGHT 4
#define OBJ_PLOT 5
#define OBJ_SERIES 6


class SamplinPlot: public QFrame, public SamplinPlotData
{
    Q_OBJECT

 public:
   long test_obj;
   
   SamplinPlot(QWidget *p = 0, const char *name = 0);
   virtual ~SamplinPlot();


   virtual void setPlotColor(const QColor &c);

   //
   //  manipulate axes
   //
   void setAxisAutoScale(int axis);    
   void setAxisScale(int axis, double min, double max, double step = 0.0 );
   void setAxisOptions(int axis, int opt);
   void changeAxisOptions(int axis, int opt, bool tf);
   void setAxisMaxMinor(int axis, int maxMinor);
   void setAxisMaxMajor(int axis, int maxMajor);
   void setAxisReference(int axis, double value);
   void setAxisTitle(int axis, const char *t);
   void setAxisFont(int axis, const QFont &f);
   void setAxisTitleFont(int axis, const QFont &f);
   void setAxisFont(int axis, QFont &f);
   
   double transform(int pos, int axis) const;
   
   void setAutoReplot(bool tf = true);
   
   //const QwtScaleDiv &scaleDiv(int axis) const;
   //double axisReference(int axis) const;
   //int axisMaxMajor(int axis) const;
   //int axisMaxMinor(int axis) const;
   
   bool autoReplot(){ return d_autoReplot; }
   void print(void);
   void blinkObject(int obj, uint key=0);   

   virtual bool exportPic(const char *fn);
   virtual bool exportBMP(const char *fn);
   
 private:

   QwtDiMap d_map[axisCnt];
   QPixmap d_pix;

//    int d_axisDist;
//    int d_borderDist;
//    int d_hScaleDist;
//    int d_vScaleDist;

   int d_litemcount,d_litemwidth,d_litemheight,d_llines,d_llineitems;
   
   int d_margin; //absolute margin space
   int d_marginX,d_marginY; //depend on painter DPI
   int d_autoReplot;

   bool d_zooming, d_zoom;

   QPoint d_p1,d_p2;
   QFont fscl,fttl;
   QRect rc[axisCnt];
   QRect rTitle, rPlot, rPix, rPainter, rLegend, rComment, rGraph;

   void init();
   void autoRefresh();
   void updateCursor(int x, int y);
   
 protected:
   int whichObject(QPoint &pt, uint *key=0);
   uint nearestCurve(QPoint &pt);
   void resizeEvent(QResizeEvent *e);
   void resizeObjects(QPainter &p, const QRect &r);
   void paintEvent(QPaintEvent *e);
   void drawContents(QPainter *p);
   void draw(QPainter &p, bool clip=TRUE);
   void updateAxes();
   void drawZoomer();
   void mouseMoveEvent(QMouseEvent *);
   void mousePressEvent(QMouseEvent *);
   void mouseReleaseEvent(QMouseEvent *);
   void mouseDoubleClickEvent(QMouseEvent *);
   int legendItemSize(QPainter &p) const;
   
   signals:
   void objectSelected(int type, uint key);
   void mouseMoved(const QMouseEvent &m);
   void mousePressed(const QMouseEvent &m);
   void mouseReleased(const QMouseEvent &m);
   void mouseDblClicked(const QMouseEvent &m);
   void objClick(const QMouseEvent *,int obj, uint key);
   void objDoubleClick(const QMouseEvent *,int obj, uint key);
   
 public slots:
   void replot();

 protected slots:
   void updatePixmap();

};

#endif // Samplin_Plot_included
