/**************************************************************************
 * $Id: rgpib_proc.c 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "ibSampLin.h"
#include "rgpib.h"

/*----------------------------------------------------------------------*/
void *rgpib_null_1_svc(void *req, struct svc_req *rqstp){

   DB(printf("nullproc called\n"));

   return(NULL);
}

/*----------------------------------------------------------------------*/
int *rgpib_gethandle_1_svc (struct gpib_request *req, struct svc_req *rqstp)
{
static int result;
   
   switch(req->request){
    case REQ_OPEN:
      DB(printf("Remote request open device '%s', address %d from %s\n",req->buf.buf_val, req->pad, req->client ));
      result=ibOpen(req->buf.buf_val,req->pad);
      DB(printf("Open device '%s', address %d, got handle %i\n",req->buf.buf_val,req->pad,result ));
      break;
    case REQ_CLOSE:
      DB(printf("Remote request close device handle %d, address %d\n",req->handle,req->pad ));      
      result=ibClose(req->handle,req->pad);
      DB(printf("Close device handle %d, address %d, got result %d\n",req->handle,req->pad,result ));            
      break;
   }
   return &result;
}

/*----------------------------------------------------------------------*/

struct gpib_request *rgpib_dorequest_1_svc (struct gpib_request *req, struct svc_req *rqstp)

{
   static struct gpib_request result;
   static char *tmpbuf = NULL;
   static char errmsg[80];
   int r;
   
   DB(printf("Remote request %d(%s) for handle %d, address %d\n",req->request,ibVerbCode(req->request),req->handle, req->arg));
   
   init_gpib_request(&result);
   result.request=req->request;
   
   switch(req->request) {
      
    case IBRD:
    case DVRD:
    DB(printf("ibrd: %d \n",req->count));
      
      if (tmpbuf){
       DB(printf("Freeing old buffer @ 0x%x \n",tmpbuf));
	 free(tmpbuf);
      }
      /*xdr_free(xdr_gpib_request, &result );*/
      /*
       * get the memory for the XDR result string
       */
      if(( tmpbuf = calloc( 1, req->count * sizeof(char) + 1 )) == NULL){
	 ibsta |= ERR;
	 fprintf(stderr,"Remote GPIB request Error: No more Memory !");
      } else {
	 DB(printf("Got %d bytes @ 0x%x for Read Buffer\n",req->count+1,tmpbuf));
      DB(printf("ibrd(req->handle=%i,tmpbuf=0x%x,req->count=%i)\n",
		req->handle,tmpbuf,req->count));
	 
	 if (( r = ibFunc(req->handle,req->request,req->arg,tmpbuf,req->count)) & ERR )
	   ibsta |= ERR;
	 else{
	    result.buf.buf_val = tmpbuf;
	    result.buf.buf_len = ibcnt;
	 }
	 
	 DB(printf("Read all %i bytes\n", ibcnt));
	 if (ibsta&ERR)
	   DB(printf("with errors\n"));
      }
      break;
    case IBWRT:
    case DVWRT:
      DB(printf("ibwrt: %s \n",req->buf.buf_val));
      if (( r = ibFunc(req->handle,req->request,req->arg,req->buf.buf_val,req->buf.buf_len)) & ERR )
	ibsta |= ERR;
      break;
    case IBCMD:
      DB(printf("ibcmd: %s \n",req->buf.buf_val));
      if (( r = ibFunc(req->handle,req->request,0,req->buf.buf_val, req->buf.buf_len)) & ERR )
	ibsta |= ERR;
      break;
    case IBWAIT:
      DB(printf("ibwait: 0x%x \n",req->arg));
      if (( r = ibFunc(req->handle,req->request,req->arg)) & ERR )
	ibsta |= ERR;
      break;
      
    case IBONL:
      DB(printf("ibonl: 0x%x \n",req->arg));
      if (( r = ibFunc(req->handle,req->request,req->arg)) & ERR )
      	ibsta |= ERR;
      break;
      
    case IBSIC:
      DB(printf("ibsic: \n"));
      if (( r = ibFunc(req->handle,req->request,req->arg)) & ERR )
	ibsta |= ERR;
      break;
      
    case IBSRE:
      DB(printf("ibsre: %d \n",req->arg ));
      if (( r = ibFunc(req->handle,req->request,req->arg)) & ERR )
	ibsta |= ERR;
      break;
      
    case IBGTS:
      DB(printf("ibgts: %d\n",req->arg));
      if (( r = ibFunc(req->handle,req->request,req->arg)) & ERR )
      	ibsta |= ERR;
      break;
      
    case IBCAC:
      DB(printf("ibcac: %d\n",req->arg));
      if (( r = ibFunc(req->handle,req->request,req->arg)) & ERR )
	ibsta |= ERR;
      break;
      
    case DVTRG:
      DB(printf("ibtrg \n"));
      if(( r = ibFunc( req->handle,req->request,req->arg )) & ERR )
	ibsta |= ERR;
      break;
      
    case DVCLR:
      DB(printf("ibclr %d\n",req->handle));
      if(( r = ibFunc( req->handle,req->request,req->arg )) & ERR )
	ibsta |= ERR;
    break;
      
    case DVRSP:
      DB(printf("ibrsp \n"));
      if (tmpbuf){
	 DB(printf("Freeing old buffer @ 0x%x \n",tmpbuf));
	 free(tmpbuf);
      }
      if(( tmpbuf = calloc( 1, sizeof(char) + 1 )) == NULL){
	 ibsta |= ERR;
	 fprintf(stderr,"Remote GPIB request Error: No more Memory !");
      } 
      else {
	 DB(printf("Got %d bytes @ 0x%x for RSP buffer\n",2,tmpbuf));
      
	 if(( r = ibFunc( req->handle,req->request,req->arg ,tmpbuf )) & ERR )
	   ibsta |= ERR;
	 else {
	    result.buf.buf_val=tmpbuf;
	    result.buf.buf_len=ibcnt;
	 }
      }
      break;
      
    case IBRPP:
    case IBTMO:
    case IBEOS:
    default:
      result.ibsta = CMPL | ERR;
      result.iberr = ENWE;
      strcpy(errmsg,"Request Not Implemented");
      result.buf.buf_val = errmsg;
      result.buf.buf_len = strlen(errmsg);
      break;
   }
   result.ibsta = ibsta;
   result.iberr = iberr;
   result.ibcnt = ibcnt;

   return &result;
}
