/***************************************************************************
                          TabData.cpp  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include "TabData.h"
#define Inherited QTabDialog

TabData::TabData
(
	KApplication *a,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, TRUE, 0 )
{
	mykapp = a;
	this->setCancelButton();
	this->setApplyButton();
	this->setOkButton();
	this->setBackgroundMode (QWidget::PaletteBackground);
	QWidget *w = new QWidget (this);
	General = new GeneralData(w,"General");
	addTab( w ,i18n("General"));
	w = new QWidget(this);
	Details = new DetailsData(w,"Details");
	addTab( w ,i18n("Details"));
	w = new QWidget(this);
	Extensions = new ExtensionsData(w,"Extensions");
	addTab(w , i18n("Extensions"));

	connect(this,SIGNAL(applyButtonPressed()), this, SLOT(slot_tabdata_apply()));
	connect(this,SIGNAL(cancelButtonPressed()), this, SLOT(slot_tabdata_cancel()));
	connect(this, SIGNAL(signal_tabdata_apply()),	General, SLOT(slot_generaldata_apply()));
	connect(this, SIGNAL(signal_tabdata_apply()),	Details, SLOT(slot_detailsdata_apply()));	
	connect(this, SIGNAL(signal_tabdata_apply()),	Extensions, SLOT(slot_extensionsdata_apply()));
	
	connect(this, SIGNAL(signal_tabdata_receivegeneral(QString)),	General, SLOT(slot_generaldata_receivegeneral(QString)));
	connect(this, SIGNAL(signal_tabdata_receivedetails(QString)),	Details, SLOT(slot_detailsdata_receivedetails(QString)));	
	connect(this, SIGNAL(signal_tabdata_receiveextensions(QString)),	Extensions, SLOT(slot_extensionsdata_receiveextensions(QString)));

	
	connect(General, SIGNAL(signal_generaldata_apply(QString)), this, SLOT(slot_tabdata_updategeneral(QString)));
	connect(Details, SIGNAL(signal_detailsdata_apply(QString)), this, SLOT(slot_tabdata_updatedetails(QString)));
	connect(Extensions, SIGNAL(signal_extensionsdata_apply(QString)), this, SLOT(slot_tabdata_updateextensions(QString)));
	
	this->setCaption(i18n("Infos"));
	
	resize( 490,400 );
	setMinimumSize( 490, 400 );
	setMaximumSize( 490, 400 );
}


TabData::~TabData()
{
}

void TabData::slot_tabdata_apply()
{
emit signal_tabdata_apply();
}

void TabData::slot_tabdata_cancel()
{
emit signal_tabdata_cancel();
}

void TabData::slot_tabdata_updategeneral(QString this_String)
{
StringTab1=this_String;
emit signal_tabdata_updategeneral(StringTab1);
}

void TabData::slot_tabdata_updatedetails(QString this_String)
{
StringTab2=this_String;
emit signal_tabdata_updatedetails(StringTab2);
}

void TabData::slot_tabdata_updateextensions(QString this_String)
{
StringTab3=this_String;
emit signal_tabdata_updateextensions(StringTab3);
}

void TabData::slot_tabdata_receivegeneral(QString this_string)
{
emit signal_tabdata_receivegeneral(this_string);
}

void TabData::slot_tabdata_receivedetails(QString this_string)
{
emit signal_tabdata_receivedetails(this_string);
}

void TabData::slot_tabdata_receiveextensions(QString this_string)
{
emit signal_tabdata_receiveextensions(this_string);
}
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
