/***************************************************************************
                          kcard.h  -  description
		This Class handles the card representation in the main Window
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <kapp.h>
#include <qlabel.h>
#include <qstring.h>
#include <qkeycode.h>
#include "Labels.h"
#define MAX_INFO 64

class Kcard : public QWidget
{
	Q_OBJECT
public:

	Kcard(
	KApplication *a=NULL,
	QWidget *_parent=NULL,
	const QString& name="",
	int posx=0,
	int posy=0,
	const QString& text="",
	int number=0
	);
	~Kcard();
	KApplication *mykapp;
	bool	hidden;
	Labels	*labels[MAX_INFO];
private:
   	QWidget	 *parent;
	bool		selected;
	bool		dclicked;
	
signals:
	void signal_kcard_ordercards();
	void signal_kcard_reorder_positions();
	void signal_kcard_whoselect(int);
	void signal_kcard_unselectall();
	void signal_kcard_clicked();
	void signal_kcard_dclicked();
	void signal_kcard_mousedcg(int,QString);
	void signal_kcard_mousedcd(int,QString);
	void signal_kcard_mousedce(int,QString);
	
public slots:
	void slot_kcard_delcard(int me);
	void slot_kcard_selectall();
	void slot_kcard_unselectall();
	void slot_kcard_invertselect();
	void slot_kcard_whoselect();
	void slot_kcard_mousePressEvent();
	void slot_kcard_mouseDoubleClickEvent();
	void slot_kcard_updategeneral(int,QString);
	void slot_kcard_updatedetails(int,QString);
	void slot_kcard_updateextensions(int,QString);
	void slot_kcard_show(int);
protected :
	int	numero;
	int	old_number_of_fields;
	void showsmalldata();
	void showmediumdata();
	void showcompletedata();
	void savecompletedata();
	void loadcompletedata();
	QString String_Extensions,String_Details,String_General;
};
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
