
#include <qlayout.h>
#include <qpushbutton.h>
#include <qbitmap.h>
//#include <kiconloader.h>

#include "ksiag_tableview.h"
#include "ksiag_app.h"
#include "ksiag_plugin.h"
#include "uparrow.h"


KSiagTableView::KSiagTableView (window *w, QWidget *parent,
                                const char *name)
    : QWidget(parent, name)
{
    QBitmap arrow(uparrow_width, uparrow_height, uparrow_bits, true);
    QVBoxLayout *layout = new QVBoxLayout(this);
    QHBoxLayout *top = new QHBoxLayout();
    QHBoxLayout *mid = new QHBoxLayout();
    QHBoxLayout *btm = new QHBoxLayout();
    QHBoxLayout *tablayout = new QHBoxLayout();

    QPushButton *resetpos = new QPushButton(this);
    hscroll = new QScrollBar(0, BUFFER_COLS, 1, 1, 0,
                             QScrollBar::Horizontal, this);
    vscroll = new QScrollBar(0, BUFFER_ROWS, 1, 1, 0,
                             QScrollBar::Vertical, this);
    tbl = new KSiagTable (w, this);
    hheader = new KSiagHorizHeader(tbl, this);
    vheader = new KSiagVertHeader(tbl, this);
    tabbar = new KSiagTabBar(this);
    /*
    KIconLoader *ldr = KApplication::getKApplication()->getIconLoader();
    QPushButton *add_btn = new QPushButton(this);
    QPushButton *sub_btn = new QPushButton(this);
    QPushButton *mult_btn = new QPushButton(this);
    QPushButton *div_btn = new QPushButton(this);
    */
    resetpos->setPixmap(arrow);
    /*
    add_btn->setPixmap(ldr->loadIcon("add.xpm"));
    sub_btn->setPixmap(ldr->loadIcon("sub.xpm"));
    mult_btn->setPixmap(ldr->loadIcon("mult.xpm"));
    div_btn->setPixmap(ldr->loadIcon("div.xpm"));
    */
    hscroll->setFixedHeight(hscroll->sizeHint().height());
    vscroll->setFixedWidth(vscroll->sizeHint().width());
    hheader->setFixedHeight(hheader->fontMetrics().height()+4);
    resetpos->setFixedHeight(hheader->height());
    vheader->setFixedWidth(((vheader->fontMetrics().maxWidth())*6)+4);
    resetpos->setFixedWidth(vheader->width());
    tabbar->setFixedHeight(tabbar->fontMetrics().height()+4);
    /*
    add_btn->setFixedHeight(tabbar->height());
    add_btn->setFixedWidth(tabbar->height());
    sub_btn->setFixedSize(add_btn->size());
    mult_btn->setFixedSize(add_btn->size());
    div_btn->setFixedSize(add_btn->size());
    */
    
    layout->addLayout(top, 0);
    layout->addLayout(mid, 1);
    layout->addLayout(btm, 0);
    layout->addLayout(tablayout, 0);

    top->addWidget(resetpos, 0);
    top->addWidget(hheader, 1);
    mid->addWidget(vheader, 0);
    mid->addWidget(tbl, 1);
    mid->addWidget(vscroll, 0);
    btm->addWidget(hscroll, 1);
    btm->addSpacing(vscroll->width());
    tablayout->addWidget(tabbar, 1);

    layout->activate();

    connect(tbl, SIGNAL(scrollHorizontal(int)), SLOT(setLeftCell(int)));
    connect(tbl, SIGNAL(scrollVertical(int)), SLOT(setTopCell(int)));
    connect(hscroll, SIGNAL(valueChanged(int)), SLOT(setLeftCell(int)));
    connect(vscroll, SIGNAL(valueChanged(int)), SLOT(setTopCell(int)));
    connect(resetpos, SIGNAL(clicked()), SLOT(gotoTop()));
    connect(tabbar, SIGNAL(tabChanged(const char *)),
            SLOT(setActiveBuffer(const char *)));
}

void KSiagTableView::addBufferTab(const char *name)
{
    tabbar->addTab(name);
}

bool KSiagTableView::removeBufferTab(const char *name)
{
    tabbar->removeTab(name);
    return (1);
}

bool KSiagTableView::changeBufferTab(const char *name, const char *newname)
{
    tabbar->changeTab(name, newname);
    return (1);
}

void KSiagTableView::positionPlugins()
{
    int pnum = tbl->siagWindow()->buf->nplugin;
    if (pnum){
        int i, x, y;
        plugin_t *tmp = tbl->siagWindow()->buf->plugin;
        for (i=0; i < pnum; ++i){
            KSiagPlugin *p = KSiagApp::pmanager()->plugin(tmp[i].ph);
            if(tbl->rowIsVisible(tmp[i].row-1) &&
               tbl->colIsVisible(tmp[i].col-1))
            {
                tbl->colXPos(tmp[i].col-1, &x);
                tbl->rowYPos(tmp[i].row-1, &y);
                p->move(x, y);
                if(!tmp[i].displayed)
                    p->show();
                tmp[i].displayed = 1;
            }
            else if (tmp[i].displayed){
                p->hide();
                tmp[i].displayed=0;
            }
        }
    }
}

void KSiagTableView::setLeftCell(int col)
{
    tbl->setLeftCell(col);
    hheader->setTopCell(col);
    hscroll->setSteps(1, tbl->lastColVisible() - tbl->leftCell());
    hscroll->setValue(col);
    positionPlugins();
}

void KSiagTableView::setTopCell(int row)
{
    tbl->setTopCell(row);
    vheader->setTopCell(row);
    vscroll->setSteps(1, tbl->lastRowVisible() - tbl->topCell());
    vscroll->setValue(row);
    positionPlugins();
}

void KSiagTableView::gotoTop()
{
    tbl->setLeftCell(0);
    tbl->setTopCell(0);
    hheader->setTopCell(0);
    vheader->setTopCell(0);
    set_point_row(w_list, 1);
    set_point_col(w_list, 1);
    hscroll->setSteps(1, tbl->lastColVisible() - tbl->leftCell());
    vscroll->setSteps(1, tbl->lastRowVisible() - tbl->topCell());
    hscroll->setValue(0);
    vscroll->setValue(0);
    tbl->setCursor();
    positionPlugins();
}

void KSiagTableView::resetBuffer()
{
    tbl->resetBuffer();
    hheader->repaint();
    vheader->repaint();
    positionPlugins();
    hscroll->setSteps(1, tbl->lastColVisible() - tbl->leftCell());
    vscroll->setSteps(1, tbl->lastRowVisible() - tbl->topCell());
    hscroll->setValue(0);
    vscroll->setValue(0);
}

void KSiagTableView::repaintAll()
{
    tbl->repaint(false);
    hheader->repaint();
    vheader->repaint();
}

void KSiagTableView::setActiveBuffer(const char *name)
{
    emit activateBuffer(this, name);
}

