
#include "ksiag_logwindow.h"
#include <qpushbutton.h>
#include <qlayout.h>
#include <qfile.h>
#include <kfiledialog.h>
#include <qtextstream.h>
#include <kseparator.h>

KSiagLogWindow::KSiagLogWindow()
    : QDialog()
{
    QHBoxLayout *buttons = new QHBoxLayout();
    QVBoxLayout *layout = new QVBoxLayout(this, 3);
    KSeparator *sep = new KSeparator(QFrame::HLine, this);
    QPushButton *save = new QPushButton("Save", this);
    QPushButton *clear = new QPushButton("Clear", this);
    QPushButton *exit = new QPushButton("Close", this);
    edit = new QMultiLineEdit(this);

    exit->setFixedSize(exit->fontMetrics().width("Close")+16,
                       exit->fontMetrics().height()+10);
    clear->setFixedSize(exit->width(), exit->height());
    save->setFixedSize(exit->width(), exit->height());
    edit->setReadOnly(true);

    resize(280,100);
    layout->addWidget(edit, 1);
    layout->addSpacing(2);
    layout->addWidget(sep, 0);
    layout->addLayout(buttons, 0);
    layout->addSpacing(2);

    buttons->addStretch(1);
    buttons->addWidget(save, 0);
    buttons->addSpacing(3);
    buttons->addWidget(clear, 0);
    buttons->addSpacing(3);
    buttons->addWidget(exit, 0);
    buttons->addSpacing(3);

    layout->activate();
    setCaption("KSiag debug log");
    connect (exit, SIGNAL(clicked()), SLOT(accept()));
    connect (clear, SIGNAL(clicked()), edit, SLOT(clear()));
    connect (save, SIGNAL(clicked()), SLOT(save()));
}

KSiagLogWindow::~KSiagLogWindow()
{
    ;
}

void KSiagLogWindow::save()
{
    const char *name = KFileDialog::getSaveFileName();
    QFile file(name);
    if(name && !file.open(IO_WriteOnly))
        return;
    QTextStream stream(&file);
    stream << edit->text();
    file.close();
}

void KSiagLogWindow::insert(const char *text)
{
    edit->insertLine(text);
}
    
    
    
