/* ###########################################################################
 *
 *                 The MiniBuffer Class
 *                 read minibuffer.h for more
 *                 information.
 *
 *           Copyright (C) 1995 1996 Matthias Ettrich
 *           and the LyX Team.
 *
 * ###########################################################################
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "klyx.h"
#include <qkeycode.h>
#include <qapp.h>

#include "filetools.h"
#include "lyx_main.h"
#include "lyxfunc.h"
#include "minibuffer.h"
#include "LyXView.h"
#include "error.h"

// 	$Id: minibuffer.C,v 1.7 1999/01/05 11:17:24 kulow Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: minibuffer.C,v 1.7 1999/01/05 11:17:24 kulow Exp $";
#endif /* lint */

extern bool keyseqUncomplete();
extern LString keyseqOptions(int l=190);
extern LString keyseqStr(int l=190);
extern LyXAction lyxaction;


MiniBuffer::MiniBuffer(LyXView *o)
  : owner(o)
{
  text = i18n("Welcome to LyX!");
  shows_no_match = true;
  history_idx = history_cnt = 0;
  owner->k_mini->installEventFilter(this);
}

void MiniBuffer::execute()
{
	lyxerr.debug("Getting ready to execute: " + cur_cmd);
	if (cur_cmd.empty()) {
		Init();
		return ;
	}
	Set(i18n("Executing:"), cur_cmd);
	addHistory(cur_cmd);
	
	// Split command into function and argument
	// This is done wrong Asger. Instead of <function argument>
	// it ends up as <argument function> Queer solution:
	LString arg = cur_cmd;
	LString function;
	if (arg.contains(" ")) {
		arg.split(function, ' ');
		function.strip();
	} else {
		function = arg;
		arg.clean();
	}
	lyxerr.print("Function: " + function);
	lyxerr.print("Arg     : " + arg);
	// Check if the name is valid (ale)
	// No, let the dispatch functions handle that.
	//int action = lyxaction.LookupFunc(function.c_str());
	//lyxerr.debug(LString("minibuffer action: ") + action);
	//if (action>=0) {
	    // Dispatch only returns requested data for a few commands (ale)
	LString res=owner->getLyXFunc()->Dispatch(function.c_str(),
						       arg.c_str());
	lyxerr.print(LString("Minibuffer Res: ") + res);
/*	if (!res.empty())
		if(owner->getLyXFunc()->errorStat())
			Set(i18n("Error:"), _(res.c_str()), "", 4);
		else
			Set(i18n("Result:"), _(res.c_str()), "", 4);
	else
		Init();
*/
	//} else {
#warning Look at this.
	//Set(i18n("Cannot find function"), function, "!");
	shows_no_match = false;
	//}

	return ;
}


void MiniBuffer::timerEvent( QTimerEvent * ){
  Init();
  killTimers();
}


void MiniBuffer::ExecCommand()
{
	text.clean();
	owner->k_mini->setFocus();
	owner->k_mini->setText(text.c_str());
}



// Added optional arg `delay_secs', defaults to 4.
//When 0, no timeout is done. RVDK_PATCH_5
void MiniBuffer::Set(LString const& s1, LString const& s2,
		     LString const& s3, int delay_secs)
{
	startTimer(1000 * delay_secs);

	LString ntext = s1 + ' ' + s2 + ' ' + s3;
	ntext.strip(' ');

	if (!owner->k_mini->hasFocus()){
	  if (ntext != (const char*) owner->k_mini->text())
	    owner->k_mini->setText(ntext.c_str());
	  text = ntext;
	}
}


void MiniBuffer::Init()
{
	// If we have focus, we don't want to change anything.
	if (owner->k_mini->hasFocus())
		return;

	// When meta-fake key is pressed, show the key sequence so far + "M-".
	if (owner->getLyXFunc()->wasMetaKey()) {
		text = owner->getLyXFunc()->keyseqStr();
		text += " M-";
	}

	// Else, when a non-complete key sequence is pressed,
	// show the available options.
	else if (owner->getLyXFunc()->keyseqUncomplete())
		text = owner->getLyXFunc()->keyseqOptions();

	// Else, show the buffer state.
	else {
		if (owner->currentView()->available()) {
			LString nicename =
				MakeDisplayPath(owner->currentBuffer()->
						getFileName());
			// Should we do this instead? (kindo like emacs)
			// leaves more room for other information
			text = "LyX: ";
			text += nicename;
			if (owner->currentBuffer()->lyxvc.inUse()) {
				text += " [RCS:";
				text += owner->currentBuffer()->lyxvc.getVersion();
				text += ' ';
				text += owner->currentBuffer()->lyxvc.getLocker();
				if (owner->currentBuffer()->isReadonly())
					text += " (RO)";
				text += ']';
			} else if (owner->currentBuffer()->isReadonly())
				text += " [RO]";
			if (!owner->currentBuffer()->isLyxClean())
				text += i18n(" (Changed)");
		} else {
			text = i18n("* No document open *");
		}
	}


	owner->k_mini->setText(text.c_str());
	
	killTimers();
	QApplication::flushX();
}


// allows to store and reset the contents one time. Usefull for
// status messages like "load font" (Matthias)
void MiniBuffer::Store()
{
	text_stored = owner->k_mini->text();
}


void MiniBuffer::Reset()
{
	if (!text_stored.empty()){
		Set(text_stored);
		text_stored.clean();
	}
}

void MiniBuffer::Activate()
{
}

void MiniBuffer::Deactivate()
{
}


bool MiniBuffer::eventFilter( QObject *o, QEvent *e ){
  if (o != owner->k_mini)
    return FALSE;
  if (e->type() != Event_KeyPress)
    return FALSE;

  QKeyEvent* ke = (QKeyEvent*)e;

  switch (ke->key()){
  case Key_Down:
    history_idx++;
    if (!getHistory().empty()) {
      owner->k_mini->setText(getHistory().c_str());
    } else
      history_idx--;
    return TRUE;
    break;
  case Key_Up:
    if (history_idx > 0) history_idx--;
    owner->k_mini->setText(getHistory().c_str());
    return TRUE;
    break;
  case Key_Tab:
    {
      // complete or increment the command
      const char *s = lyxaction.getApproxFuncName(owner->k_mini->text());
      if (s && s[0])
	owner->k_mini->setText(s);
    }
    return TRUE;
    break;
  case Key_Escape:
    // Abort
    owner->currentView()->getKCanvas()->setFocus();
    Init();
    return TRUE;
    break;
  case Key_Return:
    // Execute a command.
    cur_cmd = LString(owner->k_mini->text());
    execute();
    owner->currentView()->getKCanvas()->setFocus();
    return TRUE;
    break;
  }
  return FALSE;
}


