// -*- C++ -*-
/* This file is part of
 * ======================================================
* 
*           LyX, the High Level Word Processor
*        
*           Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team.
*
*======================================================*/

#ifndef _LYX_LIB_H
#define _LYX_LIB_H

#include <stdlib.h>
#include <time.h>

#include <kapp.h>
#include <klocale.h>

#include "LString.h"

/// generates an checksum
unsigned long lyxsum(char const *file);

/// returns a date string
inline char* date() 
{
	time_t tid;
	if ((tid=time(NULL)) == -1)
		return (char*)NULL;
	else
		return (ctime(&tid));
}


// Where can I put this?  I found the occurence of the same code
// three/four times. Don't you think it better to use a macro definition
// (an inlined member of some class)?
///
inline LString getUserName()
{
	LString userName ;
	userName = getenv("LOGNAME");
	if (userName.empty())
		userName = getenv("USER");
	if (userName.empty())
		userName = klocale->translate("unknown");
	return userName;
}


/// Returns the maximum of two integers.
inline
int Maximum(int a, int b)
{
	return ((a>b) ? a : b);
}


/// Returns the minimum of two integers.
inline
int Minimum(int a, int b)
{
	return ((a<b) ? a : b);
}

#endif
