/*
 * $Id: AskForTextDialog.C,v 1.6 1999/01/05 11:16:23 kulow Exp $
 */

#include "AskForTextDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qlayout.h>

AskForTextDialog::AskForTextDialog( LyXView* view, QWidget * parent=0, 
									const char * name=0, 
									WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  labelLA = new QLabel( this );
  
  editED = new QLineEdit( this );

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );

  setCaption( i18n( "Please enter text" ) );

  editED->setMinimumSize(editED->sizeHint());
  //The next line is that way, because since labelLA doesn't have a text
  //its sizeHint is (0,0). editED's one should be good enough.
  labelLA->setMinimumSize(editED->sizeHint());
  okPB->setMinimumSize(okPB->sizeHint());
  cancelPB->setMinimumSize(cancelPB->sizeHint());

  if (okPB->minimumSize().width() <75)
      okPB->setFixedWidth(75);
  if (cancelPB->minimumSize().width() <75)
      cancelPB->setFixedWidth(75);
  
  QVBoxLayout *v=new QVBoxLayout(this,5,5);
  QHBoxLayout *h=new QHBoxLayout();
  v->addWidget(labelLA,1);
  v->addWidget(editED,1);
  v->addLayout(h,0);
  h->addWidget(okPB,0);
  h->addStretch(10);
  h->addWidget(cancelPB,0);
  v->activate();

  resize(250,10);


}

void AskForTextDialog::okClicked()
{
  accept();
}


void AskForTextDialog::cancelClicked()
{
  reject();
}


QString AskForTextDialog::text()
{
  return editED->text();
}


void AskForTextDialog::setMessage( const char* text )
{
  labelLA->setText( text );
}


void AskForTextDialog::setDefault( const char* text )
{
  editED->setText( text );
}


void AskForTextDialog::setEditFocus()
{
 editED->setFocus();
}


/*
 * $Log: AskForTextDialog.C,v $
 * Revision 1.6  1999/01/05 11:16:23  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.5  1998/10/22 21:59:08  ettrich
 * fixes for the version control support (thanks to Dimitri Shlyakhtenko)
 *
 * Revision 1.4  1998/06/08 07:18:03  kalle
 * Lots of small changes (edit fields get focus, when they need it, Swedish spelling correction, etc. pp.)
 *
 * Revision 1.3  1998/03/05 21:28:19  ralsina
 * [Roberto] GMified AskForTextDialog
 *
 * Revision 1.2  1998/03/04 21:49:11  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/02/20 13:11:12  kalle
 * Added forgotten AskForTextDialog
 *
 */
