/***************************************************************************
                          kashview.h  -  description
                             -------------------
    begin                : Son Nov 21 15:23:42 CET 1999
    copyright            : (C) 1999 by Stephan Kahnt
    email                : stephan.kahnt@ipk.fhg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KASHVIEW_H
#define KASHVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qintdict.h>
#include <qdatetime.h>
#include <qmap.h>
#include <qlineedit.h>
#include <qstringlist.h> 
#include <qvalidator.h>

// include files for KDE

// application specific includes
#include "kashtransaction.h"
#include "kashlistviewitem.h"

class KashDoc;

/** The KashView class provides the view widget for the KashApp instance.	
 * The View instance inherits QWidget as a base class and represents the 
 * view object of a KTMainWindow. As KashView is part of the
 * docuement-view model, it needs a reference to the document object 
 * connected with it by the KashApp class to manipulate and display
 * the document structure provided by the KashDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KashView : public QWidget {
  Q_OBJECT
 public:
  /** Constructor for the main view */
  KashView(QWidget *parent = 0, const char *name=0);
  /** Destructor for the main view */
  ~KashView();
  /** returns a pointer to the document connected to the view instance. 
   *  Mind that this method requires a KashApp instance as a parent
   *  widget to get to the window document pointer by calling the 
   *  KashApp::getDocument() method.
   *
   * @see KashApp#getDocument
   */
  KashDoc *getDocument() const;
  /** contains the implementation for printing functionality */
  void print(QPrinter *pPrinter);

 public slots:
  /** adds or updates a transaction in the list view */  
  void slotListTransaction( long transId, StringVector& dataVec );
  /** removes all transactions from the list */
  void slotNewModel();
  /** even refuse input that is QValidator::Intermediate */
  void amountLineChanged( const QString & text );
  
 protected:
  QLineEdit* payeeLE;
  QLineEdit* catLE;
  QLineEdit* memoLE;
  QLineEdit* subCatLE;
  QLineEdit* amountLine;
  QLineEdit* nrLE;
  QLineEdit* dateLine;
  QLabel* balanceLabel;

 private:
  /** the transaction table */
  QListView* transTab;
  
  /** this dictionary maps ids of transactions to pointers of QLiewViewItems */
  QIntDict< KashListViewItem > idDict;

  /** the actual balance */
  double sum;
  
  /** an array for the header label */
  static const char* const headerLabel[];

 private slots:
  /** callback for the new button */
  void slotNewButton();
  /** callback for the delete button */
  void slotDelButton();
  /** callback for the update button */
  void slotUpdateButton();
  /** callback for a click in the transaction table */
  void slotTransTabClicked( QListViewItem* item );
  /** callback for a click on the header */
  void slotHeaderClicked( int headerNo = -1 );
};

/** a validator class to check the date input */
class KashDateValidator : public QValidator {
 public:
  KashDateValidator( QWidget* parent, const char* name = 0 ) :
    QValidator( parent, name ) {
  };
  /** checks the input of the date line edit */
  virtual State validate( QString &, int & ) const;
};

/** a QLineEdit class for the date input */
class KashDateLineEdit : public QLineEdit {
 public:
  KashDateLineEdit( QWidget* parent );
  /** handel the special keys for the date input */
  void keyPressEvent( QKeyEvent* ev );
};

/** a validator class to check the transaction amount input */
class KashAmountValidator : public QDoubleValidator {
 public:
  KashAmountValidator( double bottom, double top, 
		       int decimals, QWidget* parent, 
		       const char* name = 0 ) :
    QDoubleValidator( bottom, top, decimals, parent, name ) {
  };
  /** adds missing "0"'s behind the point */
  virtual void fixup( QString& input ) const;
};
#endif // KASHVIEW_H









