/***************************************************************************
                          kashlistviewitem.h  -  description
                             -------------------
    begin                : Son Nov 21 15:23:42 CET 1999
    copyright            : (C) 1999 by Stephan Kahnt
    email                : stephan.kahnt@ipk.fhg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KASHLISTVIEWITEM_H
#define KASHLISTVIEWITEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qlistview.h>
#include <qdatetime.h>

// include files for KDE

// application specific includes

class KashListViewItem : public QListViewItem {
 public:
  KashListViewItem( QListView* parent, long aTransId );
  
  long transId();

  virtual QString key( int column, bool ascending ) const;

  virtual void setText( int column, const QString & text );

  double amount();
 private:
  /** this is the id of the transaction in the document */
  long id;
  /** actually the date is updated by a QString, but is then converted
      and saved in this variable for sorting */
  QDate date;
  /** actually the amount is updated by a QString, but is then converted
      and saved in this variable for calculating */
  double am;
};

#endif // KASHLISTVIEWITEM_H





