/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* web.cpp */

// Adapted from _UNIX_Network_Programming, 2nd Edition
// by W. Richard Stevens
#include <stdlib.h>
#include <qapp.h>
#include "web.h"


/* Write "n" bytes to a descriptor. */

ssize_t writen(int fd, const void *vptr, size_t n)
{
    size_t		nleft;
    ssize_t		nwritten;
    const char	*ptr;

    // ptr = vptr;
    ptr = (const char*)vptr;
    nleft = n;
    while (nleft > 0) {
	if ( (nwritten = write(fd, ptr, nleft)) <= 0) {
	    if (errno == EINTR)
		nwritten = 0;		/* and call write() again */
	    else
		return(-1);			/* error */
	}

	nleft -= nwritten;
	ptr   += nwritten;
    }
    return(n);
}
/* end writen */

void Writen(int fd, void *ptr, ssize_t nbytes)
{
    if (writen(fd, ptr, nbytes) != nbytes)
	warning("kwebwatch: written error");
}


///////////////////////////////////////////

int tcp_connect(const char* host, const char* serv)
{
    int sockfd = -1;
    int len;
    struct sockaddr_in address;
    struct hostent* 	  hostinfo;
         
    hostinfo = gethostbyname(host);
    if( !hostinfo )
    {
	warning( "kwebwatch ERROR: can't get host" );
    }
    else
    {
	sockfd = socket(AF_INET, SOCK_STREAM, 0);
	 	   
	address.sin_family = AF_INET;
	address.sin_port = htons(atoi(serv));
	address.sin_addr = *(struct in_addr *)*hostinfo->h_addr_list;
	len = sizeof( address );
	   	   
	if( -1 ==  connect( sockfd, (struct sockaddr *)&address, len) )
	{
	    warning( "kwebwatch: connect failed" );
	    close(sockfd);
	    sockfd = -1;
	}
	
    }
	
    return sockfd;
}





