/***************************************************************************
                          sshdialog.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Sep 17 1999                                           
    copyright            : (C) 1999 by Andrea Rizzi                         
    email                : rizzi@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "sshdialog.h"
#include "optionsdia.h"
#include <qapp.h>
#include <kapp.h>
#include <qdialog.h>
#include <stdlib.h>
#include <kiconloader.h>
#include <kstddirs.h>
//#include <kmsgbox.h>
#include <qmsgbox.h>
#include <qtooltip.h>
#include <unistd.h>
#include <kwin.h> 
SshDialog::SshDialog(QWidget *parent, const char *name)
: QDialog(parent,name)
{
  app=KApplication::kApplication();
  config=app->config();
  initDialog();
  connect(QPushButton_2,SIGNAL(clicked()),qApp,SLOT(quit()));
  connect(QPushButton_1,SIGNAL(clicked()),SLOT(launch()));
  connect(KCombo_1,SIGNAL(highlighted(const QString &)),SLOT(hostChanged(const QString &)));
  connect(QPushButton_3,SIGNAL(clicked()),SLOT(about()));
  connect(QPushButton_4,SIGNAL(clicked()),SLOT(options()));
  connect(QCheckBox_1,SIGNAL(toggled(bool)),SLOT(enableSpin(bool)));
  connect(QLineEdit_1,SIGNAL(textChanged(const QString&)),SLOT(userChanged(const QString&)));
  fillCombo();
  KWin::setIcons(this->winId(), app->icon(), app->miniIcon());
  QToolTip::add(QPushButton_2,i18n("Exit kssh"));
  QToolTip::add(QPushButton_1,i18n("Launch ssh"));
  QToolTip::add(QPushButton_3,i18n("Information about kssh"));
  QToolTip::add(QPushButton_4,i18n("General kssh options"));
  QToolTip::add(QCheckBox_1,i18n("Force ssh to use a port, default of ssh is 22"));
  QToolTip::add(QLineEdit_1,i18n("Username on remote host"));
  QToolTip::add(KCombo_1,i18n("Remote host"));
}

SshDialog::~SshDialog(){
}

void SshDialog::fillCombo()
{
KCombo_1->clear();
  config->setGroup("Host List");
  for(int va=1;va<=config->readNumEntry("NumHost");va++)
      {
	      QString sstr;
        sstr.sprintf("Host%d",va);
	      KCombo_1->insertItem(config->readEntry(sstr));
      }
 config->setGroup("Options");
 QCheckBox_1->setChecked(config->readBoolEntry("UsePort"));
 hostChanged(KCombo_1->currentText());
/*
  config->setGroup("User List");
	QLineEdit_1->setText(config->readEntry(KCombo_1->currentText()));
	config->setGroup("Port List");
	QCheckBox_1->setChecked(config->readBoolEntry(KCombo_1->currentText()));
	config->setGroup("PortNum List");
	QSpinBox_1->setValue(config->readNumEntry(KCombo_1->currentText()));
  int p=config->readNumEntry(a);
  if (p==0) p=22;
	QSpinBox_1->setValue(p);
*/
}

void SshDialog::setHostName(QString host)
{
KCombo_1->setEditText(host);
}

void SshDialog::setUserName(QString user)
{
QLineEdit_1->setText(user);
}


void SshDialog::launch()
{
 QString stringa;
 QString host(KCombo_1->currentText());
 QString user(QLineEdit_1->text());
 bool withPort=QCheckBox_1->isChecked();
 QString porta(QSpinBox_1->text());
 config->setGroup("Options");
 QString termCom(config->readEntry("Terminal"));
 QString sshCom(config->readEntry("SshCommand"));

 if(config->readBoolEntry("AutoSave"))
 {
  config->setGroup("Host List");

  int va;
	      QString sstr;
  bool hExist=false;
  for(va=0;va<KCombo_1->count();va++)
      {

        sstr.sprintf("Host%d",va+1);
			  stringa=KCombo_1->text(va);
	      if(stringa==host) hExist=true;
        config->writeEntry(sstr,stringa);
      }

      if(!hExist)
          {
             sstr.sprintf("Host%d",va+1);
	           config->writeEntry(sstr,host);
						 config->writeEntry("NumHost",KCombo_1->count()+1);			
          }
      	   else
					    config->writeEntry("NumHost",KCombo_1->count());

   }

   config->setGroup("Options");
   if(config->readBoolEntry("SaveHostSettings"))
    {
     config->setGroup("User List");
	   config->writeEntry(host,user);
	   config->setGroup("Port List");
     config->writeEntry(host,withPort);
	   config->setGroup("PortNum List");
     config->writeEntry(host,atoi(porta));
     config->sync();
    }


switch(fork())
 {
 case -1:
 warning("Unable to fork!!");
 exit(1);
 break;
 case 0: /* child */
 if(withPort)
  execlp((const char *)termCom,(const char *)termCom,"-e",(const char *)sshCom,"-l",
     (const char *)user,(const char *)host,"-p",(const char *) porta,NULL);
 else
 execlp((const char *)termCom,(const char *)termCom,"-e",(const char *)sshCom,"-l",
     (const char *)user,(const char *)host,NULL);
  
warning("exec:cannot open console");
_exit(1);
 break;
default:
 exit(0);
break;
}

_exit(127);


}
void SshDialog::about()
{   			
QString message;
message.sprintf( i18n("   K Secure Shell front-end, v. %d.%d  \n\n  (C)  Andrea Rizzi <rizzi@kde.org>    \n         Kevin Lo <kevlo@kde.org>\n              1999-2000 \n"),0,4);

QMessageBox *b= new QMessageBox(      "About KDE SSH",message,
			QMessageBox::Warning, 0,0,  0,this);
b->setIconPixmap(QPixmap(locate("icon","hicolor/48x48/apps/kssh.png")));
b->show();


}
void SshDialog::options()
{
 new OptionsDia();
  fillCombo();
}


void SshDialog::enableSpin(bool a)
{
 QSpinBox_1->setEnabled(a);
}

void SshDialog::userChanged(const QString& a)
{
 if(a.isEmpty())
  QPushButton_1->setEnabled(false);
 else
  QPushButton_1->setEnabled(true);
QString t;
}

void SshDialog::hostChanged(const QString &a)
{
  config->setGroup("Options");
  if(config->readBoolEntry("UseHostSettings"))
  {
	  config->setGroup("User List");
		QLineEdit_1->setText(config->readEntry(a));
		config->setGroup("Port List");
		QCheckBox_1->setChecked(config->readBoolEntry(a));
		config->setGroup("PortNum List");
	  int p=config->readNumEntry(a);
	  if (p==0) p=22;
	  QSpinBox_1->setValue(p);
  }
	
}











































