/***************************************************************************
                          knetstartdoc.h  -  A simple netconfig tool
                             -------------------
    begin                : Thu Sep 30 20:48:28 CDT 1999
    copyright            : (C) 1999 by F David Sacerdoti
    email                : fds@slinuxmachines.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KNETSTARTDOC_H
#define KNETSTARTDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>

// Defines
// The device for this program will be ethernet. There are many reasons for this, the
// most important being ethernet's good design and pervasiveness.
#define NETDEVICE "eth0"

// forward declaration of the Knetstart classes
class KnetstartView;
class KConfig;
class KProcess;
class QTimer;

/**	KnetstartDoc provides a document object for a document-view model.
  *
	* The KnetstartDoc class provides a document object that can be used in conjunction with the classes KnetstartApp and KnetstartView
	* to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
	* is created by the KnetstartApp instance and contains the document structure with the according methods for manipulation of the document
	* data by KnetstartView objects. Also, KnetstartDoc contains the methods for serialization of the document data from and to files.
	*
	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
	* @version KDevelop version 0.4 code generation
	*/
class KnetstartDoc : public QObject
{
  Q_OBJECT

 public:
  /** Constructor for the fileclass of the application */
  KnetstartDoc(QWidget* parent, const char *name=0);
  /** Destructor for the fileclass of the application */
  ~KnetstartDoc();
	/** adds a view to the document which represents the document contents. Usually this is your main view. */
  void addView(KnetstartView* m_pView);
	/** removes a view from the list of currently connected views */
	void removeView(KnetstartView* m_pView);
	
	/* THESE METHODS ARE NOT USED */
  /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
  void setModified(bool modified=true){ b_modified=modified; }
	/** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
  bool isModified(){ return b_modified;}
	/** "save modified" - asks the user for saving if the document is modified */
	bool saveModified();	
	/** deletes the document's contents */
	void deleteContents();
	/** initializes the document generally */
	bool newDocument();
	/** closes the acutal document */
	void closeDocument();
	/** loads the document by filename and format and emits the updateViews() signal */
  bool openDocument(const char* filename, const char* format=0);
  /** saves the document under filename and format.*/	
  bool saveDocument(const char* filename, const char* format=0);
	/** sets the path to the file connected with the document */
	void pathName(const char* path_name);
	/** returns the pathname of the current document file*/
	const QString& getPathName() const;
	/** sets the filename of the document */
	void title(const char* title);
	/** returns the title of the document */
	const QString& getTitle() const;
	/*********************************/
	
	/** Puts the gateway and nameserver IP addresses in their config files */
 	bool commitNetConfig(const QString & g, const QString & n);
 	/** Makes ethernet configuration file for RedHat's network script
 	 * The netmast and broadcast addresses are automatically discovered using /bin/ipcalc */
 	bool commitEthConfig(const QString & i);
 	/** Runs RedHat's network start script /etc/rc.d/init.d/network */
 	void activateNet();
 	
 	/** Reads the most recent network configuration from the config file
 	    The default nameserver used is a public DNS server with good ping times */
 	void readRecent (KConfig *config);
 	
 	/** Accessor for the DCHP variable. If useDHCP is true, commitEthConfig will set
 	  * BOOTPROTO=dhcp in the interface config file	*/
	bool useDhcp () { return dhcp; }
	/** Accessors for network parameters */
	QString getIp() {return ip;}
	QString getGateway() {return gateway;}
	QString getNs() {return ns;}
	
	/** Runs the internal DHCP client. This client is Pump v0.6.7
	 and conforms to all features and bugs of that package. */
	bool pumpUpTheDhcp ();

	/** Tries to ping the supplied network node by its ip address */
	void pingNode (const QString & node);
	
 signals:
	void statusMsg(const char *);
	void statusHelpMsg(const char *);
	void dhcpToggled(bool);

 public slots:
 	/** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
 	  * As this view normally repaints itself, it is excluded from the paintEvent. */
 	void slotUpdateAllViews(KnetstartView* pSender);
 	/** Changes the state of the DHCP variable */
 	void slotDhcp(bool);
 	
 	
 public:	
 	/** the list of the views currently connected to the document */
	static QList<KnetstartView>* viewList;	
	
 protected:
 	/** searches for a keyword 'KEY=' on a line **/
 	bool lookFor(const char* line, const char* keyword);
 	/** swaps files as root user **/
 	bool installConfig(const char*, const char*);


 protected slots:
  /** Waits for the network script to exit. Also starts the network
  	  discovery routines */
	bool slotNetworkCleaner(KProcess *);
	/** Waits for a ping system call to exit. It knows which node it is pinging
			via the "node" attribute */
	bool slotPingCleaner (KProcess *);	
	/** Timer callback to catch long pings. This timer event will kill the ping process */
  void slotPingDead ();

 protected:
 	/** IP address of the 'Me' node, the machine this program is running on */
 	QString ip;
 	/** IP address of the Gateway node **/
 	QString gateway;
 	/** IP address of the Nameserver node **/
 	QString ns;
 	/** State variable. Keeps track of which network node is being discovered */
 	QString node;
 	/** The KProcess object for pinging */
 	KProcess * ping;
 	/** Timer to catch long pings */
 	QTimer *pingTimer;
 	/** indicates wether DHCP should be used to find the host's IP address */
 	bool dhcp;

 	
 private:
 	/** the modified flag of the current document */
 	bool b_modified;
	QString m_title;
	QString m_path;

};

#endif // KNETSTARTDOC_H
























































