/***************************************************************************
                          knetstart.cpp  -  A simple netconfig tool
                             -------------------
    begin                : Thu Sep 30 20:48:28 CDT 1999
    copyright            : (C) 1999 by Federico David Sacerdoti
    email                : fds@slinuxmachines.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include <knetstart.h>
#include "knetstartview.h"
#include "knetstartdoc.h"
#include "resource.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

KnetstartApp::KnetstartApp()
{
	config=kapp->getConfig();
	
	this->make_directories();
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initKeyAccel();
  initDocument();

  readOptions();

  initView();

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup

  //disableCommand(ID_FILE_SAVE);
  //disableCommand(ID_FILE_SAVE_AS);
  //disableCommand(ID_FILE_PRINT);
 	
  disableCommand(ID_EDIT_CUT);
  disableCommand(ID_EDIT_COPY);
  disableCommand(ID_EDIT_PASTE);

  if (width() > 500) resize(500, height());

}

KnetstartApp::~KnetstartApp()
{

}

void KnetstartApp::initKeyAccel()
{
	key_accel = new KAccel( this );
	
	// file_menu accelerators
	//key_accel->connectItem( KAccel::New, this, SLOT( slotFileNew() ) );
	//key_accel->connectItem( KAccel::Open, this, SLOT( slotFileOpen() ) );
	//key_accel->connectItem( KAccel::Save, this, SLOT( slotFileSave() ) );
	//key_accel->connectItem( KAccel::Close, this, SLOT( slotFileClose() ) );
	//key_accel->connectItem( KAccel::Print, this, SLOT( slotFilePrint() ) );
	key_accel->connectItem( KAccel::Quit, this, SLOT( slotFileQuit() ) );
	// edit_menu accelerators
	key_accel->connectItem( KAccel::Cut, this, SLOT( slotEditCut() ) );
	key_accel->connectItem( KAccel::Copy, this, SLOT( slotEditCopy() ) );
	key_accel->connectItem( KAccel::Paste, this, SLOT( slotEditPaste() ) );

	key_accel->connectItem( KAccel::Help, kapp, SLOT( appHelpActivated() ) );
			
	key_accel->changeMenuAccel(	file_menu, ID_FILE_NEW, KAccel::New );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_OPEN, KAccel::Open );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_SAVE, KAccel::Save );
	key_accel->changeMenuAccel( file_menu, ID_FILE_CLOSE, KAccel::Close );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_PRINT, KAccel::Print );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_QUIT, KAccel::Quit );

  key_accel->changeMenuAccel(	edit_menu, ID_EDIT_CUT, KAccel::Cut );
  key_accel->changeMenuAccel(	edit_menu, ID_EDIT_COPY, KAccel::Copy );
  key_accel->changeMenuAccel(	edit_menu, ID_EDIT_PASTE, KAccel::Paste );

  key_accel->readSettings();	
}

QString KnetstartApp::about() {
	QString aboutKn;
	aboutKn = kapp->appName()+" "+VERSION+"\n\n\
--- Red Hat network tool for Ethernet Cards -----\n\n\
Net Device: \n\
 Eth0 is the active net interface. This ethernet device must be previously configured.\n\
 This is done by choosing the right kernel module for your brand of card (3com: 3c59x, Intel: eepro100).\n\n\
RedHat Scripts used: \n\
 To start networking: \n\
   /etc/rc.d/init.d/network restart \n\n\
Files Modified:\n\
 For those who care, this program edits the following files.\n\
 /etc/sysconfig/network \n\
 /etc/sysconfig/network-scripts/ifcfg-eth0 \n\
 /etc/resolv.conf \n\n\
Note: The default nameserver is ns.granitecanyon.com, a public DNS server.\n\
 (205.166.226.38 or 216.17.165.20)\n\n\
1999 by Federico David Sacerdoti \n\
www.slinuxmachines.com";

	return aboutKn;
}

void KnetstartApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
	file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Use Public Nameserver"), ID_FILE_NS );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );
	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  edit_menu = new QPopupMenu();
  edit_menu->insertItem(Icon("editcut.xpm"), i18n("Cu&t"), ID_EDIT_CUT );
  edit_menu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY );
  edit_menu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  QString aboutstring=about();

  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, aboutstring );

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Edit"), edit_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(file_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(file_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(edit_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(edit_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(view_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(view_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

}

void KnetstartApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  toolBar()->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut") );
  toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy") );
  toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked() ),
  				kapp, SLOT( appHelpActivated() ), true,i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE WITH toolBar(n)


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
	// connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
	// connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));

}

void KnetstartApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
	// TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG );

}

void KnetstartApp::initDocument()
{
  doc = new KnetstartDoc(this);
  //doc->newDocument();

  //Connect status bar
  connect(doc, SIGNAL(statusMsg(const char*)), SLOT(slotStatusMsg(const char *)));
  connect(doc, SIGNAL(statusHelpMsg(const char*)), SLOT(slotStatusHelpMsg(const char *)));

}

void KnetstartApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new KnetstartView(this);
  doc->addView(view);
  setView(view);
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+ "Ethernet Setup");

  //Connect status bar
  connect(view, SIGNAL(statusMsg(const char*)), SLOT(slotStatusMsg(const char *)));
  connect(view, SIGNAL(statusHelpMsg(const char*)), SLOT(slotStatusHelpMsg(const char *)));

  //Connect DHCP state between Doc and View
  connect(doc, SIGNAL(dhcpToggled(bool)), view, SLOT(slotDhcp(bool)));

  //Connect File->use public nameserver
  connect(this, SIGNAL(usePubNs(const char*)), view, SLOT(slotUsePubNs(const char*)));

}

void KnetstartApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KnetstartApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}


KnetstartDoc* KnetstartApp::getDocument() const
{
	return doc;
}

void KnetstartApp::saveOptions()
{	
	config->setGroup("General Options");
	config->writeEntry("Geometry", size() );
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos",  (int)toolBar()->barPos());
	//config->writeEntry("Recent Files", recent_files);
	
	config->setGroup("Network");
	config->writeEntry("DHCP", doc->useDhcp());
	config->writeEntry("IP", doc->getIp());
	config->writeEntry("Gateway", doc->getGateway());
	config->writeEntry("NameServer", doc->getNs());
}


void KnetstartApp::readOptions()
{
	
	config->setGroup("General Options");

	// bar status settings
	bool bViewToolbar = config->readBoolEntry("Show Toolbar", false);
	view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
	if(!bViewToolbar)
		enableToolBar(KToolBar::Hide);
	
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
	view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
	if(!bViewStatusbar)
		enableStatusBar(KStatusBar::Hide);
	
	// bar position settings
	KMenuBar::menuPosition menu_bar_pos;
	menu_bar_pos=(KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition tool_bar_pos;
  tool_bar_pos=(KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

	menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);
	
  // initialize the recent file list
	//recent_files.setAutoDelete(TRUE);
	//config->readListEntry("Recent Files",recent_files);
	
	//uint i;
	//for ( i =0 ; i < recent_files.count(); i++){
    //recent_files_menu->insertItem(recent_files.at(i));
  //}

  QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty())
		resize(size);
		
	//Read recent Network configuration
	doc->readRecent(config);
	
}

void KnetstartApp::saveProperties(KConfig* )
{
/*	if( doc->getTitle() != i18n("Untitled") && !doc->isModified()){
		return;
	}
	else{
		QString filename=doc->getPathName()+doc->getTitle();	
    config->writeEntry("filename",filename);
    config->writeEntry("modified",doc->isModified());
		
		const char* tempname = kapp->tempSaveName(filename);
		doc->saveDocument(tempname);
	}
*/
}


void KnetstartApp::readProperties(KConfig*)
{
/*	QString filename = config->readEntry("filename","");
	bool modified = config->readBoolEntry("modified",false);
  if( modified ){
  	bool b_canRecover;
		QString tempname = kapp->checkRecoverFile(filename,b_canRecover);
  	
  	if(b_canRecover){
   			doc->openDocument(tempname);
   			doc->setModified();
   			QFileInfo info(filename);
   			doc->pathName(info.absFilePath());
   			doc->title(info.fileName());
   			QFile::remove(tempname);
		}
	}
 	else if(!filename.isEmpty()){
		doc->openDocument(filename);
	}
*/
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+ "Ethernet Setup");
}		

bool KnetstartApp::queryClose()
{
	//return doc->saveModified();
	return true;
}

bool KnetstartApp::queryExit()
{
	saveOptions();
	return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////


void KnetstartApp::slotFileQuit()
{
	saveOptions();
	// close the first window, the list makes the next one the first again.
	// This ensures that queryClose() is called on each window to ask for closing
	KTMainWindow* w;
	if(memberList){
		for(w=memberList->first(); w; w=memberList->first()){
			// only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
			// the window and the application stay open.
			if(!w->close())
				break;
		}
	}	
}

void KnetstartApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  slotStatusMsg(i18n("Ready."));
}

void KnetstartApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to Clipboard..."));

  slotStatusMsg(i18n("Ready."));
}

void KnetstartApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting Clipboard contents..."));

  slotStatusMsg(i18n("Ready."));
}

void KnetstartApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
	if( view_menu->isItemChecked(ID_VIEW_TOOLBAR))
	  view_menu->setItemChecked(ID_VIEW_TOOLBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_TOOLBAR, true);
		
  enableToolBar();

  slotStatusMsg(i18n("Ready."));
}

void KnetstartApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
	if( view_menu->isItemChecked(ID_VIEW_STATUSBAR))
	  view_menu->setItemChecked(ID_VIEW_STATUSBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_STATUSBAR, true);

  enableStatusBar();

  slotStatusMsg(i18n("Ready."));
}


void KnetstartApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KnetstartApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void KnetstartApp::commandCallback(int id_){
  switch (id_){
  	case ID_FILE_NS:
  		emit usePubNs(PUBNS);
  		break;
    case ID_FILE_QUIT:
    	slotFileQuit();
    	break;

    case ID_EDIT_CUT:
    	slotEditCut();
    	break;
    case ID_EDIT_COPY:
    	slotEditCopy();
    	break;
    case ID_EDIT_PASTE:
    	slotEditPaste();
    	break;
  
    case ID_VIEW_TOOLBAR:
    	slotViewToolBar();
    	break;
    case ID_VIEW_STATUSBAR:
    	slotViewStatusBar();
    	break;
    default:
    	break;
  }
}

void KnetstartApp::statusCallback(int id_){
  switch (id_){
  	case ID_FILE_NS:
  		slotStatusHelpMsg(i18n("Uses the public nameservers from granitecanyon.com"));
  		break;
    case ID_FILE_QUIT:{
    	QString caption=kapp->getCaption();
    	slotStatusHelpMsg(i18n("Exits "+ caption));
    	break;
    }
    case ID_EDIT_CUT:
    	slotStatusHelpMsg(i18n("Cuts the selected section and puts it to the clipboard"));
    	break;
    case ID_EDIT_COPY:
    	slotStatusHelpMsg(i18n("Copys the selected section to the clipboard"));
    	break;
    case ID_EDIT_PASTE:
    	slotStatusHelpMsg(i18n("Pastes the clipboard contents to actual position"));
    	break;

    case ID_VIEW_TOOLBAR:
    	slotStatusHelpMsg(i18n("Enables / disables the actual Toolbar"));
    	break;
    case ID_VIEW_STATUSBAR:
    	slotStatusHelpMsg(i18n("Enables / disables the actual Statusbar"));
    	break;
		default:
			break;
  }
}


void KnetstartApp::make_directories() {

  QDir dir;
  QString d = KApplication::localkdedir();

  dir.setPath(d.data());
  if(!dir.exists()){
    dir.mkdir(d.data());
    chown(d.data(),getuid(),getgid());
    chmod(d.data(),S_IRUSR | S_IWUSR | S_IXUSR);
  }

  d += "/share";
  dir.setPath(d.data());
  if(!dir.exists()){
    dir.mkdir(d.data());
    chown(d.data(),getuid(),getgid());
    chmod(d.data(),S_IRUSR | S_IWUSR | S_IXUSR);
  }

  d += "/apps";
  dir.setPath(d.data());
  if(!dir.exists()){
    dir.mkdir(d.data());
    chown(d.data(),getuid(),getgid());
    chmod(d.data(),S_IRUSR | S_IWUSR | S_IXUSR);
  }

  d += "/knetstart" ;

  dir.setPath(d.data());
  if(!dir.exists()){
    dir.mkdir(d.data());
    chown(d.data(),getuid(),getgid());
    chmod(d.data(),S_IRUSR | S_IWUSR | S_IXUSR);
  }

}







































































