/***************************************************************************
                          clientconfig.cpp  -  description
                             -------------------
    begin                : Tue Aug 24 1999
    copyright            : (C) 1999 by Darren Poulson
    email                : daz@flapper.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "clientconfig.h"

ClientConfig::ClientConfig (QWidget *parent, const char *name ) : QWidget(parent,name){

			KConfig *config = KApplication::getKApplication()->getConfig();


      this->setGeometry(this->x(),this->y(),200,300);
      this->setMinimumSize(210,350);
			this->setCaption("Configure");

      servernamelabel = new QLabel(this);
      serverport = new QLineEdit(this);
      serverportlabel = new QLabel(this);
      servername = new QLineEdit(this);
      autoconnect = new QCheckBox(this);
      username = new QLineEdit(this);
      userpassword = new QLineEdit(this);
      usernamelabel = new QLabel(this);
      userpasswordlabel = new QLabel(this);
			autoauth = new QCheckBox(this);
			autodial = new QCheckBox(this);
			autodialname = new QLineEdit(this);
			autodialnamelabel = new QLabel(this);


      serverportlabel->setGeometry(this->width() - 35 - 10, 5, 35, 25);
      serverport->setGeometry(this->width() - 35 - 10, 30, 35, 25);
      servernamelabel->setGeometry(10, serverportlabel->y(), this->width() - (20 + serverportlabel->width()), 25);
      servername->setGeometry(10, serverport->y(), this->width() - (20 + serverport->width()), 25);
      autoconnect->setGeometry(10, servername->y() + 25, this->width(), 25);
      usernamelabel->setGeometry(10, autoconnect->y() +25, (this->width() - 20),25);
      username->setGeometry(10,usernamelabel->y() +25, (this->width() - 20), 25);
      userpasswordlabel->setGeometry(10, username->y() +25, (this->width() - 20),25);
      userpassword->setGeometry(10,userpasswordlabel->y() + 25, (this->width() -20),25);
      autoauth->setGeometry(10, userpassword->y() +25, this->width() -20 , 25);
      autodial->setGeometry(10, autoauth->y() +25, this->width() -20 , 25);
			autodialnamelabel->setGeometry(10, autodial->y() +25, this->width() - 20 , 25);
			autodialname->setGeometry(10, autodialnamelabel->y() + 25, this->width() - 20 , 25);

     	userpassword->setEchoMode(QLineEdit::Password);


      serverportlabel->setText(i18n("Port"));
      servernamelabel->setText(i18n("Server"));
      usernamelabel->setText(i18n("User name"));
      userpasswordlabel->setText(i18n("Password"));
      autoconnect->setText(i18n("Autoconnect to server?"));
      servername->setText(config->readEntry("servername"));
      serverport->setText(config->readEntry("serverport"));
      autoconnect->setChecked(config->readBoolEntry("autoconnect"));
      username->setText(config->readEntry("username"));
      userpassword->setText(config->readEntry("userpassword"));
			autoauth->setText(i18n("Automatically authorize user"));
			autoauth->setChecked(config->readBoolEntry("autoauth"));
			autodial->setText(i18n("Automatically dial connection"));
			autodial->setChecked(config->readBoolEntry("autodial"));
			autodialnamelabel->setText(i18n("Dial which connection"));
			autodialname->setText(config->readEntry("autodialname"));
     	
     	ok = new QPushButton(i18n("OK"), this);
	    ok->setGeometry(  ((this->width()/2)-(ok->width()/2)) , this->height() - ok->height() - 5 , ok->width() , ok->height()  );
      connect(ok, SIGNAL(clicked()), this, SLOT(saveconf()));
	    connect(ok, SIGNAL(clicked()), this, SLOT(hide()));

}


void ClientConfig::resizeEvent (QResizeEvent *)
{
	resizeEvent();
}

void ClientConfig::resizeEvent ()
{
      serverportlabel->setGeometry(this->width() - 35 - 10, 5, 35, 25);
      serverport->setGeometry(this->width() - 35 - 10, 30, 35, 25);
      servernamelabel->setGeometry(10, serverportlabel->y(), this->width() - (20 + serverportlabel->width()), 25);
      servername->setGeometry(10, serverport->y(), this->width() - (20 + serverport->width()), 25);
      autoconnect->setGeometry(10, servername->y() + 25, this->width(), 25);
      usernamelabel->setGeometry(10, autoconnect->y() +25, (this->width() - 20),25);
      username->setGeometry(10,usernamelabel->y() +25, (this->width() - 20), 25);
      userpasswordlabel->setGeometry(10, username->y() +25, (this->width() - 20),25);
      userpassword->setGeometry(10,userpasswordlabel->y() + 25, (this->width() -20),25);
      autoauth->setGeometry(10, userpassword->y() +25, this->width() -20 , 25);
      autodial->setGeometry(10, autoauth->y() +25, this->width() -20 , 25);
			autodialnamelabel->setGeometry(10, autodial->y() +25, this->width() - 20 , 25);
			autodialname->setGeometry(10, autodialnamelabel->y() + 25, this->width() - 20 , 25);
	    ok->setGeometry(  ((this->width()/2)-(ok->width()/2)) , this->height() - ok->height() - 5 , ok->width() , ok->height()  );

}



void ClientConfig::saveconf()
{

KConfig *config = KApplication::getKApplication()->getConfig();

config->writeEntry("serverport",serverport->text());
config->writeEntry("servername",servername->text());
config->writeEntry("autoconnect",autoconnect->isChecked());
config->writeEntry("username", username->text());
config->writeEntry("userpassword", userpassword->text());
config->writeEntry("autoauth", autoauth->isChecked());
config->writeEntry("autodial", autodial->isChecked());
config->writeEntry("autodialname", autodialname->text());

}


ClientConfig::~ClientConfig(){
}












