/***************************************************************************
                          openetext.cpp  -  description
                             -------------------
    begin                : Sat Dec 4 1999
    copyright            : (C) 1999 & 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kgutenbook.h"
#include "openetext.h"
#include <ksimpleconfig.h>

OpenEtext::OpenEtext(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();

  connect( QPushButton_Cancel, SIGNAL(released()), SLOT(reject()) );
  connect( QListBox_1, SIGNAL(selected ( int)),this, SLOT(select_title(int)) );
  local_library = (QDir::homeDirPath ()) +"/.kgutenbook/";
  local_index = local_library +"PGWHOLE.TXT";

  getTitles();
}

OpenEtext::~OpenEtext(){
}

void OpenEtext::getTitles()
{
  KConfig *config = kapp->getConfig();	
  config->setGroup( "Files" );
  s_numofFiles = config->readEntry("NumberOfFiles", 0);

  int  i_numofFiles = s_numofFiles.toInt();
  for (int i = 1; i <= i_numofFiles; i++)
   	{
   	QString temp;
   	temp.setNum(i);
   	config->setGroup( "Files" );
   	QString ramble = config->readEntry(temp, "" );
 		config->setGroup( "Titles" );
 		title = config->readEntry(ramble, "");   	

      if(!title.isEmpty()) {
      QListBox_1->insertItem ( title);
      }
   	}
}

void OpenEtext::OpenTitle()
{
// opens selected title
if( QListBox_1->currentItem() != -1)
		select_title(  QListBox_1->currentItem() );
		else
		{
		QString sMsg;
		sMsg = "You must select an Etext to open";
		QMessageBox::message( "Error",sMsg);
		}
}

void OpenEtext::select_title(int index )
{
  KConfig *config = kapp->getConfig();	
  QString temp;
  temp.setNum( index + 1);
  const char * title;
  title = QListBox_1->text( index );

  openFileTitle = title;
//  QMessageBox::message( "temp",openFileTitle );

  config->setGroup( "Files" );
  file = config->readEntry(temp, "");
  OpenEtext::accept();

}

void OpenEtext::open()
{
// open external etext- not already added to the title list
		title = "";
		QString currDir="";
		QString filer;
		QString local = (QDir::homeDirPath () );
		fileList = QFileDialog::getOpenFileNames( 0, local_library, this);
		// filelist is string QStrList
		for (const char* f = fileList.first(); f; f = fileList.next()) {
				fileName = f;
				if( !fileName.isEmpty() )	{
						filer = fileName;
				}	else {
						QString sMsg;
						sMsg = "Error opening library filelist "+fileName;
						QMessageBox::message( "Error",sMsg);
				}

				if( filer.right(4) == ".txt" ||  filer.right(4) == ".TXT" ||  filer.right(4) == ".zip"  ||  filer.right(4) == ".ZIP" )				{
						QFileInfo zipFile( filer);
						QString s_fileName = zipFile.fileName();
						if( s_fileName.right(4) == ".zip")	{
          // unzip that sucker....
								s_fileName = s_fileName.left( s_fileName.length() - 4);
								QString cmd = "/usr/bin/unzip -o " + filer + " -d " + local_library;
								fileName = local_library + s_fileName + ".txt";
								system(cmd);
						}
				}
				FindTitle();
				QListBox_1->clear();
				getTitles();
		} // end of for each file name....
}

bool OpenEtext::FindTitle()
{
// find the title in the config file
		KConfig	*config = kapp->getConfig();	
		config->setGroup( "Files" );
		QString s_numofFiles = config->readEntry("NumberOfFiles", 0);
		int  i_numofFiles = s_numofFiles.toInt();

		QFileInfo fi(fileName);
		name = fi.fileName();

		QFile indexLib( local_index);
				
		if ( indexLib.open( IO_ReadOnly) ) {
				 // file opened successfully
				QTextStream indexStream( &indexLib );
				QString indexLine;
				while ( !indexStream.eof() ) 	{
						  // until end of file..
						indexLine = indexStream.readLine();
		        QString beg_filename = name.left( 5);
						if ( indexLine.contains( beg_filename, TRUE ) == 1 ) {
									// if the current line contains our file.. get title
								title = indexLine.mid( indexLine.find("  "), 50);
//								title = indexLine.mid( 28, indexLine.find("\n", 0, TRUE));
								title = title.stripWhiteSpace();
						}
				}
				indexLib.close();
//				QMessageBox::message( "Note",title);
  		
				if (checkConf() == false)	{
						config->setGroup( "Files");
						config->writeEntry("NumberOfFiles",i_numofFiles + 1 );
						QString interger;
						interger.setNum( i_numofFiles +1);
						config->writeEntry(interger, fileName);
						config->setGroup( "Titles" );
						config->writeEntry( fileName,title);
						config->sync();
	      }
		}	else {
				QString sMsg;
				sMsg = "Error opening library file "+fileName;
				QMessageBox::message( "Error",sMsg);
		}
		return true;
}

bool OpenEtext::checkConf()
{
    QString file = fileName;
    KConfig	*config = kapp->getConfig();	
    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", 0);
    int  i_numofFiles = s_numofFiles.toInt();

		for (int i = 1; i <= i_numofFiles; i++)
		{
				QString temp;
				temp.setNum(i);
				config->setGroup( "Files");
				QString ramble = config->readEntry(temp, "" );

				if(ramble == file )
				{
						return true;
				}
		}
		return false;
}

void OpenEtext::removeSelection()
{
		KConfig *config = kapp->getConfig();
		config->setGroup( "Files" );
		s_numofFiles = config->readEntry("NumberOfFiles", 0);

		int  i_numofFiles = s_numofFiles.toInt();
		for (int i = 1; i <= i_numofFiles; i++)
   	{
				QString fileNum;
				fileNum.setNum(i);
				config->setGroup( "Files" );
				QString s_filename = config->readEntry(fileNum, "" );
				config->setGroup( "Titles" );
				QString file_title = config->readEntry( s_filename, "");   	
				if(title_text == file_title )
				{
						selFile = s_filename;
//  QMessageBox::message( "Note", selFile );
				}
   	}
		remFile();
}	

void OpenEtext::remFile()
{
		KConfig *config = kapp->getConfig();
		config->setGroup( "Files" );
		QString remFile;

		s_numofFiles = config->readEntry("NumberOfFiles", 0);
		int  i_numofFiles = s_numofFiles.toInt();
		for (int i = 1; i <= i_numofFiles; i++)
   	{
				QString fileNum;
				fileNum.setNum(i);
				config->setGroup( "Files" );
				QString s_filename = config->readEntry(fileNum, "" );
 		
				if( s_filename == selFile) {
 		
						for(int fg = i_numofFiles - i; fg < i_numofFiles ; fg++  )
						{
								QString fileNum2;
								fileNum2.setNum( fg + 1);
								QString s_filename2 = config->readEntry(fileNum2, "" );
 		
								if (!s_filename2.isEmpty()) {
										config->writeEntry(fileNum, s_filename2 );
								}
						}
				}
 		}
 		config->writeEntry("NumberOfFiles", i_numofFiles - 1 );
 		config->sync();
		QString local_fileToRemove; 		
 		QString strDir = kapp->localconfigdir();
 		strDir += "/kgutenbookrc";
 		QString newRc;
		QFile rcFile(strDir);
		if ( rcFile.open(IO_ReadWrite) )  { // file opened successfully
				QTextStream rcStream( &rcFile );
				QString rcLine;
					
				while ( !rcStream.eof() )  	{ // until end of file..
						rcLine = rcStream.readLine();
						if (( rcLine.left(11) != selFile) && (  rcLine.left(2) != s_numofFiles))
						{
								newRc += rcLine+"\n";
						}
				}
		}
		rcFile.close();
		QFile rcFile2(strDir);
					
		if ( rcFile2.open(IO_WriteOnly) )
		{  // file opened successfully
				rcFile2.writeBlock(newRc, newRc.length());	
				rcFile2.close();
		}
		if( !selFile.contains("/", TRUE) )
		{
				local_fileToRemove = local_library + selFile;
		}
		else
		{
				local_fileToRemove = selFile;
		}
		if(!QFile::remove(local_fileToRemove))
				QMessageBox::message( "Note","Could not delete\n" + selFile );

}

void OpenEtext::remove()
{
// remove button
		title_text = QListBox_1->text( QListBox_1->currentItem() );
		QString tTile = title_text;
		QString msg ="Do you really want to REMOVE\n " +tTile +"??\n";
		switch( QMessageBox::information( this, (i18n("Remove Etext?")),
																			(i18n(msg)),
																			(i18n("&Yes")), (i18n("&Cancel")),0 )){
				case 0: // Yes clicked,
				{
						removeSelection();
						QListBox_1->clear();
						getTitles();
				}
				break;
				case 1: // Cancel

						break;
		};
}

