/***************************************************************************
                          kgutenbook.cpp  -  description
                             -------------------
    begin                : Wed Nov 24 00:25:13 MST 1999
    copyright            : (C) 1999 & 2000 by llornkcor
    email                : llornkcor@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   ## ftp://uiarchive.cso.uiuc.edu                                       *
 *   Ahead, groove factor five....                                         *
  QMessageBox::message( "Note","test" );

 ***************************************************************************/

#include "LibDlg.h"
#include "bookmarksdlg.h"
#include "ftpsitedlg.h"
#include "helpme.h"
#include "kgutenbook.h"
#include "openetext.h"
#include <kaccel.h>
#include <math.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>

Kgutenbook::Kgutenbook(QWidget *parent, const char *name) : QWidget(parent, name)
{
		loadCheck = false;
		initKDialog();
		index = "GUTINDEX.ALL";
		local_library = (QDir::homeDirPath ()) +"/.kgutenbook/";
		local_index = local_library + index;
		QDir library(local_library);
		if (!library.exists()) {
     // make ~/.kgutenbook
				mkdir(local_library, TRUE);
				QString msg;
				msg = "chmod 755 " + local_library;
				system(msg);
		}

		font = QFont ("helvetica", 12, QFont::Normal);
		config->setGroup( "Font" );
		font = config->readFontEntry( "Family", &font);
		m_Left_Text->setFont(font);
		m_Right_Text->setFont(font);

		config->setGroup( "Browser" );
		brow = config->readEntry("Preferred", "");

		if(brow.length() < 2  ) {
				switch( QMessageBox::information( this, (i18n("Kgutenbook Browser Setup")),
																					(i18n("Do you want to use\n"
																								"KFM, Lynx,or Netscape\n"
																								"to download, and/or view the dictionary output?\n\n"
																								"If you choose netscape to view\nthe output from the dictionary lookup,\n"
																								"lynx will be used to download the library index, and ftp site list." )),
																					(i18n("&KFM")), (i18n("&Lynx")), (i18n("&Netscape")),0, 1 )){
						case 0: // KFM clicked,
						{
								brow = "KFM";
						}
						break;
						case 1: // lynx
						{
								brow = "Lynx";
						}
						break;
						case 2: // netscape
						{
								brow = "Netscape";
						}
						break;
				};

				config->setGroup( "Browser" );
				config->writeEntry("Preferred",brow);
				config->sync();
	
				config->setGroup( "FTPsite" );
				ftp_host = config->readEntry("SiteName", "");
				ftp_base_dir = config->readEntry("base", "");

//	QMessageBox::message( "Note",ftp_host );
				if( ftp_host.isEmpty() )
				{
						checkFTP();
				}
				QFile thatFile( local_library +"PGWHOLE.TXT");
				if( !thatFile.exists() )
				   DownloadIndex();
		}
}

bool Kgutenbook::downloadFtpList()
{
		setCursor( waitCursor );
		ftpSiteDlg* siteDlg;
		siteDlg = new ftpSiteDlg();
		siteDlg->exec();
//		delete siteDlg;
		ftp_host  = siteDlg->host;
		ftp_base_dir  = siteDlg->base_dir;
		cursor();
		setCursor(  arrowCursor);
		return true;
}

bool Kgutenbook::checkFTP()
{
//  ftp_host = "ftp.datacanyon.com";
//  ftp_base_dir = "/pub/gutenberg/";
		QFileInfo fi(local_library + "ftpList");
		if( !fi.exists() )
		{
				downloadFtpList();
				return true;		
		}
		else
		{
											
				switch( QMessageBox::information( 0,(i18n( "Select ftp site?")),
																					(i18n("Do you want to select a\n"
																								"Project Gutenberg ftp site now, or later?\n")),
																					(i18n("&Now")), (i18n("&Later")),0 ) ){
						case 0: // Now clicked,
						{
								downloadFtpList();
								return true;
						}
						break;

						case 1: // Later selected
						{
								if( !fi.exists() )
								{
	/*									QString msg;
										msg = (i18n("You can select an ftp site later,\njust click on the download button\n"));
										QMessageBox::message( "Note", msg );
	*/
								}
						}
						return false;
						break;
				};
		}
									
		return false;
}

Kgutenbook::~Kgutenbook()
{
		QFileInfo temp("./.guten_temp");
		if (temp.exists() == TRUE)
		remove("./.guten_temp");
//    delete printer;
}

void Kgutenbook::DownloadIndex()
{
 	QFile ftpLis( local_library + "ftpList");
		if ( ftpLis.exists() )
		{
 		switch( QMessageBox::information( 0, (i18n("Download Library Index, or FTP sites?")),
																			(i18n("Do you want to download the newest\n"
																						"Project Gutenberg Library Index?\n"
																						"or select an ftp site?\n")),
																			(i18n("&Library Index")), (i18n("&Ftp Site")), (i18n("&Cancel")), 0, 1 ) )
		{
				case 0: // index clicked,
				{
						setCursor( waitCursor );
						remove(local_index);
						if(brow == "KFM")
						{
								QString dwmloader = "file://"+ local_index;
								KFM::download("http://www.gutenberg.net/pgwhole.zip", dwmloader);
								cursor();
						}
						else
						{
								setCursor( waitCursor );
								QString dwmloader = local_library + "pgwhole.zip";
								QString cmd = "lynx -source http://www.gutenberg.net/pgwhole.zip | cat >> " + dwmloader;
									//local_index;
								system(cmd);	
								cursor();
						}
							//	LibraryBtn();
						return;
				}

				break;

				case 1: // ftp selected
				{
					downloadFtpList();
				}
				return;

				break;

				case 2: // Cancel
						break;
		};
		}
		else
		{
			downloadFtpList();
		}
}

void Kgutenbook::LibraryBtn()
{
setCursor( waitCursor );
		QString newestLibraryFile = local_library +"pgwhole.zip";
		if( QFile::exists( newestLibraryFile))
		{
				if( QFile::exists( "/usr/bin/unzip"))
				{
						QString thatFile = local_library +"PGWHOLE.TXT";
						QString cmd = "/usr/bin/unzip -o " + newestLibraryFile + " -d " + local_library;
//  QMessageBox::message( "Note",cmd );
						system( cmd);
						remove( newestLibraryFile);
				}
				else
						QMessageBox::message( "Note",(i18n("Please install unzip")) );
		}
		LibDlg* Lib_Dlg;
		Lib_Dlg = new LibDlg(0,"Lib_Dlg");

		QString origTitle = title;
		StatusBar->setText( status=(i18n("Opening Library Index")) );
		StatusBar->update();
		
		QFileInfo newindexLib( local_library + "PGWHOLE.TXT");
		if( newindexLib.exists() )
		{
//				if(
				Lib_Dlg->exec();// ) {
//c				delete Lib_Dlg;

				listItemNumber = Lib_Dlg->DlglistItemNumber;
				listItemFile =  Lib_Dlg->DlglistItemFile;
				listItemYear = Lib_Dlg->DlglistItemYear;
				listItemTitle = Lib_Dlg->DlglistItemTitle;
				file_name = Lib_Dlg->File_Name;	
				title = listItemTitle;
				if( Lib_Dlg->checked == 1)
				{
						config->setGroup( "Proxy" );
						config->writeEntry("IsChecked", "TRUE");
						config->sync();
				}
				else
				{
						config->setGroup( "Proxy" );
						config->writeEntry("IsChecked", "FALSE");
						config->sync();
				}
	
				if ( listItemNumber.isNull())
				{
						setCursor(  arrowCursor);	
				}
				else
				{
						setCursor(  arrowCursor);
						i_pageNum = 1;
						setTitle();
						load(file_name);
				}		
		}
		else
		{ // if PGWHOLE.TXT does not exist
				setCursor(  arrowCursor);	
				QString sMsg;
				sMsg = (i18n("Please download the Gutenberg library index."));
				sMsg += (i18n("\nYou can download it by choosing the down arrow button."));
				QMessageBox::message( "Error",sMsg);
		}
	setCursor(  arrowCursor);
}

void Kgutenbook::OpenBtn()
{
		QString s_temp;
		s_temp = status;
		StatusBar->setText( (i18n("Open File" )) );
		StatusBar->update();
		OpenEtext* OpenDlg;
		OpenDlg = new  OpenEtext(this,"OpenDlg");
	
		if ( OpenDlg->exec() != 0) {
				title = OpenDlg->openFileTitle;
				file_name = OpenDlg->file;
				i_pageNum = 1;
				if(QFile::exists( local_library + file_name))	{
						file_name = local_library + file_name;
						setCursor( waitCursor );
						m_Left_Text->setCursor( waitCursor);
						m_Right_Text->setCursor( waitCursor);
	
						load(file_name);
						cursor();
				}	else {
						if(QFile::exists(file_name)) {
									// find title
								setCursor( waitCursor);
								m_Left_Text->setCursor( waitCursor);
								m_Right_Text->setCursor( waitCursor);
	
								load(file_name);
								cursor();
						} else {
								QMessageBox::message( "Error", "Error opening " +file_name);
						}
				}
	  }	else {
//	   QMessageBox::message( "s_temp", s_temp );
				status = s_temp;
				StatusBar->setText( status);
				InfoBar->setText( status.left( title.find("  ", TRUE) ));				
				StatusBar->update();
		}
}

bool Kgutenbook::load( const char *fileName)
{
		QString o_file = file_name;
		if( o_file.left(1) != "/") {
				o_file = local_library + o_file;
		}
// QMessageBox::message( "Note", o_file );
		if (i_pageNum == 0)	{
				i_pageNum = 1;
		}
		QFile f( o_file);
		if ( !f.open( IO_ReadOnly))	{
				QMessageBox::message( (i18n("Note")), (i18n("File not opened sucessfully." )) );
				return  false;
		}
    m_Left_Text->setAutoUpdate( FALSE);
    m_Left_Text->clear();
    m_Right_Text->setAutoUpdate( FALSE);
    m_Right_Text->clear();
   QTextStream t(&f);
		while ( !t.eof() ) {
				QString s = t.readLine();
				m_Left_Text->append( s );
				m_Right_Text->append( s );
		}
    f.close();
    m_Left_Text->setAutoUpdate( TRUE);
    m_Left_Text->repaint();
    m_Right_Text->setAutoUpdate( TRUE);
    m_Right_Text->repaint();
    setCaption( fileName );

    m_Right_Text->setCursorPosition(0,1,FALSE);
		m_Right_Text->MultiLine_Ex::pageDown( FALSE);

    m_Left_Text->setCursorPosition(0,0,FALSE);
    m_Left_Text->setFocus();
//	m_Left_Text->setFixedVisibleLines ( m_Left_Text->PageSize() + 1 );
//	m_Right_Text->setFixedVisibleLines (  m_Right_Text->PageSize() + 1 );

		pages = ((m_Left_Text->numLines() / m_Left_Text->editSize() ) / 2 ) +1;

    status = title +(i18n("  :page "));
    setStatus();
    setCursor(  arrowCursor);
		m_Left_Text->setCursor( arrowCursor );
		m_Right_Text->setCursor(arrowCursor );
		 loadCheck = true;
    return false;
}

void Kgutenbook::PrintBtn()
{
		setCursor( waitCursor );
    const int MARGIN = 10;
    int pageNo = 1;

    if ( printer->setup(this) )  {		// printer dialog
				StatusBar->setText(status= (i18n("Printing...")) );
				StatusBar->update();
				QPainter p;
				p.begin( printer );			// paint on printer
				p.setFont( m_Left_Text->font() );
				int yPos        = 0;			// y position for each line
				QFontMetrics fm = p.fontMetrics();
				QPaintDeviceMetrics metrics( printer ); // need width/height
					// of printer surface
				for( int i = 0 ; i < m_Left_Text->numLines() ; i++)	{
						if ( MARGIN + yPos > metrics.height() - MARGIN)	{
								QString msg;
								msg.sprintf( (i18n("Printing (page %d)...")), ++pageNo);
								StatusBar->setText(status= msg);
								StatusBar->update();
								printer->newPage();		// no more room on this page
								yPos = 0;			// back to top of page
						}
						p.drawText( MARGIN, MARGIN + yPos,
												metrics.width(), fm.lineSpacing(),
												ExpandTabs | DontClip,
												m_Left_Text->textLine( i ) );
						yPos = yPos + fm.lineSpacing();
				}
				p.end();				// send job to printer
				StatusBar->setText(status= (i18n("Printing completed")) );
				StatusBar->update();
		} else {
				StatusBar->setText(status= (i18n("Printing aborted")) );
				StatusBar->update();
    }
    cursor();
}

bool  Kgutenbook::setStatus()
{
		QString s_pages;
		s_pages.setNum( pages);
		QString chNum;
		statusTop = status.left( status.find("  ", TRUE) );
		status.append(chNum.setNum(i_pageNum));
		status += " out of " + s_pages;
		StatusBar->setText(status);
		InfoBar->setText( statusTop );
		StatusBar->update();
	  return true;
}

void Kgutenbook::ForwardBtn()
{
		QString topR;
		QString lastR;
		QString pageR;
		int sizer =  m_Right_Text->lastRow() - m_Right_Text->topRow();
		int i_rLastRow = m_Right_Text->lastRow();
		int i_numbLines = m_Right_Text->numLines();

		if( i_pageNum != pages)	{
				if( sizer > ( i_numbLines - i_rLastRow) )	{
						m_Left_Text->MultiLine_Ex::ScrollUp( i_numbLines - i_rLastRow);
						m_Right_Text->MultiLine_Ex::ScrollUp( i_numbLines - i_rLastRow);
				}	else {
						for (int i = 0; i <2; i++) {
								m_Left_Text->MultiLine_Ex::pageDown( FALSE);
								m_Right_Text->MultiLine_Ex::pageDown( FALSE);
						}
						i_pageNum++;
						status= title + (i18n("  :page "));
						setStatus();
				}
		}	else {
				status = (i18n("End of book  "));
				setStatus();
		}
		m_Left_Text->setCursorPosition( m_Left_Text->Top(), 0, FALSE);
}

void Kgutenbook::BackBtn()
{
		QString topR;
		QString lastR;
		QString pageR;
		int sizer =  m_Left_Text->lastRow() - m_Left_Text->topRow();
		int i_topRow = m_Left_Text->topRow();

		if( sizer > i_topRow ) {
				m_Left_Text->MultiLine_Ex::ScrollDown( i_topRow);
				m_Right_Text->MultiLine_Ex::ScrollDown( i_topRow);
		}	else {
				if (m_Left_Text->atBeginning())	{
						status= (i18n("Start of book  "));
						setStatus();
				} else {
						for (int i = 0; i <2; i++) {
								m_Right_Text->MultiLine_Ex::pageUp( FALSE);
								m_Left_Text->MultiLine_Ex::pageUp( FALSE);
						}
						i_pageNum--;
						if( i_pageNum < 1)
								i_pageNum = 1;
						status= title + (i18n("  :page "));
						setStatus();
				}
				m_Left_Text->setCursorPosition( m_Left_Text->Top(), 0, FALSE);
  	}
}

void Kgutenbook::resizeEvent( QResizeEvent *)
{
		if(  loadCheck == true)	{
				ResizeEdits();
				AdjustStatus();
		}
}

void Kgutenbook::ResizeEdits()
{
int rTopRow = m_Right_Text->topRow();
int lLastRow = m_Left_Text->lastRow();
	if( lLastRow >	rTopRow )	{
	    m_Right_Text->MultiLine_Ex::ScrollUp( lLastRow - rTopRow  );
	}	else if( lLastRow <	rTopRow )	{
			m_Right_Text->MultiLine_Ex::ScrollDown( rTopRow - lLastRow );
	}
}

void Kgutenbook::ChangeFont()
{
//QFont font = this->font();
  KFontDialog::getFont(font);
  m_Left_Text->setFont(font);
  m_Right_Text->setFont(font);
  ResizeEdits();
	AdjustStatus();
	m_Left_Text->setFocus();
}

void Kgutenbook::AdjustStatus()
{
		int linesPerPage = m_Right_Text->lastRow() - m_Left_Text->topRow();
		pages = ((m_Left_Text->numLines() / m_Left_Text->editSize() ) / 2 ) +1;
		i_pageNum = (( m_Left_Text->topRow() - 1) / linesPerPage) +1;
		if( i_pageNum < 1)
				i_pageNum = 1;
    status = title +(i18n("  :page "));
		setStatus();
		Kgutenbook::m_Right_Text->repaint( TRUE);	

}

void Kgutenbook::HelpBtn()
{
  QString statusTemp = status;
  StatusBar->setText(status= (i18n("Help Me")) );
  HelpMe* HelpDlg;
	HelpDlg = new HelpMe();
	HelpDlg->exec();
  StatusBar->setText( statusTemp);
}

void Kgutenbook::SearchBtn()
{
  Search();
}

void Kgutenbook::Search()
{
//  if(!srchdialog){
    srchdialog = new KEdSrch(0, "searchdialog");
    connect(srchdialog,SIGNAL(search_signal()),this,SLOT(search_slot()));
    connect(srchdialog,SIGNAL(search_done_signal()),this,SLOT(searchdone_slot()));
//  }
//
//  // If we already searched / replaced something before make sure it shows
//  // up in the find dialog line-edit.
//
  QString string;
  string = srchdialog->getText();
  if(string.isEmpty())
  srchdialog->setText(pattern);

  m_Left_Text->deselect();
  last_search = 0;
	m_Left_Text->clearFocus();
  QPoint point = m_Left_Text->mapToGlobal (QPoint (0,0));
  QRect pos = m_Left_Text->geometry();
  srchdialog->setGeometry(point.x() + pos.width()/2  - srchdialog->width()/2,
  point.y() + pos.height()/2 - srchdialog->height()/2,
  srchdialog->width(),
  srchdialog->height());

  srchdialog->show();
  srchdialog->result();
}

void Kgutenbook::search_slot()
{
  int line, col;
//  if (!srchdialog)
//    return;
//
  QString to_find_string = srchdialog->getText();
  m_Left_Text->getCursorPosition(&line,&col);
//
//  // srchdialog->get_direction() is true if searching backward
//
  if (last_search != 0 && srchdialog->get_direction()){
    col = col  - pattern.length() - 1 ;
  }
again:
  int  result = doSearch(to_find_string , srchdialog->case_sensitive(), (!srchdialog->get_direction()), line, col);

  if(result == 0){
    if(!srchdialog->get_direction()){ // forward search

      int query = QMessageBox::information(
					   srchdialog,
					   klocale->translate("Find"),
					   klocale->translate("End of document reached.\nContinue from the beginning?"),
					   klocale->translate("Yes"),
					   klocale->translate("No"),
					   "",
					   0,1);
      if (query == 0){
	line = 0;
	col = 0;
	goto again;
      }
    }
    else
    { //backward search
      int query = QMessageBox::information(
					   srchdialog,
					   klocale->translate("Find"),
					   klocale->translate("Beginning of document reached.\nContinue from the end?"),
					   klocale->translate("Yes"),
					   klocale->translate("No"),
					   "",
					   0,1);
      if (query == 0){
	QString string = m_Left_Text->textLine( m_Left_Text->numLines() - 1 );
	line = m_Left_Text->numLines() - 1;
	lineCheck = line;
	col  = string.length();
	last_search = -1; //BACKWARD;
	goto again;
      }
    }
  }
  else{
//    emit CursorPositionChanged(); textLine
  }
}

int Kgutenbook::doSearch(QString s_pattern, bool case_sensitive,  bool forward, int line, int col )
{
  int i, length;
  int pos = -1;
  if(forward) {
    QString string;
    for(i = line; i < m_Left_Text->numLines(); i++)
    {
    string = m_Left_Text->textLine(i);
      pos = string.find(s_pattern, i == line ? col : 0, case_sensitive);

      if( pos != -1)
      {
					int top = m_Left_Text->Top();
					length = s_pattern.length();
					if( i > m_Left_Text->lastRow() )
					{
							m_Left_Text->setCursorPosition(i,pos,FALSE);
							for(int l = 0 ; l < length; l++)
							{
									m_Left_Text->cursorRight(TRUE);
							}
							m_Left_Text->setCursorPosition( i , pos + length, TRUE );
							int newTop = m_Left_Text->Top();
							m_Right_Text->ScrollUp( newTop - top);
					}
					else
					{
							m_Left_Text->setCursorPosition(i,pos,FALSE);
							for(int l = 0 ; l < length; l++)
							{
									m_Left_Text->cursorRight(TRUE);
							}
							m_Left_Text->setCursorPosition( i , pos + length, TRUE );
					}
					pattern = s_pattern;
					last_search = 1; //FORWARD;
					return 1;
			}
		}
	}
	else
	{ ////////////////////////////////////////////////////////////// searching backwards
    QString string;

    for( i = line; i >= 0; i--)
		{
				string = m_Left_Text->textLine(i);
				int line_length = string.length();
				pos = string.findRev(s_pattern, line == i ? col : line_length , case_sensitive);
				if (pos != -1)
				{
//						int top = m_Left_Text->Top();
						length = s_pattern.length();
								if( i <  m_Left_Text->Top() )
						{
								//m_Left_Text->ScrollDown( m_Left_Text->PageSize() );
//                 m_Left_Text->MultiLine_Ex::pageUp( FALSE );
//											if( ! (line == i && pos > col ) )
//											{
								m_Left_Text->setCursorPosition( i ,pos ,FALSE );
										for(int l = 0 ; l < length; l++)
										{
												m_Left_Text->cursorRight(TRUE);
										}
										m_Left_Text->setCursorPosition(i ,pos + length ,TRUE );
										//	int newTop = m_Left_Text->Top();
//										m_Right_Text->ScrollUp( newTop - top);
//											}
						}
						else
						{ 
//      	  QMessageBox::message( "Note", "test" );
									//														if( ! (line == i && pos > col ) )
									//{
										m_Left_Text->setCursorPosition( i, pos, FALSE );
										for( int l = 0 ; l < length; l++)
										{
												m_Left_Text->cursorRight( TRUE);
										}
										m_Left_Text->setCursorPosition( i, pos + length, TRUE );
										
											//}
								pattern = s_pattern;
								last_search = -1;
								return 1;
						}
				}
		}
	}
	return 0;
}

void Kgutenbook::searchdone_slot()
{
  if (!srchdialog)
    return;
  srchdialog->hide();
  m_Left_Text->setFocus();
  last_search = 0;
}

bool Kgutenbook::Bookmark()
{
    config->setGroup( "Bookmarks" );
   	file_name = config->readEntry("File Name", "");
    i_pageNum = config->readNumEntry("Page Number", 0);
	  int Bmrkrow;
		Bmrkrow = config->readNumEntry("LineNumber",0);
	
	  if( !file_name.contains("/")) {
				file_name = local_library + file_name;
		}
		getTitle(file_name);
		load(file_name);
		for ( check=1; check < i_pageNum; check++ )	{
				if ( !m_Right_Text->atEnd()) {
						for (int i = 0; i <2; i++) {
								m_Left_Text->MultiLine_Ex::pageDown( FALSE );
								m_Right_Text->MultiLine_Ex::pageDown( FALSE );
						}

						status= title + (i18n("  :page "));
						setStatus();
				}	else {
						status= "End of book  ";
						setStatus();
				}
		}
		if( Bmrkrow >  m_Left_Text->topRow() ) {
				 //  if editview is smaller
				m_Left_Text->MultiLine_Ex::ScrollUp( Bmrkrow  -  m_Left_Text->topRow() );
				ResizeEdits();
				AdjustStatus();
		}
		else if( Bmrkrow <  m_Left_Text->topRow() ) {
				  // if editview is larger
				m_Left_Text->MultiLine_Ex::ScrollDown( m_Left_Text->topRow() - Bmrkrow );
				ResizeEdits();
				AdjustStatus();
		}
		return true;
}

void Kgutenbook::setBookmark()
{
/*	bookMarksDlg* bookDlg;
	bookDlg = new  bookMarksDlg(this,"bookMarkDlg");
	if(bookDlg->exec() != 0)
		{
//		QMessageBox::message( "Note", "accepted");
//    QMessageBox::message( "Note", file_name );
 }
 */

		if( file_name.contains(local_library) )	{
				QFileInfo f1( file_name);
				QString file = f1.fileName();
				file_name = file;
		}

		QString temp;
		temp.setNum(i_pageNum);
		config->setGroup( "Bookmarks" );
		config->writeEntry("File Name",file_name);
		config->writeEntry("Page Number",temp);

		int row =  m_Left_Text->topRow();// m_Left_Text->Top();
		QString numb;
		numb.setNum( row);
		config->writeEntry("LineNumber",numb);

		QMessageBox::message( "Note", numb );       	
		config->sync();	
}

bool Kgutenbook::setTitle()
{
		if( file_name.contains( local_library))	{
				QFileInfo f( file_name);
				QString s_file =	f.fileName();
				file_name = s_file;
		}
		int test = 0;
		config->setGroup( "Files" );
		QString s_numofFiles = config->readEntry("NumberOfFiles", 0);
		int  i_numofFiles = s_numofFiles.toInt();

		for (int i = 1; i <= i_numofFiles; i++)	{
      	QString temp;
      	temp.setNum(i);
      	QString ramble = config->readEntry(temp, "" );

      	if( strcmp(ramble, file_name) == 0)	{
						test = 1;
				}
		}
		if (test == 0) {
      	config->writeEntry("NumberOfFiles",i_numofFiles +1 );
      	QString interger;
      	interger.setNum( i_numofFiles +1);
      	config->writeEntry(interger, file_name);

      	config->setGroup( "Titles" );
      	config->writeEntry(file_name,listItemTitle);
		}
    test = 0;
    config->sync();
		return true;
}

bool Kgutenbook::getTitle( const char *file )
{
		QString s_file;
		QString filer = file;
//   QMessageBox::message( "Note", filer );
   	if( filer.contains(local_library, TRUE))	{
				QFileInfo f(file);
				s_file =	f.fileName();
		}	else {
				s_file = filer;
		}

		config->setGroup( "Files" );
		QString s_numofFiles = config->readEntry("NumberOfFiles", 0);
		int  i_numofFiles = s_numofFiles.toInt();

		for (int i = 1; i <= i_numofFiles; i++) {
				QString temp;
				temp.setNum(i);
				QString ramble = config->readEntry(temp, "" );
   	
				if( strcmp(ramble, s_file) == 0) {
						config->setGroup( "Titles" );
						title = config->readEntry(ramble, "");
				}
   	}
   	
		return true;
}

void Kgutenbook::LookupBtn()
{
		QClipboard *cb = QApplication::clipboard();
		const char *text;
		text = cb->text();
		QString clip = text;
		QString cmd;
		QString s_lookup = "http://www.m-w.com/cgi-bin/dictionary?" + clip;

		if(brow == "KFM")	{
				KShellProcess proc("bash");
				proc << "kfmclient" << "openURL"	<< s_lookup;
				proc.start(KProcess::DontCare,KProcess::All);
		}	else if (brow == "Netscape") {
				QString str = QDir::homeDirPath() + "/.netscape/lock";
				struct stat stat_p;

				if ( -1 !=  lstat (str, &stat_p))	{
						KShellProcess proc("bash");
						proc << "netscape" <<"-remote" << "'openURL(" <<s_lookup << ")'";
						proc.start(KProcess::DontCare,KProcess::All);
				}	else {
						KShellProcess proc("bash");
						proc << "netscape" <<s_lookup;
						proc.start(KProcess::DontCare,KProcess::All);
				}
		}

		else if(brow =="Lynx") {
//    cmd = "lynx -source "+ s_lookup + " | cat >> ~/somefile.html";
				KShellProcess proc("bash");
				proc << "xterm" <<"-fg black" << "-bg white"<< "-e" <<"lynx" << s_lookup;
				proc.start(KProcess::DontCare,KProcess::All);
    }
//// http://www.encyclopedia.com/home.html
}


void Kgutenbook::keyReleaseEvent( QKeyEvent *e)
{
		switch ( e->key() ) {
	
				case Key_M:
						Bookmark();
						break;
	
				case Key_D:
						DownloadIndex();
						break;
				case Key_L:
						LibraryBtn();
						break;
				case Key_O:
						OpenBtn();
						break;
				case Key_F:
						ForwardBtn();
						break;
				case Key_B:
						BackBtn();
						break;
				case Key_P:
						PrintBtn();
						break;
				case Key_S:
						SearchBtn();
						break;
				case Key_E:
						ByeBye();
						break;
				case Key_R:
						setBookmark();
						break;
				case Key_T:
						ChangeFont();
						break;
				case Key_C:
						ClearEdit();
						break;
				case Key_H:
						HelpBtn();
						break;
				case Key_K:
						LookupBtn();
						break;
	    /*
	case Key_Next:
HelpBtn()
	    break;
	case Key_Next:
HelpBtn()
	    break;
*/	
	}
}

void Kgutenbook::keyPressEvent( QKeyEvent *e)
{
		switch ( e->key() ) {
				case Key_Next:
						ForwardBtn();
						break;
				case Key_Prior:
						BackBtn();
						break;
				case Key_Space:
						ForwardBtn();
						break;
		}
}

void Kgutenbook::ClearEdit()
{
		m_Left_Text->clear();
    m_Right_Text->clear();
		loadCheck = false;
		status = (i18n("KGutenbook"));
		InfoBar->setText( "");	
		setCaption(i18n("Kgutenbook"));
		i_pageNum = 0;
		StatusBar->setText(status);
}

void Kgutenbook::ByeBye()
{
  config->setGroup( "Geometry" );
  QString s(32);
  QRect frameRect;
  frameRect = geometry();
  s.sprintf("%i,%i", frameRect.width(), frameRect.height());
  config->writeEntry("Frame", s);
  config->setGroup( "Font" );
  config->writeEntry("Family", font, true, false, false );
  config->sync();
  kapp->quit();
}

//

//void Kgutenbook::
//{



//}

//void Kgutenbook::
//{



//}
