/***************************************************************************
                          LibDlgData.cpp  -  description
                             -------------------
    begin                : Mon Mar 13 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "LibDlg.h"

/////////////////////////// TODO add tabs with library sorted   ??
///  A-E, F-J, K-O, P-R, S-T, U-Z, and AllElse
void LibDlg::initDialog()
{
	qtarch_LibraryDlg = new QListView( this, "LibraryDlg" );
	  this->setCaption((i18n("Kgutenbook Gutenberg library index")) );
	qtarch_LibraryDlg->setGeometry( 10, 10, 725, 400 );
	qtarch_LibraryDlg->setMinimumSize( 725, 400 );
	qtarch_LibraryDlg->setMaximumSize( 32767, 32767 );
	{
		QFont font( "New Century Schoolbook", 12, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		qtarch_LibraryDlg->setFont( font );
	}
	qtarch_LibraryDlg->setFocusPolicy( QWidget::TabFocus );
	qtarch_LibraryDlg->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_LibraryDlg->setFontPropagation( QWidget::NoChildren );
	qtarch_LibraryDlg->setPalettePropagation( QWidget::NoChildren );
	qtarch_LibraryDlg->setFrameStyle( 0 );
	qtarch_LibraryDlg->setLineWidth( 1 );
	qtarch_LibraryDlg->setMidLineWidth( 0 );
	qtarch_LibraryDlg->QFrame::setMargin( 2 );
	qtarch_LibraryDlg->setResizePolicy( QScrollView:: Default );
	qtarch_LibraryDlg->setVScrollBarMode( QScrollView::AlwaysOn );
	qtarch_LibraryDlg->setHScrollBarMode( QScrollView::AlwaysOff );
	qtarch_LibraryDlg->setTreeStepSize( 1 );
	qtarch_LibraryDlg->setMultiSelection( FALSE );
	qtarch_LibraryDlg->setAllColumnsShowFocus( TRUE );
	qtarch_LibraryDlg->setItemMargin( 2 );
	qtarch_LibraryDlg->setRootIsDecorated( FALSE );
	
	qtarch_LibraryDlg->addColumn( "Number", -1 );
	qtarch_LibraryDlg->setColumnWidthMode( 0, QListView::Manual );
	qtarch_LibraryDlg->setColumnAlignment( 0, 1 );
	qtarch_LibraryDlg->setColumnWidth(0, 55);
	
	qtarch_LibraryDlg->addColumn( "Title", -1 );
	qtarch_LibraryDlg->setColumnWidthMode( 1, QListView::Manual );
	qtarch_LibraryDlg->setColumnAlignment( 1, 1 );
	qtarch_LibraryDlg->setColumnWidth(1, 330);
	
	qtarch_LibraryDlg->addColumn( "Author", -1 );
	qtarch_LibraryDlg->setColumnWidthMode( 2, QListView::Manual );
	qtarch_LibraryDlg->setColumnAlignment( 2, 1 );
	qtarch_LibraryDlg->setColumnWidth(2, 170);
	qtarch_LibraryDlg->setSorting(1, TRUE);	
	
	qtarch_LibraryDlg->addColumn( "Year", -1 );
	qtarch_LibraryDlg->setColumnWidthMode( 3, QListView::Manual);
	qtarch_LibraryDlg->setColumnAlignment( 3, 1 );
	qtarch_LibraryDlg->setColumnWidth(3, 50);
	
	qtarch_LibraryDlg->addColumn( "File", -1 );
	qtarch_LibraryDlg->setColumnWidthMode( 4, QListView::Manual );
	qtarch_LibraryDlg->setColumnAlignment( 4, 1 );
	qtarch_LibraryDlg->setColumnWidth(4, 100);
	qtarch_LibraryDlg->setSorting(1, TRUE);

	progressBar = new QProgressBar(this);
	progressBar->setGeometry(10, 417, 400, 15);
  progressBar->setTotalSteps ( 6 );
  progressBar->setProgress( 0);
  QToolTip::add( progressBar, (i18n("This doesn't really work....yet")) );

  checkBox = new QCheckBox( (i18n("Open Automatically")), this);
  checkBox->setGeometry(420,414,130,20);
  checkBox->setChecked( TRUE);
  QToolTip::add( checkBox, (i18n("open the etext automatically \nin the main window, after the download.")) );

  httpBox = new QCheckBox( (i18n("Use http")), this);
  httpBox->setGeometry( 570, 414, 100, 20);
  httpBox->setChecked( FALSE);
  QToolTip::add( httpBox, (i18n("Use http to download \nproxy users should probably use this.")) );

qtarch_LibraryDlg->setSorting( 3, TRUE);

	cancel = new QPushButton(this);
	cancel->setGeometry(675,414,60,20);
	cancel->setPixmap( QPixmap(kapp->kde_toolbardir() +"/exit.xpm") );
//	cancel->setText(i18n("&Close"));
	cancel->setFocus();
	
	connect( cancel,SIGNAL( clicked()),this,SLOT( cancelIt()));
	connect( qtarch_LibraryDlg, SIGNAL(doubleClicked( QListViewItem*)), SLOT(select_title( QListViewItem*)) );
	connect( qtarch_LibraryDlg, SIGNAL(returnPressed( QListViewItem*)), SLOT(select_title( QListViewItem*)) );
	connect( httpBox, SIGNAL( clicked() ), SLOT( saveConfig()) );
	
	i = 1;
	
	qtarch_LibraryDlg->setFocus();
	qtarch_LibraryDlg->sizeHint();
  index = "GUTINDEX.ALL";
  local_library = (QDir::homeDirPath ()) +"/.kgutenbook/";
  local_index = local_library + index;
  proxy_http = "http://sailor.gutenberg.org/";
	QList_Item =  new QListViewItem( qtarch_LibraryDlg);

	KConfig *config = kapp->getConfig();
	config->setGroup( "Proxy" );
	if( config->readEntry("IsChecked", "FALSE") == "TRUE")
			httpBox->setChecked( TRUE );

}