/*
    This file is part of ktvision, a front end to frame grabber cards 
	for the KDE-Project
    
    Copyright (C) 1998 Oliver Burtchen <oliver.burtchen@rz.hu-berlin.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef Settings_included
#define Settings_included

#include "SettingsData.h"
#include <kapp.h>
#include "chanlist.h"


class Settings : public SettingsData
{
    Q_OBJECT

public:

    Settings
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~Settings();

	QPushButton * delBut;
	QPushButton * addBut;
	QPushButton * reset;
	QLineEdit * chanEdit;
	QLCDNumber * memLcd;
	QScrollBar * chanSlider;
	QScrollBar * fineSlider;
	QComboBox * input;
	QComboBox * format;
	
public slots:
	void setChanSlider(int i){ chanSliderP->setValue(i);}
	void setFineSlider(int i){ fineSliderP->setValue(i);}
	void resetFineSlider(){ fineSliderP->setValue(0);}
	void setFormatCombo(int i){ formatP->setCurrentItem(i);}
	void setInputCombo(int i){ inputP->setCurrentItem(i);}


	
};
#endif // Settings_included
