    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "guilabel.h"
#include "kpoti.h"
#include "qframe.h"
#include "qbitmap.h"
#include "kiconloader.h"
#include "qpaintdevice.h"
#include "qpainter.h"

Gui_LABEL::Gui_LABEL()
{
	printf("constructor\n");
	Widget = 0;
	ParentWidget = 0;
}

Gui_LABEL::~Gui_LABEL()
{
	if(Widget)
	{
		printf("<deleting Gui_LABEL>\n");
		delete Widget;
	}
}

void Gui_LABEL::widgetDestroyed(QWidget *widget)
{
	assert(Widget == widget);
	Widget = 0;
}

void Gui_LABEL::publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker)
{
	Arts::ModuleInfo info;

	info.name = CORBA::string_dup("Gui_LABEL");
	info.isInterface = false;
	info.isStructure = false;

	addPort(info,"parent",Arts::input,Arts::audio_data,Arts::stream);
	addPort(info,"x",Arts::input,Arts::audio_data,Arts::property);
	addPort(info,"y",Arts::input,Arts::audio_data,Arts::property);
	addPort(info,"color",Arts::input,Arts::string_data,Arts::property);
	addPort(info,"caption",Arts::input,Arts::string_data,Arts::property);
	addPort(info,"pixmap",Arts::input,Arts::string_data,Arts::property);

	Broker->publishModule(Server, info);
}

void *Gui_LABEL::Creator()
{
	Gui_LABEL *result = new Gui_LABEL;
	return (GuiModule *)result;
}

ModuleClient MC_Gui_LABEL(GuiModule::get_MS,"Gui_LABEL",Gui_LABEL::Creator);

void Gui_LABEL::applyParameters(Arts::ModuleDesc *desc)
{
	KIconLoader iconloader;

	getPosition(desc,x,y);

	setupParent(desc,"parent");

	if(!Widget)
	{
		Widget = new QLabel();
		watchWidget(Widget);
	}

	pixmap = 0;
	string bg = getStringParam(desc,"pixmap");
	if(strlen(bg.c_str()))
	{
		KIconLoader iconloader;
		QString iconname = QString(bg.c_str())+".xpm";
		pixmap = new QPixmap(iconloader.loadIcon(iconname));

		if(!pixmap->height())
		{
			delete pixmap;
			pixmap = 0;
		}
	}
	if(pixmap)
	{
		Widget->setFixedSize(pixmap->width(),pixmap->height());
		Widget->setAlignment(AlignCenter);
	}

	string color = getStringParam(desc,"color");
	if(strlen(color.c_str()))
	{
		// ;-) - anyone has a more elegant way to set the text color?
		QColor qc(color.c_str());

		QColorGroup cg(qc,qc,qc,qc,qc,qc,qc);
		QPalette pal(cg,cg,cg);
		Widget->setPalette(pal);
	}

	string caption = getStringParam(desc,"caption");
	if(strlen(caption.c_str()))
	{
		Widget->setText(caption.c_str());
	}
}

void Gui_LABEL::setParent(QWidget *parent, QBoxLayout *layout)
{
	printf("gui_label::setParent\n");
	if(Widget)
	{
		QPixmap bg(Widget->width(),Widget->height());
		bg.fill(parent,QPoint(x,y));

		if(pixmap)
		{
			bitBlt(&bg,0,0,pixmap,0,0);
		}

		printf("recreating widget...\n");
		Widget->recreate(parent,0,QPoint(x,y));
		printf("setbackgroundpixmap\n");
		Widget->setBackgroundPixmap(bg);

		if(layout)
		{
			printf("adding widget to layout\n");
			layout->addWidget(Widget);
		}
	}
	ParentWidget = parent;
}

void Gui_LABEL::finalize()
{
}

void Gui_LABEL::start()
{
	Widget->show();
}
