/***************************************************************************
    spielstein.cpp  fr KWA - Kanadische Waldbrandaustreter
	  Segment des Spielfelds, Klassen-Implementation
                             -------------------
    begin                : Sat Sep 30 2000
    copyright            : (C) 2000 by Ulrich Bochert
    email                : schroeder_bochert@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlabel.h>
#include "spielstein.h"
#include <stdio.h>
#include <qpainter.h>

SpielStein::SpielStein(QWidget *parent, const char *name, int xPos, int yPos)
        :QWidget (parent, name)
{
        //printf("sskonstruktor\n");
        init(xPos, yPos);
}
void SpielStein::init(int xPos, int yPos, int Tp, float FS, bool Hs, bool wL, bool ab)
{
        x           =xPos;
        y           =yPos;
        Type        = Tp;
        FeuerStatus = FS;
        Haus        = Hs;
        willLoeschen= wL;
        Abgebrannt  = ab;
        SpielSteinFarbeSetzen();
}

/*void SpielStein::paintEvent(QPaintEvent *)
{
        SpielSteinFarbeSetzen();
}*/

void SpielStein::SpielSteinFarbeSetzen()
{
               //printf("ssfarbesetzen\n");
    if (Type==0 && Haus==false && Abgebrannt==false)
        {
        if (FeuerStatus < 5)
                SpielStein::setBackgroundColor(QColor(0, 250, 0));//grn
        else if (FeuerStatus <60)
                SpielStein::setBackgroundColor(QColor(250, 250, 0));//gelb
        else if (FeuerStatus <120)
                SpielStein::setBackgroundColor(QColor(250, 0, 0));//rot
        else if (FeuerStatus <180)
                SpielStein::setBackgroundColor(QColor(200, 100, 0));//braun
        else
                SpielStein::setBackgroundColor(QColor(150, 150, 150));//grau
        }
    else if (Type==0 && Haus==true)//Dorf
        {
                //printf("HausMalen\n");
                if (backgroundColor()!=QColor(100,100,100))
                        setBackgroundColor(QColor(100, 100, 100));//
                QPainter p;
                QRect r=QRect(2,2,width()-4,height()-4);
                p.begin (this);
                p.setPen(red);
                p.setBrush(red);
                p.drawRect(r);
                p.end();
        }
    else if (Type>0)//Feuerwehr
        {

                if (Abgebrannt==true)
                {
                        if (backgroundColor()!=QColor(0,0,0))
                            setBackgroundColor(QColor(0, 0,0));//schwarz
                }
                else if (willLoeschen==true)
                {
                //printf("willLoeschen true\n");
                        if (backgroundColor()!=QColor(0,250,250))
                            setBackgroundColor(QColor(0, 250,250));//hellblau
                }
                else
                {
                //printf("willLoeschen false\n");
                        if (backgroundColor()!=QColor(blue))
                           setBackgroundColor(QColor(blue));//dunkelblau
                }
                NummerSchreiben();
        }
    RahmenZeichnen();
}
void SpielStein::RahmenZeichnen()
{
    QPainter p;
    p.begin (this);
    p.setPen(QColor(200, 200, 200));
    p.drawLine(0,height()-1,width(),height()-1);
    p.drawLine(width()-1,0,width()-1,height());
    p.end();
}
void SpielStein::NummerSchreiben()
{
                if (selected==true)
                {
                        QPainter p;
                        p.begin (this);
                        QRect r=QRect(0,0,width()-1,height()-1);
                        p.setPen(red);
                        p.drawRect(r);
                        p.setPen(black);
                        if (willLoeschen==false||Abgebrannt==true) p.setPen(white);
                        p.setFont(QFont("Arial",9,QFont::Normal));
                        char fwNr[2];//Strg der Type aufnehmen soll
                        char *fwNr_p;//Pointer auf 1 Elem. von fwNr
                        fwNr[0]=Type+48;//ASCII von 0 ist 48
                        fwNr[1]=0;//StringEnde
                        fwNr_p=fwNr;//Pointer auf fwNr-Array setzen
                        p.drawText(2,height()-2,fwNr_p, 1);
                        p.end();
                }
                else
                {
                        //printf("ssFWmahlen else\n");
                        QPainter p;
                        p.begin (this);
                        p.setPen(black);
                        if (willLoeschen==false||Abgebrannt==true) p.setPen(white);
                        p.setFont(QFont("Arial",10,QFont::Normal));
                        char fwNr[2];//Strg der Type aufnehmen soll
                        char *fwNr_p;//Pointer auf 1 Elem. von fwNr
                        fwNr[0]=Type+48;//ASCII von 0 ist 48
                        fwNr[1]=0;//StringEnde
                        fwNr_p=fwNr;//Pointer auf fwNr-Array setzen
                        p.drawText(2,height()-1,fwNr_p, 1);
                        p.end();
                }

}

void SpielStein::setFeuerStatus(double fs)
{
        //printf("sssetFeuerstatus %1.1f\n", fs);
        FeuerStatus=fs;
        if (FeuerStatus>200) FeuerStatus=200;
        SpielStein::SpielSteinFarbeSetzen();
        //this->update();
        //repaint();
}
double SpielStein::getFeuerStatus()
{
        //printf("ssgetFeuerstatus\n");
        return FeuerStatus;
}
void SpielStein::setType(int Tp)
{
        //printf("sssetType\n");
        Type=Tp;
        SpielStein::SpielSteinFarbeSetzen();
        //repaint();
}
int SpielStein::getType()
{
        return Type;
}
void SpielStein::mousePressEvent(QMouseEvent *e)
{
        //printf("mousepress\n");
        if(e->button()==LeftButton)
        {
                //emit FWMenueBauen(Type, x, y);
                emit FWRichtungSetzen(Type, x, y);
        }
        else    emit FWKontrollClose();
}
void SpielStein::mouseDoubleClickEvent(QMouseEvent *)
{
/*        //printf("Doppelklick\n");
        if (willLoeschen==true)
                willLoeschen=false;
        else
                willLoeschen=true;
        emit WillLoeschenChanged(Type, willLoeschen, x, y);
*/}
void SpielStein::setSelected(bool s)
{
        //printf("ssSelected");
        selected=s;
        erase();
        SpielSteinFarbeSetzen();
}
void SpielStein::setHaus(bool h)
{
        //printf("ssSelected");
        Haus=h;
        SpielSteinFarbeSetzen();
        //repaint();
}
void SpielStein::setAbgebrannt(bool b)
{
        //printf("ssSelected");
        Abgebrannt=b;
        SpielSteinFarbeSetzen();
        //repaint();
}
bool SpielStein::getAbgebrannt()
{
        //printf("ssSelected");
        return Abgebrannt;
        //repaint();
}
bool SpielStein::getHaus()
{
        //printf("ssSelected");
        return Haus;
}
void SpielStein::setWillLoeschen(bool L)
{
                //printf("ss setWillLoeschen\n");
                willLoeschen=L;
                if (Type>0)
                {
                        erase();
                        SpielSteinFarbeSetzen();
                }
}
#include "spielstein.moc"