/***************************************************************************
                          puzzlewidget.h  -  description
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PUZZLEWIDGET_H
#define PUZZLEWIDGET_H

#include <qwidget.h>
#include <qpainter.h>
#include <qevent.h>
#include <kmsgbox.h>
/**
  *@author Arjan Buursink
  */

struct puzzletype
{
    QString title;
    QString author;
    QString copyright;
    QString file;
    bool changed;
    QString * solution;
    QString * solve;
    QString * reveal;
    QString * across;
    QString * down;
    int * across_question_number;
    int * down_question_number;
    int width,height,acrnumber,downumber;
};

class PuzzleWidget : public QWidget
{
    Q_OBJECT
private:
    unsigned int fn_x,fn_y,fn2_x,fn2_y;
    int x_old,y_old;
    int nextX();
    int prevX();
    int nextY();
    int prevY();
    int across_question_number_inv(int);
    int down_question_number_inv(int);
    bool mouse_pressed;
    char part(int, int);
    void leftClick(int, int);
    void leftClickRemove(int, int);
    void drawFrame(unsigned int, unsigned int, QColor,QColor);
    void flipDir();
    bool horizontal_dir;
    bool onPuzzle(int, int);
    bool onBlack(int, int);
    bool onWhite(int, int);
    bool beginWord(int, int);
    void typeLetter(char);
    void removeLetter();
    void makeBlack(int, int);
    void clickNextWord();
    unsigned int number[100][100];
    bool wordCorrect(int,int);

public:
    PuzzleWidget(QWidget * parent = 0, const char * name = 0);
    puzzletype puzzle;
    void computeNumbers();
    bool edit_mode;
    bool ShowWordCorr_bl,ShowLetterCorr_bl;
    unsigned int square_size;

public slots:
    void revealWord();

protected:
    void paintEvent(QPaintEvent *);
    void mousePressEvent(QMouseEvent *);
    void keyPressEvent(QKeyEvent *);
    void focusInEvent(QFocusEvent *);
    void focusOutEvent(QFocusEvent *);

signals:
    void solutionmenu_enable(int, bool);
    void questions_widget_select(int, bool, bool);
};

#endif
